﻿// auto-generated: do not edit

/**
* ConfigurationTransformation
*/
export type ConfigurationTransformation = {
  /**
  * OffsetX
  */
  OffsetX?: number,
  /**
  * OffsetY
  */
  OffsetY?: number,
  /**
  * OffsetZ
  */
  OffsetZ?: number,
  /**
  * AxisX
  */
  AxisX?: number,
  /**
  * AxisY
  */
  AxisY?: number,
  /**
  * AxisZ
  */
  AxisZ?: number,
  /**
  * Angle
  */
  Angle?: number,
  /**
  * ScaleX
  */
  ScaleX?: number,
  /**
  * ScaleY
  */
  ScaleY?: number,
  /**
  * ScaleZ
  */
  ScaleZ?: number,
};

/**
* ConfigurationConnection
*/
export type ConfigurationConnection = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * SourceInstanceId
  */
  SourceInstanceId?: string | null,
  /**
  * SourceConnectorId
  */
  SourceConnectorId?: string | null,
  /**
  * SourceTransformation
  */
  SourceTransformation?: ConfigurationTransformation | null,
  /**
  * TargetInstanceId
  */
  TargetInstanceId?: string | null,
  /**
  * TargetConnectorId
  */
  TargetConnectorId?: string | null,
  /**
  * TargetTransformation
  */
  TargetTransformation?: ConfigurationTransformation | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null>,
};

/**
* ConfigurationInstance
*/
export type ConfigurationInstance = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * PartId
  */
  PartId?: string | null,
  /**
  * LayersId
  */
  LayersId?: string | null,
  /**
  * TextsId
  */
  TextsId?: string | null,
  /**
  * Layers
  */
  Layers?: (string)[] | null,
  /**
  * Texts
  */
  Texts?: Record<string, string | null> | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationSubConnection
*/
export type ConfigurationSubConnection = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * SourceInstanceId
  */
  SourceInstanceId?: string | null,
  /**
  * SourceConnectorId
  */
  SourceConnectorId?: string | null,
  /**
  * SourceTransformation
  */
  SourceTransformation?: ConfigurationTransformation | null,
  /**
  * TargetAttributeId
  */
  TargetAttributeId?: string | null,
  /**
  * TargetObjectIndex
  */
  TargetObjectIndex?: number,
  /**
  * TargetInstanceId
  */
  TargetInstanceId?: string | null,
  /**
  * TargetConnectorId
  */
  TargetConnectorId?: string | null,
  /**
  * TargetTransformation
  */
  TargetTransformation?: ConfigurationTransformation | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null>,
};

/**
* ConfigurationBomPrice
*/
export type ConfigurationBomPrice = {
  /**
  * Id
  */
  Id?: string | null,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Price
  */
  Price?: number | null,
  /**
  * TotalPrice
  */
  TotalPrice?: number | null,
  /**
  * UnitId
  */
  UnitId?: string | null,
  /**
  * Type
  */
  Type?: string | null,
  /**
  * RecurringInterval
  */
  RecurringInterval?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationBomStatus
*/
export type ConfigurationBomStatus = {
  /**
  * Id
  */
  Id?: string | null,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationBomNote
*/
export type ConfigurationBomNote = {
  /**
  * Id
  */
  Id?: string | null,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * Severity
  */
  Severity?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationBomReference
*/
export type ConfigurationBomReference = {
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Path
  */
  Path?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationBom
*/
export type ConfigurationBom = {
  /**
  * Controls hierarchical saving the data of Items, which belong to current Configuration Object (makes only sense if it's a specific Configuration Substructure).
  *     true: A single Item gets inserted into list of Items of Parent Configuration Object as container for data of all Items of current Configuration Object. These Items get saved to property "Items", which is part of property "Bom".
  *     false: Items of current Configuration Object are saved by their insertion into list of Items of Parent Configuration Object.
  */
  IsHierarchical?: boolean,
  /**
  * Identifier of current Configuration Object
  */
  Id?: string | null,
  /**
  * Reference Identifier, which can be provided by an external system (e.g. PIM) during import of current Configuration Object via the Data Manager
  */
  ReferenceId?: string | null,
  /**
  * Name of current Configuration Object
  */
  Name?: string | null,
  /**
  * Description of current Configuration Object
  */
  Description?: string | null,
  /**
  * Relative Image Path (URL) of current Configuration Object
  */
  Image?: string | null,
  /**
  * Part Identifier of current Configuration Object
  */
  PartId?: string | null,
  /**
  * Part class name of current Configuration Object
  */
  PartClass?: string | null,
  /**
  * Quantity of current Configuration Object
  */
  Quantity?: number | null,
  /**
  * Unit Identifier of quantity of current Configuration Object
  */
  QuantityUnitId?: string | null,
  /**
  * PriceId
  */
  PriceId?: string | null,
  /**
  * Mass of a single unit (i.e. quantity 1) of current Configuration Object
  */
  BaseMass?: number | null,
  /**
  * Mass
  */
  Mass?: number | null,
  /**
  * Mass of a single unit of current Configuration Object multiplied by quantity
  */
  TotalMass?: number | null,
  /**
  * Unit Identifier of mass of current Configuration Object
  */
  MassUnitId?: string | null,
  /**
  * Id of the product.
  */
  ProductId?: string | null,
  /**
  * Items
  */
  Items?: (ConfigurationBomItem)[] | null,
  /**
  * BasePrices
  */
  BasePrices?: (ConfigurationBomPrice)[] | null,
  /**
  * Prices
  */
  Prices?: (ConfigurationBomPrice)[] | null,
  /**
  * Status
  */
  Status?: (ConfigurationBomStatus)[] | null,
  /**
  * Notes
  */
  Notes?: (ConfigurationBomNote)[] | null,
  /**
  * References
  */
  References?: (ConfigurationBomReference)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationBomItem
*/
export type ConfigurationBomItem = {
  /**
  * Identifier of Item. It gets taken over from its source, which can be
  *     - a selected Value of an Attribute: its Identifier
  *     - a dataset of Bill Of Materials table imported via the Data Manager: content of column "Id"
  *     - an Item created individually by script: content of property "Id"
  */
  Id?: string | null,
  /**
  * Reference Identifier, which can be provided by an external system (e.g. PIM) during import of Bill Of Materials table via the Data Manager
  */
  ReferenceId?: string | null,
  /**
  * Position
  */
  Position?: string | null,
  /**
  * Level
  */
  Level?: number,
  /**
  * Controls accumulation of Items wit the same PartId.
  *     true: Items with the same PartId are accumulated into a single Item.
  *     false: Items with the same PartId get displayed as separate Items.
  */
  IsUnique?: boolean,
  /**
  * IsHierarchical
  */
  IsHierarchical?: boolean,
  /**
  * Numeric value used to sort Items correctly in the Bill Of Material to display it as table.
  *     Sorting is done by rising number, i.e. the smallest number comes first
  */
  Rank?: number,
  /**
  * Part Identifier of Item. It gets taken over from its source, which can be
  *     - a selected Value of an Attribute: content of property "PartId"
  *     - a dataset of Bill Of Materials table imported via the Data Manager: content of column "PartId"
  *     - an Item created individually by script: content of property "PartId"
  */
  PartId?: string | null,
  /**
  * Type code fragment assigned to Item. It gets taken over from its source, which can be
  *     - a selected Value of an Attribute: code fragment assigned to it
  *     - a dataset of Bill Of Materials table imported via the Data Manager: content of column "TypeCode"
  *     - an Item created individually by script: content of property "TypeCode"
  */
  TypeCode?: string | null,
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Name of Item. It gets taken over from its source, which can be
  *     - a selected Value of an Attribute: its Name if data type of Attribute is "String", otherwise its Identifier
  *     - a dataset of Bill Of Materials table imported via the Data Manager: content of column "Name"
  *     - an Item created individually by script: content of property "Name"
  */
  Name?: string | null,
  /**
  * Name of Item. It gets taken over from its source, which can be
  *     - a selected Value of an Attribute: its Description if data type of Attribute is "String", otherwise its Identifier
  *     - a dataset of Bill Of Materials table imported via the Data Manager: content of column "Description"
  *     - an Item created individually by script: content of property "Description"
  */
  Description?: string | null,
  /**
  * Manufacturer
  */
  Manufacturer?: string | null,
  /**
  * Relative Image Path (URL) of Item. It gets taken over from its source, which can be
  *     - a selected Value of an Attribute: image file assigned to it via the Data Manager
  *     - a dataset of Bill Of Materials table imported via the Data Manager: content of column "Image"
  *     - an Item created individually by script: content of property "Image"
  */
  Image?: string | null,
  /**
  * Quantity of Item. It gets taken over from its source, which can be
  *     - a selected Value of an Attribute: content of property "Quantity"
  *     - a dataset of Bill Of Materials table imported via the Data Manager: content of column "Quantity"
  *     - an Item created individually by script: content of property "Quantity"
  */
  Quantity?: number | null,
  /**
  * Unit identifier of quantity of Item. It gets taken over from its source, which can be
  *     - a selected Value of an Attribute: content of property "QuantityUnitId"
  *     - a dataset of Bill Of Materials table imported via the Data Manager: content of column "QuantityUnitId"
  *     - an Item created individually by script: content of property "QuantityUnitId"
  */
  QuantityUnitId?: string | null,
  /**
  * Mass of a single unit (i.e. quantity 1) of Item. It gets taken over from its source, which can be
  *     - a selected Value of an Attribute: content of property "Mass"
  *     - a dataset of Bill Of Materials table imported via the Data Manager: content of column "Mass"
  *     - an Item created individually by script: content of property "BaseMass"
  */
  BaseMass?: number | null,
  /**
  * Mass
  */
  Mass?: number | null,
  /**
  * TotalMass
  */
  TotalMass?: number | null,
  /**
  * MassUnitId
  */
  MassUnitId?: string | null,
  /**
  * AttributeId
  */
  AttributeId?: string | null,
  /**
  * ParentId
  */
  ParentId?: string | null,
  /**
  * PriceId
  */
  PriceId?: string | null,
  /**
  * Bom
  */
  Bom?: ConfigurationBom | null,
  /**
  * BasePrices
  */
  BasePrices?: (ConfigurationBomPrice)[] | null,
  /**
  * Prices
  */
  Prices?: (ConfigurationBomPrice)[] | null,
  /**
  * Status
  */
  Status?: (ConfigurationBomStatus)[] | null,
  /**
  * Notes
  */
  Notes?: (ConfigurationBomNote)[] | null,
  /**
  * References
  */
  References?: (ConfigurationBomReference)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationLayer
*/
export type ConfigurationLayer = {
  /**
  * LayersId
  */
  LayersId?: string,
  /**
  * Layer
  */
  Layer?: string,
};

/**
* ConfigurationText
*/
export type ConfigurationText = {
  /**
  * TextsId
  */
  TextsId?: string,
  /**
  * Key
  */
  Key?: string,
  /**
  * Value
  */
  Value?: string | null,
};

/**
* ConfigurationMessageAction
*/
export type ConfigurationMessageAction = {
  /**
  * Id
  */
  Id?: string | null,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * UserDefinedFunctionName
  */
  UserDefinedFunctionName?: string | null,
  /**
  * UserDefinedFunctionInput
  */
  UserDefinedFunctionInput?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationMessageReference
*/
export type ConfigurationMessageReference = {
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Path
  */
  Path?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationMessage
*/
export type ConfigurationMessage = {
  /**
  * Id
  */
  Id?: string | null,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Severity
  */
  Severity?: string | null,
  /**
  * AutoCloseMilliseconds
  */
  AutoCloseMilliseconds?: number | null,
  /**
  * IsPersistent
  */
  IsPersistent?: boolean,
  /**
  * Actions
  */
  Actions?: (ConfigurationMessageAction)[] | null,
  /**
  * References
  */
  References?: (ConfigurationMessageReference)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationTableColumn
*/
export type ConfigurationTableColumn = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ImageColumnId
  */
  ImageColumnId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * AttributeId
  */
  AttributeId?: string | null,
  /**
  * DataType
  */
  DataType?: string,
  /**
  * HorizontalAlign
  */
  HorizontalAlign?: string | null,
  /**
  * VerticalAlign
  */
  VerticalAlign?: string | null,
  /**
  * IsSortable
  */
  IsSortable?: boolean,
  /**
  * IsFilterable
  */
  IsFilterable?: boolean,
  /**
  * IsVisible
  */
  IsVisible?: boolean,
  /**
  * IsLanguageDependent
  */
  IsLanguageDependent?: boolean,
  /**
  * IsRowId
  */
  IsRowId?: boolean,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationTableOrder
*/
export type ConfigurationTableOrder = {
  /**
  * ColumnId
  */
  ColumnId?: string,
  /**
  * Ascending
  */
  Ascending?: boolean,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationTableFilter
*/
export type ConfigurationTableFilter = {
  /**
  * ColumnId
  */
  ColumnId?: string,
  /**
  * Operator
  */
  Operator?: string,
  /**
  * Variant
  */
  Variant?: string | null,
  /**
  * Values
  */
  Values?: (boolean | number | string | null)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationTableInternalFilter
*/
export type ConfigurationTableInternalFilter = {
  /**
  * LeftValue
  */
  LeftValue?: string | null,
  /**
  * Operator
  */
  Operator?: string,
  /**
  * RightValues
  */
  RightValues?: (boolean | number | string | null)[] | null,
  /**
  * SubFilters
  */
  SubFilters?: (ConfigurationTableInternalFilter | null)[] | null,
};

/**
* ConfigurationTableOptions
*/
export type ConfigurationTableOptions = {
  /**
  * Id
  */
  Id?: string | null,
  /**
  * AttributeId
  */
  AttributeId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Columns
  */
  Columns?: (ConfigurationTableColumn)[],
  /**
  * Orderings
  */
  Orderings?: (ConfigurationTableOrder)[] | null,
  /**
  * Filters
  */
  Filters?: (ConfigurationTableFilter)[] | null,
  /**
  * InternalFilters
  */
  InternalFilters?: (ConfigurationTableInternalFilter)[] | null,
  /**
  * BaseSql
  */
  BaseSql?: string | null,
  /**
  * BaseParameters
  */
  BaseParameters?: (boolean | number | string | null)[] | null,
  /**
  * RowOffset
  */
  RowOffset?: number | null,
  /**
  * RowCount
  */
  RowCount?: number | null,
  /**
  * AllowSelect
  */
  AllowSelect?: boolean,
  /**
  * AllowMultiSelect
  */
  AllowMultiSelect?: boolean,
  /**
  * SelectedRowsOnly
  */
  SelectedRowsOnly?: boolean,
};

/**
* DatabaseStatement
*/
export type DatabaseStatement = {
  /**
  * Sql
  */
  Sql?: string | null,
  /**
  * Parameters
  */
  Parameters?: (boolean | number | string | null)[] | null,
};

/**
* ConfigurationTableAttributeOptions
*/
export type ConfigurationTableAttributeOptions = {
  /**
  * AttributePath
  */
  AttributePath?: string | null,
  /**
  * ColumnId
  */
  ColumnId?: string | null,
  /**
  * Operator
  */
  Operator?: string | null,
  /**
  * IsRestrictingSelf
  */
  IsRestrictingSelf?: boolean | null,
  /**
  * IsRestrictingOther
  */
  IsRestrictingOther?: boolean | null,
  /**
  * IsRestrictionInverse
  */
  IsRestrictionInverse?: boolean | null,
  /**
  * RestrictionType
  */
  RestrictionType?: string | null,
  /**
  * IsRestrictingAllowedValues
  */
  IsRestrictingAllowedValues?: boolean | null,
  /**
  * Separator
  */
  Separator?: string | null,
  /**
  * Values
  */
  Values?: (boolean | number | string | null)[] | null,
  /**
  * Wildcards
  */
  Wildcards?: (boolean | number | string | null)[] | null,
  /**
  * InternalFilters
  */
  InternalFilters?: (ConfigurationTableInternalFilter)[] | null,
};

/**
* ConfigurationVariantTableOptions
*/
export type ConfigurationVariantTableOptions = {
  /**
  * Attributes
  */
  Attributes?: (ConfigurationTableAttributeOptions)[],
  /**
  * InternalFilters
  */
  InternalFilters?: (ConfigurationTableInternalFilter)[] | null,
  /**
  * BaseSql
  */
  BaseSql?: string | null,
  /**
  * BaseParameters
  */
  BaseParameters?: (boolean | number | string | null)[] | null,
};

/**
* DatabaseResult
*/
export type DatabaseResult = {
  /**
  * Success
  */
  Success?: boolean,
  /**
  * Message
  */
  Message?: string | null,
  /**
  * Columns
  */
  Columns?: (string)[] | null,
  /**
  * Rows
  */
  Rows?: (Record<string, boolean | number | string | null>)[] | null,
};

/**
* ConfigurationTableCell
*/
export type ConfigurationTableCell = {
  /**
  * Value
  */
  Value?: boolean | number | string | null,
  /**
  * RawValue
  */
  RawValue?: boolean | number | string | null,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationTableRow
*/
export type ConfigurationTableRow = {
  /**
  * Id
  */
  Id?: string,
  /**
  * IsSelectable
  */
  IsSelectable?: boolean,
  /**
  * Cells
  */
  Cells?: (ConfigurationTableCell)[],
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationTable
*/
export type ConfigurationTable = {
  /**
  * Id
  */
  Id?: string,
  /**
  * AttributeId
  */
  AttributeId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * RowOffset
  */
  RowOffset?: number | null,
  /**
  * RowCount
  */
  RowCount?: number | null,
  /**
  * TotalRowCount
  */
  TotalRowCount?: number | null,
  /**
  * AllowSelect
  */
  AllowSelect?: boolean,
  /**
  * AllowMultiSelect
  */
  AllowMultiSelect?: boolean,
  /**
  * Columns
  */
  Columns?: (ConfigurationTableColumn)[],
  /**
  * Rows
  */
  Rows?: (ConfigurationTableRow)[],
  /**
  * Orderings
  */
  Orderings?: (ConfigurationTableOrder)[] | null,
  /**
  * Filters
  */
  Filters?: (ConfigurationTableFilter)[] | null,
  /**
  * Selections
  */
  Selections?: (string)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* DatabaseColumn
*/
export type DatabaseColumn = {
  /**
  * Name
  */
  Name?: string | null,
  /**
  * DataType
  */
  DataType?: string | null,
};

/**
* ConfigurationAssemblyTransformation
*/
export type ConfigurationAssemblyTransformation = {
  /**
  * OffsetX
  */
  OffsetX?: number,
  /**
  * OffsetY
  */
  OffsetY?: number,
  /**
  * OffsetZ
  */
  OffsetZ?: number,
  /**
  * AxisX
  */
  AxisX?: number,
  /**
  * AxisY
  */
  AxisY?: number,
  /**
  * AxisZ
  */
  AxisZ?: number,
  /**
  * Angle
  */
  Angle?: number,
  /**
  * ScaleX
  */
  ScaleX?: number,
  /**
  * ScaleY
  */
  ScaleY?: number,
  /**
  * ScaleZ
  */
  ScaleZ?: number,
};

/**
* ConfigurationAssemblyConnector
*/
export type ConfigurationAssemblyConnector = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Transformation
  */
  Transformation?: ConfigurationAssemblyTransformation | null,
  /**
  * Groups
  */
  Groups?: (string)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationAssemblyConnection
*/
export type ConfigurationAssemblyConnection = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * SourceConnector
  */
  SourceConnector?: ConfigurationAssemblyConnector,
  /**
  * TargetConnector
  */
  TargetConnector?: ConfigurationAssemblyConnector,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationSubAssembly
*/
export type ConfigurationSubAssembly = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Group
  */
  Group?: string | null,
  /**
  * File
  */
  File?: string | null,
  /**
  * Connection
  */
  Connection?: ConfigurationAssemblyConnection | null,
  /**
  * Children
  */
  Children?: (ConfigurationSubAssembly)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationAssembly
*/
export type ConfigurationAssembly = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Assembly
  */
  Assembly?: ConfigurationSubAssembly | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationChange
*/
export type ConfigurationChange = {
  /**
  * ObjectPath
  */
  ObjectPath?: string,
  /**
  * AttributeId
  */
  AttributeId?: string,
  /**
  * Value
  */
  Value?: boolean | number | string | null,
  /**
  * UnitId
  */
  UnitId?: string | null,
  /**
  * Quantity
  */
  Quantity?: number | null,
  /**
  * QuantityUnitId
  */
  QuantityUnitId?: string | null,
  /**
  * IsSelected
  */
  IsSelected?: boolean | null,
  /**
  * OldIndex
  */
  OldIndex?: number | null,
  /**
  * NewIndex
  */
  NewIndex?: number | null,
};

/**
* ConfigurationTypeCodeCharRange
*/
export type ConfigurationTypeCodeCharRange = {
  /**
  * Start
  */
  Start?: number | null,
  /**
  * End
  */
  End?: number | null,
};

/**
* ConfigurationTypeCodeTemplateElement
*/
export type ConfigurationTypeCodeTemplateElement = {
  /**
  * Prefix
  */
  Prefix?: string | null,
  /**
  * Suffix
  */
  Suffix?: string | null,
  /**
  * AttributePath
  */
  AttributePath?: string | null,
  /**
  * Rank
  */
  Rank?: number | null,
  /**
  * MinLength
  */
  MinLength?: number | null,
  /**
  * MaxLength
  */
  MaxLength?: number | null,
  /**
  * DecimalPrecision
  */
  DecimalPrecision?: number | null,
  /**
  * DecimalSeparator
  */
  DecimalSeparator?: number | null,
  /**
  * PaddingPosition
  */
  PaddingPosition?: number | null,
  /**
  * PaddingChar
  */
  PaddingChar?: number | null,
  /**
  * ExcludeCharRanges
  */
  ExcludeCharRanges?: (ConfigurationTypeCodeCharRange)[] | null,
  /**
  * IncludeCharRanges
  */
  IncludeCharRanges?: (ConfigurationTypeCodeCharRange)[] | null,
};

/**
* ConfigurationTypeCodeTemplate
*/
export type ConfigurationTypeCodeTemplate = {
  /**
  * Elements
  */
  Elements?: (ConfigurationTypeCodeTemplateElement)[] | null,
};

/**
* ConfigurationTypeCodeElement
*/
export type ConfigurationTypeCodeElement = {
  /**
  * Value
  */
  Value?: string | null,
  /**
  * ValueType
  */
  ValueType?: string | null,
  /**
  * AttributeId
  */
  AttributeId?: string | null,
  /**
  * ObjectPath
  */
  ObjectPath?: string | null,
};

/**
* ConfigurationTypeCode
*/
export type ConfigurationTypeCode = {
  /**
  * Elements
  */
  Elements?: (ConfigurationTypeCodeElement)[] | null,
};

/**
* ConfigurationProperty
*/
export type ConfigurationProperty = {
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * DataType
  */
  DataType?: number,
  /**
  * Value
  */
  Value?: boolean | number | string | null,
  /**
  * IsLanguageDependent
  */
  IsLanguageDependent?: boolean,
};

/**
* ConfigurationAttachment
*/
export type ConfigurationAttachment = {
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Path
  */
  Path?: string | null,
  /**
  * Tags
  */
  Tags?: (string)[] | null,
  /**
  * Locales
  */
  Locales?: (string)[] | null,
};

/**
* ConfigurationValue
*/
export type ConfigurationValue = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Value
  */
  Value?: boolean | number | string | null,
  /**
  * Index
  */
  Index?: number,
  /**
  * DefaultValue
  */
  DefaultValue?: boolean | number | string | null,
  /**
  * IsLanguageDependent
  */
  IsLanguageDependent?: boolean,
  /**
  * IsSelected
  */
  IsSelected?: boolean,
  /**
  * IsUserSelected
  */
  IsUserSelected?: boolean,
  /**
  * IsActive
  */
  IsActive?: boolean,
  /**
  * IsAllowed
  */
  IsAllowed?: boolean,
  /**
  * IsEditable
  */
  IsEditable?: boolean,
  /**
  * RecommendationScore
  */
  RecommendationScore?: number,
  /**
  * TypeCodeFragment
  */
  TypeCodeFragment?: string | null,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * PartId
  */
  PartId?: string | null,
  /**
  * PartClass
  */
  PartClass?: string | null,
  /**
  * Mass
  */
  Mass?: number | null,
  /**
  * MassUnitId
  */
  MassUnitId?: string | null,
  /**
  * PriceId
  */
  PriceId?: string | null,
  /**
  * Quantity
  */
  Quantity?: number | null,
  /**
  * QuantityUnitId
  */
  QuantityUnitId?: string | null,
  /**
  * UnitId
  */
  UnitId?: string | null,
  /**
  * UnitGroupId
  */
  UnitGroupId?: string | null,
  /**
  * FormatString
  */
  FormatString?: string | null,
  /**
  * Prices
  */
  Prices?: Record<string, ConfigurationBomPrice> | null,
  /**
  * Properties
  */
  Properties?: Record<string, ConfigurationProperty> | null,
  /**
  * Attachments
  */
  Attachments?: Record<string, ConfigurationAttachment> | null,
};

/**
* ConfigurationAttribute
*/
export type ConfigurationAttribute = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Index
  */
  Index?: number,
  /**
  * DataType
  */
  DataType?: number,
  /**
  * IsReadOnly
  */
  IsReadOnly?: boolean,
  /**
  * IsEditable
  */
  IsEditable?: boolean,
  /**
  * IsLanguageDependent
  */
  IsLanguageDependent?: boolean,
  /**
  * IsMultiValued
  */
  IsMultiValued?: boolean,
  /**
  * IsRequired
  */
  IsRequired?: boolean,
  /**
  * IsAutoSelected
  */
  IsAutoSelected?: boolean,
  /**
  * IsActive
  */
  IsActive?: boolean,
  /**
  * IsAllowed
  */
  IsAllowed?: boolean,
  /**
  * IsVisible
  */
  IsVisible?: boolean,
  /**
  * IsUserSelected
  */
  IsUserSelected?: boolean,
  /**
  * IsConfiguration
  */
  IsConfiguration?: boolean,
  /**
  * IsComplete
  */
  IsComplete?: boolean,
  /**
  * ConfigurationObjectId
  */
  ConfigurationObjectId?: string,
  /**
  * RecommendationScore
  */
  RecommendationScore?: number,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * ValueMaxLength
  */
  ValueMaxLength?: number | null,
  /**
  * ValueMin
  */
  ValueMin?: number | null,
  /**
  * ValueMax
  */
  ValueMax?: number | null,
  /**
  * ValueStepWidth
  */
  ValueStepWidth?: number | null,
  /**
  * ValueMinExclusive
  */
  ValueMinExclusive?: boolean,
  /**
  * ValueMaxExclusive
  */
  ValueMaxExclusive?: boolean,
  /**
  * CardinalityMin
  */
  CardinalityMin?: number,
  /**
  * CardinalityMax
  */
  CardinalityMax?: number,
  /**
  * CardinalityDefault
  */
  CardinalityDefault?: number,
  /**
  * FormatString
  */
  FormatString?: string | null,
  /**
  * UnitId
  */
  UnitId?: string | null,
  /**
  * UnitGroupId
  */
  UnitGroupId?: string | null,
  /**
  * TableId
  */
  TableId?: string | null,
  /**
  * TableChangeToken
  */
  TableChangeToken?: string | null,
  /**
  * SelectedValues
  */
  SelectedValues?: (number)[],
  /**
  * Groups
  */
  Groups?: (string)[],
  /**
  * Properties
  */
  Properties?: Record<string, ConfigurationProperty> | null,
  /**
  * Attachments
  */
  Attachments?: Record<string, ConfigurationAttachment> | null,
  /**
  * Values
  */
  Values?: (ConfigurationValue)[],
  /**
  * Configurations
  */
  Configurations?: (ConfigurationObject)[],
};

/**
* ConfigurationVariable
*/
export type ConfigurationVariable = {
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * DataType
  */
  DataType?: number,
  /**
  * Value
  */
  Value?: boolean | number | string | null,
  /**
  * IsLanguageDependent
  */
  IsLanguageDependent?: boolean,
  /**
  * IsPrivate
  */
  IsPrivate?: boolean,
};

/**
* ConfigurationObject
*/
export type ConfigurationObject = {
  /**
  * Guid
  */
  Guid?: string,
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Version
  */
  Version?: string,
  /**
  * TypeCodeTemplate
  */
  TypeCodeTemplate?: ConfigurationTypeCodeTemplate | null,
  /**
  * TypeCode
  */
  TypeCode?: ConfigurationTypeCode | null,
  /**
  * IsIndependent
  */
  IsIndependent?: boolean,
  /**
  * IsValid
  */
  IsValid?: boolean,
  /**
  * IsComplete
  */
  IsComplete?: boolean,
  /**
  * IsFirstRun
  */
  IsFirstRun?: boolean,
  /**
  * RecommendationScore
  */
  RecommendationScore?: number,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * Quantity
  */
  Quantity?: number | null,
  /**
  * QuantityUnitId
  */
  QuantityUnitId?: string | null,
  /**
  * PriceId
  */
  PriceId?: string | null,
  /**
  * PartId
  */
  PartId?: string | null,
  /**
  * PartClass
  */
  PartClass?: string | null,
  /**
  * Mass
  */
  Mass?: number | null,
  /**
  * MassUnitId
  */
  MassUnitId?: string | null,
  /**
  * Bom
  */
  Bom?: ConfigurationBom,
  /**
  * Prices
  */
  Prices?: Record<string, ConfigurationBomPrice> | null,
  /**
  * Properties
  */
  Properties?: Record<string, ConfigurationProperty> | null,
  /**
  * Attachments
  */
  Attachments?: Record<string, ConfigurationAttachment> | null,
  /**
  * Attributes
  */
  Attributes?: (ConfigurationAttribute)[],
  /**
  * AssemblyInstances
  */
  AssemblyInstances?: (ConfigurationInstance)[],
  /**
  * AssemblyConnections
  */
  AssemblyConnections?: (ConfigurationConnection)[],
  /**
  * AssemblySubConnections
  */
  AssemblySubConnections?: (ConfigurationSubConnection)[],
  /**
  * DrawingInstances
  */
  DrawingInstances?: (ConfigurationInstance)[],
  /**
  * DrawingConnections
  */
  DrawingConnections?: (ConfigurationConnection)[],
  /**
  * DrawingTexts
  */
  DrawingTexts?: (ConfigurationText)[],
  /**
  * DrawingLayers
  */
  DrawingLayers?: (ConfigurationLayer)[],
  /**
  * DrawingSubConnections
  */
  DrawingSubConnections?: (ConfigurationSubConnection)[],
  /**
  * Messages
  */
  Messages?: (ConfigurationMessage)[],
  /**
  * MessageActions
  */
  MessageActions?: Record<string, boolean>,
  /**
  * Variables
  */
  Variables?: Record<string, ConfigurationVariable>,
  /**
  * Inputs
  */
  Inputs?: Record<string, ConfigurationVariable>,
  /**
  * Outputs
  */
  Outputs?: Record<string, ConfigurationVariable>,
  /**
  * PreviousInputs
  */
  PreviousInputs?: Record<string, ConfigurationVariable>,
  /**
  * PreviousOutputs
  */
  PreviousOutputs?: Record<string, ConfigurationVariable>,
  /**
  * SummaryExcludes
  */
  SummaryExcludes?: Record<string, boolean>,
};

/**
* ConfigurationProductConfigurationValue
*/
export type ConfigurationProductConfigurationValue = {
  /**
  * Id
  */
  Id?: string,
  /**
  * Value
  */
  Value?: boolean | number | string | null,
};

/**
* ConfigurationProductConfigurationAttribute
*/
export type ConfigurationProductConfigurationAttribute = {
  /**
  * Id
  */
  Id?: string,
  /**
  * Values
  */
  Values?: (ConfigurationProductConfigurationValue)[] | null,
  /**
  * Configurations
  */
  Configurations?: (ConfigurationProductConfiguration)[] | null,
};

/**
* ConfigurationProductConfiguration
*/
export type ConfigurationProductConfiguration = {
  /**
  * Attributes
  */
  Attributes?: (ConfigurationProductConfigurationAttribute)[] | null,
};

/**
* ConfigurationProductAttributeValue
*/
export type ConfigurationProductAttributeValue = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Value
  */
  Value?: boolean | number | string | null,
};

/**
* ConfigurationProductAttribute
*/
export type ConfigurationProductAttribute = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * IsLanguageDependent
  */
  IsLanguageDependent?: boolean,
  /**
  * IsMultiValued
  */
  IsMultiValued?: boolean,
  /**
  * IsReadOnly
  */
  IsReadOnly?: boolean,
  /**
  * IsEditable
  */
  IsEditable?: boolean,
  /**
  * DataType
  */
  DataType?: number,
  /**
  * UnitId
  */
  UnitId?: string | null,
  /**
  * ConfigurationObjectId
  */
  ConfigurationObjectId?: string | null,
  /**
  * Values
  */
  Values?: (ConfigurationProductAttributeValue)[] | null,
};

/**
* ConfigurationProductProperty
*/
export type ConfigurationProductProperty = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Value
  */
  Value?: boolean | number | string | null,
  /**
  * IsLanguageDependent
  */
  IsLanguageDependent?: boolean,
  /**
  * DataType
  */
  DataType?: number,
};

/**
* ConfigurationProduct
*/
export type ConfigurationProduct = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * TypeCode
  */
  TypeCode?: string | null,
  /**
  * PartId
  */
  PartId?: string | null,
  /**
  * Path
  */
  Path?: string | null,
  /**
  * ValidFrom
  */
  ValidFrom?: string | null,
  /**
  * ValidTo
  */
  ValidTo?: string | null,
  /**
  * Type
  */
  Type?: string | null,
  /**
  * State
  */
  State?: string | null,
  /**
  * ConfigurationObjectKnowledgeBaseId
  */
  ConfigurationObjectKnowledgeBaseId?: string | null,
  /**
  * ConfigurationObjectWorkspaceId
  */
  ConfigurationObjectWorkspaceId?: string | null,
  /**
  * ConfigurationObjectId
  */
  ConfigurationObjectId?: string | null,
  /**
  * Customer
  */
  Customer?: string | null,
  /**
  * Region
  */
  Region?: string | null,
  /**
  * ImagePath
  */
  ImagePath?: string | null,
  /**
  * IsActive
  */
  IsActive?: boolean,
  /**
  * PreConfiguration
  */
  PreConfiguration?: ConfigurationProductConfiguration | null,
  /**
  * Attributes
  */
  Attributes?: (ConfigurationProductAttribute)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, ConfigurationProductProperty | null> | null,
};

/**
* ConfigurationSaveDifference
*/
export type ConfigurationSaveDifference = {
  /**
  * Type
  */
  Type?: number,
  /**
  * ObjectPath
  */
  ObjectPath?: string,
  /**
  * AttributeId
  */
  AttributeId?: string | null,
  /**
  * OldIsComplete
  */
  OldIsComplete?: boolean | null,
  /**
  * CurrentIsComplete
  */
  CurrentIsComplete?: boolean | null,
  /**
  * OldValue
  */
  OldValue?: string | null,
  /**
  * CurrentValue
  */
  CurrentValue?: string | null,
  /**
  * OldUnitId
  */
  OldUnitId?: string | null,
  /**
  * CurrentUnitId
  */
  CurrentUnitId?: string | null,
  /**
  * OldQuantity
  */
  OldQuantity?: number | null,
  /**
  * CurrentQuantity
  */
  CurrentQuantity?: number | null,
  /**
  * OldQuantityUnitId
  */
  OldQuantityUnitId?: string | null,
  /**
  * CurrentQuantityUnitId
  */
  CurrentQuantityUnitId?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* The result of a configuration restore/load operation.
*/
export type ConfigurationRestoreResult = {
  /**
  * IsSuccess
  */
  IsSuccess?: boolean,
  /**
  * ConfigurationDifferences
  */
  ConfigurationDifferences?: (ConfigurationSaveDifference)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* Save of a configuration value.
*/
export type ConfigurationSaveValue = {
  /**
  * The ID of the configuration value.
  */
  Id?: string | null,
  /**
  * The reference ID of the configuration value.
  */
  ReferenceId?: string | null,
  /**
  * The name of the configuration value.
  */
  Name?: string | null,
  /**
  * The value of the configuration value.
  */
  Value?: boolean | number | string | null,
  /**
  * The part ID of the configuration value.
  */
  PartId?: string | null,
  /**
  * The part class of the configuration value.
  */
  PartClass?: string | null,
  /**
  * The unit ID of the configuration value.
  */
  UnitId?: string | null,
  /**
  * The mass of the configuration value.
  */
  Mass?: number | null,
  /**
  * The unit ID of the mass of the configuration value.
  */
  MassUnitId?: string | null,
  /**
  * The quantity of the configuration value.
  */
  Quantity?: number | null,
  /**
  * The unit ID of the quantity of the configuration value.
  */
  QuantityUnitId?: string | null,
  /**
  * The price ID of the configuration value.
  */
  PriceId?: string | null,
  /**
  * The prices of the configuration value.
  */
  Prices?: (ConfigurationBomPrice)[] | null,
  /**
  * User defined additional properties.
  *     This can be set using configuration scripts.
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* Save of a configuration attribute with all selected values.
*/
export type ConfigurationSaveAttribute = {
  /**
  * The ID of the attribute.
  */
  Id?: string,
  /**
  * The reference ID of the attribute.
  */
  ReferenceId?: string | null,
  /**
  * The name of the attribute.
  */
  Name?: string | null,
  /**
  * A flag indicating if the user has selected the attribute.
  */
  IsUserSelected?: boolean,
  /**
  * The values of the attribute (if any).
  */
  Values?: (ConfigurationSaveValue)[] | null,
  /**
  * The sub-configurations of the attribute (if any).
  */
  Configurations?: (ConfigurationSaveObject)[] | null,
  /**
  * User defined additional properties.
  *     This can be set using configuration scripts.
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* Save of a configuration object and all sub-configurations.
*/
export type ConfigurationSaveObject = {
  /**
  * The ID of the configuration object.
  */
  Id?: string,
  /**
  * The reference ID of the configuration object.
  */
  ReferenceId?: string | null,
  /**
  * The part ID of the configuration object.
  */
  PartId?: string | null,
  /**
  * The part class of the configuration object.
  */
  PartClass?: string | null,
  /**
  * The name of the configuration object.
  */
  Name?: string | null,
  /**
  * The type code of the configuration object.
  */
  TypeCode?: string | null,
  /**
  * The price ID of the configuration object.
  */
  PriceId?: string | null,
  /**
  * The quantity of the configuration object.
  */
  Quantity?: number | null,
  /**
  * The unit ID of the quantity of the configuration object.
  */
  QuantityUnitId?: string | null,
  /**
  * The mass of the configuration object.
  */
  Mass?: number | null,
  /**
  * The unit ID of the mass of the configuration object.
  */
  MassUnitId?: string | null,
  /**
  * A flag indicating if the configuration object is complete.
  */
  IsComplete?: boolean,
  /**
  * The prices of the configuration object.
  */
  Prices?: (ConfigurationBomPrice)[] | null,
  /**
  * The attributes of the configuration object.
  */
  Attributes?: (ConfigurationSaveAttribute)[],
  /**
  * User defined additional properties.
  *     This can be set using configuration scripts.
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationSummaryReference
*/
export type ConfigurationSummaryReference = {
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Path
  */
  Path?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationSummaryAttachment
*/
export type ConfigurationSummaryAttachment = {
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Path
  */
  Path?: string | null,
  /**
  * Tags
  */
  Tags?: (string)[] | null,
  /**
  * Locales
  */
  Locales?: (string)[] | null,
};

/**
* ConfigurationSummaryValue
*/
export type ConfigurationSummaryValue = {
  /**
  * Id
  */
  Id?: string | null,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Value
  */
  Value?: boolean | number | string | null,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * PartId
  */
  PartId?: string | null,
  /**
  * PartClass
  */
  PartClass?: string | null,
  /**
  * TypeCodeFragment
  */
  TypeCodeFragment?: string | null,
  /**
  * UnitId
  */
  UnitId?: string | null,
  /**
  * Mass
  */
  Mass?: number | null,
  /**
  * MassUnitId
  */
  MassUnitId?: string | null,
  /**
  * Quantity
  */
  Quantity?: number | null,
  /**
  * QuantityUnitId
  */
  QuantityUnitId?: string | null,
  /**
  * PriceId
  */
  PriceId?: string | null,
  /**
  * Reference
  */
  Reference?: ConfigurationSummaryReference,
  /**
  * Prices
  */
  Prices?: (ConfigurationBomPrice)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
  /**
  * Attachments
  */
  Attachments?: Record<string, ConfigurationSummaryAttachment> | null,
};

/**
* ConfigurationSummaryAttribute
*/
export type ConfigurationSummaryAttribute = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * TableId
  */
  TableId?: string | null,
  /**
  * IsUserSelected
  */
  IsUserSelected?: boolean,
  /**
  * Reference
  */
  Reference?: ConfigurationSummaryReference,
  /**
  * Values
  */
  Values?: (ConfigurationSummaryValue)[] | null,
  /**
  * Configurations
  */
  Configurations?: (ConfigurationSummaryObject)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
  /**
  * Attachments
  */
  Attachments?: Record<string, ConfigurationSummaryAttachment> | null,
};

/**
* ConfigurationSummaryObject
*/
export type ConfigurationSummaryObject = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Version
  */
  Version?: string,
  /**
  * TypeCode
  */
  TypeCode?: string | null,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * PartId
  */
  PartId?: string | null,
  /**
  * PartClass
  */
  PartClass?: string | null,
  /**
  * PriceId
  */
  PriceId?: string | null,
  /**
  * Quantity
  */
  Quantity?: number | null,
  /**
  * QuantityUnitId
  */
  QuantityUnitId?: string | null,
  /**
  * Mass
  */
  Mass?: number | null,
  /**
  * MassUnitId
  */
  MassUnitId?: string | null,
  /**
  * IsComplete
  */
  IsComplete?: boolean,
  /**
  * Reference
  */
  Reference?: ConfigurationSummaryReference,
  /**
  * Attributes
  */
  Attributes?: (ConfigurationSummaryAttribute)[],
  /**
  * Prices
  */
  Prices?: (ConfigurationBomPrice)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
  /**
  * Attachments
  */
  Attachments?: Record<string, ConfigurationSummaryAttachment> | null,
};

/**
* ConfigurationSummary
*/
export type ConfigurationSummary = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Image
  */
  Image?: string | null,
  /**
  * ProductId
  */
  ProductId?: string | null,
  /**
  * RootObject
  */
  RootObject?: ConfigurationSummaryObject,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* Save of a product configuration.
*/
export type ConfigurationSave = {
  /**
  * The version of the configuration save data structure.
  */
  Version?: string,
  /**
  * The date of the configuration save.
  */
  Date?: string | null,
  /**
  * The knowledge base ID.
  */
  KnowledgeBaseId?: string | null,
  /**
  * The workspace ID.
  */
  WorkspaceId?: string | null,
  /**
  * The product ID of the product that the configuration is for.
  */
  ProductId?: string | null,
  /**
  * The locale ID of the configuration.
  */
  LocaleId?: string | null,
  /**
  * The currency ID of the configuration.
  */
  CurrencyId?: string | null,
  /**
  * The product configurator release that the configuration was created with.
  */
  ReleaseId?: string | null,
  /**
  * The version of the product configurator release that the configuration was created with.
  */
  ReleaseVersion?: string | null,
  /**
  * The date of the product configurator release that the configuration was created with.
  */
  ReleaseDate?: string | null,
  /**
  * The content of the configuration.
  *     This includes alle visible user selections including all sub-configurations.
  */
  Configuration?: ConfigurationSaveObject | null,
  /**
  * The BOM of the configuration.
  */
  Bom?: ConfigurationBom | null,
  /**
  * The summary of the configuration.
  */
  Summary?: ConfigurationSummary | null,
  /**
  * The context this configuration was created with.
  */
  Context?: Record<string, boolean | number | string | null> | null,
  /**
  * User defined additional properties.
  *     This can be set using configuration scripts.
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationTypeCodeAnalysisOptions
*/
export type ConfigurationTypeCodeAnalysisOptions = {
  /**
  * ConfigurationSearchDepth
  */
  ConfigurationSearchDepth?: number | null,
  /**
  * UnmatchedCharsLimit
  */
  UnmatchedCharsLimit?: number | null,
  /**
  * HeuristicAttributeLength
  */
  HeuristicAttributeLength?: number | null,
  /**
  * IsStrict
  */
  IsStrict?: boolean | null,
  /**
  * ResetConfiguration
  */
  ResetConfiguration?: boolean | null,
  /**
  * TODO: not implemented yet
  */
  UseRank?: boolean | null,
  /**
  * ExcludedAttributeIds
  */
  ExcludedAttributeIds?: (string)[] | null,
};

/**
* ConfigurationTypeCodeAnalysisElement
*/
export type ConfigurationTypeCodeAnalysisElement = {
  /**
  * IsMatch
  */
  IsMatch?: boolean,
  /**
  * IsExpected
  */
  IsExpected?: boolean,
  /**
  * Index
  */
  Index?: number,
  /**
  * Length
  */
  Length?: number,
  /**
  * Value
  */
  Value?: string | null,
  /**
  * AttributeId
  */
  AttributeId?: string | null,
  /**
  * ObjectPath
  */
  ObjectPath?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationTypeCodeAnalysisResult
*/
export type ConfigurationTypeCodeAnalysisResult = {
  /**
  * IsSuccess
  */
  IsSuccess?: boolean,
  /**
  * CurrentTypeCode
  */
  CurrentTypeCode?: string | null,
  /**
  * AnalyzedTypeCode
  */
  AnalyzedTypeCode?: string | null,
  /**
  * Elements
  */
  Elements?: (ConfigurationTypeCodeAnalysisElement)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationDrawingTransformation
*/
export type ConfigurationDrawingTransformation = {
  /**
  * OffsetX
  */
  OffsetX?: number,
  /**
  * OffsetY
  */
  OffsetY?: number,
  /**
  * OffsetZ
  */
  OffsetZ?: number,
  /**
  * AxisX
  */
  AxisX?: number,
  /**
  * AxisY
  */
  AxisY?: number,
  /**
  * AxisZ
  */
  AxisZ?: number,
  /**
  * Angle
  */
  Angle?: number,
  /**
  * ScaleX
  */
  ScaleX?: number,
  /**
  * ScaleY
  */
  ScaleY?: number,
  /**
  * ScaleZ
  */
  ScaleZ?: number,
};

/**
* ConfigurationDrawingConnector
*/
export type ConfigurationDrawingConnector = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Transformation
  */
  Transformation?: ConfigurationDrawingTransformation | null,
  /**
  * Groups
  */
  Groups?: (string)[] | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationDrawingConnection
*/
export type ConfigurationDrawingConnection = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * SourceConnector
  */
  SourceConnector?: ConfigurationDrawingConnector,
  /**
  * TargetConnector
  */
  TargetConnector?: ConfigurationDrawingConnector,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationSubDrawing
*/
export type ConfigurationSubDrawing = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Group
  */
  Group?: string | null,
  /**
  * File
  */
  File?: string | null,
  /**
  * Connection
  */
  Connection?: ConfigurationDrawingConnection | null,
  /**
  * Children
  */
  Children?: (ConfigurationSubDrawing)[] | null,
  /**
  * Layers
  */
  Layers?: (string)[] | null,
  /**
  * Texts
  */
  Texts?: Record<string, string | null> | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationDrawing
*/
export type ConfigurationDrawing = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * Name
  */
  Name?: string | null,
  /**
  * Description
  */
  Description?: string | null,
  /**
  * Drawing
  */
  Drawing?: ConfigurationSubDrawing | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* ConfigurationPrice
*/
export type ConfigurationPrice = {
  /**
  * Id
  */
  Id?: string,
  /**
  * ReferenceId
  */
  ReferenceId?: string | null,
  /**
  * PriceListId
  */
  PriceListId?: string | null,
  /**
  * Type
  */
  Type?: string | null,
  /**
  * Price
  */
  Price?: number | null,
  /**
  * UnitId
  */
  UnitId?: string | null,
  /**
  * RecurringInterval
  */
  RecurringInterval?: string | null,
  /**
  * QuantityFrom
  */
  QuantityFrom?: number | null,
  /**
  * QuantityTo
  */
  QuantityTo?: number | null,
  /**
  * QuantityUnitId
  */
  QuantityUnitId?: string | null,
  /**
  * ValidFrom
  */
  ValidFrom?: string | null,
  /**
  * ValidTo
  */
  ValidTo?: string | null,
  /**
  * Properties
  */
  Properties?: Record<string, boolean | number | string | null> | null,
};

/**
* WebRequestOptions
*/
export type WebRequestOptions = {
  /**
  * Method
  */
  Method?: string | null,
  /**
  * ContentType
  */
  ContentType?: string | null,
  /**
  * CacheResponse
  */
  CacheResponse?: boolean,
  /**
  * QueryParams
  */
  QueryParams?: Record<string, string | null> | null,
  /**
  * Headers
  */
  Headers?: Record<string, string | null> | null,
};

/**
* WebServiceResult
*/
export type WebServiceResult = {
  /**
  * Success
  */
  Success?: boolean,
  /**
  * StatusCode
  */
  StatusCode?: number,
  /**
  * Message
  */
  Message?: string | null,
  /**
  * Headers
  */
  Headers?: Record<string, string | null> | null,
  /**
  * Data
  */
  Data?: boolean | number | string | null,
};

/**
* ConfigurationValidationResult
*/
export type ConfigurationValidationResult = {
  /**
  * IsValid
  */
  IsValid?: boolean,
  /**
  * Message
  */
  Message?: string | null,
};

/**
* AddAssemblyConnection
*
* @param connection - The parameter connection.
* @returns The return value.
*/
export function AddAssemblyConnection(connection: ConfigurationConnection | null) : boolean;

/**
* AddAssemblyInstance
*
* @param instance - The parameter instance.
* @returns The return value.
*/
export function AddAssemblyInstance(instance: ConfigurationInstance | null) : boolean;

/**
* AddAssemblyObjectConnection
*
* @param objectPath - The parameter objectPath.
* @param connection - The parameter connection.
* @returns The return value.
*/
export function AddAssemblyObjectConnection(objectPath: string | null, connection: ConfigurationConnection | null) : boolean;

/**
* AddAssemblyObjectInstance
*
* @param objectPath - The parameter objectPath.
* @param instance - The parameter instance.
* @returns The return value.
*/
export function AddAssemblyObjectInstance(objectPath: string | null, instance: ConfigurationInstance | null) : boolean;

/**
* AddAssemblyObjectSubConnection
*
* @param objectPath - The parameter objectPath.
* @param subConnection - The parameter subConnection.
* @returns The return value.
*/
export function AddAssemblyObjectSubConnection(objectPath: string | null, subConnection: ConfigurationSubConnection | null) : boolean;

/**
* AddAssemblySubConnection
*
* @param subConnection - The parameter subConnection.
* @returns The return value.
*/
export function AddAssemblySubConnection(subConnection: ConfigurationSubConnection | null) : boolean;

/**
* Appends the given Item of Bill Of Material to Items of Bill Of Material of currently running configuration
*
* @example
* let bomItemData = {
*       Level: 1,
*       Rank: 4,
*       Name: "Additional item",
*       Quantity: 5,
*       BasePrices: [
*         {
*           Price: 150,
*           UnitId: "USD"
*         }
*       ]
*     };
*     PCL.AddBomItem(bomItemData);
*
* @param bomItem - Item of Bill Of Material data (as object)
* @returns true if it was successful, false otherwise
*/
export function AddBomItem(bomItem: ConfigurationBomItem | null) : boolean;

/**
* AddDrawingConnection
*
* @param connection - The parameter connection.
* @returns The return value.
*/
export function AddDrawingConnection(connection: ConfigurationConnection | null) : boolean;

/**
* AddDrawingInstance
*
* @param instance - The parameter instance.
* @returns The return value.
*/
export function AddDrawingInstance(instance: ConfigurationInstance | null) : boolean;

/**
* AddDrawingLayer
*
* @param layer - The parameter layer.
* @returns The return value.
*/
export function AddDrawingLayer(layer: ConfigurationLayer | null) : boolean;

/**
* AddDrawingObjectConnection
*
* @param objectPath - The parameter objectPath.
* @param connection - The parameter connection.
* @returns The return value.
*/
export function AddDrawingObjectConnection(objectPath: string | null, connection: ConfigurationConnection | null) : boolean;

/**
* AddDrawingObjectInstance
*
* @param objectPath - The parameter objectPath.
* @param instance - The parameter instance.
* @returns The return value.
*/
export function AddDrawingObjectInstance(objectPath: string | null, instance: ConfigurationInstance | null) : boolean;

/**
* AddDrawingObjectLayer
*
* @param objectPath - The parameter objectPath.
* @param layer - The parameter layer.
* @returns The return value.
*/
export function AddDrawingObjectLayer(objectPath: string | null, layer: ConfigurationLayer | null) : boolean;

/**
* AddDrawingObjectSubConnection
*
* @param objectPath - The parameter objectPath.
* @param subConnection - The parameter subConnection.
* @returns The return value.
*/
export function AddDrawingObjectSubConnection(objectPath: string | null, subConnection: ConfigurationSubConnection | null) : boolean;

/**
* AddDrawingObjectText
*
* @param objectPath - The parameter objectPath.
* @param text - The parameter text.
* @returns The return value.
*/
export function AddDrawingObjectText(objectPath: string | null, text: ConfigurationText | null) : boolean;

/**
* AddDrawingSubConnection
*
* @param subConnection - The parameter subConnection.
* @returns The return value.
*/
export function AddDrawingSubConnection(subConnection: ConfigurationSubConnection | null) : boolean;

/**
* AddDrawingText
*
* @param text - The parameter text.
* @returns The return value.
*/
export function AddDrawingText(text: ConfigurationText | null) : boolean;

/**
* AddMessage
*
* @param message - The parameter message.
* @returns The return value.
*/
export function AddMessage(message: ConfigurationMessage | null) : boolean;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Creates a new Instance of the Substructure Reference and appends it to the end of list of all existing substructures.
*
* @example
* PCL.AddSubConfiguration("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @returns true if it was successful, false otherwise
*/
export function AddSubConfiguration(attributePath: string | null) : boolean;

/**
* Sets the given Attribute, which is searched in the currently running configuration, as excluded from Summary information.
*
* @example
* PCL.AddSummaryExclude("A_RAM");
*
* @param attributeId - Attribute Identifier
* @returns true if it was successful, false otherwise
*/
export function AddSummaryExclude(attributeId: string | null) : boolean;

/**
* Performs the automatic selection of Values of ALL Attributes of the Configuration Object referenced by the given Long Distance-Path evaluation according to tagging "Auto Selected"
*
* @description
* The tag "Auto Selected" of a Value means, that if just one valid Value of an Attribute is leftover, this Value will be automatically selected.
*
* @example
* PCL.AutoSelectValues("/XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function AutoSelectValues(objectPath: string | null) : boolean;

/**
* BenchmarkSelectValueNative
*
* @param attributePath - The parameter attributePath.
* @param count - The parameter count.
* @returns The return value.
*/
export function BenchmarkSelectValueNative(attributePath: string | null, count: number) : number;

/**
* BenchmarkSpanParams
*
* @param text1 - The parameter text1.
* @param text2 - The parameter text2.
* @param text3 - The parameter text3.
* @param text4 - The parameter text4.
* @returns The return value.
*/
export function BenchmarkSpanParams(text1: string, text2: string, text3: string, text4: string) : number;

/**
* BenchmarkStringParams
*
* @param text1 - The parameter text1.
* @param text2 - The parameter text2.
* @param text3 - The parameter text3.
* @param text4 - The parameter text4.
* @returns The return value.
*/
export function BenchmarkStringParams(text1: string | null, text2: string | null, text3: string | null, text4: string | null) : number;

/**
* BenchmarkStringParamsNative
*
* @param text - The parameter text.
* @param count - The parameter count.
* @returns The return value.
*/
export function BenchmarkStringParamsNative(text: string | null, count: number) : number;

/**
* BuildDatabaseExecuteTableQuery
*
* @param databaseId - The parameter databaseId.
* @param tableName - The parameter tableName.
* @param tableOptions - The parameter tableOptions.
* @returns The return value.
*/
export function BuildDatabaseExecuteTableQuery(databaseId: string | null, tableName: string | null, tableOptions: ConfigurationTableOptions | null) : DatabaseStatement | null;

/**
* BuildDatabaseExecuteVariantTableQueries
*
* @param databaseId - The parameter databaseId.
* @param tableName - The parameter tableName.
* @param variantTableOptions - The parameter variantTableOptions.
* @returns The return value.
*/
export function BuildDatabaseExecuteVariantTableQueries(databaseId: string | null, tableName: string | null, variantTableOptions: ConfigurationVariantTableOptions | null) : (DatabaseStatement)[];

/**
* ClearAssemblyConnections
*
* @returns The return value.
*/
export function ClearAssemblyConnections() : boolean;

/**
* ClearAssemblyInstances
*
* @returns The return value.
*/
export function ClearAssemblyInstances() : boolean;

/**
* ClearAssemblyObjectConnections
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ClearAssemblyObjectConnections(objectPath: string | null) : boolean;

/**
* ClearAssemblyObjectInstances
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ClearAssemblyObjectInstances(objectPath: string | null) : boolean;

/**
* ClearAssemblyObjectSubConnections
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ClearAssemblyObjectSubConnections(objectPath: string | null) : boolean;

/**
* ClearAssemblySubConnections
*
* @returns The return value.
*/
export function ClearAssemblySubConnections() : boolean;

/**
* Depending on the given parameter "attributePath", there are two different use cases:
*     
*             Attribute Identifier: Clears (deletes) ALL selected Values.
*             After clearing, the following Properties get set for all Values:
*                 IsActive = true;
*                 IsAllowed = true;
*                 IsSelected = false;
*             
*             Substructure Reference: Clears (deletes) ALL instances of the referenced Configuration Object.
*
* @example
* PCL.ClearAttribute("A_RAM");
*     PCL.ClearAttribute("XAS_EXT_DEVICES");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if use case can be processed according to the parameter "attributePath", false otherwise
*/
export function ClearAttribute(attributePath: string | null) : boolean;

/**
* ClearAttributeAttachment
*
* @param attributePath - The parameter attributePath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function ClearAttributeAttachment(attributePath: string | null, attachmentId: string | null) : boolean;

/**
* Clears (deletes) the tag "Auto Selected" from the given Attribute
*
* @description
* The tag "Auto Selected" means, that if just one valid Value is leftover, this Value will be automatically selected.
*
* @example
* PCL.ClearAttributeAutoSelected("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ClearAttributeAutoSelected(attributePath: string | null) : boolean;

/**
* Clears (deletes) the Default Value definition of ALL Values of the given Attribute by setting it to null.
*     Processing gets performed only if no Value of the given Attribute was selected by hand (i.e. tagged as "User Selected"), but solely automatically by a script or tag for example.
*
* @example
* PCL.ClearAttributeDefault("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ClearAttributeDefault(attributePath: string | null) : boolean;

/**
* Clears (deletes) the Image Path (URL) of the given Attribute
*
* @example
* PCL.ClearAttributeImage("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ClearAttributeImage(attributePath: string | null) : boolean;

/**
* Clears (deletes) the Min and Max Values of the given Attribute by setting it to null
*
* @example
* PCL.ClearAttributeMinMax("A_TEMPERATURE");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ClearAttributeMinMax(attributePath: string | null) : boolean;

/**
* Clears (deletes) Property Value of the given Property assigned to the given Attribute
*
* @example
* PCL.ClearAttributeProperty("A_RAM", "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearAttributeProperty(attributePath: string | null, propertyId: string | null) : boolean;

/**
* Clears (deletes) the Recommendation Score of the given Attribute by setting it to 0
*
* @example
* PCL.ClearAttributeRecommendationScore("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ClearAttributeRecommendationScore(attributePath: string | null) : boolean;

/**
* Clears (deletes) the "Required" tag from the given Attribute
*
* @description
* The tag "Required" means, that a Value of the Attribute must be assigned (selected) so it gets considered as evaluated, which is necessary to complete the configuration.
*
* @example
* The tag "Required" means, that a Value of the Attribute must be assigned (selected) so it gets considered as evaluated, which is necessary to complete the configuration.
*     
*     PCL.ClearAttributeRequired("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ClearAttributeRequired(attributePath: string | null) : boolean;

/**
* Clears (deletes) the Step Width of the given Attribute by setting it to null
*
* @example
* PCL.ClearAttributeStepWidth("A_TEMPERATURE");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the attribute exists, false otherwise
*/
export function ClearAttributeStepWidth(attributePath: string | null) : boolean;

/**
* ClearAttributeTableChangeToken
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function ClearAttributeTableChangeToken(attributePath: string | null) : boolean;

/**
* ClearAttributeTableId
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function ClearAttributeTableId(attributePath: string | null) : boolean;

/**
* EXPERIMENTAL FUNCTION!
*     Clears (deletes) the Unit Group Identifier of the given Attribute
*
* @example
* PCL.ClearAttributeUnitGroupId("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ClearAttributeUnitGroupId(attributePath: string | null) : boolean;

/**
* Clears (deletes) the Unit Identifier of the given Attribute.
*     The given Attribute has no Unit assigned anymore after this operation
*
* @example
* PCL.ClearAttributeUnitId("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ClearAttributeUnitId(attributePath: string | null) : boolean;

/**
* Clears (deletes) the Bill of Material of currently running configuration
*
* @example
* PCL.ClearBom();
*
* @returns true if it was successful, false otherwise
*/
export function ClearBom() : boolean;

/**
* ClearDrawingConnections
*
* @returns The return value.
*/
export function ClearDrawingConnections() : boolean;

/**
* ClearDrawingInstances
*
* @returns The return value.
*/
export function ClearDrawingInstances() : boolean;

/**
* ClearDrawingLayers
*
* @returns The return value.
*/
export function ClearDrawingLayers() : boolean;

/**
* ClearDrawingObjectConnections
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ClearDrawingObjectConnections(objectPath: string | null) : boolean;

/**
* ClearDrawingObjectInstances
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ClearDrawingObjectInstances(objectPath: string | null) : boolean;

/**
* ClearDrawingObjectLayers
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ClearDrawingObjectLayers(objectPath: string | null) : boolean;

/**
* ClearDrawingObjectSubConnections
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ClearDrawingObjectSubConnections(objectPath: string | null) : boolean;

/**
* ClearDrawingObjectTexts
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ClearDrawingObjectTexts(objectPath: string | null) : boolean;

/**
* ClearDrawingSubConnections
*
* @returns The return value.
*/
export function ClearDrawingSubConnections() : boolean;

/**
* ClearDrawingTexts
*
* @returns The return value.
*/
export function ClearDrawingTexts() : boolean;

/**
* Clears (deletes) the evaluation of ALL Attributes, which belong to the given Attribute Group
*
* @example
* PCL.ClearGroup("CONFIG_ATTR_GROUP_PERFORMANCE");
*
* @param groupPath - Attribute Group Identifier
* @returns true if the Attribute Group exists, false otherwise
*/
export function ClearGroup(groupPath: string | null) : boolean;

/**
* Clears (deletes) the Recommendation Score of ALL Attributes, which belong to the given Attribute Group, by setting it to 0
*
* @example
* PCL.ClearGroupRecommendationScore("CONFIG_ATTR_GROUP_PERFORMANCE");
*
* @param groupPath - Attribute Group Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearGroupRecommendationScore(groupPath: string | null) : boolean;

/**
* Clears (removes) ALL Inputs assigned to the currently running configuration
*
* @example
* PCL.ClearInputs();
*
* @returns true if it was successful, false otherwise
*/
export function ClearInputs() : boolean;

/**
* ClearMessages
*
* @returns The return value.
*/
export function ClearMessages() : boolean;

/**
* Clears (deletes) the evaluation of all Attributes after the given Attribute
*
* @example
* PCL.ClearNextAttributes("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists, false otherwise
*/
export function ClearNextAttributes(attributePath: string | null) : boolean;

/**
* For this function to work, the given Long Distance-Path must reference an existing instance of a Configuration Object in the currently running configuration.
*     If so, it clears (deletes) the selected Values of all Attributes of referenced Configuration Object
*
* @example
* PCL.ClearObject("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if the deletion of selected Values of all Attributes of referenced Configuration Object was performed, false otherwise
*/
export function ClearObject(objectPath: string | null) : boolean;

/**
* ClearObjectAttachment
*
* @param objectPath - The parameter objectPath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function ClearObjectAttachment(objectPath: string | null, attachmentId: string | null) : boolean;

/**
* Clears (deletes) the Image Path (URL) of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectImage("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectImage(objectPath: string | null) : boolean;

/**
* Clears (removes) ALL Inputs assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectInputs("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectInputs(objectPath: string | null) : boolean;

/**
* Clears (deletes) the mass of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectMass("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectMass(objectPath: string | null) : boolean;

/**
* Clears (deletes) the Unit Identifier of mass of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectMassUnitId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectMassUnitId(objectPath: string | null) : boolean;

/**
* Clears (removes) ALL Outputs assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectOutputs("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectOutputs(objectPath: string | null) : boolean;

/**
* Clears (deletes) the part class name of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectPartClass("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectPartClass(objectPath: string | null) : boolean;

/**
* Clears (deletes) the part Identifier of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectPartId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectPartId(objectPath: string | null) : boolean;

/**
* Clears (deletes) price of the Configuration Object referenced by the given Long Distance-Path.
*     Second parameter "priceType" is optional. If given, deletion of the price, which was set by call of function "SetObjectPrice" with the same "priceType" passed, is performed now.
*
* @example
* PCL.ClearObjectPrice("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function ClearObjectPrice(objectPath: string | null, priceType: string | null) : boolean;

/**
* ClearObjectPriceId
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ClearObjectPriceId(objectPath: string | null) : boolean;

/**
* Clears (deletes) Currency Identifier of price, which gets converted to currency symbol for displaying it, of the Configuration Object referenced by the given Long Distance-Path.
*     Second parameter "priceType" is optional. If given, deletion of Currency Identifier, which was set by call of function "SetObjectPriceUnitId" with the same "priceType" passed, is performed now.
*
* @example
* PCL.ClearObjectPriceUnitId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function ClearObjectPriceUnitId(objectPath: string | null, priceType: string | null) : boolean;

/**
* Clears (deletes) Property Value of the given Property assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectProperty("XAS_EXT_DEVICES/0", "Quantity");
*
* @param objectPath - Long Distance-Path
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearObjectProperty(objectPath: string | null, propertyId: string | null) : boolean;

/**
* Clears (deletes) the quantity of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectQuantity("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectQuantity(objectPath: string | null) : boolean;

/**
* Clears (deletes) the Unit Identifier of quantity of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectQuantityUnitId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectQuantityUnitId(objectPath: string | null) : boolean;

/**
* Clears (deletes) the Recommendation Score of the Configuration Object referenced by the given Long Distance-Path by setting it to 0
*
* @example
* PCL.ClearObjectRecommendationScore("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectRecommendationScore(objectPath: string | null) : boolean;

/**
* Clears (removes) ALL Variables assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.ClearObjectVariables("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ClearObjectVariables(objectPath: string | null) : boolean;

/**
* Clears (removes) ALL Outputs assigned to the currently running configuration
*
* @example
* PCL.ClearOutputs();
*
* @returns true if it was successful, false otherwise
*/
export function ClearOutputs() : boolean;

/**
* Clears (deletes) the evaluation of all Attributes before the given Attribute
*
* @example
* PCL.ClearPreviousAttributes("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists, false otherwise
*/
export function ClearPreviousAttributes(attributePath: string | null) : boolean;

/**
* ClearStateAttachment
*
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function ClearStateAttachment(attachmentId: string | null) : boolean;

/**
* Clears (deletes) Property Value of the given Property Identifier assigned to the State of configuration by setting it to null.
*     The assignment of the Property Identifier remains in the State of configuration.
*
* @example
* PCL.ClearStateProperty("priority");
*
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearStateProperty(propertyId: string | null) : boolean;

/**
* Clears (removes) ALL key/value pairs from the Store.
*
* @example
* PCL.ClearStore();
*
*/
export function ClearStore() : void;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Deletes all Instances (i.e. Cardinality = 0) of the Substructure Reference, and overwrites the default number of Instances (default Cardinality).
*
* @example
* PCL.ClearSubConfigurationCount("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @returns true if it was successful, false otherwise
*/
export function ClearSubConfigurationCount(attributePath: string | null) : boolean;

/**
* Clears (deletes) definition of all Attributes of the currently running configuration as excluded from Summary information.
*
* @example
* PCL.ClearSummaryExcludes();
*
* @returns true if deletion of the exclusion of Attributes from Summary was successful, false otherwise
*/
export function ClearSummaryExcludes() : boolean;

/**
* ClearValueAttachment
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function ClearValueAttachment(attributePath: string | null, valueId: boolean | number | string | null, attachmentId: string | null) : boolean;

/**
* Clears (deletes) the given Value as Default Value of the given Attribute
*
* @example
* PCL.ClearValueDefault("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueDefault(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) the Image Path (URL) of the given Value of the given Attribute
*
* @example
* PCL.ClearValueImage("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueImage(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) the mass of the given Value of the given Attribute
*
* @example
* PCL.ClearValueMass("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueMass(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) the Unit Identifier of mass of the given Value of the given Attribute
*
* @example
* PCL.ClearValueMassUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueMassUnitId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) the part class name of the given Value of the given Attribute
*
* @example
* PCL.ClearValuePartClass("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValuePartClass(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) the part Identifier of the given Value of the given Attribute
*
* @example
* PCL.ClearValuePartId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValuePartId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) price of the given Value of the given Attribute.
*     Third parameter "priceType" is optional. If given, deletion of the price, which was set by call of function "SetValuePrice" with the same "priceType" passed, is performed now.
*
* @example
* PCL.ClearValuePrice("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function ClearValuePrice(attributePath: string | null, valueId: boolean | number | string | null, priceType: string | null) : boolean;

/**
* ClearValuePriceId
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @returns The return value.
*/
export function ClearValuePriceId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) Currency Identifier of price, which gets converted to currency symbol for displaying it, of the given Value of the given Attribute.
*     Third parameter "priceType" is optional. If given, deletion of Currency Identifier, which was set by call of function "SetValuePriceUnitId" with the same "priceType" passed, is performed now.
*
* @example
* PCL.ClearValuePriceUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function ClearValuePriceUnitId(attributePath: string | null, valueId: boolean | number | string | null, priceType: string | null) : boolean;

/**
* Clears (deletes) Property Value of the given Property assigned to the given Value of the given Attribute
*
* @example
* PCL.ClearValueProperty("A_RAM", "V_16GB", "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueProperty(attributePath: string | null, valueId: boolean | number | string | null, propertyId: string | null) : boolean;

/**
* Clears (deletes) the quantity of the given Value of the given Attribute
*
* @example
* PCL.ClearValueQuantity("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueQuantity(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) the Unit Identifier of quantity of the given Value of the given Attribute
*
* @example
* PCL.ClearValueQuantityUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueQuantityUnitId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) the Recommendation Score of the given Value of the given Attribute by setting it to 0
*
* @example
* PCL.ClearValueRecommendationScore("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueRecommendationScore(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) the Recommendation Score of ALL Values of the given Attribute by setting it to 0
*
* @example
* PCL.ClearValuesRecommendationScore("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ClearValuesRecommendationScore(attributePath: string | null) : boolean;

/**
* Clears (deletes) the type code fragment assigned to the given Value of the given Attribute
*
* @example
* PCL.ClearValueTypeCodeFragment("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueTypeCodeFragment(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (deletes) the Unit Identifier of the given Value of the given Attribute.
*     The given Value of the given Attribute has no Unit assigned anymore after this operation
*
* @example
* PCL.ClearValueUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ClearValueUnitId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Clears (removes) ALL Variables assigned to the currently running configuration.
*
* @example
* PCL.ClearVariables();
*
* @returns true if it was successful, false otherwise
*/
export function ClearVariables() : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Closes the Configuration Object of the currently running configuration. This means that the parent Configuration Object is the currently running configuration afterwards, if wasn't already the Root Configuration Object
*
* @example
* PCL.CloseObject();
*
* @returns true
*/
export function CloseObject() : boolean;

/**
* CAUTION - ENHANCED FUNCTIONALITY! USE ONLY IN CONSIDERATION OF CHANGES APPLIED TO ALL CONFIGURATION STRUCTURES DEPENDING ON THIS FUNCTION
*     Closes the Configuration Object of the currently running configuration. This means that the parent Configuration Object is the currently running configuration afterwards, if wasn't already the Root Configuration Object
*
* @example
* PCL.CloseSubConfiguration();
*
* @returns true if it was successful, false otherwise
*/
export function CloseSubConfiguration() : boolean;

/**
* CompareInfoVersions
*
* @param leftVersionString - The parameter leftVersionString.
* @param rightVersionString - The parameter rightVersionString.
* @returns The return value.
*/
export function CompareInfoVersions(leftVersionString: string | null, rightVersionString: string | null) : number;

/**
* ComputeCustomTableChangeToken
*
* @param data - The parameter data.
* @returns The return value.
*/
export function ComputeCustomTableChangeToken(data: any) : string;

/**
* Returns the conversion of the given Value of money from given Source currency Identifier to given Target currency Identifier.
*
* @example
* PCL.ConvertCurrency(25.5, "EUR", "USD");
*
* @param value - Value of money
* @param fromCurrencyId - Source currency Identifier
* @param toCurrencyId - Target currency Identifier
* @returns Converted Value of money from Source currency Identifier to Target currency Identifier
*/
export function ConvertCurrency(value: number | null, fromCurrencyId: string | null, toCurrencyId: string | null) : number | null;

/**
* Returns the conversion of the given Value of money from given Source currency Identifier to given Target currency Identifier rounded to decimal digits as specified in currencies table for the Target currency.
*
* @example
* PCL.ConvertCurrencyRounded(25.5, "EUR", "USD");
*
* @param value - Value of money
* @param fromCurrencyId - Source currency Identifier
* @param toCurrencyId - Target currency Identifier
* @returns Converted Value of money from Source currency Identifier to Target currency Identifier rounded to decimal digits as specified in currencies table for Target currency
*/
export function ConvertCurrencyRounded(value: number | null, fromCurrencyId: string | null, toCurrencyId: string | null) : number | null;

/**
* ConvertQuantity
*
* @param value - The parameter value.
* @param fromUnitId - The parameter fromUnitId.
* @param toUnitId - The parameter toUnitId.
* @returns The return value.
*/
export function ConvertQuantity(value: number | null, fromUnitId: string | null, toUnitId: string | null) : number | null;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Initially, creates a new Instance of the Substructure Reference and inserts it at the given targetIndex into list of all existing substructures.
*     Afterwards, copies evaluation of the Instance of the Substructure Reference with the given sourceIndex in list of all existing substructures and applies it to this new Instance
*
* @example
* PCL.CopySubConfiguration("XAS_MISCELLANEOUS", 0, 1);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param sourceIndex - Index number of the Instance to be copied (Source)
* @param targetIndex - Index number of the Instance to be copied to (Target)
* @returns true if it was successful, false otherwise
*/
export function CopySubConfiguration(attributePath: string | null, sourceIndex: number, targetIndex: number) : boolean;

/**
* CreateGuid
*
* @returns The return value.
*/
export function CreateGuid() : string;

/**
* Executes a SQL Query to a Database to either insert datasets into or change datasets of one or multiple of its tables or create a new table.
*
* @example
* let currentTime = new Date().getTime();
*      let checkAttributeId = "A_RAM";
*      let checkAttributeValue = PCL.GetSelectedValue(checkAttributeId);
*      let sqlQuery = "INSERT INTO TestTable VALUES (?, ?, ?);";
*      let sqlArguments = [currentTime, checkAttributeId, checkAttributeValue];
*      let dbResult = PCL.DatabaseExecuteNonQuery("EXTERNAL_DATA", sqlQuery, sqlArguments);
*     
*     
*      // The result of Database Execution, named above "dbResult", is an object providing the following data:
*      // If the Database Execution was successful:
*      dbResult = {
*        Success: true // Boolean indicating successful performance of Database Execution
*      };
*     
*      // Otherwise, if the Database Execution was not successful:
*      dbResult = {
*        Success: false, // Boolean indicating that error occurred during performance of Database Execution
*        Message: "SQLite Error 1: 'no such column: testData'." // String containing the error message of Database Execution
*      };
*
* @param databaseId - Database ID, mostly "EXTERNAL_DATA"
* @param statement - SQL Statement
* @param parameters - Array of Arguments
* @returns 
     Result of Database Execution as an object. For further details, see description of variable named "dbResult" in example above.
     
*/
export function DatabaseExecuteNonQuery(databaseId: string | null, statement: string | null, parameters: (boolean | number | string | null)[] | null) : DatabaseResult;

/**
* Executes a SQL Query to a Database to retrieve datasets from one or multiple of its tables.
*
* @example
* let selectedScreenSize = PCL.GetSelectedValue("A_SCREEN_SIZE");
*      let sqlQuery = "select * from VT_GRAPHICS where A_SCREEN_RESOLUTION LIKE ? and A_SCREEN_SIZE = ?";
*      let sqlArguments = ["V_SR_1600", selectedScreenSize];
*      let dbResult = PCL.DatabaseExecuteQuery("EXTERNAL_DATA", sqlQuery, sqlArguments);
*     
*      // The result of Database Execution, named above "dbResult", is an object providing the following data:
*      // If the Database Execution was successful:
*      dbResult = {
*        Success: true, // Boolean indicating successful performance of Database Execution
*        Columns: [...], // Array containing strings representing the identifiers of all database table columns whose data got retrieved according to the SQL Statement
*        Rows: [...] // Array of objects containing data of all rows retrieved from the database table columns according to the SQL Statement
*      };
*      // Each entry of the Array "Rows" is an object providing the same properties as strings contained in the Array "Columns".
*      // The content of each property is the value of the corresponding database table column in respective row.
*     
*      // Otherwise, if the Database Execution was not successful:
*      dbResult = {
*        Success: false, // Boolean indicating that error occurred during performance of Database Execution
*        Columns: [], // empty Array (due to error)
*        Rows: [], // empty Array (due to error)
*        Message: "SQLite Error 1: 'no such column: testData'." // String containing the error message of Database Execution
*      };
*
* @param databaseId - Database ID, mostly "EXTERNAL_DATA"
* @param statement - SQL Statement
* @param parameters - Array of Arguments
* @returns 
     Result of Database Execution as an object. For further details, see description of variable named "dbResult" in example above.
     
*/
export function DatabaseExecuteQuery(databaseId: string | null, statement: string | null, parameters: (boolean | number | string | null)[] | null) : DatabaseResult;

/**
* DatabaseExecuteTableQuery
*
* @param databaseId - The parameter databaseId.
* @param tableName - The parameter tableName.
* @param tableOptions - The parameter tableOptions.
* @returns The return value.
*/
export function DatabaseExecuteTableQuery(databaseId: string | null, tableName: string | null, tableOptions: ConfigurationTableOptions | null) : ConfigurationTable;

/**
* DatabaseGetQueryColumns
*
* @param databaseId - The parameter databaseId.
* @param statement - The parameter statement.
* @param parameters - The parameter parameters.
* @returns The return value.
*/
export function DatabaseGetQueryColumns(databaseId: string | null, statement: string | null, parameters: (boolean | number | string | null)[] | null) : DatabaseColumn;

/**
* DatabaseGetTableColumns
*
* @param databaseId - The parameter databaseId.
* @param tableId - The parameter tableId.
* @returns The return value.
*/
export function DatabaseGetTableColumns(databaseId: string | null, tableId: string | null) : DatabaseColumn;

/**
* EXPERIMENTAL FUNCTION!
*
* @returns The return value.
*/
export function DatabaseUpperCaseColumns() : boolean;

/**
* DecodeBase64
*
* @param data - The parameter data.
* @returns The return value.
*/
export function DecodeBase64(data: string | null) : string | null;

/**
* DecodeUrl
*
* @param data - The parameter data.
* @returns The return value.
*/
export function DecodeUrl(data: string | null) : string | null;

/**
* DecodeUrlPath
*
* @param data - The parameter data.
* @returns The return value.
*/
export function DecodeUrlPath(data: string | null) : string | null;

/**
* Deselects the given Value as Default Value of the given Attribute by calling PCL.SetDefaultValueSelected(attributePath, valueId, false)
*
* @example
* PCL.DeselectDefaultValue("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function DeselectDefaultValue(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Deselects all Default Values of the given Attribute
*
* @example
* PCL.DeselectDefaultValues("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function DeselectDefaultValues(attributePath: string | null) : boolean;

/**
* Deselects the given Value of the given Attribute
*
* @example
* PCL.DeselectValue("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function DeselectValue(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* EXPERIMENTAL FUNCTION!
*     Deselects the given Value of the given Attribute everywhere in the Configuration, including all Sub-Configurations and Root Object
*
* @example
* PCL.DeselectValueEverywhere("A_RAM", "V_16GB");
*
* @param attributeId - Attribute Identifier
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function DeselectValueEverywhere(attributeId: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Deselects ALL Values of the given Attribute
*
* @example
* PCL.DeselectValues("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function DeselectValues(attributePath: string | null) : boolean;

/**
* EXPERIMENTAL FUNCTION!
*     Deselects ALL Values of the given Attribute everywhere in the Configuration, including all Sub-Configurations and Root Object
*
* @example
* PCL.DeselectValuesEverywhere("A_RAM");
*
* @param attributeId - Attribute Identifier
* @returns true if it was successful, false otherwise
*/
export function DeselectValuesEverywhere(attributeId: string | null) : boolean;

/**
* EncodeBase64
*
* @param data - The parameter data.
* @returns The return value.
*/
export function EncodeBase64(data: string | null) : string | null;

/**
* EncodeUrl
*
* @param data - The parameter data.
* @returns The return value.
*/
export function EncodeUrl(data: string | null) : string;

/**
* EncodeUrlPath
*
* @param data - The parameter data.
* @returns The return value.
*/
export function EncodeUrlPath(data: string | null) : string;

/**
* Returns result of evaluation of the given Formula string, which usually represents a complex condition of Configuration datasets (e.g. evaluation of Attributes with specific value)
*
* @example
* For more information on definition of Formulas, please see the xWiki Documentation under https://xwiki-plansoft.prod.ingress-ps-3pq-demo.n4group.eu/bin/view/Main/ (Section: Standard Functions - Formulas)
*     
*     PCL.EvaluateFormula('A_MODEL == "V_CERES" && A_SSD > 500');
*
* @param formulaString - Formula string
* @returns Result of evaluation of the Formula string
*/
export function EvaluateFormula(formulaString: string | null) : boolean | number | string | null;

/**
* Function to use for debugging of evaluation of the given Formula string, which usually represents a complex condition of Configuration datasets (e.g. evaluation of Attributes with specific value).
*     Returns string with information on processing of the given Formula string, which contains results of the processing steps in the same sequence as they get performed.
*
* @example
* For more information on definition of Formulas, please see the xWiki Documentation under https://xwiki-plansoft.prod.ingress-ps-3pq-demo.n4group.eu/bin/view/Main/ (Section: Standard Functions - Formulas)
*     
*     PCL.EvaluateFormulaComment('A_MODEL == "V_CERES" && A_SSD > 500');
*
* @param formulaString - Formula string
* @returns String with debugging information on processing of the given Formula string
*/
export function EvaluateFormulaComment(formulaString: string | null) : string | null;

/**
* Function to use for debugging of evaluation of the given Formula string, which usually represents a complex condition of Configuration datasets (e.g. evaluation of Attributes with specific value).
*     Returns extensive multi-line string with information on processing of the given Formula string. The tree-like indention in it is used to improve the understanding of the sequence of processing steps.
*
* @example
* For more information on definition of Formulas, please see the xWiki Documentation under https://xwiki-plansoft.prod.ingress-ps-3pq-demo.n4group.eu/bin/view/Main/ (Section: Standard Functions - Formulas)
*     
*     PCL.EvaluateFormulaTree('A_MODEL == "V_CERES" && A_SSD > 500');
*
* @param formulaString - Formula string
* @returns String with debugging information on processing of the given Formula string
*/
export function EvaluateFormulaTree(formulaString: string | null) : string | null;

/**
* ExecuteVariantTable
*
* @param databaseId - The parameter databaseId.
* @param tableName - The parameter tableName.
* @param variantTableOptions - The parameter variantTableOptions.
* @returns The return value.
*/
export function ExecuteVariantTable(databaseId: string | null, tableName: string | null, variantTableOptions: ConfigurationVariantTableOptions | null) : (DatabaseStatement)[];

/**
* ForceCurrentObjectConsistency
*
* @returns The return value.
*/
export function ForceCurrentObjectConsistency() : boolean;

/**
* ForceObjectConsistency
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ForceObjectConsistency(objectPath: string | null) : boolean;

/**
* ForceRootObjectConsistency
*
* @returns The return value.
*/
export function ForceRootObjectConsistency() : boolean;

/**
* Returns all Attributes of the Configuration Object referenced by the given Long Distance-Path, which are either active (active = true) or inactive (active = false) as an Array
*
* @example
* PCL.GetActiveAttributes("/XAS_EXT_DEVICES/0", true);
*
* @param objectPath - Long Distance-Path
* @param active - true or false
* @returns Array of all Attribute Identifiers, which are either active (active = true) or inactive (active = false), if the Configuration Object exists, empty Array otherwise
*/
export function GetActiveAttributes(objectPath: string | null, active: boolean) : (string)[];

/**
* Returns all Values of the given Attribute, which are either active (active = true) or inactive (active = false)
*
* @example
* PCL.GetActiveValues("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param active - true or false
* @returns Array of all (in)active Values if the Attribute exists, empty Array otherwise
*/
export function GetActiveValues(attributePath: string | null, active: boolean) : (boolean | number | string | null)[];

/**
* Returns all Attributes of the Configuration Object referenced by the given Long Distance-Path, which are either allowed (allowed = true) or hidden (allowed = false) as an Array
*
* @example
* PCL.GetAllowedAttributes("/XAS_EXT_DEVICES/0", true);
*
* @param objectPath - Long Distance-Path
* @param allowed - true or false
* @returns Array of all Attribute Identifiers, which are either allowed (allowed = true) or hidden (allowed = false), if the Configuration Object exists, empty Array otherwise
*/
export function GetAllowedAttributes(objectPath: string | null, allowed: boolean) : (string)[];

/**
* Returns all Values of the given Attribute, which are either allowed (allowed = true) or hidden (allowed = false), as an Array
*
* @example
* PCL.GetAllowedValues("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param allowed - true or false
* @returns Array of all allowed or all hidden Values if the Attribute exists, empty Array otherwise
*/
export function GetAllowedValues(attributePath: string | null, allowed: boolean) : (boolean | number | string | null)[];

/**
* GetAssembly
*
* @returns The return value.
*/
export function GetAssembly() : ConfigurationAssembly;

/**
* GetAssemblyConnections
*
* @returns The return value.
*/
export function GetAssemblyConnections() : (ConfigurationConnection)[];

/**
* GetAssemblyInstances
*
* @returns The return value.
*/
export function GetAssemblyInstances() : (ConfigurationInstance)[];

/**
* GetAssemblyObjectConnections
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetAssemblyObjectConnections(objectPath: string | null) : (ConfigurationConnection)[];

/**
* GetAssemblyObjectInstances
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetAssemblyObjectInstances(objectPath: string | null) : (ConfigurationInstance)[];

/**
* GetAssemblyObjectSubConnections
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetAssemblyObjectSubConnections(objectPath: string | null) : (ConfigurationSubConnection)[];

/**
* GetAssemblySubConnections
*
* @returns The return value.
*/
export function GetAssemblySubConnections() : (ConfigurationSubConnection)[];

/**
* GetAttachmentDescriptionTranslation
*
* @param attachmentId - The parameter attachmentId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetAttachmentDescriptionTranslation(attachmentId: string | null, localeId: string | null) : string;

/**
* GetAttachmentLocales
*
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function GetAttachmentLocales(attachmentId: string | null) : (string)[] | null;

/**
* GetAttachmentNameTranslation
*
* @param attachmentId - The parameter attachmentId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetAttachmentNameTranslation(attachmentId: string | null, localeId: string | null) : string;

/**
* Returns the relative file path of the given Attachment Identifier, which is assigned as attachment anywhere in the environment of all datasets of configuration, i.e. Configuration Objects, Attributes and Attribute Values.
*
* @example
* PCL.GetAttachmentPath("Product_Ceres_png");
*
* @param attachmentId - Attachment Identifier
* @returns Relative file path of the given Attachment Identifier, which is assigned as attachment anywhere in the environment of all datasets of configuration, i.e. Configuration Objects, Attributes and Attribute Values.
*/
export function GetAttachmentPath(attachmentId: string | null) : string | null;

/**
* GetAttributeAttachmentCount
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function GetAttributeAttachmentCount(attributePath: string | null) : number;

/**
* GetAttributeAttachmentPath
*
* @param attributePath - The parameter attributePath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function GetAttributeAttachmentPath(attributePath: string | null, attachmentId: string | null) : string | null;

/**
* GetAttributeAttachments
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function GetAttributeAttachments(attributePath: string | null) : Record<string, string | null>;

/**
* GetAttributeAttachmentTags
*
* @param attributePath - The parameter attributePath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function GetAttributeAttachmentTags(attributePath: string | null, attachmentId: string | null) : (string)[] | null;

/**
* Returns the Attribute Identifier according to the given Index within the given Configuration Object
*
* @example
* PCL.GetAttributeByIndex("XAS_EXT_DEVICES/0", 2);
*
* @param objectPath - Long Distance-Path of the Root Configuration Object ("/") or an existing Instances of a Substructure Reference
* @param index - Index/Rank of an Attribute
* @returns The Attribute Identifier if the Attribute exists, null otherwise
*/
export function GetAttributeByIndex(objectPath: string | null, index: number) : string | null;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Returns the Configuration Object Identifier of the given Attribute
*
* @example
* PCL.GetAttributeConfigurationObjectId("XAS_EXT_DEVICES");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path) of a Substructure Reference
* @returns The Configuration Object Identifier if the Configuration Object exists, null otherwise
*/
export function GetAttributeConfigurationObjectId(attributePath: string | null) : string | null;

/**
* Returns the number of Attributes within the given Configuration Object
*
* @example
* PCL.GetAttributeCount("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path of the Root Configuration Object ("/") or an existing Instances of a Substructure Reference
* @returns The number of Attributes (int) if the Attribute exists, 0 otherwise
*/
export function GetAttributeCount(objectPath: string | null) : number;

/**
* Returns the data type of the given Attribute
*
* @example
* PCL.GetAttributeDataType("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The data type if the Attribute exists, null otherwise
*/
export function GetAttributeDataType(attributePath: string | null) : string | null;

/**
* Returns the data type ID of the given Attribute
*
* @example
* PCL.GetAttributeDataTypeId("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The data type ID as number (int) if the Attribute exists, -1 (int) otherwise
*/
export function GetAttributeDataTypeId(attributePath: string | null) : number;

/**
* Returns the translated description of the given Attribute Identifier in language of the given Language Identifier.
*     The description of the Attribute Identifier represents the descriptive text, which is assigned to the Attribute via the Data Manager.
*     Notice: The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetAttributeDescriptionTranslation("A_KEYBOARD", "en-US");
*
* @param attributeId - Attribute Identifier
* @param localeId - Language Identifier
* @returns Translated description of the Attribute Identifier in language of the Language Identifier, if the Attribute Identifier exists and the Language Identifier is valid, otherwise the unchanged Attribute Identifier
*/
export function GetAttributeDescriptionTranslation(attributeId: string | null, localeId: string | null) : string;

/**
* Returns the translated description of the given Attribute Group Identifier in language of the given Language Identifier.
*     The description of the Attribute Group Identifier represents the descriptive text, which is assigned to the Attribute Group via the Data Manager.
*     Notice: The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetAttributeGroupDescriptionTranslation("CONFIG_ATTR_GROUP_STORAGE", "en-US");
*
* @param groupId - Attribute Group Identifier
* @param localeId - Language Identifier
* @returns Translated description of the Attribute Group Identifier in language of the Language Identifier, if the Attribute Group Identifier exists and the Language Identifier is valid, otherwise the unchanged Attribute Group Identifier
*/
export function GetAttributeGroupDescriptionTranslation(groupId: string | null, localeId: string | null) : string;

/**
* Returns all group identifiers to which the given Attribute belongs as an Array
*
* @example
* PCL.GetAttributeGroupIds("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns Array of group identifiers if the Attribute exists, null otherwise
*/
export function GetAttributeGroupIds(attributePath: string | null) : (string)[] | null;

/**
* Returns the translated name of the given Attribute Group Identifier in language of the given Language Identifier.
*     The name of the Attribute Group Identifier represents the string being displayed in the user interface for the Attribute Group.
*     Notice: The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetAttributeGroupNameTranslation("CONFIG_ATTR_GROUP_STORAGE", "en-US");
*
* @param groupId - Attribute Group Identifier
* @param localeId - Language Identifier
* @returns Translated name of the Attribute Group Identifier in language of the Language Identifier, if the Attribute Group Identifier exists and the Language Identifier is valid, otherwise the unchanged Attribute Group Identifier
*/
export function GetAttributeGroupNameTranslation(groupId: string | null, localeId: string | null) : string;

/**
* Returns the Attribute Identifier of the given Attribute Path
*
* @example
* PCL.GetAttributeId("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The Attribute Identifier if the Attribute exists, null otherwise
*/
export function GetAttributeId(attributePath: string | null) : string | null;

/**
* Returns the Image Path (URL) of the given Attribute
*
* @example
* PCL.GetAttributeImage("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns Image Path (URL) if the Attribute exists, null otherwise
*/
export function GetAttributeImage(attributePath: string | null) : string | null;

/**
* Returns the Index of the given Attribute in the currently running configuration
*
* @example
* PCL.GetAttributeIndex("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The Attribute Index if the Attribute exists, -1 otherwise
*/
export function GetAttributeIndex(attributePath: string | null) : number;

/**
* Returns the Max Value of the given Attribute
*
* @example
* PCL.GetAttributeMax("A_TEMPERATURE");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The Max Value if the Attribute exists, null otherwise
*/
export function GetAttributeMax(attributePath: string | null) : number | null;

/**
* Returns the Min Value of the given Attribute
*
* @example
* PCL.GetAttributeMin("A_TEMPERATURE");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The Min Value if the Attribute exists, null otherwise
*/
export function GetAttributeMin(attributePath: string | null) : number | null;

/**
* Returns the translated name of the given Attribute Identifier in language of the given Language Identifier.
*     The name of the Attribute Identifier represents the string being displayed in the user interface for the Attribute.
*     Notice: The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetAttributeNameTranslation("A_KEYBOARD", "en-US");
*
* @param attributeId - Attribute Identifier
* @param localeId - Language Identifier
* @returns Translated name of the Attribute Identifier in language of the Language Identifier, if the Attribute Identifier exists and the Language Identifier is valid, otherwise the unchanged Attribute Identifier
*/
export function GetAttributeNameTranslation(attributeId: string | null, localeId: string | null) : string;

/**
* Returns the Long Distance-Path of the given Attribute Identifier
*
* @example
* PCL.GetAttributePath("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The Long Distance-Path if the Attribute exists, null otherwise
*/
export function GetAttributePath(attributePath: string | null) : string | null;

/**
* Returns all Properties assigned to the given Attribute and their Property Values as an object (key/value pairs)
*
* @example
* PCL.GetAttributeProperties("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns An object of key/value pairs containing the Property Values of all Properties assigned to the Attribute if it was successful, an empty object otherwise
*/
export function GetAttributeProperties(attributePath: string | null) : Record<string, boolean | number | string | null>;

/**
* Returns the number of Properties assigned to the given Attribute
*
* @example
* PCL.GetAttributePropertyCount("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The number of Properties (int) assigned to the Attribute if it was successful, 0 otherwise
*/
export function GetAttributePropertyCount(attributePath: string | null) : number;

/**
* Returns the translated Description of the Attribute Property in language of the given Language Identifier.
*     The description of the Attribute Property represents the descriptive text, which is assigned to the Property of the Attribute via the Data Manager.
*     Notice: The fifth parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetAttributePropertyDescriptionTranslation("CFG_NOTEBOOK", "A_KEYBOARD", "auxiliaryInfo", "en-US");
*
* @param objectId - Configuration Object Identifier
* @param attributeId - Attribute Identifier
* @param propertyId - Property Identifier
* @param propertyValue - Property Value
* @param localeId - Language Identifier
* @returns Translated Description of the Attribute Property in language of the Language Identifier, if the Attribute Property exists and the Language Identifier is valid, otherwise the unchanged Attribute Property
*/
export function GetAttributePropertyDescriptionTranslation(objectId: string | null, attributeId: string | null, propertyId: string | null, propertyValue: boolean | number | string | null, localeId: string | null) : string;

/**
* Returns the translated Name of the Attribute Property in language of the given Language Identifier.
*     Notice: The fifth parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetAttributePropertyNameTranslation("CFG_NOTEBOOK", "A_KEYBOARD", "auxiliaryInfo", "en-US");
*
* @param objectId - Configuration Object Identifier
* @param attributeId - Attribute Identifier
* @param propertyId - Property Identifier
* @param propertyValue - Property Value
* @param localeId - Language Identifier
* @returns Translated name of the Attribute Property in language of the Language Identifier, if the Attribute Property exists and the Language Identifier is valid, otherwise the unchanged Attribute Property
*/
export function GetAttributePropertyNameTranslation(objectId: string | null, attributeId: string | null, propertyId: string | null, propertyValue: boolean | number | string | null, localeId: string | null) : string;

/**
* Returns the Property Value of the given Property if it is assigned to the given Attribute as a JSON object
*
* @example
* PCL.GetAttributePropertyObject("A_RAM", "property");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param propertyId - Property Identifier
* @returns An object with data of Property Value if it was successful, null otherwise
*/
export function GetAttributePropertyObject(attributePath: string | null, propertyId: string | null) : any;

/**
* Returns the Property Value of the given Property if it is assigned to the given Attribute
*
* @example
* PCL.GetAttributePropertyValue("A_RAM", "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param propertyId - Property Identifier
* @returns The Property Value if Property is assigned, null otherwise
*/
export function GetAttributePropertyValue(attributePath: string | null, propertyId: string | null) : boolean | number | string | null;

/**
* Returns the Recommendation Score of the given Attribute
*
* @example
* PCL.GetAttributeRecommendationScore("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The Recommendation Score as number (double) if the Attribute exists, 0 otherwise
*/
export function GetAttributeRecommendationScore(attributePath: string | null) : number;

/**
* Returns the Reference Identifier, which can be provided by an external system (e.g. PIM) during import of the given Attribute via the Data Manager
*
* @example
* PCL.GetAttributeReferenceId("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The Reference Identifier if the Attribute exists, null otherwise
*/
export function GetAttributeReferenceId(attributePath: string | null) : string | null;

/**
* Returns all Attributes of the Configuration Object referenced by the given Long Distance-Path as an Array
*
* @example
* PCL.GetAttributes("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Array of all Attribute Identifiers if the Configuration Object exists, empty Array otherwise
*/
export function GetAttributes(objectPath: string | null) : (string)[];

/**
* Return the Step Width of the given Attribute
*
* @example
* PCL.GetAttributeStepWidth("A_TEMPERATURE");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The Step Width if the Attribute exists, null otherwise
*/
export function GetAttributeStepWidth(attributePath: string | null) : number | null;

/**
* GetAttributeTableChangeToken
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function GetAttributeTableChangeToken(attributePath: string | null) : string | null;

/**
* GetAttributeTableId
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function GetAttributeTableId(attributePath: string | null) : string | null;

/**
* Returns type code fragments of all selected Values of the given Attribute as directly joined string
*
* @example
* PCL.GetAttributeTypeCode("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The type code fragments of all selected Values of the Attribute as directly joined string if it exists and at least one of its Values is selected, null otherwise
*/
export function GetAttributeTypeCode(attributePath: string | null) : string | null;

/**
* EXPERIMENTAL FUNCTION!
*     Returns the selected Unit Group Identifier of the given Attribute
*     Notice: The Unit Group Identifier references a specific list of Units which can be selected by user together with value of attribute
*
* @example
* PCL.GetAttributeUnitGroupId("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns Unit Group Identifier if the Attribute exists, null otherwise
*/
export function GetAttributeUnitGroupId(attributePath: string | null) : string | null;

/**
* Returns the Unit Identifier of the given Attribute
*     Notice: The Unit Identifier is the content of column "Id" of a dataset of the table "PC_Units", which contains all available units
*
* @example
* PCL.GetAttributeUnitId("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns Unit Identifier if the Attribute exists, null otherwise
*/
export function GetAttributeUnitId(attributePath: string | null) : string | null;

/**
* Returns the Bill Of Material of Root Configuration Object (i.e. starting point of configuration process) as an Object
*
* @example
* PCL.GetBom();
*
* @returns Object containing data of Bill Of Material of Root Configuration Object (i.e. starting point of configuration process)
*/
export function GetBom() : ConfigurationBom;

/**
* Returns the Value of the given Key assigned to the overall Cache of the application as a JSON object.
*
* @example
* PCL.GetCacheObject("userData");
*
* @param key - Key
* @returns An object of key/value pairs provided by the Value of the given Key assigned to the overall Cache of the application, null otherwise
*/
export function GetCacheObject(key: string | null) : any;

/**
* Returns the Value of the given Key assigned to the overall Cache of the application
*
* @example
* PCL.GetCacheValue("standard");
*
* @param key - Key
* @returns Value of the given Key assigned to the overall Cache of the application, null otherwise
*/
export function GetCacheValue(key: string | null) : string | null;

/**
* Returns all Context data, which can get passed by an external application when starting the configuration process, as an object (key/value pairs)
*
* @example
* PCL.GetContext();
*
* @returns An object of key/value pairs containing Context data, which got passed by an external application when starting the configuration process, an empty object if no such data got passed
*/
export function GetContext() : Record<string, boolean | number | string | null>;

/**
* Returns the Value of the given Key of Context data, which can get passed by an external application when starting the configuration process, as a JSON object.
*
* @example
* PCL.GetContextObject("userData");
*
* @param key - Key of Context data
* @returns An object of key/value pairs provided by the Value of the Key of Context data, which can get passed by an external application when starting the configuration process, null if respective data aren't available
*/
export function GetContextObject(key: string | null) : any;

/**
* Returns the Value of the given Key of Context data, which can get passed by an external application when starting the configuration process
*
* @example
* PCL.GetContextValue("userName");
*
* @param key - Key of Context data
* @returns The Value of the Key of Context data if it's available, null otherwise
*/
export function GetContextValue(key: string | null) : boolean | number | string | null;

/**
* GetCurrencySymbol
*
* @param currencyId - The parameter currencyId.
* @returns The return value.
*/
export function GetCurrencySymbol(currencyId: string | null) : string | null;

/**
* Returns the Attribute currently evaluated by the user
*
* @example
* PCL.GetCurrentAttribute();
*
* @returns The Attribute Identifier of the Attribute currently evaluated by the user
*/
export function GetCurrentAttribute() : string;

/**
* GetCurrentChange
*
* @returns The return value.
*/
export function GetCurrentChange() : ConfigurationChange | null;

/**
* Returns the State of Configuration of the currently running configuration as an Object
*
* @example
* PCL.GetCurrentObject();
*
* @returns Object containing data of State of Configuration of the currently running configuration
*/
export function GetCurrentObject() : ConfigurationObject;

/**
* Returns the unique identifier of the currently running configuration. The engine generates it during creation of this Configuration Object, except it's the copy of an existing one triggered by the user. In this case, the same Guid gets copied, too
*
* @example
* PCL.GetCurrentObjectGuid();
*
* @returns Unique identifier of the currently running configuration
*/
export function GetCurrentObjectGuid() : string;

/**
* Returns the Configuration Object Identifier of the currently running configuration
*
* @example
* PCL.GetCurrentObjectId();
*
* @returns Configuration Object Identifier of the currently running configuration
*/
export function GetCurrentObjectId() : string;

/**
* Returns the Index of Configuration Object in the currently running configuration
*
* @example
* PCL.GetCurrentObjectIndex();
*
* @returns Configuration Object Index if it was successful, 0 otherwise
*/
export function GetCurrentObjectIndex() : number;

/**
* Returns the Long Distance-Path of the currently running configuration
*
* @example
* PCL.GetCurrentObjectPath();
*
* @returns Long Distance-Path (absolute) of the currently running configuration
*/
export function GetCurrentObjectPath() : string;

/**
* Returns the TypeCode of the currently running configuration
*
* @example
* PCL.GetCurrentObjectTypeCode();
*
* @returns String of TypeCode of the currently running configuration
*/
export function GetCurrentObjectTypeCode() : string | null;

/**
* Returns an Array of objects providing information on all elements from which the TypeCode of the currently running configuration is composed
*
* @example
* PCL.GetCurrentObjectTypeCodeElements();
*
* @returns Array of objects providing information on all elements from which the TypeCode of the currently running configuration is composed
*/
export function GetCurrentObjectTypeCodeElements() : (ConfigurationTypeCodeElement)[] | null;

/**
* Returns the template for composition of TypeCode of the currently running configuration assigned via the Data Manager
*
* @example
* PCL.GetRootObjectTypeCode();
*
* @returns String of the template for composition of TypeCode of the currently running configuration
*/
export function GetCurrentObjectTypeCodeTemplate() : string | null;

/**
* GetCurrentProduct
*
* @returns The return value.
*/
export function GetCurrentProduct() : ConfigurationProduct | null;

/**
* GetCurrentProductId
*
* @returns The return value.
*/
export function GetCurrentProductId() : string | null;

/**
* GetCustomRestoreResult
*
* @returns The return value.
*/
export function GetCustomRestoreResult() : ConfigurationRestoreResult | null;

/**
* GetCustomSave
*
* @returns The return value.
*/
export function GetCustomSave() : ConfigurationSave | null;

/**
* GetCustomTable
*
* @returns The return value.
*/
export function GetCustomTable() : ConfigurationTable | null;

/**
* GetCustomTypeCode
*
* @returns The return value.
*/
export function GetCustomTypeCode() : string | null;

/**
* GetCustomTypeCodeAnalysisOptions
*
* @returns The return value.
*/
export function GetCustomTypeCodeAnalysisOptions() : ConfigurationTypeCodeAnalysisOptions | null;

/**
* GetCustomTypeCodeAnalysisResult
*
* @returns The return value.
*/
export function GetCustomTypeCodeAnalysisResult() : ConfigurationTypeCodeAnalysisResult | null;

/**
* Returns the Database Provider representing the type of database with the given databaseId
*
* @example
* PCL.GetDatabaseProvider("EXTERNAL_DATA");
*
* @param databaseId - Long Distance-Path
* @returns Database Provider of database with the databaseId
*/
export function GetDatabaseProvider(databaseId: string | null) : string | null;

/**
* Returns all Values of the given Attribute, which are marked as Default, as an Array
*
* @example
* PCL.GetDefaultValues("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns Array of all Default values if the Attribute exists, empty Array otherwise
*/
export function GetDefaultValues(attributePath: string | null) : (boolean | number | string | null)[];

/**
* GetDrawing
*
* @returns The return value.
*/
export function GetDrawing() : ConfigurationDrawing;

/**
* GetDrawingConnections
*
* @returns The return value.
*/
export function GetDrawingConnections() : (ConfigurationConnection)[];

/**
* GetDrawingInstances
*
* @returns The return value.
*/
export function GetDrawingInstances() : (ConfigurationInstance)[];

/**
* GetDrawingLayers
*
* @returns The return value.
*/
export function GetDrawingLayers() : (ConfigurationLayer)[];

/**
* GetDrawingObjectConnections
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetDrawingObjectConnections(objectPath: string | null) : (ConfigurationConnection)[];

/**
* GetDrawingObjectInstances
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetDrawingObjectInstances(objectPath: string | null) : (ConfigurationInstance)[];

/**
* GetDrawingObjectLayers
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetDrawingObjectLayers(objectPath: string | null) : (ConfigurationLayer)[];

/**
* GetDrawingObjectSubConnections
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetDrawingObjectSubConnections(objectPath: string | null) : (ConfigurationSubConnection)[];

/**
* GetDrawingObjectTexts
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetDrawingObjectTexts(objectPath: string | null) : (ConfigurationText)[];

/**
* GetDrawingSubConnections
*
* @returns The return value.
*/
export function GetDrawingSubConnections() : (ConfigurationSubConnection)[];

/**
* GetDrawingTexts
*
* @returns The return value.
*/
export function GetDrawingTexts() : (ConfigurationText)[];

/**
* Returns the Identifiers of ALL Attributes, which belong to the given Attribute Group as an Array
*
* @example
* PCL.GetGroupAttributes("CONFIG_ATTR_GROUP_PERFORMANCE");
*
* @param groupPath - Attribute Group Identifier
* @returns Array of the Identifiers of all Attributes, which belong to the Attribute Group, if it exists in the currently running configuration, empty Array otherwise
*/
export function GetGroupAttributes(groupPath: string | null) : (string)[];

/**
* Returns the Reference Identifier, which can be provided by an external system (e.g. PIM) during import of the given Attribute Group via the Data Manager
*
* @example
* PCL.GetGroupReferenceId("CONFIG_ATTR_GROUP_PERFORMANCE");
*
* @param groupId - Attribute Group Identifier
* @returns The Reference Identifier if the Attribute Group exists, null otherwise
*/
export function GetGroupReferenceId(groupId: string | null) : string | null;

/**
* Returns all Attribute Groups of the Configuration Object referenced by the given Long Distance-Path as an Array
*
* @example
* PCL.GetGroups("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Array of names of all Attribute Groups, defined as Dictionary Identifiers, if the Configuration Object exists, empty Array otherwise
*/
export function GetGroups(objectPath: string | null) : (string)[];

/**
* GetInfoConfiguratorVersion
*
* @returns The return value.
*/
export function GetInfoConfiguratorVersion() : string;

/**
* GetInfoReleaseDate
*
* @returns The return value.
*/
export function GetInfoReleaseDate() : string;

/**
* GetInfoReleaseId
*
* @returns The return value.
*/
export function GetInfoReleaseId() : string;

/**
* GetInfoReleaseNotes
*
* @returns The return value.
*/
export function GetInfoReleaseNotes() : string;

/**
* GetInfoReleaseVersion
*
* @returns The return value.
*/
export function GetInfoReleaseVersion() : string;

/**
* GetInfoSaveVersion
*
* @returns The return value.
*/
export function GetInfoSaveVersion() : string;

/**
* Returns the Input Value of the given Input if it is assigned to the currently running configuration as a JSON object
*
* @example
* PCL.GetInputObject("priorityData");
*
* @param key - Input Identifier
* @returns An object with data of Input Value if it was successful, null otherwise
*/
export function GetInputObject(key: string | null) : any;

/**
* Returns ALL Inputs assigned to the currently running configuration and their Input Values as an object (key/value pairs)
*
* @example
* PCL.GetInputs();
*
* @returns An object of key/value pairs containing the Input Values of all Inputs assigned to the currently running configuration if it was successful, an empty object otherwise
*/
export function GetInputs() : Record<string, boolean | number | string | null>;

/**
* Returns the Input Value of the given Input if it is assigned to the currently running configuration
*
* @example
* // Parent object:
*     PCL.SetObjectInputValue("XAS_EXT_DEVICES/0", "priority", "high", false);
*     // Child object:
*     PCL.GetInputValue("priority");
*
* @param key - Input Identifier
* @returns The Input Value if Input is assigned to the currently running configuration, null otherwise
*/
export function GetInputValue(key: string | null) : boolean | number | string | null;

/**
* GetKnowledgeBaseId
*
* @returns The return value.
*/
export function GetKnowledgeBaseId() : string;

/**
* GetKnowledgeBaseWorkspaceId
*
* @returns The return value.
*/
export function GetKnowledgeBaseWorkspaceId() : string;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Returns the error message of the most recently performed Database Execution. Thus, it only makes sense to call this function immediately after performance of a Database Execution to avoid that inappropriate message gets returned.
*
* @example
* PCL.GetLastDatabaseError();
*
* @returns Error message of the most recently performed Database Execution
*/
export function GetLastDatabaseError() : string | null;

/**
* Returns the Language Identifier of the currently activated language
*
* @example
* PCL.GetLocaleId();
*
* @returns Language Identifier of the currently activated language
*/
export function GetLocaleId() : string;

/**
* GetMessages
*
* @returns The return value.
*/
export function GetMessages() : (ConfigurationMessage)[];

/**
* GetNextAttributes
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function GetNextAttributes(attributePath: string | null) : (string)[];

/**
* For this function to work, the given Long Distance-Path must reference an existing instance of a Configuration Object.
*     Returns the next Attribute from the top of the Configuration Object, which is tagged as "Required" but not yet evaluated
*
* @description
* The tag "Required" means, that a Value of the Attribute must be assigned (selected) so it gets considered as evaluated, which is necessary to complete the Configuration.
*
* @example
* PCL.GetNextRequiredAttribute("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns next Attribute, which is tagged as "Required" but not yet evaluated, null otherwise
*/
export function GetNextRequiredAttribute(objectPath: string | null) : string | null;

/**
* GetObjectAttachmentCount
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetObjectAttachmentCount(objectPath: string | null) : number;

/**
* GetObjectAttachmentPath
*
* @param objectPath - The parameter objectPath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function GetObjectAttachmentPath(objectPath: string | null, attachmentId: string | null) : string | null;

/**
* GetObjectAttachments
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetObjectAttachments(objectPath: string | null) : Record<string, string | null>;

/**
* GetObjectAttachmentTags
*
* @param objectPath - The parameter objectPath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function GetObjectAttachmentTags(objectPath: string | null, attachmentId: string | null) : (string)[] | null;

/**
* Returns the translated description of the given Configuration Object Identifier in language of the given Language Identifier.
*     The description of the Configuration Object Identifier represents the descriptive text, which is assigned to the Configuration Object via the Data Manager.
*     Notice: The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetObjectDescriptionTranslation("CFG_NOTEBOOK", "en-US");
*
* @param objectId - Configuration Object Identifier
* @param localeId - Language Identifier
* @returns Translated description of the Configuration Object Identifier in language of the Language Identifier, if the Configuration Object Identifier exists and the Language Identifier is valid, otherwise the unchanged Configuration Object Identifier
*/
export function GetObjectDescriptionTranslation(objectId: string | null, localeId: string | null) : string;

/**
* Returns the unique identifier of the Configuration Object referenced by the given Long Distance-Path. The engine generates it during creation of this Configuration Object which is not a copying processed triggered by the user
*
* @example
* PCL.GetObjectGuid("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Unique identifier if the Configuration Object exists, null otherwise
*/
export function GetObjectGuid(objectPath: string | null) : string | null;

/**
* Returns the Configuration Object Identifier of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Configuration Object Identifier if the Configuration Object exists, null otherwise
*/
export function GetObjectId(objectPath: string | null) : string | null;

/**
* Returns the Image Path (URL) of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectImage("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Image Path (URL) if the Configuration Object exists, null otherwise
*/
export function GetObjectImage(objectPath: string | null) : string | null;

/**
* Returns the Index of Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectIndex("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Configuration Object Index if it was successful, 0 otherwise
*/
export function GetObjectIndex(objectPath: string | null) : number;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Returns the Input Value of the given Input if it is assigned to the Configuration Object referenced by the given Long Distance-Path as a JSON object
*
* @example
* PCL.GetObjectInputObject("XAS_EXT_DEVICES/0", "priorityData");
*
* @param objectPath - Long Distance-Path
* @param key - Input Identifier
* @returns An object with data of Input Value if it was successful, null otherwise
*/
export function GetObjectInputObject(objectPath: string | null, key: string | null) : any;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Returns ALL Inputs and their Input Values assigned to the Configuration Object, which is referenced by the given Long Distance-Path, as an object (key/value pairs)
*
* @example
* PCL.GetObjectInputs("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns An object of key/value pairs containing the Input Values of all Inputs assigned to the Configuration Object if it was successful, an empty object otherwise
*/
export function GetObjectInputs(objectPath: string | null) : Record<string, boolean | number | string | null>;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Returns the Input Value of the given Input if it is assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* // Parent object:
*     PCL.SetObjectInputValue("XAS_EXT_DEVICES/0", "priority", "high", false);
*     // Child object:
*     PCL.GetObjectInputValue(".", "priority");
*
* @param objectPath - Long Distance-Path
* @param key - Input Identifier
* @returns The Input Value if Input is assigned, null otherwise
*/
export function GetObjectInputValue(objectPath: string | null, key: string | null) : boolean | number | string | null;

/**
* Returns the mass of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectMass("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns mass as numeric value if the Configuration Object exists, null otherwise
*/
export function GetObjectMass(objectPath: string | null) : number | null;

/**
* Returns the Unit Identifier of mass of the Configuration Object referenced by the given Long Distance-Path
*     Notice: The Unit Identifier is the content of column "Id" of a dataset of the table "PC_Units", which contains all available units
*
* @example
* PCL.GetObjectMassUnitId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Unit Identifier of mass if the Configuration Object exists, null otherwise
*/
export function GetObjectMassUnitId(objectPath: string | null) : string | null;

/**
* Returns the translated name of the given Configuration Object Identifier in language of the given Language Identifier.
*     The name of the Configuration Object Identifier represents the string being displayed in the user interface for the Configuration Object.
*     Notice: The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetObjectNameTranslation("CFG_NOTEBOOK", "en-US");
*
* @param objectId - Configuration Object Identifier
* @param localeId - Language Identifier
* @returns Translated name of the Configuration Object Identifier in language of the Language Identifier, if the Configuration Object Identifier exists and the Language Identifier is valid, otherwise the unchanged Configuration Object Identifier
*/
export function GetObjectNameTranslation(objectId: string | null, localeId: string | null) : string;

/**
* Returns the Output Value of the given Output if it is assigned to the Configuration Object referenced by the given Long Distance-Path as a JSON object
*
* @example
* PCL.GetObjectOutputObject("XAS_EXT_DEVICES/0", "priorityData");
*
* @param objectPath - Long Distance-Path
* @param key - Output Identifier
* @returns An object with data of Output Value if it was successful, null otherwise
*/
export function GetObjectOutputObject(objectPath: string | null, key: string | null) : any;

/**
* Returns all Outputs and their Output Values assigned to the Configuration Object, which is referenced by the given Long Distance-Path, as an object (key/value pairs)
*
* @example
* PCL.GetObjectOutputs("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns An object of key/value pairs containing the Output Values of all Outputs assigned to the Configuration Object if it was successful, an empty object otherwise
*/
export function GetObjectOutputs(objectPath: string | null) : Record<string, boolean | number | string | null>;

/**
* Returns the Output Value of the given Output if it is assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectOutputValue("XAS_EXT_DEVICES/0", "priority");
*
* @param objectPath - Long Distance-Path
* @param key - Output Identifier
* @returns The Output Value if Output is assigned, null otherwise
*/
export function GetObjectOutputValue(objectPath: string | null, key: string | null) : boolean | number | string | null;

/**
* Returns the part class name of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectPartClass("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns part class name if the Configuration Object exists, null otherwise
*/
export function GetObjectPartClass(objectPath: string | null) : string | null;

/**
* Returns the part Identifier of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectPartId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns part Identifier if the Configuration Object exists, null otherwise
*/
export function GetObjectPartId(objectPath: string | null) : string | null;

/**
* Returns the Long Distance-Path of the given Configuration Object Path
*
* @example
* PCL.GetObjectPath("/XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Long Distance-Path (absolute) if the Configuration Object exists, null otherwise
*/
export function GetObjectPath(objectPath: string | null) : string | null;

/**
* Returns the Long Distance-Path of the Configuration Object referenced by the given unique identifier
*
* @example
* PCL.GetObjectPathByGuid("0aceb854-7d86-496a-be6b-48afcb046747");
*
* @param objectGuid - unique identifier of Configuration Object
* @returns Long Distance-Path if the Configuration Object referenced by the unique identifier exists, null otherwise
*/
export function GetObjectPathByGuid(objectGuid: string | null) : string | null;

/**
* Returns price of the Configuration Object referenced by the given Long Distance-Path.
*     Second parameter "priceType" is optional. If given, respective price must have been set by call of function "SetObjectPrice" with the same "priceType" passed.
*
* @example
* PCL.GetObjectPrice("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @param priceType - price type
* @returns Price as numeric value if the Configuration Object exists, null otherwise
*/
export function GetObjectPrice(objectPath: string | null, priceType: string | null) : number | null;

/**
* GetObjectPriceId
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function GetObjectPriceId(objectPath: string | null) : string | null;

/**
* Returns Currency Identifier, which gets converted to currency symbol for displaying it, of price of the Configuration Object referenced by the given Long Distance-Path.
*     The Currency Identifier must be the content of column "Id" of the dataset of table "PC_Currencies" (contains all available currencies), which represents respective currency.
*     Second parameter "priceType" is optional. If given, Currency Identifier must have been set by call of function "SetObjectPriceUnitId" with the same "priceType" passed.
*
* @example
* PCL.GetObjectPriceUnitId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @param priceType - price type
* @returns Currency Identifier of price if the Configuration Object exists, null otherwise
*/
export function GetObjectPriceUnitId(objectPath: string | null, priceType: string | null) : string | null;

/**
* Returns all Properties and their Property Values assigned to the Configuration Object, which is referenced by the given Long Distance-Path, as an object (key/value pairs)
*
* @example
* PCL.GetObjectProperties("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns An object of key/value pairs containing the Property Values of all Properties assigned to the Configuration Object if it was successful, an empty object otherwise
*/
export function GetObjectProperties(objectPath: string | null) : Record<string, boolean | number | string | null>;

/**
* Returns the number Properties assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectPropertyCount("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns number of Properties (int) assigned to the Configuration Object if it was successful, 0 (int) otherwise
*/
export function GetObjectPropertyCount(objectPath: string | null) : number;

/**
* Returns the translated Description of the Configuration Object Property in language of the given Language Identifier.
*     The description of the Configuration Object Property represents the descriptive text, which is assigned to the Property of the Configuration Object via the Data Manager.
*     Notice: The fourth parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetObjectPropertyDescriptionTranslation("CFG_NOTEBOOK", "auxiliaryInfo", "en-US");
*
* @param objectId - Configuration Object Identifier
* @param propertyId - Property Identifier
* @param propertyValue - Property Value
* @param localeId - Language Identifier
* @returns Translated Description of the Configuration Object Property in language of the Language Identifier, if the Configuration Object Property exists and the Language Identifier is valid, otherwise the unchanged Configuration Object Property
*/
export function GetObjectPropertyDescriptionTranslation(objectId: string | null, propertyId: string | null, propertyValue: boolean | number | string | null, localeId: string | null) : string;

/**
* Returns the translated Name of the Configuration Object Property in language of the given Language Identifier.
*     Notice: The fourth parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetObjectPropertyNameTranslation("CFG_NOTEBOOK", "auxiliaryInfo", "en-US");
*
* @param objectId - Configuration Object Identifier
* @param propertyId - Property Identifier
* @param propertyValue - Property Value
* @param localeId - Language Identifier
* @returns Translated name of the Configuration Object Property in language of the Language Identifier, if the Configuration Object Property exists and the Language Identifier is valid, otherwise the unchanged Configuration Object Property
*/
export function GetObjectPropertyNameTranslation(objectId: string | null, propertyId: string | null, propertyValue: boolean | number | string | null, localeId: string | null) : string;

/**
* Returns the Property Value of the given Property if it is assigned to the Configuration Object referenced by the given Long Distance-Path as a JSON object
*
* @example
* PCL.GetObjectPropertyObject("XAS_EXT_DEVICES/0", "property");
*
* @param objectPath - Long Distance-Path
* @param propertyId - Property Identifier
* @returns An object with data of Property Value if it was successful, null otherwise
*/
export function GetObjectPropertyObject(objectPath: string | null, propertyId: string | null) : any;

/**
* Returns the Property Value of the given Property if it is assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectPropertyValue("XAS_EXT_DEVICES/0", "Quantity");
*
* @param objectPath - Long Distance-Path
* @param propertyId - Property Identifier
* @returns The Property Value if Property is assigned, null otherwise
*/
export function GetObjectPropertyValue(objectPath: string | null, propertyId: string | null) : boolean | number | string | null;

/**
* Returns the quantity of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectQuantity("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns quantity as numeric value, if the Configuration Object exists, null otherwise
*/
export function GetObjectQuantity(objectPath: string | null) : number | null;

/**
* Returns the Unit Identifier of quantity of the Configuration Object referenced by the given Long Distance-Path.
*     Notice: The Unit Identifier is the content of column "Id" of a dataset of the table "PC_Units", which contains all available units
*
* @example
* PCL.GetObjectQuantityUnitId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Unit Identifier of quantity if the Configuration Object exists, null otherwise
*/
export function GetObjectQuantityUnitId(objectPath: string | null) : string | null;

/**
* Returns the Recommendation Score of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectRecommendationScore("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns The Recommendation Score as a number (double) if the Configuration Object exists, 0 otherwise
*/
export function GetObjectRecommendationScore(objectPath: string | null) : number;

/**
* Returns the Reference Identifier, which can be provided by an external system (e.g. PIM) during import of the Configuration Object referenced by the given Long Distance-Path via the Data Manager
*
* @example
* PCL.GetObjectReferenceId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns The Reference Identifier if the Configuration Object exists, null otherwise
*/
export function GetObjectReferenceId(objectPath: string | null) : string | null;

/**
* Returns the TypeCode of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.GetObjectTypeCode("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns String of TypeCode of the Configuration Object if it exists, null otherwise
*/
export function GetObjectTypeCode(objectPath: string | null) : string | null;

/**
* Returns an Array of objects providing information on all elements from which the TypeCode of the Configuration Object referenced by the given Long Distance-Path is composed
*
* @example
* PCL.GetObjectTypeCodeElements("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Array of objects providing information on all elements from which the TypeCode of the Configuration Object referenced by the Long Distance-Path is composed
*/
export function GetObjectTypeCodeElements(objectPath: string | null) : (ConfigurationTypeCodeElement)[] | null;

/**
* Returns the template for composition of TypeCode of the Configuration Object referenced by the given Long Distance-Path assigned via the Data Manager
*
* @example
* PCL.GetObjectTypeCodeTemplate("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns String of the template for composition of TypeCode of the Configuration Object if it exists, null otherwise
*/
export function GetObjectTypeCodeTemplate(objectPath: string | null) : string | null;

/**
* Returns the Value of the given Variable Key assigned to the Configuration Object, which is referenced by the given Long Distance-Path, as a JSON object.
*
* @example
* PCL.GetObjectVariableObject("XAS_EXT_DEVICES/0", "userData");
*
* @param objectPath - Long Distance-Path
* @param key - Variable Key
* @returns An object of key/value pairs provided by the Value of the Variable Key assigned to the Configuration Object if it was successful, null otherwise
*/
export function GetObjectVariableObject(objectPath: string | null, key: string | null) : any;

/**
* Returns all Variables assigned to the Configuration Object, which is referenced by the given Long Distance-Path, as an object (key/value pairs).
*
* @example
* PCL.GetObjectVariables("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns An object of key/value pairs containing all Variables assigned to the Configuration Object if it was successful, an empty object otherwise
*/
export function GetObjectVariables(objectPath: string | null) : Record<string, boolean | number | string | null>;

/**
* Returns the Value of the given Variable Key assigned to the Configuration Object, which is referenced by the given Long Distance-Path.
*
* @example
* PCL.GetObjectVariableValue("XAS_EXT_DEVICES/0", "priority");
*
* @param objectPath - Long Distance-Path
* @param key - Variable Key
* @returns The Value of the Variable Key assigned to the Configuration Object if it was successful, null otherwise
*/
export function GetObjectVariableValue(objectPath: string | null, key: string | null) : boolean | number | string | null;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Returns the Output Value of the given Output if it is assigned to the currently running configuration as a JSON object
*
* @example
* PCL.GetOutputObject("priorityData");
*
* @param key - Output Identifier
* @returns An object with data of Output Value if it was successful, null otherwise
*/
export function GetOutputObject(key: string | null) : any;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Returns ALL Outputs assigned to the currently running configuration and their Output Values as an object (key/value pairs)
*
* @example
* PCL.GetOutputs();
*
* @returns An object of key/value pairs containing the Output Values of all Outputs assigned to the currently running configuration if it was successful, an empty object otherwise
*/
export function GetOutputs() : Record<string, boolean | number | string | null>;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Returns the Output Value of the given Output if it is assigned to the currently running configuration
*
* @example
* PCL.GetOutputValue("priority");
*
* @param key - Output Identifier
* @returns The Output Value if Output is assigned to the currently running configuration, null otherwise
*/
export function GetOutputValue(key: string | null) : boolean | number | string | null;

/**
* GetPathBase
*
* @param path - The parameter path.
* @returns The return value.
*/
export function GetPathBase(path: string | null) : string;

/**
* GetPathName
*
* @param path - The parameter path.
* @returns The return value.
*/
export function GetPathName(path: string | null) : string;

/**
* GetPathRootedBase
*
* @param path - The parameter path.
* @returns The return value.
*/
export function GetPathRootedBase(path: string | null) : string;

/**
* GetPreviousAttributes
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function GetPreviousAttributes(attributePath: string | null) : (string)[];

/**
* Returns the first dataset from the database table of prices which meets all conditions defined by the given parameters.
*     Conditions are considered as met for all datasets in the database table of prices, which don't provide a value in relevant columns.
*
* @example
* PCL.GetPrice("PRICE_STD_HARDDISK", "COMMON", "US", "internalSales", "USD", 4);
*
* @param priceId - Price Identifier
* @param priceType - Price Type Identifier
* @param region - Region Identifier
* @param customer - Customer Identifier
* @param unitId - Currency Identifier
* @param quantity - Quantity
* @returns Object with data of first dataset from the database table of prices which meets all conditions defined by the given parameters
*/
export function GetPrice(priceId: string | null, priceType: string | null, region: string | null, customer: string | null, unitId: string | null, quantity: number | null) : ConfigurationPrice | null;

/**
* GetPriceListId
*
* @returns The return value.
*/
export function GetPriceListId() : string | null;

/**
* Returns all datasets from the database table of prices which meet all conditions defined by the given parameters as array of objects.
*     Conditions are considered as met for all datasets in the database table of prices, which don't provide a value in relevant columns.
*
* @example
* PCL.GetPrices("PRICE_STD_HARDDISK", "US", "internalSales", "USD", 4);
*
* @param priceId - Price Identifier
* @param region - Region Identifier
* @param customer - Customer Identifier
* @param unitId - Currency Identifier
* @param quantity - Quantity
* @returns Array of objects providing data of all datasets from the database table of prices which meet all conditions defined by the given parameters
*/
export function GetPrices(priceId: string | null, region: string | null, customer: string | null, unitId: string | null, quantity: number | null) : (ConfigurationPrice)[] | null;

/**
* GetProduct
*
* @param productId - The parameter productId.
* @returns The return value.
*/
export function GetProduct(productId: string | null) : ConfigurationProduct | null;

/**
* GetProductDescriptionTranslation
*
* @param productId - The parameter productId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetProductDescriptionTranslation(productId: string | null, localeId: string | null) : string;

/**
* GetProductNameTranslation
*
* @param productId - The parameter productId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetProductNameTranslation(productId: string | null, localeId: string | null) : string;

/**
* GetProductPropertyDescriptionTranslation
*
* @param productId - The parameter productId.
* @param propertyId - The parameter propertyId.
* @param propertyValue - The parameter propertyValue.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetProductPropertyDescriptionTranslation(productId: string | null, propertyId: string | null, propertyValue: boolean | number | string | null, localeId: string | null) : string;

/**
* GetProductPropertyNameTranslation
*
* @param productId - The parameter productId.
* @param propertyId - The parameter propertyId.
* @param propertyValue - The parameter propertyValue.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetProductPropertyNameTranslation(productId: string | null, propertyId: string | null, propertyValue: boolean | number | string | null, localeId: string | null) : string;

/**
* Returns all Attributes of the Configuration Object referenced by the given Long Distance-Path, which are either tagged as "Read Only" (readOnly = true) or not (readOnly = false) as an Array
*
* @example
* PCL.GetReadOnlyAttributes("/XAS_EXT_DEVICES/0", true);
*
* @param objectPath - Long Distance-Path
* @param readOnly - true or false
* @returns Array of all Attribute Identifiers, which are either tagged as "Read Only" (readOnly = true) or not (readOnly = false), if the Configuration Object exists, empty Array otherwise
*/
export function GetReadOnlyAttributes(objectPath: string | null, readOnly: boolean) : (string)[];

/**
* Returns the State of Configuration of the Root Configuration Object (i.e. starting point of configuration process) as an Object
*
* @example
* PCL.GetRootObject();
*
* @returns Object containing data of State of Configuration of the Root Configuration Object (i.e. starting point of configuration process)
*/
export function GetRootObject() : ConfigurationObject;

/**
* Returns the Configuration Object Identifier of the Root Configuration Object (i.e. starting point of configuration process)
*
* @example
* PCL.GetRootObjectId();
*
* @returns Configuration Object Identifier of the Root Configuration Object
*/
export function GetRootObjectId() : string;

/**
* Returns the Long Distance-Path of the Root Configuration Object (i.e. starting point of configuration process)
*
* @example
* PCL.GetRootObjectPath();
*
* @returns Long Distance-Path of the Root Configuration Object
*/
export function GetRootObjectPath() : string;

/**
* Returns the TypeCode of the Root Configuration Object (i.e. starting point of configuration process)
*
* @example
* PCL.GetRootObjectTypeCode();
*
* @returns String of TypeCode of the Root Configuration Object (i.e. starting point of configuration process)
*/
export function GetRootObjectTypeCode() : string | null;

/**
* Returns an Array of objects providing information on all elements from which the TypeCode of the Root Configuration Object (i.e. starting point of configuration process) is composed
*
* @example
* PCL.GetRootObjectTypeCodeElements();
*
* @returns Array of objects providing information on all elements from which the TypeCode of the Root Configuration Object (i.e. starting point of configuration process) is composed
*/
export function GetRootObjectTypeCodeElements() : (ConfigurationTypeCodeElement)[] | null;

/**
* Returns the template for composition of TypeCode of the Root Configuration Object (i.e. starting point of configuration process) assigned via the Data Manager
*
* @example
* PCL.GetRootObjectTypeCode();
*
* @returns String of TypeCode of the Root Configuration Object (i.e. starting point of configuration process)
*/
export function GetRootObjectTypeCodeTemplate() : string | null;

/**
* Returns all data of the Security Context, which get composed by the system when starting the configuration process, as an object (key/value pairs)
*
* @example
* PCL.GetSecurityContext();
*
* @returns An object of key/value pairs containing Security Context, which get composed by the system when starting the configuration process
*/
export function GetSecurityContext() : Record<string, boolean | number | string | null> | null;

/**
* Returns the Value of the given Key of Security Context data, which get composed by the system when starting the configuration process, as a JSON object.
*
* @example
* PCL.GetSecurityContextObject("User");
*
* @param key - Key of Security Context data
* @returns An object of key/value pairs provided by the Value of the Key of Security Context data, which get composed by the system when starting the configuration process, null if respective data aren't available
*/
export function GetSecurityContextObject(key: string | null) : any;

/**
* Returns the Value of the given Key of Security Context data, which get composed by the system when starting the configuration process
*
* @example
* PCL.GetSecurityContextValue("User");
*
* @param key - Key of Context data
* @returns The Value of the Key of Security Context data if it's available, null otherwise
*/
export function GetSecurityContextValue(key: string | null) : boolean | number | string | null;

/**
* Returns the selected Value of the given Attribute
*
* @example
* PCL.GetSelectedValue("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The selected Value if the Attribute exists and is evaluated, null otherwise
*/
export function GetSelectedValue(attributePath: string | null) : boolean | number | string | null;

/**
* Returns the selected Values of the given Attribute as an Array
*
* @example
* PCL.GetSelectedValues("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns Array of the selected Values if the Attribute exists and is evaluated, empty Array otherwise
*/
export function GetSelectedValues(attributePath: string | null) : (boolean | number | string | null)[];

/**
* GetStateAttachmentCount
*
* @returns The return value.
*/
export function GetStateAttachmentCount() : number;

/**
* GetStateAttachmentPath
*
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function GetStateAttachmentPath(attachmentId: string | null) : string | null;

/**
* GetStateAttachments
*
* @returns The return value.
*/
export function GetStateAttachments() : Record<string, string | null>;

/**
* GetStateAttachmentTags
*
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function GetStateAttachmentTags(attachmentId: string | null) : (string)[] | null;

/**
* Returns all Properties assigned to the State of configuration and their Property Values as an object (key/value pairs)
*
* @example
* PCL.GetStateProperties();
*
* @returns An object of key/value pairs containing the Property Values of all Properties assigned to the State of configuration
*/
export function GetStateProperties() : Record<string, boolean | number | string | null>;

/**
* Returns the number of Properties assigned to the State of configuration
*
* @example
* PCL.GetStatePropertyCount();
*
* @returns The number of Properties (int) assigned to the State of configuration
*/
export function GetStatePropertyCount() : number;

/**
* Returns the Property Value of the given Property Identifier if it is assigned to the State of configuration as a JSON object
*
* @example
* PCL.GetStatePropertyObject("auxiliaryData");
*
* @param propertyId - Property Identifier
* @returns An object with data of Property Value if it was successful, null otherwise
*/
export function GetStatePropertyObject(propertyId: string | null) : any;

/**
* Returns the Property Value of the given Property Identifier if it is assigned to the State of configuration
*
* @example
* PCL.GetStatePropertyValue("priority");
*
* @param propertyId - Property Identifier
* @returns The Property Value if Property Identifier is assigned, null otherwise
*/
export function GetStatePropertyValue(propertyId: string | null) : boolean | number | string | null;

/**
* Returns ALL key/value pairs of the Store as an object.
*
* @example
* PCL.GetStore();
*
* @returns An object containing all key/value pairs of the Store if it was successful, an empty object otherwise
*/
export function GetStore() : Record<string, boolean | number | string | null>;

/**
* Returns the Value of the key/value pair, identified by the given Key, from the Store as a JSON object.
*
* @example
* PCL.GetStoreObject("UserData");
*
* @param key - Store Key
* @returns An object with data of Value if key/value pair identified by the Key exists in the Store, null otherwise
*/
export function GetStoreObject(key: string | null) : any;

/**
* Returns the Value of the key/value pair, identified by the given Key, from the Store.
*
* @example
* PCL.GetStoreValue("UserName");
*
* @param key - Store Key
* @returns The Value if key/value pair identified by the Key exists in the Store, null otherwise
*/
export function GetStoreValue(key: string | null) : boolean | number | string | null;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Returns the number of Instances (Cardinality) of the Substructure Reference currently existing
*
* @example
* PCL.GetSubConfigurationCount("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long Distance-Path)
* @returns number of Instances currently existing, if the Attribute represents a Substructure Reference, 0 otherwise
*/
export function GetSubConfigurationCount(attributePath: string | null) : number;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Returns the default number of Instances (default Cardinality) of the Substructure Reference, as assigned via the Data Manager.
*     Respective number of Instances get created automatically at the start of configuration process
*
* @example
* PCL.GetSubConfigurationDefault("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @returns default number of Instances as assigned via the Data Manager, if the Attribute represents a Substructure Reference, 0 otherwise
*/
export function GetSubConfigurationDefault(attributePath: string | null) : number;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Returns the maximum number of Instances (maximum Cardinality) the Substructure Reference is allowed to have
*
* @example
* PCL.GetSubConfigurationMax("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @returns maximum number of Instances allowed, if the Attribute represents a Substructure Reference, 0 otherwise
*/
export function GetSubConfigurationMax(attributePath: string | null) : number;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Returns the minimum number of Instances (minimum Cardinality) of the Substructure Reference, which must exist in completely evaluated state, so the given Attribute is treated as evaluated
*
* @example
* PCL.GetSubConfigurationMin("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @returns minimum number of Instances getting created automatically by the engine, if the Attribute represents a Substructure Reference, 0 otherwise
*/
export function GetSubConfigurationMin(attributePath: string | null) : number;

/**
* Returns the Summary information of Root Configuration Object (i.e. starting point of configuration process) as an Object
*
* @example
* PCL.GetSummary();
*
* @returns Object containing Summary information of Root Configuration Object (i.e. starting point of configuration process)
*/
export function GetSummary() : ConfigurationSummary;

/**
* GetTableSelectedRowIds
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function GetTableSelectedRowIds(attributePath: string | null) : (string)[];

/**
* GetTableSelections
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function GetTableSelections(attributePath: string | null) : (Record<string, boolean | number | string | null>)[];

/**
* Returns the translation of the given Dictionary Identifier in the currently activated language
*
* @example
* PCL.GetTranslation("NAME_ARTICLE");
*
* @param id - Dictionary Identifier
* @returns Translated Dictionary Identifier, if it exists, in currently activated language, otherwise the unchanged Dictionary Identifier
*/
export function GetTranslation(id: string | null) : string;

/**
* GetTranslationByPath
*
* @param translationPath - The parameter translationPath.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetTranslationByPath(translationPath: string | null, localeId: string | null) : string;

/**
* GetTranslationForContext
*
* @param id - The parameter id.
* @param context - The parameter context.
* @returns The return value.
*/
export function GetTranslationForContext(id: string | null, context: string | null) : string;

/**
* Returns the translation of the given Dictionary Identifier in language of the given Language Identifier.
*     Notice: The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetTranslationForLanguage("NAME_ARTICLE", "en-US");
*
* @param id - Dictionary Identifier
* @param localeId - Language Identifier
* @returns Translated Dictionary Identifier in language of the Language Identifier, if the Dictionary Identifier exists and the Language Identifier is valid, otherwise the unchanged Dictionary Identifier
*/
export function GetTranslationForLanguage(id: string | null, localeId: string | null) : string;

/**
* GetTranslationForLanguageAndContext
*
* @param id - The parameter id.
* @param localeId - The parameter localeId.
* @param context - The parameter context.
* @returns The return value.
*/
export function GetTranslationForLanguageAndContext(id: string | null, localeId: string | null, context: string | null) : string;

/**
* EXPERIMENTAL FUNCTION!
*     Returns all conditions referenced as datasets of the Conditions and Rules table, which are currently met, as an object (key/value pairs)
*
* @example
* PCL.GetTrueConditions();
*
* @returns An object of key/value pairs containing all conditions referenced as datasets of the Conditions and Rules table, which are currently met, an empty object otherwise
*/
export function GetTrueConditions() : Record<string, boolean> | null;

/**
* Returns the translated description of the given Unit Identifier in language of the given Language Identifier.
*     The description of the Unit Identifier represents the descriptive text, which is assigned to the unit via the Data Manager.
*     Notice: The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetUnitDescriptionTranslation("squareMeter", "en-US");
*
* @param unitId - Unit Identifier
* @param localeId - Language Identifier
* @returns Translated description of the Unit Identifier in language of the Language Identifier, if the Unit Identifier exists and the Language Identifier is valid, otherwise the unchanged Unit Identifier
*/
export function GetUnitDescriptionTranslation(unitId: string | null, localeId: string | null) : string | null;

/**
* GetUnitDimensionDescriptionTranslation
*
* @param unitId - The parameter unitId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetUnitDimensionDescriptionTranslation(unitId: string | null, localeId: string | null) : string | null;

/**
* GetUnitDimensionNameTranslation
*
* @param unitId - The parameter unitId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetUnitDimensionNameTranslation(unitId: string | null, localeId: string | null) : string | null;

/**
* GetUnitGroupDescriptionTranslation
*
* @param unitId - The parameter unitId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetUnitGroupDescriptionTranslation(unitId: string | null, localeId: string | null) : string | null;

/**
* GetUnitGroupNameTranslation
*
* @param unitId - The parameter unitId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetUnitGroupNameTranslation(unitId: string | null, localeId: string | null) : string | null;

/**
* Returns the translated name of the given Unit Identifier into language of the given Language Identifier.
*     The name of the Unit Identifier represents the string being displayed in the user interface for the unit.
*     Notice: The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetUnitNameTranslation("squareMeter", "en-US");
*
* @param unitId - Unit Identifier
* @param localeId - Language Identifier
* @returns Translated name of the Unit Identifier into language of the Language Identifier, if the Unit Identifier exists and the Language Identifier is valid, otherwise the unchanged Unit Identifier
*/
export function GetUnitNameTranslation(unitId: string | null, localeId: string | null) : string | null;

/**
* GetUnitSymbol
*
* @param unitId - The parameter unitId.
* @returns The return value.
*/
export function GetUnitSymbol(unitId: string | null) : string | null;

/**
* GetUnitSystemDescriptionTranslation
*
* @param unitId - The parameter unitId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetUnitSystemDescriptionTranslation(unitId: string | null, localeId: string | null) : string | null;

/**
* GetUnitSystemNameTranslation
*
* @param unitId - The parameter unitId.
* @param localeId - The parameter localeId.
* @returns The return value.
*/
export function GetUnitSystemNameTranslation(unitId: string | null, localeId: string | null) : string | null;

/**
* Returns updated version of the given Bill Of Material, which includes calculation of masses and prices of its Items, as an Object
*
* @example
* let currentBom = PCL.GetBom();
*     currentBom.Items[0].Quantity = 5;
*     currentBom.Items[0].BasePrices[0].Price = 9.25;
*     currentBom.Items[0].BaseMass = 60;
*     let updatedBom = PCL.GetUpdatedBom(currentBom);
*
* @param bom - The parameter bom.
* @returns Object containing data of updated version of the Bill Of Material
*/
export function GetUpdatedBom(bom: ConfigurationBom | null) : ConfigurationBom | null;

/**
* Returns the translated description of the given Dictionary Identifier in language of the given Language Identifier.
*     The description of the Dictionary Identifier represents the descriptive text, which is assigned to the Dictionary Identifier via the Data Manager.
*     Notices: The Dictionary Identifier must reference a dataset of Dictionary, which is setup in Data Manager using the functionality "Translations". The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetUserDefinedDescriptionTranslation("BASIC_INFO", "en-US");
*
* @param translationId - Dictionary Identifier
* @param localeId - Language Identifier
* @returns Translated description of the Dictionary Identifier in language of the Language Identifier, if the Dictionary Identifier exists and the Language Identifier is valid, otherwise the unchanged Dictionary Identifier
*/
export function GetUserDefinedDescriptionTranslation(translationId: string | null, localeId: string | null) : string;

/**
* Returns the translated name of the given Dictionary Identifier in language of the given Language Identifier.
*     Notices: The Dictionary Identifier must reference a dataset of Dictionary, which is setup in Data Manager using the functionality "Translations". The second parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetUserDefinedNameTranslation("BASIC_INFO", "en-US");
*
* @param translationId - Dictionary Identifier
* @param localeId - Language Identifier
* @returns Translated name of the Dictionary Identifier in language of the Language Identifier, if the Dictionary Identifier exists and the Language Identifier is valid, otherwise the unchanged Dictionary Identifier
*/
export function GetUserDefinedNameTranslation(translationId: string | null, localeId: string | null) : string;

/**
* GetUserEmail
*
* @returns The return value.
*/
export function GetUserEmail() : string | null;

/**
* GetUserMainRole
*
* @returns The return value.
*/
export function GetUserMainRole() : string | null;

/**
* GetUserName
*
* @returns The return value.
*/
export function GetUserName() : string | null;

/**
* GetUserRoles
*
* @returns The return value.
*/
export function GetUserRoles() : (string)[];

/**
* Returns all Attributes of the Configuration Object referenced by the given Long Distance-Path, which are selected by hand (i.e. not tagged as "User Selected") as an Array
*
* @example
* PCL.GetUserSelectedAttributes("/XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns Array of all Attribute Identifiers, which are selected by hand (i.e. not tagged as "User Selected"), if the Configuration Object exists, empty Array otherwise
*/
export function GetUserSelectedAttributes(objectPath: string | null) : (string)[];

/**
* GetUserSettingValue
*
* @param settingId - The parameter settingId.
* @returns The return value.
*/
export function GetUserSettingValue(settingId: string | null) : boolean | number | string | null;

/**
* GetUserSettingValues
*
* @param settingId - The parameter settingId.
* @returns The return value.
*/
export function GetUserSettingValues(settingId: string | null) : (boolean | number | string | null)[] | null;

/**
* GetValueAttachmentCount
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @returns The return value.
*/
export function GetValueAttachmentCount(attributePath: string | null, valueId: boolean | number | string | null) : number;

/**
* GetValueAttachmentPath
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function GetValueAttachmentPath(attributePath: string | null, valueId: boolean | number | string | null, attachmentId: string | null) : string | null;

/**
* GetValueAttachments
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @returns The return value.
*/
export function GetValueAttachments(attributePath: string | null, valueId: boolean | number | string | null) : Record<string, string | null>;

/**
* GetValueAttachmentTags
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function GetValueAttachmentTags(attributePath: string | null, valueId: boolean | number | string | null, attachmentId: string | null) : (string)[] | null;

/**
* Returns the Value, which has the given Index in the Value pool of the given Attribute
*
* @example
* PCL.GetValueByIndex("A_RAM", 3);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param index - Index of Value as number (integer))
* @returns Value Identifier with respective Index in Value pool, if the Value of the Attribute exists, null otherwise
*/
export function GetValueByIndex(attributePath: string | null, index: number) : boolean | number | string | null;

/**
* Returns the number of Values within the Value pool of the given Attribute
*
* @example
* PCL.GetValueCount("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns The number of Values (int) within the Value pool, if the Value of the Attribute exists, 0 otherwise
*/
export function GetValueCount(attributePath: string | null) : number;

/**
* Returns the translated Description of the given Value Identifier of the given Attribute Identifier in language of the given Language Identifier.
*     The description of the Value Identifier of the Attribute Identifier represents the descriptive text, which is assigned to the Value of the Attribute via the Data Manager.
*     Notice: The third parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetValueDescriptionTranslation("A_KEYBOARD", "V_KB_MULTIMEDIA", "en-US");
*
* @param attributeId - Attribute Identifier
* @param valueId - Value Identifier
* @param localeId - Language Identifier
* @returns Translated description of the Value Identifier of the Attribute Identifier in language of the Language Identifier, if the Value Identifier of the Attribute Identifier exists and the Language Identifier is valid, otherwise the unchanged Value Identifier
*/
export function GetValueDescriptionTranslation(attributeId: string | null, valueId: boolean | number | string | null, localeId: string | null) : string;

/**
* Returns the Image Path (URL) of the given Value of the given Attribute
*
* @example
* PCL.GetValueImage("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns Image Path (URL) if the Value of the Attribute exists, null otherwise
*/
export function GetValueImage(attributePath: string | null, valueId: boolean | number | string | null) : string | null;

/**
* Returns the Index of the given Value within the Value pool of the given Attribute
*
* @example
* PCL.GetValueIndex("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns Index of Value within the Value pool, if the Value of the Attribute exists, null otherwise
*/
export function GetValueIndex(attributePath: string | null, valueId: boolean | number | string | null) : boolean | number | string | null;

/**
* Returns the mass of the given Value of the given Attribute
*
* @example
* PCL.GetValueMass("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns mass as numeric value if the Value of the Attribute exists, null otherwise
*/
export function GetValueMass(attributePath: string | null, valueId: boolean | number | string | null) : number | null;

/**
* Returns the Unit Identifier of mass of the given Value of the given Attribute
*     Notice: The Unit Identifier is the content of column "Id" of a dataset of the table "PC_Units", which contains all available units
*
* @example
* PCL.GetValueMassUnitId("A_BATTERY", "V_BAT_6CELLS");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns Unit Identifier of mass if the Value of the Attribute exists, null otherwise
*/
export function GetValueMassUnitId(attributePath: string | null, valueId: boolean | number | string | null) : string | null;

/**
* Returns the translated name of the given Value Identifier of the given Attribute Identifier in language of the given Language Identifier.
*     The name of the Value Identifier of the Attribute Identifier represents the string being displayed in the user interface for the Value of the Attribute.
*     Notice: The third parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetValueNameTranslation("A_KEYBOARD", "V_KB_MULTIMEDIA", "en-US");
*
* @param attributeId - Attribute Identifier
* @param valueId - Value Identifier
* @param localeId - Language Identifier
* @returns Translated name of the Value Identifier of the Attribute Identifier in language of the Language Identifier, if the Value Identifier of the Attribute Identifier exists and the Language Identifier is valid, otherwise the unchanged Value Identifier
*/
export function GetValueNameTranslation(attributeId: string | null, valueId: boolean | number | string | null, localeId: string | null) : string;

/**
* Returns the part class name of the given Value of the given Attribute
*
* @example
* PCL.GetValuePartClass("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns part class name if the Value of the Attribute exists, null otherwise
*/
export function GetValuePartClass(attributePath: string | null, valueId: boolean | number | string | null) : string | null;

/**
* Returns the part Identifier of the given Value of the given Attribute
*
* @example
* PCL.GetValuePartId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns part Identifier if the Value of the Attribute exists, null otherwise
*/
export function GetValuePartId(attributePath: string | null, valueId: boolean | number | string | null) : string | null;

/**
* Returns price of the given Value of the given Attribute.
*     Third parameter "priceType" is optional. If given, respective price must have been set by call of function "SetValuePrice" with the same "priceType" passed.
*
* @example
* PCL.GetValuePrice("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param priceType - price type
* @returns Price as numeric value if the Value of the Attribute exists, null otherwise
*/
export function GetValuePrice(attributePath: string | null, valueId: boolean | number | string | null, priceType: string | null) : number | null;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Returns price of the given Value of the given Attribute, which is assigned via the Data Manager as its initial value.
*     Third parameter "priceType" is optional. If given, it must be empty string as the Data Manager uses this context for assignment of prices.
*
* @example
* PCL.GetValuePriceDefault("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param priceType - price type
* @returns Price, which is assigned by Data Manager, as numeric value, if the Value of the Attribute exists, null otherwise
*/
export function GetValuePriceDefault(attributePath: string | null, valueId: boolean | number | string | null, priceType: string | null) : number | null;

/**
* GetValuePriceId
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @returns The return value.
*/
export function GetValuePriceId(attributePath: string | null, valueId: boolean | number | string | null) : string | null;

/**
* Returns Currency Identifier, which gets converted to currency symbol for displaying it, of price of the given Value of the given Attribute.
*     Third parameter "priceType" is optional. If given, Currency Identifier must have been set by call of function "SetValuePriceUnitId" with the same "priceType" passed.
*
* @example
* PCL.GetValuePriceUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param priceType - price type
* @returns Currency Identifier of price if the Value of the Attribute exists, null otherwise
*/
export function GetValuePriceUnitId(attributePath: string | null, valueId: boolean | number | string | null, priceType: string | null) : string | null;

/**
* Returns all Properties assigned to the given Value of the given Attribute and their Property Values as an object (key/value pairs)
*
* @example
* PCL.GetValueProperties("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns An object of key/value pairs containing the Property Values of all Properties assigned to the Value of the Attribute if it was successful, an empty object otherwise
*/
export function GetValueProperties(attributePath: string | null, valueId: boolean | number | string | null) : Record<string, boolean | number | string | null>;

/**
* Returns the number Properties assigned to the given Value of the given Attribute
*
* @example
* PCL.GetValuePropertyCount("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns The number of Properties (int) assigned to the Value of the Attribute if it was successful, 0 otherwise
*/
export function GetValuePropertyCount(attributePath: string | null, valueId: boolean | number | string | null) : number;

/**
* Returns the translated Description of the Value Property in language of the given Language Identifier.
*     The description of the Value Property represents the descriptive text, which is assigned to the Property of the Attribute via the Data Manager.
*     Notice: The sixth parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetValuePropertyDescriptionTranslation("CFG_NOTEBOOK", "A_KEYBOARD", "V_KB_MULTIMEDIA", "auxiliaryInfo", "en-US");
*
* @param objectId - Configuration Object Identifier
* @param attributeId - Attribute Identifier
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @param propertyValue - Property Value
* @param localeId - Language Identifier
* @returns Translated Description of the Value Property in language of the Language Identifier, if the Value Property exists and the Language Identifier is valid, otherwise the unchanged Value Property
*/
export function GetValuePropertyDescriptionTranslation(objectId: string | null, attributeId: string | null, valueId: boolean | number | string | null, propertyId: string | null, propertyValue: boolean | number | string | null, localeId: string | null) : string;

/**
* Returns the translated Name of the Value Property in language of the given Language Identifier.
*     Notice: The sixth parameter "Language Identifier" is optional. If missing, the currently activated language is used for the translation
*
* @example
* PCL.GetValuePropertyNameTranslation("CFG_NOTEBOOK", "A_KEYBOARD", "V_KB_MULTIMEDIA", "auxiliaryInfo", "en-US");
*
* @param objectId - Configuration Object Identifier
* @param attributeId - Attribute Identifier
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @param propertyValue - Property Value
* @param localeId - Language Identifier
* @returns Translated name of the Value Property in language of the Language Identifier, if the v Property exists and the Language Identifier is valid, otherwise the unchanged Value Property
*/
export function GetValuePropertyNameTranslation(objectId: string | null, attributeId: string | null, valueId: boolean | number | string | null, propertyId: string | null, propertyValue: boolean | number | string | null, localeId: string | null) : string;

/**
* Returns the Property Value of the given Property if it is assigned to the given Value of the given Attribute as a JSON object
*
* @example
* PCL.GetValuePropertyObject("A_RAM", "V_16GB", "property");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @returns An object with data of Property Value if it was successful, null otherwise
*/
export function GetValuePropertyObject(attributePath: string | null, valueId: boolean | number | string | null, propertyId: string | null) : any;

/**
* Returns the Property Value of the given Property if it is assigned to the given Value of the given Attribute
*
* @example
* PCL.GetValuePropertyValue("A_RAM", "V_16GB", "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @returns The Property Value if Property is assigned, null otherwise
*/
export function GetValuePropertyValue(attributePath: string | null, valueId: boolean | number | string | null, propertyId: string | null) : boolean | number | string | null;

/**
* Returns the quantity of the given Value of the given Attribute
*
* @example
* PCL.GetValueQuantity("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns Quantity as numeric value, if the Value of the Attribute exists, null otherwise
*/
export function GetValueQuantity(attributePath: string | null, valueId: boolean | number | string | null) : number | null;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Returns the quantity of the given Value of the given Attribute, which is assigned via the Data Manager as its initial value by Property "Quantity"
*
* @example
* PCL.GetValueQuantityDefault("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns Quantity, which is assigned by Data Manager, as numeric value, if the Value of the Attribute exists, null otherwise
*/
export function GetValueQuantityDefault(attributePath: string | null, valueId: boolean | number | string | null) : number | null;

/**
* Returns the Unit Identifier of quantity of the given Value of the given Attribute
*     Notice: The Unit Identifier is the content of column "Id" of a dataset of the table "PC_Units", which contains all available units
*
* @example
* PCL.GetValueQuantityUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns Unit Identifier of quantity, if the Value of the Attribute exists, null otherwise
*/
export function GetValueQuantityUnitId(attributePath: string | null, valueId: boolean | number | string | null) : string | null;

/**
* Returns the Recommendation Score of the given Value of the given Attribute
*
* @example
* PCL.GetValueRecommendationScore("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns The Recommendation Score as number (double) if the Value of the Attribute exists, 0 otherwise
*/
export function GetValueRecommendationScore(attributePath: string | null, valueId: boolean | number | string | null) : number;

/**
* Returns the Reference Identifier, which can be provided by an external system (e.g. PIM) during import of the given Value of the given Attribute via the Data Manager
*
* @example
* PCL.GetValueReferenceId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns The Reference Identifier if the Value of the Attribute exists, null otherwise
*/
export function GetValueReferenceId(attributePath: string | null, valueId: boolean | number | string | null) : string | null;

/**
* Returns all Values of the given Attribute as an Array
*
* @example
* PCL.GetValues("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns Array of all values if the Attribute exists, empty Array otherwise
*/
export function GetValues(attributePath: string | null) : (boolean | number | string | null)[];

/**
* Returns the type code fragment assigned to the given Value of the given Attribute
*
* @example
* PCL.GetValueTypeCodeFragment("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns type code fragment if it is assigned and the Value of the Attribute exists, null otherwise
*/
export function GetValueTypeCodeFragment(attributePath: string | null, valueId: boolean | number | string | null) : string | null;

/**
* Returns the Unit Identifier of the given Value of the given Attribute
*     Notice: The Unit Identifier is the content of column "Id" of a dataset of the table "PC_Units", which contains all available units
*
* @example
* PCL.GetValueUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns Unit Identifier, if the Value of the Attribute exists, null otherwise
*/
export function GetValueUnitId(attributePath: string | null, valueId: boolean | number | string | null) : string | null;

/**
* Returns the Value of the given Variable Key assigned to the currently running configuration as a JSON object.
*
* @example
* PCL.GetVariableObject("userData");
*
* @param key - Variable Key
* @returns An object of key/value pairs provided by the Value of the Variable Key assigned to the currently running configuration, null otherwise
*/
export function GetVariableObject(key: string | null) : any;

/**
* Returns all Variables assigned to the currently running configuration as an object (key/value pairs).
*
* @example
* PCL.GetVariables();
*
* @returns An object of key/value pairs containing all Variables assigned to the currently running configuration, an empty object if no Variables are assigned
*/
export function GetVariables() : Record<string, boolean | number | string | null>;

/**
* Returns the Value of the given Variable Key assigned to the currently running configuration.
*
* @example
* PCL.GetVariableValue("priority");
*
* @param key - Variable Key
* @returns The Value of the Variable Key assigned to the currently running configuration, null otherwise
*/
export function GetVariableValue(key: string | null) : boolean | number | string | null;

/**
* Returns all Attributes of the Configuration Object referenced by the given Long Distance-Path, which are either visible (visible = true) or invisible (visible = false) to the user as an Array
*
* @example
* PCL.GetVisibleAttributes("/XAS_EXT_DEVICES/0", true);
*
* @param objectPath - Long Distance-Path
* @param visible - true or false
* @returns Array of all Attribute Identifiers, which are either visible (visible = true) or invisible (visible = false) to the user, if the Configuration Object exists, empty Array otherwise
*/
export function GetVisibleAttributes(objectPath: string | null, visible: boolean) : (string)[];

/**
* HasUserMainRole
*
* @param roleId - The parameter roleId.
* @returns The return value.
*/
export function HasUserMainRole(roleId: string | null) : boolean;

/**
* HasUserPermission
*
* @param permissionId - The parameter permissionId.
* @returns The return value.
*/
export function HasUserPermission(permissionId: string | null) : boolean;

/**
* HasUserRole
*
* @param roleId - The parameter roleId.
* @returns The return value.
*/
export function HasUserRole(roleId: string | null) : boolean;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Creates a new Instance of the Substructure Reference and inserts it at the given Index into list of all existing substructures.
*
* @example
* PCL.InsertSubConfiguration("XAS_MISCELLANEOUS", 0);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param index - Index number at which to insert new Instance of the Substructure Reference into list of all existing substructures
* @returns true if it was successful, false otherwise
*/
export function InsertSubConfiguration(attributePath: string | null, index: number) : boolean;

/**
* Returns the interpolation of the given text by replacement of all dynamic placeholders it contains with the data being referenced by them in context of the Configuration Object referenced by the given Long Distance-Path.
*
* @example
* let selectedOS = PCL.GetSelectedValue("XAS_SOFTWARE/0/A_OPERATING_SYSTEM");
*     PCL.InterpolateObjectString("XAS_SOFTWARE/0", "You selected operating system {{attributes.A_OPERATING_SYSTEM.values." + selectedOS + ".name}}.");
*
* @param objectPath - Long Distance-Path
* @param text - Text to interpolate
* @returns String containing interpolation of the text by replacement of all dynamic placeholders it contains with the data being referenced by them in context of the Configuration Object referenced by the Long Distance-Path
*/
export function InterpolateObjectString(objectPath: string | null, text: string | null) : string | null;

/**
* Returns the interpolation of the given text by replacement of all dynamic placeholders it contains with the data being referenced by them in context of the currently running configuration.
*
* @example
* let selectedModel = PCL.GetSelectedValue("A_MODEL");
*     PCL.InterpolateString("You selected model {{attributes.A_MODEL.values." + selectedModel + ".name}}.");
*
* @param text - Text to interpolate
* @returns String containing interpolation of the text by replacement of all dynamic placeholders it contains with the data being referenced by them in context of the currently running configuration
*/
export function InterpolateString(text: string | null) : string | null;

/**
* Checks if the given Attachment Identifier is assigned as attachment anywhere in the environment of all datasets of configuration, i.e. Configuration Objects, Attributes and Attribute Values.
*
* @example
* PCL.IsAttachment("Product_Ceres_png");
*
* @param attachmentId - Attachment Identifier
* @returns true if the Attachment Identifier is assigned as attachment anywhere in the environment of all datasets of configuration, false otherwise
*/
export function IsAttachment(attachmentId: string | null) : boolean;

/**
* Checks if the given Attribute exists in the currently running configuration
*
* @example
* PCL.IsAttribute("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists, false otherwise
*/
export function IsAttribute(attributePath: string | null) : boolean;

/**
* Checks if the given Attribute it currently active or not
*
* @example
* PCL.IsAttributeActive("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and is active, false otherwise
*/
export function IsAttributeActive(attributePath: string | null) : boolean;

/**
* Checks if the given Attribute is currently allowed or hidden
*
* @example
* PCL.IsAttributeAllowed("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and is allowed, false otherwise
*/
export function IsAttributeAllowed(attributePath: string | null) : boolean;

/**
* Checks if any Value of the given Attribute is assigned (selected).
*
* @example
* PCL.IsAttributeAssigned("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and any of its Values is assigned (selected), false otherwise
*/
export function IsAttributeAssigned(attributePath: string | null) : boolean;

/**
* IsAttributeAttachment
*
* @param attributePath - The parameter attributePath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function IsAttributeAttachment(attributePath: string | null, attachmentId: string | null) : boolean;

/**
* Checks if the given Attribute is tagged as "Auto Selected"
*
* @description
* The tag "Auto Selected" means, that if just one valid Value is leftover, this Value will be automatically assigned (selected).
*
* @example
* PCL.IsAttributeAutoSelected("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and is tagged as "Auto Selected", false otherwise
*/
export function IsAttributeAutoSelected(attributePath: string | null) : boolean;

/**
* Depending on the given parameter "attributePath", there are two different use cases:
*     
*             Attribute Identifier: Checks if any Value of the given Attribute is assigned (selected) or it is not tagged as "Required" (optional).
*             
*             Substructure Reference: Checks if at least as much instances of the referenced Configuration Object as defined by minimum cardinality exist.
*                 Furthermore, it checks for all Attributes tagged as "Required" of all existing instances of the Configuration Object if any Value is assigned (selected).
*
* @example
* PCL.IsAttributeComplete("A_RAM");
*     PCL.IsAttributeComplete("XAS_EXT_DEVICES");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if all checks performed according to use case are successful, false otherwise
*/
export function IsAttributeComplete(attributePath: string | null) : boolean;

/**
* Checks if the given Attribute represents a Substructure Reference.
*     These Attributes allow the user to add, edit and remove instances of referenced Configuration Object.
*
* @example
* PCL.IsAttributeConfiguration("XAS_EXT_DEVICES");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and represents a Substructure Reference, false otherwise
*/
export function IsAttributeConfiguration(attributePath: string | null) : boolean;

/**
* Checks if the given Attribute is tagged as "Editable"
*
* @example
* PCL.IsAttributeEditable("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and is tagged as "Editable", false otherwise
*/
export function IsAttributeEditable(attributePath: string | null) : boolean;

/**
* Checks if the given Attribute is tagged as "Language Dependent"
*
* @example
* PCL.IsAttributeLanguageDependent("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and is tagged as "Language Dependent", false otherwise
*/
export function IsAttributeLanguageDependent(attributePath: string | null) : boolean;

/**
* Checks if the given Attribute is tagged as "Multi Valued" (Multi Valued Attribute)
*
* @example
* PCL.IsAttributeMultiValued("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and is tagged as "Multi Valued", false otherwise
*/
export function IsAttributeMultiValued(attributePath: string | null) : boolean;

/**
* Checks if the given Property is assigned to the given Attribute
*
* @example
* PCL.IsAttributeProperty("A_RAM", "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param propertyId - Property Identifier
* @returns true if the Property is assigned, false otherwise
*/
export function IsAttributeProperty(attributePath: string | null, propertyId: string | null) : boolean;

/**
* Checks if the given Attribute is tagged as "Read Only"
*
* @example
* PCL.IsAttributeReadOnly("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and is tagged as "Read Only", false otherwise
*/
export function IsAttributeReadOnly(attributePath: string | null) : boolean;

/**
* Checks if the given Attribute is tagged as "Required"
*
* @description
* The tag "Required" means, that a Value of the Attribute must be assigned (selected) so it gets considered as evaluated, which is necessary to complete the configuration.
*
* @example
* PCL.IsAttributeRequired("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and is tagged as "Required", false otherwise
*/
export function IsAttributeRequired(attributePath: string | null) : boolean;

/**
* Checks if the given Attribute was selected by hand (i.e. tagged as "User Selected") or if it was selected automatically by a script or tag for example.
*
* @example
* PCL.IsAttributeUserSelected("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute is user selected, false otherwise
*/
export function IsAttributeUserSelected(attributePath: string | null) : boolean;

/**
* Checks if the given Attribute it currently visible to the user or not
*
* @example
* PCL.IsAttributeVisible("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists and is visible, false otherwise
*/
export function IsAttributeVisible(attributePath: string | null) : boolean;

/**
* Checks if the Bill Of Material of currently running configuration is tagged as "hierarchical"
*
* @example
* PCL.IsBomHierarchical();
*
* @returns true if the Bill Of Material of currently running configuration is tagged as "hierarchical", false otherwise
*/
export function IsBomHierarchical() : boolean;

/**
* Checks if the Bill Of Material of Configuration Object referenced by the given Long Distance-Path is tagged as "hierarchical"
*
* @example
* PCL.IsBomObjectHierarchical("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if the Bill Of Material of the Configuration Object is tagged as "hierarchical", false otherwise
*/
export function IsBomObjectHierarchical(objectPath: string | null) : boolean;

/**
* EXPERIMENTAL FUNCTION!
*     Checks if the condition referenced as dataset of the Conditions and Rules table by the given Rule Identifier is met
*
* @example
* PCL.IsConditionTrue("COND_CPU_I7");
*
* @param ruleId - Rule Identifier
* @returns true if the condition referenced as dataset of the Conditions and Rules table by the Rule Identifier is met, false otherwise
*/
export function IsConditionTrue(ruleId: string | null) : boolean;

/**
* At first, all Attributes tagged as "Required" (Required Attributes) of the Configuration Object representing the currently running configuration get determined.
*     This processing step runs recursively, so that all Substructure References contained in this Configuration Object get considered and its Required Attributes are found, too.
*     Then, for all Substructure References, which represent Required Attributes, it checks if at least as much instances of the referenced Configuration Object as defined by minimum cardinality exist.
*     Afterwards, it checks for all other common Required Attributes if any Value is assigned (selected).
*
* @example
* PCL.IsCurrentObjectComplete();
*
* @returns true if all checks getting performed are successful, false otherwise
*/
export function IsCurrentObjectComplete() : boolean;

/**
* Checks if the Configuration Object of the currently running configuration just got created, so the script assigned to it runs for the first time since its creation
*
* @example
* PCL.IsCurrentObjectFirstRun()
*
* @returns true if script runs for the first time since creation of Configuration Object, false otherwise
*/
export function IsCurrentObjectFirstRun() : boolean;

/**
* IsCurrentObjectValid
*
* @returns The return value.
*/
export function IsCurrentObjectValid() : boolean;

/**
* Checks if the given Attribute Group exists in the currently running configuration
*
* @example
* PCL.IsGroup("CONFIG_ATTR_GROUP_PERFORMANCE");
*
* @param groupPath - Attribute Group Identifier
* @returns true if the Attribute Group exists, false otherwise
*/
export function IsGroup(groupPath: string | null) : boolean;

/**
* Checks if the given Long Distance-Path references an existing instance of a Configuration Object in the currently running configuration
*
* @example
* PCL.IsObject("/XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if the Long Distance-Path references an existing instance of a Configuration Object, false otherwise
*/
export function IsObject(objectPath: string | null) : boolean;

/**
* IsObjectAttachment
*
* @param objectPath - The parameter objectPath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function IsObjectAttachment(objectPath: string | null, attachmentId: string | null) : boolean;

/**
* At first, all Attributes tagged as "Required" (Required Attributes) according to the Configuration Object referenced by the given Long Distance-Path get determined.
*     This processing step runs recursively, so that all Substructure References contained in the given Configuration Object get considered and its Required Attributes are found, too.
*     Then, for all Substructure References, which represent Required Attributes, it checks if at least as much instances of the referenced Configuration Object as defined by minimum cardinality exist.
*     Afterwards, it checks for all other common Required Attributes if any Value is assigned (selected).
*
* @example
* PCL.IsObjectComplete("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if all checks getting performed are successful, false otherwise
*/
export function IsObjectComplete(objectPath: string | null) : boolean;

/**
* Checks if a specific Property is assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.IsObjectProperty("XAS_EXT_DEVICES/0", "Quantity");
*
* @param objectPath - Long Distance-Path
* @param propertyId - Property Identifier
* @returns true if the Property is assigned, false otherwise
*/
export function IsObjectProperty(objectPath: string | null, propertyId: string | null) : boolean;

/**
* IsObjectValid
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function IsObjectValid(objectPath: string | null) : boolean;

/**
* IsPathAbsolute
*
* @param path - The parameter path.
* @returns The return value.
*/
export function IsPathAbsolute(path: string | null) : boolean;

/**
* IsPathLocal
*
* @param path - The parameter path.
* @returns The return value.
*/
export function IsPathLocal(path: string | null) : boolean;

/**
* IsPathRelative
*
* @param path - The parameter path.
* @returns The return value.
*/
export function IsPathRelative(path: string | null) : boolean;

/**
* At first, all Attributes tagged as "Required" (Required Attributes) of the Root Configuration Object (i.e. starting point of configuration process) get determined.
*     This processing step runs recursively, so that all Substructure References contained in this Configuration Object get considered and its Required Attributes are found, too.
*     Then, for all Substructure References, which represent Required Attributes, it checks if at least as much instances of the referenced Configuration Object as defined by minimum cardinality exist.
*     Afterwards, it checks for all other common Required Attributes if any Value is assigned (selected).
*
* @example
* PCL.IsRootObjectComplete();
*
* @returns true if all checks getting performed are successful, false otherwise
*/
export function IsRootObjectComplete() : boolean;

/**
* Checks if the Root Configuration Object (i.e. starting point of configuration process) just got created, so the script assigned to it runs for the first time
*
* @example
* PCL.IsRootObjectFirstRun()
*
* @returns true if script runs for the first time since creation of Configuration Object, false otherwise
*/
export function IsRootObjectFirstRun() : boolean;

/**
* IsRootObjectValid
*
* @returns The return value.
*/
export function IsRootObjectValid() : boolean;

/**
* IsStateAttachment
*
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function IsStateAttachment(attachmentId: string | null) : boolean;

/**
* Checks if the given Property Identifier is assigned to the State of configuration
*
* @example
* PCL.IsStateProperty("priority");
*
* @param propertyId - Property Identifier
* @returns true if the Property Identifier is assigned, false otherwise
*/
export function IsStateProperty(propertyId: string | null) : boolean;

/**
* Checks if the State of configuration tagged as "Read Only", which means that no change can be made to the evaluation of any Attribute.
*
* @example
* PCL.IsStateReadOnly();
*
* @returns true if the State of configuration tagged as "Read Only", which means that no change can be made to the evaluation of any Attribute, false otherwise
*/
export function IsStateReadOnly() : boolean;

/**
* Checks if the given Attribute represents a Substructure Reference
*
* @example
* PCL.IsSubConfiguration("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute represents a Substructure Reference, false otherwise
*/
export function IsSubConfiguration(attributePath: string | null) : boolean;

/**
* Checks if the given Value is part of the Value pool of the given Attribute
*
* @example
* PCL.IsValue("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if the Value is part of the Value pool of the Attribute, false otherwise
*/
export function IsValue(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Checks if the given Value of the given Attribute is currently active or not
*
* @example
* PCL.IsValueActive("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if the Value of the Attribute exists and the Value is currently active, false otherwise
*/
export function IsValueActive(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Checks if the given Value of the given Attribute is currently allowed or not
*
* @example
* PCL.IsValueAllowed("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if the Value of the Attribute exists and the Value is currently allowed, false otherwise
*/
export function IsValueAllowed(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* IsValueAttachment
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function IsValueAttachment(attributePath: string | null, valueId: boolean | number | string | null, attachmentId: string | null) : boolean;

/**
* Checks if the given Value is currently defined as a Default Value of the given Attribute
*
* @example
* PCL.IsValueDefault("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if the Value of the Attribute exists and the Value is defined as a Default Value, false otherwise
*/
export function IsValueDefault(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Checks if a specific Property is assigned to the given Value of the given Attribute
*
* @example
* PCL.IsValueProperty("A_RAM", "V_16GB, "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @returns true if the Property is assigned, false otherwise
*/
export function IsValueProperty(attributePath: string | null, valueId: boolean | number | string | null, propertyId: string | null) : boolean;

/**
* Checks if the given Value of the given Attribute is currently selected
*
* @example
* PCL.IsValueSelected("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if the Value of the Attribute exists and the Value is currently selected, false otherwise
*/
export function IsValueSelected(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* EXPERIMENTAL FUNCTION!
*     Evaluates if the given Value of the given Attribute is currently selected anywhere in the Configuration, including all Sub-Configurations and Root Object
*
* @example
* PCL.IsValueSelectedAnywhere("A_RAM", "V_16GB")
*
* @param attributeId - Attribute Identifier
* @param valueId - Value Identifier
* @returns true if the Value is selected anywhere in the Configuration, false otherwise
*/
export function IsValueSelectedAnywhere(attributeId: string | null, valueId: boolean | number | string | null) : boolean;

/**
* IsValueSelectedAnywhereByProperty
*
* @param attributeId - The parameter attributeId.
* @param propertyId - The parameter propertyId.
* @param propertyValue - The parameter propertyValue.
* @returns The return value.
*/
export function IsValueSelectedAnywhereByProperty(attributeId: string | null, propertyId: string | null, propertyValue: boolean | number | string | null) : boolean;

/**
* JoinPath
*
* @param path1 - The parameter path1.
* @param path2 - The parameter path2.
* @returns The return value.
*/
export function JoinPath(path1: string | null, path2: string | null) : string;

/**
* JsonToXml
*
* @param json - The parameter json.
* @param writeIndented - The parameter writeIndented.
* @returns The return value.
*/
export function JsonToXml(json: any, writeIndented: boolean) : string | null;

/**
* LoadWasmModuleByPath
*
* @param wasmPath - The parameter wasmPath.
* @returns The return value.
*/
export function LoadWasmModuleByPath(wasmPath: string | null) : Uint8Array;

/**
* Outputs the given Log message in the console log at level Critical (filter in Visual Studio: "FTL")
*
* @example
* PCL.LogCritical("Calculation failed due to division by zero");
*
* @param message - Log message
*/
export function LogCritical(message: string | null) : void;

/**
* Outputs the given Log message in the console log at level Debug (filter in Visual Studio: "DBG")
*
* @example
* PCL.LogDebug("Debug processing message");
*
* @param message - Log message
*/
export function LogDebug(message: string | null) : void;

/**
* Outputs the given Log message in the console log at level Error (filter in Visual Studio: "ERR")
*
* @example
* PCL.LogError("Invalid condition found");
*
* @param message - Log message
*/
export function LogError(message: string | null) : void;

/**
* Outputs the given Log message in the console log at level Information (filter in Visual Studio: "INF")
*
* @example
* PCL.LogInformation("Now processing is complete");
*
* @param message - Log message
*/
export function LogInformation(message: string | null) : void;

/**
* Outputs the given Log message in the console log at level Trace (filter in Visual Studio: "VRB")
*
* @example
* PCL.LogTrace("Trace processing message");
*
* @param message - Log message
*/
export function LogTrace(message: string | null) : void;

/**
* Outputs the given Log message in the console log at level Warning (filter in Visual Studio: "WRN")
*
* @example
* PCL.LogWarning("This part of processing decreases performance");
*
* @param message - Log message
*/
export function LogWarning(message: string | null) : void;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Moves evaluation from the Instance of the Substructure Reference with the given sourceIndex in list of all existing substructures to the Instance with the given targetIndex
*
* @example
* PCL.MoveSubConfiguration("XAS_MISCELLANEOUS", 0, 1);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param sourceIndex - Index number of the Instance whose evaluation to be moved (Source)
* @param targetIndex - Index number of the Instance to move evaluation of source Instance to (Target)
* @returns true if it was successful, false otherwise
*/
export function MoveSubConfiguration(attributePath: string | null, sourceIndex: number, targetIndex: number) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Opens the Configuration Object of the given Long Distance-Path if it represents an existing Instance of a specific Substructure Reference in the currently running configuration
*
* @example
* PCL.OpenObject("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if the Long Distance-Path references an existing instance of a Configuration Object, false otherwise
*/
export function OpenObject(objectPath: string | null) : boolean;

/**
* CAUTION - ENHANCED FUNCTIONALITY! USE ONLY IN CONSIDERATION OF CHANGES APPLIED TO ALL CONFIGURATION STRUCTURES DEPENDING ON THIS FUNCTION
*     This function works only if the given Attribute represents a Substructure Reference.
*     Opens the Configuration Object, which is referenced as Instance with the given Index in the list of all existing substructures of the Substructure Reference
*
* @example
* PCL.OpenSubConfiguration("XAS_MISCELLANEOUS", 0);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param index - Index of Instance of Substructure Reference to open
* @returns true if it was successful, false otherwise
*/
export function OpenSubConfiguration(attributePath: string | null, index: number) : boolean;

/**
* ParseTableSelectedRowIds
*
* @param value - The parameter value.
* @returns The return value.
*/
export function ParseTableSelectedRowIds(value: string | null) : (string)[];

/**
* ParseTableSelections
*
* @param value - The parameter value.
* @returns The return value.
*/
export function ParseTableSelections(value: string | null) : (Record<string, boolean | number | string | null>)[];

/**
* RemoveAttributeAttachment
*
* @param attributePath - The parameter attributePath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function RemoveAttributeAttachment(attributePath: string | null, attachmentId: string | null) : boolean;

/**
* Removes the given Property from the given Attribute
*
* @example
* PCL.RemoveAttributeProperty("A_RAM", "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function RemoveAttributeProperty(attributePath: string | null, propertyId: string | null) : boolean;

/**
* Removes Variable with the given Key from the overall Cache of the application.
*
* @example
* PCL.RemoveCacheValue("category");
*
* @param key - Key
*/
export function RemoveCacheValue(key: string | null) : void;

/**
* Removes the given Input assigned to the currently running configuration
*
* @example
* PCL.RemoveInputValue("priority");
*
* @param key - Input Identifier
* @returns true if it was successful, false otherwise
*/
export function RemoveInputValue(key: string | null) : boolean;

/**
* RemoveObjectAttachment
*
* @param objectPath - The parameter objectPath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function RemoveObjectAttachment(objectPath: string | null, attachmentId: string | null) : boolean;

/**
* Removes the given Input assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.RemoveObjectInputValue("XAS_EXT_DEVICES/0", "priority");
*
* @param objectPath - Long Distance-Path
* @param key - Input Identifier
* @returns true if it was successful, false otherwise
*/
export function RemoveObjectInputValue(objectPath: string | null, key: string | null) : boolean;

/**
* Removes the given Output assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.RemoveObjectOutputValue("XAS_EXT_DEVICES/0", "priority");
*
* @param objectPath - Long Distance-Path
* @param key - Output Identifier
* @returns true if it was successful, false otherwise
*/
export function RemoveObjectOutputValue(objectPath: string | null, key: string | null) : boolean;

/**
* Removes the given Property from the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.RemoveObjectProperty("XAS_EXT_DEVICES/0", "Quantity");
*
* @param objectPath - Long Distance-Path
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function RemoveObjectProperty(objectPath: string | null, propertyId: string | null) : boolean;

/**
* Removes Variable with the given Key from the Variables assigned to the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.RemoveObjectVariableValue("XAS_EXT_DEVICES/0", "priority");
*
* @param objectPath - Long Distance-Path
* @param key - Output Identifier
* @returns true if it was successful, false otherwise
*/
export function RemoveObjectVariableValue(objectPath: string | null, key: string | null) : boolean;

/**
* Removes the given Output assigned to the currently running configuration
*
* @example
* PCL.RemoveOutputValue("priority");
*
* @param key - Output Identifier
* @returns true if it was successful, false otherwise
*/
export function RemoveOutputValue(key: string | null) : boolean;

/**
* RemoveStateAttachment
*
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function RemoveStateAttachment(attachmentId: string | null) : boolean;

/**
* Removes assignment of the given Property Identifier from the State of configuration
*
* @example
* PCL.RemoveStateProperty("priority");
*
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function RemoveStateProperty(propertyId: string | null) : boolean;

/**
* Removes the key/value pair identified by the given Key from the Store.
*
* @example
* PCL.RemoveStoreValue("UserName");
*
* @param key - Store Key
*/
export function RemoveStoreValue(key: string | null) : void;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Deletes that Instance of the Substructure Reference from the list of all existing substructures, which has the given Index.
*
* @example
* PCL.RemoveSubConfiguration("XAS_MISCELLANEOUS", 2);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param index - Index number of the Instance to delete
* @returns true if it was successful, false otherwise
*/
export function RemoveSubConfiguration(attributePath: string | null, index: number) : boolean;

/**
* RemoveValueAttachment
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function RemoveValueAttachment(attributePath: string | null, valueId: boolean | number | string | null, attachmentId: string | null) : boolean;

/**
* Removes the given Property from the given Value of the given Attribute
*
* @example
* PCL.RemoveValueProperty("A_RAM", "V_16GB", "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function RemoveValueProperty(attributePath: string | null, valueId: boolean | number | string | null, propertyId: string | null) : boolean;

/**
* Removes Variable with the given Key from the Variables assigned to the currently running configuration.
*
* @example
* PCL.RemoveVariableValue("priority");
*
* @param key - Variable Key
* @returns true if it was successful, false otherwise
*/
export function RemoveVariableValue(key: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Depending on the given parameter "attributePath", there are two different use cases:
*     
*             Attribute Identifier: Resets selected Values and Properties to the initial data assigned via the Data Manager
*             
*             Substructure Reference: Deletion of ALL instances of the referenced Configuration Object.
*             After deletion, as many instances as defined via the Data Manager (minimum cardinality) get created and evaluation of Attributes is performed according to Values marked as Default.
*
* @example
* PCL.ResetAttribute("A_RAM");
*     PCL.ResetAttribute("XAS_EXT_DEVICES");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if use case can be processed according to the parameter "attributePath", false otherwise
*/
export function ResetAttribute(attributePath: string | null) : boolean;

/**
* ResetAttributeAttachment
*
* @param attributePath - The parameter attributePath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function ResetAttributeAttachment(attributePath: string | null, attachmentId: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the tag "Auto Selected" of the given Attribute to the initial value assigned via the Data Manager
*
* @description
* The tag "Auto Selected" means, that if just one valid Value is leftover, this Value will be automatically selected.
*
* @example
* PCL.ResetAttributeAutoSelected("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ResetAttributeAutoSelected(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Default Value definition of ALL Values of the given Attribute to the initial data assigned via the Data Manager
*
* @example
* PCL.ResetAttributeDefault("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ResetAttributeDefault(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Image Path (URL) of the given Attribute to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetAttributeImage("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ResetAttributeImage(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Min and Max Values of the given Attribute to the initial data assigned via the Data Manager
*
* @example
* PCL.ResetAttributeMinMax("A_TEMPERATURE");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ResetAttributeMinMax(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets Property Value of the given Property assigned to the given Attribute to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetAttributeProperty("A_RAM", "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetAttributeProperty(attributePath: string | null, propertyId: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Recommendation Score of the given Attribute to the initial value assigned via the Data Manager by Property "RecommendationScore"
*
* @example
* PCL.ResetAttributeRecommendationScore("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ResetAttributeRecommendationScore(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the "Required" tag of the given Attribute to the initial value assigned via the Data Manager
*
* @description
* The tag "Required" means, that a Value of the Attribute must be assigned (selected) so it gets considered as evaluated, which is necessary to complete the configuration.
*
* @example
* PCL.ResetAttributeRequired("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ResetAttributeRequired(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Step Width of the given Attribute to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetAttributeStepWidth("A_TEMPERATURE");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists, false otherwise
*/
export function ResetAttributeStepWidth(attributePath: string | null) : boolean;

/**
* ResetAttributeTableChangeToken
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function ResetAttributeTableChangeToken(attributePath: string | null) : boolean;

/**
* ResetAttributeTableId
*
* @param attributePath - The parameter attributePath.
* @returns The return value.
*/
export function ResetAttributeTableId(attributePath: string | null) : boolean;

/**
* EXPERIMENTAL FUNCTION!
*     Clears (deletes) the Unit Group Identifier of the given Attribute
*     Resets the Unit Group Identifier of the given Attribute to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetAttributeUnitGroupId("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ResetAttributeUnitGroupId(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Unit Identifier of the given Attribute to the initial value assigned via the Data Manager by Property "UnitId"
*     In case the given Attribute has no Unit assigned via the Data Manager, there will be no Unit assigned after this operation
*
* @example
* PCL.ResetAttributeUnitId("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ResetAttributeUnitId(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the evaluation of ALL Attributes, which belong to the given Attribute Group, to the initial data assigned via the Data Manager
*
* @example
* PCL.ResetGroup("CONFIG_ATTR_GROUP_PERFORMANCE");
*
* @param groupPath - Attribute Group Identifier
* @returns true if the Attribute Group exists, false otherwise
*/
export function ResetGroup(groupPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Recommendation Score of ALL Attributes, which belong to the given Attribute Group, to the initial value assigned via the Data Manager by Property "RecommendationScore"
*
* @example
* PCL.ResetGroupRecommendationScore("CONFIG_ATTR_GROUP_PERFORMANCE");
*
* @param groupPath - Attribute Group Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetGroupRecommendationScore(groupPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the evaluation of all Attributes after the given Attribute to the initial data assigned via the Data Manager
*
* @example
* PCL.ResetNextAttributes("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists, false otherwise
*/
export function ResetNextAttributes(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     For this function to work, the given Long Distance-Path must reference an existing instance of a Configuration Object in the currently running configuration.
*     If so, it resets the selected Values of all Attributes of referenced Configuration Object to the initial definition assigned via the Data Manager.
*     Thus, after deletion of all evaluations, those Values of Attributes, which are marked as Default via the Data Manager, get directly evaluated again.
*
* @example
* PCL.ResetObject("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if the deletion of selected Values of all Attributes of referenced Configuration Object was performed, false otherwise
*/
export function ResetObject(objectPath: string | null) : boolean;

/**
* ResetObjectAttachment
*
* @param objectPath - The parameter objectPath.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function ResetObjectAttachment(objectPath: string | null, attachmentId: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Image Path (URL) of the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetObjectImage("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ResetObjectImage(objectPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the mass of the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager by Property "Mass"
*
* @example
* PCL.ResetObjectMass("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ResetObjectMass(objectPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Unit Identifier of mass of the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager by Property "MassUnitId"
*
* @example
* PCL.ResetObjectMassUnitId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ResetObjectMassUnitId(objectPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the part class name of the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager by Property "PartClass"
*
* @example
* PCL.ResetObjectPartClass("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ResetObjectPartClass(objectPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the part Identifier of the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager by Property "PartId"
*
* @example
* PCL.ResetObjectPartId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ResetObjectPartId(objectPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets price of the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager.
*     Second parameter "priceType" is optional. If given, it must be empty string as the Data Manager uses this context.
*
* @example
* PCL.ResetObjectPrice("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function ResetObjectPrice(objectPath: string | null, priceType: string | null) : boolean;

/**
* ResetObjectPriceId
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function ResetObjectPriceId(objectPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets Currency Identifier of price, which gets converted to currency symbol for displaying it, of the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager.
*     Second parameter "priceType" is optional. If given, it must be empty string as the Data Manager uses this context
*
* @example
* PCL.ResetObjectPriceUnitId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function ResetObjectPriceUnitId(objectPath: string | null, priceType: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets Property Value of the given Property assigned to the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetObjectProperty("XAS_EXT_DEVICES/0", "Quantity");
*
* @param objectPath - Long Distance-Path
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetObjectProperty(objectPath: string | null, propertyId: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the quantity of the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager by Property "Quantity"
*
* @example
* PCL.ResetObjectQuantity("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ResetObjectQuantity(objectPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Unit Identifier of quantity of the Configuration Object referenced by the given Long Distance-Path to the initial value assigned via the Data Manager by Property "QuantityUnitId"
*
* @example
* PCL.ResetObjectQuantityUnitId("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ResetObjectQuantityUnitId(objectPath: string | null) : boolean;

/**
* Resets the Recommendation Score of the Configuration Object referenced by the given Long Distance-Path back to the initial value assigned via the Data Manager by Property "RecommendationScore"
*
* @example
* PCL.ResetObjectRecommendationScore("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns true if it was successful, false otherwise
*/
export function ResetObjectRecommendationScore(objectPath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the evaluation of all Attributes before the given Attribute to the initial data assigned via the Data Manager
*
* @example
* PCL.ResetPreviousAttributes("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if the Attribute exists, false otherwise
*/
export function ResetPreviousAttributes(attributePath: string | null) : boolean;

/**
* ResetStateAttachment
*
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function ResetStateAttachment(attachmentId: string | null) : boolean;

/**
* Clears (deletes) Property Value of the given Property Identifier assigned to theState of configuration by setting it to null.
*     The assignment of the Property Identifier remains in the State of configuration.
*
* @example
* PCL.ResetStateProperty("priority");
*
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetStateProperty(propertyId: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     This function works only if the given Attribute represents a Substructure Reference.
*     Resets the selected Values (i.e. evaluation) of ALL Attributes of the Instance of the Substructure Reference with the given index in list of all existing substructures to the initial definition assigned via the Data Manager.
*     Thus, after deletion of all evaluations, those Values of Attributes, which are marked as Default via the Data Manager, get directly selected again.
*
* @example
* PCL.ResetSubConfiguration("XAS_MISCELLANEOUS", 2);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param index - specific index number of the Instance to be reset
* @returns true if it was successful, false otherwise
*/
export function ResetSubConfiguration(attributePath: string | null, index: number) : boolean;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Resets the number of currently existing Instances (Cardinality) of the Substructure Reference as assigned via the Data Manager
*     Thus, if Instances are missing, they get created and if too many Instances exist, they get deleted.
*
* @example
* PCL.ResetSubConfigurationCount("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @returns true if it was successful, false otherwise
*/
export function ResetSubConfigurationCount(attributePath: string | null) : boolean;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Resets the minimum and maximum number of Instances (minimum and maximum Cardinality) of the Substructure Reference as assigned via the Data Manager
*
* @example
* PCL.ResetSubConfigurationMinMax("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @returns true if it was successful, false otherwise
*/
export function ResetSubConfigurationMinMax(attributePath: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     This function works only if the given Attribute represents a Substructure Reference.
*     Resets the selected Values (i.e. evaluation) of ALL Attributes of ALL existing Instances of the Substructure Reference to the initial definition assigned via the Data Manager.
*     Thus, after deletion of all evaluations, those Values of Attributes, which are marked as Default via the Data Manager, get directly selected again.
*
* @example
* PCL.ResetSubConfigurations("XAS_MISCELLANEOUS");
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @returns true if it was successful, false otherwise
*/
export function ResetSubConfigurations(attributePath: string | null) : boolean;

/**
* ResetValueAttachment
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @param attachmentId - The parameter attachmentId.
* @returns The return value.
*/
export function ResetValueAttachment(attributePath: string | null, valueId: boolean | number | string | null, attachmentId: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Default Value definition of the given Value of the given Attribute to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetValueDefault("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueDefault(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Resets the Image Path (URL) of the given Value of the given Attribute to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetValueImage("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueImage(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the mass of the given Value of the given Attribute to the initial value assigned via the Data Manager by Property "Mass"
*
* @example
* PCL.ResetValueMass("A_BATTERY", "V_BAT_6CELLS");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueMass(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Unit Identifier of mass of the given Value of the given Attribute to the initial value assigned via the Data Manager by Property "MassUnitId"
*
* @example
* PCL.ResetValueMassUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueMassUnitId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the part class name of the given Value of the given Attribute to the initial value assigned via the Data Manager by Property "PartClass"
*
* @example
* PCL.ResetValuePartClass("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValuePartClass(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the part Identifier of the given Value of the given Attribute to the initial value assigned via the Data Manager by Property "PartId"
*
* @example
* PCL.ResetValuePartId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValuePartId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets price of the given Value of the given Attribute to the initial value assigned via the Data Manager.
*     Third parameter "priceType" is optional. If given, it must be empty string as the Data Manager uses this context.
*
* @example
* PCL.ResetValuePrice("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function ResetValuePrice(attributePath: string | null, valueId: boolean | number | string | null, priceType: string | null) : boolean;

/**
* ResetValuePriceId
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @returns The return value.
*/
export function ResetValuePriceId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets Currency Identifier of price, which gets converted to currency symbol for displaying it, of the given Value of the given Attribute to the initial value assigned via the Data Manager.
*     Third parameter "priceType" is optional. If given, it must be empty string as the Data Manager uses this context
*
* @example
* PCL.ResetValuePriceUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function ResetValuePriceUnitId(attributePath: string | null, valueId: boolean | number | string | null, priceType: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets Property Value of the given Property assigned to the given Value of the given Attribute to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetValueProperty("A_RAM", "V_16GB", "Quantity");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueProperty(attributePath: string | null, valueId: boolean | number | string | null, propertyId: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the quantity of the given Value of the given Attribute to the initial value assigned via the Data Manager by Property "Quantity"
*
* @example
* PCL.ResetValueQuantity("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueQuantity(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Unit Identifier of quantity of the given Value of the given Attribute to the initial value assigned via the Data Manager by Property "QuantityUnitId"
*
* @example
* PCL.ResetValueQuantityUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueQuantityUnitId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Recommendation Score of the given Value of the given Attribute to the initial value assigned via the Data Manager by Property "RecommendationScore"
*
* @example
* PCL.ResetValueRecommendationScore("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueRecommendationScore(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Recommendation Score of ALL Values of the given Attribute to the initial value assigned to each Value via the Data Manager by its Property "RecommendationScore"
*
* @example
* PCL.ResetValuesRecommendationScore("A_RAM");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @returns true if it was successful, false otherwise
*/
export function ResetValuesRecommendationScore(attributePath: string | null) : boolean;

/**
* Resets the type code fragment assigned to the given Value of the given Attribute to the initial value assigned via the Data Manager
*
* @example
* PCL.ResetValueTypeCodeFragment("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueTypeCodeFragment(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Resets the Unit Identifier of the given Value of the given Attribute to the initial value assigned via the Data Manager by Property "UnitId"
*
* @example
* PCL.ResetValueUnitId("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function ResetValueUnitId(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* ResolvePath
*
* @param basePath - The parameter basePath.
* @param path - The parameter path.
* @returns The return value.
*/
export function ResolvePath(basePath: string | null, path: string | null) : string;

/**
* Performs the restoration of evaluation state of a configuration according to given Saved data structure of configuration.
*
* @example
* PCL.SaveConfiguration();
*
* @param save - Saved data structure of configuration
* @param preConfiguration - Perform pre-configuration instead of normal restoration (does not reset unsaved attributes)
* @returns Number of Configuration Objects handles by restoration process if successful, 0 otherwise
*/
export function RestoreConfiguration(save: ConfigurationSave | null, preConfiguration: boolean) : number;

/**
* RestrictAttributeValues
*
* @param attributePath - The parameter attributePath.
* @param restrictionType - The parameter restrictionType.
* @param values - The parameter values.
* @param isRestrictingAllowedValues - The parameter isRestrictingAllowedValues.
* @param isInverse - The parameter isInverse.
* @returns The return value.
*/
export function RestrictAttributeValues(attributePath: string | null, restrictionType: string | null, values: (boolean | number | string | null)[] | null, isRestrictingAllowedValues: boolean, isInverse: boolean) : boolean;

/**
* Returns the given Value of money rounded to decimal digits as specified in currencies table for the given Currency Identifier.
*
* @example
* PCL.RoundCurrency(25.876, "EUR", "USD");
*
* @param value - Value of money
* @param currencyId - Currency Identifier
* @returns Value of money rounded to decimal digits as specified in currencies table for the Currency Identifier
*/
export function RoundCurrency(value: number | null, currencyId: string | null) : number | null;

/**
* Returns data structure containing the saved data of current evaluation state of whole configuration for later restoration.
*
* @example
* PCL.SaveConfiguration();
*
* @returns Data structure containing the saved data of current evaluation state of whole configuration for later restoration
*/
export function SaveConfiguration() : ConfigurationSave;

/**
* Selects the given Value as Default Value of the given Attribute by calling PCL.SetDefaultValueSelected(attributePath, valueId, true)
*
* @example
* PCL.SelectDefaultValue("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function SelectDefaultValue(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Selects the given Value of the given Attribute
*
* @example
* PCL.SelectValue("A_RAM", "V_16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function SelectValue(attributePath: string | null, valueId: boolean | number | string | null) : boolean;

/**
* EXPERIMENTAL FUNCTION!
*     Selects the given Value of the given Attribute everywhere in the Configuration, including all Sub-Configurations and Root Object
*
* @example
* PCL.SelectValueEverywhere("A_RAM", "V_16GB");
*
* @param attributeId - Attribute Identifier
* @param valueId - Value Identifier
* @returns true if it was successful, false otherwise
*/
export function SelectValueEverywhere(attributeId: string | null, valueId: boolean | number | string | null) : boolean;

/**
* Send a JSON array (batch) web request to the given web service and return the response.
*     The array elements will be cached and the remaining elements sent in a single request.
*
* @param webServiceId - The ID of the web service
* @param path - The path segment of the URL
* @param array - The array request content (must be JSON array)
* @param options - Request options (e.g. headers and query params)
* @returns Web Service Result
*/
export function SendJsonArrayWebRequest(webServiceId: string | null, path: string | null, array: any, options: WebRequestOptions | null) : WebServiceResult;

/**
* Send a JSON web request to the given web service and return the response.
*
* @param webServiceId - The ID of the web service
* @param path - The path segment of the URL
* @param data - The request content (any valid JSON object)
* @param options - Request options (e.g. headers and query params)
* @returns Web Service Result
*/
export function SendJsonWebRequest(webServiceId: string | null, path: string | null, data: any, options: WebRequestOptions | null) : WebServiceResult;

/**
* Sets the given Attribute either active (active = true) or inactive (active = false)
*
* @example
* PCL.SetAttributeActive("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param active - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributeActive(attributePath: string | null, active: boolean) : boolean;

/**
* Sets the given Attribute either allowed (allowed = true) or hidden (allowed = false)
*
* @example
* PCL.SetAttributeAllowed("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param allowed - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributeAllowed(attributePath: string | null, allowed: boolean) : boolean;

/**
* SetAttributeAttachmentPath
*
* @param attributePath - The parameter attributePath.
* @param attachmentId - The parameter attachmentId.
* @param path - The parameter path.
* @returns The return value.
*/
export function SetAttributeAttachmentPath(attributePath: string | null, attachmentId: string | null, path: string | null) : boolean;

/**
* SetAttributeAttachmentTags
*
* @param attributePath - The parameter attributePath.
* @param attachmentId - The parameter attachmentId.
* @param tags - The parameter tags.
* @returns The return value.
*/
export function SetAttributeAttachmentTags(attributePath: string | null, attachmentId: string | null, tags: (string)[] | null) : boolean;

/**
* Sets the given Attribute tagged as "Auto Selected" or not
*
* @description
* The tag "Auto Selected" means, that if just one valid Value is leftover, this Value will be automatically selected.
*
* @example
* PCL.SetAttributeAutoSelected("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param autoSelected - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributeAutoSelected(attributePath: string | null, autoSelected: boolean) : boolean;

/**
* Sets the Image Path (URL) of the given Attribute
*
* @example
* PCL.SetAttributeImage("A_RAM", "/Images/RAM.jpg");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param image - Image Path (e.g. "/Images/RAM.jpg")
* @returns true if it was successful, false otherwise
*/
export function SetAttributeImage(attributePath: string | null, image: string | null) : boolean;

/**
* Sets the given Min and Max Values of the given Attribute
*
* @example
* PCL.SetAttributeMinMax("A_TEMPERATURE", -20, 85);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param min - Start of range (Minimum)
* @param max - End of range (Maximum)
* @returns true if it was successful, false otherwise
*/
export function SetAttributeMinMax(attributePath: string | null, min: number | null, max: number | null) : boolean;

/**
* Assigns the given Property to the given Attribute and sets it to the given Property Value representing a JSON object.
*     If the given Property is already assigned, the assignment gets overwritten by the given Property Value.
*
* @example
* var obj = {price:50, gb:16, brand:"HyperX"};
*     PCL.SetAttributePropertyObject("A_RAM", "property", obj);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param propertyId - Property Identifier
* @param value - Property Value
* @returns true if it was successful, false otherwise
*/
export function SetAttributePropertyObject(attributePath: string | null, propertyId: string | null, value: any) : boolean;

/**
* Assigns the given Property to the given Attribute and sets it to the given Property Value.
*     If the given Property is already assigned, the assignment gets overwritten by the given Property Value.
*
* @example
* PCL.SetAttributePropertyValue("A_RAM", "Quantity", "2");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param propertyId - Property Identifier
* @param value - Property Value
* @returns true if it was successful, false otherwise
*/
export function SetAttributePropertyValue(attributePath: string | null, propertyId: string | null, value: boolean | number | string | null) : boolean;

/**
* Sets the given Attribute to either "Read Only" or not
*
* @example
* PCL.SetAttributeReadOnly("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param readOnly - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributeReadOnly(attributePath: string | null, readOnly: boolean) : boolean;

/**
* Sets the Recommendation Score of the given Attribute
*
* @example
* PCL.SetAttributeRecommendationScore("A_RAM", 1.5);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param score - Score value as number (double)
* @returns true if it was successful, false otherwise
*/
export function SetAttributeRecommendationScore(attributePath: string | null, score: number) : boolean;

/**
* Sets the given Attribute tagged as "Required" or not
*
* @description
* The tag "Required" means, that a Value of the Attribute must be assigned (selected) so it gets considered as evaluated, which is necessary to complete the configuration.
*
* @example
* PCL.SetAttributeRequired("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param required - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributeRequired(attributePath: string | null, required: boolean) : boolean;

/**
* Sets ALL Attributes of the Configuration Object referenced by the given Long Distance-Path to active (active = true) or inactive (active = false)
*
* @example
* PCL.SetAttributesActive("XAS_EXT_DEVICES/0", true);
*
* @param objectPath - Long Distance-Path
* @param active - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributesActive(objectPath: string | null, active: boolean) : boolean;

/**
* Sets ALL Attributes of the Configuration Object referenced by the given Long Distance-Path allowed (allowed = true) or hidden (allowed = false)
*
* @example
* PCL.SetAttributesAllowed("XAS_EXT_DEVICES/0", true);
*
* @param objectPath - Long Distance-Path
* @param allowed - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributesAllowed(objectPath: string | null, allowed: boolean) : boolean;

/**
* Sets ALL Attributes of the Configuration Object referenced by the given Long Distance-Path to either "Read Only" or not
*
* @example
* PCL.SetAttributesReadOnly("XAS_EXT_DEVICES/0", true);
*
* @param objectPath - Long Distance-Path
* @param readOnly - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributesReadOnly(objectPath: string | null, readOnly: boolean) : boolean;

/**
* Sets the given Step Width of the given Attribute
*
* @example
* PCL.SetAttributeStepWidth("A_TEMPERATURE", 10);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param stepWidth - Step Width as number (double)
* @returns true if it was successful, false otherwise
*/
export function SetAttributeStepWidth(attributePath: string | null, stepWidth: number | null) : boolean;

/**
* Sets ALL Attributes of the Configuration Object referenced by the given Long Distance-Path to either visible (visible = true) or invisible (visible = false)
*
* @example
* PCL.SetAttributesVisible("XAS_EXT_DEVICES/0", true);
*
* @param objectPath - Long Distance-Path
* @param visible - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributesVisible(objectPath: string | null, visible: boolean) : boolean;

/**
* SetAttributeTableChangeToken
*
* @param attributePath - The parameter attributePath.
* @param tableChangeToken - The parameter tableChangeToken.
* @returns The return value.
*/
export function SetAttributeTableChangeToken(attributePath: string | null, tableChangeToken: string | null) : boolean;

/**
* SetAttributeTableId
*
* @param attributePath - The parameter attributePath.
* @param tableId - The parameter tableId.
* @returns The return value.
*/
export function SetAttributeTableId(attributePath: string | null, tableId: string | null) : boolean;

/**
* EXPERIMENTAL FUNCTION!
*     Sets the given Unit Group Identifier of the given Attribute
*     Notice: The Unit Group Identifier references a specific list of Units which can be selected by user together with value of attribute
*
* @example
* PCL.SetAttributeUnitGroupId("A_RAM", "RAM_TYPES_GROUP");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param unitGroupId - Unit Group Identifier
* @returns true if it was successful, false otherwise
*/
export function SetAttributeUnitGroupId(attributePath: string | null, unitGroupId: string | null) : boolean;

/**
* Sets the Unit Identifier for the given Attribute
*     Notice: The Unit Identifier must be the content of column "Id" of table "PC_Units" of its row representing respective unit
*
* @example
* PCL.SetAttributeUnitId("A_RAM", "GigaByte");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param unitId - Unit Identifier
* @returns true if it was successful, false otherwise
*/
export function SetAttributeUnitId(attributePath: string | null, unitId: string | null) : boolean;

/**
* Sets the given Attribute tagged as "User Selected" or not
*
* @example
* PCL.SetAttributeUserSelected("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param userSelected - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributeUserSelected(attributePath: string | null, userSelected: boolean) : boolean;

/**
* Sets the given Attribute either visible (visible = true) or invisible (visible = false) to the user
*
* @example
* PCL.SetAttributeVisible("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param visible - true or false
* @returns true if it was successful, false otherwise
*/
export function SetAttributeVisible(attributePath: string | null, visible: boolean) : boolean;

/**
* SetBom
*
* @param bom - The parameter bom.
* @returns The return value.
*/
export function SetBom(bom: ConfigurationBom | null) : boolean;

/**
* Sets the Bill Of Material of currently running configuration tagged as "hierarchical"
*
* @example
* PCL.SetBomHierarchical(true);
*
* @param hierarchical - true or false
* @returns true if it was successful, false otherwise
*/
export function SetBomHierarchical(hierarchical: boolean) : boolean;

/**
* Sets the Bill Of Material of Configuration Object referenced by the given Long Distance-Path tagged as "hierarchical"
*
* @example
* PCL.SetBomObjectHierarchical("XAS_EXT_DEVICES/0", true);
*
* @param objectPath - Long Distance-Path
* @param hierarchical - true or false
* @returns true if it was successful, false otherwise
*/
export function SetBomObjectHierarchical(objectPath: string | null, hierarchical: boolean) : boolean;

/**
* Assigns the given Key to the overall Cache of the application and sets it to the given Value representing a JSON object.
*     If the given Key is already assigned, the assignment gets overwritten by the given Value.
*
* @example
* let dataObject = {userType:"client", sessionTimeout:1800, brand:"HyperX"}
*     PCL.SetCacheObject("userData", dataObject);
*
* @param key - Key
* @param value - Value
*/
export function SetCacheObject(key: string | null, value: any) : void;

/**
* Assigns the given Key to the overall Cache of the application and sets it to the given Value.
*     If the given Key is already assigned, the assignment gets overwritten by the given Value.
*
* @example
* PCL.SetCacheValue("category", "standard");
*
* @param key - Key
* @param value - Value
*/
export function SetCacheValue(key: string | null, value: string | null) : void;

/**
* SetCurrentObjectTypeCode
*
* @param typeCode - The parameter typeCode.
* @returns The return value.
*/
export function SetCurrentObjectTypeCode(typeCode: string | null) : boolean;

/**
* SetCurrentObjectTypeCodeElements
*
* @param typeCodeElements - The parameter typeCodeElements.
* @returns The return value.
*/
export function SetCurrentObjectTypeCodeElements(typeCodeElements: (ConfigurationTypeCodeElement)[] | null) : boolean;

/**
* SetCurrentObjectValid
*
* @param valid - The parameter valid.
* @returns The return value.
*/
export function SetCurrentObjectValid(valid: boolean) : boolean;

/**
* SetCustomAssembly
*
* @param assembly - The parameter assembly.
* @returns The return value.
*/
export function SetCustomAssembly(assembly: ConfigurationAssembly | null) : boolean;

/**
* Sets the given Bill Of Material data as modified Bill Of Material of currently running configuration
*
* @example
* // implementation of event listener function "OnCreateBom"
*     globalThis.OnCreateBom = () => {
*       // get the current BOM
*       const customBomData = PCL.GetBom();
*       // modify the BOM
*       customBomData.Items.push({
*         Rank: 3,
*         PartId: "234567",
*         Name: "Custom Part",
*         Quantity: 4,
*         BaseMass: 500,
*         BasePrices: [
*           {
*             Price: 150,
*             UnitId: "USD",
*           }
*         ]
*       });
*       // calculate the final BOM: aggregate prices, mass, set level, set position ID, etc.
*       const updatedBom = PCL.GetUpdatedBom(bom);
*       // set the final BOM as the modified BOM
*       PCL.SetCustomBom(updatedBom);
*     };
*
* @param bom - Bill Of Material data (as object)
* @returns true if it was successful, false otherwise
*/
export function SetCustomBom(bom: ConfigurationBom | null) : boolean;

/**
* SetCustomDrawing
*
* @param drawing - The parameter drawing.
* @returns The return value.
*/
export function SetCustomDrawing(drawing: ConfigurationDrawing | null) : boolean;

/**
* SetCustomRestoreResult
*
* @param customRestoreResult - The parameter customRestoreResult.
*/
export function SetCustomRestoreResult(customRestoreResult: ConfigurationRestoreResult | null) : void;

/**
* SetCustomSave
*
* @param save - The parameter save.
*/
export function SetCustomSave(save: ConfigurationSave | null) : void;

/**
* SetCustomSummary
*
* @param summary - The parameter summary.
* @returns The return value.
*/
export function SetCustomSummary(summary: ConfigurationSummary | null) : boolean;

/**
* SetCustomTable
*
* @param table - The parameter table.
* @returns The return value.
*/
export function SetCustomTable(table: ConfigurationTable | null) : boolean;

/**
* SetCustomTypeCode
*
* @param customTypeCode - The parameter customTypeCode.
*/
export function SetCustomTypeCode(customTypeCode: string | null) : void;

/**
* SetCustomTypeCodeAnalysisOptions
*
* @param options - The parameter options.
*/
export function SetCustomTypeCodeAnalysisOptions(options: ConfigurationTypeCodeAnalysisOptions | null) : void;

/**
* SetCustomTypeCodeAnalysisResult
*
* @param customTypeCodeAnalysisResult - The parameter customTypeCodeAnalysisResult.
*/
export function SetCustomTypeCodeAnalysisResult(customTypeCodeAnalysisResult: ConfigurationTypeCodeAnalysisResult | null) : void;

/**
* SetCustomValidationResult
*
* @param customValidationResult - The parameter customValidationResult.
*/
export function SetCustomValidationResult(customValidationResult: ConfigurationValidationResult | null) : void;

/**
* (De)selects the given Value as Default Value of the given Attribute
*
* @example
* PCL.SetDefaultValueSelected("A_RAM", "V_16GB", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param selected - true or false
* @returns true if it was successful, false otherwise
*/
export function SetDefaultValueSelected(attributePath: string | null, valueId: boolean | number | string | null, selected: boolean) : boolean;

/**
* Sets ALL Attributes, which belong to the given Attribute Group, either active (active = true) or inactive (active = false)
*
* @example
* PCL.SetGroupActive("CONFIG_ATTR_GROUP_PERFORMANCE", true);
*
* @param groupPath - Attribute Group Identifier
* @param active - true or false
* @returns true if it was successful, false otherwise
*/
export function SetGroupActive(groupPath: string | null, active: boolean) : boolean;

/**
* Sets ALL Attributes, which belong to the given Attribute Group, either allowed (allowed = true) or hidden (allowed = false)
*
* @example
* PCL.SetGroupAllowed("CONFIG_ATTR_GROUP_PERFORMANCE", true);
*
* @param groupPath - Attribute Group Identifier
* @param allowed - true or false
* @returns true if it was successful, false otherwise
*/
export function SetGroupAllowed(groupPath: string | null, allowed: boolean) : boolean;

/**
* Sets ALL Attributes, which belong to the given Attribute Group, tagged as "Auto Selected" or not
*
* @description
* The tag "Auto Selected" means, that if just one valid Value is leftover for an Attribute, this Value will be automatically selected.
*
* @example
* PCL.SetGroupAutoSelected("CONFIG_ATTR_GROUP_PERFORMANCE", true);
*
* @param groupPath - Attribute Group Identifier
* @param autoSelected - true or false
* @returns true if it was successful, false otherwise
*/
export function SetGroupAutoSelected(groupPath: string | null, autoSelected: boolean) : boolean;

/**
* Sets ALL Attributes, which belong to the given Attribute Group, to either "Read Only" or not
*
* @example
* PCL.SetGroupReadOnly("CONFIG_ATTR_GROUP_PERFORMANCE", true);
*
* @param groupPath - Attribute Group Identifier
* @param readOnly - true or false
* @returns true if it was successful, false otherwise
*/
export function SetGroupReadOnly(groupPath: string | null, readOnly: boolean) : boolean;

/**
* Sets the Recommendation Score of ALL Attributes, which belong to the given Attribute Group
*
* @example
* PCL.SetGroupRecommendationScore("CONFIG_ATTR_GROUP_PERFORMANCE", 1.5);
*
* @param groupPath - Attribute Group Identifier
* @param score - Score value as number (double)
* @returns true if it was successful, false otherwise
*/
export function SetGroupRecommendationScore(groupPath: string | null, score: number) : boolean;

/**
* Sets ALL Attributes, which belong to the given Attribute Group, tagged as "Required" or not
*
* @description
* The tag "Required" means, that a Value of an Attribute must be assigned (selected) so it gets considered as evaluated, which is necessary to complete the configuration.
*
* @example
* PCL.SetGroupRequired("CONFIG_ATTR_GROUP_PERFORMANCE", true);
*
* @param groupPath - Attribute Group Identifier
* @param required - true or false
* @returns true if it was successful, false otherwise
*/
export function SetGroupRequired(groupPath: string | null, required: boolean) : boolean;

/**
* Sets ALL Attributes, which belong to the given Attribute Group, either visible (visible = true) or invisible (visible = false) to the user
*
* @example
* PCL.SetGroupVisible("CONFIG_ATTR_GROUP_PERFORMANCE", true);
*
* @param groupPath - Attribute Group Identifier
* @param visible - true or false
* @returns true if it was successful, false otherwise
*/
export function SetGroupVisible(groupPath: string | null, visible: boolean) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Assigns the given Input to the currently running configuration and sets it to the given Input Value representing a JSON object.
*     If the given Input is already assigned, the assignment gets overwritten by the given Input Value.
*
* @example
* let inputObj = {priority:12, explainText:"Selected by user"};
*     PCL.SetInputObject("priorityData", inputObj, false);
*
* @param key - Input Identifier
* @param value - Input Value
* @param languageDependent - Boolean indicating whether the Input Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetInputObject(key: string | null, value: any, languageDependent: boolean) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Assigns a new Input to the currently running configuration and sets it to the given Input Value or changes the existing assignment to the given Input Value
*
* @example
* PCL.SetInputValue("priority", "high", false);
*
* @param key - Input Identifier
* @param value - Input Value
* @param languageDependent - Boolean indicating whether the Input Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetInputValue(key: string | null, value: boolean | number | string | null, languageDependent: boolean) : boolean;

/**
* SetObjectAttachmentPath
*
* @param objectPath - The parameter objectPath.
* @param attachmentId - The parameter attachmentId.
* @param path - The parameter path.
* @returns The return value.
*/
export function SetObjectAttachmentPath(objectPath: string | null, attachmentId: string | null, path: string | null) : boolean;

/**
* SetObjectAttachmentTags
*
* @param objectPath - The parameter objectPath.
* @param attachmentId - The parameter attachmentId.
* @param tags - The parameter tags.
* @returns The return value.
*/
export function SetObjectAttachmentTags(objectPath: string | null, attachmentId: string | null, tags: (string)[] | null) : boolean;

/**
* Sets the Image Path (URL) of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.SetObjectImage("XAS_EXT_DEVICES/0", "/Images/ExternalDevices.jpg");
*
* @param objectPath - Long Distance-Path
* @param image - Image Path (e.g. "/Images/ExternalDevices.jpg")
* @returns true if it was successful, false otherwise
*/
export function SetObjectImage(objectPath: string | null, image: string | null) : boolean;

/**
* Assigns the given Input to the Configuration Object referenced by the given Long Distance-Path and sets it to the given Input Value representing a JSON object.
*     If the given Input is already assigned, the assignment gets overwritten by the given Input Value.
*
* @example
* let inputObj = {priority:12, explainText:"Selected by user"};
*     PCL.SetObjectInputObject("XAS_EXT_DEVICES/0", "priorityData", inputObj, false);
*
* @param objectPath - Long Distance-Path
* @param key - Input Identifier
* @param value - Input Value
* @param languageDependent - Boolean indicating whether the Input Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetObjectInputObject(objectPath: string | null, key: string | null, value: any, languageDependent: boolean) : boolean;

/**
* Assigns the given Input to the Configuration Object referenced by the given Long Distance-Path and sets it to the given Input Value.
*     If the given Input is already assigned, the assignment gets overwritten by the given Input Value.
*
* @example
* PCL.SetObjectInputValue("XAS_EXT_DEVICES/0", "priority", "high", false);
*
* @param objectPath - Long Distance-Path
* @param key - Input Identifier
* @param value - Input Value
* @param languageDependent - Boolean indicating whether the Input Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetObjectInputValue(objectPath: string | null, key: string | null, value: boolean | number | string | null, languageDependent: boolean) : boolean;

/**
* Sets the given mass of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.SetObjectMass("XAS_EXT_DEVICES/0", 250);
*
* @param objectPath - Long Distance-Path
* @param mass - mass (as numeric value)
* @returns true if it was successful, false otherwise
*/
export function SetObjectMass(objectPath: string | null, mass: number | null) : boolean;

/**
* Sets the given Unit Identifier of mass of the Configuration Object referenced by the given Long Distance-Path.
*     Notice: The Unit Identifier must be the content of column "Id" of the dataset of table "PC_Units" which represents respective unit
*
* @example
* PCL.SetObjectMassUnitId("XAS_EXT_DEVICES/0", "Gram");
*
* @param objectPath - Long Distance-Path
* @param massUnitId - Unit Identifier of mass
* @returns true if it was successful, false otherwise
*/
export function SetObjectMassUnitId(objectPath: string | null, massUnitId: string | null) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Assigns the given Output to the Configuration Object referenced by the given Long Distance-Path and sets it to the given Output Value representing a JSON object.
*     If the given Output is already assigned, the assignment gets overwritten by the given Output Value.
*
* @example
* let inputObj = {priority:12, explainText:"Selected by user"};
*     PCL.SetObjectOutputObject("XAS_EXT_DEVICES/0", "priorityData", inputObj, false);
*
* @param objectPath - Long Distance-Path
* @param key - Output Identifier
* @param value - Output Value
* @param languageDependent - Boolean indicating whether the Output Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetObjectOutputObject(objectPath: string | null, key: string | null, value: any, languageDependent: boolean) : boolean;

/**
* CAUTION - DEPRECATED! DO NOT USE IN NEW PROJECTS!
*     Assigns the given Output to the Configuration Object referenced by the given Long Distance-Path and sets it to the given Output Value.
*     If the given Output is already assigned, the assignment gets overwritten by the given Output Value.
*
* @example
* PCL.SetObjectOutputValue("XAS_EXT_DEVICES/0", "priority", "high", false);
*
* @param objectPath - Long Distance-Path
* @param key - Output Identifier
* @param value - Output Value
* @param languageDependent - Boolean indicating whether the Output Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetObjectOutputValue(objectPath: string | null, key: string | null, value: boolean | number | string | null, languageDependent: boolean) : boolean;

/**
* Sets the given part class name of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.SetObjectPartClass("XAS_EXT_DEVICES/0", "ext_devices_part_class");
*
* @param objectPath - Long Distance-Path
* @param partClass - part class name
* @returns true if it was successful, false otherwise
*/
export function SetObjectPartClass(objectPath: string | null, partClass: string | null) : boolean;

/**
* Sets the given part Identifier of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.SetObjectPartId("XAS_EXT_DEVICES/0", "ext_devices_part");
*
* @param objectPath - Long Distance-Path
* @param partId - part Identifier
* @returns true if it was successful, false otherwise
*/
export function SetObjectPartId(objectPath: string | null, partId: string | null) : boolean;

/**
* Sets the given price of the Configuration Object referenced by the given Long Distance-Path.
*     Third parameter "priceType" is optional. If given, respective price can only get retrieved by call of function "GetObjectPrice" with the same "priceType" passed.
*
* @example
* PCL.SetObjectPrice("XAS_EXT_DEVICES/0", 150.80);
*
* @param objectPath - Long Distance-Path
* @param price - Price (as numeric value)
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function SetObjectPrice(objectPath: string | null, price: number | null, priceType: string | null) : boolean;

/**
* SetObjectPriceId
*
* @param objectPath - The parameter objectPath.
* @param priceId - The parameter priceId.
* @returns The return value.
*/
export function SetObjectPriceId(objectPath: string | null, priceId: string | null) : boolean;

/**
* Sets the given Currency Identifier of price, which gets converted to currency symbol for displaying it, of the Configuration Object referenced by the given Long Distance-Path.
*     Third parameter "priceType" is optional. If given, respective Currency Identifier can only get retrieved by call of function "GetObjectPriceUnitId" with the same "priceType" passed.
*
* @example
* PCL.SetObjectPriceUnitId("XAS_EXT_DEVICES/0", "EUR");
*
* @param objectPath - Long Distance-Path
* @param priceUnitId - Currency Identifier
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function SetObjectPriceUnitId(objectPath: string | null, priceUnitId: string | null, priceType: string | null) : boolean;

/**
* Assigns the given Property to the Configuration Object referenced by the given Long Distance-Path and sets it to the given Property Value representing a JSON object.
*     If the given Property is already assigned, the assignment gets overwritten by the given Property Value.
*
* @example
* var obj = {price:250, initTime:160, brand:"HyperX"}
*     PCL.SetObjectPropertyObject("XAS_EXT_DEVICES/0", "property", obj);
*
* @param objectPath - Long Distance-Path
* @param propertyId - Property Identifier
* @param value - Property Value
* @returns true if it was successful, false otherwise
*/
export function SetObjectPropertyObject(objectPath: string | null, propertyId: string | null, value: any) : boolean;

/**
* Assigns the given Property to the Configuration Object referenced by the given Long Distance-Path and sets it to the given Property Value.
*     If the given Property is already assigned, the assignment gets overwritten by the given Property Value.
*
* @example
* PCL.SetObjectPropertyValue("XAS_EXT_DEVICES/0", "Quantity", "2");
*
* @param objectPath - Long Distance-Path
* @param propertyId - Property Identifier
* @param value - Property Value
* @returns true if it was successful, false otherwise
*/
export function SetObjectPropertyValue(objectPath: string | null, propertyId: string | null, value: boolean | number | string | null) : boolean;

/**
* Sets the given quantity of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.SetObjectQuantity("XAS_EXT_DEVICES/0", 2);
*
* @param objectPath - Long Distance-Path
* @param quantity - quantity (as numeric value)
* @returns true if it was successful, false otherwise
*/
export function SetObjectQuantity(objectPath: string | null, quantity: number | null) : boolean;

/**
* Sets the given Unit Identifier of quantity of the Configuration Object referenced by the given Long Distance-Path.
*     Notice: The Unit Identifier must be the content of column "Id" of the dataset of table "PC_Units" which represents respective unit
*
* @example
* PCL.SetObjectQuantityUnitId("XAS_EXT_DEVICES/0", "Piece");
*
* @param objectPath - Long Distance-Path
* @param quantityUnitId - Unit Identifier of quantity
* @returns true if it was successful, false otherwise
*/
export function SetObjectQuantityUnitId(objectPath: string | null, quantityUnitId: string | null) : boolean;

/**
* Sets the given Recommendation Score of the Configuration Object referenced by the given Long Distance-Path
*
* @example
* PCL.SetObjectRecommendationScore("XAS_EXT_DEVICES/0", 1.5);
*
* @param objectPath - Long Distance-Path
* @param score - Score value as number (double)
* @returns true if it was successful, false otherwise
*/
export function SetObjectRecommendationScore(objectPath: string | null, score: number) : boolean;

/**
* SetObjectTypeCode
*
* @param objectPath - The parameter objectPath.
* @param typeCode - The parameter typeCode.
* @returns The return value.
*/
export function SetObjectTypeCode(objectPath: string | null, typeCode: string | null) : boolean;

/**
* SetObjectTypeCodeElements
*
* @param objectPath - The parameter objectPath.
* @param typeCodeElements - The parameter typeCodeElements.
* @returns The return value.
*/
export function SetObjectTypeCodeElements(objectPath: string | null, typeCodeElements: (ConfigurationTypeCodeElement)[] | null) : boolean;

/**
* SetObjectValid
*
* @param objectPath - The parameter objectPath.
* @param valid - The parameter valid.
* @returns The return value.
*/
export function SetObjectValid(objectPath: string | null, valid: boolean) : boolean;

/**
* Assigns the given Variable Key to the Variables of the Configuration Object referenced by the given Long Distance-Path and sets it to the given Variable Value representing a JSON object.
*     If the given Variable Key is already assigned, the assignment gets overwritten by the given Variable Value.
*
* @example
* let dataObject = {userType:"client", sessionTimeout:1800, brand:"HyperX"}
*     PCL.SetObjectVariableObject("XAS_EXT_DEVICES/0", "userData", dataObject, false, true);
*
* @param objectPath - Long Distance-Path
* @param key - Variable Key
* @param value - Variable Value
* @param languageDependent - Boolean indicating whether the Variable Value is language dependent
* @param isPrivate - EXPERIMENTAL! - Boolean to control transfer of the Variable Value to frontend
* @returns true if it was successful, false otherwise
*/
export function SetObjectVariableObject(objectPath: string | null, key: string | null, value: any, languageDependent: boolean, isPrivate: boolean) : boolean;

/**
* Assigns the given Variable Key to the Variables of the Configuration Object referenced by the given Long Distance-Path and sets it to the given Variable Value.
*     If the given Variable Key is already assigned, the assignment gets overwritten by the given Variable Value.
*
* @example
* PCL.SetObjectVariableValue("XAS_EXT_DEVICES/0", "priority", "high", false, true);
*
* @param objectPath - Long Distance-Path
* @param key - Variable Key
* @param value - Variable Value
* @param languageDependent - Boolean indicating whether the Variable Value is language dependent
* @param isPrivate - EXPERIMENTAL! - Boolean to control transfer of the Variable Value to frontend
* @returns true if it was successful, false otherwise
*/
export function SetObjectVariableValue(objectPath: string | null, key: string | null, value: boolean | number | string | null, languageDependent: boolean, isPrivate: boolean) : boolean;

/**
* Assigns the given Output to the currently running configuration and sets it to the given Output Value representing a JSON object.
*     If the given Output is already assigned, the assignment gets overwritten by the given Output Value.
*
* @example
* let inputObj = {priority:12, explainText:"Selected by user"};
*     PCL.SetOutputObject("priorityData", inputObj, false);
*
* @param key - Output Identifier
* @param value - Output Value
* @param languageDependent - Boolean indicating whether the Output Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetOutputObject(key: string | null, value: any, languageDependent: boolean) : boolean;

/**
* Assigns a new Output to the currently running configuration and sets it to the given Output Value or changes the existing assignment to the given Output Value
*
* @example
* PCL.SetOutputValue("priority", "high", false);
*
* @param key - Output Identifier
* @param value - Output Value
* @param languageDependent - Boolean indicating whether the Output Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetOutputValue(key: string | null, value: boolean | number | string | null, languageDependent: boolean) : boolean;

/**
* SetPriceListId
*
* @param priceListId - The parameter priceListId.
*/
export function SetPriceListId(priceListId: string | null) : void;

/**
* SetRootObjectTypeCode
*
* @param typeCode - The parameter typeCode.
* @returns The return value.
*/
export function SetRootObjectTypeCode(typeCode: string | null) : boolean;

/**
* SetRootObjectTypeCodeElements
*
* @param typeCodeElements - The parameter typeCodeElements.
* @returns The return value.
*/
export function SetRootObjectTypeCodeElements(typeCodeElements: (ConfigurationTypeCodeElement)[] | null) : boolean;

/**
* SetRootObjectValid
*
* @param valid - The parameter valid.
* @returns The return value.
*/
export function SetRootObjectValid(valid: boolean) : boolean;

/**
* SetStateAttachmentPath
*
* @param attachmentId - The parameter attachmentId.
* @param path - The parameter path.
* @returns The return value.
*/
export function SetStateAttachmentPath(attachmentId: string | null, path: string | null) : boolean;

/**
* SetStateAttachmentTags
*
* @param attachmentId - The parameter attachmentId.
* @param tags - The parameter tags.
* @returns The return value.
*/
export function SetStateAttachmentTags(attachmentId: string | null, tags: (string)[] | null) : boolean;

/**
* Assigns the given Property Identifier to the Properties of the State of configuration and sets it to the given Property Value representing a JSON object.
*     If the given Property Identifier is already assigned, the assignment gets overwritten by the given Property Value.
*
* @example
* let additionalInfo = {category: "supplies", storedQuantity: 275};
*     PCL.SetStatePropertyObject("auxiliaryData", additionalInfo);
*
* @param propertyId - Property Identifier
* @param value - Property Value
* @returns true if it was successful, false otherwise
*/
export function SetStatePropertyObject(propertyId: string | null, value: any) : boolean;

/**
* Assigns the given Property Identifier to the Properties of the State of configuration and sets it to the given Property Value.
*     If the given Property Identifier is already assigned, the assignment gets overwritten by the given Property Value.
*
* @example
* PCL.SetStatePropertyValue("priority", "high");
*
* @param propertyId - Property Identifier
* @param value - Property Value
* @returns true if it was successful, false otherwise
*/
export function SetStatePropertyValue(propertyId: string | null, value: boolean | number | string | null) : boolean;

/**
* Sets the State of configuration to "Read Only" or not. If set to "Read Only" by given value true, no change can be made to the evaluation of any Attribute of configuration.
*
* @example
* PCL.SetStateReadOnly(true);
*
* @param readOnlyState - The parameter readOnlyState.
* @returns true
*/
export function SetStateReadOnly(readOnlyState: boolean) : boolean;

/**
* Sets the given Value, which represents a JSON object, of the given Key to the Store as key/value pair identified by the given Key.
*     If the Key already exists in the Store, the Value associated to it gets overwritten by the given Value.
*
* @example
* var storeObj = {userName:"John Doe", hobby:"paint images", age:42};
*     PCL.SetStoreObject("UserData", storeObj);
*
* @param key - Store Key
* @param value - Store Value
*/
export function SetStoreObject(key: string | null, value: any) : void;

/**
* Sets the given Value of the given Key to the Store as key/value pair identified by the given Key.
*     If the Key already exists in the Store, the Value associated to it gets overwritten by the given Value.
*
* @example
* PCL.SetStoreValue("UserName", "John Doe");
*
* @param key - Store Key
* @param value - Store Value
*/
export function SetStoreValue(key: string | null, value: boolean | number | string | null) : void;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Defines the number of Instances (Cardinality) of the Substructure Reference, currently existing.
*     Thus, if Instances are missing, they get created and if too many Instances exist, they get deleted.
*
* @example
* PCL.SetSubConfigurationCount("XAS_MISCELLANEOUS", 2);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param count - number (Cardinality) of Instances
* @returns true if it was successful, false otherwise
*/
export function SetSubConfigurationCount(attributePath: string | null, count: number) : boolean;

/**
* SetSubConfigurationInputObject
*
* @param attributePath - The parameter attributePath.
* @param index - The parameter index.
* @param key - The parameter key.
* @param value - The parameter value.
* @param languageDependent - The parameter languageDependent.
* @returns The return value.
*/
export function SetSubConfigurationInputObject(attributePath: string | null, index: number, key: string | null, value: any, languageDependent: boolean) : boolean;

/**
* This function works only if the given Attribute references a Substructure Reference.
*     Assigns the given value as Input Value with the given key to the Instance of the Substructure Reference with the given index in list of all existing substructures.
*     The given flag languageDependent is used to signalize if the given value is language dependent or not.
*
* @example
* PCL.SetSubConfigurationInputValue("XAS_MISCELLANEOUS", 1, "performanceLevel", "high", false);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param index - specific index number of the Instance whose Input Value to set
* @param key - key (i.e. name) of the Input Value to set
* @param value - value of the Input Value to set
* @param languageDependent - flag to signalize language dependency of value of Input Value
* @returns true if it was successful, false otherwise
*/
export function SetSubConfigurationInputValue(attributePath: string | null, index: number, key: string | null, value: boolean | number | string | null, languageDependent: boolean) : boolean;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Sets the maximum number of Instances (maximum Cardinality) the Substructure Reference is allowed to have, to the given Maximum.
*
* @example
* PCL.SetSubConfigurationMax("XAS_MISCELLANEOUS", 3);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param max - maximum number of Instances (maximum Cardinality)
* @returns true if it was successful, false otherwise
*/
export function SetSubConfigurationMax(attributePath: string | null, max: number) : boolean;

/**
* This function works only if the given Attribute represents a Substructure Reference.
*     Sets the minimum number of Instances (minimum Cardinality) of the Substructure Reference, which must exist in completely evaluated state, so the given Attribute is treated as evaluated
*
* @example
* PCL.SetSubConfigurationMin("XAS_MISCELLANEOUS", 1);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param min - minimum number of Instances (minimum Cardinality)
* @returns true if it was successful, false otherwise
*/
export function SetSubConfigurationMin(attributePath: string | null, min: number) : boolean;

/**
* SetSubConfigurationsInputObject
*
* @param attributePath - The parameter attributePath.
* @param key - The parameter key.
* @param value - The parameter value.
* @param languageDependent - The parameter languageDependent.
* @returns The return value.
*/
export function SetSubConfigurationsInputObject(attributePath: string | null, key: string | null, value: any, languageDependent: boolean) : boolean;

/**
* This function works only if the given Attribute references a Substructure Reference.
*     Assigns the given value as Input Value with the given key to ALL existing Instances of the Substructure Reference.
*     The given flag languageDependent is used to signalize if the given value is language dependent or not.
*
* @example
* PCL.SetSubConfigurationsInputValue("XAS_MISCELLANEOUS", "performanceLevel", "high", false);
*
* @param attributePath - CFG-Object-Attribute Identifier (or Long-Distance Path)
* @param key - key (i.e. name) of the Input Value to set
* @param value - value of the Input Value to set
* @param languageDependent - flag to signalize language dependency of value of Input Value
* @returns true if it was successful, false otherwise
*/
export function SetSubConfigurationsInputValue(attributePath: string | null, key: string | null, value: boolean | number | string | null, languageDependent: boolean) : boolean;

/**
* Sets the given Value of the given Attribute as active (active = true) or inactive (active = false)
*
* @example
* PCL.SetValueActive("A_RAM", "V_16GB", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param active - true or false
* @returns true if is was successful, false otherwise
*/
export function SetValueActive(attributePath: string | null, valueId: boolean | number | string | null, active: boolean) : boolean;

/**
* Sets the given Value of the given Attribute as allowed (allowed = true) or hidden (allowed = false)
*
* @example
* PCL.SetValueAllowed("A_RAM", "V_16GB", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param allowed - true or false
* @returns true if is was successful, false otherwise
*/
export function SetValueAllowed(attributePath: string | null, valueId: boolean | number | string | null, allowed: boolean) : boolean;

/**
* SetValueAttachmentPath
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @param attachmentId - The parameter attachmentId.
* @param path - The parameter path.
* @returns The return value.
*/
export function SetValueAttachmentPath(attributePath: string | null, valueId: boolean | number | string | null, attachmentId: string | null, path: string | null) : boolean;

/**
* SetValueAttachmentTags
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @param attachmentId - The parameter attachmentId.
* @param tags - The parameter tags.
* @returns The return value.
*/
export function SetValueAttachmentTags(attributePath: string | null, valueId: boolean | number | string | null, attachmentId: string | null, tags: (string)[] | null) : boolean;

/**
* Sets the given Value of the given Attribute as its Default Value (isDefault = true) or not (isDefault = false)
*
* @example
* PCL.SetValueDefault("A_RAM", "V_16GB", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param isDefault - true or false
* @returns true if it was successful, false otherwise
*/
export function SetValueDefault(attributePath: string | null, valueId: boolean | number | string | null, isDefault: boolean) : boolean;

/**
* Sets the Image Path (URL) of the given Value of the given Attribute
*
* @example
* PCL.SetValueImage("A_RAM", "V_16GB", "/Images/Ram_Picture1.png");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param image - Image Path
* @returns true if it was successful, false otherwise
*/
export function SetValueImage(attributePath: string | null, valueId: boolean | number | string | null, image: string | null) : boolean;

/**
* Sets the given mass of the given Value of the given Attribute
*
* @example
* PCL.SetValueMass("A_RAM", "V_16GB", 15);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param mass - mass (as numeric value)
* @returns true if it was successful, false otherwise
*/
export function SetValueMass(attributePath: string | null, valueId: boolean | number | string | null, mass: number | null) : boolean;

/**
* Sets the given Unit Identifier of mass of the given Value of the given Attribute.
*     Notice: The Unit Identifier must be the content of column "Id" of the dataset of table "PC_Units" which represents respective unit
*
* @example
* PCL.SetValueMassUnitId("A_BATTERY", "V_BAT_6CELLS", "Gram");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param massUnitId - Unit Identifier of mass
* @returns true if it was successful, false otherwise
*/
export function SetValueMassUnitId(attributePath: string | null, valueId: boolean | number | string | null, massUnitId: string | null) : boolean;

/**
* Sets the given part class name of the given Value of the given Attribute
*
* @example
* PCL.SetValuePartClass("A_RAM", "V_16GB", "RAM_part_class");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param partClass - part class name
* @returns true if it was successful, false otherwise
*/
export function SetValuePartClass(attributePath: string | null, valueId: boolean | number | string | null, partClass: string | null) : boolean;

/**
* Sets the given part Identifier of the given Value of the given Attribute
*
* @example
* PCL.SetValuePartId("A_RAM", "V_16GB", "RAM_part");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param partId - part Identifier
* @returns true if it was successful, false otherwise
*/
export function SetValuePartId(attributePath: string | null, valueId: boolean | number | string | null, partId: string | null) : boolean;

/**
* Sets the given price of the given Value of the given Attribute.
*     Fourth parameter "priceType" is optional. If given, respective price can only get retrieved by call of function "GetValuePrice" with the same "priceType" passed.
*
* @example
* PCL.SetValuePrice("A_RAM", "V_16GB", 36.75);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param price - Price (as numeric value)
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function SetValuePrice(attributePath: string | null, valueId: boolean | number | string | null, price: number | null, priceType: string | null) : boolean;

/**
* SetValuePriceId
*
* @param attributePath - The parameter attributePath.
* @param valueId - The parameter valueId.
* @param priceId - The parameter priceId.
* @returns The return value.
*/
export function SetValuePriceId(attributePath: string | null, valueId: boolean | number | string | null, priceId: string | null) : boolean;

/**
* Sets the given Currency Identifier of price, which gets converted to currency symbol for displaying it, of the given Value of the given Attribute.
*     The Currency Identifier must be the content of column "Id" of the dataset of table "PC_Currencies" (contains all available currencies), which represents respective currency.
*     Fourth parameter "priceType" is optional. If given, respective Currency Identifier can only get retrieved by call of function "GetValuePriceUnitId" with the same "priceType" passed.
*
* @example
* PCL.SetValuePriceUnitId("A_RAM", "V_16GB", "EUR");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param priceUnitId - Currency Identifier
* @param priceType - price type
* @returns true if it was successful, false otherwise
*/
export function SetValuePriceUnitId(attributePath: string | null, valueId: boolean | number | string | null, priceUnitId: string | null, priceType: string | null) : boolean;

/**
* Assigns the given Property to the given Value of the given Attribute and sets it to the given Property Value representing a JSON object.
*     If the given Property is already assigned, the assignment gets overwritten by the given Property Value.
*
* @example
* var obj = {price:50, busSpeed:10600, brand:"HyperX"};
*     PCL.SetValuePropertyObject("A_RAM", "V_16GB", "property", obj);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @param value - Property Value
* @returns true if it was successful, false otherwise
*/
export function SetValuePropertyObject(attributePath: string | null, valueId: boolean | number | string | null, propertyId: string | null, value: any) : boolean;

/**
* Assigns a new Property to the given Value of the given Attribute and sets it to the given Property Value or changes the existing assignment to the given Property Value
*
* @example
* PCL.SetValuePropertyValue("A_RAM", "V_16GB", "Quantity", "2");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param propertyId - Property Identifier
* @param value - Property Value
* @returns true if it was successful, false otherwise
*/
export function SetValuePropertyValue(attributePath: string | null, valueId: boolean | number | string | null, propertyId: string | null, value: boolean | number | string | null) : boolean;

/**
* Sets the given quantity of the given Value of the given Attribute
*
* @example
* PCL.SetValueQuantity("A_RAM", "V_16GB", 2);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param quantity - quantity (as numeric value)
* @returns true if it was successful, false otherwise
*/
export function SetValueQuantity(attributePath: string | null, valueId: boolean | number | string | null, quantity: number | null) : boolean;

/**
* Sets the given Unit Identifier of quantity of the given Value of the given Attribute.
*     Notice: The Unit Identifier must be the content of column "Id" of the dataset of table "PC_Units" which represents respective unit
*
* @example
* PCL.SetValueQuantityUnitId("A_RAM", "V_16GB", "Piece");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param quantityUnitId - Unit Identifier of quantity
* @returns true if it was successful, false otherwise
*/
export function SetValueQuantityUnitId(attributePath: string | null, valueId: boolean | number | string | null, quantityUnitId: string | null) : boolean;

/**
* Sets the given Recommendation Score of the given Value of the given Attribute
*
* @example
* PCL.SetValueRecommendationScore("A_RAM", "V_16GB", 4.5);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param score - Score value as number (double)
* @returns true if it was successful, false otherwise
*/
export function SetValueRecommendationScore(attributePath: string | null, valueId: boolean | number | string | null, score: number) : boolean;

/**
* Sets ALL Values of the given Attribute to active (active = true) or inactive (active = false)
*
* @example
* PCL.SetValuesActive("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param active - true or false
* @returns true if it was successful, false otherwise
*/
export function SetValuesActive(attributePath: string | null, active: boolean) : boolean;

/**
* Sets ALL Values of the given Attribute to allowed (allowed = true) or hidden (allowed = false)
*
* @example
* PCL.SetValuesAllowed("A_RAM", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param allowed - true or false
* @returns true if it was successful, false otherwise
*/
export function SetValuesAllowed(attributePath: string | null, allowed: boolean) : boolean;

/**
* Selects (selected = true) or deselects (selected = false) the given Value of the given Attribute
*
* @example
* PCL.SetValueSelected("A_RAM", "V_16GB", true);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param selected - true or false
* @returns true if it was successful, false otherwise
*/
export function SetValueSelected(attributePath: string | null, valueId: boolean | number | string | null, selected: boolean) : boolean;

/**
* EXPERIMENTAL FUNCTION!
*     Selects (selected = true) or deselects (selected = false) the given Value of the given Attribute everywhere in the Configuration, including all Sub-Configurations and Root Object
*
* @example
* PCL.SetValueSelectedEverywhere("A_RAM", "V_16GB", true);
*
* @param attributeId - Attribute Identifier
* @param valueId - Value Identifier
* @param selected - true or false
* @returns true if it was successful, false otherwise
*/
export function SetValueSelectedEverywhere(attributeId: string | null, valueId: boolean | number | string | null, selected: boolean) : boolean;

/**
* Sets the Recommendation Score of ALL Values of the given Attribute to the given Score
*
* @example
* PCL.SetValuesRecommendationScore("A_RAM", 16);
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param score - Score value as number (double)
* @returns true if it was successful, false otherwise
*/
export function SetValuesRecommendationScore(attributePath: string | null, score: number) : boolean;

/**
* Sets the given type code fragment assigned to the given Value of the given Attribute
*
* @example
* PCL.SetValueTypeCodeFragment("A_RAM", "V_16GB", "RAM16GB");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param typeCodeFragment - type code fragment
* @returns true if it was successful, false otherwise
*/
export function SetValueTypeCodeFragment(attributePath: string | null, valueId: boolean | number | string | null, typeCodeFragment: string | null) : boolean;

/**
* Sets the given Unit Identifier of the given Value of the given Attribute.
*     Notice: The Unit Identifier must be the content of column "Id" of the dataset of table "PC_Units" which represents respective unit
*
* @example
* PCL.SetValueUnitId("A_RAM", "V_16GB", "GigaByte");
*
* @param attributePath - Attribute Identifier (or Long Distance-Path)
* @param valueId - Value Identifier
* @param unitId - Unit Identifier
* @returns true if it was successful, false otherwise
*/
export function SetValueUnitId(attributePath: string | null, valueId: boolean | number | string | null, unitId: string | null) : boolean;

/**
* Assigns the given Variable Key to the Variables of the currently running configuration and sets it to the given Variable Value representing a JSON object.
*     If the given Variable Key is already assigned, the assignment gets overwritten by the given Variable Value.
*
* @example
* let dataObject = {userType:"client", sessionTimeout:1800, brand:"HyperX"}
*     PCL.SetVariableObject("userData", dataObject, false);
*
* @param key - Variable Key
* @param value - Variable Value
* @param languageDependent - Boolean indicating whether the Variable Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetVariableObject(key: string | null, value: any, languageDependent: boolean) : boolean;

/**
* Assigns the given Variable Key to the Variables of the currently running configuration and sets it to the given Variable Value.
*     If the given Variable Key is already assigned, the assignment gets overwritten by the given Variable Value.
*
* @example
* PCL.SetVariableValue("priority", "high", false);
*
* @param key - Variable Key
* @param value - Variable Value
* @param languageDependent - Boolean indicating whether the Variable Value is language dependent
* @returns true if it was successful, false otherwise
*/
export function SetVariableValue(key: string | null, value: boolean | number | string | null, languageDependent: boolean) : boolean;

/**
* UpdateCurrentObjectCompleteness
*
* @returns The return value.
*/
export function UpdateCurrentObjectCompleteness() : boolean;

/**
* Updates the TypeCode of the currently running configuration and returns it
*
* @example
* PCL.UpdateCurrentObjectTypeCode();
*
* @returns String of updated TypeCode of the currently running configuration
*/
export function UpdateCurrentObjectTypeCode() : string;

/**
* UpdateObjectCompleteness
*
* @param objectPath - The parameter objectPath.
* @returns The return value.
*/
export function UpdateObjectCompleteness(objectPath: string | null) : boolean;

/**
* Updates the TypeCode of the Configuration Object referenced by the given Long Distance-Path and returns it
*
* @example
* PCL.UpdateObjectTypeCode("XAS_EXT_DEVICES/0");
*
* @param objectPath - Long Distance-Path
* @returns String of updated TypeCode of the Configuration Object referenced by the Long Distance-Path
*/
export function UpdateObjectTypeCode(objectPath: string | null) : string | null;

/**
* UpdateRootObjectCompleteness
*
* @returns The return value.
*/
export function UpdateRootObjectCompleteness() : boolean;

/**
* Updates the TypeCode of the Root Configuration Object (i.e. starting point of configuration process) and returns it
*
* @example
* PCL.UpdateRootObjectTypeCode();
*
* @returns String of updated TypeCode of the Root Configuration Object (i.e. starting point of configuration process)
*/
export function UpdateRootObjectTypeCode() : string;

/**
* XmlToJson
*
* @param xml - The parameter xml.
* @returns The return value.
*/
export function XmlToJson(xml: string | null) : any;

