import "./ecl";

const originalJsonParse = JSON.parse;
const originalParseInt = parseInt;
const originalParseFloat = parseFloat;

// waning: full-ecma mode throws exception...
JSON.parse = function (...args) {
  try {
    return originalJsonParse(...args);
  } catch (e) {
    return {};
  }
};

Object.fromJSON = function (json) {
  return JSON.parse(json);
};

/*globalThis.parseInt = function parseInt(str) {
  const result = originalParseInt(str);

  if (isNaN(result) || !isFinite(result)) {
    return 0;
  }

  return result;
};

globalThis.parseFloat = function parseFloat(str) {
  const result = originalParseFloat(str);

  if (isNaN(result) || !isFinite(result)) {
    return 0;
  }

  return result;
};*/

globalThis.getlanguage = function getlanguage() {
  return ECL_GetCurrentLanguage();
};

globalThis.translate = function translate(id) {
  return ECL_Translate(id);
};

globalThis.translate2 = function translate2(id, language) {
  return ECL_Translate(id, language);
};

globalThis.Translate2 = function Translate2(id, language) {
  return ECL_Translate(id, language);
};

globalThis.translateAttribute = function translateAttribute(attrId) {
  return ECL_TranslateAttribute(attrId);
};

globalThis.translateValue = function translateValue(attrId, valueId) {
  return ECL_TranslateValue(attrId, valueId);
};

globalThis._global = function _global() {
  ECL_LogError("_global is not supported");

  return globalThis;
};

globalThis._session = function _session() {
  ECL_LogError("_session is not supported");

  if (!globalThis._sessionData) {
    globalThis._sessionData = {};
  }

  return globalThis._sessionData;
};

globalThis.translateEx = function translateEx(id, transform) {
  ECL_LogError("translateEx is not supported");

  return ECL_Translate(id);
};

globalThis.iscancelationrequested = function iscancelationrequested() {
  ECL_LogError("iscancelationrequested is not supported");

  return false;
};

globalThis.debug = function debug(enable) {
  return ECL_LogError("debug is not supported");
};

globalThis.specialexec = function specialexec(name) {
  return ECL_LogError("specialexec is not supported");
};

globalThis.coscriptexec = function coscriptexec(scriptPath) {
  return ECL_LogError("coscriptexec is not supported");
};

// TODO:
//haslanguage
//Int
//Double
//createguid
