import "./ecl";
import * as pcl from "./pcl";

globalThis.cfgGetIdentCurrentElement = function cfgGetIdentCurrentElement() {
  return ECL_GetCurrentAttribute();
};

globalThis.cfgGetIdentRootStructure = function cfgGetIdentRootStructure() {
  return ECL_GetRootCfgObject();
};

globalThis.cfgGetIdentCurrentStructure = function cfgGetIdentCurrentStructure() {
    return ECL_GetCurrentCfgObject();
};

globalThis.cfgAttributeShow = function cfgAttributeShow(attr) {
  return ECL_ActivateAttribute(attr);
};

globalThis.cfgAttributeHide = function cfgAttributeHide(attr) {
  return ECL_DeactivateAttribute(attr);
};

globalThis.cfgAttributeEnable = function cfgAttributeEnable(attr) {
  return pcl.SetAttributeActive(ECL_ConvertLegacyPath(attr), true);
};

globalThis.cfgAttributeDisable = function cfgAttributeDisable(attr) {
  return pcl.SetAttributeActive(ECL_ConvertLegacyPath(attr), false);
};

globalThis.cfgAttributeValueEnable = function cfgAttributeValueEnable(attr, value) {
  return ECL_EnableValue(attr, value);
};

globalThis.cfgAttributeValueDisable = function cfgAttributeValueDisable(attr, value) {
  return ECL_DisableValue(attr, value);
};

globalThis.cfgAttributeValueEnableAll = function cfgAttributeValueEnableAll(attr) {
  return ECL_EnableAllAttributeValues(attr);
};

globalThis.cfgAttributeValueDisableAll = function cfgAttributeValueDisableAll(attr) {
  return ECL_DisableAllAttributeValues(attr);
};

globalThis.cfgAttributeValueShow = function cfgAttributeValueShow(attr, value) {
  return ECL_ActivateValue(attr, value);
};

globalThis.cfgAttributeValueHide = function cfgAttributeValueHide(attr, value) {
  return ECL_DeactivateValue(attr, value);
};

globalThis.cfgAttributeValueShowAll = function cfgAttributeValueShowAll(attr) {
  return ECL_ActivateAllAttributeValues(attr);
};

globalThis.cfgAttributeValueHideAll = function cfgAttributeValueHideAll(attr) {
  return ECL_DeactivateAllAttributeValues(attr);
};

globalThis.cfgGetMin = function cfgGetMin(attr) {
  return ECL_GetMin(attr);
};

globalThis.cfgGetMax = function cfgGetMax(attr) {
  return ECL_GetMax(attr);
};

globalThis.cfgSetMinMax = function cfgSetMinMax(attr, minValue, maxValue) {
  return ECL_SetMinMax(attr, minValue, maxValue);
};

globalThis.cfgResetMinMax = function cfgResetMinMax(attr) {
  return ECL_ResetMinMax(attr);
};

globalThis.cfgIsAttributeVisible = function cfgIsAttributeVisible(attr) {
  return ECL_AttributeActive(attr);
};

globalThis.cfgIsAttributeEnabled = function cfgIsAttributeEnabled(attr) {
  return ECL_AttributeEnabled(attr);
};

// TODO: hack cfgIsAttributeEnabled should be replaced with cfgIsAttributeActive
globalThis.cfgIsAttributeActive = function cfgIsAttributeActive(attr) {
  return pcl.IsAttributeActive(ECL_ConvertLegacyPath(attr));
};

globalThis.cfgIsAttributeValueVisible = function cfgIsAttributeValueVisible(attr, value) {
  return ECL_ValueActive(attr, value);
};

globalThis.cfgIsAttributeValueEnabled = function cfgIsAttributeValueEnabled(attr, value) {
  return ECL_ValueEnabled(attr, value);
};

globalThis.cfgIsMultiValued = function cfgIsMultiValued(attr) {
  return ECL_GetAttributeMV(attr);
};

globalThis.cfgIsAssigned = function cfgIsAssigned(attr) {
  return ECL_IsAssigned(attr);
};

globalThis.cfgIsValueSelected = function cfgIsValueSelected(attr, value) {
  return ECL_ValueSelected(attr, value);
};

globalThis.cfgIsValueSelectedAnywhere = function cfgIsValueSelectedAnywhere(attr, value) {
  return ECL_ValueSelectedAnywhere(attr, value);
};

globalThis.cfgSelectValue = function cfgSelectValue(attr, value) {
  return ECL_SelectValue(attr, value);
};

globalThis.cfgDeselectAttribute = function cfgDeselectAttribute(attr) {
  return ECL_DeselectAttribute(attr);
};

globalThis.cfgDeselectValue = function cfgDeselectValue(attr, value) {
  return ECL_DeselectValue(attr, value);
};

globalThis.cfgGetStatusProcess = function cfgGetStatusProcess() {
  if (ECL_GetCurrentAttribute() === "@INIT@") {
    return "CFG-STATUS-PROCESS-INIT";
  }

  return "CFG-STATUS-PROCESS-IN-PORCESS";
};

globalThis.cfgAttributeValueGetData = function cfgAttributeValueGetData(attr, valueId, propertyName) {
  const regexExInfo = /^S?EXINFO\.([A-Za-z0-9_.-]+)$/;
  const attrPath = StringOrEmpty(attr);
  const exInfoMatch = StringOrEmpty(propertyName).match(regexExInfo);
  const mapPropId = id => {
    if (id.endsWith(".RAW")) {
      return id.slice(0, -4);
    } else if (id.endsWith(".VALUE")) {
      return id.slice(0, -6);
    } else if (id === "ALIAS") {
      return "Alias";
    }

    return id;
  };

  if (exInfoMatch) {
    const propId = mapPropId(exInfoMatch[1]);

    switch (propId) {
      case "TYPECODE":
        return ECL_GetValueTypecode(attrPath, valueId);
      case "IMAGE":
        return ECL_GetValueImage(attrPath, valueId);
      case "ADATA1":
        return ECL_GetValueArticleNumber(attrPath, valueId);
      case "MASS":
      case "ADATA2":
        return ECL_GetValueMass(attrPath, valueId);
      case "ADATA3":
        return ECL_GetValuePartClass(attrPath, valueId);
      case "EPREIS":
      case "ADATA4":
        return ECL_GetPrice(attrPath, valueId);
      case "ADATA5":
      case "ADATA7":
        const properties = ECL_GetValueProperties(attrPath, valueId) ?? {};
        const propertiesString = Object.entries(properties).map(x => x.join("=")).join(";");
        return propertiesString;
      // TODO: ...
      //case "ALIAS":
      //case "scriptFlags":
    }

    return ECL_GetValueProperty(attrPath, valueId, propId);
  }

  return ECL_GetValueProperty(attrPath, valueId, propertyName);
};

globalThis.cfgAttributeValueSetData = function cfgAttributeValueSetData(attr, value, propertyName, propertyValue) {
  return ECL_SetValueProperty(attr, value, propertyName, propertyValue);
};

globalThis.cfgIsComplete = function cfgIsComplete(path) {
  if (!path) {
    return ECL_IsCurrentObjectComplete();
  }

  return ECL_IsObjectComplete(path);
};

globalThis.cfgSetExtraInfo = function cfgSetExtraInfo(attr, value, propId, propValue) {
  switch (propId) {
    case "TYPECODE":
      return ECL_SetValueTypecode(attrPath, valueId, propValue);
    case "IMAGE":
      return ECL_SetValueImage(attrPath, valueId, propValue);
    case "ADATA1":
      return ECL_SetValueArticleNumber(attrPath, valueId, propValue);
    case "MASS":
    case "ADATA2":
      return ECL_SetValueMass(attrPath, valueId, propValue);
    case "ADATA3":
      return ECL_SetValuePartClass(attrPath, valueId, propValue);
    case "EPREIS":
    case "ADATA4":
      return ECL_SetPrice(attrPath, valueId, propValue);
    // TODO: ...
    //case "ALIAS":
    //case "ADATA5":
    //case "ADATA7":
    //case "scriptFlags":
  }

  return ECL_SetValueProperty(attr, value, propId, propValue);
};

globalThis.cfgGetSize = function cfgGetSize(path) {
  if (ECL_ObjectValid(path)) {
    return ECL_GetAttributeCount(path);
  } else if (ECL_AttributeValid(path)) {
    if (ECL_IsSubConfiguration(path)) {
      return ECL_GetCard(path);
    }

    return ECL_GetValueCount(path);
  }

  return 0;
};

globalThis.cfgSetValue = function cfgSetValue(attr, value) {
  // TODO: see cfgGetValue...
  return ECL_SetValue(attr, value);
};

globalThis.cfgGetValue = function cfgGetValue(attr) {
  const regexExInfo = /\.S?EXINFO\.([A-Za-z0-9_.-]+)$/;
  const regexValue = /(?:\[|\.RANGE\.|\.SEQUENCE\.)([0-9_]+)\]?$/;
  const path = StringOrEmpty(attr);
  const exInfoMatch = path.match(regexExInfo);
  const mapPropId = id => {
    if (id.endsWith(".RAW")) {
      return id.slice(0, -4);
    } else if (id.endsWith(".VALUE")) {
      return id.slice(0, -6);
    } else if (id === "ALIAS") {
      return "Alias";
    }

    return id;
  };

  if (exInfoMatch) {
    const propId = mapPropId(exInfoMatch[1]);
    const prefix = path.slice(0, -exInfoMatch[0].length);

    if (ECL_ObjectValid(prefix)) {
      return ECL_GetObjectProperty(prefix, propId);
    }

    if (ECL_AttributeValid(prefix)) {
      return ECL_GetAttributeProperty(prefix, propId);
    }

    const valueMatch = prefix.match(regexValue);

    if (valueMatch) {
      const valueIndex = valueMatch[1];
      const attrPath = prefix.slice(0, -valueMatch[0].length);
      const valueId = ECL_GetValueByIndex(attrPath, valueIndex);

      switch (propId) {
        case "TYPECODE":
          return ECL_GetValueTypecode(attrPath, valueId);
        case "IMAGE":
          return ECL_GetValueImage(attrPath, valueId);
        case "ADATA1":
          return ECL_GetValueArticleNumber(attrPath, valueId);
        case "MASS":
        case "ADATA2":
          return ECL_GetValueMass(attrPath, valueId);
        case "ADATA3":
          return ECL_GetValuePartClass(attrPath, valueId);
        case "EPREIS":
        case "ADATA4":
          return ECL_GetPrice(attrPath, valueId);
        case "ADATA5":
        case "ADATA7":
              const properties = ECL_GetValueProperties(attrPath, valueId) ?? {};
              const propertiesString = Object.entries(properties).map(x => x.join("=")).join(";");
              return propertiesString;
        // TODO: ...
        //case "ALIAS":
        //case "scriptFlags":
      }

      return ECL_GetValueProperty(attrPath, valueId, propId);
    }
  } else if (path.endsWith(".ID")) {
    const prefix = path.slice(0, -".ID".length);

    if (ECL_ObjectValid(prefix)) {
      if (prefix === "PARENT" && !ECL_GetCurrentCfgStructurePath().includes(".")) {
        return "CFGDATA";
      }

      return ECL_GetObjectId(prefix);
    }

    if (ECL_AttributeValid(prefix)) {
      return ECL_GetAttributeId(prefix);
    }

    const valueMatch = prefix.match(regexValue);

    if (valueMatch) {
      const valueIndex = valueMatch[1];
      const attrPath = prefix.slice(0, -valueMatch[0].length);

      return ECL_GetValueByIndex(attrPath, valueIndex);
    }
  } else if (path === "ID") {
    return ECL_GetObjectId("");
  } else if (path.endsWith(".OBJTYPE")) {
    const prefix = path.slice(0, -".OBJTYPE".length);

    return ECL_GetObjectType(prefix);
  } else if (path === "OBJTYPE") {
    return ECL_GetObjectType("");
  } else if (ECL_AttributeValid(path)) {
    if (ECL_IsSubConfiguration(path)) {
      return ECL_GetAttributeId(path);
    }

    return ECL_GetValue(attr);
  }

  const valueMatch = path.match(regexValue);

  if (valueMatch) {
    const valueIndex = valueMatch[1];
    const attrPath = path.slice(0, -valueMatch[0].length);

    return ECL_GetValueByIndex(attrPath, valueIndex);
  }

  return ECL_GetValue(attr);
};

globalThis.cfgSetState = function cfgSetState() {
  if (arguments.length < 4) {
    const [attr, option, optionValue] = arguments;
    let result;

    switch (option) {
      case "disable":
        if (optionValue) {
          result = ECL_DisableAttribute(attr);
        } else {
          result = ECL_EnableAttribute(attr);
        }
        break;
      default:
        ECL_LogError("cfgSetState: option not supported " + option);
    }

    return result;
  }

  let [attr, value, option, optionValue] = arguments;
  const m = attr.match(/^(.*)\.+RANGE/i);
  let all = false;
  let result;

  if (m) {
    attr = m[1];
    all = true;
  }

  if (all) {
    switch (option) {
      case "disable":
        if (optionValue) {
          result = ECL_DisableAllAttributeValues(attr);
        } else {
          result = ECL_EnableAllAttributeValues(attr);
        }
        break;
      default:
        ECL_LogError("cfgSetState: option not supported " + option);
    }
  } else {
    switch (option) {
      case "disable":
        if (optionValue) {
          result = ECL_DisableValue(attr, value);
        } else {
          result = ECL_EnableValue(attr, value);
        }
        break;
      default:
        ECL_LogError("cfgSetState: option not supported " + option);
    }
  }

  return result;
};
