import "./ecl";
import "./dbrecset";

const databaseResults = {};

Object.fromDatabase = function (database, statement, args) {
  const result = ECL_ObjectFromDatabase(database, statement, args);

  return result;
};

globalThis.dbconnect = function dbconnect() {
  ECL_LogError("dbconnect is not supported");

  return 0;
};

globalThis.dbdisconnect = function dbdisconnect() {
  ECL_LogError("dbdisconnect is not supported");

  return 0;
};

globalThis.dbsetoption = function dbsetoption() {
  ECL_LogError("dbsetoption is not supported");

  return 0;
};

globalThis.dbgetoption = function dbgetoption() {
  ECL_LogError("dbgetoption is not supported");

  return 0;
};

globalThis.dbuppercase = function dbuppercase() {
  ECL_LogError("dbuppercase is not supported");

  return 0;
};

globalThis.dbcopy = function dbcopy() {
  ECL_LogError("dbcopy is not supported");

  return 0;
};

globalThis.dbbuildtable = function dbbuildtable() {
  ECL_LogError("dbbuildtable is not supported");

  return 0;
};

globalThis.dbexecutestatement = function dbexecutestatement() {
  ECL_LogError("dbexecutestatement is not supported");

  return 0;
};

globalThis.dbbuildstatement = function dbbuildstatement() {
  ECL_LogError("dbbuildstatement is not supported");

  return 0;
};

globalThis.dbsqlite3lib = function dbsqlite3lib() {
  ECL_LogError("dbsqlite3lib is not supported");

  return 0;
};

globalThis.dbfullcolmode = function dbfullcolmode() {
  ECL_LogError("dbfullcolmode is not supported");

  return 0;
};

globalThis.dbselect = function dbselect(dbName, statement, dbResult) {
  const recSet = new DBRecSet(dbName, statement);

  databaseResults[dbResult] = recSet;

  return recSet.ok() ? recSet.getNumRecs() : 0;
};

globalThis.dbexecute = function dbexecute(dbName, statement, dbResult) {
  const recSet = new DBRecSet(dbName, statement);

  databaseResults[dbResult] = recSet;

  return recSet.ok() ? 1 : 0;
};

globalThis.dbiseof = function dbiseof(dbResult) {
  if (!(dbResult in databaseResults)) {
    return 1;
  }

  const recSet = databaseResults[dbResult];

  return recSet.ok() ? 0 : 1;
};

globalThis.dbskip = function dbskip(dbResult) {
  if (!(dbResult in databaseResults)) {
    return 0;
  }

  const recSet = databaseResults[dbResult];

  recSet.fetchNext();

  return recSet.ok() ? 1 : 0;
};

globalThis.dbgotop = function dbgotop(dbResult) {
  if (!(dbResult in databaseResults)) {
    return 0;
  }

  const recSet = databaseResults[dbResult];

  recSet.fetchFirst();

  return recSet.ok() ? 1 : 0;
};

globalThis.dbgo = function dbgo(dbResult, offset) {
  if (!(dbResult in databaseResults)) {
    return 0;
  }

  const recSet = databaseResults[dbResult];

  recSet.fetchRelative(offset);

  return recSet.ok() ? 1 : 0;
};

globalThis.dbgetfieldname = function dbgetfieldname(dbResult, colId) {
  if (!(dbResult in databaseResults)) {
    return "";
  }

  const recSet = databaseResults[dbResult];

  return recSet.getFieldName(colId);
};

globalThis.dbgetfieldnr = function dbgetfieldnr(dbResult, colName) {
  if (!(dbResult in databaseResults)) {
    return "";
  }

  const recSet = databaseResults[dbResult];

  return recSet.getFieldNr(colName);
};

globalThis.dbgetstring = function dbgetstring(dbResult, fieldName) {
  if (!(dbResult in databaseResults)) {
    return "";
  }

  const recSet = databaseResults[dbResult];

  return recSet.getString(fieldName);
};

globalThis.dbgetdouble = function dbgetdouble(dbResult, fieldName) {
  if (!(dbResult in databaseResults)) {
    return "";
  }

  const recSet = databaseResults[dbResult];

  return recSet.getDouble(fieldName);
};

globalThis.dbgetnumfields = function dbgetnumfields(dbResult) {
  if (!(dbResult in databaseResults)) {
    return 0;
  }

  const recSet = databaseResults[dbResult];

  return recSet.getNumFields();
};

globalThis.dbgetlasterror = function dbgetlasterror(dbName) {
  const result = ECL_GetLastDatabaseError(dbName);

  return result;
};

globalThis.dbgetlasterrorstate = function dbgetlasterrorstate(dbName) {
  const result = ECL_GetLastDatabaseError(dbName);

  return result;
};
