import "./ecl";

globalThis.DBRecSet = class DBRecSet {
  _database;
  _statement;
  _args;
  _isNonQuery;
  _success;
  _message;
  _columns;
  _rows;
  _row;

  constructor(database, statement, args, isNonQuery) {
    const result = ECL_DatabaseExecuteQuery(database, statement, args);

    this._database = database;
    this._statement = statement;
    this._args = args;
    this._isNonQuery = !!isNonQuery;
    this._success = result.Success;
    this._message = result.Message;
    this._columns = result.Columns;
    this._rows = result.Rows;
    this._row = 0;
  }

  static select(database, statement, args) {
    return new DBRecSet(database, statement, args, false);
  }

  static execute(database, statement, args) {
    return new DBRecSet(database, statement, args, true);
  }

  skip() {
    this.fetchNext();
  }

  next() {
    this.fetchNext();
  }

  go(offset) {
    this.fetchRelative(offset);
  }

  goTop() {
    this.fetchFirst();
  }

  size() {
    return this.getNumRecs();
  }

  delete() {
    if (this._row >= 0 && this._row < this._rows.length) {
      this._rows = this._rows.filter((_, i) => i !== this._row);
    }
  }

  clear() {
    this._columns = [];
    this._rows = [];
    this._row = 0;
  }

  copyToStorage(path) {
    // TODO..
    ECL_LogError("DbRecSet.copyToStorage not implemented");
  }

  getType() {
    // TODO...
    ECL_LogError("DbRecSet.getType not implemented");
  }

  setVal(name, value) {
    // TODO...
    ECL_LogError("DbRecSet.setVal not implemented");
  }

  setValFromIdx(idx, value) {
    // TODO...
    ECL_LogError("DbRecSet.setValFromIdx not implemented");
  }

  getNumRecs() {
    return this._rows.length;
  }

  fetchNext() {
    if (this.ok() || this._row < 0) {
      this._row += 1;
    }
  }

  fetchPrior() {
    if (this.ok() || this._row >= 0) {
      this._row -= 1;
    }
  }

  fetchFirst() {
    if (this.ok()) {
      this._row = 0;
    }
  }

  fetchLast() {
    if (this.ok()) {
      this._row = this._rows.length - 1;
    }
  }

  fetchAbsolute(rowIdx) {
    if (this.ok() || (rowIdx >= 0 && rowIdx < this._rows.length)) {
      this._row = rowIdx;
    } else if (rowIdx < 0) {
      this._row = -1;
    } else {
      this._row = this._rows.length;
    }
  }

  fetchRelative(offset) {
    if (
      this.ok() ||
      (this._row + offset >= 0 && this._row + offset < this._rows.length)
    ) {
      this._row = this._row + offset;
    } else if (this._row + offset < 0) {
      this._row = -1;
    } else {
      this._row = this._rows.length;
    }
  }

  getBool(fieldName) {
    if (!this.ok() || !this.checkFieldExist(fieldName)) {
      return false;
    }

    return Boolean(this._rows[this._row][fieldName] ?? false);
  }

  getBoolFromIdx(fieldIdx) {
    if (!this.ok() || !this.checkFieldIndexExist(fieldIdx)) {
      return false;
    }

    return Boolean(this._rows[this._row][this._columns[fieldIdx]] ?? false);
  }

  getDouble(fieldName) {
    if (!this.ok() || !this.checkFieldExist(fieldName)) {
      return 0;
    }

    return Number(this._rows[this._row][fieldName] ?? 0);
  }

  getDoubleFromIdx(fieldIdx) {
    if (!this.ok() || !this.checkFieldIndexExist(fieldIdx)) {
      return 0;
    }

    return Number(this._rows[this._row][this._columns[fieldIdx]] ?? 0);
  }

  getInt(fieldName) {
    if (!this.ok() || !this.checkFieldExist(fieldName)) {
      return 0;
    }

    return Number(this._rows[this._row][fieldName] ?? 0) | 0;
  }

  getIntFromIdx(fieldIdx) {
    if (!this.ok() || !this.checkFieldIndexExist(fieldIdx)) {
      return 0;
    }

    return Number(this._rows[this._row][this._columns[fieldIdx]] ?? 0) | 0;
  }

  getString(fieldName) {
    if (!this.ok() || !this.checkFieldExist(fieldName)) {
      return "";
    }

    return String(this._rows[this._row][fieldName] ?? "");
  }

  getStringFromIdx(fieldIdx) {
    if (!this.ok() || !this.checkFieldIndexExist(fieldIdx)) {
      return "";
    }

    return String(this._rows[this._row][this._columns[fieldIdx]] ?? "");
  }

  isNull(fieldName) {
    if (!this.ok() || !this.checkFieldExist(fieldName)) {
      return true;
    }

    return this._rows[this._row][fieldName] === null;
  }

  isNullFromIdx(fieldIdx) {
    if (!this.ok() || !this.checkFieldIndexExist(fieldIdx)) {
      return true;
    }

    return this._rows[this._row][this._columns[fieldIdx]] === null;
  }

  getFieldName(fieldIdx) {
    if (!this.checkFieldIndexExist(fieldIdx)) {
      return "";
    }

    return this._columns[fieldIdx];
  }

  getFieldNr(fieldName) {
    return this._columns.indexOf(String(fieldName));
  }

  checkFieldExist(fieldName) {
    return this.getFieldNr(fieldName) >= 0;
  }

  checkFieldIndexExist(index) {
    return index >= 0 && index < this._columns.length;
  }

  getNumFields() {
    return this._columns.length;
  }

  getRowIndex() {
    return this._row;
  }

  getMessage() {
    this._message;
  }

  isEof() {
    return this._row < 0 || this._row >= this._rows.length;
  }

  ok() {
    return this._success && !this.isEof();
  }
};
