export {}

declare type ConfigurationTableParams = {
  /**
   * The table ID
   */
  Id: string;

  /**
   * The locale ID
   */
  LocaleId: string;

  /**
   * Used resolving objects
   */
  ObjectPath: string;

  /**
   * Attribute id of the table
   */
  AttributeId: string;

  /**
   * Filters to apply
   */
  Filters: import("./ConfigurationApi.d.ts").ConfigurationTableFilter[];

  /**
   * Order to apply
   */
  Orderings: import("./ConfigurationApi.d.ts").ConfigurationTableOrder[];

  /**
   * First row ro fetch
   */
  RowCount: number;

  /**
   * Number of rows to fetch
   */
  RowOffset: number;
};

interface GlobalApi {
  OnSaveState: () => void;
  OnRestoreState: () => void;
  OnBeforeAnalyzeTypeCode: () => void;
  OnAfterAnalyzeTypeCode: () => void;
  OnBeforeSaveConfiguration: () => void;
  OnAfterSaveConfiguration: () => void;
  OnBeforeRestoreConfiguration: () => void;
  OnAfterRestoreConfiguration: () => void;
  OnCreateTypeCode: () => void;
  OnCreateBom: () => void;
  OnCreateSummary: () => void;
  OnCreateAssembly: () => void;
  OnCreateDrawing: () => void;
  OnInitializeConfiguration: () => void;
  OnBeforeChangeConfiguration: () => void;
  OnValidateChangeConfiguration: () => void;
  OnCompleteChangeConfiguration: () => void;
  OnChangeConfiguration: () => void;
  OnAfterChangeConfiguration: () => void;
  OnGetTable: (tableParams: ConfigurationTableParams) => void;
  OnInvokeUserDefinedGetter: (name: string | null, input: string | null) => string | null;
  OnInvokeUserDefinedFunction: (name: string | null, input: string | null) => string | null;
}

declare global {
  // causes typing of the parameters of GlobalApi
  var globalThis: GlobalApi;

  // caused completion in the editor
  /**
   * Called every time after the configuration engine enters a script context.
   */
  var OnSaveState: () => void;
  /**
   * Called every time before the configuration engine leaves a script context.
   */
  var OnRestoreState: () => void;
  /**
   * Called before type code analysis (TCA) starts.
   */
  var OnBeforeAnalyzeTypeCode: () => void;
  /**
   * Called after type code analysis (TCA) is complete.
   */
  var OnAfterAnalyzeTypeCode: () => void;
  /**
   * User wants to save data of current evaluation state of the whole Configuration Structure. This routine is called before saving gets processed by Configuration Engine.
   */
  var OnBeforeSaveConfiguration: () => void;
  /**
   * User wants to save data of current evaluation state of the whole Configuration Structure. This routine is called after saving got processed by Configuration Engine.
   */
  var OnAfterSaveConfiguration: () => void;
  /**
   * User wants to load data of current evaluation state of the whole Configuration Structure. This routine is called before loading gets processed by Configuration Engine.
   */
  var OnBeforeRestoreConfiguration: () => void;
  /**
   * User wants to load data of current evaluation state of the whole Configuration Structure. This routine is called after loading got processed by Configuration Engine.
   */
  var OnAfterRestoreConfiguration: () => void;
  /**
   * Called by Configuration Engine after change of data of Configuration Object is processed when recent type code gets composed.
   */
  var OnCreateTypeCode: () => void;
  /**
   * User wants to see the Bill Of Material of the whole Configuration Structure. This routine is called when respective data, which will be displayed, get composed.
   * Thus, it allows modification of these data via PCL functions "GetBom", "GetUpdatedBom" and "SetCustomBom".
   */
  var OnCreateBom: () => void;
  /**
   * User wants to see the summary of the whole Configuration Structure. This routine is called when respective data, which will be displayed, get composed.
   * Thus, it allows modification of these data by script.
   */
  var OnCreateSummary: () => void;
  /**
    * User wants to see the 3D assembly of the whole Configuration Structure. This routine is called when respective data, which will be displayed, get composed.
    * Thus, it allows modification of these data by script.
    */
  var OnCreateAssembly: () => void;
  /**
   * User wants to see the drawing of the whole Configuration Structure. This routine is called when respective data, which will be displayed, get composed.
   * Thus, it allows modification of these data by script.
   */
  var OnCreateDrawing: () => void;
  /**
   * Configuration Object gets initialized after its creation or full reset.
   */
  var OnInitializeConfiguration: () => void;
  /**
   * Called before a change is made to the configuration (e.g. change value, reset, add sub-configuration, ...).
   * If the validation fails, the change is not performed.
   */
  var OnValidateChangeConfiguration: () => void;
  /**
   * Called after a change is made to the configuration and all dependent changes are processed.
   */
  var OnCompleteChangeConfiguration: () => void;
  /**
   * Called once by Configuration Engine before change of data of Configuration Object is processed.
   */
  var OnBeforeChangeConfiguration: () => void;
  /**
   * Called by Configuration Engine as many times as required to process change of data of Configuration Object.
   * 
   * Examples:
   * Change of attribute value, change of Input, change of Output, creation / reset of Configuration Structure
   */
  var OnChangeConfiguration: () => void;
  /**
   * Called once by Configuration Engine after change of data of Configuration Object got processed.
   */
  var OnAfterChangeConfiguration: () => void;
  /**
   * Called by Configuration Engine when a table is displayed or changed.
   */
  var OnGetTable: (tableParams: ConfigurationTableParams) => void;
  /**
   * Configuration Engine dos not run after performance of this event handler, called when a user defined getter is invoked.
   */
  var OnInvokeUserDefinedGetter: (name: string | null, input: string | null) => string | null;
  /**
   * Configuration Engine runs after performance of this event handler, called when a user defined function is invoked.
   */
  var OnInvokeUserDefinedFunction: (name: string | null, input: string | null) => string | null;
}
