globalThis.ObjectToJsonOrNull = function ObjectToJsonOrNull(obj) {
  if (obj === undefined || obj === null) {
    return null;
  }

  try {
    return JSON.stringify(obj);
  } catch {
    return null;
  }
};

globalThis.ObjectFromJsonOrNull = function ObjectFromJsonOrNull(json) {
  if (json === undefined || json === null) {
    return null;
  }

  try {
    return JSON.parse(json);
  } catch {
    return null;
  }
};

globalThis.PrimitiveOrNull = function PrimitiveOrNull(obj) {
  if (obj === undefined || obj === null || typeof obj === "object" || typeof obj === "function") {
    return null;
  }

  return obj;
};

globalThis.ValueOrNull = function ValueOrNull(obj) {
  if (obj === undefined || obj === null) {
    return null;
  }

  return obj;
};

globalThis.ValueOrEmpty = function ValueOrEmpty(obj) {
  if (obj === undefined || obj === null) {
    return "";
  }

  return obj;
};

globalThis.StringOrNull = function StringOrNull(str) {
  if (str === undefined || str === null) {
    return null;
  }

  return String(str);
};

globalThis.StringOrEmpty = function StringOrEmpty(str) {
  if (str === undefined || str === null) {
    return "";
  }

  return String(str);
};

globalThis.NumberOrNull = function NumberOrNull(num) {
  if (num === undefined || num === null) {
    return null;
  }

  return Number(num);
};

globalThis.NumberOrZero = function NumberOrZero(num) {
  if (num === undefined || num === null) {
    return 0;
  }

  return Number(num);
};

globalThis.NumberOrOne = function NumberOrOne(num) {
  if (num === undefined || num === null) {
    return 1;
  }

  return Number(num);
};

globalThis.NumberOrMinusOne = function NumberOrMinusOne(num) {
  if (num === undefined || num === null) {
    return -1;
  }

  return Number(num);
};

globalThis.BooleanOrNull = function BooleanOrNull(value) {
  if (value === undefined || value === null) {
    return null;
  }

  return Boolean(value);
};

globalThis.BooleanOrFalse = function BooleanOrFalse(value) {
  if (value === undefined || value === null) {
    return false;
  }

  return Boolean(value);
};

globalThis.BooleanOrTrue = function BooleanOrTrue(value) {
  if (value === undefined || value === null) {
    return true;
  }

  return Boolean(value);
};
