String.prototype.___replace = String.prototype.replace;

String.prototype.replace = function (a, b, c, d) {
  if (a && a instanceof RegExp) {
    return this.___replace(a, b, c, d);
  }

  return this.replaceAll(a, b);
};

String.prototype.left = function (n) {
  return this.substring(0, n);
};

String.prototype.right = function (n) {
  return this.substring(Math.max(this.length - n, 0));
};

String.prototype.indexOfUtf8 = function (searchValue, fromIndex) {
  return this.indexOf(searchValue, fromIndex);
};

globalThis.left = function left(str, num) {
  if (!str) {
    return "";
  }

  return String(str).left(num);
};

globalThis.right = function right(str, num) {
  if (!str) {
    return "";
  }

  return String(str).right(num);
};

globalThis.mid = function mid(str, pos, count) {
  if (!str) {
    return "";
  }

  return String(str).substring(pos - 1, pos - 1 + count);
};

globalThis.substr = function substr(str, pos1, pos2) {
  if (!str) {
    return "";
  }

  return String(str).substring(pos1 - 1, pos2 - 1);
};

globalThis.escapeRegExp = function escapeRegExp(str) {
  if (!str) {
    return "";
  }

  return String(str).___replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
};

globalThis.trimleft = function trimleft(str, prefix) {
  if (!str) {
    return "";
  }

  const re = new RegExp("^(" + escapeRegExp(prefix) + ")*");

  return String(str).___replace(re, "");
};

globalThis.trimright = function trimright(str, suffix) {
  if (!str) {
    return "";
  }

  const re = new RegExp("(" + escapeRegExp(suffix) + ")*$");

  return String(str).___replace(re, "");
};

globalThis.toupper = function toupper(str) {
  if (!str) {
    return "";
  }

  return String(str).toUpperCase();
};

globalThis.tolower = function tolower(str) {
  if (!str) {
    return "";
  }

  return String(str).toLowerCase();
};

globalThis.replace = function replace(str, a, b) {
  if (!str) {
    return "";
  }

  return String(str).replace(a, b);
};

globalThis.findex = function findex(str, a, startPos, direction = 0) {
  if (!str) {
    return -1;
  }

  const pos =
    direction >= 0
      ? String(str).indexOf(a, startPos - 1)
      : String(str).lastIndexOf(a, startPos - 1);
  if (pos < 0) {
    return -1;
  }

  return pos + 1;
};

globalThis.find = function find(str, a) {
  if (!str) {
    return -1;
  }

  const pos = String(str).indexOf(a);
  if (pos < 0) {
    return -1;
  }

  return pos + 1;
};

globalThis.rfind = function rfind(str, a) {
  if (!str) {
    return -1;
  }

  const pos = String(str).lastIndexOf(a);
  if (pos < 0) {
    return -1;
  }

  return pos + 1;
};

globalThis.findlastof = function findlastof(str, a, b) {
  if (!str) {
    return -1;
  }

  const startPos = b ? b - 1 : 0;
  const pos = String(str).lastIndexOf(a, startPos);
  if (pos < 0) {
    return -1;
  }

  return pos + 1;
};

globalThis.strerase = function strerase(str, pos, count) {
  if (!str || pos <= 0 || count <= 0) {
    return str;
  }

  const startPos = pos - 1;
  const endPos = startPos + count;
  const text = String(str);

  return text.substring(0, startPos) + text.substring(endPos);
};

globalThis.strlen = function strlen(str) {
  if (!str) {
    return 0;
  }

  return String(str).length;
};

globalThis.strlenutf8 = function strlenutf8(str) {
  return strlen(str);
};

globalThis.checkutf8 = function checkutf8(str) {
  return String(str);
};

globalThis.ansi2utf8 = function ansi2utf8(str) {
  return String(str);
};

globalThis.utf8toansi = function utf8toansi(str) {
  return String(str);
};

globalThis.chr = function chr(c) {
  return String.fromCharCode(c);
};

globalThis.comparenocase = function comparenocase(str1, str2) {
  return String(str1).localeCompare(String(str2), undefined, {
    sensitivity: "accent",
  });
};

globalThis.collatenocase = function collatenocase(str1, str2) {
  return String(str1).localeCompare(String(str2), undefined, {
    sensitivity: "accent",
  });
};

globalThis.collatenocaseutf8 = function collatenocaseutf8(str1, str2) {
  return String(str1).localeCompare(String(str2), undefined, {
    sensitivity: "accent",
  });
};

globalThis.substrcount = function substrcount(str, findStr) {
  str = String(str);
  findStr = String(findStr);

  if (findStr.length <= 0) {
    return str.length + 1;
  }

  let count = 0;
  let position = 0;
  let size = findStr.length;

  while (true) {
    position = str.indexOf(findStr, position);

    if (position >= 0) {
      ++count;
      position += size;
    } else {
      break;
    }
  }

  return count;
};

// TODO:
//md5hash
//sha256hash
//sha512hash
//hex2base64
//base64encode
//base64decode
//decodeURI
//encodeURI
//decodeURIComponent
//encodeURIComponent
