import * as ecl from "../eclbase";
import "./Logger";

if (typeof VariantTables === "undefined") {
  globalThis.VariantTables = {};
}

VariantTables.Cache = function () {
  this._hitCount = 0;
  this._missCount = 0;
  this._logger = VariantTables.Logger.getLogger("Cache");

  this._logger.trace("initialized cache");
};

VariantTables.Cache.prototype.getHitRate = function () {
  var accessCount = this._hitCount + this._missCount;
  var hitRate = 1;

  if (accessCount > 0) {
    hitRate = this._hitCount / accessCount;
  }

  return hitRate;
};

VariantTables.Cache.prototype.getStats = function () {
  var accessCount = this._hitCount + this._missCount;
  var hitRate = this.getHitRate();
  var missRate = 1 - hitRate;

  var stats = {
    accessCount: accessCount,
    hitCount: this._hitCount,
    missCount: this._missCount,
    hitRate: hitRate,
    missRate: missRate,
    size: size
  };

  return stats;
};

VariantTables.Cache.prototype.resetStats = function () {
  this._hitCount = 0;
  this._missCount = 0;
};

VariantTables.Cache.prototype.get = function (key) {
  var value = ecl.ECL_GetCacheValue(key) || null;

  return JSON.parse(value);
};

VariantTables.Cache.prototype.set = function (key, value) {
  ecl.ECL_SetCacheValue(key, JSON.stringify(value));
};

VariantTables.Cache.instance = function () {
  if (!globalThis.__variantTablesCache) {
    var cache = new VariantTables.Cache();

    globalThis.__variantTablesCache = cache;
  }

  return globalThis.__variantTablesCache;
};
