import * as ecl from "../eclbase";
import "./Logger";

if (typeof VariantTables === "undefined") {
  globalThis.VariantTables = {};
}

VariantTables.DatabaseInfo = function () { };

VariantTables.DatabaseInfo.GetDatabaseProvider = function (database) {
  const dbProvider = ecl.ECL_GetDatabaseProvider(database);

  return dbProvider;
}

VariantTables.DatabaseInfo.getTableInfo = function (database, tableName) {
  var key = "db::" + database + "::" + tableName;
  var tableInfo = JSON.parse(ecl.ECL_GetCacheValue(key) || null);

  if (tableInfo) {
    return tableInfo;
  }

  var provider = ecl.ECL_GetDatabaseProvider(database);
  var columns;

  if (provider === "Microsoft.Data.Sqlite") {
    var quote = VariantTables.DatabaseInfo.getQuoteFunction(database);
    columns = ecl.ECL_ObjectFromDatabase(database, "PRAGMA table_info(" + quote(tableName) + ")");
  } else {
    columns = ecl.ECL_ObjectFromDatabase(database, "SELECT TABLE_NAME, COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE lower(TABLE_NAME) = lower(?)", [tableName]);
  }

  for (var i = 0; i < columns.length; ++i) {
    var result = columns[i];

    if (result.COLUMN_NAME !== undefined) {
      columns[i] = result.COLUMN_NAME;
    }
    else if (result.column_name !== undefined) {
      columns[i] = result.column_name;
    }
    else if (result.name !== undefined) {
      columns[i] = result.name;
    }
    else {
      columns[i] = result.NAME;
    }

    if (result.TABLE_NAME !== undefined) {
      tableName = result.TABLE_NAME;
    }
    else if (result.table_name !== undefined) {
      tableName = result.table_name;
    }
  }

  tableInfo = { tableName: tableName, columns: columns };

  ecl.ECL_SetCacheValue(key, JSON.stringify(tableInfo));

  return tableInfo;
};

VariantTables.DatabaseInfo.getQuoteFunction = function (database) {
  var key = "quote::" + database;
  var result = ecl.ECL_GetCacheValue(key);
  var quoter;

  if (!result) {
    var provider = ecl.ECL_GetDatabaseProvider(database);

    if (provider === "Microsoft.Data.SqlClient") {
      result = "bracket";
    } else if (provider === "MySqlConnector") {
      result = "backtick";
    } else {
      result = "quote";
    }

    ecl.ECL_SetCacheValue(key, result);
  }

  if (result === "bracket") {
    quoter = function (id) {
      return "[" + id + "]";
    };
  } else if (result === "quote") {
    quoter = function (id) {
      return "\"" + id + "\"";
    };
  } else if (result === "backtick") {
    quoter = function (id) {
      return "`" + id + "`";
    };
  } else {
    quoter = function (id) {
      return id;
    };
  }

  return quoter;
};

VariantTables.DatabaseInfo._logger = VariantTables.Logger.getLogger("DatabaseInfo");
