import * as ecl from "../eclbase";

if (typeof VariantTables === "undefined") {
  globalThis.VariantTables = {};
}

VariantTables.LogLevel = {
  Trace: 5,
  Info: 4,
  Warning: 3,
  Error: 2,
  Fatal: 1
};

VariantTables.Logger = function (prefix) {
  this._prefix = (prefix || "");
};

VariantTables.Logger.setLevel = function (level) {
  VariantTables.Logger._level = level;
};

VariantTables.Logger.getLevel = function () {
  return VariantTables.Logger._level;
};

VariantTables.Logger.getLogger = function (name, context) {
  var logger = new VariantTables.Logger(context ? context + " - " + name : name);

  return logger;
};

VariantTables.Logger.prototype.log = function (label, values) {
  var lineList = new Array(values.length + 3);

  lineList[0] = label;
  lineList[1] = ":";
  lineList[2] = this._prefix;
  for (var i = 0; i < values.length; ++i) {
    var value = values[i];

    lineList[i + 3] = value;
  }

  var line = lineList.join(" ");

  ecl.ECL_Trace(line);
};

VariantTables.Logger.prototype.trace = function () {
  if (VariantTables.Logger._level >= VariantTables.LogLevel.Trace) {
    this.log("[VT: TRACE  ]", arguments);
  }
};

VariantTables.Logger.prototype.info = function () {
  if (VariantTables.Logger._level >= VariantTables.LogLevel.Info) {
    this.log("[VT: INFO   ]", arguments);
  }
};

VariantTables.Logger.prototype.waning = function () {
  if (VariantTables.Logger._level >= VariantTables.LogLevel.Warning) {
    this.log("[VT: WARNING]", arguments);
  }
};

VariantTables.Logger.prototype.error = function () {
  if (VariantTables.Logger._level >= VariantTables.LogLevel.Error) {
    this.log("[VT: ERROR  ]", arguments);
  }
};

VariantTables.Logger.prototype.fatal = function () {
  if (VariantTables.Logger._level >= VariantTables.LogLevel.Fatal) {
    this.log("[VT: FATAL  ]", arguments);
  }
};

VariantTables.Logger._level = VariantTables.LogLevel.Warning;
