import * as ecl from "../eclbase";

if (typeof VariantTables === "undefined") {
  globalThis.VariantTables = {};
}

VariantTables.Test = function () { };

VariantTables.Test.clearLog = function () { };

VariantTables.Test.log = function (message) {
  ecl.ECL_Trace("[VT: TEST   ]: " + message);
};

VariantTables.Test.assert = function (condition, message) {
  if (!condition) {
    VariantTables.Test.log("failed: " + message);
  }
  else {
    VariantTables.Test.log("passed: " + message);
  }
};

VariantTables.Test.describe = function (text, func) {
  var desc = {
    text: text,
    tests: []
  };

  VariantTables.Test._testCases.push(desc);
  VariantTables.Test._current.push(desc);

  VariantTables.Test._onlyTestCase = {
    text: text,
    tests: []
  };

  func();

  VariantTables.Test._current.pop();
};

VariantTables.Test.before = function (func) {
  if (VariantTables.Test._current.length === 0) {
    return;
  }

  var back = VariantTables.Test._current.length - 1;
  VariantTables.Test._current[back].before = func;
};

VariantTables.Test.after = function (func) {
  if (VariantTables.Test._current.length === 0) {
    return;
  }

  var back = VariantTables.Test._current.length - 1;
  VariantTables.Test._current[back].after = func;
};

VariantTables.Test.beforeEach = function (func) {
  if (VariantTables.Test._current.length === 0) {
    return;
  }

  var back = VariantTables.Test._current.length - 1;
  VariantTables.Test._current[back].beforeEach = func;
};

VariantTables.Test.afterEach = function (func) {
  if (VariantTables.Test._current.length === 0) {
    return;
  }

  var back = VariantTables.Test._current.length - 1;
  VariantTables.Test._current[back].afterEach = func;
};

VariantTables.Test.it = function (text, func) {
  if (VariantTables.Test._current.length === 0) {
    return;
  }

  var test = {
    text: text,
    test: func
  };

  var back = VariantTables.Test._current.length - 1;
  VariantTables.Test._current[back].tests.push(test);
};

VariantTables.Test.it.only = function (text, func) {
  if (VariantTables.Test._current.length === 0) {
    return;
  }

  var test = {
    text: text,
    test: func
  };

  VariantTables.Test._onlyTestCase.tests.push(test);
};

VariantTables.Test.run = function () {
  var tests;

  if (VariantTables.Test._onlyTestCase.tests && VariantTables.Test._onlyTestCase.tests.length > 0) {
    tests = [VariantTables.Test._onlyTestCase];
  }
  else {
    tests = VariantTables.Test._testCases;
  }

  VariantTables.Test._runTests(tests);
};

VariantTables.Test._runTests = function (tests, beforeEach, afterEach) {
  for (var i = 0; i < tests.length; ++i) {
    var test = tests[i];

    VariantTables.Test.log(test.text);

    if (test.test) {
      if (beforeEach) {
        beforeEach();
      }

      test.test();

      if (afterEach) {
        afterEach();
      }
    }
    else {
      if (test.before) {
        test.before();
      }

      VariantTables.Test._runTests(test.tests, test.beforeEach, test.afterEach);

      if (test.after) {
        test.after();
      }
    }
  }
};

VariantTables.Test._current = [];
VariantTables.Test._testCases = [];
VariantTables.Test._onlyTestCase = {
  tests: []
};

VariantTables.Test.clearLog();
