if (typeof VariantTables === "undefined") {
  globalThis.VariantTables = {};
}

VariantTables.Util = function () { };

VariantTables.Util.getTime = function () {
  var time = new Date().getTime();

  return time;
};

VariantTables.Util.getInverseUpperCaseMap = function (map) {
  var invMap = {};

  for (var key in map) {
    var value = String(map[key]).toUpperCase();

    if (value !== null) {
      invMap[value] = key;
    }
  }

  return invMap;
};

VariantTables.Util.getArrayAsMap = function (array) {
  var map = {};

  for (var i = 0; i < array.length; ++i) {
    var value = array[i];

    if (value !== null) {
      map[value] = true;
    }
  }

  return map;
};

VariantTables.Util.getArrayAsString = function (array) {
  var values = [];

  if (typeof array !== "object" || array.length < 1) {
    return "";
  }

  for (var i = 0; i < array.length; ++i) {
    var value = array[i];

    if (value === null) {
      values.push("null");
    }
    else {
      values.push(value);
    }
  }

  return values.join(",");
};

/*
HACK
Bug in Array.indexOf:
var idx1 = [null, "*"].indexOf("Motor A"); // expected: -1, actual: 0
var idx2 = [null, "*"].indexOf(320); // expected: -1, actual: -1
var idx3 = [null, "*"].indexOf(""); // expected: -1, actual: 0
var idx4 = [null, "*"].indexOf("*"); // expected: 1, actual: 0
var idx5 = [null, "*"].indexOf(null); // expected: 0, actual: 0
var idx6 = [null, "*"].indexOf(undefined); // expected: -1, actual: 0
var idx7 = [null, "*"].indexOf(({})); // expected: -1, actual: -1

Note: The method below works like the JS version of indexOf.
*/
VariantTables.Util.indexOf = function (array, findV, i /*opt*/) {
  if (i === undefined) i = 0;
  if (i < 0) i += array.length;
  if (i < 0) i = 0;
  for (var n = array.length; i < n; i++)
    if (i in array && array[i] === findV)
      return i;
  return -1;
};
