//@legacy
//#mode(full-ecma)



//@import "VT_1FE1.js"


// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration

// ###################################################################################################################################
// Consequence-Attributes
// ###################################################################################################################################

// ECSI_CC_AdditionalInertia

// IpProtectionLevelMotor


// ECSI_CC_BrakeID


function determineConsequences(sECSI_MLFB) {
    var normalizedMLFB = replace(sECSI_MLFB, '-Z', '');
    normalizedMLFB = replace(sECSI_MLFB, '-', '');
    var baseMLFB = left(normalizedMLFB, 16);
    var ka = right(normalizedMLFB, (normalizedMLFB.length > 16) ? normalizedMLFB.length - 16 : 0);
    var strErr = "";

    /*var aShaftParams = getOutputShaft();
    if (aShaftParams == "ERROR"){
        strErr = "ERR: ShaftParams";
    }
    */
    /*
        [GearboxOutputShaftType, 
         GearboxOutputShaftDiameter,
         OutputShaftLength];
    */

    var oConsequences = {
        //AdditionalInertia 			: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        //IpProtectionLevelMotor  	: getIpProtectionLevelMotor(),
        //BrakeID						: getBrakeID(sECSI_MLFB),
        //VPM							: getVPM(sECSI_MLFB),
        Error_Message: strErr
    }

    return oConsequences;
}

// consequence = name in database table
// operator = max | min | sum

// pro consequence kann es mehrere Origins geben, deren Resultate mit dem Operator verknüpft werden müssen
// Innerhalb einer Origin soll immer nur eine Tabellenzeile verwendet werden, wobei die allgemeinste am Ende kommen muss (daher das DESC im order by)
function determineOneConsequence(baseMLFB, ka, consequence, operator) {
    var dRet = 0;
    if (operator == 'min')
        dRet = 99999;

    var aOrigins = Object.fromDatabase("1FS_ADD_DATA", "select distinct ORIGIN from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' ") || [];

    for (var i = 0; i < aOrigins.length; i++) {
        var resval = determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, aOrigins[i].ORIGIN);
        if (resval != -99999) {
            if ((operator == 'min') && (resval < dRet))
                dRet = resval;
            else if ((operator == 'max') && (resval > dRet))
                dRet = resval;
            else if (operator == 'sum')
                dRet += resval;
        }
    }
    var strRet = '';
    if ((dRet != 0) && (dRet != 99999))
        strRet = '' + dRet;	// als String zurückliefern
    return strRet;
}

function determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, origin) {
    var aResult = Object.fromDatabase("1FE1_ADD_DATA", "select * from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' and ORIGIN = '" + origin + "' order by OPTION DESC");

    for (var i = 0; i < aResult.length; i++) {
        var mlfbPattern = aResult[i]['PATTERN'];
        var dbKAG = aResult[i]['OPTION'];
        var origin = aResult[i]['ORIGIN'];			// für jeden Origin nur max. einen Wert bestimmen
        var resval = aResult[i]['RES_VALUE'] - 0;	// Wert als Zahl bestimmen

        var matchP = true;
        if (mlfbPattern) {
            if (!EK_regFound(baseMLFB, mlfbPattern))
                matchP = false;
        }
        var matchK = true;
        if (dbKAG) {
            if (find(ka, dbKAG) < 0)
                matchK = false;
        }
        if (matchP && matchK) {
            return resval;
        }
    }
    return -99999;
}

function getAdditionalInertia(sECSI_MLFB) {
    // Keine Trägheitsmomente für Bremse, da dies der SIZER selbst addiert!!!

    var AdditionalInertia = 0;
    return AdditionalInertia;
}

function getIpProtectionLevelMotor() {
    // PMD_ABJ176_001_000_1FE1  	Schutzart
    //var IpProtectionLevelMotor = "";
    var IpProtectionLevelMotor = "67";	// derzeit nur IP66/67 IP69K (30bar)
    /*
    00046	IP66/67 IP69K (30bar)
    */
    /*var PMD_ABJ176_001_000_1FE1 = ECL_GetValue("PMD_ABJ176_001_000_1FE1");
    
    /*switch(PMD_ABJ176_001_000_1FE1){
        case "00046":
            IpProtectionLevelMotor = "67";
        break;
        
    }
    */
    return IpProtectionLevelMotor;
}


function getBrakeID(sECSI_MLFB) {
    /**
    //Bremsen Consequences
    */
    var sBrakeID = "";

    var sTable = "BRAKE_ID";

    if (ECL_ValueSelected("CB_HALTEBREMSE_1FE1", "T")) {

        var sMLFB = sECSI_MLFB.left(16);
        var sMLFBpattern = replaceAt(sMLFB, 12, "?");

        // SZ_MBC_M_OrderNumber	SZ_MBC_M_ShortOptions	SZ_MBC_BrakeId	SZ_MBC_IsDefaultBrake
        var sSQL = "SELECT SZ_MBC_BrakeId FROM BRAKE_ID WHERE " +
            "SZ_MBC_M_OrderNumber = '" + sMLFBpattern + "';";

        var aResult = Object.fromDatabase("1FE1_ADD_DATA", sSQL);

        if (aResult.length > 0) {
            sBrakeID = aResult[0].SZ_MBC_BRAKEID;
        } else {
            sBrakeID = "ERROR";
        }
    }
    else {
        sBrakeID = "";
    }

    return sBrakeID;
}


/* in FC verlagert
function getVPM(sECSI_MLFB)
{
    // ECSI_CX_Default_VPM gibt vor, ob ein VPM verbaut werden muss
    // ECSI_CC_VPM enthält die MLFB des VPM
    // ECSI_CC_Selected_VPM ist True/False
    
    var ECSI_CX_Default_VPM = ECL_GetValue("ECSI_CX_Default_VPM");
    
    if (ECSI_CX_Default_VPM == "1" || ECSI_CX_Default_VPM == "True"){
        
        var sMLFB_VPM = "";
        var sMOTORTYPE = left(sECSI_MLFB,10) + "...";
        var sSQL = "SELECT * FROM VPM_DATA WHERE MOTORTYPE = '" + sMOTORTYPE + "';";
        
        var aResult = Object.fromDatabase("1FE1_ADD_DATA", sSQL);
        
        if (aResult.length > 0){
            
            var sMLFB_VPM = aResult[0].MLFB_VPM;
            // Wildcard-Handling
            //todo
            
            return sMLFB_VPM;
            }
        }else{
            return "ERROR";
        }
    }else{
        return "";
        
    }
    
}
*/