//@legacy
//#mode(full-ecma)



//@import "VT_1FE1.js"


/*


MLFB-Schema
    MLFB1-10 fix
    
    MLFB01	1FE1
    MLFB05	Baugröße	{04,05,06,07,08,09,10,11,12,14}
    MLFB07	Baulänge 	HMK_BAULAENGE_1FE1	{1,2,3,4,5,6,7}
    MLFB08	Motor-Polpaarzahl	PMD_ACF149_001_000_1FE1		{4,6,8}
    MLFB09 	(8+9) Motortyp	PMD_AAA259_001_000_1FE1	{4H,4W,6W,8W}
    MLFB10	{C,N,Y,D,E,F,G,H,J,K,L,M,P,Q,R,S,T,U,V,W,X}
    MLFB11	. Motorschutz		PMD_AAA863_001_000_1FE1 {1,3,5}
    MLFB12	0|. VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1}
    MLFB13	. (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
                  Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
    MLFB14	. (B) Ausführung des Ständers (Stator) 		PMD_ACF212_001_000_1FE1 {B,W}
    MLFB15	. Ausführung des Läufers					PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W}
    MLFB16	. Kabelabgang								PMD_AAA759_001_000_1FE1 {0,1,2,3,8}
    
    
    
Motordaten:
    PMD_ABY192_001_000_1006581		Außendurchmesser Stator D	
    PMD_ACL360_001_000_1FE1		Innendurchmesser Rotor d
    HMK_BAULAENGE_1FE1 			Baulänge
    PMD_AAE020_001_000_1FE1		Bemessungsdrehzahl
    PMD_ABJ544_001_000_1FE1		Bemessungsdrehmoment
    PMD_ABP615_001_000_1FE1		Bemessungsleistung
    PMD_ABP635_001_000_1FE1		maximal zul. Drehzahl (mech)
    
    PMD_AAA259_001_000_1FE1		Motortyp
    
    PMD_AAA863_001_000_1FE1		Motorschutz
    PMD_AAA717_001_000_1FE1		Ausführung der Temperaturüberwachung
    
    PMD_ACF212_001_000_1FE1		Ausführung des Ständers
    PMD_ACF213_001_000_1FE1		Ausführung des Läufers

Anschlusstechnik:
    PMD_AAA759_001_000_1FE1		Kabelabgang
    O_X35_X36_1FE1				Sonderanschlusstechnik

Lieferumfang:
    PMD_ABW070_001_000_1FE1		Lieferumfang
    
VPM-Modul	
    HMK_VPM_MODUL_1FE1			VPM-Modul
*/

function SetMotor_Init(oData) {
    if (oData && !isEmpty(oData)) {

        Bestimme_Motordaten(oData);			// 

        Bestimme_Lieferumfang(oData);		// 

        Bestimme_VPM(oData);				// 

        Bestimme_Anschlusstechnik(oData);	// 

    } else {
        // Motordaten
        ExecSetStandardifValueEmpty("PMD_ABY192_001_000_1006581", "95");		// PMD_ABY192_001_000_1006581		Außendurchmesser Stator D	
        ExecSetStandardifValueEmpty("PMD_ACL360_001_000_1FE1", "33");		// Innendurchmesser Rotor d
        ExecSetStandardifValueEmpty("HMK_BAULAENGE_1FE1", "50");				// Baulänge
        ExecSetStandardifValueEmpty("PMD_AAA259_001_000_1FE1", "00005");		// Motortyp

        ExecSetStandardifValueEmpty("PMD_AAE020_001_000_1FE1", "3000");		// Bemessungsdrehzahl
        ExecSetStandardifValueEmpty("PMD_ABJ544_001_000_1FE1", "40");		// Bemessungsdrehmoment
        ExecSetStandardifValueEmpty("PMD_ABP615_001_000_1FE1", "40");		// Bemessungsleistung
        ExecSetStandardifValueEmpty("PMD_ABP635_001_000_1FE1", "");			// maximal zul. Drehzahl (mech)

        ExecSetStandardifValueEmpty("PMD_AAA863_001_000_1FE1", "00006");		// Motorschutz
        ExecSetStandardifValueEmpty("PMD_AAA717_001_000_1FE1", "Z0004");		// Ausführung der Temperaturüberwachung

        ExecSetStandardifValueEmpty("PMD_AAA759_001_000_1FE1", "00003");		// Kabelabgang
        ExecSetStandardifValueEmpty("O_X35_X36_1FE1", "F");					// Sonderanschlusstechnik

        ExecSetStandardifValueEmpty("HMK_VPM_MODUL_1FE1", "00001");			// VPM-Modul
        ExecSetStandardifValueEmpty("PMD_ABW070_001_000_1FE1", "S_R");		// Lieferumfang
        ExecSetStandardifValueEmpty("PMD_ACF212_001_000_1FE1", "MIT");		// Ausführung des Ständers
        ExecSetStandardifValueEmpty("PMD_ACF213_001_000_1FE1", "00001");		// Ausführung des Läufers
    }
}

function SetMotor(strchangedAttribute, oData) {
}
// #########################################################################################################################
/**
Motordaten:
    PMD_ABY192_001_000_1006581		Außendurchmesser Stator D	
    PMD_ACL360_001_000_1FE1		Innendurchmesser Rotor d
    HMK_BAULAENGE_1FE1 			Baulänge
    PMD_AAE020_001_000_1FE1		Bemessungsdrehzahl
    PMD_ABJ544_001_000_1FE1		Bemessungsdrehmoment
    PMD_ABP615_001_000_1FE1		Bemessungsleistung
    PMD_ABP635_001_000_1FE1		maximal zul. Drehzahl (mech)
    
    PMD_AAA259_001_000_1FE1		Motortyp
    
    PMD_AAA863_001_000_1FE1		Motorschutz
    PMD_AAA717_001_000_1FE1		Ausführung der Temperaturüberwachung
    
    PMD_ACF212_001_000_1FE1		Ausführung des Ständers		(VT71)
    PMD_ACF213_001_000_1FE1		Ausführung des Läufers
*/
// #########################################################################################################################
function Bestimme_Motordaten(oData) {

    var oParsingData = oData.oParsingData;

    // -----------------------------------------------------------------------------------------------------------
    // MLFB07	Baulänge 	HMK_BAULAENGE_1FE1	{1,2,3,4,5,6,7}			VT60
    // -----------------------------------------------------------------------------------------------------------
    var MLFB07_1FE1 = oParsingData.MLFB.POS07;

    var sTable = "VT_1FE1_M00060" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB07_1FE1 = '" + MLFB07_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var HMK_BAULAENGE_1FE1 = aResult[0].HMK_BAULAENGE_1FE1;
        ECL_DeactivateAllAttributeValues("HMK_BAULAENGE_1FE1");

        ECL_ActivateValue("HMK_BAULAENGE_1FE1", HMK_BAULAENGE_1FE1);
        ECL_SetValue("HMK_BAULAENGE_1FE1", HMK_BAULAENGE_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_HMK_BAULAENGE");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // Motortyp
    // -----------------------------------------------------------------------------------------------------------
    var MLFB08_1FE1 = oParsingData.MLFB.POS08;
    var MLFB09_1FE1 = oParsingData.MLFB.POS09;

    // VT_1FE1_M00105
    // MLFB08_1FE1	MLFB09_1FE1	PMD_AAA259_001_000_1FE1

    var sTable = "VT_1FE1_M00105" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB08_1FE1 = '" + MLFB08_1FE1 + "' AND " +
        "MLFB09_1FE1 = '" + MLFB09_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAA259_001_000_1FE1 = aResult[0].PMD_AAA259_001_000_1FE1;

        ECL_SetValue("PMD_AAA259_001_000_1FE1", PMD_AAA259_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_MOTORTYP");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // Leistungsdaten
    // -----------------------------------------------------------------------------------------------------------
    /*
    PMD_AAE020_001_000_1FE1		Bemessungsdrehzahl
    PMD_ABJ544_001_000_1FE1		Bemessungsdrehmoment
    PMD_ABP615_001_000_1FE1		Bemessungsleistung
    PMD_ABP635_001_000_1FE1		maximal zul. Drehzahl (mech)
    */
    var MLFB_RUMPF_01_10_1FE1 = oData.oParsingData.RUMPF;

    var sTable = "VT_1FE1_M00099" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "' AND " +
        "HMK_VALUE_VALID_1FE1 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        // Polzahl:
        //PMD_ACF149_001_000_1FE1
        //PMD_ABY204_001_000_1FE1
        // Bemessungsdrehzahl
        var PMD_AAE020_001_000_1FE1 = aResult[0].PMD_AAE020_001_000_1FE1;
        // Bemessungsdrehmoment
        var PMD_ABJ544_001_000_1FE1 = aResult[0].PMD_ABJ544_001_000_1FE1;
        // Bemessungsleistung
        var PMD_ABP615_001_000_1FE1 = aResult[0].PMD_ABP615_001_000_1FE1;

        ECL_SetValue("PMD_AAE020_001_000_1FE1", PMD_AAE020_001_000_1FE1);
        ECL_SetValue("PMD_ABJ544_001_000_1FE1", PMD_ABJ544_001_000_1FE1);
        ECL_SetValue("PMD_ABP615_001_000_1FE1", PMD_ABP615_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_HMK_BAULAENGE");
        return;
    }

    // PMD_ABP635_001_000_1FE1		maximal zul. Drehzahl (mech)
    // VT_1FE1_M00112
    // MLFB_RUMPF_01_10_1FE1	MLFB12_1FE1	PMD_ABP635_001_000_1FE1	HMK_MAX_KW_1FE1
    var MLFB12_1FE1 = oParsingData.MLFB.POS12;

    var sTable = "VT_1FE1_M00112" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "' AND " +
        "MLFB12_1FE1 = '" + MLFB12_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ABP635_001_000_1FE1 = aResult[0].PMD_ABP635_001_000_1FE1;

        ECL_SetValue("PMD_ABP635_001_000_1FE1", PMD_ABP635_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_MAX_N");
        return;
    }



    // -----------------------------------------------------------------------------------------------------------
    // MLFB11	. Motorschutz		PMD_AAA863_001_000_1FE1 {1,3,5}		VT61
    // -----------------------------------------------------------------------------------------------------------

    var MLFB11_1FE1 = oParsingData.MLFB.POS11;

    var sTable = "VT_1FE1_M00061" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB11_1FE1 = '" + MLFB11_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAA863_001_000_1FE1 = aResult[0].PMD_AAA863_001_000_1FE1;
        ECL_ActivateValue("PMD_AAA863_001_000_1FE1", PMD_AAA863_001_000_1FE1);
        ECL_SelectValue("PMD_AAA863_001_000_1FE1", PMD_AAA863_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_MOTORSCHUTZ");
        return;
    }



    // -----------------------------------------------------------------------------------------------------------
    // MLFB14	PMD_ACF212_001_000_1FE1		Ausführung des Ständers		(VT71)
    // -----------------------------------------------------------------------------------------------------------
    var MLFB14_1FE1 = oParsingData.MLFB.POS14;

    var sTable = "VT_1FE1_M00071" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB14_1FE1 = '" + MLFB14_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ACF212_001_000_1FE1 = aResult[0].PMD_ACF212_001_000_1FE1;

        ECL_SetValue("PMD_ACF212_001_000_1FE1", PMD_ACF212_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_STATOR");
        return;
    }


    // -----------------------------------------------------------------------------------------------------------
    // PMD_ABY192_001_000_1006581		Außendurchmesser Stator D	
    // -----------------------------------------------------------------------------------------------------------
    // VT_1FE1_M00100
    // MLFB_RUMPF_01_10_1FE1	MLFB14_1FE1	PMD_ABY192_001_000_1006581	HMK_VALUE_VALID_1FE1

    var sTable = "VT_1FE1_M00100" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "' AND " +
        "MLFB14_1FE1 = '" + MLFB14_1FE1 + "' AND " +
        "HMK_VALUE_VALID_1FE1 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ABY192_001_000_1006581 = aResult[0].PMD_ABY192_001_000_1006581;

        ECL_SetValue("PMD_ABY192_001_000_1006581", PMD_ABY192_001_000_1006581);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_AD_STATOR");
        return;
    }



    // -----------------------------------------------------------------------------------------------------------
    // MLFB15	. Ausführung des Läufers		PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W}		VT72, VT75
    // -----------------------------------------------------------------------------------------------------------

    var MLFB15_1FE1 = oParsingData.MLFB.POS15;

    var sTable = "VT_1FE1_M00072" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB15_1FE1 = '" + MLFB15_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ACF213_001_000_1FE1 = aResult[0].PMD_ACF213_001_000_1FE1;


        ECL_SetValue("PMD_ACF213_001_000_1FE1", PMD_ACF213_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_ROTOR");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // PMD_ACL360_001_000_1FE1		Innendurchmesser Rotor d
    // -----------------------------------------------------------------------------------------------------------

    // VT_1FE1_M00102
    // MLFB_RUMPF_01_10_1FE1	MLFB15_1FE1	PMD_ACL360_001_000_1FE1	HMK_VALUE_VALID_1FE1

    var sTable = "VT_1FE1_M00102" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "' AND " +
        "MLFB15_1FE1 = '" + MLFB15_1FE1 + "' AND " +
        "HMK_VALUE_VALID_1FE1 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ACL360_001_000_1FE1 = aResult[0].PMD_ACL360_001_000_1FE1;

        ECL_SetValue("PMD_ACL360_001_000_1FE1", PMD_ACL360_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_ID_ROTOR");
        return;
    }




    // -----------------------------------------------------------------------------------------------------------
    // MLFB13	. (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
    // -----------------------------------------------------------------------------------------------------------

    var MLFB13_1FE1 = oParsingData.MLFB.POS13;

    var sTable = "VT_1FE1_M00097" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "HMK_KONFIG_TYP_1FE1 = 'KONFIG' AND " +
        "MLFB13_1FE1 = '" + MLFB13_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAA717_001_000_1FE1 = aResult[0].PMD_AAA717_001_000_1FE1;

        ECL_SetValue("PMD_AAA717_001_000_1FE1", PMD_AAA717_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_TEMP_UEBERWACHUNG");
        return;
    }

}
// #########################################################################################################################

// #########################################################################################################################
/**
    PMD_ABW070_001_000_1FE1		Lieferumfang		VT96
    
    MLFB13	. (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
                  Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
*/
// #########################################################################################################################
function Bestimme_Lieferumfang(oData) {
    var oMLFB = oData.oParsingData.MLFB;

    var MLFB13_1FE1 = oMLFB.POS13;

    var sTable = "VT_1FE1_M00096" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB13_1FE1 = '" + MLFB13_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ABW070_001_000_1FE1 = aResult[0].PMD_ABW070_001_000_1FE1;

        ECL_SetValue("PMD_ABW070_001_000_1FE1", PMD_ABW070_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_LIEFERUMFANG");
        return;
    }

}
// #########################################################################################################################

// #########################################################################################################################
/**
    MLFB12	. VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1}		VT62
*/
// #########################################################################################################################
function Bestimme_VPM(oData) {
    var MLFB12_1FE1 = oData.oParsingData.MLFB.POS12;

    if (MLFB12_1FE1 == "1") {
        // mit VPM-Modul
        ECL_SelectValue("HMK_VPM_MODUL_1FE1", "00002");
    } else { // ohne 
        ECL_SelectValue("HMK_VPM_MODUL_1FE1", "00001");
    }
}

// #########################################################################################################################
/**
Anschlusstechnik
    PMD_AAA759_001_000_1FE1		Kabelabgang
    O_X35_X36_1FE1				Sonderanschlusstechnik
    
    MLFB16	. Kabelabgang					PMD_AAA759_001_000_1FE1 {0,1,2,3,8}			VT63
    
*/
// #########################################################################################################################
function Bestimme_Anschlusstechnik(oData) {
    //MLFB16	. Kabelabgang								PMD_AAA759_001_000_1FE1 {0,1,2,3,8}
    var MLFB16_1FE1 = oData.oParsingData.MLFB.POS16;
    if (MLFB16_1FE1 != "8") {
        var sTable = "VT_1FE1_M00063" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "MLFB16_1FE1 = '" + MLFB16_1FE1 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {

            var PMD_AAA759_001_000_1FE1 = aResult[0].PMD_AAA759_001_000_1FE1;

            ECL_SetValue("PMD_AAA759_001_000_1FE1", PMD_AAA759_001_000_1FE1);
        } else {
            oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_ANSCHLUSSTECH");
            return;
        }
    } else {

        // KAG: O_X35_X36_1FE1				Sonderanschlusstechnik			VT68
        // F, X35, X36	

        //if (MLFB16_1FE1 == "8"){

        var oMLFB = oData.oParsingData.MLFB;

        var aKAG = oMLFB.KAG || [];

        var sTargetAttribute = "O_X35_X36_1FE1";
        var bCheck = false;

        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = getKAGforAttribute(sTargetAttribute, oMLFB.KAG);

        if (sKAG != "F") { // Wenn MLFB16 == "8", dann muss es eine KAG geben
            // setzen

            var sTable = "VT_1FE1_M00068" + sDB_Suffix;
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "O_X35_X36_1FE1 = '" + sKAG + "';";

            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0) {

                var PMD_AAA759_001_000_1FE1 = aResult[0].PMD_AAA759_001_000_1FE1;

                ECL_SetValue("PMD_AAA759_001_000_1FE1", PMD_AAA759_001_000_1FE1);

                ECL_ActivateValue(sTargetAttribute, sKAG);
                ECL_SetValue(sTargetAttribute, sKAG);
            } else {
                oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_ANSCHLUSSTECH");
                return;
            }
        } else {
            // keine KAG generiert, 
            oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___MLFB16_NO_KAG");
            return;
        }
    }
}
// #########################################################################################################################
