//@legacy
//#mode(full-ecma)



//@import "../1FE1_MLFB/Base.misc.js"

//@import "VT_1FE1.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute) {
    var strError = "";

    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var sMLFB_BaseType = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    var MLFB12_1FE1_BT = sMLFB_BaseType.charAt(11);

    var MLFB01_1FE1 = sMLFB.substring(0, 4);
    var MLFB05_1FE1 = sMLFB.charAt(4) + sMLFB.charAt(5);

    var MLFB07_1FE1 = sMLFB.charAt(6);
    var MLFB08_1FE1 = sMLFB.charAt(7);
    var MLFB09_1FE1 = sMLFB.charAt(8);
    var MLFB10_1FE1 = sMLFB.charAt(9);
    var MLFB11_1FE1 = sMLFB.charAt(10);
    var MLFB12_1FE1 = sMLFB.charAt(11);
    var MLFB13_1FE1 = sMLFB.charAt(12);
    var MLFB14_1FE1 = sMLFB.charAt(13);
    var MLFB15_1FE1 = sMLFB.charAt(14);
    var MLFB16_1FE1 = sMLFB.charAt(15);

    var MLFB_RUMPF_01_10_1FE1 = sMLFB.substring(0, 10);

    var HMK_KONFIG_TYP_1FE1 = "KONFIG";
    /*
    MLFB11	. Motorschutz		PMD_AAA863_001_000_1FE1 {1,3,5}
    MLFB12	. VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1}
    MLFB13	. (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
                  Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
    MLFB14	. (B) Ausführung des Ständers (Stator) 		PMD_ACF212_001_000_1FE1 {B,W}
    MLFB15	. Ausführung des Läufers					PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W}
    MLFB16	. Kabelabgang								PMD_AAA759_001_000_1FE1 {0,1,2,3,8}
    */

    // ################################################################################################################
    // Motorschutz		PMD_AAA863_001_000_1FE1			MLFB11
    // ################################################################################################################
    /*
    VT_1FE1_M00061	ZO MLFB11 - Wicklungsschutz
        MLFB11_1FE1	PMD_AAA863_001_000_1FE1
    
    MLFB11_1FE1:
    VT_1FE1_M00061	ZO MLFB11 - Wicklungsschutz
    nn. VT_1FE1_M00115	MLFB-Rumpf+MLFB11 <> CAD
    
    ==> keine Einschränkungen
    */

    // ################################################################################################################
    // setze MLFB11
    // ################################################################################################################
    /*
    MLFB11_1FE1		PMD_AAA863_001_000_1FE1
    1				00006
    3				00007
    5				00008
    */
    var PMD_AAA863_001_000_1FE1 = ECL_GetValue("PMD_AAA863_001_000_1FE1");

    var sTable = "VT_1FE1_M00061" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "PMD_AAA863_001_000_1FE1 = '" + PMD_AAA863_001_000_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var MLFB11_1FE1 = aResult[0].MLFB11_1FE1;

        sMLFB = replaceAt(sMLFB, 10, MLFB11_1FE1)
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FE1___PL_MLFB11_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################



    // ################################################################################################################
    // Ausführung der Temperaturüberwachung			PMD_AAA717_001_000_1FE1			MLFB13
    // ################################################################################################################
    /*
    VT_1FE1_M00097	Konfigtyp <> Temp.-Sensor
        HMK_KONFIG_TYP_1FE1	MLFB13_1FE1	PMD_AAA717_001_000_1FE1
    
    
    MLFB13_1FE1: (in Zusammenhang mit Lieferumfang)
        
        VT_1FE1_M00096	ZO MLFB13 - Lieferumfang
            MLFB13_1FE1	PMD_ABW070_001_000_1FE1
        
        VT_1FE1_M00097	Konfigtyp <> Temp.-Sensor
            HMK_KONFIG_TYP_1FE1	MLFB13_1FE1	PMD_AAA717_001_000_1FE1
        
        VT_1FE1_M00104	MLFB13, 14 und 15
            MLFB13_1FE1	MLFB14_1FE1	MLFB15_1FE1	HMK_VALUE_VALID_1FE1
    */
    // ----------------------------------------------------------------------------------------------------------------
    // zunächst MLFB13 einschränken
    // ----------------------------------------------------------------------------------------------------------------
    var sTargetAttribute = "MLFB13_1FE1";

    /* VT_1FE1_M00104	MLFB13, 14 und 15
            MLFB13_1FE1	MLFB14_1FE1	MLFB15_1FE1	HMK_VALUE_VALID_1FE1
    */
    var sTable = "VT_1FE1_M00104" + sDB_Suffix;
    var sWhere = "MLFB14_1FE1 = '" + MLFB14_1FE1 + "' AND " +
        "MLFB15_1FE1 = '" + MLFB15_1FE1 + "' AND " +
        "HMK_VALUE_VALID_1FE1 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_TEMP_MLFB13_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------
    /*	VT_1FE1_M00097	Konfigtyp <> Temp.-Sensor
            HMK_KONFIG_TYP_1FE1	MLFB13_1FE1	PMD_AAA717_001_000_1FE1
    */
    var sTable = "VT_1FE1_M00097" + sDB_Suffix;
    var sWhere = "HMK_KONFIG_TYP_1FE1 = '" + HMK_KONFIG_TYP_1FE1 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_TEMP_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Einschränkung von MLFB13 übertragen auf PMD_AAA717_001_000_1FE1
    // ----------------------------------------------------------------------------------------------------------------
    var sTable = "VT_1FE1_M00097" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB("PMD_AAA717_001_000_1FE1", "MLFB13_1FE1", sTable)

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_TEMP_MLFB13_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // weitere Einschränkung von PMD_AAA717_001_000_1FE1
    // ----------------------------------------------------------------------------------------------------------------
    /* nicht nötig, bereits durch MLFB13 erledigt.
    var sTargetAttribute = "PMD_AAA717_001_000_1FE1";
    
    /*	VT_1FE1_M00097	Konfigtyp <> Temp.-Sensor
            HMK_KONFIG_TYP_1FE1	MLFB13_1FE1	PMD_AAA717_001_000_1FE1
    * /
    var sTable = "VT_1FE1_M00097" + sDB_Suffix;
    var sWhere = 	"HMK_KONFIG_TYP_1FE1 = '" + HMK_KONFIG_TYP_1FE1 + "';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FE1___PL_TEMP_NO_DB_RESULT";
        return strError;
    }
    */


    // ################################################################################################################
    // Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
    // ################################################################################################################
    /* 
    VT_1FE1_M00096	ZO MLFB13 - Lieferumfang
        MLFB13_1FE1	PMD_ABW070_001_000_1FE1
    
    MLFB 13 ist voreingeschränkt, zunächst einschränkung übertragen:
    */
    var sTable = "VT_1FE1_M00096" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABW070_001_000_1FE1", "MLFB13_1FE1", sTable)

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_LIEFER_MLFB13_NO_DB_RESULT";
        return strError;
    }



    // ----------------------------------------------------------------------------------------------------------------
    // MLFB13 aktualisieren (nur mit Lieferumfang zusammen eindeutig!)
    // ----------------------------------------------------------------------------------------------------------------

    var PMD_AAA717_001_000_1FE1 = ECL_GetValue("PMD_AAA717_001_000_1FE1");
    var PMD_ABW070_001_000_1FE1 = ECL_GetValue("PMD_ABW070_001_000_1FE1");
    /*
    VT_1FE1_M00096	ZO MLFB13 - Lieferumfang
        MLFB13_1FE1	PMD_ABW070_001_000_1FE1
        
    VT_1FE1_M00097	Konfigtyp <> Temp.-Sensor
        HMK_KONFIG_TYP_1FE1	MLFB13_1FE1	PMD_AAA717_001_000_1FE1
    */
    var sTable1 = "VT_1FE1_M00096" + sDB_Suffix;
    var sTable2 = "VT_1FE1_M00097" + sDB_Suffix;

    var sSQL = "SELECT DISTINCT " + sTable1 + ".MLFB13_1FE1 FROM " + sTable1 + " " +
        "INNER JOIN " + sTable2 + " ON " +
        sTable2 + ".MLFB13_1FE1 = " + sTable1 + ".MLFB13_1FE1 WHERE " +
        sTable1 + ".PMD_ABW070_001_000_1FE1 = '" + PMD_ABW070_001_000_1FE1 + "' AND " +
        sTable2 + ".HMK_KONFIG_TYP_1FE1 = '" + HMK_KONFIG_TYP_1FE1 + "' AND " +
        sTable2 + ".PMD_AAA717_001_000_1FE1 = '" + PMD_AAA717_001_000_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var MLFB13_1FE1 = aResult[0].MLFB13_1FE1;

        sMLFB = replaceAt(sMLFB, 12, MLFB13_1FE1)
        ECL_SetValue("ECSI_MLFB", sMLFB);
        ECL_SetValue("MLFB13_1FE1", MLFB13_1FE1);
    } else {
        strError = "DICT1_ERR_1FE1___PL_MLFB13_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################


    // ################################################################################################################
    // (B) Ausführung des Ständers (Stator) 		PMD_ACF212_001_000_1FE1 {B,W}			MLFB14
    // ################################################################################################################
    /*
    VT_1FE1_M00071	MLFB14 - Ständerausführung
        MLFB14_1FE1	PMD_ACF212_001_000_1FE1
    
    MLFB14_1FE1
        VT_1FE1_M00071	MLFB14 - Ständerausführung
        VT_1FE1_M00100	Aussendurchmesser Stator
            MLFB_RUMPF_01_10_1FE1	MLFB14_1FE1	PMD_ABY192_001_000_1006581	HMK_VALUE_VALID_1FE1
        
        VT_1FE1_M00104	MLFB13, 14 und 15
            MLFB13_1FE1	MLFB14_1FE1	MLFB15_1FE1	HMK_VALUE_VALID_1FE1
        
    
    MLFB14_1FE1	PMD_ACF212_001_000_1FE1
    B			MIT
    W			NR
    
    */
    // ----------------------------------------------------------------------------------------------------------------
    // zunächst MLFB14 einschränken
    // ----------------------------------------------------------------------------------------------------------------
    var sTargetAttribute = "MLFB14_1FE1";

    /* VT_1FE1_M00104	MLFB13, 14 und 15
            MLFB13_1FE1	MLFB14_1FE1	MLFB15_1FE1	HMK_VALUE_VALID_1FE1
    */
    var sTable = "VT_1FE1_M00104" + sDB_Suffix;
    var sWhere = "MLFB13_1FE1 = '" + MLFB13_1FE1 + "' AND " +
        "MLFB15_1FE1 = '" + MLFB15_1FE1 + "' AND " +
        "HMK_VALUE_VALID_1FE1 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_STATOR_MLFB14_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------
    /*	VT_1FE1_M00100	Konfigtyp <> Temp.-Sensor
            MLFB_RUMPF_01_10_1FE1	MLFB14_1FE1	PMD_ABY192_001_000_1006581	HMK_VALUE_VALID_1FE1
    */
    var sTable = "VT_1FE1_M00100" + sDB_Suffix;
    var sWhere = "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_STATOR_MLFB14_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Einschränkung von MLFB14_1FE1 übertragen auf PMD_ACF212_001_000_1FE1
    // ----------------------------------------------------------------------------------------------------------------
    /*
    VT_1FE1_M00071	MLFB14 - Ständerausführung
        MLFB14_1FE1	PMD_ACF212_001_000_1FE1
    */
    var sTable = "VT_1FE1_M00071" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB("PMD_ACF212_001_000_1FE1", "MLFB14_1FE1", sTable)

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_STATOR_MLFB14_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // weitere Einschränkung von PMD_ACF212_001_000_1FE1
    // ----------------------------------------------------------------------------------------------------------------

    // keine

    // ----------------------------------------------------------------------------------------------------------------
    // MLFB14_1FE1 aktualisieren
    // ----------------------------------------------------------------------------------------------------------------
    /*
    VT_1FE1_M00071	MLFB14 - Ständerausführung
        MLFB14_1FE1	PMD_ACF212_001_000_1FE1
    */
    var PMD_ACF212_001_000_1FE1 = ECL_GetValue("PMD_ACF212_001_000_1FE1");

    var sTable = "VT_1FE1_M00071" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "PMD_ACF212_001_000_1FE1 = '" + PMD_ACF212_001_000_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var MLFB14_1FE1 = aResult[0].MLFB14_1FE1;

        sMLFB = replaceAt(sMLFB, 13, MLFB14_1FE1)
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FE1___PL_MLFB14_NO_DB_RESULT";
        return strError;
    }

    // -----------------------------------------------------------------------------------------------------------
    // Außendurchmesser Stator D		PMD_ABY192_001_000_1006581
    // -----------------------------------------------------------------------------------------------------------
    var sTargetAttribute = "PMD_ABY192_001_000_1006581";
    // VT_1FE1_M00100
    // MLFB_RUMPF_01_10_1FE1	MLFB14_1FE1	PMD_ABY192_001_000_1006581	HMK_VALUE_VALID_1FE1

    var aValidValuesMLFB14 = ECL_GetAllActiveAttributeValues("MLFB14_1FE1");

    var sWhereMLFB14 = "(MLFB14_1FE1 = '" + aValidValuesMLFB14[0] + "' ";
    if (aValidValuesMLFB14.length > 1) {
        for (var i = 1; i < aValidValuesMLFB14.length; i++) {
            sWhereMLFB14 += "OR MLFB14_1FE1 = '" + aValidValuesMLFB14[i] + "' ";
        }
    }
    sWhereMLFB14 += ") AND ";

    var sTable = "VT_1FE1_M00100" + sDB_Suffix;
    var sWhere = "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "' AND " +
        sWhereMLFB14 +
        "HMK_VALUE_VALID_1FE1 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_STATOR_AD_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Ausführung des Läufers		PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W}		MLFB15
    // ################################################################################################################
    /*
    VT_1FE1_M00072	MLFB15 - Läuferausführung
        MLFB15_1FE1	PMD_ACF213_001_000_1FE1
    
    MLFB15_1FE1:
        VT_1FE1_M00072	MLFB15 - Läuferausführung
        
        VT_1FE1_M00075	MLFB05_06,07,08 + 15
            MLFB05_1FE1	MLFB07_1FE1	MLFB08_1FE1	MLFB15_1FE1
        
        VT_1FE1_M00102	Innendurchmesser Rotor
            MLFB_RUMPF_01_10_1FE1	MLFB15_1FE1	PMD_ACL360_001_000_1FE1	HMK_VALUE_VALID_1FE1
        
        VT_1FE1_M00104	MLFB13, 14 und 15
            MLFB13_1FE1	MLFB14_1FE1	MLFB15_1FE1	HMK_VALUE_VALID_1FE1
        
    nn	VT_1FE1_M00118	Tech. Daten in Abhängigkeit zu MLFB15
    
    
    VT_1FE1_M00072:
    MLFB15_1FE1	PMD_ACF213_001_000_1FE1
    A			00004
    R			00004
    B			00003
    C			00002					nicht eindeutig
    D			00002					nicht eindeutig
    E			00002					nicht eindeutig
    W			00001

    */
    // ----------------------------------------------------------------------------------------------------------------
    // zunächst MLFB15_1FE1 einschränken
    // ----------------------------------------------------------------------------------------------------------------
    var sTargetAttribute = "MLFB15_1FE1";

    /* VT_1FE1_M00104	MLFB13, 14 und 15
            MLFB13_1FE1	MLFB14_1FE1	MLFB15_1FE1	HMK_VALUE_VALID_1FE1
    */
    var sTable = "VT_1FE1_M00104" + sDB_Suffix;
    var sWhere = "MLFB13_1FE1 = '" + MLFB13_1FE1 + "' AND " +
        "MLFB14_1FE1 = '" + MLFB14_1FE1 + "' AND " +
        "HMK_VALUE_VALID_1FE1 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_ROTOR_MLFB15_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------
    /*	VT_1FE1_M00075	MLFB05_06,07,08 + 15
            MLFB05_1FE1	MLFB07_1FE1	MLFB08_1FE1	MLFB15_1FE1
    */
    var sTable = "VT_1FE1_M00075" + sDB_Suffix;
    var sWhere = "MLFB05_1FE1 = '" + MLFB05_1FE1 + "' AND " +
        "MLFB07_1FE1 = '" + MLFB07_1FE1 + "' AND " +
        "MLFB08_1FE1 = '" + MLFB08_1FE1 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_ROTOR_MLFB15_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------
    /*	VT_1FE1_M00102	Innendurchmesser Rotor
            MLFB_RUMPF_01_10_1FE1	MLFB15_1FE1	PMD_ACL360_001_000_1FE1	HMK_VALUE_VALID_1FE1
    */
    var sTable = "VT_1FE1_M00102" + sDB_Suffix;
    var sWhere = "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_ROTOR_MLFB15_NO_DB_RESULT";
        return strError;
    }

    // ----------------------------------------------------------------------------------------------------------------
    // Einschränkung von MLFB15_1FE1 übertragen auf PMD_ACF213_001_000_1FE1
    // ----------------------------------------------------------------------------------------------------------------
    /*
    VT_1FE1_M00072	MLFB15 - Läuferausführung
        MLFB15_1FE1	PMD_ACF213_001_000_1FE1
    */
    var sTable = "VT_1FE1_M00072" + sDB_Suffix;
    var sStatus = SetAttributeLogicFromMLFB("PMD_ACF213_001_000_1FE1", "MLFB15_1FE1", sTable)

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_ROTOR_MLFB15_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // weitere Einschränkung von PMD_ACF213_001_000_1FE1
    // ----------------------------------------------------------------------------------------------------------------

    // keine



    // ----------------------------------------------------------------------------------------------------------------
    // MLFB15_1FE1 aktualisieren
    // ----------------------------------------------------------------------------------------------------------------
    /*
    VT_1FE1_M00072	MLFB15 - Läuferausführung
        MLFB15_1FE1	PMD_ACF213_001_000_1FE1
    */
    var PMD_ACF213_001_000_1FE1 = ECL_GetValue("PMD_ACF213_001_000_1FE1");

    var aValidValuesMLFB15 = ECL_GetAllActiveAttributeValues("MLFB15_1FE1");

    var sWhereMLFB15 = "(MLFB15_1FE1 = '" + aValidValuesMLFB15[0] + "' ";
    if (aValidValuesMLFB15.length > 1) {
        for (var i = 1; i < aValidValuesMLFB15.length; i++) {
            sWhereMLFB15 += "OR MLFB15_1FE1 = '" + aValidValuesMLFB15[i] + "' ";
        }
    }
    sWhereMLFB15 += ") AND ";


    var sTable = "VT_1FE1_M00072" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        sWhereMLFB15 +
        "PMD_ACF213_001_000_1FE1 = '" + PMD_ACF213_001_000_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var MLFB15_1FE1 = aResult[0].MLFB15_1FE1;

        sMLFB = replaceAt(sMLFB, 14, MLFB15_1FE1)
        ECL_SetValue("ECSI_MLFB", sMLFB);
        ECL_SetValue("MLFB15_1FE1", MLFB15_1FE1);
    } else {
        strError = "DICT1_ERR_1FE1___PL_MLFB15_NO_DB_RESULT";
        return strError;
    }


    // -----------------------------------------------------------------------------------------------------------
    // Innendurchmesser Rotor d		PMD_ACL360_001_000_1FE1
    // -----------------------------------------------------------------------------------------------------------

    // VT_1FE1_M00102
    // MLFB_RUMPF_01_10_1FE1	MLFB15_1FE1	PMD_ACL360_001_000_1FE1	HMK_VALUE_VALID_1FE1
    var sTargetAttribute = "PMD_ACL360_001_000_1FE1";



    var sTable = "VT_1FE1_M00102" + sDB_Suffix;
    var sWhere = "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "' AND " +
        sWhereMLFB15 +
        "HMK_VALUE_VALID_1FE1 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_ROTOR_ID_NO_DB_RESULT";
        return strError;
    }

    // Wert setzen für gewählte MLFB15 (abhängig von Läuferausführung):
    if (strchangedAttribute == "PMD_ACF213_001_000_1FE1") {
        var MLFB15_1FE1 = ECL_GetValue("MLFB15_1FE1");

        var sTable = "VT_1FE1_M00102" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "' AND " +
            "MLFB15_1FE1 = '" + MLFB15_1FE1 + "' AND " +
            "HMK_VALUE_VALID_1FE1 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {

            var PMD_ACL360_001_000_1FE1 = aResult[0].PMD_ACL360_001_000_1FE1;
            ECL_SelectValue("PMD_ACL360_001_000_1FE1", PMD_ACL360_001_000_1FE1);
        }
    }
    // ################################################################################################################

    // MLFB15 aktualisieren
    var PMD_ACL360_001_000_1FE1 = ECL_GetValue("PMD_ACL360_001_000_1FE1");

    var sTable = "VT_1FE1_M00102" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "' AND " +
        "PMD_ACL360_001_000_1FE1 = '" + PMD_ACL360_001_000_1FE1 + "' AND " +
        "HMK_VALUE_VALID_1FE1 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var MLFB15_1FE1 = aResult[0].MLFB15_1FE1;

        sMLFB = replaceAt(sMLFB, 14, MLFB15_1FE1)
        ECL_SetValue("ECSI_MLFB", sMLFB);
        ECL_SetValue("MLFB15_1FE1", MLFB15_1FE1);
    } else {
        strError = "DICT1_ERR_1FE1___PL_MLFB15_NO_DB_RESULT";
        return strError;
    }

    //wenn geändert, dann Läuferausführung aktualisieren
    if (strchangedAttribute == "PMD_ACL360_001_000_1FE1") {
        var MLFB15_1FE1 = ECL_GetValue("MLFB15_1FE1");

        var sTable = "VT_1FE1_M00072" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "MLFB15_1FE1 = '" + MLFB15_1FE1 + "';";


        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {

            var PMD_ACF213_001_000_1FE1 = aResult[0].PMD_ACF213_001_000_1FE1;
            ECL_SelectValue("PMD_ACF213_001_000_1FE1", PMD_ACF213_001_000_1FE1);
        }
    }
    // ################################################################################################################
    // VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1} 	 MLFB12
    // ################################################################################################################
    /*
    VT_1FE1_M00062	ZO MLFB12 - VPM
        MLFB12_1FE1	HMK_VPM_MODUL_1FE1
    
    MLFB12_1FE1:
        VT_1FE1_M00062	ZO MLFB12 - VPM
    nn	VT_1FE1_M00110	Chartlinie M - Rumpf/Spannung
    nn	VT_1FE1_M00111	Chartlinie P - Rumpf/Spannung
        VT_1FE1_M00112	Max. Drehzahl / Max. Leistung
            MLFB_RUMPF_01_10_1FE1	MLFB12_1FE1	PMD_ABP635_001_000_1FE1	HMK_MAX_KW_1FE1
    
    */
    // ----------------------------------------------------------------------------------------------------------------
    // Einschränkungen aus MLFB12_1FE1:
    // ----------------------------------------------------------------------------------------------------------------
    // nur, wenn nicht mit MLFB vorgegeben
    if (MLFB12_1FE1_BT == ".") {
        ECL_EnableAttribute("HMK_VPM_MODUL_1FE1");
        var sTargetAttribute = "MLFB12_1FE1";

        /* VT_1FE1_M00112	Max. Drehzahl / Max. Leistung
                MLFB_RUMPF_01_10_1FE1	MLFB12_1FE1	PMD_ABP635_001_000_1FE1	HMK_MAX_KW_1FE1
        */
        var sTable = "VT_1FE1_M00112" + sDB_Suffix;
        var sWhere = "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE1___PL_VPM_MLFB12_NO_DB_RESULT";
            return strError;
        }

        // ----------------------------------------------------------------------------------------------------------------
        // Einschränkung von MLFB12 übertragen auf HMK_VPM_MODUL_1FE1
        // ----------------------------------------------------------------------------------------------------------------
        var sTable = "VT_1FE1_M00062" + sDB_Suffix;
        var sStatus = SetAttributeLogicFromMLFB("HMK_VPM_MODUL_1FE1", "MLFB12_1FE1", sTable)

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE1___PL_VPM_MLFB12_NO_DB_RESULT";
            return strError;
        }

        // ----------------------------------------------------------------------------------------------------------------
        // setze MLFB12
        // ----------------------------------------------------------------------------------------------------------------
        /*
        MLFB12_1FE1	HMK_VPM_MODUL_1FE1
        0			00001
        1			00002

        */
        var HMK_VPM_MODUL_1FE1 = ECL_GetValue("HMK_VPM_MODUL_1FE1");

        var sTable = "VT_1FE1_M00062" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "HMK_VPM_MODUL_1FE1 = '" + HMK_VPM_MODUL_1FE1 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {

            var MLFB12_1FE1 = aResult[0].MLFB12_1FE1;

            sMLFB = replaceAt(sMLFB, 11, MLFB12_1FE1)
            ECL_SetValue("MLFB12_1FE1", MLFB12_1FE1);
            ECL_SetValue("ECSI_MLFB", sMLFB);
        } else {
            strError = "DICT1_ERR_1FE1___PL_MLFB12_NO_DB_RESULT";
            return strError;
        }
    } else {
        ECL_DisableAttribute("HMK_VPM_MODUL_1FE1");
    }
    // ################################################################################################################


    // ################################################################################################################
    // Kabelabgang		PMD_AAA759_001_000_1FE1 {0,1,2,3,8}		MLFB16_1FE1
    // ################################################################################################################
    /*
    VT_1FE1_M00063	ZO MLFB16 - Anschlussart
        MLFB16_1FE1	PMD_AAA759_001_000_1FE1
    
    VT_1FE1_M00068	ZO X35, X36
        PMD_AAA759_001_000_1FE1	O_X35_X36_1FE1
    
    MLFB16 nur in VT63, keine weitere Einschränkung

    VT_1FE1_M00120	ZO MLFB13 - X35, X36
        MLFB13_1FE1	    PMD_AAA759_001_000_1FE1
    */
    var sTargetAttribute = "PMD_AAA759_001_000_1FE1";

    var sTable = "VT_1FE1_M00120" + sDB_Suffix;
    var sWhere = "MLFB13_1FE1 = '" + MLFB13_1FE1 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_PMD_AAA759_NO_DB_RESULT";
        return strError;
    }

    // MLFB16 aktualisieren
    var PMD_AAA759_001_000_1FE1 = ECL_GetValue("PMD_AAA759_001_000_1FE1");

    var sTable = "VT_1FE1_M00063" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "PMD_AAA759_001_000_1FE1 = '" + PMD_AAA759_001_000_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var MLFB16_1FE1 = aResult[0].MLFB16_1FE1;

        sMLFB = replaceAt(sMLFB, 15, MLFB16_1FE1)
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FE1___PL_MLFB16_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Sonderanschlusstechnik		O_X35_X36_1FE1	VT68
    // ################################################################################################################
    /*
    VT_1FE1_M00068	ZO X35, X36
        PMD_AAA759_001_000_1FE1	O_X35_X36_1FE1
    */
    var sTargetAttribute = "O_X35_X36_1FE1";

    //var PMD_AAA759_001_000_1FE1 = ECL_GetValue("PMD_AAA759_001_000_1FE1");

    var sTable = "VT_1FE1_M00068" + sDB_Suffix;
    var sWhere = "PMD_AAA759_001_000_1FE1 = '" + PMD_AAA759_001_000_1FE1 + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE1___PL_KABEL_KAG_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################



    // ################################################################################################################
    // maximal zul. Drehzahl (mech)
    // ################################################################################################################

    // PMD_ABP635_001_000_1FE1		maximal zul. Drehzahl (mech)
    // VT_1FE1_M00112
    // MLFB_RUMPF_01_10_1FE1	MLFB12_1FE1	PMD_ABP635_001_000_1FE1	HMK_MAX_KW_1FE1

    var sTable = "VT_1FE1_M00112" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB_RUMPF_01_10_1FE1 = '" + MLFB_RUMPF_01_10_1FE1 + "' AND " +
        "MLFB12_1FE1 = '" + MLFB12_1FE1 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ABP635_001_000_1FE1 = aResult[0].PMD_ABP635_001_000_1FE1;

        ECL_SetValue("PMD_ABP635_001_000_1FE1", PMD_ABP635_001_000_1FE1);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE1___NO_DB_RESULT_MAX_N");
        return;
    }

    // ################################################################################################################
    // ################################################################################################################
    return "OK";

}
