//@legacy
//#mode(full-ecma)

//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"

//@import "../1FE1_MLFB/Base.misc.js"

//@import "../1FE1_CONFIG/VT_1FE1.js"

/**
 * @category   1FE1 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2021 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init(strMLFB) {
  vtTimeStart = Date.getTime();

  var oParsing = {
    strBaseMLFB: "",
    strFullMLFB: "",
    strError: "",
    strWarning: "",
    aTokens: [],
    oFreetext: {},
  };

  var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

  strMLFB = normalizeMLFB(strMLFB);
  strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

  var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

  if (strStartConfiguration == "" && find(strMLFB.left(16), ".") >= 0)
    strStartConfiguration = "1";

  //if(strStartConfiguration=="1")
  //{
  //Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
  //Hier sollen dann möglichst viele Attribute beibehalten werden.
  //Die Basetype MLFB kann sich in Getriebe, Motor oder Übersetzung von der Haupt MLFB unterscheiden.
  if (strBaseTypeMLFB != "") {
    //--------------------------------------------------------------------------------------------------------
    // Base Type  MLFB aufbereiten
    //--------------------------------------------------------------------------------------------------------
    var aBTComponents = tokenize(strBaseTypeMLFB);
    if (aBTComponents.length > 1) {
      // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
      // eliminate the resulting invalid short description 'Z'
      if (aBTComponents[1] === "Z" || aBTComponents[1] === "-Z") {
        aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
      }
    }

    strBaseTypeMLFB = aBTComponents[0];

    if (strBaseTypeMLFB.length === 17) {
      // eliminate the -Z
      strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
    }

    var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring(0, 10);
  }

  var oResult;

  var nFreetext = find(strMLFB, "{");
  var strFreetext = "";
  if (nFreetext > 0) {
    strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
  }
  oParsing.oFreetext = parseFreetext(strFreetext, true);
  strMLFB = replace(strMLFB, strFreetext, "");
  oParsing.strFullMLFB = strMLFB;

  var aComponents = tokenize(strMLFB);
  if (!aComponents.length) {
    oParsing.strError = "ERRORMSG_MLFB_1FE1___INVALID_MLFB";
    return oParsing;
  } else if (aComponents.length > 1) {
    // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
    // eliminate the resulting invalid short description 'Z'
    if (aComponents[1] === "Z" || aComponents[1] === "-Z") {
      aComponents = removeElementsFromArray(aComponents, 1, 1);
    }
  }
  oParsing.strBaseMLFB = aComponents[0];
  oParsing.aTokens = aComponents;

  var strMLFB_fix = strMLFB.substring(0, 10); //

  // EDIT RepairConfig added
  if (
    strStartConfiguration == "1" &&
    strBaseTypeMLFB_fix == strMLFB_fix &&
    strBaseTypeMLFB != "" &&
    find(strMLFB.left(16), ".") < 0
  ) {
    // if same motor is selected again
    var bRepairConfig = true;
  }
  // -----------------------------------------------------------------------------------------------
  //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
  // -----------------------------------------------------------------------------------------------
  if (
    (strBaseTypeMLFB_fix != strMLFB_fix &&
      find(strMLFB.left(16), ".") < 0 &&
      strBaseTypeMLFB != "") ||
    bRepairConfig
  ) {
    // -----------------------------------------------------------------------------------------------
    // Platzhalter aus MLFB in BT übernehmen
    // -----------------------------------------------------------------------------------------------
    /* MLFB-Schema
                MLFB1-10 fix
    
                MLFB01	1FE1
                MLFB05	Baugröße	{04,05,06,07,08,09,10,11,12,14}
                MLFB07	Baulänge 	HMK_BAULAENGE_1FE1	{1,2,3,4,5,6,7}
                MLFB08	Motor-Polpaarzahl	PMD_ACF149_001_000_1FE1		{4,6,8}
                MLFB09 	(8+9) Motortyp	PMD_AAA259_001_000_1FE1	{4H,4W,6W,8W}
                MLFB10	{C,N,Y,D,E,F,G,H,J,K,L,M,P,Q,R,S,T,U,V,W,X}
                MLFB11	. Motorschutz		PMD_AAA863_001_000_1FE1 {1,3,5}
                MLFB12	. VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1}
                MLFB13	. (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
                              Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
                MLFB14	. (B) Ausführung des Ständers (Stator) 		PMD_ACF212_001_000_1FE1 {B,W}
                MLFB15	. Ausführung des Läufers					PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W}
                MLFB16	. Kabelabgang								PMD_AAA759_001_000_1FE1 {0,1,2,3,8}
            */
    // 11 bis 16 ein Wildcard, dann Wert aus alter MLFB setzen, ggf. Default setzen

    // --------------------------------------------------------------------------------------------------------
    // MLFB11 Motorschutz
    // --------------------------------------------------------------------------------------------------------
    var sMLFB11 = strMLFB.charAt(10);
    var sBT_MLFB11 = strBaseTypeMLFB.charAt(10);

    if (sBT_MLFB11 == ".") {
      // check-routine:
      sMLFB11 = getMLFB11default_1FE1(strBaseTypeMLFB, sMLFB11);
      if (sMLFB11 !== "ERROR") {
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 10, sMLFB11);
      } else {
        oParsing.strError = "ERRORMSG_MLFB_1FE1___PARSER_NO_DB_RESULT_MLFB11";
        return oParsing;
      }
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB12 VPM-Modul
    // --------------------------------------------------------------------------------------------------------
    var sMLFB12 = strMLFB.charAt(11);
    var sBT_MLFB12 = strBaseTypeMLFB.charAt(11);

    if (sBT_MLFB12 == ".") {
      // Check VPM
      // MLFB_RUMPF_01_10_1FE1	MLFB12_1FE1	PMD_ABP635_001_000_1FE1	HMK_MAX_KW_1FE1
      var sTable = "VT_1FE1_M00112" + sDB_Suffix;
      var sSQL =
        "SELECT * FROM " +
        sTable +
        " WHERE " +
        "MLFB_RUMPF_01_10_1FE1 = '" +
        strBaseTypeMLFB.substring(0, 10) +
        "' AND " +
        "MLFB12_1FE1 = '" +
        sMLFB12 +
        "';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length < 1) {
        var sSQL =
          "SELECT * FROM " +
          sTable +
          " WHERE " +
          "MLFB_RUMPF_01_10_1FE1 = '" +
          strBaseTypeMLFB.substring(0, 10) +
          "';";

        var aResult = GetDBDataSetEXT(sSQL);

        if (aResult.length > 0) {
          sMLFB12 = aResult[0].MLFB12_1FE1;
        } else {
          oParsing.strError = "ERRORMSG_MLFB_1FE1___NO_DB_RESULT_VPE_MLFB12";
          return oParsing;
        }
      }

      strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
    }

    // Check VT104	MLFB13_1FE1	MLFB14_1FE1	MLFB15_1FE1	HMK_VALUE_VALID_1FE1
    // --------------------------------------------------------------------------------------------------------
    // MLFB13 Ausführung der Temperaturüberwachung / Lieferumfang
    // --------------------------------------------------------------------------------------------------------
    var sMLFB13 = strMLFB.charAt(12);
    var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);

    if (sBT_MLFB13 == ".") {
      sMLFB13 = getMLFB13default_1FE1(strBaseTypeMLFB, sMLFB13);
      if (sMLFB11 !== "ERROR") {
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
      } else {
        oParsing.strError = "ERRORMSG_MLFB_1FE1___PARSER_NO_DB_RESULT_MLFB13";
        return oParsing;
      }
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB14 Ausführung des Ständers (Stator)
    // --------------------------------------------------------------------------------------------------------
    var sMLFB14 = strMLFB.charAt(13);
    var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);

    if (sBT_MLFB14 == ".") {
      sMLFB14 = getMLFB14default_1FE1(strBaseTypeMLFB, sMLFB14);
      if (sMLFB11 !== "ERROR") {
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
      } else {
        oParsing.strError = "ERRORMSG_MLFB_1FE1___PARSER_NO_DB_RESULT_MLFB14";
        return oParsing;
      }
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB15 Ausführung des Läufers
    // --------------------------------------------------------------------------------------------------------
    var sMLFB15 = strMLFB.charAt(14);
    var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);

    if (sBT_MLFB15 == ".") {
      // Check MLFB15
      var sTable = "VT_1FE1_M00102" + sDB_Suffix;
      var sSQL =
        "SELECT * FROM " +
        sTable +
        " WHERE " +
        "MLFB_RUMPF_01_10_1FE1 = '" +
        strBaseTypeMLFB.substring(0, 10) +
        "' AND " +
        "MLFB15_1FE1 = '" +
        sMLFB15 +
        "' AND " +
        "HMK_VALUE_VALID_1FE1 = 'T';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length < 1) {
        sMLFB15 = getMLFB15_1FE1(strBaseTypeMLFB.substring(0, 10));
        if (sMLFB15 == "ERROR") {
          oParsing.strError = "ERRORMSG_MLFB_1FE1___NO_DB_RESULT_MLFB15";
          return oParsing;
        }
      }
      strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
    }

    // --------------------------------------------------------------------------------------------------------
    // MLFB16 Kabelabgang
    // --------------------------------------------------------------------------------------------------------
    var sMLFB16 = strMLFB.charAt(15);
    var sBT_MLFB16 = strBaseTypeMLFB.charAt(15);

    if (sBT_MLFB16 == ".") {
      sMLFB16 = getMLFB16default_1FE1(strBaseTypeMLFB, sMLFB16);
      if (sMLFB16 !== "ERROR") {
        strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
      } else {
        oParsing.strError = "ERRORMSG_MLFB_1FE1___PARSER_NO_DB_RESULT_MLFB16";
        return oParsing;
      }
    }

    // -----------------------------------------------------------------------------------------------
    // Zuweisen der neuen MLFB und KAG-Liste
    strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

    oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
    oParsing.strFullMLFB = strMLFB;
    aComponents[0] = oParsing.strBaseMLFB;
    oParsing.aTokens = aComponents;
    ECL_SetValue("ECSI_MLFB", strMLFB);
  }
  // -- END EDIT KEEP CONF --
  // Wildcards definieren, wenn kein Keep Configuration
  else {
    if (find(strMLFB.left(16), ".") >= 0) {
      //Unvollständige SIZER MLFB
      /* MLFB-Schema
                
                MLFB1-10 fix
    
                MLFB01	1FE1
                MLFB05	Baugröße	{04,05,06,07,08,09,10,11,12,14}
                MLFB07	Baulänge 	HMK_BAULAENGE_1FE1	{1,2,3,4,5,6,7}
                MLFB08	Motor-Polpaarzahl	PMD_ACF149_001_000_1FE1		{4,6,8}
                MLFB09 	(8+9) Motortyp	PMD_AAA259_001_000_1FE1	{4H,4W,6W,8W}
                MLFB10	{C,N,Y,D,E,F,G,H,J,K,L,M,P,Q,R,S,T,U,V,W,X}
                MLFB11	. Motorschutz		PMD_AAA863_001_000_1FE1 {1,3,5}
                MLFB12	. VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1}
                MLFB13	. (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
                              Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
                MLFB14	. (B) Ausführung des Ständers (Stator) 		PMD_ACF212_001_000_1FE1 {B,W}
                MLFB15	. Ausführung des Läufers					PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W}
                MLFB16	. Kabelabgang								PMD_AAA759_001_000_1FE1 {0,1,2,3,8}
                */
      // ##########################################################################################
      // Prüfen, ob '.' an Stelle 1 bis 10, dann Fehler
      // ##########################################################################################
      for (var i = 0; i < 10; i++) {
        if (strMLFB.charAt(i) == ".") {
          oParsing.strError = "ERRORMSG_MLFB_1FE1___INCOMPLETE_MLFB";
          return oParsing;
        }
      }

      // ##########################################################################################
      // Wenn MLFB11 bis MLFB16 ein Wildcard, dann Default setzen
      // ##########################################################################################

      // --------------------------------------------------------------------------------------------------------
      // MLFB11 Motorschutz
      // --------------------------------------------------------------------------------------------------------
      var sMLFB11 = strMLFB.charAt(10);

      if (sMLFB11 == ".") {
        sMLFB11 = "1";
        strMLFB = replaceAt(strMLFB, 10, sMLFB11);
      }

      // --------------------------------------------------------------------------------------------------------
      // MLFB12 VPM-Modul
      // --------------------------------------------------------------------------------------------------------
      var sMLFB12 = strMLFB.charAt(11);

      if (sMLFB12 == ".") {
        sMLFB12 = "0";
        // Kontext-Vorgabe für Default
        var ECSI_CX_Default_VPM = ECL_GetValue("ECSI_CX_Default_VPM");

        if (ECSI_CX_Default_VPM == "1" || ECSI_CX_Default_VPM == "True") {
          // Prüfen, ob erlaubt:
          var sTable = "VT_1FE1_M00112" + sDB_Suffix;
          var sSQL =
            "SELECT * FROM " +
            sTable +
            " WHERE " +
            "MLFB_RUMPF_01_10_1FE1 = '" +
            strMLFB.substring(0, 10) +
            "' AND " +
            "MLFB12_1FE1 = '1';";

          var aResult = GetDBDataSetEXT(sSQL);

          if (aResult.length > 0) {
            sMLFB12 = "1";
          } else {
            sMLFB12 = "0";
          }
        } else {
          // Check ohne VPM
          // MLFB_RUMPF_01_10_1FE1	MLFB12_1FE1	PMD_ABP635_001_000_1FE1	HMK_MAX_KW_1FE1
          var sTable = "VT_1FE1_M00112" + sDB_Suffix;
          var sSQL =
            "SELECT * FROM " +
            sTable +
            " WHERE " +
            "MLFB_RUMPF_01_10_1FE1 = '" +
            strMLFB.substring(0, 10) +
            "' AND " +
            "MLFB12_1FE1 = '0';";

          var aResult = GetDBDataSetEXT(sSQL);
          if (aResult.length < 1) {
            // Falls keine Lösung ohne, dann prüfen, ob mit möglich
            var sSQL =
              "SELECT * FROM " +
              sTable +
              " WHERE " +
              "MLFB_RUMPF_01_10_1FE1 = '" +
              strMLFB.substring(0, 10) +
              "' AND " +
              "MLFB12_1FE1 = '1';";

            var aResult = GetDBDataSetEXT(sSQL);

            if (aResult.length > 0) {
              sMLFB12 = "1";
            } else {
              oParsing.strError =
                "ERRORMSG_MLFB_1FE1___NO_DB_RESULT_VPE_MLFB12";
              return oParsing;
            }
          }
        }

        strMLFB = replaceAt(strMLFB, 11, sMLFB12);
      }

      // --------------------------------------------------------------------------------------------------------
      // MLFB13 Ausführung der Temperaturüberwachung / Lieferumfang
      // --------------------------------------------------------------------------------------------------------
      var sMLFB13 = strMLFB.charAt(12);

      if (sMLFB13 == ".") {
        sMLFB13 = "6";
        strMLFB = replaceAt(strMLFB, 12, sMLFB13);
      }

      // --------------------------------------------------------------------------------------------------------
      // MLFB14 Ausführung des Ständers (Stator)
      // --------------------------------------------------------------------------------------------------------
      var sMLFB14 = strMLFB.charAt(13);

      if (sMLFB14 == ".") {
        sMLFB14 = "B";
        strMLFB = replaceAt(strMLFB, 13, sMLFB14);
      }

      // --------------------------------------------------------------------------------------------------------
      // MLFB15 Ausführung des Läufers
      // --------------------------------------------------------------------------------------------------------
      var sMLFB15 = strMLFB.charAt(14);

      if (sMLFB15 == ".") {
        // getMLFB15
        sMLFB15 = getMLFB15_1FE1(strMLFB.substring(0, 10));
        if (sMLFB15 == "ERROR") {
          oParsing.strError = "ERRORMSG_MLFB_1FE1___NO_DB_RESULT_MLFB15";
          return oParsing;
        }

        //sMLFB15 = "A";
        strMLFB = replaceAt(strMLFB, 14, sMLFB15);
      }

      // --------------------------------------------------------------------------------------------------------
      // MLFB16 Kabelabgang
      // --------------------------------------------------------------------------------------------------------
      var sMLFB16 = strMLFB.charAt(15);

      if (strMLFB.charAt(15) == ".") {
        sMLFB16 = "0";
        strMLFB = replaceAt(strMLFB, 15, sMLFB16);
      }

      // --------------------------------------------------------------------------------------------------------

      ECL_SetValue("ECSI_MLFB", strMLFB);

      oParsing.strBaseMLFB = strMLFB.substring(0, 16);
      aComponents[0] = oParsing.strBaseMLFB;
      //oParsing.aTokens = aComponents;
    } else {
      // MLFB vollständig definiert, aber Kontexte berücksichtigen

      // todo prüfen Kontext VPM

      ECL_SetValue("ECSI_MLFB", strMLFB);

      oParsing.strBaseMLFB = strMLFB.substring(0, 16);
      aComponents[0] = oParsing.strBaseMLFB;
    }
  }
  //}
  // END IS-Start-Configuration

  if (oParsing.strBaseMLFB.length !== 16) {
    // Prüfen, ob die Zeichenkette 16 Stellen hat
    oParsing.strError = "ERRORMSG_MLFB_1FE1___PARSE_WRONG_SIZE";
    return oParsing;
  }

  if (oParsing.strBaseMLFB.indexOf("1FE1") < 0) {
    // Falsches Produkt
    oParsing.strError = "ERRORMSG_MLFB_1FE1___PARSE_WRONG_PRODUCT";
    return oParsing;
  }

  var oResult;
  oResult = parse_1FE1(oParsing.aTokens);

  if (oResult) {
    if (oResult.oProduct) oParsing.oProduct = oResult.oProduct;
    if (oResult.oParsingData) oParsing.oParsingData = oResult.oParsingData;
    oParsing.strError += (oParsing.strError ? " " : "") + oResult.strError;
    oParsing.strWarning +=
      (oParsing.strWarning ? " " : "") + oResult.strWarning;
  }

  vtTimeStop = Date.getTime();
  vtTime = (vtTimeStop - vtTimeStart) / 1000;
  logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

  return oParsing;
}

function parse_1FE1(aTokens) {
  var oResult = {
    strError: "",
    strRegion: "",
    strWarning: "",
    oProduct: null,
    oParsingData: {},
  };
  /*
    MLFB-Schema
    
    MLFB1-10 fix
    
    MLFB01	1FE1
    MLFB05	Baugröße	{04,05,06,07,08,09,10,11,12,14}
    MLFB07	Baulänge 	HMK_BAULAENGE_1FE1	{1,2,3,4,5,6,7}
    MLFB08	Motor-Polpaarzahl	PMD_ACF149_001_000_1FE1		{4,6,8}
    MLFB09 	(8+9) Motortyp	PMD_AAA259_001_000_1FE1	{4H,4W,6W,8W}
    MLFB10	{C,N,Y,D,E,F,G,H,J,K,L,M,P,Q,R,S,T,U,V,W,X}
    MLFB11	. Motorschutz		PMD_AAA863_001_000_1FE1 {1,3,5}
    MLFB12	. VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1}
    MLFB13	. (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
                  Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
    MLFB14	. (B) Ausführung des Ständers (Stator) 		PMD_ACF212_001_000_1FE1 {B,W}
    MLFB15	. Ausführung des Läufers					PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W}
    MLFB16	. Kabelabgang								PMD_AAA759_001_000_1FE1 {0,1,2,3,8}
    */
  var strBaseMLFB = aTokens[0];
  oResult.oParsingData.MLFB = {};
  oResult.oParsingData.MLFB.POS01 = strBaseMLFB.substring(0, 4); // 01 1FE1
  oResult.oParsingData.MLFB.POS05 = strBaseMLFB.charAt(4); // 05 Baugröße	{04,05,06,07,08,09,10,11,12,14}
  oResult.oParsingData.MLFB.POS06 = strBaseMLFB.charAt(5); // 06 Baugröße	{04,05,06,07,08,09,10,11,12,14}
  oResult.oParsingData.MLFB.POS07 = strBaseMLFB.charAt(6); // 07 Baulänge 	HMK_BAULAENGE_1FE1	{1,2,3,4,5,6,7}
  oResult.oParsingData.MLFB.POS08 = strBaseMLFB.charAt(7); // 08 Motor-Polpaarzahl	PMD_ACF149_001_000_1FE1		{4,6,8}
  oResult.oParsingData.MLFB.POS09 = strBaseMLFB.charAt(8); // 09 (8+9) Motortyp	PMD_AAA259_001_000_1FE1	{4H,4W,6W,8W}
  oResult.oParsingData.MLFB.POS10 = strBaseMLFB.charAt(9); // 10 {C,N,Y,D,E,F,G,H,J,K,L,M,P,Q,R,S,T,U,V,W,X}
  oResult.oParsingData.MLFB.POS11 = strBaseMLFB.charAt(10); // 11 . Motorschutz		PMD_AAA863_001_000_1FE1 {1,3,5}
  oResult.oParsingData.MLFB.POS12 = strBaseMLFB.charAt(11); // 12 . VPM-Modul		HMK_VPM_MODUL_1FE1		{0,1}
  oResult.oParsingData.MLFB.POS13 = strBaseMLFB.charAt(12); // 13 . (6) Ausführung der Temperaturüberwachung	PMD_AAA717_001_000_1FE1 {1,2,3,6,7}		{Konfigtyp="KONFIG": 3,6,7}
  //			Lieferumfang							PMD_ABW070_001_000_1FE1 {1,2,3,6,7}
  oResult.oParsingData.MLFB.POS14 = strBaseMLFB.charAt(13); // 14 . (B) Ausführung des Ständers (Stator) 		PMD_ACF212_001_000_1FE1 {B,W}
  oResult.oParsingData.MLFB.POS15 = strBaseMLFB.charAt(14); // 15 . Ausführung des Läufers					PMD_ACF213_001_000_1FE1 {A,B,C,D,E,R,W}
  oResult.oParsingData.MLFB.POS16 = strBaseMLFB.charAt(15); // 16 . Kabelabgang								PMD_AAA759_001_000_1FE1 {0,1,2,3,8}

  oResult.oParsingData.RUMPF = strBaseMLFB.substring(0, 10); // = MLFB_RUMPF_01_10_1FE1

  // Prüfen, ob Rumpf-MLFB in DB abgebildet:
  var sTable = "VT_1FE1_M00099" + sDB_Suffix; // todo

  var sSQL =
    "SELECT MLFB_RUMPF_01_10_1FE1 FROM " +
    sTable +
    " WHERE " +
    "MLFB_RUMPF_01_10_1FE1 = '" +
    oResult.oParsingData.RUMPF +
    "' AND " +
    "HMK_VALUE_VALID_1FE1 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length < 1) {
    oResult.strError = "ERRORMSG_MLFB_1FE1___PARSE_WRONG_MLFB";
  }
  ECL_SetValue("MLFB_RUMPF_01_10_1FE1", oResult.oParsingData.RUMPF); // = MLFB_RUMPF_01_10_1FE1
  // ################################################################################################################

  // Kurzangaben
  if (aTokens.length > 0) {
    if (aTokens[0] === strBaseMLFB) {
      aTokens = removeElementsFromArray(aTokens, 0, 1);
    }
    oResult.oParsingData.MLFB.KAG = aTokens || [];

    oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
  }

  return oResult;
}

/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
  var kagString = "";
  for (var i = 0; i < aTokens.length; i++) {
    kagString += aTokens[i];
    if (i < aTokens.length - 1) {
      kagString += ";";
    }
  }
  return kagString;
}

function SetFreetextValue(field, value) {
  value = trimleft(value, "*");
  value = trimright(value, "*");

  ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {
  /*	zur Info - oParse: 
    {
        strBaseMLFB : '',
        strFullMLFB
        strError : '',
        strWarning : '',
        aTokens : [],
        oFreetext : {}
    };
*/
  /*/ O_Y84_1FK2	+ O_Y84_TXT_1FK2
    if (find(oParse.strFullMLFB , 'Y84') >= 0) {
        if (oParse.oFreetext['Y84']) SetFreetextValue('O_Y84_TXT_1FK2', oParse.oFreetext['Y84']);
    }*/
}

function isKAGinMLFB(aArray, sKAG) {
  for (var i = 0; i < aArray.length; i++) {
    if (aArray[i] == sKAG) return true;
  }

  return false;
}

function getMLFB15_1FE1(strMLFB_Rumpf) {
  // Bestimme aus VT102 gültige MLFB15 für den Default
  var sTable = "VT_1FE1_M00102" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB15_1FE1 FROM " +
    sTable +
    " WHERE " +
    "MLFB_RUMPF_01_10_1FE1 = '" +
    strMLFB_Rumpf +
    "' AND " +
    "HMK_VALUE_VALID_1FE1 = 'T' ORDER BY MLFB15_1FE1;";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var MLFB15_1FE1 = aResult[0].MLFB15_1FE1;
    return MLFB15_1FE1;
  } else {
    return "ERROR";
  }
}

function getMLFB11default_1FE1(strBaseTypeMLFB, sMLFB11) {
  // Prüfe, ob übergebene MLFB11 gültig, sonst bestimme aus VT61 gültige MLFB11 für den Default
  var sTable = "VT_1FE1_M00061" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB11_1FE1 FROM " +
    sTable +
    " WHERE " +
    "MLFB11_1FE1 = '" +
    sMLFB11 +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return sMLFB11;
  } else {
    var sSQL = "SELECT * FROM " + sTable + " ORDER BY MLFB11_1FE1;";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var MLFB11_1FE1 = aResult[0].MLFB11_1FE1;
      return MLFB11_1FE1;
    } else {
      return "ERROR";
    }
  }
}

function getMLFB13default_1FE1(strBaseTypeMLFB, sMLFB13) {
  // Check VT97
  var sTable = "VT_1FE1_M00097" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB13_1FE1 FROM " +
    sTable +
    " WHERE " +
    "HMK_KONFIG_TYP_1FE1 = 'KONFIG' AND " +
    "MLFB13_1FE1 = '" +
    sMLFB13 +
    "' AND " +
    "HMK_VALUE_VALID_1FE1 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return sMLFB13;
  } else {
    var sSQL =
      "SELECT * FROM " +
      sTable +
      " WHERE " +
      "HMK_KONFIG_TYP_1FE1 = 'KONFIG' ORDER BY MLFB13_1FE1;";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var MLFB13_1FE1 = aResult[0].MLFB13_1FE1;
      return MLFB13_1FE1;
    } else {
      return "ERROR";
    }
  }
}

function getMLFB14default_1FE1(strBaseTypeMLFB, sMLFB14) {
  var MLFB_RUMPF_01_10_1FE1 = strBaseTypeMLFB.substring(0, 10);

  var sTable = "VT_1FE1_M00100" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB14_1FE4 FROM " +
    sTable +
    " WHERE " +
    "MLFB_RUMPF_01_10_1FE1 = '" +
    MLFB_RUMPF_01_10_1FE1 +
    "' AND MLFB14_1FE1 = '" +
    sMLFB14 +
    "' AND HMK_VALUE_VALID_1FE1 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return sMLFB14;
  } else {
    var sSQL =
      "SELECT * FROM " +
      sTable +
      " WHERE " +
      "MLFB_RUMPF_01_10_1FE1 = '" +
      MLFB_RUMPF_01_10_1FE1 +
      "' AND HMK_VALUE_VALID_1FE1 = 'T' ORDER BY MLFB14_1FE1;";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var MLFB14_1FE1 = aResult[0].MLFB14_1FE1;
      return MLFB14_1FE1;
    } else {
      return "ERROR";
    }
  }
}

function getMLFB16default_1FE1(strBaseTypeMLFB, sMLFB16) {
  var sTable = "VT_1FE1_M00063" + sDB_Suffix;
  var sSQL =
    "SELECT MLFB16_1FE1 FROM " +
    sTable +
    " WHERE " +
    "MLFB16_1FE1 = '" +
    sMLFB16 +
    "';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    return sMLFB16;
  } else {
    var sSQL = "SELECT * FROM " + sTable + " ORDER BY MLFB16_1FE1;";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      var MLFB16_1FE1 = aResult[0].MLFB16_1FE1;
      return MLFB16_1FE1;
    } else {
      return "ERROR";
    }
  }
}
