//@legacy
//#mode(full-ecma)


//@import "VT_1FE2.js"


/*
Motordaten:
    Motorlänge L
        PMD_ABY204_001_000_1FE2
        HMK_BAULAENGE_1FE2
    
    PMD_ABP663_001_000_1FE2	Achshöhe
    PMD_ABY192_001_000_1010140	Außendurchmesser Stator D
    PMD_ABY239_001_000_1FE2	Innendurchmesser Rotor d
    
    PMD_AAA259_001_000_1FE2	Motortyp
    
    PMD_ACF212_001_000_1FE2	Statorausführung (Kühlmantel)
    
    PMD_ACF213_001_000_1FE2	Ausführung des Läufers
    
    HMK_AUSFUEHRUNG_1FE2	Ausführung		Asynchron/Synchron		MLFB09
    
    (HMK_W_AUSFUEHRUNG_1FE2	Wicklungsausführung)
    HMK_W_AUSFUEHRUNG_UI_1FE2	Wicklungsausführung UI

    PMD_AAA863_001_000_1FE2	Motorschutz
    
    PMD_ABW070_001_000_1FE2	Lieferumfang


Anschlusstechnik:
    PMD_AAA759_001_000_1FE2	Kabelabgang
    
    
    KAG / Optionen
    HMK_T00_1FE2	Rotor vorgewuchtet

*/

function SetMotor_Init_1FE2(oData) {
    if (oData && !isEmpty(oData)) {

        Bestimme_Lieferumfang_1FE2(oData);		// 
        Bestimme_Motordaten_1FE2(oData);			// 
        Bestimme_Anschlusstechnik_1FE2(oData);	// 
        Bestimme_Optionen_1FE2(oData);
    } else {
        // Motordaten
        ExecSetStandardifValueEmpty("PMD_ABP663_001_000_1FE2", "90");		// Achshöhe
        ExecSetStandardifValueEmpty("PMD_ABY192_001_000_1010140", "179,7");		// 	Außendurchmesser Stator D
        ExecSetStandardifValueEmpty("PMD_ABY239_001_000_1FE2", "90");		// Innendurchmesser Rotor d

        ExecSetStandardifValueEmpty("HMK_BAULAENGE_1FE2", "200");			// Baulänge

        ExecSetStandardifValueEmpty("PMD_ACF212_001_000_1FE2", "OHNE_KM");	// Statorausführung (Kühlmantel)
        ExecSetStandardifValueEmpty("PMD_ACF213_001_000_1FE2", "00001");		// Ausführung des Läufers

        ExecSetStandardifValueEmpty("HMK_AUSFUEHRUNG_1FE2", "00001");		// Ausführung		Asynchron/Synchron
        ExecSetStandardifValueEmpty("HMK_W_AUSFUEHRUNG_1FE2", "00001");		// Wicklungsausführung
        ExecSetStandardifValueEmpty("HMK_W_AUSFUEHRUNG_UI_1FE2", "Y");		// Wicklungsausführung UI

        ExecSetStandardifValueEmpty("PMD_AAA759_001_000_1FE2", "00003");		// Anschlusstechnik
        ExecSetStandardifValueEmpty("HMK_KABELABGANG_1FE2", "00001");		// Kabelabgang
        ExecSetStandardifValueEmpty("HMK_KABELLAENGE_1010590", 0.5);		// Kabellänge

        ExecSetStandardifValueEmpty("PMD_AAA136_001_000_1FE2", "Z0004");		// Art der Kühlung
        ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_1FE2", "00046");		// Schutzart IP
    }
}

function SetMotor_1FE2(strchangedAttribute, oData) {
}
// #########################################################################################################################
/**
Motordaten:
    
*/
// #########################################################################################################################
function Bestimme_Motordaten_1FE2(oData) {

    var oParsingData = oData.oParsingData;
    var sMLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

    // -----------------------------------------------------------------------------------------------------------
    // Ausführung		Asynchron/Synchron		MLFB09		HMK_AUSFUEHRUNG_1FE2
    // -----------------------------------------------------------------------------------------------------------
    /* BG 09+14 = Asynchron (A, C), BG 18 = Synchron (L) */

    var MLFB09_1FE2 = oParsingData.MLFB.MLFB09;

    var sTable = "VT_1FE2_M00031" + sDB_Suffix;
    // MLFB09_1FE2	HMK_AUSFUEHRUNG_1FE2	HMK_VALUE_VALID_1FE2

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB09_1FE2 = '" + MLFB09_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var HMK_AUSFUEHRUNG_1FE2 = aResult[0].HMK_AUSFUEHRUNG_1FE2;
        ECL_DeactivateAllAttributeValues("HMK_AUSFUEHRUNG_1FE2");

        ECL_ActivateValue("HMK_AUSFUEHRUNG_1FE2", HMK_AUSFUEHRUNG_1FE2);
        ECL_SelectValue("HMK_AUSFUEHRUNG_1FE2", HMK_AUSFUEHRUNG_1FE2);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_HMK_AUSFUEHRUNG");
        return;
    }


    // -----------------------------------------------------------------------------------------------------------
    // Wicklungsausführung			HMK_W_AUSFUEHRUNG_1FE2	and HMK_W_AUSFUEHRUNG_UI_1FE2
    // -----------------------------------------------------------------------------------------------------------
    /* 	HMK_W_AUSFUEHRUNG_1FE2 nicht eindeutig bei MLFB16 == 2, mündet jedoch beides (00001, 00002) in Y_D bei HMK_W_AUSFUEHRUNG_UI_1FE2
    
        VT_1FE2_M00112	Technische-Daten
        VT_1FE2_M00063	MLFB16 - Wicklungsausführung
    */
    var BT_MLFB16_1FE2 = sMLFB_BASE_TYPE.charAt(15);

    //var ECSI_CX_MotorConnection = ECL_GetValue("ECSI_CX_MotorConnection"); // siehe Parser
    /* 	0	Motor dimensioned with delta circuit
        1	Motor dimensioned with star circuit
    */

    // HMK_W_AUSFUEHRUNG_UI_1FE2
    var MLFB16_1FE2 = oParsingData.MLFB.MLFB16;

    var sTable = "VT_1FE2_M00090" + sDB_Suffix;
    // HMK_W_AUSFUEHRUNG_UI_1FE2	HMK_W_AUSFUEHRUNG_1FE2	MLFB16_1FE2

    var sSQL = "SELECT DISTINCT HMK_W_AUSFUEHRUNG_UI_1FE2 FROM " + sTable + " WHERE " +
        "MLFB16_1FE2 = '" + MLFB16_1FE2 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var HMK_W_AUSFUEHRUNG_UI_1FE2 = aResult[0].HMK_W_AUSFUEHRUNG_UI_1FE2;

        ECL_ActivateValue("HMK_W_AUSFUEHRUNG_UI_1FE2", HMK_W_AUSFUEHRUNG_UI_1FE2);
        ECL_SelectValue("HMK_W_AUSFUEHRUNG_UI_1FE2", HMK_W_AUSFUEHRUNG_UI_1FE2);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_HMK_W_AUSFUEHRUNG_UI");
        return;
    }
    // -----------------------------------------------------------------------------------------------------------
    // PMD_ABY192_001_000_1010140	Außendurchmesser Stator D   ==> nach MLFB14 / PMD_ACF212_001_000_1FE2
    // -----------------------------------------------------------------------------------------------------------
    /** VT_1FE2_M00045	ZO Durchmesser - Kühlmantel
     *      MLFB05_1FE2	Segment Merkmal MLFB05_1FE2
     *      PMD_ABY192_001_000_1010140	Durchmesser / des Motors
     *      PMD_ACF212_001_000_1FE2	Ausführung des Ständers
     *      HMK_VALUE_VALID_1FE2	Wert gültig
     */

    // -----------------------------------------------------------------------------------------------------------
    // Achshöhe
    // -----------------------------------------------------------------------------------------------------------
    /* 	PMD_ABP663_001_000_1FE2	Achshöhe
    */
    var MLFB05_1FE2 = oParsingData.MLFB.MLFB05;
    switch (MLFB05_1FE2) {
        case "07":
            var PMD_ABP663_001_000_1FE2 = "70";
            break;
        case "09":
            var PMD_ABP663_001_000_1FE2 = "90";
            break;
        case "11":
            var PMD_ABP663_001_000_1FE2 = "110";
            break;
        case "12":
            var PMD_ABP663_001_000_1FE2 = "120";
            break;
        case "14":
            var PMD_ABP663_001_000_1FE2 = "140";
            break;
        case "18":
            var PMD_ABP663_001_000_1FE2 = "180";
            break;

    }
    ECL_DeactivateAllAttributeValues("PMD_ABP663_001_000_1FE2");
    ECL_ActivateValue("PMD_ABP663_001_000_1FE2", PMD_ABP663_001_000_1FE2);
    ECL_SelectValue("PMD_ABP663_001_000_1FE2", PMD_ABP663_001_000_1FE2);


    // -----------------------------------------------------------------------------------------------------------
    // MLFB11	PMD_AAA863_001_000_1FE2		Motorschutz
    // -----------------------------------------------------------------------------------------------------------

    var MLFB11_1FE2 = oParsingData.MLFB.MLFB11;

    var sTable = "VT_1FE2_M00022" + sDB_Suffix;
    // MLFB11_1FE2	PMD_AAA863_001_000_1FE2	MLFB16_1FE2	HMK_MLFB_DIREKT_1FE2	HMK_VALUE_VALID_1FE2

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB11_1FE2 = '" + MLFB11_1FE2 + "' AND " +
        "MLFB16_1FE2 = '" + MLFB16_1FE2 + "' AND " +
        "HMK_MLFB_DIREKT_1FE2 = 'F' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAA863_001_000_1FE2 = aResult[0].PMD_AAA863_001_000_1FE2;

        ECL_SelectValue("PMD_AAA863_001_000_1FE2", PMD_AAA863_001_000_1FE2);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_MOTORSCHUTZ");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // MLFB14	PMD_ACF212_001_000_1FE2		Stator-Ausführung		(VT_1FE2_M00006)
    // -----------------------------------------------------------------------------------------------------------
    var MLFB14_1FE2 = oParsingData.MLFB.MLFB14;

    var sTable = "VT_1FE2_M00006" + sDB_Suffix;
    // MLFB14_1FE2	PMD_ACF212_001_000_1FE2	HMK_VALUE_VALID_1FE2

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB14_1FE2 = '" + MLFB14_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ACF212_001_000_1FE2 = aResult[0].PMD_ACF212_001_000_1FE2;

        ECL_ActivateValue("PMD_ACF212_001_000_1FE2", PMD_ACF212_001_000_1FE2);
        ECL_SelectValue("PMD_ACF212_001_000_1FE2", PMD_ACF212_001_000_1FE2);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_STATOR");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // PMD_ABY192_001_000_1010140	Außendurchmesser Stator D
    // -----------------------------------------------------------------------------------------------------------
    /** VT_1FE2_M00045	ZO Durchmesser - Kühlmantel
     *      MLFB05_1FE2	Segment Merkmal MLFB05_1FE2
     *      PMD_ABY192_001_000_1010140	Durchmesser / des Motors
     *      PMD_ACF212_001_000_1FE2	Ausführung des Ständers
     *      HMK_VALUE_VALID_1FE2	Wert gültig
     * 
     */
    var sTable = "VT_1FE2_M00045" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
        "PMD_ACF212_001_000_1FE2 = '" + PMD_ACF212_001_000_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var PMD_ABY192_001_000_1010140 = aResult[0].PMD_ABY192_001_000_1010140;
        ECL_ActivateValue("PMD_ABY192_001_000_1010140", PMD_ABY192_001_000_1010140);
        ECL_SetValue("PMD_ABY192_001_000_1010140", PMD_ABY192_001_000_1010140);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_STATOR_D");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // MLFB15	. Ausführung des Läufers		PMD_ACF213_001_000_1FE2 {A,B,C,D,E,R,W}		VT_1FE2_M00007
    // -----------------------------------------------------------------------------------------------------------
    var sTable = "VT_1FE2_M00007" + sDB_Suffix;
    // MLFB15_1FE2	PMD_ACF213_001_000_1FE2	HMK_VALUE_VALID_1FE2

    var MLFB15_1FE2 = oParsingData.MLFB.MLFB15;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB15_1FE2 = '" + MLFB15_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";


    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_ACF213_001_000_1FE2 = aResult[0].PMD_ACF213_001_000_1FE2;
        // Feste Zuordnung über BG, daher einschränken
        ECL_DeactivateAllAttributeValues("PMD_ACF213_001_000_1FE2");
        ECL_ActivateValue("PMD_ACF213_001_000_1FE2", PMD_ACF213_001_000_1FE2);
        ECL_SelectValue("PMD_ACF213_001_000_1FE2", PMD_ACF213_001_000_1FE2);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_ROTOR");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // HMK_PRODNAM_SLEEVE_1FE2
    // -----------------------------------------------------------------------------------------------------------
    // VT_1FE2_M00086
    // MLFB15_1FE2 HMK_PRODNAM_SLEEVE_1FE2
    var sTable = "VT_1FE2_M00086" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB15_1FE2 = '" + MLFB15_1FE2 + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var HMK_PRODNAM_SLEEVE_1FE2 = aResult[0].HMK_PRODNAM_SLEEVE_1FE2;
        ECL_ActivateValue("HMK_PRODNAM_SLEEVE_1FE2", HMK_PRODNAM_SLEEVE_1FE2);
        ECL_SetValue("HMK_PRODNAM_SLEEVE_1FE2", HMK_PRODNAM_SLEEVE_1FE2);
    }
    else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_POWER_DATA");
        return;
    }
    // -----------------------------------------------------------------------------------------------------------
    // Innendurchmesser Rotor d     PMD_ABY239_001_000_1FE2
    // -----------------------------------------------------------------------------------------------------------
    /* VT_1FE2_M00087	ZO Achshoehe - Innendurchmesser Rotor
            PMD_ABP663_001_000_1FE2     HMK_PRODNAM_SLEEVE_1FE2     PMD_ABY239_001_000_1FE2     HMK_VALUE_VALID_1FE2
    */
    var sTable = "VT_1FE2_M00087" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "PMD_ABP663_001_000_1FE2 = '" + PMD_ABP663_001_000_1FE2 + "' AND " +
        "HMK_PRODNAM_SLEEVE_1FE2 = '" + HMK_PRODNAM_SLEEVE_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        var PMD_ABY239_001_000_1FE2 = aResult[0].PMD_ABY239_001_000_1FE2;
        ECL_DeactivateAllAttributeValues("PMD_ABY239_001_000_1FE2");
        ECL_ActivateValue("PMD_ABY239_001_000_1FE2", PMD_ABY239_001_000_1FE2);
        ECL_SelectValue("PMD_ABY239_001_000_1FE2", PMD_ABY239_001_000_1FE2);
    }
    else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_INNER_DIAMETER");
        return;
    }

    // -----------------------------------------------------------------------------------------------------------
    // MLFB07	Baulänge 	HMK_BAULAENGE_1FE2	{2,3,4,5,6,7}			VT61+VT13		PMD_ABY204_001_000_1FE2
    // -----------------------------------------------------------------------------------------------------------
    var MLFB07_1FE2 = oParsingData.MLFB.MLFB07;
    /* HMK_BAULAENGE_1FE2 is no longer used, PMD_ABY204_001_000_1FE2 is used instead */
    /* var sTable = "VT_1FE2_M00001" + sDB_Suffix;
    // MLFB07_1FE2	HMK_BAULAENGE_1FE2	HMK_VALUE_VALID_1FE2
    
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB07_1FE2= '" + MLFB07_1FE2 + "' AND " +
                "HMK_VALUE_VALID_1FE2= 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        
        var HMK_BAULAENGE_1FE2 = aResult[0].HMK_BAULAENGE_1FE2;
        ECL_DeactivateAllAttributeValues("HMK_BAULAENGE_1FE2");
        
        ECL_ActivateValue("HMK_BAULAENGE_1FE2", HMK_BAULAENGE_1FE2);
        ECL_SelectValue("HMK_BAULAENGE_1FE2", HMK_BAULAENGE_1FE2);
    }else{
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_HMK_BAULAENGE");
        return;
    }
    */
    var sTable = "VT_1FE2_M00089" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
        "MLFB07_1FE2 = '" + MLFB07_1FE2 + "' AND " +
        "MLFB09_1FE2 = '" + MLFB09_1FE2 + "' AND " +
        //"PMD_ACF212_001_000_1FE2 = '" + PMD_ACF212_001_000_1FE2 + "' AND " +
        "HMK_PRODNAM_SLEEVE_1FE2 = '" + HMK_PRODNAM_SLEEVE_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        // Länge des Motors PMD_ABY204_001_000_1FE2
        var PMD_ABY204_001_000_1FE2 = aResult[0].PMD_ABY204_001_000_1FE2;
        ECL_DeactivateAllAttributeValues("PMD_ABY204_001_000_1FE2");
        // Baulänge
        ECL_ActivateValue("PMD_ABY204_001_000_1FE2", PMD_ABY204_001_000_1FE2);
        ECL_SelectValue("PMD_ABY204_001_000_1FE2", PMD_ABY204_001_000_1FE2);
    }
    else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_POWER_DATA");
        return;
    }
}
// #########################################################################################################################


// #########################################################################################################################
/**
    PMD_ABW070_001_000_1FE2		Lieferumfang		VT_1FE2_M00005
    
*/
// #########################################################################################################################
function Bestimme_Lieferumfang_1FE2(oData) {
    /*	Wenn PMD_ABW070_001_000_1FE2 == 'S_R' MLFB13: '1' (Stator und Rotor-BG), keine Sekundär-MLFB
        Wenn PMD_ABW070_001_000_1FE2 ==	'ET_S' MLFB13 = "2", keine Sekundär-MLFB
        Wenn PMD_ABW070_001_000_1FE2 ==	'ET_S_R' MLFB13 = "2", mit Sekundär-MLFB (Kopie mit MLFB13 = '3')
        Wenn PMD_ABW070_001_000_1FE2 ==	'ET_R' MLFB13 = "3", keine Sekundär-MLFB
    */

    var oMLFB = oData.oParsingData.MLFB;

    var MLFB13_1FE2 = oMLFB.MLFB13;

    if (MLFB13_1FE2 == "2" && oData.strSecMLFB != "") {
        // Es gibt einen Rotor, also ET_S_R
        // ggf. noch MLFB_Sec prüfen?
        var strSecMLFB_ref = replaceAt(oData.strBaseMLFB, 12, 3);
        if (oData.strSecMLFB.left(16) == strSecMLFB_ref) {
            // Rotor-MLFB in Sec-MLFB bestätigt
            var PMD_ABW070_001_000_1FE2 = "ET_S_R";
        } else {
            var PMD_ABW070_001_000_1FE2 = "ET_S";
        }
        ECL_SetValue("PMD_ABW070_001_000_1FE2", PMD_ABW070_001_000_1FE2);
    } else if (MLFB13_1FE2 == "1") {
        // MLFB13_1FE2 == 1
        var PMD_ABW070_001_000_1FE2 = "S_R";

        ECL_SetValue("PMD_ABW070_001_000_1FE2", PMD_ABW070_001_000_1FE2);

    } else if (MLFB13_1FE2 == "3") {
        var PMD_ABW070_001_000_1FE2 = "ET_R";

        ECL_SetValue("PMD_ABW070_001_000_1FE2", PMD_ABW070_001_000_1FE2);

    } else if (MLFB13_1FE2 == "2") {
        var PMD_ABW070_001_000_1FE2 = "ET_S";

        ECL_SetValue("PMD_ABW070_001_000_1FE2", PMD_ABW070_001_000_1FE2);

    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_LIEFERUMFANG");
        return;
        //}
    }
}
// #########################################################################################################################

// #########################################################################################################################
/**
Anschlusstechnik
    
    MLFB12	. Kabelabgang		PMD_AAA759_001_000_1FE2	Kabelabgang
            
    VT_1FE2_M00004
*/
// #########################################################################################################################
function Bestimme_Anschlusstechnik_1FE2(oData) {
    //MLFB12	. Kabelabgang								PMD_AAA759_001_000_1FE2
    var MLFB12_1FE2 = oData.oParsingData.MLFB.MLFB12;
    ECL_SelectValue("MLFB12_1FE2", MLFB12_1FE2);

    var sTable = "VT_1FE2_M00004" + sDB_Suffix;
    // MLFB12_1FE2	PMD_AAA759_001_000_1FE2	HMK_VALUE_VALID_1FE2

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB12_1FE2 = '" + MLFB12_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {

        var PMD_AAA759_001_000_1FE2 = aResult[0].PMD_AAA759_001_000_1FE2;

        ECL_SetValue("PMD_AAA759_001_000_1FE2", PMD_AAA759_001_000_1FE2);
    } else {
        oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_ANSCHLUSSTECH");
        return;
    }

}
// #########################################################################################################################
function Bestimme_Optionen_1FE2(oData) {
    var oMLFB = oData.oParsingData.MLFB;

    var aKAG = oMLFB.KAG || [];

    //var sTargetAttribute = "HMK_T00_1FE2";	// CB_T00_1FE2
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "T00";
    ECL_EnableAttribute("CB_T00_1FE2");

    if (aKAG.indexOf(sKAG) > -1) {
        bCheck = checkT00_1FE2(oData, sKAG);
    }
    if (bCheck) {
        ECL_SelectValue("CB_T00_1FE2", "T");
    } else {
        ECL_DeselectAttribute("CB_T00_1FE2");
    }

}

function checkT00_1FE2(oData, sKAG) {
    if (oData.IsStartConfig == "0")
        return 1;

    // #############################################################################################################
    // HMK_T00_1FE2		
    // #############################################################################################################
    var sTarget = "HMK_T00_1FE2";
    // VT_1FE2_M00058
    // MLFB05_1FE2	PMD_ABW070_001_000_1FE2	HMK_T00_1FE2	HMK_VALUE_VALID_1FE2

    var MLFB05_1FE2 = oData.oParsingData.MLFB.MLFB05;
    var PMD_ABW070_001_000_1FE2 = ECL_GetValue("PMD_ABW070_001_000_1FE2");

    var sTable = "VT_1FE2_M00058" + sDB_Suffix;
    var sSQL = "SELECT " + sTarget + " FROM " + sTable + " WHERE " +
        "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
        "PMD_ABW070_001_000_1FE2 = '" + PMD_ABW070_001_000_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T' AND " +
        sTarget + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        return 0;
    }
    // #############################################################################################################
    // Code:
    // #############################################################################################################
    return 1;
}