//@legacy
//#mode(full-ecma)


//@import "../1FE2_MLFB/Base.misc.js"

//@import "VT_1FE2.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic_1FE2(strchangedAttribute) {
    var strError = "";

    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var sMLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

    var PMD_ABP663_001_000_1FE2 = ECL_GetValue("PMD_ABP663_001_000_1FE2"); // Achshöhe

    var MLFB01_1FE2 = sMLFB.substring(0, 4);
    var MLFB05_1FE2 = sMLFB.charAt(4) + sMLFB.charAt(5);
    var MLFB07_1FE2 = sMLFB.charAt(6);
    var MLFB08_1FE2 = sMLFB.charAt(7);
    var MLFB09_1FE2 = sMLFB.charAt(8);
    var MLFB10_1FE2 = sMLFB.charAt(9);
    var MLFB11_1FE2 = sMLFB.charAt(10);
    var MLFB12_1FE2 = sMLFB.charAt(11);
    var MLFB13_1FE2 = sMLFB.charAt(12);
    var MLFB14_1FE2 = sMLFB.charAt(13);
    var MLFB15_1FE2 = sMLFB.charAt(14);
    var MLFB16_1FE2 = sMLFB.charAt(15);



    // ################################################################################################################
    // Lieferumfang		PMD_ABW070_001_000_1FE2		MLFB13
    // ################################################################################################################
    /* 
    VT_1FE2_M00005	MLFB13-Lieferumfang		nur Übersetzung
    VT_1FE2_M00058	Lieferumfang-T00		in diese Richtung keine Einschränkung!
    VT_1FE2_M00074	Scope of delivery, MLFB14, 15
        PMD_ABW070_001_000_1FE2     MLFB14_1FE2     MLFB15_1FE2

    MLFB13_1FE2:
        VT_1FE2_M00005	MLFB13-Lieferumfang
    nn	VT_1FE2_M00050	statisches Maßbild
 
    */
    // ################################################################################################################
    var sScopeOfDelivery = "NON";
    // nur wählbar, wenn BT_MLFB 14/15 "."
    if (sMLFB_BASE_TYPE.charAt(13) == "." && sMLFB_BASE_TYPE.charAt(14) == ".") {
        sScopeOfDelivery = "BOTH";
    } else if (sMLFB_BASE_TYPE.charAt(13) == ".") {
        // Fallunterscheidung, wenn nur eine Ausführung wählbar
        sScopeOfDelivery = "STATOR";
    } else if (sMLFB_BASE_TYPE.charAt(14) == ".") {
        sScopeOfDelivery = "ROTOR";
    }

    if (sScopeOfDelivery == "NON") {
        var sTable = "VT_1FE2_M00074" + sDB_Suffix;

        var sSQL = "SELECT DISTINCT PMD_ABW070_001_000_1FE2 FROM " + sTable + " WHERE " +
            "MLFB14_1FE2 = '" + MLFB14_1FE2 + "' AND " +
            "MLFB15_1FE2 = '" + MLFB15_1FE2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            ECL_DeactivateAllAttributeValues("PMD_ABW070_001_000_1FE2");
            ECL_ActivateValue("PMD_ABW070_001_000_1FE2", aResult[0].PMD_ABW070_001_000_1FE2);
            ECL_SelectValue("PMD_ABW070_001_000_1FE2", aResult[0].PMD_ABW070_001_000_1FE2);

        } else {
            strError = "DICT1_ERR_1FE2___PL_MLFB13_NO_DB_RESULT";
            return strError;
        }
    } else if (sScopeOfDelivery == "BOTH") {
        ECL_ActivateAllAttributeValues("PMD_ABW070_001_000_1FE2");
        ECL_ActivateAllAttributeValues("MLFB14_1FE2");
        ECL_ActivateAllAttributeValues("MLFB15_1FE2");

    } else if (sScopeOfDelivery == "STATOR") {
        // nur Stator (MLFB14) wählbar, alle Werte, bei denen MLFB15 = fix
        ECL_DeactivateAllAttributeValues("MLFB15_1FE2");
        ECL_ActivateValue("MLFB15_1FE2", MLFB15_1FE2);
        ECL_SelectValue("MLFB15_1FE2", MLFB15_1FE2);

        var sTable = "VT_1FE2_M00074" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT PMD_ABW070_001_000_1FE2, MLFB14_1FE2 FROM " + sTable + " WHERE " +
            "MLFB15_1FE2 = '" + MLFB15_1FE2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);

        if (aResult.length > 0) {
            for (var i = 0; i < aResult.length; i++) {
                ECL_DeactivateAllAttributeValues("PMD_ABW070_001_000_1FE2");
                ECL_ActivateValue("PMD_ABW070_001_000_1FE2", aResult[i].PMD_ABW070_001_000_1FE2);
                ECL_DeactivateAllAttributeValues("MLFB14_1FE2");
                ECL_ActivateValue("MLFB14_1FE2", aResult[i].MLFB14_1FE2);
            }
        }
        ExecSetStandardifValueEmpty("PMD_ABW070_001_000_1FE2", "S_R");
    } else if (sScopeOfDelivery == "ROTOR") {
        // nur Rotor (MLFB15) wählbar, alle Werte, bei denen MLFB14 = fix
        ECL_DeactivateAllAttributeValues("MLFB14_1FE2");
        ECL_ActivateValue("MLFB14_1FE2", MLFB14_1FE2);
        ECL_SelectValue("MLFB14_1FE2", MLFB14_1FE2);

        var sTable = "VT_1FE2_M00074" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT PMD_ABW070_001_000_1FE2, MLFB15_1FE2 FROM " + sTable + " WHERE " +
            "MLFB14_1FE2 = '" + MLFB14_1FE2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);

        if (aResult.length > 0) {
            for (var i = 0; i < aResult.length; i++) {
                ECL_DeactivateAllAttributeValues("PMD_ABW070_001_000_1FE2");
                ECL_ActivateValue("PMD_ABW070_001_000_1FE2", aResult[i].PMD_ABW070_001_000_1FE2);
                ECL_DeactivateAllAttributeValues("MLFB15_1FE2");
                ECL_ActivateValue("MLFB15_1FE2", aResult[i].MLFB15_1FE2);
            }
        }
        ExecSetStandardifValueEmpty("PMD_ABW070_001_000_1FE2", "S_R");
    }

    // ################################################################################################################
    // setze MLFB13
    // ################################################################################################################
    var PMD_ABW070_001_000_1FE2 = ECL_GetValue("PMD_ABW070_001_000_1FE2");

    var sTable = "VT_1FE2_M00005" + sDB_Suffix;

    var sSQL = "SELECT DISTINCT MLFB13_1FE2 FROM " + sTable + " WHERE " +
        "PMD_ABW070_001_000_1FE2 = '" + PMD_ABW070_001_000_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        MLFB13_1FE2 = aResult[0].MLFB13_1FE2;
        sMLFB = replaceAt(sMLFB, 12, MLFB13_1FE2)
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FE2___PL_MLFB13_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Statorausführung (Kühlmantel)		PMD_ACF212_001_000_1FE2				MLFB14
    // ################################################################################################################
    /** MLFB14 ist über Lieferumfang ggf. voreingeschränkt
     * 
     * OHNE_KM	ohne Kühlmantel
     * MIT_KM	mit Kühlmantel
     * -	    -
     * 
     * VT_1FE2_M00006	MLFB14-Kühlmantel					==> Überstzung MLFB
     *      MLFB14_1FE2		PMD_ACF212_001_000_1FE2		HMK_VALUE_VALID_1FE2
     * 
     * VT_1FE2_M00089	ZO Motorlänge - Kühlmantel			==> ergibt sich
     *      alt:    PMD_ACF212_001_000_1FE2		PMD_ABY204_001_000_1FE2		HMK_VALUE_VALID_1FE2
     *      neu:    MLFB05_1FE2 MLFB07_1FE2 MLFB09_1FE2 PMD_ACF212_001_000_1FE2 HMK_PRODNAM_SLEEVE_1FE2 PMD_ABY204_001_000_1FE2 HMK_VALUE_VALID_1FE2
     * 
     * VT_1FE2_M00045	ZO Durchmesser - Kühlmantel			==> Einschränkung über BG
     *      MLFB05_1FE2		PMD_ABY192_001_000_1010140		PMD_ACF212_001_000_1FE2		HMK_VALUE_VALID_1FE2
     *
     * MLFB14_1FE2:
     *      VT_1FE2_M00006	MLFB14-Kühlmantel
     *      VT_1FE2_M00048	Kabelabgang-Kühlmantel		Einschränkung MLFB14 über MLFB05 !!!! bereits über VT45 abgedeckt, Kabelabgang nachrangig
     *   nn	VT_1FE2_M00050	statisches Maßbild
     *   nn	VT_1FE2_M00053	Tech-Daten-Gewicht
     *  	VT_1FE2_M00074	Scope of delivery, MLFB14, 15
     *          PMD_ABW070_001_000_1FE2	MLFB14_1FE2	MLFB15_1FE2	
     * 
     * BG 09 und 14 immer ohne KM, BG 18 wählbar
     */
    //var PMD_ABY204_001_000_1FE2 = ECL_GetValue("PMD_ABY204_001_000_1FE2"); // darf nicht einschränken, ist nur Ergebnis!
    if (sMLFB_BASE_TYPE.charAt(13) == ".") {
        ECL_EnableAttribute("PMD_ACF212_001_000_1FE2");

        var PMD_ABW070_001_000_1FE2 = ECL_GetValue("PMD_ABW070_001_000_1FE2");
        // MLFB14 einschränken
        var sTargetAttribute = "MLFB14_1FE2";
        var sTable = "VT_1FE2_M00074" + sDB_Suffix;
        var sWhere = "PMD_ABW070_001_000_1FE2 = '" + PMD_ABW070_001_000_1FE2 + "' AND " +
            "MLFB14_1FE2 <> 'B';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_STATOR_NO_DB_RESULT";
            return strError;
        }
        // VT_1FE2_M00089	ZO Motorlänge - Kühlmantel
        //  MLFB05_1FE2 MLFB07_1FE2 MLFB09_1FE2 PMD_ACF212_001_000_1FE2 HMK_PRODNAM_SLEEVE_1FE2 PMD_ABY204_001_000_1FE2 HMK_VALUE_VALID_1FE2
        var sTargetAttribute = "PMD_ACF212_001_000_1FE2";
        // --------------------------------------------------------------------------------------------
        // Übertragung Einschränkung MLFB14 auf PMD_ACF212_001_000_1FE2
        var sMLFB_NAME = "MLFB14_1FE2";

        var sTable = "VT_1FE2_M00006" + sDB_Suffix;
        var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sMLFB_NAME, sTable)

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_STATOR_NO_DB_RESULT";
            return strError;
        }
        // --------------------------------------------------------------------------------------------
        var sTable = "VT_1FE2_M00089" + sDB_Suffix;
        var sWhere = "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
            "MLFB07_1FE2 = '" + MLFB07_1FE2 + "' AND " +
            "MLFB09_1FE2 = '" + MLFB09_1FE2 + "' AND " +
            //"PMD_ABY204_001_000_1FE2 = '" + PMD_ABY204_001_000_1FE2 + "' AND " + // darf nicht einschränken, ist nur Ergebnis!
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_STATOR_NO_DB_RESULT";
            return strError;
        }
        // --------------------------------------------------------------------------------------------
        var sTable = "VT_1FE2_M00045" + sDB_Suffix;
        var sWhere = "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_STATOR_NO_DB_RESULT";
            return strError;
        }
        // ################################################################################################################
        // MLFB14 aktualisieren
        //if (MLFB05_1FE2 == "18") {
        /** VT_1FE2_M00006	MLFB14-Kühlmantel   nicht eindeutig
         * MLFB14_1FE2	PMD_ACF212_001_000_1FE2 	HMK_VALUE_VALID_1FE2
         * W	        -	                        T
         * C	        MIT_KM                  	T
         * D	        MIT_KM	                    T
         * A	        OHNE_KM	                    T
         * B	        OHNE_KM	                    T
         * E	        OHNE_KM	                    T
         * 
         * InnerJoin VT_1FE2_M00048    Kabelabgang-Kühlmantel
         * Zuordnung zu Achshöhe (MLFB05) macht es eindeutig
         * MLFB05_1FE1, MLFB14_1FE2, HMK_VALUE_VALID_1FE2 (MLFB12_1FE1 kann hier vernachlässigt werden)
         */

        var sTableA = "VT_1FE2_M00006" + sDB_Suffix;
        var sTableB = "VT_1FE2_M00048" + sDB_Suffix;
        var PMD_ACF212_001_000_1FE2 = ECL_GetValue("PMD_ACF212_001_000_1FE2");

        var sSQL = "SELECT DISTINCT " + sTableA + ".MLFB14_1FE2 FROM " + sTableA +
            " INNER JOIN " + sTableB + " ON " + sTableA + ".MLFB14_1FE2 = " + sTableB + ".MLFB14_1FE2 WHERE " +
            sTableA + ".PMD_ACF212_001_000_1FE2 = '" + PMD_ACF212_001_000_1FE2 + "' AND " +
            sTableB + ".MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
            sTableA + ".MLFB14_1FE2 <> 'B' AND " + // B nicht mehr gültig für Konfig (VT65)
            sTableA + ".HMK_VALUE_VALID_1FE2 = 'T' AND " +
            sTableB + ".HMK_VALUE_VALID_1FE2 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            MLFB14_1FE2 = aResult[0].MLFB14_1FE2;
            sMLFB = replaceAt(sMLFB, 13, MLFB14_1FE2)
            ECL_SelectValue("MLFB14_1FE2", MLFB14_1FE2);
            ECL_SetValue("ECSI_MLFB", sMLFB);
        } else {
            strError = "DICT1_ERR_1FE2___PL_MLFB14_NO_DB_RESULT";
            return strError;
        }
        /*} else {
            MLFB14_1FE2 = "E";
            sMLFB = replaceAt(sMLFB, 13, MLFB14_1FE2)
            ECL_SetValue("ECSI_MLFB", sMLFB);
        }*/
    } else {
        // Specified by BaseType, no change permitted
        ECL_DisableAttribute("PMD_ACF212_001_000_1FE2");

    }
    // ################################################################################################################

    // -----------------------------------------------------------------------------------------------------------
    // PMD_ABY192_001_000_1010140	Außendurchmesser Stator D
    // -----------------------------------------------------------------------------------------------------------
    /** VT_1FE2_M00045	ZO Durchmesser - Kühlmantel
     *      MLFB05_1FE2	Segment Merkmal MLFB05_1FE2
     *      PMD_ABY192_001_000_1010140	Durchmesser / des Motors
     *      PMD_ACF212_001_000_1FE2	Ausführung des Ständers
     *      HMK_VALUE_VALID_1FE2	Wert gültig
     * 
     */
    var PMD_ACF212_001_000_1FE2 = ECL_GetValue("PMD_ACF212_001_000_1FE2");
    if (PMD_ACF212_001_000_1FE2 == "-") {
        ECL_DeactivateAttribute("PMD_ABY192_001_000_1010140");
    } else {
        ECL_ActivateAttribute("PMD_ABY192_001_000_1010140");
        var sTable = "VT_1FE2_M00045" + sDB_Suffix;

        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
            "PMD_ACF212_001_000_1FE2 = '" + PMD_ACF212_001_000_1FE2 + "' AND " +
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);
        ECL_DeactivateAllAttributeValues("PMD_ABY192_001_000_1010140");
        if (aResult.length > 0) {
            var PMD_ABY192_001_000_1010140 = aResult[0].PMD_ABY192_001_000_1010140;

            ECL_ActivateValue("PMD_ABY192_001_000_1010140", PMD_ABY192_001_000_1010140);
            ECL_SetValue("PMD_ABY192_001_000_1010140", PMD_ABY192_001_000_1010140);
        } else {
            oData.strError = oData.strError + ECL_Translate("ERRORMSG_MLFB_1FE2___NO_DB_RESULT_STATOR_D");
            return;
        }
    }



    // ################################################################################################################
    // Ausführung des Läufers (Rotors)		PMD_ACF213_001_000_1FE2          MLFB15
    // ################################################################################################################
    /*  
    00002	Läuferpaket ohne Hülse, Innendurchmesser unbearbeitet
    00001	Läuferpaket mit Standardhülse
    00003	Rotorkern mit Standardhülse - ausgewuchtet
    00004	Ohne Rotor, nur Stator

    VT_1FE2_M00007	MLFB15-Läuferausführung
        MLFB15_1FE2     PMD_ACF213_001_000_1FE2     HMK_VALUE_VALID_1FE2
    
    MLFB15:
        VT_1FE2_M00007	MLFB15-Läuferausführung     MLFB-assignment only
        VT_1FE2_M00055	MLFB05-15
            MLFB05_1FE2     MLFB15_1FE2     HMK_VALUE_VALID_1FE2
        VT_1FE2_M00074	Scope of delivery, MLFB14, 15
            PMD_ABW070_001_000_1FE2     MLFB14_1FE2     MLFB15_1FE2
    nn? VT_1FE2_M00085	statisches Maßbild
        VT_1FE2_M00086	MLFB15 -- rotor sleeve (prodName)
            MLFB15_1FE2     HMK_PRODNAM_SLEEVE_1FE2
   
    HMK_PRODNAM_SLEEVE_1FE2
        -   	-
        WITH	mit Hülse
        WITHOUT	ohne Hülse

        VT_1FE2_M00086	MLFB15 -- rotor sleeve (prodName)
            MLFB15_1FE2     HMK_PRODNAM_SLEEVE_1FE2
        VT_1FE2_M00087	ZO Achshoehe - Innendurchmesser Rotor
            PMD_ABP663_001_000_1FE2     HMK_PRODNAM_SLEEVE_1FE2     PMD_ABY239_001_000_1FE2     HMK_VALUE_VALID_1FE2
        VT_1FE2_M00089	ZO Motorlänge - Kühlmantel
            MLFB05_1FE2     MLFB07_1FE2     MLFB09_1FE2     PMD_ACF212_001_000_1FE2     HMK_PRODNAM_SLEEVE_1FE2     PMD_ABY204_001_000_1FE2     HMK_VALUE_VALID_1FE2
    */
    if (sMLFB_BASE_TYPE.charAt(14) == ".") {
        ECL_EnableAttribute("PMD_ACF213_001_000_1FE2");

        var sTargetAttribute = "MLFB15_1FE2";

        var PMD_ABW070_001_000_1FE2 = ECL_GetValue("PMD_ABW070_001_000_1FE2");
        // MLFB15 einschränken

        var sTable = "VT_1FE2_M00074" + sDB_Suffix;
        var sWhere = "PMD_ABW070_001_000_1FE2 = '" + PMD_ABW070_001_000_1FE2 + "' AND " +
            "MLFB14_1FE2 <> 'B';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_STATOR_NO_DB_RESULT";
            return strError;
        }

        // VT_1FE2_M00055	MLFB05-15
        //  MLFB05_1FE2 MLFB15_1FE2 HMK_VALUE_VALID_1FE2
        var sTable = "VT_1FE2_M00055" + sDB_Suffix;
        var sWhere = "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_ROTOR_NO_DB_RESULT";
            return strError;
        }

        // Übertragung Einschränkung MLFB15 auf PMD_ACF213_001_000_1FE2
        var sTargetAttribute = "PMD_ACF213_001_000_1FE2";
        var sMLFB_NAME = "MLFB15_1FE2";

        var sTable = "VT_1FE2_M00007" + sDB_Suffix;
        var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sMLFB_NAME, sTable)

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_ROTOR_NO_DB_RESULT";
            return strError;
        }
        // ################################################################################################################
        // MLFB15 aktualisieren
        var sTable = "VT_1FE2_M00007" + sDB_Suffix;
        var PMD_ACF213_001_000_1FE2 = ECL_GetValue("PMD_ACF213_001_000_1FE2");

        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "PMD_ACF213_001_000_1FE2 = '" + PMD_ACF213_001_000_1FE2 + "' AND " +
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            MLFB15_1FE2 = aResult[0].MLFB15_1FE2;
            sMLFB = replaceAt(sMLFB, 14, MLFB15_1FE2)
            ECL_SetValue("ECSI_MLFB", sMLFB);
            ECL_SelectValue("MLFB15_1FE2", MLFB15_1FE2);
        } else {
            strError = "DICT1_ERR_1FE2___PL_MLFB15_NO_DB_RESULT";
            return strError;
        }

        // -----------------------------------------------------------------------------------------------------------
        // HMK_PRODNAM_SLEEVE_1FE2
        // -----------------------------------------------------------------------------------------------------------
        // VT_1FE2_M00086
        // MLFB15_1FE2 HMK_PRODNAM_SLEEVE_1FE2
        var sTable = "VT_1FE2_M00086" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "MLFB15_1FE2 = '" + MLFB15_1FE2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0) {
            var HMK_PRODNAM_SLEEVE_1FE2 = aResult[0].HMK_PRODNAM_SLEEVE_1FE2;
            ECL_ActivateValue("HMK_PRODNAM_SLEEVE_1FE2", HMK_PRODNAM_SLEEVE_1FE2);
            ECL_SetValue("HMK_PRODNAM_SLEEVE_1FE2", HMK_PRODNAM_SLEEVE_1FE2);
        }
        else {
            strError = "DICT1_ERR_1FE2___PLVT_HMK_PRODNAM_SLEEVE";
            return strError;
        }
        // -----------------------------------------------------------------------------------------------------------
        // Innendurchmesser Rotor d     PMD_ABY239_001_000_1FE2
        // -----------------------------------------------------------------------------------------------------------
        /* VT_1FE2_M00087	ZO Achshoehe - Innendurchmesser Rotor
                PMD_ABP663_001_000_1FE2     HMK_PRODNAM_SLEEVE_1FE2     PMD_ABY239_001_000_1FE2     HMK_VALUE_VALID_1FE2
        */
        var sTable = "VT_1FE2_M00087" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "PMD_ABP663_001_000_1FE2 = '" + PMD_ABP663_001_000_1FE2 + "' AND " +
            "HMK_PRODNAM_SLEEVE_1FE2 = '" + HMK_PRODNAM_SLEEVE_1FE2 + "' AND " +
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);
        ECL_DeactivateAllAttributeValues("PMD_ABY239_001_000_1FE2");
        if (aResult.length > 0) {
            var PMD_ABY239_001_000_1FE2 = aResult[0].PMD_ABY239_001_000_1FE2;
            ECL_ActivateValue("PMD_ABY239_001_000_1FE2", PMD_ABY239_001_000_1FE2);
            ECL_SelectValue("PMD_ABY239_001_000_1FE2", PMD_ABY239_001_000_1FE2);
        }
        else {
            strError = "ERRORMSG_MLFB_1FE2___NO_DB_RESULT_INNER_DIAMETER";
            return strError;
        }

    } else {
        // Specified by BaseType, no change permitted
        ECL_DisableAttribute("PMD_ACF213_001_000_1FE2");
    }

    // ################################################################################################################
    // Ausführung			HMK_AUSFUEHRUNG_1FE2			MLFB09
    // ################################################################################################################
    /*
    VT_1FE2_M00031	MLFB09_Ausfuehrung
    
        MLFB09_1FE2	HMK_AUSFUEHRUNG_1FE2	HMK_VALUE_VALID_1FE2
        A			00001					T
        C			00001					T
        L			00002					T         
    
    ==> PARSER
    */

    // ################################################################################################################


    // ################################################################################################################
    // Wicklungsausführung		HMK_W_AUSFUEHRUNG_UI_1FE2  HMK_W_AUSFUEHRUNG_1FE2		Stern oder Stern/Dreieck
    // ################################################################################################################
    /* todo, ist jetzt eindeutig, kann in Parser verschoben werden
nn	VT_1FE2_M00059	Chartlinie M - Rumpf/Spannung AsynchronM
nn	VT_1FE2_M00060	Chartlinie P - Rumpf/Spannung AsynchronM
    VT_1FE2_M00112  Technical data Y/D
    VT_1FE2_M00063	MLFB16 - Wicklungsausführung				keine Einschränkung, nur Übersetzung MLFB
    
     VT_1FE2_M00090	Winding UI; Winding; MLFB16
        HMK_W_AUSFUEHRUNG_UI_1FE2	Wicklungsausführung
        HMK_W_AUSFUEHRUNG_1FE2	Wicklungsausführung
        MLFB16_1FE2	Segment Merkmal MLFB16_1FE2
    
    MLFB16
        VT_1FE2_M00022	MLFB11-Motorschutz
        nn	VT_1FE2_M00059	Chartlinie M - Rumpf/Spannung AsynchronM
        nn	VT_1FE2_M00060	Chartlinie P - Rumpf/Spannung AsynchronM
        VT_1FE2_M00112	Technical data Y/D
        VT_1FE2_M00063	MLFB16 - Wicklungsausführung

        VT_1FE2_M00090	Winding UI; Winding; MLFB16
    
    DT-K setzt bei DI auf Y (00001), wenn MLFB16 == 2	todo
    */

    // VT_1FE2_M00112	Technical data Y/D
    // MLFB05_1FE2	MLFB07_1FE2	MLFB09_1FE2	MLFB10_1FE2	MLFB16_1FE2	HMK_W_AUSFUEHRUNG_UI_1FE2	
    if (sMLFB_BASE_TYPE.charAt(15) == ".") {

        // MLFB16 einschränken (ob überhaupt 1 und 2 möglich sind)
        //  VT_1FE2_M00112	Technical data Y/D
        var sTargetAttribute = "MLFB16_1FE2";

        var sTable = "VT_1FE2_M00112" + sDB_Suffix;
        var sWhere = "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
            "MLFB07_1FE2 = '" + MLFB07_1FE2 + "' AND " +
            "MLFB09_1FE2 = '" + MLFB09_1FE2 + "' AND " +
            "MLFB10_1FE2 = '" + MLFB10_1FE2 + "' AND " +
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_W_AUSF_NO_DB_RESULT";
            return strError;
        }

        var ECSI_CX_MotorConnection = ECL_GetValue("ECSI_CX_MotorConnection");
        /* 	0	Motor dimensioned with delta circuit
            1	Motor dimensioned with star circuit
        */

        if (ECSI_CX_MotorConnection == "0") {
            // nur 2 möglich
            ECL_DeactivateValue("MLFB16_1FE2", "1");
        }

        // Einschränkung übertragen auf HMK_W_AUSFUEHRUNG_UI_1FE2
        var sTargetAttribute = "HMK_W_AUSFUEHRUNG_UI_1FE2";
        var sMLFB_NAME = "MLFB16_1FE2";

        var sTable = "VT_1FE2_M00090" + sDB_Suffix;

        var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sMLFB_NAME, sTable)

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_W_AUSF_NO_DB_RESULT";
            return strError;
        }

        // ################################################################################################################
        // setze MLFB16
        // ################################################################################################################
        /*
        VT_1FE2_M00090	Winding UI; Winding; MLFB16
            HMK_W_AUSFUEHRUNG_UI_1FE2	Wicklungsausführung
            HMK_W_AUSFUEHRUNG_1FE2	Wicklungsausführung
            MLFB16_1FE2	Segment Merkmal MLFB16_1FE2
        */

        var HMK_W_AUSFUEHRUNG_UI_1FE2 = ECL_GetValue("HMK_W_AUSFUEHRUNG_UI_1FE2");

        // Bestimmung über VT90
        var sTable = "VT_1FE2_M00090" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT MLFB16_1FE2 FROM " + sTable + " WHERE " +
            "HMK_W_AUSFUEHRUNG_UI_1FE2 = '" + HMK_W_AUSFUEHRUNG_UI_1FE2 + "';";

        var aResult = GetDBDataSetEXT(sSQL);

        if (aResult.length > 0) {
            MLFB16_1FE2 = aResult[0].MLFB16_1FE2;
        } else {
            //Fehler
            strError = "DICT1_ERR_1FE2___PL_MLFB16_NO_DB_RESULT";
            return strError;
        }
        ECL_SelectValue("MLFB16_1FE2", MLFB16_1FE2);
        sMLFB = replaceAt(sMLFB, 15, MLFB16_1FE2)
        ECL_SetValue("ECSI_MLFB", sMLFB);

        // ################################################################################################################
        // ################################################################################################################
        // wenn MLFB16 1 UND 2 möglich:
        var aValidValuesMLFB16 = ECL_GetAllActiveAttributeValues("MLFB16_1FE2");

        if (aValidValuesMLFB16.length > 1) {
            // Auswahl möglich

        } else {
            // Auswahl nicht möglich

        }
    } else {
        // Specified by BaseType, no change permitted
        ECL_DeactivateAllAttributeValues("HMK_W_AUSFUEHRUNG_UI_1FE2");
        if (MLFB16_1FE2 == "1") {
            ECL_ActivateValue("HMK_W_AUSFUEHRUNG_UI_1FE2", "Y");
            ECL_SelectValue("HMK_W_AUSFUEHRUNG_UI_1FE2", "Y");
        } else if (MLFB16_1FE2 == "2") {
            ECL_ActivateValue("HMK_W_AUSFUEHRUNG_UI_1FE2", "Y_D");
            ECL_SelectValue("HMK_W_AUSFUEHRUNG_UI_1FE2", "Y_D");
        }

    }
    // ################################################################################################################
    /*var sTargetAttribute = "HMK_W_AUSFUEHRUNG_UI_1FE2";
    // VT_1FE2_M00112	Technical data Y/D
    var sTable = "VT_1FE2_M00112" + sDB_Suffix;
    var sWhere = "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
        "MLFB07_1FE2 = '" + MLFB07_1FE2 + "' AND " +
        "MLFB09_1FE2 = '" + MLFB09_1FE2 + "' AND " +
        "MLFB10_1FE2 = '" + MLFB10_1FE2 + "' AND " +
        "MLFB16_1FE2 = '" + MLFB16_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE2___PLVT_W_AUSF_NO_DB_RESULT";
        return strError;
    }
*/
    var ECSI_CX_MotorConnection = ECL_GetValue("ECSI_CX_MotorConnection");
    /* 	0	Motor dimensioned with delta circuit
        1	Motor dimensioned with star circuit
    */

    if (ECSI_CX_MotorConnection == "0") {

        var sTargetAttribute = "HMK_W_AUSFUEHRUNG_UI_1FE2";
        var aValidValues = ['Y_D'];

        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            // Fehler
            strError = ECL_Translate("DICT1_ERR_1FE2___PLVT_W_AUSF_NO_DB_RESULT");
            return strError;
        }
    }
    // ################################################################################################################


    // ################################################################################################################
    // Motorschutz			PMD_AAA863_001_000_1FE2			MLFB11
    // ################################################################################################################
    /*
    VT_1FE2_M00022	MLFB11-Motorschutz
        MLFB11_1FE2	            Segment Merkmal MLFB11_1FE2
        PMD_AAA863_001_000_1FE2	Ausführung des Motorschutzes
        MLFB16_1FE2	            Segment Merkmal MLFB16_1FE2
        HMK_MLFB_DIREKT_1FE2	Direkteingabe erfolgt
        HMK_VALUE_VALID_1FE2	Wert gültig

    MLFB11 nichts weiteres
    */

    // ################################################################################################################
    var sTargetAttribute = "PMD_AAA863_001_000_1FE2";

    var sTable = "VT_1FE2_M00022" + sDB_Suffix;
    var sWhere = "MLFB16_1FE2 = '" + MLFB16_1FE2 + "' AND " +
        "HMK_MLFB_DIREKT_1FE2 = 'F' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FE2___PL_MLFB11_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    // setze MLFB11		
    // ################################################################################################################
    var sTable = "VT_1FE2_M00022" + sDB_Suffix;
    // MLFB11_1FE2	PMD_AAA863_001_000_1FE2	MLFB16_1FE2	HMK_MLFB_DIREKT_1FE2	HMK_VALUE_VALID_1FE2

    var PMD_AAA863_001_000_1FE2 = ECL_GetValue("PMD_AAA863_001_000_1FE2");

    var sSQL = "SELECT DISTINCT MLFB11_1FE2 FROM " + sTable + " WHERE " +
        "PMD_AAA863_001_000_1FE2 = '" + PMD_AAA863_001_000_1FE2 + "' AND " +
        "MLFB16_1FE2 = '" + MLFB16_1FE2 + "' AND " +
        "HMK_MLFB_DIREKT_1FE2 = 'F' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        MLFB11_1FE2 = aResult[0].MLFB11_1FE2;
        sMLFB = replaceAt(sMLFB, 10, MLFB11_1FE2)
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {
        strError = "DICT1_ERR_1FE2___PL_MLFB11_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Kabelabgang		PMD_AAA759_001_000_1FE2	(Art des Kabelabgangs)	MLFB12
    // ################################################################################################################
    /*
    VT_1FE2_M00004	MLFB12_Kabelabgang
    
    
    MLFB12_1FE2
        VT_1FE2_M00004	MLFB12_Kabelabgang
            MLFB12_1FE2 PMD_AAA759_001_000_1FE2 HMK_VALUE_VALID_1FE2	
        VT_1FE2_M00048	Kabelabgang-Kühlmantel
            MLFB05_1FE2	MLFB12_1FE2	MLFB14_1FE2	HMK_VALUE_VALID_1FE2
        
    nn	VT_1FE2_M00085	statisches Maßbild

 
    */
    if (sMLFB_BASE_TYPE.charAt(11) == ".") {

        // zunächst MLFB12 einschränken
        var sTargetAttribute = "MLFB12_1FE2";

        var sTable = "VT_1FE2_M00048" + sDB_Suffix;
        var sWhere = "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
            "MLFB14_1FE2 = '" + MLFB14_1FE2 + "' AND " +
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_MLFB12_NO_DB_RESULT";
            return strError;
        }

        // Einschränkung übertragen auf PMD_AAA759_001_000_1FE2
        var sTargetAttribute = "PMD_AAA759_001_000_1FE2";
        var sMLFB_NAME = "MLFB12_1FE2";

        var sTable = "VT_1FE2_M00004" + sDB_Suffix;

        var sStatus = SetAttributeLogicFromMLFB(sTargetAttribute, sMLFB_NAME, sTable)

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FE2___PLVT_KABELABGANG_NO_DB_RESULT";
            return strError;
        }

        // ################################################################################################################

        // ################################################################################################################
        // setze MLFB12
        // ################################################################################################################
        // 

        var PMD_AAA759_001_000_1FE2 = ECL_GetValue("PMD_AAA759_001_000_1FE2");

        var sTable = "VT_1FE2_M00004" + sDB_Suffix;

        var sSQL = "SELECT DISTINCT MLFB12_1FE2 FROM " + sTable + " WHERE " +
            "PMD_AAA759_001_000_1FE2 = '" + PMD_AAA759_001_000_1FE2 + "' AND " +
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);

        if (aResult.length > 0) {
            MLFB12_1FE2 = aResult[0].MLFB12_1FE2;
            sMLFB = replaceAt(sMLFB, 11, MLFB12_1FE2)
            ECL_SetValue("ECSI_MLFB", sMLFB);
            ECL_SelectValue("MLFB12_1FE2", MLFB12_1FE2);
        } else {
            strError = "DICT1_ERR_1FE2___PL_MLFB12_NO_DB_RESULT";
            return strError;
        }
    } else {
        var PMD_AAA759_001_000_1FE2 = ECL_GetValue("PMD_AAA759_001_000_1FE2");
        ECL_DeactivateAllAttributeValues("PMD_AAA759_001_000_1FE2");
        ECL_ActivateValue("PMD_AAA759_001_000_1FE2", PMD_AAA759_001_000_1FE2);
        ECL_SelectValue("PMD_AAA759_001_000_1FE2", PMD_AAA759_001_000_1FE2);

        ECL_DeactivateAllAttributeValues("MLFB12_1FE2");
        ECL_ActivateValue("MLFB12_1FE2", MLFB12_1FE2);
        ECL_SelectValue("MLFB12_1FE2", MLFB12_1FE2);
    }
    // ################################################################################################################



    // ################################################################################################################
    // PMD_ACF212_001_000_1FE2	Statorausführung (Kühlmantel)       MLFB14
    // ################################################################################################################
    /**
     * VT_1FE2_M00006	MLFB14-Kühlmantel
     *  MLFB14_1FE2     PMD_ACF212_001_000_1FE2     HMK_VALUE_VALID_1FE2
     * 
     * VT_1FE2_M00045	ZO Durchmesser - Kühlmantel
     *  MLFB05_1FE2     PMD_ABY192_001_000_1010140      PMD_ACF212_001_000_1FE2     HMK_VALUE_VALID_1FE2
     * 
     * VT_1FE2_M00089	ZO Motorlänge - Kühlmantel
     *   MLFB05_1FE2    MLFB07_1FE2     MLFB09_1FE2     PMD_ACF212_001_000_1FE2     
     *   HMK_PRODNAM_SLEEVE_1FE2     PMD_ABY204_001_000_1FE2     HMK_VALUE_VALID_1FE2
     * 
     */

    // PMD_ABY192_001_000_1010140 ausblenden, wenn PMD_ACF212_001_000_1FE2 == "-"
    /*
    Restrictions:
        * Stator design (cooling jacket)
        d.HMK_SCREEN_DEP_INVISIBLE = 'PMD_ACF212_001_000_1FE2'
        if c.PMD_ACF212_001_000_1FE2 = '-',
        *
        * Outer diameter stator
        d.HMK_SCREEN_DEP_INVISIBLE = 'PMD_ABY192_001_000_1010140'
        if c.PMD_ACF212_001_000_1FE2 = '-',
        *
        * Inner diameter rotor
        d.HMK_SCREEN_DEP_INVISIBLE = 'PMD_ABY239_001_000_1FE2'
        if c.PMD_ABW070_001_000_1FE2 = 'ET_S'
     */




    // ################################################################################################################
    // setze MLFB14 		
    // ################################################################################################################
    var sTable1 = "VT_1FE2_M00048" + sDB_Suffix;
    var sTable2 = "VT_1FE2_M00006" + sDB_Suffix;

    var PMD_ACF212_001_000_1FE2 = ECL_GetValue("PMD_ACF212_001_000_1FE2");

    // try to get the valid character for mlfb14
    // letter B is forbidden based on SPC

    var sSQL = `SELECT ${sTable1}.MLFB14_1FE2
    FROM ${sTable1}
    INNER JOIN ${sTable2}
    ON ${sTable1}.[MLFB14_1FE2] = ${sTable2}.[MLFB14_1FE2]
    WHERE [MLFB05_1FE2] = '${MLFB05_1FE2}' AND
    [MLFB12_1FE2] = '${MLFB12_1FE2}' AND
    [PMD_ACF212_001_000_1FE2] = '${PMD_ACF212_001_000_1FE2}' AND
    ${sTable1}.MLFB14_1FE2 <> 'B';`

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        MLFB14_1FE2 = aResult[0].MLFB14_1FE2;
        sMLFB = replaceAt(sMLFB, 13, MLFB14_1FE2)
        ECL_SetValue("ECSI_MLFB", sMLFB);
    } else {

        // try to get the valid character for mlfb14 without the restriction of PMD_ACF212_001_000_1FE2
        // get multiple values to be able to set the value of PMD_ACF212_001_000_1FE2 besides mlfb14

        var sSQL = `SELECT * FROM ${sTable1}
        INNER JOIN ${sTable2}
        ON ${sTable1}.[MLFB14_1FE2] = ${sTable2}.[MLFB14_1FE2]
        WHERE [MLFB05_1FE2] = '${MLFB05_1FE2}' AND
        [MLFB12_1FE2] = '${MLFB12_1FE2}' AND
        ${sTable1}.MLFB14_1FE2 <> 'B';`

        var aResult = GetDBDataSetEXT(sSQL);

        // if no result retund an error, just like before
        if (aResult.lenght === 0) {
            strError = "DICT1_ERR_1FE2___PL_MLFB11_NO_DB_RESULT";
            return strError;
        }

        // set values based on the result
        MLFB14_1FE2 = aResult[0].MLFB14_1FE2;
        sMLFB = replaceAt(sMLFB, 13, MLFB14_1FE2);
        ECL_SelectValue("MLFB14_1FE2", aResult[0].MLFB14_1FE2);
        ECL_SelectValue("PMD_ACF212_001_000_1FE2", aResult[0].PMD_ACF212_001_000_1FE2);
        ECL_SetValue("ECSI_MLFB", sMLFB);

        PMD_ACF212_001_000_1FE2 = aResult[0].PMD_ACF212_001_000_1FE2;

        aResult = aResult.map(x => x.PMD_ACF212_001_000_1FE2);
        ECL_DeactivateAllAttributeValues("PMD_ACF212_001_000_1FE2");

        for (i = 0; i < aResult.length; i++) {
            ECL_ActivateValue("PMD_ACF212_001_000_1FE2", aResult[i]);
        }
    }
    // ################################################################################################################


    // ################################################################################################################
    // HMK_T00_1FE2	Rotor vorgewuchtet		abgebildet über Checkbox-Attribut CB_T00_1FE2
    // ################################################################################################################
    /*
    nn VT_1FE2_M00050	statisches Maßbild
    VT_1FE2_M00058	Lieferumfang-T00
 
    */
    //var PMD_ABW070_001_000_1FE2 = ECL_GetValue("PMD_ABW070_001_000_1FE2");

    if (MLFB05_1FE2 == "18" && PMD_ABW070_001_000_1FE2 != "ET_S") {
        ECL_EnableAttribute("CB_T00_1FE2");
    } else {
        ECL_DeselectAttribute("CB_T00_1FE2");
        ECL_DisableAttribute("CB_T00_1FE2");
    }
    // ################################################################################################################


    // MLFB16 bestimmen
    // 1,2

    /*
    VT_1FE2_M00022	MLFB11-Motorschutz								keine Einschränkung, nicht eindeutig
    nn	VT_1FE2_M00059	Chartlinie M - Rumpf/Spannung AsynchronM
    nn	VT_1FE2_M00060	Chartlinie P - Rumpf/Spannung AsynchronM
    VT_1FE2_M00112	Technical data Y/D								HMK_W_AUSFUEHRUNG_UI: Y, Y_D || Y MLFB16 = 1, Y_D == 2 
    VT_1FE2_M00063	MLFB16 - Wicklungsausführung					HMK_W_AUSFUEHRUNG = 00001 nur MLFB16 = 1, bei 2 beide (auch 00002)
    */

    // ################################################################################################################
    return "OK";

}
