//@legacy
//#mode(full-ecma)


//@import "StringHandler.js"
//@import "Parser.common.js"
//@import "Parser.tokenizer.js"
//@import "../1FE2_MLFB/Base.misc.js"
//@import "../1FE2_CONFIG/VT_1FE2.js"


/**
 * @category   1FE2 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2021 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init_1FE2(strMLFB) {
    vtTimeStart = Date.getTime();

    var oParsing = {
        strBaseMLFB: '',
        strFullMLFB: '',
        strSecMLFB: '',
        strError: '',
        strWarning: '',
        aTokens: [],
        oFreetext: {}
    };

    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    if (strBaseTypeMLFB.length === 12) {
        strBaseTypeMLFB = strBaseTypeMLFB + "....";
    }


    if (strMLFB.length === 12) {
        strMLFB = strMLFB + "....";
        ECL_SetValue("ECSI_MLFB", strMLFB);
    }

    strMLFB = normalizeMLFB(strMLFB);
    strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

    var strSecMLFB = GetMlfbSec() || "";

    var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

    if (strStartConfiguration == "" && find(strMLFB.left(16), ".") >= 0)
        strStartConfiguration = "1";

    //if(strStartConfiguration=="1")
    //{
    //Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
    //Hier sollen dann möglichst viele Attribute beibehalten werden.
    //Die Basetype MLFB kann sich in Getriebe, Motor oder Übersetzung von der Haupt MLFB unterscheiden.
    if (strBaseTypeMLFB != "") {
        //--------------------------------------------------------------------------------------------------------
        // Base Type  MLFB aufbereiten
        //--------------------------------------------------------------------------------------------------------
        var aBTComponents = tokenize(strBaseTypeMLFB);
        if (aBTComponents.length > 1) {
            // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
            // eliminate the resulting invalid short description 'Z'
            if ((aBTComponents[1] === 'Z') || (aBTComponents[1] === '-Z')) {
                aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
            }
        }

        strBaseTypeMLFB = aBTComponents[0];

        if (strBaseTypeMLFB.length === 17) {
            // eliminate the -Z 
            strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
        }

        var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring(0, 10);
    }

    var oResult;

    var nFreetext = find(strMLFB, '{');
    var strFreetext = '';
    if (nFreetext > 0) {
        strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
    }
    oParsing.oFreetext = parseFreetext(strFreetext, true);
    strMLFB = replace(strMLFB, strFreetext, "");
    oParsing.strFullMLFB = strMLFB;
    oParsing.strSecMLFB = strSecMLFB;


    var aComponents = tokenize(strMLFB);
    if (!aComponents.length) {
        oParsing.strError = 'ERRORMSG_MLFB_1FE2___INVALID_MLFB';
        return (oParsing)
    } else if (aComponents.length > 1) {
        // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
        // eliminate the resulting invalid short description 'Z'
        if ((aComponents[1] === 'Z') || (aComponents[1] === '-Z')) {
            aComponents = removeElementsFromArray(aComponents, 1, 1);
        }
    }
    oParsing.strBaseMLFB = aComponents[0];
    oParsing.aTokens = aComponents;

    var strMLFB_fix = strMLFB.substring(0, 10); // 

    var sMLFB05 = strMLFB.charAt(4) + strMLFB.charAt(5);

    if (strStartConfiguration == "1" && strBaseTypeMLFB_fix == strMLFB_fix && strBaseTypeMLFB != "" && find(strMLFB.left(16), ".") < 0)   // if same motor is selected again
    {
        var bRepairConfig = true;
    }
    // -----------------------------------------------------------------------------------------------
    //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
    // -----------------------------------------------------------------------------------------------
    if (((strBaseTypeMLFB_fix != strMLFB_fix) && find(strMLFB.left(16), ".") < 0 && strBaseTypeMLFB != "") || bRepairConfig) {
        // -----------------------------------------------------------------------------------------------
        // Platzhalter aus MLFB in BT übernehmen
        // -----------------------------------------------------------------------------------------------
        /* MLFB-Schema
            MLFB01	1FE2
            MLFB05	Baugröße 			        {07,09,11,12,14,18}
            MLFB07	Baulänge			        {2,3,4,5,6,7}
            MLFB08	8 Polpaarzahl			    {8}
            MLFB09	Motorprinzip / Ausführung	{A,C,L}
            MLFB10	Wicklungsvariante (Bemessungsdrehzahl)	{C,E,G,H,J,K,L,M,N}
            MLFB11	. Motorschutz		        {1,3,5}
            MLFB12	n|. Kabelabgang		        {0,1,2,3}	// kann belegt sein oder Wildcard
            MLFB13	. Lieferumfang		        {1,2,3(,4,5)}
            MLFB14	C|. Statorausführung (Kühlmantel)		{A,B,C}
            MLFB15	C|. Läuferausführung	    {A,C}
            MLFB16	1|. Wicklungsausführung	    {0,1,2}     0 nicht mehr gültig, 1 Y, 2 Y/D
        */
        // 11 bis 16 ein Wildcard, dann Wert aus alter MLFB prüfen und setzen, ggf. Default setzen

        // --------------------------------------------------------------------------------------------------------
        // MLFB16 Version (+ Stern/Dreieck)
        // --------------------------------------------------------------------------------------------------------
        var sMLFB16 = strMLFB.charAt(15);
        var sBT_MLFB16 = strBaseTypeMLFB.charAt(15);
        var sMLFB16default = "";

        if (sBT_MLFB16 == ".") {
            sMLFB16default = GetMLFB16_1FE2(strBaseTypeMLFB);
            if (sMLFB16default == "ERROR") {
                oParsing.strError = 'ERRORMSG_MLFB_1FE2___DET_MLFB16';
                return (oParsing);
            }
            sMLFB16 = checkMLFB16_1FE2(strBaseTypeMLFB, sMLFB16, sMLFB16default);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
        }
        // -----------------------------------------------------------------------------------------------

        // --------------------------------------------------------------------------------------------------------
        // MLFB11 Motorschutz
        // --------------------------------------------------------------------------------------------------------
        var sMLFB11 = strMLFB.charAt(10);
        var sBT_MLFB11 = strBaseTypeMLFB.charAt(10);
        var sMLFB11default = "1";

        if (sBT_MLFB11 == ".") {
            sMLFB11 = checkMLFB11_1FE2(strBaseTypeMLFB, sMLFB11, sMLFB11default);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 10, sMLFB11);
        }

        // --------------------------------------------------------------------------------------------------------
        // MLFB12 Kabelabgang
        // --------------------------------------------------------------------------------------------------------
        var sMLFB12 = strMLFB.charAt(11);
        var sBT_MLFB12 = strBaseTypeMLFB.charAt(11);
        var sMLFB12default = "0";

        if (sBT_MLFB12 == ".") {

            sMLFB12 = checkMLFB12_1FE2(strBaseTypeMLFB, sMLFB12, sMLFB12default);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
        }
        // --------------------------------------------------------------------------------------------------------
        // MLFB13 Lieferumfang
        // --------------------------------------------------------------------------------------------------------
        var sMLFB13 = strMLFB.charAt(12);
        var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);
        var sMLFB13default = "1";

        if (sBT_MLFB13 == ".") {
            sMLFB13 = checkMLFB13_1FE2(strBaseTypeMLFB, sMLFB13, sMLFB13default);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, sMLFB13);
        }
        // --------------------------------------------------------------------------------------------------------
        // MLFB14 Stator-Ausführung
        // --------------------------------------------------------------------------------------------------------
        var sMLFB14 = strMLFB.charAt(13);
        if (sMLFB14 == "B") {    // Compatibility to previous versions
            sMLFB14 = "E";
        }

        var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);
        var sMLFB14default = "";

        if (sMLFB05 == "18" && sMLFB12 == "1") {
            sMLFB14default = "C";
        } else if (sMLFB05 == "18" && sMLFB12 != "1") {
            sMLFB14default = "A";
        } else {
            sMLFB14default = "E"; // B obsolet since 3.53, E is used instead
        }

        if (sBT_MLFB14 == ".") {
            sMLFB14 = checkMLFB14_1FE2(strBaseTypeMLFB, sMLFB14, sMLFB14default);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
        }

        // --------------------------------------------------------------------------------------------------------
        // MLFB15 Ausführung des Läufers		feste Zuordnung zu BG
        // --------------------------------------------------------------------------------------------------------
        var sMLFB15 = strMLFB.charAt(14);
        var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);
        var sMLFB15default = "";

        if (sBT_MLFB15 == ".") {
            if (sMLFB05 == "18") {
                sMLFB15default = "C";
            } else {
                sMLFB15default = "A";
            }
            sMLFB15 = checkMLFB15_1FE2(strBaseTypeMLFB, sMLFB15, sMLFB15default);
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
        }


        // -----------------------------------------------------------------------------------------------
        // Zuweisen der neuen MLFB und KAG-Liste
        strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

        oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
        oParsing.strFullMLFB = strMLFB;
        aComponents[0] = oParsing.strBaseMLFB;
        oParsing.aTokens = aComponents;
        ECL_SetValue("ECSI_MLFB", strMLFB);
    }
    // -- END EDIT KEEP CONF --
    // Wildcards definieren, wenn kein Keep Configuration
    else {
        if (find(strMLFB.left(16), ".") >= 0) {
            //Unvollständige SIZER MLFB
            /* MLFB-Schema
            
            MLFB01	1FE2
            MLFB05	Baugröße 			{09,14,18}
            MLFB07	Baulänge			{2,3,4,5,6,7}
            MLFB08	8 Polpaarzahl			{8}
            MLFB09	Motorprinzip / Ausführung	{A,C,L}
            MLFB10	Wicklungsvariante (Bemessungsdrehzahl)	{C,E,G,H,J,K,L,M,N}
            MLFB11	. Motorschutz		{1,3,5}
            MLFB12	. Kabelabgang		{0,1,2,3}
            MLFB13	. Lieferumfang		{1,2,3(,4,5)}
            MLFB14	. Statorausführung (Kühlmantel)		{A,B,E,C} 'B' is obsolet and replaced by 'E'
            MLFB15	. Läuferausführung	{A,C}
            MLFB16	. Wicklungsausführung Y/D	{0,1,2}          0 nicht mehr gültig, 1 Y, 2 Y/D
            for synchronous motors MLFB14...16 fixed to CC1
            */
            // ##########################################################################################
            // Prüfen, ob '.' an Stelle 1 bis 10, dann Fehler
            // ##########################################################################################
            for (var i = 0; i < 10; i++) {
                if (strMLFB.charAt(i) == ".") {
                    oParsing.strError = 'ERRORMSG_MLFB_1FE2___INCOMPLETE_MLFB';
                    return (oParsing);
                }
            }

            // ##########################################################################################
            // Wenn MLFB11 bis MLFB16 ein Wildcard, dann Default setzen
            // ##########################################################################################

            // --------------------------------------------------------------------------------------------------------
            // MLFB16 Version
            // --------------------------------------------------------------------------------------------------------
            var sMLFB16 = strMLFB.charAt(15);

            if (sMLFB16 == ".") {
                sMLFB16 = GetMLFB16_1FE2(strMLFB);
                if (sMLFB16 == "ERROR") {
                    oParsing.strError = 'ERRORMSG_MLFB_1FE2___DET_MLFB16';
                    return (oParsing);
                }
                strMLFB = replaceAt(strMLFB, 15, sMLFB16);
            }
            // --------------------------------------------------------------------------------------------------------

            // --------------------------------------------------------------------------------------------------------
            // MLFB11 Motorschutz
            // --------------------------------------------------------------------------------------------------------
            var sMLFB11 = strMLFB.charAt(10);

            if (sMLFB11 == ".") {
                sMLFB11 = "1";
                strMLFB = replaceAt(strMLFB, 10, sMLFB11);
            }

            // --------------------------------------------------------------------------------------------------------
            // MLFB12 Kabelabgang
            // --------------------------------------------------------------------------------------------------------
            var sMLFB12 = strMLFB.charAt(11);

            if (sMLFB12 == ".") {
                sMLFB12 = "0";
                strMLFB = replaceAt(strMLFB, 11, sMLFB12);
            }

            // --------------------------------------------------------------------------------------------------------
            // MLFB13 Lieferumfang
            // --------------------------------------------------------------------------------------------------------
            var sMLFB13 = strMLFB.charAt(12);

            if (sMLFB13 == ".") {
                sMLFB13 = "1";
                strMLFB = replaceAt(strMLFB, 12, sMLFB13);
            }
            // --------------------------------------------------------------------------------------------------------
            // MLFB14 Ausführung des Ständers (Stator)
            // --------------------------------------------------------------------------------------------------------

            var sMLFB14 = strMLFB.charAt(13);


            if (sMLFB14 == ".") {
                if (sMLFB05 == "18" && sMLFB12 == "1") {
                    sMLFB14 = "C";
                } else if (sMLFB05 == "18" && sMLFB12 != "1") {
                    sMLFB14 = "A";
                } else {
                    sMLFB14 = "E"; // B obsolet since 3.53, E is used instead
                }
                strMLFB = replaceAt(strMLFB, 13, sMLFB14);
            }
            if (sMLFB14 == "B") {    // Compatibility to previous versions
                sMLFB14 = "E";
                strMLFB = replaceAt(strMLFB, 13, sMLFB14);
            }
            // --------------------------------------------------------------------------------------------------------
            // MLFB15 Ausführung des Läufers		feste Zuordnung zu BG
            // --------------------------------------------------------------------------------------------------------
            var sMLFB15 = strMLFB.charAt(14);

            if (sMLFB15 == ".") {
                if (sMLFB05 == "18") {
                    sMLFB15 = "C";
                } else {
                    sMLFB15 = "A";
                }
                strMLFB = replaceAt(strMLFB, 14, sMLFB15);
            }



            ECL_SetValue("ECSI_MLFB", strMLFB);

            oParsing.strBaseMLFB = strMLFB.substring(0, 16);
            aComponents[0] = oParsing.strBaseMLFB;
            //oParsing.aTokens = aComponents;
        } else {

            // MLFB vollständig definiert

            ECL_SetValue("ECSI_MLFB", strMLFB);

            oParsing.strBaseMLFB = strMLFB.substring(0, 16);
            aComponents[0] = oParsing.strBaseMLFB;

        }

    }
    //}
    // END IS-Start-Configuration

    if (oParsing.strBaseMLFB.length !== 16) {
        // Prüfen, ob die Zeichenkette 16 Stellen hat
        oParsing.strError = 'ERRORMSG_MLFB_1FE2___PARSE_WRONG_SIZE';
        return (oParsing);
    }

    if (oParsing.strBaseMLFB.indexOf("1FE2") < 0) {
        // Falsches Produkt
        oParsing.strError = 'ERRORMSG_MLFB_1FE2___PARSE_WRONG_PRODUCT';
        return (oParsing);
    }

    var oResult;
    oResult = parse_1FE2(oParsing.aTokens);

    if (oResult) {
        if (oResult.oProduct)
            oParsing.oProduct = oResult.oProduct;
        if (oResult.oParsingData)
            oParsing.oParsingData = oResult.oParsingData;
        oParsing.strError += ((oParsing.strError ? ' ' : '') + oResult.strError);
        oParsing.strWarning += ((oParsing.strWarning ? ' ' : '') + oResult.strWarning);
    }

    vtTimeStop = Date.getTime();
    vtTime = (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

    return (oParsing);
}


function parse_1FE2(aTokens) {
    var oResult = {
        strError: '',
        strRegion: '',
        strWarning: '',
        oProduct: null,
        oParsingData: {}
    };
    /*
    MLFB-Schema
    
        MLFB01	1FE2
        MLFB05	Baugröße 			{09,14,18}
        MLFB07	Baulänge			{2,3,4,5,6,7}
        MLFB08	8 Polpaarzahl			{8}
        MLFB09	Motorprinzip / Ausführung	{A,C,L}
        MLFB10	Wicklungsvariante (Bemessungsdrehzahl)	{C,E,G,H,J,K,L,M,N}
        MLFB11	. Motorschutz		{1,3,5}
        MLFB12	. Kabelabgang		{0,1,2,3}
        MLFB13	. Lieferumfang		{1,2,3(,4,5)}
        MLFB14	. Statorausführung (Kühlmantel)		{A,B,C}
        MLFB15	C Läuferausführung	{A,C}
        MLFB16	. Versionsstand		{0,1,2}
    */
    var strBaseMLFB = aTokens[0];
    oResult.oParsingData.MLFB = {};
    oResult.oParsingData.MLFB.MLFB01 = strBaseMLFB.substring(0, 4);	// 01 1FE2
    oResult.oParsingData.MLFB.MLFB05 = strBaseMLFB.charAt(4) + strBaseMLFB.charAt(5);	// 05 Baugröße {09,14,18}
    oResult.oParsingData.MLFB.MLFB07 = strBaseMLFB.charAt(6);		// 07 Baulänge
    oResult.oParsingData.MLFB.MLFB08 = strBaseMLFB.charAt(7);		// 08 Polpaarzahl
    oResult.oParsingData.MLFB.MLFB09 = strBaseMLFB.charAt(8);		// 09 Motorprinzip / Ausführung	{A,C,L}
    oResult.oParsingData.MLFB.MLFB10 = strBaseMLFB.charAt(9);		// 10 Wicklungsvariante (Bemessungsdrehzahl)	{C,E,G,H,J,K,L,M,N}
    oResult.oParsingData.MLFB.MLFB11 = strBaseMLFB.charAt(10);	// 11 . Motorschutz		{1,3,5}
    oResult.oParsingData.MLFB.MLFB12 = strBaseMLFB.charAt(11);	// 12 . Kabelabgang		{0,1,2,3}
    oResult.oParsingData.MLFB.MLFB13 = strBaseMLFB.charAt(12);	// 13 . Lieferumfang		{1,2,3(,4,5)}
    oResult.oParsingData.MLFB.MLFB14 = strBaseMLFB.charAt(13); 	// 14 . Statorausführung (Kühlmantel)		{A,B,C}
    oResult.oParsingData.MLFB.MLFB15 = strBaseMLFB.charAt(14); 	// 15 C Läuferausführung	{A,C}
    oResult.oParsingData.MLFB.MLFB16 = strBaseMLFB.charAt(15); 	// 16 . Versionsstand		{0,1,2}

    oResult.oParsingData.RUMPF = strBaseMLFB.substring(0, 10); 		// = MLFB_RUMPF_01_10_1FE2
    //oResult.oParsingData.MLFB_SEC = ECL_GetValue("ECSI_MLFB_SEC") || ""; 		// Sekundär-MLFB


    // ################################################################################################################

    // Kurzangaben
    if (aTokens.length > 0) {
        if (aTokens[0] === strBaseMLFB) {
            aTokens = removeElementsFromArray(aTokens, 0, 1);
        }
        oResult.oParsingData.MLFB.KAG = aTokens || [];

        oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
    }

    return oResult;
}

/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
    var kagString = "";
    for (var i = 0; i < aTokens.length; i++) {
        kagString += aTokens[i];
        if (i < aTokens.length - 1) {
            kagString += ";";
        }
    }
    return kagString;
}


function SetFreetextValue(field, value) {

    value = trimleft(value, '*');
    value = trimright(value, '*');

    ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {

    /*	zur Info - oParse: 
        {
            strBaseMLFB : '',
            strFullMLFB
            strError : '',
            strWarning : '',
            aTokens : [],
            oFreetext : {}
        };
    */
    /*/ O_Y84_1FK2	+ O_Y84_TXT_1FK2
    if (find(oParse.strFullMLFB , 'Y84') >= 0) {
        if (oParse.oFreetext['Y84']) SetFreetextValue('O_Y84_TXT_1FK2', oParse.oFreetext['Y84']);
    }*/
}

function isKAGinMLFB(aArray, sKAG) {
    for (var i = 0; i < aArray.length; i++) {
        if (aArray[i] == sKAG)
            return true;
    }

    return false;
}

// ####################################################################################################################
// ####################################################################################################################
// functions to check overhanded values and return value if allowed or return default value
function checkMLFB11_1FE2(strBaseTypeMLFB, MLFB11_1FE2, sMLFB11default) {
    var MLFB16_1FE2 = strBaseTypeMLFB.charAt(15);

    var sTable = "VT_1FE2_M00022" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB11_1FE2 = '" + MLFB11_1FE2 + "' AND " +
        "MLFB16_1FE2 = '" + MLFB16_1FE2 + "' AND " +
        "HMK_MLFB_DIREKT_1FE2 = 'F' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        return MLFB11_1FE2;
    }

    return sMLFB11default;

}

function checkMLFB12_1FE2(strBaseTypeMLFB, MLFB12_1FE2, sMLFB12default) {
    var MLFB05_1FE2 = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5);

    //  VT_1FE2_M00048	Kabelabgang-Kühlmantel
    //    MLFB05_1FE2	MLFB12_1FE2	MLFB14_1FE2	HMK_VALUE_VALID_1FE2

    var sTable = "VT_1FE2_M00048" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
        "MLFB12_1FE2 = '" + MLFB12_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        return MLFB12_1FE2;
    }

    return sMLFB12default;
}

function checkMLFB13_1FE2(strBaseTypeMLFB, MLFB13_1FE2, sMLFB13default) {
    var sTable = "VT_1FE2_M00005" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB13_1FE2 = '" + MLFB13_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        return MLFB13_1FE2;
    }

    return sMLFB13default;
}

function checkMLFB14_1FE2(strBaseTypeMLFB, MLFB14_1FE2, sMLFB14default) {
    var MLFB05_1FE2 = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5);
    var MLFB12_1FE2 = strBaseTypeMLFB.charAt(11);

    //  VT_1FE2_M00048	Kabelabgang-Kühlmantel
    //    MLFB05_1FE2	MLFB12_1FE2	MLFB14_1FE2	HMK_VALUE_VALID_1FE2

    var sTable = "VT_1FE2_M00048" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
        "MLFB12_1FE2 = '" + MLFB12_1FE2 + "' AND " +
        "MLFB14_1FE2 = '" + MLFB14_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        return MLFB14_1FE2;
    }

    return sMLFB14default;
}

function checkMLFB15_1FE2(strBaseTypeMLFB, MLFB15_1FE2, sMLFB15default) {
    var MLFB05_1FE2 = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5);

    var sTable = "VT_1FE2_M00055" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
        "MLFB15_1FE2 = '" + MLFB15_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
        return MLFB15_1FE2;
    }

    return sMLFB15default;
}
// function to get a default value for MLFB16
function GetMLFB16_1FE2(strMLFB) {

    var MLFB05_1FE2 = strMLFB.charAt(4) + strMLFB.charAt(5);
    var MLFB07_1FE2 = strMLFB.charAt(6);
    var MLFB09_1FE2 = strMLFB.charAt(8);
    var MLFB10_1FE2 = strMLFB.charAt(9);

    var ECSI_CX_MotorConnection = ECL_GetValue("ECSI_CX_MotorConnection");
    if (ECSI_CX_MotorConnection == "0") {
        var HMK_W_AUSFUEHRUNG_UI_1FE2 = "Y_D";
    } else if (ECSI_CX_MotorConnection == "1") {
        var HMK_W_AUSFUEHRUNG_UI_1FE2 = "Y";
    }

    var sTable = "VT_1FE2_M00112" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT MLFB16_1FE2 FROM " + sTable + " WHERE " +
        "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
        "MLFB07_1FE2 = '" + MLFB07_1FE2 + "' AND " +
        "MLFB09_1FE2 = '" + MLFB09_1FE2 + "' AND " +
        "MLFB10_1FE2 = '" + MLFB10_1FE2 + "' AND " +
        "HMK_W_AUSFUEHRUNG_UI_1FE2 = '" + HMK_W_AUSFUEHRUNG_UI_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        var MLFB16_1FE2 = aResult[0].MLFB16_1FE2;
        return MLFB16_1FE2;
    } else {
        var sTable = "VT_1FE2_M00112" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT MLFB16_1FE2 FROM " + sTable + " WHERE " +
            "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
            "MLFB07_1FE2 = '" + MLFB07_1FE2 + "' AND " +
            "MLFB09_1FE2 = '" + MLFB09_1FE2 + "' AND " +
            "MLFB10_1FE2 = '" + MLFB10_1FE2 + "' AND " +
            "HMK_VALUE_VALID_1FE2 = 'T';";

        var aResult = GetDBDataSetEXT(sSQL);

        if (aResult.length > 0) {
            var MLFB16_1FE2 = aResult[0].MLFB16_1FE2;
            return MLFB16_1FE2;
        } else {
            //Fehler
            return "ERROR";
        }
    }
}

function checkMLFB16_1FE2(strMLFB, MLFB16_1FE2, sMLFB16default) {
    var MLFB05_1FE2 = strMLFB.charAt(4) + strMLFB.charAt(5);
    var MLFB07_1FE2 = strMLFB.charAt(6);
    var MLFB09_1FE2 = strMLFB.charAt(8);
    var MLFB10_1FE2 = strMLFB.charAt(9);

    var ECSI_CX_MotorConnection = ECL_GetValue("ECSI_CX_MotorConnection");
    if (ECSI_CX_MotorConnection == "0") {
        var HMK_W_AUSFUEHRUNG_UI_1FE2 = "Y_D";
    } else if (ECSI_CX_MotorConnection == "1") {
        var HMK_W_AUSFUEHRUNG_UI_1FE2 = "Y";
    }

    var sTable = "VT_1FE2_M00112" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT MLFB16_1FE2 FROM " + sTable + " WHERE " +
        "MLFB05_1FE2 = '" + MLFB05_1FE2 + "' AND " +
        "MLFB07_1FE2 = '" + MLFB07_1FE2 + "' AND " +
        "MLFB09_1FE2 = '" + MLFB09_1FE2 + "' AND " +
        "MLFB10_1FE2 = '" + MLFB10_1FE2 + "' AND " +
        "MLFB16_1FE2 = '" + MLFB16_1FE2 + "' AND " +
        "HMK_W_AUSFUEHRUNG_UI_1FE2 = '" + HMK_W_AUSFUEHRUNG_UI_1FE2 + "' AND " +
        "HMK_VALUE_VALID_1FE2 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);

    if (aResult.length > 0) {
        // Wert gültig
        return MLFB16_1FE2;
    }
    return sMLFB16default;

}