//@legacy
//#mode(full-ecma)



//@import "VT_1FG1.js"


/*
Checkroutinen ergänzt für Keep Konfiguration
*/

function SetBefestigung_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Befestigungsart(oData); 	 	//Art der Befestigung PMD_ABV672_001_000_1FG1S
        Bestimme_FlanschDurchmesser(oData); 	//	Getriebe-Flansch-Durchmesser UI_FLANSCH_DURCHM_1FG1S
            //Bestimme_FlanschDurchmesser(oData);	// H_FLANSCH_DURCHM_1FG1S
            //Bestimme_FlanschDurchmesser(oData);	// Option Getriebe-Flansch-Durchmesser O_H01_BIS_H20_1FG1S
        Bestimme_Wellenende(oData);		// Ausführung des Wellenendes PMD_ABV414_001_000_1FG1S				
            //Bestimme_Wellenende(oData);		//  Option Ausführung des Wellenendes O_H1G_BIS_H7A_1FG1S
            //Bestimme_WellenDurchmesser(oData);		// Durchmesser H_WELLEN_DURCHM_1FG1S
        Bestimme_Drehmomentstuetze(oData);		// Drehmomentstütze Figur 2 O_G10_1FG1S
        
    } else {
        ExecSetStandardifValueEmpty("PMD_ABV672_001_000_1FG1S","FU");
        ExecSetStandardifValueEmpty("UI_FLANSCH_DURCHM_1FG1S","OHNE");
        ExecSetStandardifValueEmpty("H_FLANSCH_DURCHM_1FG1S","0");
        ExecSetStandardifValueEmpty("O_H01_BIS_H20_1FG1S","STD");
        ExecSetStandardifValueEmpty("PMD_ABV414_001_000_1FG1S","VOLL_STD");
        ExecSetStandardifValueEmpty("O_H1G_BIS_H7A_1FG1S","STD");
        ExecSetStandardifValueEmpty("H_WELLEN_DURCHM_1FG1S", "");
        ExecSetStandardifValueEmpty("O_G10_1FG1S","F");
    }
}

function SetBefestigung(strchangedAttribute, oData)
{
    
}

/**
    MLFB14	. Befestigungsart	{A, B, C, D, F, H} --> Fuß-, Fuß/Flansch-, Flansch-, Gehäuseflanschausführung (C, D: Drehmomentstütze + ggf. G10)
*/
function Bestimme_Befestigungsart(oData)
{
    //MLFB14
    
    /*	VT_1FG1S_M00011	MLFB <> Befestigung								Übersetzung Attribut<->MLFB
        MLFB14_1FG1S	PMD_ABV672_001_000_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    var MLFB14_1FG1S = oData.oParsingData.MLFB.POS14;
    
    var sTable = "VT_1FG1S_M00011" + sDB_Suffix;
    var sSQL = "SELECT PMD_ABV672_001_000_1FG1S FROM "+sTable+" WHERE " +
                "MLFB14_1FG1S = '" + MLFB14_1FG1S + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable);
    if (aResult.length > 0)
    {
        var PMD_ABV672_001_000_1FG1S = aResult[0].PMD_ABV672_001_000_1FG1S;
        
        //checkBefestigungsart(); bei Keep Konf im Parser
        
        ECL_ActivateValue("PMD_ABV672_001_000_1FG1S", PMD_ABV672_001_000_1FG1S);
        ECL_SetValue("PMD_ABV672_001_000_1FG1S", PMD_ABV672_001_000_1FG1S);
        
    }else{
        ExecSetStandardifValueEmpty("PMD_ABV672_001_000_1FG1S","FU");
    }
    
    
    /*
    Abhängig von Getriebeart, prüfen!
    
    VT_1FG1S_M00048	ZO Getriebeart > Befestigung
        PMD_ABV517_001_000_1FG1S	PMD_ABV672_001_000_1FG1S	HMK_VALUE_VALID_1FG1S
    VT_1FG1S_M00059	ZO Befestigung - Flansch Durchmesser

    */
    
    
}

function Bestimme_FlanschDurchmesser(oData)
{
    // O_H01_BIS_H20_1FG1S
    var oMLFB = oData.oParsingData.MLFB;
    // O_H01_BIS_H20_1FG1S
    // KAG: H01...H10, STD
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_H01_BIS_H20_1FG1S";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    //var aKAG = parseObj.MLFB.KAG || [];
    
    if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkFlanschDurchmesser(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
        
        // -------------------------------------------------------------------------------
        // Hilfsmerkmale und UI-Attribut
        // H_FLANSCH_DURCHM_1FG1S
        /* VT_1FG1S_M00039_	O: Flansch-DM (H01-H20)
            PMD_ABV410_001_000_1FG1S	H_FLANSCH_DURCHM_1FG1S	O_H01_BIS_H20_1FG1S	HMK_VALUE_VALID_1FG1S
        */
        var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");
        var O_H01_BIS_H20_1FG1S = sKAG;
        
        var sTable = "VT_1FG1S_M00039" + sDB_Suffix;
        var sSQL = "SELECT H_FLANSCH_DURCHM_1FG1S FROM "+sTable+" WHERE " +
                    "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
                    "O_H01_BIS_H20_1FG1S = '" + O_H01_BIS_H20_1FG1S + "' AND " +
                    "HMK_VALUE_VALID_1FG1S = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSER" );
        
        if (aResult.length > 0){
            var H_FLANSCH_DURCHM_1FG1S = aResult[0].H_FLANSCH_DURCHM_1FG1S;
            ECL_ActivateValue("H_FLANSCH_DURCHM_1FG1S", H_FLANSCH_DURCHM_1FG1S);
            ECL_SetValue("H_FLANSCH_DURCHM_1FG1S", H_FLANSCH_DURCHM_1FG1S);
            
            // UI_FLANSCH_DURCHM_1FG1S
            /* VT_1FG1S_M00059	ZO Befestigung - Flansch Durchmesser
                UI_FLANSCH_DURCHM_1FG1S	H_FLANSCH_DURCHM_1FG1S	PMD_ABV672_001_000_1FG1S
            */
            if (H_FLANSCH_DURCHM_1FG1S == 0){
                var UI_FLANSCH_DURCHM_1FG1S = "OHNE";
            }else{
                var UI_FLANSCH_DURCHM_1FG1S = H_FLANSCH_DURCHM_1FG1S;
            }
            ECL_SetValue("UI_FLANSCH_DURCHM_1FG1S", UI_FLANSCH_DURCHM_1FG1S);
        }
    }
    // wenn keine KAG oder nicht erlaubt, STD setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "STD");
        ECL_SetValue(sTargetAttribute, "STD");
        
        // Durchmesser 0 (ohne Flansch) oder Standard-Wert
        // UI_FLANSCH_DURCHM_1FG1S
        // H_FLANSCH_DURCHM_1FG1S
        /*
        Bestimmen über VT39 und VT59
        */
        var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");
        var PMD_ABV672_001_000_1FG1S = ECL_GetValue("PMD_ABV672_001_000_1FG1S");
        var O_H01_BIS_H20_1FG1S = "STD";
        
        var sTable1 = "VT_1FG1S_M00039" + sDB_Suffix;
        var sTable2 = "VT_1FG1S_M00059" + sDB_Suffix;
        var sSQL = "SELECT "+sTable1+".H_FLANSCH_DURCHM_1FG1S FROM "+sTable1+" INNER JOIN " +
                    sTable2+" ON " +
                    sTable1+".H_FLANSCH_DURCHM_1FG1S = "+sTable2+".H_FLANSCH_DURCHM_1FG1S " +
                    "WHERE " +
                    sTable1+".PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
                    sTable1+".O_H01_BIS_H20_1FG1S = '" + O_H01_BIS_H20_1FG1S + "' AND " +
                    sTable1+".HMK_VALUE_VALID_1FG1S = 'T' AND " +
                    sTable2+".PMD_ABV672_001_000_1FG1S = '" + PMD_ABV672_001_000_1FG1S + "';";
        
        var aResult = GetDBDataSetEXT(sSQL, "VT_1FG1S_M00039"+"_JOIN_59" );
        
        if (aResult.length > 0){
            var H_FLANSCH_DURCHM_1FG1S = aResult[0].H_FLANSCH_DURCHM_1FG1S;
            ECL_ActivateValue("H_FLANSCH_DURCHM_1FG1S", H_FLANSCH_DURCHM_1FG1S );
            ECL_SetValue("H_FLANSCH_DURCHM_1FG1S", H_FLANSCH_DURCHM_1FG1S);
        }
        if (H_FLANSCH_DURCHM_1FG1S == 0){
            var UI_FLANSCH_DURCHM_1FG1S = "OHNE";
        }else{
            var UI_FLANSCH_DURCHM_1FG1S = H_FLANSCH_DURCHM_1FG1S;
        }
        ECL_ActivateValue("H_FLANSCH_DURCHM_1FG1S", H_FLANSCH_DURCHM_1FG1S );
        ECL_SetValue("UI_FLANSCH_DURCHM_1FG1S", UI_FLANSCH_DURCHM_1FG1S);
    }
}
function checkFlanschDurchmesser(oData, sTargetAttribute, sKAG)
{
    // todo
    /*
    VT_1FG1S_M00039	O: Flansch-DM (H01-H20)
    VT_1FG1S_M00086	H0X-Getriebe-Befestigung
    
    VT_1FG1S_M00039	O: Flansch-DM (H01-H20)
        PMD_ABV410_001_000_1FG1S	H_FLANSCH_DURCHM_1FG1S	O_H01_BIS_H20_1FG1S	HMK_VALUE_VALID_1FG1S

    VT_1FG1S_M00086	H0X-Getriebe-Befestigung
        MLFB_05_06_07_1FG1S	MLFB14_1FG1S	O_H01_BIS_H20_1FG1S
    */
    return 1;
}


/**
    Ausführung des Wellenendes PMD_ABV414_001_000_1FG1S	
    MLFB08 oder KAG
*/
function Bestimme_Wellenende(oData)
{
    /*
    Wellenende aus MLFB08 und wenn '9', dann aus KAG HnX
    VT_1FG1S_M00040	MLFB: Wellenausführung
        MLFB08_1FG1S	PMD_ABV414_001_000_1FG1S	PMD_ABV410_001_000_1FG1S	H_WELLEN_DURCHM_1FG1S	
        O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S
    
    MLFB08:
    VT_1FG1S_M00077	Getriebe-Welle-Befestigung
    VT_1FG1S_M00084	G20-Getriebe-Befest.-Welle
    VT_1FG1S_M00231	G60-Getriebe-Welle
    VT_1FG1S_M00161	N16-MLFB09-09-14
    VT_1FG1S_M00168	Wellenverriegelung
    
    O_H1G_BIS_H7A_1FG1S:
    VT_1FG1S_M00040	MLFB: Wellenausführung
    VT_1FG1S_M00084	G20-Getriebe-Befest.-Welle
    VT_1FG1S_M00231	G60-Getriebe-Welle
    VT_1FG1S_M00168	Wellenverriegelung


    */
    var MLFB08_1FG1S = oData.oParsingData.MLFB.POS8;
    
    if (MLFB08_1FG1S == "9"){
        //prüfen, ob KAG (sollte vorhanden sein)
        // O_H1G_BIS_H7A_1FG1S
        // KAG: STD, H1G, H3A, H3B, H3C, H3G, H3H, H3I, H3J, H3K, H3L, H3M, H3N, H3P, H4A, H5A, H6A, H7A
        
        var parseObj = oData.oParsingData;
        
        var sTargetAttribute = "O_H1G_BIS_H7A_1FG1S";
        var bCheck = false;
        
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
        
        //if (parseObj.MLFB.KAG.indexOf(sKAG) > -1){	
        if (sKAG != "NON"){
            // es gibt eine KAG, also prüfen, ob erlaubt
            bCheck = checkWellenende(oData, sTargetAttribute, sKAG);
        }
        if (bCheck){
            // wenn erlaubt, setzen
            ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SetValue(sTargetAttribute, sKAG);
            
            // PMD_ABV414_001_000_1FG1S setzen
            /* VT_1FG1S_M00040	MLFB: Wellenausführung
                MLFB08_1FG1S	PMD_ABV414_001_000_1FG1S	PMD_ABV410_001_000_1FG1S	H_WELLEN_DURCHM_1FG1S	
                O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S
            */
            
            var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");
            //var H_WELLEN_DURCHM_1FG1S = ECL_GetValue("H_WELLEN_DURCHM_1FG1S");
            
            var sTable = "VT_1FG1S_M00040" + sDB_Suffix;
            var sSQL = "SELECT DISTINCT * FROM "+sTable+" WHERE " +
                        "MLFB08_1FG1S = '" 				+ MLFB08_1FG1S + "' AND " +
                        "PMD_ABV410_001_000_1FG1S = '" 	+ PMD_ABV410_001_000_1FG1S + "' AND " +
                        //"H_WELLEN_DURCHM_1FG1S = '" 	+ H_WELLEN_DURCHM_1FG1S + "' AND " +
                        "O_H1G_BIS_H7A_1FG1S = '" 		+ sKAG + "' AND " +
                        "HMK_VALUE_VALID_1FG1S = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
            if (aResult.length > 0){
                var PMD_ABV414_001_000_1FG1S = aResult[0].PMD_ABV414_001_000_1FG1S;
                var H_WELLEN_DURCHM_1FG1S = aResult[0].H_WELLEN_DURCHM_1FG1S;
                ECL_SetValue("PMD_ABV414_001_000_1FG1S", PMD_ABV414_001_000_1FG1S);
                ECL_SetValue("H_WELLEN_DURCHM_1FG1S", H_WELLEN_DURCHM_1FG1S);
            }
        }
        // wenn keine KAG oder nicht erlaubt, STD setzen
        else{
            ECL_ActivateValue(sTargetAttribute, "STD");
            ECL_SetValue(sTargetAttribute, "STD");
            var PMD_ABV414_001_000_1FG1S = "VOLL_STD";
            ECL_SetValue("PMD_ABV414_001_000_1FG1S", PMD_ABV414_001_000_1FG1S);
            
            var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");
            //var H_WELLEN_DURCHM_1FG1S = ECL_GetValue("H_WELLEN_DURCHM_1FG1S");
            
            var sTable = "VT_1FG1S_M00040" + sDB_Suffix;
            var sSQL = "SELECT DISTINCT H_WELLEN_DURCHM_1FG1S FROM "+sTable+" WHERE " +
                        "MLFB08_1FG1S = '" 				+ MLFB08_1FG1S + "' AND " +
                        "PMD_ABV410_001_000_1FG1S = '" 	+ PMD_ABV410_001_000_1FG1S + "' AND " +
                        "PMD_ABV414_001_000_1FG1S = '" 	+ PMD_ABV414_001_000_1FG1S + "' AND " +
                        "O_H1G_BIS_H7A_1FG1S = '" 		+ sKAG + "' AND " +
                        "HMK_VALUE_VALID_1FG1S = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
            if (aResult.length > 0){
                var H_WELLEN_DURCHM_1FG1S = aResult[0].H_WELLEN_DURCHM_1FG1S;
                
                ECL_SetValue("H_WELLEN_DURCHM_1FG1S", H_WELLEN_DURCHM_1FG1S);
            }
            
        }
        
    }else{ //Bestimmung aus MLFB08_1FG1S
        var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");
        
        var sTable = "VT_1FG1S_M00040" + sDB_Suffix;
        var sSQL = "SELECT PMD_ABV414_001_000_1FG1S FROM "+sTable+" WHERE " +
                "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
                "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
        if (aResult.length > 0)
        {
            var PMD_ABV414_001_000_1FG1S = aResult[0].PMD_ABV414_001_000_1FG1S;
            var H_WELLEN_DURCHM_1FG1S = aResult[0].H_WELLEN_DURCHM_1FG1S;
            
            ECL_ActivateValue("PMD_ABV414_001_000_1FG1S", PMD_ABV414_001_000_1FG1S);
            ECL_SetValue("PMD_ABV414_001_000_1FG1S", PMD_ABV414_001_000_1FG1S);
            
            ECL_SetValue("H_WELLEN_DURCHM_1FG1S", H_WELLEN_DURCHM_1FG1S);
            
        }else{ // in PARSER-Prüfung bei KEEP Conf? Todo  oder hier mit return-Wert
            var sTable = "VT_1FG1S_M00040" + sDB_Suffix;
            var sSQL = "SELECT PMD_ABV414_001_000_1FG1S FROM "+sTable+" WHERE " +
                "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "';";
            
            var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE_2");
            if (aResult.length > 0){
                var MLFB08_1FG1S = aResult[0].MLFB08_1FG1S;
                
            }
        }
    }
    
    // VT_1FG1S_M00077	Getriebe-Wellenausführung
    // 	PMD_ABV410_001_000_1FG1S	MLFB08_1FG1S	MLFB14_1FG1S

}
function checkWellenende(oData, sTargetAttribute, sKAG)
{
    /* VT_1FG1S_M00040	MLFB: Wellenausführung
        MLFB08_1FG1S	PMD_ABV414_001_000_1FG1S	PMD_ABV410_001_000_1FG1S	H_WELLEN_DURCHM_1FG1S	
        O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    
    var MLFB08_1FG1S = oData.oParsingData.MLFB.POS8;
    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");
    //var H_WELLEN_DURCHM_1FG1S = ECL_GetValue("H_WELLEN_DURCHM_1FG1S");
    
    var sTable = "VT_1FG1S_M00040" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
                "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
                //"H_WELLEN_DURCHM_1FG1S = '" + H_WELLEN_DURCHM_1FG1S + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    /* VT_1FG1S_M00168	Wellenverriegelung					keine Logikeinschränkung?
        MLFB_05_06_07_1FG1S	MLFB08_1FG1S	MLFB10_1FG1S	MLFB14_1FG1S	O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S
    
    // VT_1FG1S_M00077	Getriebe-Wellenausführung
    // 	PMD_ABV410_001_000_1FG1S	MLFB08_1FG1S	MLFB14_1FG1S
    */
    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
    var MLFB10_1FG1S = oData.oParsingData.MLFB.POS10;
    var MLFB14_1FG1S = oData.oParsingData.MLFB.POS14;
    
    var sTable = "VT_1FG1S_M00168" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
                "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
                "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
                "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1){
        return 0;
    }
    
    //--------------------------------------------------------------------------------------------------------------
    return 1;	
}
// #########################################################################################################################

/**
    
*/
function Bestimme_Drehmomentstuetze(oData)
{
    // O_G10_1FG1S
    // KAG: G10, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_G10_1FG1S";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "G10"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    
    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1){	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkDrehmomentstuetze(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkDrehmomentstuetze(oData, sTargetAttribute, sKAG)
{
    // Nur Stirnschneckenradgetriebe 6xx und MLFB14 == D
    // VT_1FG1S_M00079
    // MLFB_05_06_07_1FG1S	MLFB14_1FG1S	O_G10_1FG1S
    
    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
    var MLFB14_1FG1S = oData.oParsingData.MLFB.POS14;
    
    var sTable = "VT_1FG1S_M00079" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
                "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
    
}