//@legacy
//#mode(full-ecma)



//@import "VT_1FG1.js"


/*
Checkroutinen ergänzt für Keep Konfiguration
*/

function SetBremse_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Bremse(oData); 	 		// UI_HALTEBREMSE_1FG1S		Haltebremse
        Bestimme_Bremsmoment(oData);		// PMD_ACF397_001_000_1006470	Bremsmoment
    } else {
        ExecSetStandardifValueEmpty("UI_HALTEBREMSE_1FG1S","OHNE");
        ExecSetStandardifValueEmpty("O_N30_BIS_N34_1006470","F");
        ExecSetStandardifValueEmpty("PMD_ACF397_001_000_1006470","0");
        ExecSetStandardifValueEmpty("O_K82_1FG1S","F");
        ExecSetStandardifValueEmpty("O_Q94_Q95_Q96_1FG1S","OHNE");
    }
}

function SetBremse(strchangedAttribute, oData)
{
}

/**
    Wenn N23, N24 --> mit Bremse, keine N30...N34, kein K82, kein Q94...Q96
    Wenn N30...N34, K82 optional
    wenn K82, und kein Q94..Q96, Position Handlüfthebel: STD
*/
function Bestimme_Bremse(oData)
{
    // UI_HALTEBREMSE_1FG1S
    // KAG: N23, N24, OHNE, ARB				Wenn ARB (Federkraftbremse), dann ohne KAG-Bremse, dafür N30...N34
    var parseObj = oData.oParsingData;
    
    // Bremsenvorgabe aus SIZER:
    var ECSI_IS_START_CONFIGURATION = parseInt(ECL_GetValue("ECSI_IS_START_CONFIGURATION"));
    var ECSI_CX_MotorBrakeRequired = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    if (ECSI_CX_MotorBrakeRequired == "1"){
        ECL_ActivateAllAttributeValues("UI_HALTEBREMSE_1FG1S");
        ECL_DeactivateValue("UI_HALTEBREMSE_1FG1S", "OHNE");
    }else{
        ECL_DeactivateAllAttributeValues("UI_HALTEBREMSE_1FG1S");
        ECL_ActivateValue("UI_HALTEBREMSE_1FG1S", "OHNE");
        ECL_SetValue("UI_HALTEBREMSE_1FG1S", "OHNE");
        return;
    }
    var sTargetAttribute = "UI_HALTEBREMSE_1FG1S";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    
    if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkBremse(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
        
        // Wenn N23 oder N24, keine Federkraftbremse, Option auf NON setzen
        ECL_ActivateValue("O_N30_BIS_N34_1006470", "NON");
        ECL_SetValue("O_N30_BIS_N34_1006470", "NON");
        // Kein Handlüfthebel:
        ECL_ActivateValue("O_K82_1FG1S", "F");
        ECL_SetValue("O_K82_1FG1S", "F");
        ECL_ActivateValue("O_Q94_Q95_Q96_1FG1S", "OHNE");
        ECL_SetValue("O_Q94_Q95_Q96_1FG1S", "OHNE");
    }
    // wenn keine KAG oder nicht erlaubt, OHNE oder ARB setzen
    else{
        // O_N30_BIS_N34_1006470
        // KAG: NON, N30, N31, N32, N33, N34
        var sTargetAttributeARB = "O_N30_BIS_N34_1006470";
        var bCheck = false;
        
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = getKAGforAttribute(sTargetAttributeARB, parseObj.MLFB.KAG);
        
        if (sKAG != "NON"){
            // es gibt eine KAG, also prüfen, ob erlaubt
            bCheck = checkBremse(oData, sTargetAttributeARB, sKAG);
        }
        if (bCheck){
            // wenn erlaubt, setzen
            ECL_ActivateValue(sTargetAttributeARB, sKAG);
            ECL_SetValue(sTargetAttributeARB, sKAG);
            // Bremse auf ARB setzen
            ECL_ActivateValue(sTargetAttribute, "ARB");
            ECL_SetValue(sTargetAttribute, "ARB");
            // Default Handlüfthebel:
            //aus MLFB-KAG
            Bestimme_Handlueftung(oData);		// O_K82_1FG1S				Handlüftung (nur bei Arbeitsbremse)
            //Bestimme_Handlueftung_Pos(oData);	// O_Q94_Q95_Q96_1FG1S		Positionierung des Handlüfthebels
        }else{
            if (ECSI_CX_MotorBrakeRequired == "1" && ECSI_IS_START_CONFIGURATION == 1){
                ECL_DeactivateValue("UI_HALTEBREMSE_1FG1S", "OHNE");
                ECL_ActivateValue(sTargetAttribute, "N23");
                ECL_SetValue(sTargetAttribute, "N23");
            }else{
                //EDIT Rückbau: ECL_DeactivateAllAttributeValues(sTargetAttribute);
                ECL_ActivateValue(sTargetAttribute, "OHNE");
                ECL_SetValue(sTargetAttribute, "OHNE");
            }	
            ECL_ActivateValue(sTargetAttributeARB, "NON");
            ECL_SetValue(sTargetAttributeARB, "NON");
            
            // Kein Handlüfthebel:
            ECL_ActivateValue("O_K82_1FG1S", "F");
            ECL_SetValue("O_K82_1FG1S", "F");
            ECL_ActivateValue("O_Q94_Q95_Q96_1FG1S", "OHNE");
            ECL_SetValue("O_Q94_Q95_Q96_1FG1S", "OHNE");
        }
    }
}
function checkBremse(oData, sTargetAttribute, sKAG)
{
    /* VT_1FG1S_M00211	TechDaten-Bremse
        MLFB10_11_1FG1S	MLFB13_1FG1S	UI_HALTEBREMSE_1FG1S	O_N30_BIS_N34_1006470	PMD_ABV478_001_000_1FG1S	
            PMD_ACE868_001_000_1006470	PMD_ACF397_001_000_1006470	PMD_ACJ797_001_000_1FG1S	PMD_ACE858_001_000_1FG1S	
            PMD_ACE859_001_000_1FG1S	PMD_ACF398_001_000_1FG1S
    */
    var MLFB10_11_1FG1S = oData.oParsingData.MOTOR_BG_10_11;
    var MLFB13_1FG1S = oData.oParsingData.MLFB.POS13;
    
    var sTable = "VT_1FG1S_M00211" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB10_11_1FG1S = '" + MLFB10_11_1FG1S + "' AND " +
                "MLFB13_1FG1S = '" + MLFB13_1FG1S + "' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

function Bestimme_Bremsmoment(oData)
{
    // ################################################################################################################
    // Bremsmoment		PMD_ACF397_001_000_1006470	
    // ################################################################################################################
    /*
    VT_1FG1S_M00211	TechDaten-Bremse
        MLFB10_11_1FG1S	MLFB13_1FG1S	UI_HALTEBREMSE_1FG1S	O_N30_BIS_N34_1006470	PMD_ABV478_001_000_1FG1S	
        PMD_ACE868_001_000_1006470	PMD_ACF397_001_000_1006470	PMD_ACJ797_001_000_1FG1S	PMD_ACE858_001_000_1FG1S	
        PMD_ACE859_001_000_1FG1S	PMD_ACF398_001_000_1FG1S
    */
    var sKAG = "";
    var MLFB10_11_1FG1S = oData.oParsingData.MOTOR_BG_10_11;
    var MLFB13_1FG1S = oData.oParsingData.MLFB.POS13;
    var UI_HALTEBREMSE_1FG1S = ECL_GetValue("UI_HALTEBREMSE_1FG1S");
    var O_N30_BIS_N34_1006470 = ECL_GetValue("O_N30_BIS_N34_1006470");
    
    if (UI_HALTEBREMSE_1FG1S != "ARB"){
        ECL_ActivateValue("PMD_ACF397_001_000_1006470", "0");
        ECL_SetValue("PMD_ACF397_001_000_1006470", "0");
    }else{
        var sTable = "VT_1FG1S_M00211" + sDB_Suffix;
        var sTargetAttribute = "PMD_ACF397_001_000_1006470";
        var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                    "MLFB10_11_1FG1S = '" + MLFB10_11_1FG1S + "' AND " +
                    "MLFB13_1FG1S = '" + MLFB13_1FG1S + "' AND " +
                    "UI_HALTEBREMSE_1FG1S = '" + UI_HALTEBREMSE_1FG1S + "' AND " +
                    "O_N30_BIS_N34_1006470 = '" + O_N30_BIS_N34_1006470 + "';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
        if (aResult.length > 0){
            var PMD_ACF397_001_000_1006470 = aResult[0].PMD_ACF397_001_000_1006470;
            ECL_ActivateValue("PMD_ACF397_001_000_1006470", PMD_ACF397_001_000_1006470);
            ECL_SetValue("PMD_ACF397_001_000_1006470", PMD_ACF397_001_000_1006470);
        }
    }
}


function Bestimme_Handlueftung(oData)
{
    // O_K82_1FG1S				Handlüftung (nur bei Arbeitsbremse)
    // KAG: K82, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_K82_1FG1S";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "K82"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    
    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1){	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkHandlueftung(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
        // Position Handlüfthebel bestimmen:
        Bestimme_Handlueftung_Pos(oData); //, true);
    }else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
        
        // Position Handlüfthebel = OHNE
        //Bestimme_Handlueftung_Pos(oData, false);
        ECL_ActivateValue("O_Q94_Q95_Q96_1FG1S", "OHNE");
        ECL_SetValue("O_Q94_Q95_Q96_1FG1S", "OHNE");
    }
}
function checkHandlueftung(oData, sTargetAttribute, sKAG)
{
    /* VT_1FG1S_M00160	MLFB10-Q91-To-Q96-K82
        O_Q91_Q92_Q93_1FG1S		O_Q94_Q95_Q96_1FG1S		MLFB10_1FG1S	O_K82_1FG1S		HMK_VALUE_VALID_1FG1S
    */
    
    var O_Q91_Q92_Q93_1FG1S = ECL_GetValue("O_Q91_Q92_Q93_1FG1S");
    var MLFB10_1FG1S = oData.oParsingData.MLFB.POS10;
    
    var sTable = "VT_1FG1S_M00160" +sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "O_Q91_Q92_Q93_1FG1S = '" + O_Q91_Q92_Q93_1FG1S + "' AND " +
                "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}


function Bestimme_Handlueftung_Pos(oData) //, bK82)
{
    // O_Q94_Q95_Q96_1FG1S		Positionierung des Handlüfthebels
    // KAG: Q94, G95, Q96, OHNE, STANDARD

    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_Q94_Q95_Q96_1FG1S";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    
    if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkHandlueftung_Pos(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
        
    }else{
        // Ohne oder STD	"Ohne" wird oben abgefertigt
        ECL_ActivateValue(sTargetAttribute, "STANDARD");
        ECL_SetValue(sTargetAttribute, "STANDARD");
    }
}
function checkHandlueftung_Pos(oData, sTargetAttribute, sKAG)
{
    /* VT_1FG1S_M00160	MLFB10-Q91-To-Q96-K82
        O_Q91_Q92_Q93_1FG1S		O_Q94_Q95_Q96_1FG1S		MLFB10_1FG1S	O_K82_1FG1S		HMK_VALUE_VALID_1FG1S
    */
    
    var O_Q91_Q92_Q93_1FG1S = ECL_GetValue("O_Q91_Q92_Q93_1FG1S");
    var MLFB10_1FG1S = oData.oParsingData.MLFB.POS10;
    
    var sTable = "VT_1FG1S_M00160" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "O_Q91_Q92_Q93_1FG1S = '" + O_Q91_Q92_Q93_1FG1S + "' AND " +
                "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
