//@legacy
//#mode(full-ecma)



//@import "VT_1FG1.js"


/*
Checkbox-Attribute setzen und lesen
*/

function getCheckBoxAttributes(strChangedAttribute)
{
    switch (strChangedAttribute){
        case "UI_O_G10_1FG1S":
            // O_G10_1FG1S	Drehmomentstütze Figur 2		G10, F
            setAttributeFromUICheckbox("O_G10_1FG1S", "UI_O_G10_1FG1S", "G10", "F");
        break;
        case "UI_O_G34_1FG1S":
            // O_G34_1FG1S	Ölschauglas		G34, F
            setAttributeFromUICheckbox("O_G34_1FG1S", "UI_O_G34_1FG1S", "G34", "F");
        break;
        case "UI_O_G53_1FG1S":
            // O_G53_1FG1S	Ölablassschraube magnetisch		G53, F
            setAttributeFromUICheckbox("O_G53_1FG1S", "UI_O_G53_1FG1S", "G53", "F");
        break;
        case "UI_O_G47_1FG1S":
            // O_G47_1FG1S	Ölausgleichsbehälter	G47, F
            setAttributeFromUICheckbox("O_G47_1FG1S", "UI_O_G47_1FG1S", "G47", "F");
        break;
        case "UI_O_G20_1FG1S":
            // O_G20_1FG1S	Radial verstärkte Abtriebswellenlagerung		G20, F
            setAttributeFromUICheckbox("O_G20_1FG1S", "UI_O_G20_1FG1S", "G20", "F");
        break;
        case "UI_O_B02_1FG1S":
            // O_B02_1FG1S	Prüfbescheinigung (für bestellten Motor)	B02, F
            setAttributeFromUICheckbox("O_B02_1FG1S", "UI_O_B02_1FG1S", "B02", "F");
        break;
        case "UI_O_K82_1FG1S":
            // O_K82_1FG1S	Handlüftung (nur bei Arbeitsbremse)		K82, F
            setAttributeFromUICheckbox("O_K82_1FG1S", "UI_O_K82_1FG1S", "K82", "F");
        break;
    /*	case "UI_O_Y84_1FG1S":
            // O_Y84_1FG1S	Kundenangabe auf dem Leistungsschild		Y84, F
            setAttributeFromUICheckbox("O_Y84_1FG1S", "UI_O_Y84_1FG1S", "Y84", "F");
        break;
    */	case "UI_O_N16_1FG1S":
            // O_N16_1FG1S	Ausführung für erhöhte chemische Beständigkeit	N16, F
            setAttributeFromUICheckbox("O_N16_1FG1S", "UI_O_N16_1FG1S", "N16", "F");
        break;
        case "UI_O_G99_1FG1S":
            // O_G99_1FG1S	Spielreduzierte Ausführung		G99, F
            setAttributeFromUICheckbox("O_G99_1FG1S", "UI_O_G99_1FG1S", "G99", "F");
        break;
        case "UI_O_G97_1FG1S":
            // O_G97_1FG1S	Geklebtes Endstufenrad		G97, F
            setAttributeFromUICheckbox("O_G97_1FG1S", "UI_O_G97_1FG1S", "G97", "F");
        break;
        case "UI_O_G60_1FG1S":
            // O_G60_1FG1S	Schutzhaube	Protective cover	G60, F
            setAttributeFromUICheckbox("O_G60_1FG1S", "UI_O_G60_1FG1S", "G60", "F");
        break;
        case "UI_O_W50_1FG1S":
            // O_W50_1FG1S	Motor Schnellieferservice - Fast lane		W50, F
            setAttributeFromUICheckbox("O_W50_1FG1S", "UI_O_W50_1FG1S", "W50", "F");
        break;
        
    }
}
function setCheckBoxAttributes()
{
    // O_G10_1FG1S	Drehmomentstütze Figur 2		G10, F
    setProductLogicToUIAttribute("O_G10_1FG1S", "UI_O_G10_1FG1S", "G10", "F");

    // O_G34_1FG1S	Ölschauglas		G34, F
    setProductLogicToUIAttribute("O_G34_1FG1S", "UI_O_G34_1FG1S", "G34", "F");

    // O_G53_1FG1S	Ölablassschraube magnetisch		G53, F
    setProductLogicToUIAttribute("O_G53_1FG1S", "UI_O_G53_1FG1S", "G53", "F");

    // O_G47_1FG1S	Ölausgleichsbehälter	G47, F
    setProductLogicToUIAttribute("O_G47_1FG1S", "UI_O_G47_1FG1S", "G47", "F");

    // O_G20_1FG1S	Radial verstärkte Abtriebswellenlagerung		G20, F
    setProductLogicToUIAttribute("O_G20_1FG1S", "UI_O_G20_1FG1S", "G20", "F");

    // O_B02_1FG1S	Prüfbescheinigung (für bestellten Motor)	B02, F
    setProductLogicToUIAttribute("O_B02_1FG1S", "UI_O_B02_1FG1S", "B02", "F");

    // O_K82_1FG1S	Handlüftung (nur bei Arbeitsbremse)		K82, F
    setProductLogicToUIAttribute("O_K82_1FG1S", "UI_O_K82_1FG1S", "K82", "F");

    // O_Y84_1FG1S	Kundenangabe auf dem Leistungsschild		Y84, F
//	setProductLogicToUIAttribute("O_Y84_1FG1S", "UI_O_Y84_1FG1S", "Y84", "F");

    // O_N16_1FG1S	Ausführung für erhöhte chemische Beständigkeit	N16, F
    setProductLogicToUIAttribute("O_N16_1FG1S", "UI_O_N16_1FG1S", "N16", "F");

    // O_G99_1FG1S	Spielreduzierte Ausführung		G99, F
    setProductLogicToUIAttribute("O_G99_1FG1S", "UI_O_G99_1FG1S", "G99", "F");

    // O_G97_1FG1S	Geklebtes Endstufenrad		G97, F
    setProductLogicToUIAttribute("O_G97_1FG1S", "UI_O_G97_1FG1S", "G97", "F");

    // O_G60_1FG1S	Schutzhaube	Protective cover	G60, F
    setProductLogicToUIAttribute("O_G60_1FG1S", "UI_O_G60_1FG1S", "G60", "F");

    // O_W50_1FG1S	Motor Schnellieferservice - Fast lane		W50, F
    setProductLogicToUIAttribute("O_W50_1FG1S", "UI_O_W50_1FG1S", "W50", "F");
}

/**
Funktion zur Übertragung des Logik-Auswahl-Zustandes eines Attributes (eingeschränkt durch Produktlogik) auf ein UI-Checkbox Attribut.

*/
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute)
{
    return setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";
    
    var aValidValues = ECL_GetAllActiveAttributeValues(sOrg_Attribute);
    var bValue_T_valid = false;
    var bValue_F_valid = false;
    
    if (aValidValues.length > 0){
        for (var i=0; i < aValidValues.length; i++){
            if (aValidValues[i] == sVal_True){
                bValue_T_valid = true;
            }
            if (aValidValues[i] == sVal_False){
                bValue_F_valid = true;
            }
        }
        
        if (bValue_T_valid && bValue_F_valid){
            ECL_EnableAttribute(sUI_Attribute);
            var sValue = ECL_GetValue(sOrg_Attribute);
            if (sValue == sVal_True){
                ECL_SelectValue(sUI_Attribute, "T");
            }else{
                ECL_DeselectAttribute(sUI_Attribute);
            }
        }
        else if (bValue_T_valid && !bValue_F_valid){
            ECL_SelectValue(sUI_Attribute, "T");
            ECL_DisableAttribute(sUI_Attribute);
        }
        else if (!bValue_T_valid && bValue_F_valid){
            ECL_DeselectAttribute(sUI_Attribute);
            ECL_DisableAttribute(sUI_Attribute);
        }
    }else{
        ECL_DeselectAttribute(sUI_Attribute);
        ECL_DisableAttribute(sUI_Attribute);
        return 0;
    }
    return 1;
}

/**
Funktion zur Übertragung des Auswahl-Zustandes eines UI-Checkbox-Attributes auf das Original-Attribut.
sOrg_Attribute:	original Produkt-Attrubut, welches durch die Produktlogik gesteuert wird
sUI_Attribute:	UI-Attribut mit Checkbox, auf welches die Logik gespiegelt wird
sValue_True:	Wert 'Ja' des Original-Attributes, wenn er von "T" abweicht		(optional)
sValue_False:	Wert 'Nein' des Original-Attributes, wenn er von "F" abweicht	(optional)
*/
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute)
{
    return setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";
    
    if (ECL_ValueSelected(sUI_Attribute, "T")){
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_True)) {
            ECL_SetValue(sOrg_Attribute, sVal_True);
            
        }else{
            
            if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
                ECL_SetValue(sOrg_Attribute, sVal_False);
            }
            
            ECL_DeselectAttribute(sUI_Attribute);
            ECL_DisableAttribute(sUI_Attribute);
            return 0;
        }
    }else{
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
            ECL_SetValue(sOrg_Attribute, sVal_False);
        }else{
            return 0;
        }
    }
    
    return 1;
}
