//@legacy
//#mode(full-ecma)




// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration

// ###################################################################################################################################
// Consequence-Attributes
// ###################################################################################################################################


// ECSI_CC_AdditionalInertia
// IpProtectionLevelMotor
// ECSI_CC_BrakeID
// GearboxOil			O_K06_K07_K08_K11_1FG1S
// OutputShaftLength
/*
Double [mm]		Length of the output shaft in mm
*/

// GearboxOutputShaftType		PMD_ABV414_001_000_1FG1S

// GearboxOutputShaftDiameter	Double [mm]	Diameter of the output shaft in mm 
//		Durchmesser			H_WELLEN_DURCHM_1FG1S

// GearboxMountingType		PMD_ABV672_001_000_1FG1S		Art der Befestigung
/*
F	Foot-mounted 			FU	Fußausführung
B	Foot/flange-mounted		FU_FL	Fuß/Flansch
P	Flange-mounted i2=l		FL	Flanschausführung (A-Typ)
Z	Housing flange 			ZENDE	Gehäuseflansch (C-Typ)
D	Mounted with torque support 	DRMST	Drehmomentstütze
 
*/

// GearboxReinforcedBearing
/*
0	Standard bearing of output shaft
1	Reinforced bearing of output shaft
2	XLPlus
3	VLPlus
*/

// SelectedGearboxAdapterID ????


function determineConsequences(sECSI_MLFB) {
    var normalizedMLFB = replace(sECSI_MLFB, '-Z', '');
    normalizedMLFB = replace(sECSI_MLFB, '-', '');
    var baseMLFB = left(normalizedMLFB, 16);
    var ka = right(normalizedMLFB, (normalizedMLFB.length > 16) ? normalizedMLFB.length - 16 : 0);
    var strErr = "";

    var aShaftParams = getOutputShaft();
    if (aShaftParams == "ERROR") {
        strErr = "ERR: ShaftParams";
    }
    /*
        [GearboxOutputShaftType, 
         GearboxOutputShaftDiameter,
         OutputShaftLength];
    */
    var oConsequences = {
        AdditionalInertia: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        //AllowedControlModes		: getAllowedControlModes,
        IpProtectionLevelMotor: "65",
        //	SensorModule				: getSensorModule(),
        GearboxOil: getGearboxOil(),
        OutputShaftLength: aShaftParams[2],
        GearboxOutputShaftType: aShaftParams[0],
        GearboxOutputShaftDiameter: aShaftParams[1],
        GearboxMountingType: getGearboxMountingType(),
        BrakeID: getBrakeID(sECSI_MLFB),
        GearboxReinforcedBearing: getGearboxReinforcedBearing(),
        Error_Message: strErr
    }

    return oConsequences;
}

// consequence = name in database table
// operator = max | min | sum

// pro consequence kann es mehrere Origins geben, deren Resultate mit dem Operator verknüpft werden müssen
// Innerhalb einer Origin soll immer nur eine Tabellenzeile verwendet werden, wobei die allgemeinste am Ende kommen muss (daher das DESC im order by)
function determineOneConsequence(baseMLFB, ka, consequence, operator) {
    var dRet = 0;
    if (operator == 'min')
        dRet = 99999;

    var aOrigins = Object.fromDatabase("1FG1_ADD_DATA", "select distinct ORIGIN from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' ") || [];

    for (var i = 0; i < aOrigins.length; i++) {
        var resval = determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, aOrigins[i].ORIGIN);
        if (resval != -99999) {
            if ((operator == 'min') && (resval < dRet))
                dRet = resval;
            else if ((operator == 'max') && (resval > dRet))
                dRet = resval;
            else if (operator == 'sum')
                dRet += resval;
        }
    }
    var strRet = '';
    if ((dRet != 0) && (dRet != 99999))
        strRet = '' + dRet;	// als String zurückliefern
    return strRet;
}

function determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, origin) {
    var aResult = Object.fromDatabase("1FG1_ADD_DATA", "select * from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' and ORIGIN = '" + origin + "' order by OPTION DESC");

    for (var i = 0; i < aResult.length; i++) {
        var mlfbPattern = aResult[i]['PATTERN'];
        var dbKAG = aResult[i]['OPTION'];
        var origin = aResult[i]['ORIGIN'];			// für jeden Origin nur max. einen Wert bestimmen
        var resval = aResult[i]['RES_VALUE'] - 0;	// Wert als Zahl bestimmen

        var matchP = true;
        if (mlfbPattern) {
            if (!EK_regFound(baseMLFB, mlfbPattern))
                matchP = false;
        }
        var matchK = true;
        if (dbKAG) {
            if (find(ka, dbKAG) < 0)
                matchK = false;
        }
        if (matchP && matchK) {
            return resval;
        }
    }
    return -99999;
}

function getAdditionalInertia(sECSI_MLFB) {
    // Keine Trägheitsmomente für Bremse oder Getriebe, da dies der SIZER selbst addiert!!!

    var AdditionalInertia = 0;
    return AdditionalInertia;
}


function getGearboxOil() {
    //	ECSI_CC_GearboxOil
    // GearboxOil
    /*
    1	CLP-ISO-VG220		K06
    2	CLP-ISO-PAO-VG220	
    3	CLP-ISO-PAO-VG68
    4	CLP-ISO-PAO-VG460
    5	CLP-ISO-PG-VG460	K08
    6	CLP-ISO-PG-VG220	K07
    7	CLP-ISO-H1-VG460	K11
    8	CLP-ISO-H1-VG100
    9	CLP-ISO-E-VG220
    
    O_K06_K07_K08_K11_1FG1S
    
    K06	Mineralöl CLP ISO VG220
    K07	Polyglycol Öl CLP ISO PG VG220
    K08	Polyglycol Öl CLP ISO PG VG460
    K11	Lebensmittelöl CLP ISO H1 VG460
    */
    //	ECSI_CC_GearboxOil

    var sOelSorte = ECL_GetValue("O_K06_K07_K08_K11_1FG1S");
    var ECSI_CC_GearboxOil = "";
    switch (sOelSorte) {
        case "K06":
            ECSI_CC_GearboxOil = "1";
            break;
        case "K07":
            ECSI_CC_GearboxOil = "6";
            break;
        case "K08":
            ECSI_CC_GearboxOil = "5";
            break;
        case "K11":
            ECSI_CC_GearboxOil = "7";
            break;
        default:
            ECSI_CC_GearboxOil = "";
    }
    return ECSI_CC_GearboxOil;
    //ECL_SetValue("ECSI_CC_GearboxOil", ECSI_CC_GearboxOil);
}
function getBrakeID(sECSI_MLFB) {
    /**
    
    //Bremsen Consequences
    */
    var sBrakeID = "";
    var UI_HALTEBREMSE_1FK7M = ECL_GetValue("UI_HALTEBREMSE_1FG1S"); // OHNE, ARB, N23, N24
    /*
    Mit Bremse: N23
    N24: Verstärkte Bremse
    Federkraftbremse: ARB
    */

    var sTable = "BRAKE_ID";
    // SZ_MBC_M_OrderNumber	SZ_MBC_M_ShortOptions	SZ_MBC_BrakeId	SZ_MBC_IsDefaultBrake

    // SZ_MBC_M_OrderNumber == 1FG1?????{C,D,E,F,G,S}?????? 
    // SZ_MBC_M_ShortOptions == N23, N24 oder N30...N34

    var MLFB10_1FG1S = sECSI_MLFB.charAt(9); // {C,D,E,F,G,S} 

    if (UI_HALTEBREMSE_1FK7M == "N23") {
        // 1FG1?????C??????  {C,D,E,F,G,S}

        var aValidValuesMLFB10 = ['C', 'D', 'E', 'F', 'G', 'S'];

        if (aValidValuesMLFB10.indexOf(MLFB10_1FG1S) < 0) {
            return "ERROR: Kein Treffer für BrakeID.";
        }

        var sBrakeID = "1FG1_" + MLFB10_1FG1S + "_N23";
    } else if (UI_HALTEBREMSE_1FK7M == "N24") {
        // 1FG1?????C??????  {C,D,E,F,G,S}

        var aValidValuesMLFB10 = ['C', 'D', 'E', 'F', 'G', 'S'];

        if (aValidValuesMLFB10.indexOf(MLFB10_1FG1S) < 0) {
            return "ERROR: Kein Treffer für BrakeID.";
        }

        var sBrakeID = "1FG1_" + MLFB10_1FG1S + "_N24";
    } else if (UI_HALTEBREMSE_1FK7M == "ARB") {
        // 1FG1?????F??????  {F,G}

        var aValidValuesMLFB10 = ['F', 'G'];

        if (aValidValuesMLFB10.indexOf(MLFB10_1FG1S) < 0) {
            return "ERROR: Kein Treffer für BrakeID.";
        }
        var O_N30_BIS_N34_1006470 = ECL_GetValue("O_N30_BIS_N34_1006470");
        if (O_N30_BIS_N34_1006470 != "NON") {

            var sBrakeID = "1FG1_" + MLFB10_1FG1S + "_" + O_N30_BIS_N34_1006470;
        } else {
            return "ERROR: Option Federkraftbremse nicht bestimmt. Kein Treffer für BrakeID.";
        }
    } else { // ohne
        sBrakeID = "";
    }

    return sBrakeID;
}

//	GearboxOutputShaftType
//	OutputShaftLength
//	GearboxOutputShaftDiameter
function getOutputShaft() {
    /*
    V	Solid output shaft. Shaft type: V & VG
    P	"Solid output shaft in combination with 
        mounting type flange (forward positioned bearing).
        Shaft type: V & VG"
    W	"Solid output shaft with two shaft ends.
        Shaft type: VD"
    H	"Hollow output shaft.
        Shaft type: H, HF, HS, HX & N"
    U	"Mixer hollow output shaft (bearing VLplus).
        Shaft type: HM"
    M	"Mixer solid output shaft (bearing VLplus).
        Shaft type: VM"
    R	"Agitator solid output shaft i2 ≠ l (bearing XLplus).
        Shaft type: VR  "
    C	"Cooling tower solid output shaft i2 ≠ l.
        Shaft type: VC"
    */

    // PMD_ABV414_001_000_1FG1S		Ausführung des Wellenendes
    /*
    VOLL_STD	Vollwelle Standard
    VOLL_STD2	Vollwelle Standard II
    VOLL_STD3	Vollwelle Standard III
    
    VOLL_OP	Vollwelle ohne Passfeder
    VOLL_BEIDS	Vollwelle Beidseitig
    VOLL_ZOLL	Vollwelle Zoll Standard
    
    HOHL_STD	Hohlwelle Standard
    HOHL_STD2	Hohlwelle Standard II
    HOHL_STD3	Hohlwelle Standard III
    
    HOHL_S_SCH	Hohlwelle S-Scheibe Standard I
    HOHL_S_SH2	Hohlwelle S-Scheibe Standard II
    HOHL_S_SH3	Hohlwelle S-Scheibe Standard III
    
    HOHL_ZOLL	Hohlwelle Zoll Standard
    HOHL_SIMO	Hohlwelle SimoLoc
    HOHL_SIM_Z	Hohlwelle SimoLoc Zoll
    
    VIELKEIL	Vielkeilhohlwelle Standard I
    
    PMD_ABV672_001_000_1FG1S
    SONDER	Sonderausführung
    /*	B	Foot/flange-mounted		FU_FL	Fuß/Flansch
        P	Flange-mounted i2=l		FL	Flanschausführung (A-Typ)
        case "FU_FL":
            var GearboxMountingType = "B";
        break;
        case "FL":
            var GearboxMountingType = "P";
        break;
    /*
        
    GearboxOutputShaftType		
    V	V, VG	
    P	V, VG	mit Flansch
    W	VD	doppelte Wellenende
    H	H, HF, HS, HX & N"	
    U	HM"	
    M	VM"	
    R	VR"	
    C	VC"	
    */

    var GearboxOutputShaftType = "";

    // H_WELLEN_DURCHM_1FG1S
    var H_WELLEN_DURCHM_1FG1S = ECL_GetValue("H_WELLEN_DURCHM_1FG1S");

    var sSQL = "SELECT * FROM CONSEQUENCES_SHAFT WHERE H_WELLEN_DURCHM_1FG1S = '" + H_WELLEN_DURCHM_1FG1S + "';";
    var aResult = Object.fromDatabase("1FG1_ADD_DATA", sSQL);

    if (aResult.length > 0) {
        var WELLEN_ID = aResult[0]['WELLEN_ID'];
        var DURCHMESSER = aResult[0]['DURCHMESSER'] || 0;
        var D_UMR_MM = aResult[0]['D_UMR_MM'] || 0;
        var MET_ZOLL = aResult[0]['MET_ZOLL'];
        var LAENGE = aResult[0]['LAENGE'] || 0;
        var L_UMR_MM = aResult[0]['L_UMR_MM'] || 0;
    } else {
        return "ERROR";
    }
    var PMD_ABV672_001_000_1FG1S = ECL_GetValue("PMD_ABV672_001_000_1FG1S");

    switch (WELLEN_ID) {
        case "V":
        case "VG":
            if (PMD_ABV672_001_000_1FG1S == "FU_FL" || PMD_ABV672_001_000_1FG1S == "FL") {
                GearboxOutputShaftType = "P";
            } else {
                GearboxOutputShaftType = "V";
            }
            break;

        case "VD":
        case "VDG":
            GearboxOutputShaftType = "W";
            break;

        case "H":
        case "HF":
        case "HS":
        case "HX":
        case "N":
            GearboxOutputShaftType = "H";
            break;

        case "HM":
            GearboxOutputShaftType = "U";
            break;

        case "VM":
            GearboxOutputShaftType = "M";
            break;

        case "VR":
            GearboxOutputShaftType = "R";
            break;

        case "VC":
            GearboxOutputShaftType = "C";
            break;

        default:
            return "ERROR";
    }
    if (MET_ZOLL == "Z") {
        DURCHMESSER = D_UMR_MM;
        //LAENGE = parseFloat(LAENGE) * 25.4 || 0;
        LAENGE = L_UMR_MM;
    }
    var GearboxOutputShaftDiameter = DURCHMESSER;
    var OutputShaftLength = LAENGE;

    var aConsequences = [GearboxOutputShaftType,
        GearboxOutputShaftDiameter,
        OutputShaftLength];

    return aConsequences;
}


function getGearboxMountingType() {
    // GearboxMountingType		PMD_ABV672_001_000_1FG1S		Art der Befestigung
    /*
    F	Foot-mounted 			FU	Fußausführung
    B	Foot/flange-mounted		FU_FL	Fuß/Flansch
    P	Flange-mounted i2=l		FL	Flanschausführung (A-Typ)
    Z	Housing flange 			ZENDE	Gehäuseflansch (C-Typ)
    D	Mounted with torque support 	DRMST	Drehmomentstütze	
    */
    var PMD_ABV672_001_000_1FG1S = ECL_GetValue("PMD_ABV672_001_000_1FG1S");

    switch (PMD_ABV672_001_000_1FG1S) {
        case "FU":
            var GearboxMountingType = "F";
            break;
        case "FU_FL":
            var GearboxMountingType = "B";
            break;
        case "FL":
            var GearboxMountingType = "P";
            break;
        case "ZENDE":
            var GearboxMountingType = "Z";
            break;
        case "DRMST":
            var GearboxMountingType = "D";
            break;
        default:
            var GearboxMountingType = "";
    }
    return GearboxMountingType;
}

function getGearboxReinforcedBearing() {
    // GearboxReinforcedBearing
    /*
    0	Standard bearing of output shaft
    1	Reinforced bearing of output shaft
    2	XLPlus
    3	VLPlus
    */
    var GearboxReinforcedBearing = "0";

    var O_G20_1FG1S = ECL_GetValue("O_G20_1FG1S");

    if (O_G20_1FG1S == "G20") {
        GearboxReinforcedBearing = "1";
    }
    return GearboxReinforcedBearing;

}