//@legacy
//#mode(full-ecma)



//@import "VT_1FG1.js"


/*
Checkroutinen ergänzt für Keep Konfiguration
*/

function SetEinbaulage_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Einbaulage(oData); 	 			// PMD_AAA566_001_000_1FG1S		Einbaulage
        Bestimme_Steckerposition(oData); 			// O_Q91_Q92_Q93_1FG1S			Steckerposition
        
        Bestimme_Schraegeinbaulage(oData);			// HMK_O_EXX_ACHSE_1FG1S		Schrägeinbaulagen
        
        Bestimme_AdapterflanschPos(oData); 			// O_R91_R92_R93				Position Adapterflansch
    } else {
        ExecSetStandardifValueEmpty("PMD_AAA566_001_000_1FG1S","D01");
        ExecSetStandardifValueEmpty("H_EINBAULAGE_KLASSE_1FG1S","");
        ExecSetStandardifValueEmpty("O_Q91_Q92_Q93_1FG1S","STANDARD");
        ExecSetStandardifValueEmpty("HMK_O_EXX_ACHSE_1FG1S","NON");
        ExecSetStandardifValueEmpty("HMK_O_EXX_WINKEL_1FG1S","NON");
        ExecSetStandardifValueEmpty("O_E01_BIS_E37_1FG1S", "NON");
        ExecSetStandardifValueEmpty("O_R91_R92_R93_1FG1S", "OHN");
        
    }
}

function SetEinbaulage(strchangedAttribute, oData)
{
}

/**
    
*/
function Bestimme_Einbaulage(oData)
{
    /* Vorgabe aus SIZER: ECSI_CX_MountingPosition
    
    KAG D01...D26
    
    Null	No value, if selected motor is a std. asynchron. Motor or a servo motor
    1		M1, Output side A (geared motors)
    2		M2, Output side A (geared motors)
    3		M3, Output side A (geared motors)
    4		M4, Output side A (geared motors)
    5		M5, Output side A (geared motors)
    6		M6, Output side A (geared motors)
    7		M1, Output side B (geared motors)
    8		M2, Output side B (geared motors)
    9		M3, Output side B (geared motors)
    10		M4, Output side B (geared motors)
    11		M5, Output side B (geared motors)
    12		M6, Output side B (geared motors)

    PMD_AAA566_001_000_1FG1S 
    D01...D26
    
    Einbaulage						Getriebeart
    PMD_AAA566_001_000_1FG1S		PMD_ABV517_001_000_1FG1S
    D01...D06 	==> M1...M6			Z0002, Z0006
    D11...D16	==> M1-A...M6-A		Z0003, STSCHG
    D21...D26	==> M1-B...M6-B		Z0003, STSCHG    
    */
    //var ECSI_IS_START_CONFIGURATION = parseInt(ECL_GetValue("ECSI_IS_START_CONFIGURATION"));
    //if (ECSI_IS_START_CONFIGURATION == 1){
        
        var ECSI_CX_MountingPosition = parseInt(ECL_GetValue("ECSI_CX_MountingPosition")) || 0;
        var PMD_ABV517_001_000_1FG1S = ECL_GetValue("PMD_ABV517_001_000_1FG1S");	// Getriebeart
        
        if (ECSI_CX_MountingPosition > 0 && ECSI_CX_MountingPosition < 13){
            
            if (ECSI_CX_MountingPosition == 1 || ECSI_CX_MountingPosition == 7){
                var H_EINBAULAGE_KLASSE_1FG1S = "M1";
            }else if (	ECSI_CX_MountingPosition == 2 || ECSI_CX_MountingPosition == 4 || 
                        ECSI_CX_MountingPosition == 8 || ECSI_CX_MountingPosition == 10){	
                // M2-A/B / M4-A/B
                var H_EINBAULAGE_KLASSE_1FG1S = "M2_4";
            }else if (	ECSI_CX_MountingPosition == 3 || ECSI_CX_MountingPosition == 5  || ECSI_CX_MountingPosition == 6 ||
                        ECSI_CX_MountingPosition == 9 || ECSI_CX_MountingPosition == 11 || ECSI_CX_MountingPosition == 12){	
                // M3-A/B / M5-A/B / M6-A/B
                var H_EINBAULAGE_KLASSE_1FG1S = "M3_5_6";
            }
            
            // Für Getriebeart Flachgetriebe oder Stirnradgetriebe Anbauseite fest (keine Unterscheidung A/B)
            var iEinbaulage = ECSI_CX_MountingPosition;
            if (PMD_ABV517_001_000_1FG1S == "Z0002" || PMD_ABV517_001_000_1FG1S == "Z0006"){
                var sOutputSide = "0"; // fest
            }else if (ECSI_CX_MountingPosition < 7){ // A
                var sOutputSide = "1";
            }else if (ECSI_CX_MountingPosition > 6){ // B
                var sOutputSide = "2";
                iEinbaulage = ECSI_CX_MountingPosition - 6;
            }
            
            var sEinbaulage = "D" + sOutputSide + iEinbaulage;
        }else{
            // Wert muss zwischen 1 und 12 liegen
            
            H_EINBAULAGE_KLASSE_1FG1S = "M1";
            if (PMD_ABV517_001_000_1FG1S == "Z0002" || PMD_ABV517_001_000_1FG1S == "Z0006"){
                sEinbaulage = "D01";
            } else if (PMD_ABV517_001_000_1FG1S == "Z0003" || PMD_ABV517_001_000_1FG1S == "STSCHG"){
                sEinbaulage = "D11";
            }
        }
        ECL_DeactivateAllAttributeValues("PMD_AAA566_001_000_1FG1S");
        ECL_ActivateValue("PMD_AAA566_001_000_1FG1S", sEinbaulage);
        ECL_SetValue("PMD_AAA566_001_000_1FG1S", sEinbaulage);
        
        ECL_SetValue("H_EINBAULAGE_KLASSE_1FG1S", H_EINBAULAGE_KLASSE_1FG1S);
    /*}else{
        // aus MLFB holen
        // PMD_AAA566_001_000_1FG1S	
        // KAG: D01...D06, D11...D16, D21...D26
        var parseObj = oData.oParsingData;
        
        var sTargetAttribute = "PMD_AAA566_001_000_1FG1S";
        var bCheck = false;
        
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
        
        if (sKAG != "NON"){
            // es gibt eine KAG, also prüfen, ob erlaubt
            bCheck = true; //checkHandlueftung(oData, sTargetAttribute, sKAG);
        }
        if (bCheck){
            // wenn erlaubt, setzen
            ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SetValue(sTargetAttribute, sKAG);
        }
    }
    */
    // ################################################################################################################
    // HMK_AAA566_KOMBI_1FG1S einschränken
    // ################################################################################################################
    /*
    VT_1FG1S_M00175
        HMK_AAA566_KOMBI_1FG1S	PMD_AAA566_001_000_1FG1S	HMK_VALUE_VALID_1FG1S

    */
    //var PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S");
    
    var sTable = "VT_1FG1S_M00175" + sDB_Suffix;
    var sTargetAttribute = "HMK_AAA566_KOMBI_1FG1S";
    var sWhere = 	"PMD_AAA566_001_000_1FG1S = '" + sEinbaulage + "' AND " +
                    "HMK_VALUE_VALID_1FG1S = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FG1___PARSER_EINBAULAGE_KOMBI_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    
    
}


/**
    Bremse sollte zuvor bewertet sein
*/
function Bestimme_Steckerposition(oData)
{
    
    // O_Q91_Q92_Q93_1FG1S
    // KAG: J4R, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_Q91_Q92_Q93_1FG1S";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    //var aKAG = parseObj.MLFB.KAG || [];
    
    if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkSteckerPosition(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkSteckerPosition(oData, sTargetAttribute, sKAG)
{
    /* VT_1FG1S_M00160	MLFB10-Q91-To-Q96-K82
        O_Q91_Q92_Q93_1FG1S	O_Q94_Q95_Q96_1FG1S		MLFB10_1FG1S	O_K82_1FG1S	HMK_VALUE_VALID_1FG1S
    
    Target: O_Q91_Q92_Q93_1FG1S
    */
    
    var MLFB10_1FG1S = oData.oParsingData.MLFB.POS10;
    var O_Q94_Q95_Q96_1FG1S = ECL_GetValue("O_Q94_Q95_Q96_1FG1S");
    var O_K82_1FG1S = ECL_GetValue("O_K82_1FG1S");
    
    var sTable = "VT_1FG1S_M00160" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
                "O_Q94_Q95_Q96_1FG1S = '" + O_Q94_Q95_Q96_1FG1S + "' AND " +
                "O_K82_1FG1S = '" + O_K82_1FG1S + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

function Bestimme_AdapterflanschPos(oData)
{
    
    // O_R91_R92_R93_1FG1S
    // KAG: R91, R92, R93, OHN
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_R91_R92_R93_1FG1S";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    //var aKAG = parseObj.MLFB.KAG || [];
    
    if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkAdapterflanschPos(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "OHN");
        ECL_SetValue(sTargetAttribute, "OHN");
    }
}
function checkAdapterflanschPos(oData, sTargetAttribute, sKAG)
{
    /* VT_1FG1S_M00205	MLFB10-Q91-To-Q96-K82
        O_R91_R92_R93_1FG1S		HMK_ADAPT_SCREW_TYPE_1FG1S		PMD_AAA566_001_000_1FG1S	O_E01_BIS_E37_1FG1S		PMD_ABV517_001_000_1FG1S	PMD_ABV417_001_000_1FG1S_X
    
    Target: O_R91_R92_R93_1FG1S
    */
    
    var PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S");
    var O_E01_BIS_E37_1FG1S = ECL_GetValue("O_E01_BIS_E37_1FG1S");
    var PMD_ABV517_001_000_1FG1S = ECL_GetValue("PMD_ABV517_001_000_1FG1S");
    
    var sTable = "VT_1FG1S_M00205" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "PMD_AAA566_001_000_1FG1S = '" + PMD_AAA566_001_000_1FG1S + "' AND " +
                "O_E01_BIS_E37_1FG1S = '" + O_E01_BIS_E37_1FG1S + "' AND " +
                "PMD_ABV517_001_000_1FG1S = '" + PMD_ABV517_001_000_1FG1S + "' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

/**
    
*/
function Bestimme_Schraegeinbaulage(oData)
{
    // O_E01_BIS_E37_1FG1S
    // KAG: E01, ... E37, NON
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_E01_BIS_E37_1FG1S";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    //var aKAG = parseObj.MLFB.KAG || [];
    
    if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkSchraegeinbaulage(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        sKAG = "NON";
        ECL_ActivateValue(sTargetAttribute, "NON");
        ECL_SetValue(sTargetAttribute, "NON");
    }
    
    /* VT_1FG1S_M00085	E01-bis-E37-Optionen
            HMK_O_EXX_ACHSE_1FG1S	HMK_O_EXX_WINKEL_1FG1S	O_E01_BIS_E37_1FG1S
    */
    var sTable = "VT_1FG1S_M00085" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT * FROM " + sTable + " WHERE " +
                "O_E01_BIS_E37_1FG1S = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0){
        var HMK_O_EXX_ACHSE_1FG1S = aResult[0].HMK_O_EXX_ACHSE_1FG1S;
        var HMK_O_EXX_WINKEL_1FG1S = aResult[0].HMK_O_EXX_WINKEL_1FG1S;
        
        ECL_ActivateValue("HMK_O_EXX_ACHSE_1FG1S", HMK_O_EXX_ACHSE_1FG1S);
        ECL_SetValue("HMK_O_EXX_ACHSE_1FG1S", HMK_O_EXX_ACHSE_1FG1S);
        
        ECL_ActivateValue("HMK_O_EXX_WINKEL_1FG1S", HMK_O_EXX_WINKEL_1FG1S);
        ECL_SetValue("HMK_O_EXX_WINKEL_1FG1S", HMK_O_EXX_WINKEL_1FG1S);
    }
    
    // ################################################################################################################
    // Option Schrägeinbaulagen-Kombi-Attribut		HMK_E01_E37_KOMBI_1FG1S	
    // ################################################################################################################
    /* VT_1FG1S_M00176
            HMK_E01_E37_KOMBI_1FG1S	O_E01_BIS_E37_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    //var O_E01_BIS_E37_1FG1S = ECL_GetValue("O_E01_BIS_E37_1FG1S");
    
    var sTable = "VT_1FG1S_M00176" + sDB_Suffix;
    var sTargetAttribute = "HMK_E01_E37_KOMBI_1FG1S";
    var sWhere = 	"O_E01_BIS_E37_1FG1S = '" + sKAG + "' AND " +
                    "HMK_VALUE_VALID_1FG1S = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FG1___PARSER_SCHRAEGEINBAULAGE_KAG_KOMBI_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    
    // ################################################################################################################
    
}
function checkSchraegeinbaulage(oData, sTargetAttribute, sKAG)
{
    // ################################################################################################################
    // Option Schrägeinbaulagen		O_E01_BIS_E37_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00085	E01-bis-E37-Optionen
nn		HMK_O_EXX_ACHSE_1FG1S	HMK_O_EXX_WINKEL_1FG1S	O_E01_BIS_E37_1FG1S
    VT_1FG1S_M00124	G34<>E01-E57 ==> Ölschauglas
nn		O_G34_1FG1S	O_E01_BIS_E37_1FG1S
    
NN	VT_1FG1S_M00159	Datenbl.Trigger Exx gestzt
        
    */
    // HMK_O_EXX_ACHSE_1FG1S bestimmen aus KAG
    var sTable = "VT_1FG1S_M00085" + sDB_Suffix;
    
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length > 0){
        var HMK_O_EXX_ACHSE_1FG1S = aResult[0].HMK_O_EXX_ACHSE_1FG1S;
    }else{
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S");
    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
    
    var sTable = "VT_1FG1S_M00100" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT HMK_O_EXX_ACHSE_1FG1S FROM " + sTable + " WHERE " +
                "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
                "HMK_O_EXX_ACHSE_1FG1S = '" + HMK_O_EXX_ACHSE_1FG1S + "' AND " +
                "PMD_AAA566_001_000_1FG1S = '" + PMD_AAA566_001_000_1FG1S + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}