//@legacy
//#mode(full-ecma)



//@import "VT_1FG1.js"



function SetGeber_Init(oData) {
    if (oData && !isEmpty(oData)) {
        Bestimme_Geberausfuehrung(oData); 	// UI_GEBER_1FG1S	Ausführung
        //Bestimme_Geberaufloesung(oData); 	//	UI_GEBER_AUFLOESUNG_1FG1S	Auflösung
        //Bestimme_Geber(oData);				// PMD_ABU278_001_000_1FG1S	Ermittelter Geber
    } else {
        ExecSetStandardifValueEmpty("UI_GEBER_1FG1S", "OHNEU");
        ExecSetStandardifValueEmpty("UI_GEBER_AUFLOESUNG_1FG1S", "00005");
        ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1FG1S", "Z0015");
    }
}

function SetGeber(strchangedAttribute, oData) {
}

/**
    Geber
    keine Einscränkungen aus MLFB09 oder Geberattribut 
    VT161 nur bei N16 Geber 'R', sonst keine Einschränkung
*/
function Bestimme_Geberausfuehrung(oData) {
    // MLFB09
    /*
    n.n. VT_1FG1S	Gewicht-Geber
    VT_1FG1S_M00180
        MLFB09_1FG1S	O_N16_1FG1S	PMD_ABU278_001_000_1FG1S	UI_GEBER_1FG1S	UI_GEBER_AUFLOESUNG_1FG1S	HMK_VALUE_VALID_1FG1S

    VT_1FG1S_M00161	N16-MLFB09-09-14	--> Option wird nachrangig behandelt
    */
    // Wenn Z, dann Kurzangabe (J4R)
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB09_1FG1S = oMLFB.POS9;

    if (MLFB09_1FG1S == "Z") {
        // O_J4R_1FG1S
        // KAG: J4R, F
        var parseObj = oData.oParsingData;

        var sTargetAttribute = "O_J4R_1FG1S";
        var bCheck = false;

        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = "J4R"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
        var aKAG = parseObj.MLFB.KAG || [];

        if (aKAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
            // es gibt eine KAG, also prüfen, ob erlaubt
            bCheck = checkGeber_J4R(oData, sTargetAttribute, sKAG);
        }
        if (bCheck) {
            // wenn erlaubt, setzen
            ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SetValue(sTargetAttribute, sKAG);

            var sStatus = Set_Geber(MLFB09_1FG1S);
            if (sStatus == 0) {
                // Fehler
            }
        }
        // wenn keine KAG oder nicht erlaubt, F setzen
        else {
            ECL_ActivateValue(sTargetAttribute, "F");
            ECL_SetValue(sTargetAttribute, "F");

            // Standard-Geber bestimmen
            MLFB09_1FG1S = "Q";
            var sStatus = Set_Geber(MLFB09_1FG1S);
            if (sStatus == 0) {
                // Fehler
            }
        }
    } else {
        var sStatus = Set_Geber(MLFB09_1FG1S);
        if (sStatus == 0) {
            // Standard-geber bestimmen
            var sStatus = Set_Geber("Q");
            if (sStatus == 0) {
                // Fehler
            }
        }
    }

}
function Set_Geber(MLFB09_1FG1S) {
    var sTable = "VT_1FG1S_M00180" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB09_1FG1S = '" + MLFB09_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0) {
        var UI_GEBER_1FG1S = aResult[0].UI_GEBER_1FG1S; 						// Ausführung
        var UI_GEBER_AUFLOESUNG_1FG1S = aResult[0].UI_GEBER_AUFLOESUNG_1FG1S; 	// Auflösung
        var PMD_ABU278_001_000_1FG1S = aResult[0].PMD_ABU278_001_000_1FG1S; 	// ermittelter Geber

        ECL_DeactivateAllAttributeValues("PMD_ABU278_001_000_1FG1S");

        ECL_ActivateValue("UI_GEBER_1FG1S", UI_GEBER_1FG1S);
        ECL_SetValue("UI_GEBER_1FG1S", UI_GEBER_1FG1S);

        ECL_ActivateValue("UI_GEBER_AUFLOESUNG_1FG1S", UI_GEBER_AUFLOESUNG_1FG1S);
        ECL_SetValue("UI_GEBER_AUFLOESUNG_1FG1S", UI_GEBER_AUFLOESUNG_1FG1S);

        ECL_ActivateValue("PMD_ABU278_001_000_1FG1S", PMD_ABU278_001_000_1FG1S);
        ECL_SetValue("PMD_ABU278_001_000_1FG1S", PMD_ABU278_001_000_1FG1S);
    } else {
        return 0;
    }
    return 1;
}
function checkGeber_J4R(oData, sTargetAttribute, sKAG) {
    // VT_1FG1S_M00171
    // 	MLFB09_1FG1S	O_J4R_1FG1S	HMK_VALUE_VALID_1FG1S
    var MLFB09_1FG1S = oData.oParsingData.MLFB.POS9;

    var sTable = "VT_1FG1S_M00171" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB09_1FG1S = '" + MLFB09_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}