//@legacy
//#mode(full-ecma)



//@import "VT_1FG1.js"


/*
Motordaten werden vom SIZER in der MLFB übergeben, werden immer 1:1 übernommen
*/

function SetMotor_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Baugroesse(oData); 	 	// PMD_ABP663_001_000_1FG1S Achshöhe			MLFB10 +  TAK_ABU212_001_000_1FG1S	Baulänge	MLFB11
        //Bestimme_Baulaenge(oData); 		// TAK_ABU212_001_000_1FG1S	Baulänge			MLFB11
        Bestimme_Motortyp(oData);			// PMD_AAA259_001_000_1FG1S	Motortyp			MLFB13
        Bestimme_Drehzahl(oData);			// PMD_AAE020_001_000_1FG1S Synchrondrehzahl	MLFB12
    } else {
        
        ExecSetStandardifValueEmpty("PMD_ABP663_001_000_1FG1S","36");
        ExecSetStandardifValueEmpty("TAK_ABU212_001_000_1FG1S","1");
        ExecSetStandardifValueEmpty("PMD_AAA259_001_000_1FG1S","Z0001");
        ExecSetStandardifValueEmpty("PMD_AAE020_001_000_1FG1S","3000");
    }
}

function SetMotor(strchangedAttribute, oData)
{
}

/**
    Achshöhe		PMD_ABP663_001_000_1FG1S 
    VT_1FG1S_M00012	MLFB: MLFB10_11<>Baugröße
        MLFB10_1FG1S	MLFB11_1FG1S	MLFB10_11_1FG1S	PMD_ABP663_001_000_1FG1S	TAK_ABU212_001_000_1FG1S	HMK_VALUE_VALID_1FG1S
*/
function Bestimme_Baugroesse(oData)
{
    var MLFB10_11_1FG1S = oData.oParsingData.MOTOR_BG_10_11;
    
    var sTable = "VT_1FG1S_M00012" + sDB_Suffix;
    var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                "MLFB10_11_1FG1S = '" + MLFB10_11_1FG1S + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE");
    if (aResult.length > 0)
    {
        var PMD_ABP663_001_000_1FG1S = "" + aResult[0].PMD_ABP663_001_000_1FG1S; // Achshöhe
        var TAK_ABU212_001_000_1FG1S = "" + aResult[0].TAK_ABU212_001_000_1FG1S; // Baulänge
        
        //ECL_DeactivateAllAttributeValues("PMD_ABP663_001_000_1FG1S");
        ECL_ActivateValue("PMD_ABP663_001_000_1FG1S", PMD_ABP663_001_000_1FG1S);
        ECL_SetValue("PMD_ABP663_001_000_1FG1S", PMD_ABP663_001_000_1FG1S);
        
        //ECL_DeactivateAllAttributeValues("TAK_ABU212_001_000_1FG1S");
        ECL_ActivateValue("TAK_ABU212_001_000_1FG1S", TAK_ABU212_001_000_1FG1S);
        ECL_SetValue("TAK_ABU212_001_000_1FG1S", TAK_ABU212_001_000_1FG1S);
    }
}

/**
    PMD_AAA259_001_000_1FG1S	Motortyp	MLFB13
    VT_1FG1S_M00015
    MLFB13_1FG1S	PMD_AAA259_001_000_1FG1S	PMD_ABJ558_001_000_1FG1S	HMK_VALUE_VALID_1FG1S

*/
function Bestimme_Motortyp(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB13_1FG1S = oMLFB.POS13;
    
    var sTable = "VT_1FG1S_M00015" + sDB_Suffix;
    var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                "MLFB13_1FG1S = '" + MLFB13_1FG1S + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAA259_001_000_1FG1S = aResult[0].PMD_AAA259_001_000_1FG1S; // Motortyp
        
        ECL_DeactivateAllAttributeValues("PMD_AAA259_001_000_1FG1S");
        ECL_ActivateValue("PMD_AAA259_001_000_1FG1S", PMD_AAA259_001_000_1FG1S);
        ECL_SetValue("PMD_AAA259_001_000_1FG1S", PMD_AAA259_001_000_1FG1S);
        
    }
}

/**
    PMD_AAE020_001_000_1FG1S Synchrondrehzahl	MLFB12
    
    VT_1FG1S_M00013
    MLFB12_1FG1S	PMD_AAE020_001_000_1FG1S	HMK_VALUE_VALID_1FG1S
    
    VT_1FG1S_M00146	M: Rümpfe		Prüfen, bei setzen im Parser, falls '.'
        MLFB10_11_1FG1S	MLFB12_1FG1S	MLFB13_1FG1S	M_RUMPF_TYP_1FG1S	M_RUMPF_1FG1S	PMD_ABV400_001_000_1FG1S	HMK_VALUE_VALID_1FG1S

*/
function Bestimme_Drehzahl(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB12_1FG1S = oMLFB.POS12;
    
    var sTable = "VT_1FG1S_M00013" + sDB_Suffix;
    var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                "MLFB12_1FG1S = '" + MLFB12_1FG1S + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAE020_001_000_1FG1S = aResult[0].PMD_AAE020_001_000_1FG1S; // Motortyp
        
        ECL_DeactivateAllAttributeValues("PMD_AAE020_001_000_1FG1S");
        ECL_ActivateValue("PMD_AAE020_001_000_1FG1S", PMD_AAE020_001_000_1FG1S);
        ECL_SetValue("PMD_AAE020_001_000_1FG1S", PMD_AAE020_001_000_1FG1S);
        
    }
}