//@legacy
//#mode(full-ecma)

//@import "../1FG1_MLFB/Base.misc.js"

//@import "VT_1FG1.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute) {
    var strError = "";

    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var sMLFB1_4 = sMLFB.left(4);
    var MLFB01_1FG1S = sMLFB.left(4);

    var MLFB05_1FG1S = sMLFB.charAt(4);
    var MLFB06_1FG1S = sMLFB.charAt(5); //Getriebe Stufen
    var MLFB07_1FG1S = sMLFB.charAt(6); //Getriebe	BG1
    var MLFB08_1FG1S = sMLFB.charAt(7); //Getriebe	BG2
    var MLFB09_1FG1S = sMLFB.charAt(8);
    var MLFB10_1FG1S = sMLFB.charAt(9);
    var MLFB11_1FG1S = sMLFB.charAt(10);
    var MLFB12_1FG1S = sMLFB.charAt(11);
    var MLFB13_1FG1S = sMLFB.charAt(12);
    var MLFB14_1FG1S = sMLFB.charAt(13);
    var MLFB15_1FG1S = sMLFB.charAt(14);
    var MLFB16_1FG1S = sMLFB.charAt(15);
    var MLFB_05_06_07_1FG1S = sMLFB.charAt(4) + sMLFB.charAt(5) + sMLFB.charAt(6); //Getriebe
    var MLFB10_11_1FG1S = sMLFB.charAt(9) + sMLFB.charAt(10); //Baugröße/Baulänge

    //var M_RUMPF_TYP_1FG1S 		= ECL_GetValue("M_RUMPF_TYP_1FG1S");	// definiert über 
    //var M_RUMPF_1FG1S 			= ECL_GetValue("M_RUMPF_1FG1S");	// definiert über 
    //var H_KEY_GETRIEBE_1FG1S 	= ECL_GetValue("H_KEY_GETRIEBE_1FG1S");


    var H_FLANSCH_DURCHM_1FG1S_old = ECL_GetValue("H_FLANSCH_DURCHM_1FG1S");

    // ################################################################################################################
    //Bestimme Rümpfe:
    // ################################################################################################################
    /*
    VT_1FG1S_M00146	M: Rümpfe
        MLFB10_11_1FG1S	MLFB12_1FG1S	MLFB13_1FG1S	M_RUMPF_TYP_1FG1S	M_RUMPF_1FG1S	PMD_ABV400_001_000_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    var sTable = "VT_1FG1S_M00146" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "MLFB10_11_1FG1S = '" + MLFB10_11_1FG1S + "' AND " +
        "MLFB12_1FG1S = '" + MLFB12_1FG1S + "' AND " +
        "MLFB13_1FG1S = '" + MLFB13_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var aResult = GetDBDataSetEXT(sSQL, sTable);

    if (aResult.length > 0) {
        var M_RUMPF_TYP_1FG1S = aResult[0].M_RUMPF_TYP_1FG1S;
        var M_RUMPF_1FG1S = aResult[0].M_RUMPF_1FG1S;

        ECL_SetValue("M_RUMPF_TYP_1FG1S", M_RUMPF_TYP_1FG1S);
        ECL_SetValue("M_RUMPF_1FG1S", M_RUMPF_1FG1S);

    } else {
        strError = "DICT1_ERR_1FG1___PLVT_BESTIMMUNG_RUEMPFE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // MLFB-Logik
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /* VT_1FG1S_M00168	Wellenverriegelung
        MLFB_05_06_07_1FG1S	MLFB08_1FG1S	MLFB10_1FG1S	MLFB14_1FG1S	O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S

    */
    var sTable = "VT_1FG1S_M00168" + sDB_Suffix;
    var sTargetAttribute = "MLFB14_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        //"MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_BEFESTIGUNGSART_MLFB14_NO_DB_RESULT";
        return strError;
    }
    var testDMST = ECL_GetAllActiveAttributeValues("MLFB14_1FG1S");
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /* VT_1FG1S_M00077	Getriebe-Welle-Befestigung
        PMD_ABV410_001_000_1FG1S	MLFB08_1FG1S	MLFB14_1FG1S
    */
    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");

    var sTable = "VT_1FG1S_M00077" + sDB_Suffix;
    var sTargetAttribute = "MLFB14_1FG1S";
    var sWhere = "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "';"; // AND " +
    //"MLFB08_1FG1S = '" + MLFB08_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_BEFESTIGUNGSART_MLFB14_NO_DB_RESULT";
        return strError;
    }
    var testDMST = ECL_GetAllActiveAttributeValues("MLFB14_1FG1S");
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Übernahme MLFB-Einschränkung
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABV672_001_000_1FG1S", "MLFB14_1FG1S", "VT_1FG1S_M00011" + sDB_Suffix);
    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_BEFESTIGUNGSART_MLFB14_NO_DB_RESULT";
        return strError;
    }
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    var testDMST = ECL_GetAllActiveAttributeValues("PMD_ABV672_001_000_1FG1S");
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    var PMD_ABV517_001_000_1FG1S = ECL_GetValue("PMD_ABV517_001_000_1FG1S");	// 
    // A: VT_1FG1S_M00048	ZO Getriebeart > Befestigung
    //	PMD_ABV517_001_000_1FG1S	PMD_ABV672_001_000_1FG1S	HMK_VALUE_VALID_1FG1S

    var sTable = "VT_1FG1S_M00048" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABV672_001_000_1FG1S";
    var sWhere = "PMD_ABV517_001_000_1FG1S = '" + PMD_ABV517_001_000_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_BEFESTIGUNGSART_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    var testDMST = ECL_GetAllActiveAttributeValues("PMD_ABV672_001_000_1FG1S");
    //--------------------------------------------------------------------------------------------------------------
    //Setze MLFB
    /*
    MLFB14 nur in verbindung mit VT77 und Getriebetyp eindeutig!
    */
    //if (strchangedAttribute == "PMD_ABV672_001_000_1FG1S"){
    var PMD_ABV672_001_000_1FG1S = ECL_GetValue("PMD_ABV672_001_000_1FG1S");	// Befestigungsart
    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");	// Getriebebezeichnung
    // B: 	VT_1FG1S_M00011	MLFB <> Befestigung								Übersetzung Attribut<->MLFB
    //	MLFB14_1FG1S	PMD_ABV672_001_000_1FG1S	HMK_VALUE_VALID_1FG1S
    if (PMD_ABV672_001_000_1FG1S == "DRMST") {
        // VT_1FG1S_M00077
        //	PMD_ABV410_001_000_1FG1S	MLFB08_1FG1S	MLFB14_1FG1S
        var sTable = "VT_1FG1S_M00077" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT MLFB14_1FG1S FROM " + sTable + " WHERE " +
            "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
            "(MLFB14_1FG1S = 'C' OR MLFB14_1FG1S = 'D')"; // AND " +
        //"MLFB08_1FG1S = '" + MLFB08_1FG1S + "';";

        var aResult = GetDBDataSetEXT(sSQL, sTable);

        if (aResult.length > 0) {
            MLFB14_1FG1S = aResult[0].MLFB14_1FG1S;

            sMLFB = replaceAt(sMLFB, 13, MLFB14_1FG1S);
            ECL_SetValue("ECSI_MLFB", sMLFB);
        } else {
            strError = "DICT1_ERR_1FG1___PLVT_SET_MLFB14_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
    }
    else {
        var sTable = "VT_1FG1S_M00011" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "PMD_ABV672_001_000_1FG1S = '" + PMD_ABV672_001_000_1FG1S + "' AND " +
            "HMK_VALUE_VALID_1FG1S = 'T';";

        var aResult = GetDBDataSetEXT(sSQL, sTable);

        if (aResult.length > 0) {
            MLFB14_1FG1S = aResult[0].MLFB14_1FG1S;

            sMLFB = replaceAt(sMLFB, 13, MLFB14_1FG1S);
            ECL_SetValue("ECSI_MLFB", sMLFB);
        } else {
            strError = "DICT1_ERR_1FG1___PLVT_SET_MLFB14_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
    }
    // ################################################################################################################
    // ACHTUNG ==> Bei Drehmomentstütze muss MLFB08 neu bestimmt werden, da Vollwelle nicht mehr zulässig!


    // ################################################################################################################
    // H_FLANSCH_DURCHM_1FG1S				H_FLANSCH_DURCHM_1FG1S
    // ################################################################################################################
    /*
    H_FLANSCH_DURCHM_1FG1S ist das logik-steuer-Merkmal
    
    B: VT_1FG1S_M00039	O: Flansch-DM (H01-H20)
        PMD_ABV410_001_000_1FG1S	H_FLANSCH_DURCHM_1FG1S	O_H01_BIS_H20_1FG1S	HMK_VALUE_VALID_1FG1S

    A: VT_1FG1S_M00059	ZO Befestigung - Flansch Durchmesser
        UI_FLANSCH_DURCHM_1FG1S	H_FLANSCH_DURCHM_1FG1S	PMD_ABV672_001_000_1FG1S
        
NN	VT_1FG1S_M00072	Gewicht-Getriebe
        PMD_ABV410_001_000_1FG1S	PMD_ABV417_001_000_1FG1S_X	PMD_ABV414_001_000_1FG1S	PMD_ABV672_001_000_1FG1S	
            HMK_EGBEZWNV_1FG1S	PMD_ABW207_001_000_1FG1S	H_FLANSCH_DURCHM_1FG1S
    */
    var sTargetAttribute = "H_FLANSCH_DURCHM_1FG1S";

    var PMD_ABV672_001_000_1FG1S = ECL_GetValue("PMD_ABV672_001_000_1FG1S");	// 

    // A: VT_1FG1S_M00059	ZO Befestigung - Flansch Durchmesser
    //	UI_FLANSCH_DURCHM_1FG1S	H_FLANSCH_DURCHM_1FG1S	PMD_ABV672_001_000_1FG1S
    var sTable = "VT_1FG1S_M00059" + sDB_Suffix;

    var sWhere = "PMD_ABV672_001_000_1FG1S = '" + PMD_ABV672_001_000_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_GETRIEBE_HMK_FLANSCH_D_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");	// 

    var sWhere250 = "";
    if (PMD_ABV410_001_000_1FG1S == "_B49") {
        sWhere250 = "H_FLANSCH_DURCHM_1FG1S <> '250' AND ";
    }
    // B:VT_1FG1S_M00039	O: Flansch-DM (H01-H20)
    //	PMD_ABV410_001_000_1FG1S	H_FLANSCH_DURCHM_1FG1S	O_H01_BIS_H20_1FG1S	HMK_VALUE_VALID_1FG1S
    var sTable = "VT_1FG1S_M00039" + sDB_Suffix;
    var sWhere = "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
        sWhere250 +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_GETRIEBE_HMK_FLANSCH_D_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Setze H_FLANSCH_DURCHM_1FG1S
    // ################################################################################################################
    //var aTest = ECL_GetAllActiveAttributeValues("H_FLANSCH_DURCHM_1FG1S");
    //var aTest = ECL_GetAllActiveAttributeValues("UI_FLANSCH_DURCHM_1FG1S");


    // ################################################################################################################
    // Getriebe-Flansch-Durchmesser		UI_FLANSCH_DURCHM_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00059	ZO Befestigung - Flansch Durchmesser
        UI_FLANSCH_DURCHM_1FG1S	H_FLANSCH_DURCHM_1FG1S	PMD_ABV672_001_000_1FG1S

    */
    // Einschränkungen aus H_FLANSCH_DURCHM_1FG1S auf UI-Merkmale übertragen
    var aValidVals_FlanschD = ECL_GetAllActiveAttributeValues("H_FLANSCH_DURCHM_1FG1S");
    ECL_DeactivateAllAttributeValues("UI_FLANSCH_DURCHM_1FG1S");
    for (var i = 0; i < aValidVals_FlanschD.length; i++) {
        var sValue = aValidVals_FlanschD[i];
        if (sValue == "0") {
            sValue = "OHNE";
        }
        ECL_ActivateValue("UI_FLANSCH_DURCHM_1FG1S", sValue);
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Setze UI_FLANSCH_DURCHM_1FG1S
    var H_FLANSCH_DURCHM_1FG1S = "" + ECL_GetValue("H_FLANSCH_DURCHM_1FG1S");

    if (H_FLANSCH_DURCHM_1FG1S_old != H_FLANSCH_DURCHM_1FG1S) {
        var UI_FLANSCH_DURCHM_1FG1S = ECL_GetValue("UI_FLANSCH_DURCHM_1FG1S");
        var H_FLANSCH_DURCHM_1FG1S = "" + ECL_GetValue("H_FLANSCH_DURCHM_1FG1S");

        if (H_FLANSCH_DURCHM_1FG1S != UI_FLANSCH_DURCHM_1FG1S) {
            if (H_FLANSCH_DURCHM_1FG1S == "0") {
                UI_FLANSCH_DURCHM_1FG1S = "OHNE";
            }
            else {
                UI_FLANSCH_DURCHM_1FG1S = H_FLANSCH_DURCHM_1FG1S;
            }
            ECL_SetValue("UI_FLANSCH_DURCHM_1FG1S", UI_FLANSCH_DURCHM_1FG1S);


            /*	var sTable = "VT_1FG1S_M00059" + sDB_Suffix;
                var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                            "H_FLANSCH_DURCHM_1FG1S = '" + H_FLANSCH_DURCHM_1FG1S + "' AND " +
                            "PMD_ABV672_001_000_1FG1S = '" + PMD_ABV672_001_000_1FG1S + "';";
                
                var aResult = GetDBDataSetEXT(sSQL, sTable );
                
                if (aResult.length > 0){
                    var H_FLANSCH_DURCHM_1FG1S = aResult[0].H_FLANSCH_DURCHM_1FG1S;
                    ECL_SetValue("H_FLANSCH_DURCHM_1FG1S", H_FLANSCH_DURCHM_1FG1S);
                }else{
                    strError = "DICT1_ERR_1FG1___PLVT_SET_HMK_FLANSCH_D_LOGIKFEHLER_NO_DB_RESULT";
                    return strError;
                }
            */
        }
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Setze H_FLANSCH_DURCHM_1FG1S
    if (strchangedAttribute == "UI_FLANSCH_DURCHM_1FG1S") {
        var UI_FLANSCH_DURCHM_1FG1S = ECL_GetValue("UI_FLANSCH_DURCHM_1FG1S");

        var sTable = "VT_1FG1S_M00059" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "UI_FLANSCH_DURCHM_1FG1S = '" + UI_FLANSCH_DURCHM_1FG1S + "' AND " +
            "PMD_ABV672_001_000_1FG1S = '" + PMD_ABV672_001_000_1FG1S + "';";

        var aResult = GetDBDataSetEXT(sSQL, sTable);

        if (aResult.length > 0) {
            var H_FLANSCH_DURCHM_1FG1S = aResult[0].H_FLANSCH_DURCHM_1FG1S;
            ECL_SetValue("H_FLANSCH_DURCHM_1FG1S", H_FLANSCH_DURCHM_1FG1S);
        } else {
            strError = "DICT1_ERR_1FG1___PLVT_SET_HMK_FLANSCH_D_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
    }
    // ################################################################################################################

    //var aTest = ECL_GetAllActiveAttributeValues("H_FLANSCH_DURCHM_1FG1S");
    //var aTest = ECL_GetAllActiveAttributeValues("UI_FLANSCH_DURCHM_1FG1S");

    //var sStopper = "";
    // ################################################################################################################
    // Option Getriebe-Flansch-Durchmesser				O_H01_BIS_H20_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00039	O: Flansch-DM (H01-H20)
        PMD_ABV410_001_000_1FG1S	H_FLANSCH_DURCHM_1FG1S	O_H01_BIS_H20_1FG1S	HMK_VALUE_VALID_1FG1S

    VT_1FG1S_M00086	H0X-Getriebe-Befestigung
        MLFB_05_06_07_1FG1S	MLFB14_1FG1S	O_H01_BIS_H20_1FG1S

    */
    // Setze O_H01_BIS_H20_1FG1S
    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");
    var H_FLANSCH_DURCHM_1FG1S = parseFloat(ECL_GetValue("H_FLANSCH_DURCHM_1FG1S"));

    var sTable = "VT_1FG1S_M00039" + sDB_Suffix;
    var sSQL = "SELECT O_H01_BIS_H20_1FG1S FROM " + sTable + " WHERE " +
        "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
        "H_FLANSCH_DURCHM_1FG1S = " + H_FLANSCH_DURCHM_1FG1S + " AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var aResult = GetDBDataSetEXT(sSQL, sTable);

    if (aResult.length > 0) {
        var O_H01_BIS_H20_1FG1S = aResult[0].O_H01_BIS_H20_1FG1S;
        ECL_SetValue("O_H01_BIS_H20_1FG1S", O_H01_BIS_H20_1FG1S);
    } else {
        strError = "DICT1_ERR_1FG1___PLVT_SET_KAG_FLANSCH_D_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################

    // ################################################################################################################
    // Ausführung des Wellenendes				PMD_ABV414_001_000_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00040	MLFB: Wellenausführung
        MLFB08_1FG1S	PMD_ABV414_001_000_1FG1S	PMD_ABV410_001_000_1FG1S	H_WELLEN_DURCHM_1FG1S	O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S

NN	VT_1FG1S_M00062	ZO Getriebe-Einbaulage - Bild
    UI_EINBAULAGE_BILD_1FG1S	PMD_AAA566_001_000_1FG1S	PMD_ABV410_001_000_1FG1S	PMD_ABV672_001_000_1FG1S	PMD_ABV414_001_000_1FG1S

NN	VT_1FG1S_M00072	Gewicht-Getriebe
        PMD_ABV410_001_000_1FG1S	PMD_ABV417_001_000_1FG1S_X	PMD_ABV414_001_000_1FG1S	PMD_ABV672_001_000_1FG1S	HMK_EGBEZWNV_1FG1S	PMD_ABW207_001_000_1FG1S	H_FLANSCH_DURCHM_1FG1S

NN?	VT_1FG1S_M00090	Auswahl WNV-Merkmal			Übersetzung
        PMD_ABV414_001_000_1FG1S	HMK_EGBEZWNV_1FG1S

NN	VT_1FG1S_M00092	CAD-Wellenart
        PMD_ABV414_001_000_1FG1S	CAD_EGBEZAWTYP_1FG1S

    VT_1FG1S_M00130	Getr+Welle+Befest
        HMK_EGGEHKERN_1FG1S	PMD_ABV410_001_000_1FG1S	PMD_ABV414_001_000_1FG1S	PMD_ABV672_001_000_1FG1S
    
    VT_1FG1S_M00238	WellenTyp_G60
        PMD_ABV414_001_000_1FG1S    O_G60_1FG1S

    VT_1FG1S_M00245	Rumpf567_Wellenausf_Durchm_G23/G24
        MLFB_05_06_07_1FG1S PMD_ABV414_001_000_1FG1S    H_WELLEN_DURCHM_1FG1S   O_G23_G24_1FG1S

    
    MLFB08_1FG1S:
        VT_1FG1S_M00040	MLFB: Wellenausführung
        VT_1FG1S_M00077	Getriebe-Welle-Befestigung
            PMD_ABV410_001_000_1FG1S	MLFB08_1FG1S	MLFB14_1FG1S

        VT_1FG1S_M00084	G20-Getriebe-Befest.-Welle
        VT_1FG1S_M00231	G60-Getriebe-Welle
        VT_1FG1S_M00161	N16-MLFB09-09-14
        VT_1FG1S_M00168	Wellenverriegelung

    */
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // MLFB-Logik
    /* VT_1FG1S_M00168	Wellenverriegelung
        MLFB_05_06_07_1FG1S	MLFB08_1FG1S	MLFB10_1FG1S	MLFB14_1FG1S	O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S

    */
    var sTable = "VT_1FG1S_M00168" + sDB_Suffix;
    var sTargetAttribute = "MLFB08_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_WELLENENDE_MLFB08_NO_DB_RESULT";
        return strError;
    }
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");

    var sTable = "VT_1FG1S_M00077" + sDB_Suffix;
    var sTargetAttribute = "MLFB08_1FG1S";
    var sWhere = "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_WELLENENDE_MLFB08_NO_DB_RESULT";
        return strError;
    }

    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Übernahme MLFB-Einschränkung
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABV414_001_000_1FG1S", "MLFB08_1FG1S", "VT_1FG1S_M00040" + sDB_Suffix);
    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_WELLENENDE_MLFB08_NO_DB_RESULT";
        return strError;
    }

    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // O_H1G_BIS_H7A_1FG1S-Logik
    /* VT_1FG1S_M00168	Wellenverriegelung
        MLFB_05_06_07_1FG1S	MLFB08_1FG1S	MLFB10_1FG1S	MLFB14_1FG1S	O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S

    */
    var sTable = "VT_1FG1S_M00168" + sDB_Suffix;
    var sTargetAttribute = "O_H1G_BIS_H7A_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_WELLENENDE_KAG_NO_DB_RESULT";
        return strError;
    }
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Übernahme O_H1G_BIS_H7A_1FG1S-Einschränkung
    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");

    var sStatus = SetAttributeLogicFromMLFB_2nd("PMD_ABV414_001_000_1FG1S", "O_H1G_BIS_H7A_1FG1S", "VT_1FG1S_M00040" + sDB_Suffix, "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "'");
    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_WELLENENDE_KAG_NO_DB_RESULT";
        return strError;
    }
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");

    var sTable = "VT_1FG1S_M00040" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABV414_001_000_1FG1S";
    var sWhere = "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var PMD_ABV672_001_000_1FG1S = ECL_GetValue("PMD_ABV672_001_000_1FG1S");

    var sTable = "VT_1FG1S_M00130" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABV414_001_000_1FG1S";
    var sWhere = "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
        "PMD_ABV672_001_000_1FG1S = '" + PMD_ABV672_001_000_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_WELLENENDE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    // KAG Wellenausführung
    // ################################################################################################################
    /*
    VT_1FG1S_M00040	MLFB: Wellenausführung
        MLFB08_1FG1S	PMD_ABV414_001_000_1FG1S	PMD_ABV410_001_000_1FG1S	H_WELLEN_DURCHM_1FG1S	O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S

    VT_1FG1S_M00084	G20-Getriebe-Befest.-Welle
        MLFB_05_06_07_1FG1S	MLFB08_1FG1S	MLFB14_1FG1S	O_H1G_BIS_H7A_1FG1S	O_G20_1FG1S	HMK_VALUE_VALID_1FG1S

    VT_1FG1S_M00233	G60 Getriebe, MLFB8;10Welle if (MLFB05 == (3 or 4))
        MLFB_05_06_07_1FG1S MLFB08_1FG1S    MLFB10_1FG1S    O_H1G_BIS_H7A_1FG1S O_G60_1FG1S
    VT_1FG1S_M00234	G60 Getriebe, MLFB8;14Welle if (MLFB05 == (5 or 6))
        MLFB_05_06_07_1FG1S MLFB08_1FG1S    MLFB14_1FG1S    O_H1G_BIS_H7A_1FG1S O_G60_1FG1S

    VT_1FG1S_M00237	G60+Welle vs. RUMPF_567_8_10_14
        MLFB_05_06_07_1FG1S MLFB08_1FG1S    MLFB10_1FG1S    MLFB14_1FG1S    O_H1G_BIS_H7A_1FG1S O_G60_1FG1S

    VT_1FG1S_M00168	Wellenverriegelung
        MLFB_05_06_07_1FG1S	MLFB08_1FG1S	MLFB10_1FG1S	MLFB14_1FG1S	O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S
    */

    // ################################################################################################################
    // Durchmesser			H_WELLEN_DURCHM_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00040	MLFB: Wellenausführung
        MLFB08_1FG1S	PMD_ABV414_001_000_1FG1S	PMD_ABV410_001_000_1FG1S	H_WELLEN_DURCHM_1FG1S	O_H1G_BIS_H7A_1FG1S	HMK_VALUE_VALID_1FG1S

NN?	VT_1FG1S_M00093	CAD-Welle	
        H_WELLEN_DURCHM_1FG1S	CAD_EGABKDBEZ_1FG1S	CAD_EGABKLG_1FG1S

    VT_1FG1S_M00245	Rumpf567_Wellenausf_Durchm_G23/G24
        MLFB_05_06_07_1FG1S PMD_ABV414_001_000_1FG1S    H_WELLEN_DURCHM_1FG1S   O_G23_G24_1FG1S

    */
    var sTargetAttribute = "H_WELLEN_DURCHM_1FG1S";

    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");
    var PMD_ABV414_001_000_1FG1S = ECL_GetValue("PMD_ABV414_001_000_1FG1S");

    var sTable = "VT_1FG1S_M00040" + sDB_Suffix;
    var sWhere = 	//"MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
        "PMD_ABV414_001_000_1FG1S = '" + PMD_ABV414_001_000_1FG1S + "' AND " +	// Ausführung Wellenende ergibt sich ? ToDo: klären, ob Wellenart STD, Hohl, Voll sich aus Durchmesserwahl ergeben soll???
        "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_WELLENDURCHMESSER_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    // KAG Wellenausführung O_H1G_BIS_H7A_1FG1S
    // H_WELLEN_DURCHM_1FG1S
    // MLFB08_1FG1S
    var PMD_ABV410_001_000_1FG1S = ECL_GetValue("PMD_ABV410_001_000_1FG1S");
    var PMD_ABV414_001_000_1FG1S = ECL_GetValue("PMD_ABV414_001_000_1FG1S");
    var H_WELLEN_DURCHM_1FG1S = ECL_GetValue("H_WELLEN_DURCHM_1FG1S");

    var sTable = "VT_1FG1S_M00040" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "PMD_ABV414_001_000_1FG1S = '" + PMD_ABV414_001_000_1FG1S + "' AND " +
        "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
        "H_WELLEN_DURCHM_1FG1S = '" + H_WELLEN_DURCHM_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var aResult = GetDBDataSetEXT(sSQL, sTable);

    if (aResult.length > 0) {
        MLFB08_1FG1S = aResult[0].MLFB08_1FG1S;
        var O_H1G_BIS_H7A_1FG1S = aResult[0].O_H1G_BIS_H7A_1FG1S;
        //var H_WELLEN_DURCHM_1FG1S = aResult[0].H_WELLEN_DURCHM_1FG1S;

        sMLFB = replaceAt(sMLFB, 7, MLFB08_1FG1S);
        ECL_SetValue("ECSI_MLFB", sMLFB);
        ECL_SetValue("O_H1G_BIS_H7A_1FG1S", O_H1G_BIS_H7A_1FG1S);
        //ECL_SetValue("H_WELLEN_DURCHM_1FG1S", H_WELLEN_DURCHM_1FG1S);
    } else {
        strError = "DICT1_ERR_1FG1___PLVT_WELLENENDE_KAG_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################

    // ################################################################################################################
    // Drehmomentstütze Figur 2		O_G10_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00079	G10-Getriebe-Befestigung
        MLFB_05_06_07_1FG1S	MLFB14_1FG1S	O_G10_1FG1S

NN	VT_1FG1S_M00102	CAD-Drehmomentenstütze
        MLFB_05_06_07_1FG1S	O_G10_1FG1S	CAD_EGABDMSTFIG_1FG1S

NN	VT_1FG1S_M00123	CAD-Drehmomentenstützenposition			benötigte Info steht in VT 79
        MLFB_05_06_07_1FG1S	PMD_ABV672_001_000_1FG1S	O_G10_1FG1S	CAD_POSITION_1FG1S	UI_POS_DREHMOST_BILD_1FG1S


    */
    var sTable = "VT_1FG1S_M00079" + sDB_Suffix;
    var sTargetAttribute = "O_G10_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_DREHMOMENTSTUETZE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################
    /*	var O_G10_1FG1S = ECL_GetValue("O_G10_1FG1S");
        if (O_G10_1FG1S == "G10"){
            sMLFB = replaceAt(sMLFB, 13, "D");
            ECL_SetValue("ECSI_MLFB", sMLFB);
        }
    */



    // ################################################################################################################
    // Ausführung (Geber)		UI_GEBER_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00180
        MLFB09_1FG1S	O_N16_1FG1S	PMD_ABU278_001_000_1FG1S	UI_GEBER_1FG1S	UI_GEBER_AUFLOESUNG_1FG1S	HMK_VALUE_VALID_1FG1S
    
    VT_1FG1S_M00210	ZO MLFB09 <> MLFB10
        MLFB09_1FG1S	MLFB10_1FG1S	HMK_VALUE_VALID_1FG1S
    
    */
    // Wenn mit Ausführung für erhöhte chemische Beständigkeit		O_N16_1FG1S ===> Dann Geber mit Umdrehungszähler
    //MLFB09_1FG1S	PMD_ABU278_001_000_1FG1S	UI_GEBER_1FG1S	UI_GEBER_AUFLOESUNG_1FG1S
    //R				Z0006						MIT            	00012

    /*
    VT_1FG1S_M00161
        MLFB08_1FG1S	MLFB09_1FG1S	MLFB14_1FG1S	O_N16_1FG1S
    */
    var sTargetAttribute = "MLFB09_1FG1S";



    var O_N16_1FG1S = ECL_GetValue("O_N16_1FG1S");

    var sTable = "VT_1FG1S_M00161" + sDB_Suffix;
    var sWhere = "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        "O_N16_1FG1S = '" + O_N16_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_GEBER_MLFB09_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    /* VT_1FG1S_M00210	ZO MLFB09 <> MLFB10
        MLFB09_1FG1S	MLFB10_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    var sTable = "VT_1FG1S_M00210" + sDB_Suffix;
    var sWhere = "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_GEBER_MLFB09_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Geber einschränken anhand MLFB09
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABU278_001_000_1FG1S", "MLFB09_1FG1S", "VT_1FG1S_M00180" + sDB_Suffix, "O_N16_1FG1S = '" + O_N16_1FG1S + "'");

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_GEBER_MLFB09_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // in Funktion bereits erledigt: ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1FG1S", "Q");
    // ----------------------------------------------------------------------------------------------------------------
    // UI_GEBER_1FG1S einschränken/bestimmen
    var sStatus = SetAttributeLogicFromMLFB("UI_GEBER_1FG1S", "MLFB09_1FG1S", "VT_1FG1S_M00180" + sDB_Suffix, "O_N16_1FG1S = '" + O_N16_1FG1S + "'");

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_UI_GEBER_MLFB09_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    // UI_GEBER_AUFLOESUNG_1FG1S einschränken/bestimmen
    var sStatus = SetAttributeLogicFromMLFB("UI_GEBER_AUFLOESUNG_1FG1S", "MLFB09_1FG1S", "VT_1FG1S_M00180" + sDB_Suffix, "O_N16_1FG1S = '" + O_N16_1FG1S + "'");

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_UI_GEBERAUFLOESUNG_MLFB09_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    // ################################################################################################################


    // ################################################################################################################
    // Auflösung		UI_GEBER_AUFLOESUNG_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00180
        MLFB09_1FG1S	O_N16_1FG1S	PMD_ABU278_001_000_1FG1S	UI_GEBER_1FG1S	UI_GEBER_AUFLOESUNG_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    var UI_GEBER_1FG1S = ECL_GetValue("UI_GEBER_1FG1S");
    var O_N16_1FG1S = ECL_GetValue("O_N16_1FG1S");

    var sTable = "VT_1FG1S_M00180" + sDB_Suffix;
    var sTargetAttribute = "UI_GEBER_AUFLOESUNG_1FG1S";
    var sWhere = "O_N16_1FG1S = '" + O_N16_1FG1S + "' AND " +
        "UI_GEBER_1FG1S = '" + UI_GEBER_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FG1___PLVT_GEBER_AUFLOESUNG_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Ermittelter Geber		PMD_ABU278_001_000_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00180
        MLFB09_1FG1S	O_N16_1FG1S	PMD_ABU278_001_000_1FG1S	UI_GEBER_1FG1S	UI_GEBER_AUFLOESUNG_1FG1S	HMK_VALUE_VALID_1FG1S
    
    */
    var UI_GEBER_1FG1S = ECL_GetValue("UI_GEBER_1FG1S");
    var UI_GEBER_AUFLOESUNG_1FG1S = ECL_GetValue("UI_GEBER_AUFLOESUNG_1FG1S");

    var sTable = "VT_1FG1S_M00180" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABU278_001_000_1FG1S";
    var sWhere = "UI_GEBER_AUFLOESUNG_1FG1S = '" + UI_GEBER_AUFLOESUNG_1FG1S + "' AND " +
        "UI_GEBER_1FG1S = '" + UI_GEBER_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_GEBER_AUFLOESUNG_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var PMD_ABU278_001_000_1FG1S = ECL_GetValue("PMD_ABU278_001_000_1FG1S");


    var sTable = "VT_1FG1S_M00180" + sDB_Suffix;

    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
        "PMD_ABU278_001_000_1FG1S = '" + PMD_ABU278_001_000_1FG1S + "' AND " +
        "UI_GEBER_AUFLOESUNG_1FG1S = '" + UI_GEBER_AUFLOESUNG_1FG1S + "' AND " +
        "UI_GEBER_1FG1S = '" + UI_GEBER_1FG1S + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable);

    if (aResult.length > 0) {
        MLFB09_1FG1S = aResult[0].MLFB09_1FG1S;
        sMLFB = replaceAt(sMLFB, 8, MLFB09_1FG1S);

        ECL_SetValue("ECSI_MLFB", sMLFB);

        if (MLFB09_1FG1S == "Z") {
            ECL_SetValue("O_J4R_1FG1S", "J4R");
        } else {
            ECL_SetValue("O_J4R_1FG1S", "F");
        }

    } else {
        strError = "DICT1_ERR_1FG1___PLVT_SET_MLFB09_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }


    /*
    Vorkommnisse von MLFB09_1FG1S in VT:
    NN	VT_1FG1S_M00075	Gewicht-Geber
    s.o.VT_1FG1S_M00103	MLFB09-Geber
        VT_1FG1S_M00161	N16-MLFB09-09-14
        VT_1FG1S_M00111	ZO Motor Typ/DC
        VT_1FG1S_M00189	TechnischeDaten-Motor
    */
    // ################################################################################################################


    // ################################################################################################################
    // Ausführung (Farbe)			HMK_FARBAUSFUEHRUNG_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00149	N16-K23-K24
        O_N16_1FG1S	HMK_FARBAUSFUEHRUNG_1FG1S

    * /
    var O_N16_1FG1S = ECL_GetValue("O_N16_1FG1S");
    if (O_N16_1FG1S == "N16"){
    
    }*/
    var O_N16_1FG1S = ECL_GetValue("O_N16_1FG1S");

    var sTable = "VT_1FG1S_M00149" + sDB_Suffix;
    var sTargetAttribute = "HMK_FARBAUSFUEHRUNG_1FG1S";
    var sWhere = "O_N16_1FG1S = '" + O_N16_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_AUSF_FARBE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Farbe		O_X01__X27_1FG1S	
    // ################################################################################################################
    /*
NN	VT_1FG1S_M00105	Farbe-X-Optionen-PMD-MM 	Übersetzung in PMD-Attribut Farbe des Gehäuses
        O_X01__X27_1FG1S	PMD_AAD756_001_000_1FG1S

NN	VT_1FG1S_M00142	Farbe UI - Farbe KAG
        HMK_UI_FARBSPEKTRUM_1FG1S	O_X01__X27_1FG1S



* KAG-Mapping, wenn
* Farbe gewählt
OBJECTS: c is_a (300) skey '1FG1S'
*
CONDITION: (c.HMK_FARBAUSFUEHRUNG_1FG1S = '00001' OR
c.HMK_FARBAUSFUEHRUNG_1FG1S = 'K23')
and c.H_DIREKT_1FG1S = 'F'
*
RESTRICTIONS: TABLE VT_1FG1S_M00142 (
  HMK_UI_FARBSPEKTRUM_1FG1S =c.HMK_UI_FARBSPEKTRUM_1FG1S ,
  O_X01__X27_1FG1S =c.O_X01__X27_1FG1S )
INFERENCES:
  c.O_X01__X27_1FG1S.


* KAG-Merkmal für Farbe "OHNE"
* wenn lt. Farbausführung
* keine Farbe wählbar
*  (d.h. keine Lackierung oder keine
* Grundierung u. keine Lackierung
*
OBJECTS: c is_a (300) skey '1FG1S'
*
CONDITION: c.HMK_FARBAUSFUEHRUNG_1FG1S = 'K24'
*
RESTRICTIONS: c.O_X01__X27_1FG1S = 'OHNE'
*
INFERENCES: c.O_X01__X27_1FG1S
    */
    var HMK_FARBAUSFUEHRUNG_1FG1S = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FG1S");
    if (HMK_FARBAUSFUEHRUNG_1FG1S == "K24") {
        ECL_DeactivateAllAttributeValues("O_X01__X27_1FG1S");
        ECL_ActivateValue("O_X01__X27_1FG1S", "OHNE");
        ECL_SetValue("O_X01__X27_1FG1S", "OHNE");
    } else {
        ECL_ActivateAllAttributeValues("O_X01__X27_1FG1S");
        ECL_DeactivateValue("O_X01__X27_1FG1S", "OHNE");
        ExecSetStandardifValueEmpty("O_X01__X27_1FG1S", "STD");
    }

    // ################################################################################################################

    // ################################################################################################################
    // Einbaulage		PMD_AAA566_001_000_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00018	Def: Einbaulage_klasse										nur Übersetzung KAG in HMK
        PMD_AAA566_001_000_1FG1S	H_EINBAULAGE_KLASSE_1FG1S	HMK_VALUE_VALID_1FG1S

    VT_1FG1S_M00049	Einbaulage-Getriebeart
        PMD_AAA566_001_000_1FG1S	PMD_ABV517_001_000_1FG1S
NN	VT_1FG1S_M00062	ZO Getriebe-Einbaulage - Bild
        UI_EINBAULAGE_BILD_1FG1S	PMD_AAA566_001_000_1FG1S	PMD_ABV410_001_000_1FG1S	PMD_ABV672_001_000_1FG1S	PMD_ABV414_001_000_1FG1S

    VT_1FG1S_M00100	Drehmomentenstütze-Bild <---- keine Einschränkung der Einbaulaage aus MLFB567 erkennbar, nur O_EXX
        MLFB_05_06_07_1FG1S	HMK_O_EXX_ACHSE_1FG1S	PMD_AAA566_001_000_1FG1S	HMK_DMST_POS_BILD_1FG1S

NN	VT_1FG1S_M00101	CAD-Einbaulage
NN	VT_1FG1S_M00139	Oelmenge-Zusatz-B-Seite

    */
    var PMD_ABV517_001_000_1FG1S = ECL_GetValue("PMD_ABV517_001_000_1FG1S");

    var sTable = "VT_1FG1S_M00049" + sDB_Suffix;
    var sTargetAttribute = "PMD_AAA566_001_000_1FG1S";
    var sWhere = "PMD_ABV517_001_000_1FG1S = '" + PMD_ABV517_001_000_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_EINBAULAGE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################
    // H_EINBAULAGE_KLASSE_1FG1S bestimmen --> Edit Feld wird für Auswertung M00029 benötigt bzw umgekehrt
    // ################################################################################################################
    /*
    VT_1FG1S_M00018	Def: Einbaulage_klasse										nur Übersetzung KAG in HMK
        PMD_AAA566_001_000_1FG1S	H_EINBAULAGE_KLASSE_1FG1S	HMK_VALUE_VALID_1FG1S

    VT_1FG1S_M00029	ZO DZkl>n2>key>Einbaul
        MLFB10_1FG1S	H_KEY_GETRIEBE_1FG1S	H_EINBAULAGE_KLASSE_1FG1S	H_DREHZAHL_KLASSE_1FG1S	PMD_ABW813_001_000_1FG1S

    */
    var PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S");

    var sTable = "VT_1FG1S_M00018" + sDB_Suffix;

    var sSQL = "SELECT H_EINBAULAGE_KLASSE_1FG1S FROM " + sTable + " WHERE " +
        "PMD_AAA566_001_000_1FG1S = '" + PMD_AAA566_001_000_1FG1S + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable);

    if (aResult.length > 0) {
        H_EINBAULAGE_KLASSE_1FG1S = aResult[0].H_EINBAULAGE_KLASSE_1FG1S;

        ECL_SetValue("H_EINBAULAGE_KLASSE_1FG1S", H_EINBAULAGE_KLASSE_1FG1S);

    } else {
        strError = "DICT1_ERR_1FG1___PLVT_H_EINBAULAGE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    // HMK_AAA566_KOMBI_1FG1S einschränken
    // ################################################################################################################
    /*
    VT_1FG1S_M00175
        HMK_AAA566_KOMBI_1FG1S	PMD_AAA566_001_000_1FG1S	HMK_VALUE_VALID_1FG1S

    */
    //var PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S");

    var sTable = "VT_1FG1S_M00175" + sDB_Suffix;
    var sTargetAttribute = "HMK_AAA566_KOMBI_1FG1S";
    var sWhere = "PMD_AAA566_001_000_1FG1S = '" + PMD_AAA566_001_000_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_EINBAULAGE_KOMBI_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################



    // ################################################################################################################
    // Steckerposition		O_Q91_Q92_Q93_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00160	MLFB10-Q91-To-Q96-K82
        O_Q91_Q92_Q93_1FG1S	O_Q94_Q95_Q96_1FG1S	MLFB10_1FG1S	O_K82_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    var O_Q94_Q95_Q96_1FG1S = ECL_GetValue("O_Q94_Q95_Q96_1FG1S");
    //var O_K82_1FG1S = ECL_GetValue("O_K82_1FG1S");

    var sTable = "VT_1FG1S_M00160" + sDB_Suffix;
    var sTargetAttribute = "O_Q91_Q92_Q93_1FG1S";
    var sWhere = "O_Q94_Q95_Q96_1FG1S = '" + O_Q94_Q95_Q96_1FG1S + "' AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        //"O_K82_1FG1S = '" + O_K82_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_STECKERPOS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Schrägeinbaulagen		HMK_O_EXX_ACHSE_1FG1S	
    // ################################################################################################################
    /*
    Wenn ein Ölschauglas verwendet werden soll, keine Schrägeinbaulage!
    Soll das hier einschränken?
    
    VT_1FG1S_M00085	E01-bis-E37-Optionen								keine Einschränkung in diese Richtung!
        HMK_O_EXX_ACHSE_1FG1S	HMK_O_EXX_WINKEL_1FG1S	O_E01_BIS_E37_1FG1S

NN	VT_1FG1S_M00099	CAD-Rotationsachse
    A: VT_1FG1S_M00100	Drehmomentenstütze-Bild
        MLFB_05_06_07_1FG1S	HMK_O_EXX_ACHSE_1FG1S	PMD_AAA566_001_000_1FG1S	HMK_DMST_POS_BILD_1FG1S
    */

    var O_G34_1FG1S = ECL_GetValue("O_G34_1FG1S");
    if (O_G34_1FG1S == "G34") {

        var sTargetAttribute = "HMK_O_EXX_ACHSE_1FG1S";
        var aValidValues = ['NON'];

        var sStatus = SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = ECL_Translate("DICT1_ERR_1FG1___PLVT_SCHRAEGEINBAULAGE_G34_LOGIKFEHLER_NO_DB_RESULT");
            return strError;
        }
        //-------------------------------------------------------------------------------------------------------------
        var sTargetAttribute = "HMK_O_EXX_WINKEL_1FG1S";
        var aValidValues = ['NON'];

        var sStatus = SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = ECL_Translate("DICT1_ERR_1FG1___PLVT_SCHRAEGEINBAULAGE_G34_LOGIKFEHLER_NO_DB_RESULT");
            return strError;
        }
        //-------------------------------------------------------------------------------------------------------------
        var sTargetAttribute = "O_E01_BIS_E37_1FG1S";
        var aValidValues = ['NON'];

        var sStatus = SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = ECL_Translate("DICT1_ERR_1FG1___PLVT_SCHRAEGEINBAULAGE_G34_LOGIKFEHLER_NO_DB_RESULT");
            return strError;
        }
        //-------------------------------------------------------------------------------------------------------------
        var sTargetAttribute = "HMK_E01_E37_KOMBI_1FG1S";
        var aValidValues = ['EXX', 'EXX_A', 'EXX_B', 'EXX_C', 'EXX_D', 'EXX_E'];

        var sStatus = SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValues);

        if (sStatus == "Error") {
            strError = ECL_Translate("DICT1_ERR_1FG1___PLVT_SCHRAEGEINBAULAGE_G34_LOGIKFEHLER_NO_DB_RESULT");
            return strError;
        }
    } else {

        var PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S");
        var O_K82_1FG1S = ECL_GetValue("O_K82_1FG1S");

        var sTable = "VT_1FG1S_M00100" + sDB_Suffix;
        var sTargetAttribute = "HMK_O_EXX_ACHSE_1FG1S";
        var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
            "PMD_AAA566_001_000_1FG1S = '" + PMD_AAA566_001_000_1FG1S + "';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FG1___PLVT_SCHRAEGEINBAULAGE_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
        // ################################################################################################################


        // ################################################################################################################
        // Schrägeinbaulagen Winkel		HMK_O_EXX_WINKEL_1FG1S	
        // ################################################################################################################
        /*
        VT_1FG1S_M00085	E01-bis-E37-Optionen
            HMK_O_EXX_ACHSE_1FG1S	HMK_O_EXX_WINKEL_1FG1S	O_E01_BIS_E37_1FG1S
    NN	VT_1FG1S_M00099	CAD-Rotationsachse
    NN	VT_1FG1S_M00135	Ölmenge-X-Achse
    NN	VT_1FG1S_M00136	Oelmenge-Y-Achse
    NN	VT_1FG1S_M00137	Oelmenge-Z-Achse
        
        */
        var HMK_O_EXX_ACHSE_1FG1S = ECL_GetValue("HMK_O_EXX_ACHSE_1FG1S");

        var sTable = "VT_1FG1S_M00085" + sDB_Suffix;
        var sTargetAttribute = "HMK_O_EXX_WINKEL_1FG1S";
        var sWhere = "HMK_O_EXX_ACHSE_1FG1S = '" + HMK_O_EXX_ACHSE_1FG1S + "';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FG1___PLVT_SCHRAEGEINBAULAGE_WINKEL_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
        // ################################################################################################################


        // ################################################################################################################
        // Option Schrägeinbaulagen		O_E01_BIS_E37_1FG1S	
        // ################################################################################################################
        /*
        VT_1FG1S_M00085	E01-bis-E37-Optionen
            HMK_O_EXX_ACHSE_1FG1S	HMK_O_EXX_WINKEL_1FG1S	O_E01_BIS_E37_1FG1S
        VT_1FG1S_M00124	G34<>E01-E57 ==> Ölschauglas
            O_G34_1FG1S	O_E01_BIS_E37_1FG1S
        
    NN	VT_1FG1S_M00159	Datenbl.Trigger Exx gestzt
            
        */
        var HMK_O_EXX_ACHSE_1FG1S = ECL_GetValue("HMK_O_EXX_ACHSE_1FG1S");
        var HMK_O_EXX_WINKEL_1FG1S = ECL_GetValue("HMK_O_EXX_WINKEL_1FG1S");

        var sTable = "VT_1FG1S_M00085" + sDB_Suffix;
        var sTargetAttribute = "O_E01_BIS_E37_1FG1S";
        var sWhere = "HMK_O_EXX_WINKEL_1FG1S = '" + HMK_O_EXX_WINKEL_1FG1S + "' AND " +
            "HMK_O_EXX_ACHSE_1FG1S = '" + HMK_O_EXX_ACHSE_1FG1S + "';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FG1___PLVT_SCHRAEGEINBAULAGE_KAG_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
        // ################################################################################################################

        // ################################################################################################################
        // Option Schrägeinbaulagen-Kombi-Attribut		HMK_E01_E37_KOMBI_1FG1S	
        // ################################################################################################################
        /* VT_1FG1S_M00176
                HMK_E01_E37_KOMBI_1FG1S	O_E01_BIS_E37_1FG1S	HMK_VALUE_VALID_1FG1S
        */
        var O_E01_BIS_E37_1FG1S = ECL_GetValue("O_E01_BIS_E37_1FG1S");

        var sTable = "VT_1FG1S_M00176" + sDB_Suffix;
        var sTargetAttribute = "HMK_E01_E37_KOMBI_1FG1S";
        var sWhere = "O_E01_BIS_E37_1FG1S = '" + O_E01_BIS_E37_1FG1S + "' AND " +
            "HMK_VALUE_VALID_1FG1S = 'T';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FG1___PLVT_SCHRAEGEINBAULAGE_KAG_KOMBI_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }

        // ################################################################################################################


    } //END else G34

    // ################################################################################################################
    // Bestimme HMK_ADAPT_SCREW_TYPE_1FG1S
    // ################################################################################################################
    // HMK_HOUSING_TYPE_1FG1S
    var sTargetAttribute = "HMK_HOUSING_TYPE_1FG1S";
    // VT_1FG1S_M00203
    // PMD_ABV517_001_000_1FG1S	PMD_ABV417_001_000_1FG1S_X	MLFB14_1FG1S	HMK_HOUSING_TYPE_1FG1S
    var PMD_ABV517_001_000_1FG1S = ECL_GetValue("PMD_ABV517_001_000_1FG1S");
    var sTable = "VT_1FG1S_M00203" + sDB_Suffix;
    var sWhere = "PMD_ABV517_001_000_1FG1S = '" + PMD_ABV517_001_000_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_HMK_ADAPT_SCREW_TYPE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // HMK_GEAR_GRP_HOUSING_1FG1S
    var sTargetAttribute = "HMK_GEAR_GRP_HOUSING_1FG1S";
    // VT_1FG1S_M00202
    // PMD_ABV410_001_000_1FG1S	HMK_HOUSING_TYPE_1FG1S	HMK_GEAR_GRP_HOUSING_1FG1S
    var aValidValuesHMK_HOUSING_TYPE = ECL_GetAllActiveAttributeValues("HMK_HOUSING_TYPE_1FG1S");

    var sTable = "VT_1FG1S_M00202" + sDB_Suffix;
    var sWhere = "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
        "HMK_HOUSING_TYPE_1FG1S IN ('" + aValidValuesHMK_HOUSING_TYPE.join("', '") + "' );";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_HMK_ADAPT_SCREW_TYPE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // HMK_GEAR_GRP_HOUSING_1FG1S weiter einschränken
    var HMK_GEAR_GRP_HOUSING_1FG1S = ECL_GetValue("HMK_GEAR_GRP_HOUSING_1FG1S");

    var sTargetAttribute = "HMK_HOUSING_TYPE_1FG1S";
    var sTable = "VT_1FG1S_M00202" + sDB_Suffix;
    var sWhere = "PMD_ABV410_001_000_1FG1S = '" + PMD_ABV410_001_000_1FG1S + "' AND " +
        "HMK_GEAR_GRP_HOUSING_1FG1S = '" + HMK_GEAR_GRP_HOUSING_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_HMK_ADAPT_SCREW_TYPE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // HMK_ADAPT_SCREW_TYPE_1FG1S
    var sTargetAttribute = "HMK_ADAPT_SCREW_TYPE_1FG1S";
    // VT_1FG1S_M00204
    // HMK_GEAR_GRP_HOUSING_1FG1S	PMD_AAA566_001_000_1FG1S	O_E01_BIS_E37_1FG1S	HMK_ADAPT_SCREW_TYPE_1FG1S
    var PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S");
    var O_E01_BIS_E37_1FG1S = ECL_GetValue("O_E01_BIS_E37_1FG1S");
    var HMK_GEAR_GRP_HOUSING_1FG1S = ECL_GetValue("HMK_GEAR_GRP_HOUSING_1FG1S");

    var sTable = "VT_1FG1S_M00204" + sDB_Suffix;
    var sWhere = "PMD_AAA566_001_000_1FG1S = '" + PMD_AAA566_001_000_1FG1S + "' AND " +
        "O_E01_BIS_E37_1FG1S = '" + O_E01_BIS_E37_1FG1S + "' AND " +
        "HMK_GEAR_GRP_HOUSING_1FG1S = '" + HMK_GEAR_GRP_HOUSING_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_HMK_ADAPT_SCREW_TYPE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################
    // Position Adapterflansch		O_R91_R92_R93_1FG1S	
    // ################################################################################################################
    /* VT_1FG1S_M00205	MLFB10-Q91-To-Q96-K82
        O_R91_R92_R93_1FG1S		HMK_ADAPT_SCREW_TYPE_1FG1S		PMD_AAA566_001_000_1FG1S	O_E01_BIS_E37_1FG1S		PMD_ABV517_001_000_1FG1S	PMD_ABV417_001_000_1FG1S_X
    */
    var sTargetAttribute = "O_R91_R92_R93_1FG1S";

    var PMD_AAA566_001_000_1FG1S = ECL_GetValue("PMD_AAA566_001_000_1FG1S");
    var O_E01_BIS_E37_1FG1S = ECL_GetValue("O_E01_BIS_E37_1FG1S");
    var PMD_ABV517_001_000_1FG1S = ECL_GetValue("PMD_ABV517_001_000_1FG1S");
    var HMK_ADAPT_SCREW_TYPE_1FG1S = ECL_GetValue("HMK_ADAPT_SCREW_TYPE_1FG1S");

    var sTable = "VT_1FG1S_M00205" + sDB_Suffix;
    var sWhere = "PMD_AAA566_001_000_1FG1S = '" + PMD_AAA566_001_000_1FG1S + "' AND " +
        "O_E01_BIS_E37_1FG1S = '" + O_E01_BIS_E37_1FG1S + "' AND " +
        "PMD_ABV517_001_000_1FG1S = '" + PMD_ABV517_001_000_1FG1S + "' AND " +
        "HMK_ADAPT_SCREW_TYPE_1FG1S = '" + HMK_ADAPT_SCREW_TYPE_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_POS_ADAPTERFLANSCH_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################



    // ################################################################################################################
    // Ölsorte		O_K06_K07_K08_K11_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00087	K-Optionen-Getriebe-G23-G24
        MLFB_05_06_07_1FG1S	O_G23_G24_1FG1S	O_K06_K07_K08_K11_1FG1S
    */
    var O_G23_G24_1FG1S = ECL_GetValue("O_G23_G24_1FG1S");

    var sTable = "VT_1FG1S_M00087" + sDB_Suffix;
    var sTargetAttribute = "O_K06_K07_K08_K11_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "O_G23_G24_1FG1S = '" + O_G23_G24_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_OELSORTE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Abtriebswellenabdichtung		O_G23_G24_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00087	K-Optionen-Getriebe-G23-G24
        MLFB_05_06_07_1FG1S	O_G23_G24_1FG1S	O_K06_K07_K08_K11_1FG1S
    
    VT_1FG1S_M00245	Rumpf567_Wellenausf_Durchm_G23/G24
        MLFB_05_06_07_1FG1S PMD_ABV414_001_000_1FG1S    H_WELLEN_DURCHM_1FG1S   O_G23_G24_1FG1S

    */
    var sTargetAttribute = "O_G23_G24_1FG1S";


    var O_K06_K07_K08_K11_1FG1S = ECL_GetValue("O_K06_K07_K08_K11_1FG1S");

    var sTable = "VT_1FG1S_M00087" + sDB_Suffix;
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "O_K06_K07_K08_K11_1FG1S = '" + O_K06_K07_K08_K11_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_WELLENDICHTUNG_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var PMD_ABV414_001_000_1FG1S = ECL_GetValue("PMD_ABV414_001_000_1FG1S");
    var H_WELLEN_DURCHM_1FG1S = ECL_GetValue("H_WELLEN_DURCHM_1FG1S");

    var sTable = "VT_1FG1S_M00245" + sDB_Suffix;
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "PMD_ABV414_001_000_1FG1S = '" + PMD_ABV414_001_000_1FG1S + "' AND " +
        "H_WELLEN_DURCHM_1FG1S = '" + H_WELLEN_DURCHM_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_WELLENDICHTUNG_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Ölschauglas		O_G34_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00080	G34-Getriebe
        MLFB_05_06_07_1FG1S	O_G34_1FG1S

    VT_1FG1S_M00124	G34<>E01-E57
        O_G34_1FG1S	O_E01_BIS_E37_1FG1S
    */
    var O_K06_K07_K08_K11_1FG1S = ECL_GetValue("O_K06_K07_K08_K11_1FG1S");

    var sTable = "VT_1FG1S_M00080" + sDB_Suffix;
    var sTargetAttribute = "O_G34_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_OELSCHAUGLAS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var O_E01_BIS_E37_1FG1S = ECL_GetValue("O_E01_BIS_E37_1FG1S");

    var sTable = "VT_1FG1S_M00124" + sDB_Suffix;
    var sTargetAttribute = "O_G34_1FG1S";
    var sWhere = "O_E01_BIS_E37_1FG1S = '" + O_E01_BIS_E37_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_OELSCHAUGLAS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Ölablassschraube magnetisch		O_G53_1FG1S	
    // ################################################################################################################
    /*
    VT	VT_1FG1S_M00174	G53-Getriebe +Anbauart,Einbaulg+Schräglg
        MLFB_05_06_07_1FG1S	MLFB14_1FG1S	HMK_AAA566_KOMBI_1FG1S	O_G53_1FG1S	HMK_E01_E37_KOMBI_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    // ---------------------------------------------------------------------------------------------------------------------------------------------
    // Gültige Einbaulagen (Kombi-Attribut)
    var sWhere_HMK_AAA566_KOMBI = "";	// mehrere gültig, ValidValues schränken ein, nicht einzelwert!
    var aValidValues_AAA566_KOMBI = ECL_GetAllActiveAttributeValues("HMK_AAA566_KOMBI_1FG1S") || [];

    if (aValidValues_AAA566_KOMBI.length == 0) {
        strError = "DICT1_ERR_1FG1___PLVT_NO_VALID_VALUES_AAA566";
        return strError;
    }

    var sWhere_HMK_AAA566_KOMBI = "(HMK_AAA566_KOMBI_1FG1S = '" + aValidValues_AAA566_KOMBI[0] + "'";

    if (aValidValues_AAA566_KOMBI.length > 1) {

        for (var i = 1; i < aValidValues_AAA566_KOMBI.length; i++) {

            sWhere_HMK_AAA566_KOMBI = sWhere_HMK_AAA566_KOMBI + " OR " + "HMK_AAA566_KOMBI_1FG1S = '" + aValidValues_AAA566_KOMBI[i] + "'";
        }
    }
    sWhere_HMK_AAA566_KOMBI = sWhere_HMK_AAA566_KOMBI + ")";
    // ---------------------------------------------------------------------------------------------------------------------------------------------
    // Gültige Schrägeinbaulagen (Kombi-Attribut)
    var sWhere_HMK_E01_E37_KOMBI = "";	// mehrere gültig, ValidValues schränken ein, nicht einzelwert!
    var aValidValues_E01_E37_KOMBI = ECL_GetAllActiveAttributeValues("HMK_E01_E37_KOMBI_1FG1S") || [];

    if (aValidValues_E01_E37_KOMBI.length == 0) {
        strError = "DICT1_ERR_1FG1___PLVT_NO_VALID_VALUES_E01_E37";
        return strError;
    }

    var sWhere_HMK_E01_E37_KOMBI = "(HMK_E01_E37_KOMBI_1FG1S = '" + aValidValues_E01_E37_KOMBI[0] + "'";

    if (aValidValues_E01_E37_KOMBI.length > 1) {

        for (var i = 1; i < aValidValues_E01_E37_KOMBI.length; i++) {

            sWhere_HMK_E01_E37_KOMBI = sWhere_HMK_E01_E37_KOMBI + " OR " + "HMK_E01_E37_KOMBI_1FG1S = '" + aValidValues_E01_E37_KOMBI[i] + "'";
        }
    }
    sWhere_HMK_E01_E37_KOMBI = sWhere_HMK_E01_E37_KOMBI + ")";
    // ---------------------------------------------------------------------------------------------------------------------------------------------
    // Logik G53
    var sTable = "VT_1FG1S_M00174" + sDB_Suffix;
    var sTargetAttribute = "O_G53_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        sWhere_HMK_AAA566_KOMBI + " AND " +
        sWhere_HMK_E01_E37_KOMBI + " AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_OELABLASSSCHRAUBE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Ölausgleichsbehälter		O_G47_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00177	G47-Getriebe,AH
        MLFB_05_06_07_1FG1S	MLFB10_1FG1S	O_G47_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    var sTable = "VT_1FG1S_M00177" + sDB_Suffix;
    var sTargetAttribute = "O_G47_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_OEAUSGLEICHSBEHAELTER_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Radial verstärkte Abtriebswellenlagerung		O_G20_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00084	G20-Getriebe-Befest.-Welle
        MLFB_05_06_07_1FG1S	MLFB08_1FG1S	MLFB14_1FG1S	O_H1G_BIS_H7A_1FG1S	O_G20_1FG1S	HMK_VALUE_VALID_1FG1S

NN	VT_1FG1S_M00157	Datenblatttrigger G20

    */
    var O_H1G_BIS_H7A_1FG1S = ECL_GetValue("O_H1G_BIS_H7A_1FG1S");

    var sTable = "VT_1FG1S_M00084" + sDB_Suffix;
    var sTargetAttribute = "O_G20_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_VERSTAERKTE_LAGERUNG_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################

    // ################################################################################################################
    // Prüfbescheinigung (für bestellten Motor)		O_B02_1FG1S	
    // ################################################################################################################
    /*
    Kein Vorkommen in DTK-DB-Tabellen
    */

    // ################################################################################################################


    // ################################################################################################################
    // Haltebremse		UI_HALTEBREMSE_1FG1S	
    // ################################################################################################################
    /*
NN	VT_1FG1S_M00106	Gewicht-Bremse
    VT_1FG1S_M00108	K82-Bremse			<=== Keine Einschränkung in dieser Richtung!
        O_K82_1FG1S	UI_HALTEBREMSE_1FG1S

NN	VT_1FG1S_M00110	1FKM-MLFB15
NN	VT_1FG1S_M00153	Datenblatttrigger Haltebremse

    VT_1FG1S_M00211	TechDaten-Bremse
        MLFB10_11_1FG1S	MLFB13_1FG1S	UI_HALTEBREMSE_1FG1S	O_N30_BIS_N34_1006470	PMD_ABV478_001_000_1FG1S	
            PMD_ACE868_001_000_1006470	PMD_ACF397_001_000_1006470	PMD_ACJ797_001_000_1FG1S	PMD_ACE858_001_000_1FG1S	
            PMD_ACE859_001_000_1FG1S	PMD_ACF398_001_000_1FG1S
    */
    // Bremsenvorgabe aus SIZER:
    ECL_ActivateAllAttributeValues("UI_HALTEBREMSE_1FG1S");

    var ECSI_CX_MotorBrakeRequired = ECL_GetValue("ECSI_CX_MotorBrakeRequired");

    if (ECSI_CX_MotorBrakeRequired == "1") {
        ECL_DeactivateValue("UI_HALTEBREMSE_1FG1S", "OHNE");
    } else {
        ECL_DeactivateAllAttributeValues("UI_HALTEBREMSE_1FG1S");
        ECL_ActivateValue("UI_HALTEBREMSE_1FG1S", "OHNE");
        ECL_SetValue("UI_HALTEBREMSE_1FG1S", "OHNE");
    }

    var sTable = "VT_1FG1S_M00211" + sDB_Suffix;
    var sTargetAttribute = "UI_HALTEBREMSE_1FG1S";
    var sWhere = "MLFB10_11_1FG1S = '" + MLFB10_11_1FG1S + "' AND " +
        "MLFB13_1FG1S = '" + MLFB13_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_BREMSE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }



    // ################################################################################################################
    // Bremsmoment		PMD_ACF397_001_000_1006470	
    // ################################################################################################################
    /*
    NUR FÜR ARB-Bremse
    
    VT_1FG1S_M00211	TechDaten-Bremse
        MLFB10_11_1FG1S	MLFB13_1FG1S	UI_HALTEBREMSE_1FG1S	O_N30_BIS_N34_1006470	PMD_ABV478_001_000_1FG1S	PMD_ACE868_001_000_1006470	PMD_ACF397_001_000_1006470	PMD_ACJ797_001_000_1FG1S	PMD_ACE858_001_000_1FG1S	PMD_ACE859_001_000_1FG1S	PMD_ACF398_001_000_1FG1S
    */

    var UI_HALTEBREMSE_1FG1S = ECL_GetValue("UI_HALTEBREMSE_1FG1S");
    if (UI_HALTEBREMSE_1FG1S != "ARB") {
        ECL_DeactivateAttribute("PMD_ACF397_001_000_1006470");
        ECL_DeactivateAllAttributeValues("PMD_ACF397_001_000_1006470");
        ECL_ActivateValue("PMD_ACF397_001_000_1006470", "0");
        ECL_SetValue("PMD_ACF397_001_000_1006470", "0");

    }
    else {
        ECL_ActivateAttribute("PMD_ACF397_001_000_1006470");
        var sTable = "VT_1FG1S_M00211" + sDB_Suffix;
        var sTargetAttribute = "PMD_ACF397_001_000_1006470";
        var sWhere = "MLFB10_11_1FG1S = '" + MLFB10_11_1FG1S + "' AND " +
            "MLFB13_1FG1S = '" + MLFB13_1FG1S + "' AND " +
            "UI_HALTEBREMSE_1FG1S = '" + UI_HALTEBREMSE_1FG1S + "';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FG1___PLVT_BREMSMOMENT_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
    }

    // ################################################################################################################

    // ################################################################################################################
    // Optionen Federkraftbremse			O_N30_BIS_N34_1006470
    // ################################################################################################################
    /*
    VT_1FG1S_M00211	TechDaten-Bremse
        MLFB10_11_1FG1S	MLFB13_1FG1S	UI_HALTEBREMSE_1FG1S	O_N30_BIS_N34_1006470	PMD_ABV478_001_000_1FG1S	
            PMD_ACE868_001_000_1006470	PMD_ACF397_001_000_1006470	PMD_ACJ797_001_000_1FG1S	PMD_ACE858_001_000_1FG1S	
            PMD_ACE859_001_000_1FG1S	PMD_ACF398_001_000_1FG1S
    */
    // Wenn Federkraftbremse angewählt, dann Default Position Handlufthebel STD oben	// Handlufthebel nicht default, optional Bug 47291: 1FG1 Federdruckbremsen N3X, K82 Handlüfthebel, wählbare Stecker- und Handlüfthebellagen (Konfigurierbarkeit)
    /*if (strchangedAttribute == "UI_HALTEBREMSE_1FG1S"){
        var UI_HALTEBREMSE_1FG1S = ECL_GetValue("UI_HALTEBREMSE_1FG1S");
        if (UI_HALTEBREMSE_1FG1S == "ARB"){
            ECL_SetValue("O_K82_1FG1S", "K82");
            ECL_SetValue("O_Q94_Q95_Q96_1FG1S", "STANDARD");
        }
    }
    */
    /*
    Wenn Haltebremse == "ARB", bestimmen, welche KAG rein muss
    */
    if (UI_HALTEBREMSE_1FG1S == "ARB") {

        ECL_ActivateAttribute("PMD_ACF397_001_000_1006470");
        var PMD_ACF397_001_000_1006470 = ECL_GetValue("PMD_ACF397_001_000_1006470");

        var sTable = "VT_1FG1S_M00211" + sDB_Suffix;
        var sTargetAttribute = "O_N30_BIS_N34_1006470";
        var sWhere = "MLFB10_11_1FG1S = '" + MLFB10_11_1FG1S + "' AND " +
            "MLFB13_1FG1S = '" + MLFB13_1FG1S + "' AND " +
            "PMD_ACF397_001_000_1006470 = '" + PMD_ACF397_001_000_1006470 + "' AND " +
            "UI_HALTEBREMSE_1FG1S = '" + UI_HALTEBREMSE_1FG1S + "';";

        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FG1___PLVT_KAG_FEDERKRAFTBREMSE_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
    } else {
        ECL_ActivateValue("O_N30_BIS_N34_1006470", "NON");
        ECL_SetValue("O_N30_BIS_N34_1006470", "NON");

        ECL_ActivateValue("O_K82_1FG1S", "F");
        ECL_SetValue("O_K82_1FG1S", "F");

        ECL_ActivateValue("O_Q94_Q95_Q96_1FG1S", "OHNE");
        ECL_SetValue("O_Q94_Q95_Q96_1FG1S", "OHNE");

    }

    //Da durch disable nur 1 Wert verfügbar ist, muss alles verworfen werden
    var O_N30_BIS_N34_1006470 = ECL_GetValue("O_N30_BIS_N34_1006470");
    ECL_DeactivateAllAttributeValues("O_N30_BIS_N34_1006470");
    ECL_ActivateValue("O_N30_BIS_N34_1006470", O_N30_BIS_N34_1006470);
    ECL_SelectValue("O_N30_BIS_N34_1006470", O_N30_BIS_N34_1006470);

    // ################################################################################################################
    // Handlüftung (nur bei Arbeitsbremse)		O_K82_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00108	K82-Bremse
        O_K82_1FG1S	UI_HALTEBREMSE_1FG1S
        
    VT_1FG1S_M00160	MLFB10-Q91-To-Q96-K82
        O_Q91_Q92_Q93_1FG1S	O_Q94_Q95_Q96_1FG1S		MLFB10_1FG1S	O_K82_1FG1S		HMK_VALUE_VALID_1FG1S
    */
    var UI_HALTEBREMSE_1FG1S = ECL_GetValue("UI_HALTEBREMSE_1FG1S");

    var sTable = "VT_1FG1S_M00108" + sDB_Suffix;
    var sTargetAttribute = "O_K82_1FG1S";
    var sWhere = "UI_HALTEBREMSE_1FG1S = '" + UI_HALTEBREMSE_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_HANDLUEFTUNG_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ---------------------------------------------------------------------------------------------------------------
    var O_Q91_Q92_Q93_1FG1S = ECL_GetValue("O_Q91_Q92_Q93_1FG1S");
    //var O_Q94_Q95_Q96_1FG1S = ECL_GetValue("O_Q94_Q95_Q96_1FG1S");

    var sTable = "VT_1FG1S_M00160" + sDB_Suffix;
    var sTargetAttribute = "O_K82_1FG1S";
    var sWhere = "O_Q91_Q92_Q93_1FG1S = '" + O_Q91_Q92_Q93_1FG1S + "' AND " +
        //"O_Q94_Q95_Q96_1FG1S = '" + O_Q94_Q95_Q96_1FG1S + "' AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_HANDLUEFTUNG_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // ################################################################################################################
    var TestK82 = ECL_GetAllActiveAttributeValues("O_K82_1FG1S");

    if (strchangedAttribute == "UI_O_K82_1FG1S") {
        var O_K82_1FG1S = ECL_GetValue("O_K82_1FG1S");
        if (O_K82_1FG1S == "K82") {
            ECL_SetValue("O_Q94_Q95_Q96_1FG1S", "STANDARD");
        }
    }
    // ################################################################################################################
    // Positionierung des Handlüfthebels		O_Q94_Q95_Q96_1FG1S	
    // ################################################################################################################
    /*
    VT_1FG1S_M00160	MLFB10-Q91-To-Q96-K82
        O_Q91_Q92_Q93_1FG1S	O_Q94_Q95_Q96_1FG1S	MLFB10_1FG1S	O_K82_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    var O_Q91_Q92_Q93_1FG1S = ECL_GetValue("O_Q91_Q92_Q93_1FG1S");
    var O_K82_1FG1S = ECL_GetValue("O_K82_1FG1S");
    var aO_K82_1FG1S = ECL_GetAllActiveAttributeValues("O_K82_1FG1S");

    var sWhereK82 = "(O_K82_1FG1S = '" + aO_K82_1FG1S[0] + "'";

    if (aO_K82_1FG1S.length > 1) {
        for (var i = 1; i < aO_K82_1FG1S.length; i++) {
            sWhereK82 = sWhereK82 + " OR O_K82_1FG1S = '" + aO_K82_1FG1S[i] + "'";
        }
    }

    var sTable = "VT_1FG1S_M00160" + sDB_Suffix;
    var sTargetAttribute = "O_Q94_Q95_Q96_1FG1S";
    var sWhere = "O_Q91_Q92_Q93_1FG1S = '" + O_Q91_Q92_Q93_1FG1S + "' AND " +
        "O_K82_1FG1S = '" + O_K82_1FG1S + "' AND " +
        //sWhereK82 + ") AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_HANDLUEFTUNG_POS_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }

    // Setze K82
    var O_Q94_Q95_Q96_1FG1S = ECL_GetValue("O_Q94_Q95_Q96_1FG1S");
    if (O_Q94_Q95_Q96_1FG1S == "OHNE") {
        ECL_SetValue("O_K82_1FG1S", "F");
    } else { // STANDARD, Q94, Q95, Q96
        ECL_SetValue("O_K82_1FG1S", "K82");
    }
    // ################################################################################################################


    // ################################################################################################################
    // Kundenangabe auf dem Leistungsschild		O_Y84_1FG1S
    // ################################################################################################################
    /*
    Kein Vorkommen in DTK-DB-Tabellen
    */

    // ################################################################################################################


    // ################################################################################################################
    // Kundenangabe auf dem Leistungsschild (Textfeld)		O_Y84_TEXT_1FG1S
    // ################################################################################################################
    /*
    Wenn KAG, einblenden, sonst ausblenden
    * / 
    var O_Y84_1FG1S = ECL_GetValue("O_Y84_1FG1S");
    if (O_Y84_1FG1S == "Y84"){
        ECL_ActivateAttribute("O_Y84_TEXT_1FG1S");
    }else{
        ECL_DeactivateAttribute("O_Y84_TEXT_1FG1S");
    }
    if (strchangedAttribute == "O_Y84_TEXT_1FG1S"){
        var bOK = normalizeOE_Attribute("O_Y84_TEXT_1FG1S");
    }
    */
    var aValidValues = ECL_GetAllActiveAttributeValues("O_Y84_1FG1S");	// test
    if (ECL_ValueEnabled("O_Y84_1FG1S", "Y84")) {
        ECL_ActivateAttribute("O_Y84_TEXT_1FG1S");
    } else {
        ECL_DeactivateAttribute("O_Y84_TEXT_1FG1S");
    }

    if (strchangedAttribute == "O_Y84_TEXT_1FG1S") {
        var sValueNorm = normalizeOE_Attribute("O_Y84_TEXT_1FG1S");
        if (sValueNorm == "") {
            ECL_SetValue("O_Y84_1FG1S", "F");
        } else {
            ECL_SetValue("O_Y84_1FG1S", "Y84");
        }
    }
    // ################################################################################################################


    // ################################################################################################################
    // Ausführung für erhöhte chemische Beständigkeit		O_N16_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00149	N16-K23-K24
        O_N16_1FG1S	HMK_FARBAUSFUEHRUNG_1FG1S
    
    VT_1FG1S_M00161	N16-MLFB09-09-14
        MLFB08_1FG1S	MLFB09_1FG1S	MLFB14_1FG1S	O_N16_1FG1S

    */
    var sTable = "VT_1FG1S_M00161" + sDB_Suffix;
    var sTargetAttribute = "O_N16_1FG1S";
    var sWhere = "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
        "MLFB09_1FG1S = '" + MLFB09_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_AUSF_CHEM_BEST_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var HMK_FARBAUSFUEHRUNG_1FG1S = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FG1S");

    var sTable = "VT_1FG1S_M00149" + sDB_Suffix;
    var sTargetAttribute = "O_N16_1FG1S";
    var sWhere = "HMK_FARBAUSFUEHRUNG_1FG1S = '" + HMK_FARBAUSFUEHRUNG_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_AUSF_CHEM_BEST_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################


    // ################################################################################################################
    // Spielreduzierte Ausführung		O_G99_1FG1S
    // ################################################################################################################
    /*
    A: VT_1FG1S_M00083	G99-Getriebe
        MLFB_05_06_07_1FG1S	O_G99_1FG1S

    VT_1FG1S_M00140	G97-G99		<=== über Regel, damit Umwahl möglich bleibt
        O_G97_1FG1S	O_G99_1FG1S
    */
    var sTable = "VT_1FG1S_M00083" + sDB_Suffix;
    var sTargetAttribute = "O_G99_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_SPIELREDUZIERT_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    if (strchangedAttribute == "UI_O_G99_1FG1S") {

        var O_G99_1FG1S = ECL_GetValue("O_G99_1FG1S");
        if (O_G99_1FG1S == "G99") {
            ECL_SetValue("O_G97_1FG1S", "F");
            //ECL_DeactivateValue("O_G97_1FG1S", "G97");
        }
    }
    // ################################################################################################################


    // ################################################################################################################
    // Geklebtes Endstufenrad			O_G97_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00140	G97-G99		<=== über Regel, damit Umwahl möglich bleibt
        O_G97_1FG1S	O_G99_1FG1S

    A: VT_1FG1S_M00141	G97-Getriebe
        MLFB_05_06_07_1FG1S	O_G97_1FG1S


    */
    var O_G99_1FG1S = ECL_GetValue("O_G99_1FG1S");

    var sTable = "VT_1FG1S_M00140" + sDB_Suffix;
    var sTargetAttribute = "O_G97_1FG1S";
    var sWhere = "O_G99_1FG1S = '" + O_G99_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_ENDSTUFENRAD_GEKLEBT_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------

    var sTable = "VT_1FG1S_M00141" + sDB_Suffix;
    var sTargetAttribute = "O_G97_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_ENDSTUFENRAD_GEKLEBT_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    if (strchangedAttribute == "UI_O_G97_1FG1S") {
        var O_G97_1FG1S = ECL_GetValue("O_G97_1FG1S");
        if (O_G97_1FG1S == "G97") {
            ECL_SetValue("O_G99_1FG1S", "F");
            ECL_DeactivateValue("O_G99_1FG1S", "G99");
        } else {
            ECL_ActivateValue("O_G99_1FG1S", "G99");
        }

    }
    // ################################################################################################################



    // ################################################################################################################
    // Schutzhaube			O_G60_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00231	G60-Getriebe
        MLFB_05_06_07_1FG1S     O_G60_1FG1S
    if (MLFB05 == (3 or 4))
        VT_1FG1S_M00233	G60 Getriebe, MLFB8;10Welle
            MLFB_05_06_07_1FG1S     MLFB08_1FG1S    MLFB10_1FG1S    O_H1G_BIS_H7A_1FG1S    O_G60_1FG1S
    if (MLFB05 == (5 or 6))
        VT_1FG1S_M00234	G60 Getriebe, MLFB8;14Welle
            MLFB_05_06_07_1FG1S     MLFB08_1FG1S    MLFB14_1FG1S    O_H1G_BIS_H7A_1FG1S    O_G60_1FG1S
    if (O_G60_1FG1S == "G60") only for G60, no values for without
        VT_1FG1S_M00237	G60+Welle vs. RUMPF_567_8_10_14
            MLFB_05_06_07_1FG1S     MLFB08_1FG1S    MLFB10_1FG1S    MLFB14_1FG1S    O_H1G_BIS_H7A_1FG1S     O_G60_1FG1S

    VT_1FG1S_M00238	WellenTyp_G60
        PMD_ABV414_001_000_1FG1S    O_G60_1FG1S
    
    */
    var sTargetAttribute = "O_G60_1FG1S";
    // ----------------------------------------------------------------------------------------------------------------

    var sTable = "VT_1FG1S_M00231" + sDB_Suffix;
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_SCHUTZHAUBE_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var O_H1G_BIS_H7A_1FG1S = ECL_GetValue("O_H1G_BIS_H7A_1FG1S");

    var sTable = "VT_1FG1S_M00237" + sDB_Suffix;
    var sSQL = "SELECT O_G60_1FG1S FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "' AND " +
        "O_G60_1FG1S = 'G60';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length < 1) {
        ECL_DeactivateValue("O_G60_1FG1S", "G60");
    }
    // ----------------------------------------------------------------------------------------------------------------

    if (MLFB05_1FG1S == "3" || MLFB05_1FG1S == "4") {
        var sTable = "VT_1FG1S_M00233" + sDB_Suffix;
        var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
            "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
            "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
            "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FG1___PLVT_SCHUTZHAUBE_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
    }
    // ----------------------------------------------------------------------------------------------------------------
    if (MLFB05_1FG1S == "5" || MLFB05_1FG1S == "6") {
        var sTable = "VT_1FG1S_M00234" + sDB_Suffix;
        var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
            "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
            "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
            "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "';";

        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

        if (sStatus == "Error") {
            strError = "DICT1_ERR_1FG1___PLVT_SCHUTZHAUBE_LOGIKFEHLER_NO_DB_RESULT";
            return strError;
        }
    }

    // ################################################################################################################
    var O_G60_1FG1S = ECL_GetValue("O_G60_1FG1S");

    // ################################################################################################################
    // Motor Schnellieferservice - Fast lane		O_W50_1FG1S
    // ################################################################################################################
    /*
    VT_1FG1S_M00169	W50-Getriebe-Befestigung
        MLFB_05_06_07_1FG1S	MLFB14_1FG1S	O_W50_1FG1S	HMK_VALUE_VALID_1FG1S

    VT_1FG1S_M00170	W50-Wellenausführung
        O_H1G_BIS_H7A_1FG1S	O_W50_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    var sTable = "VT_1FG1S_M00169" + sDB_Suffix;
    var sTargetAttribute = "O_W50_1FG1S";
    var sWhere = "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_FASTLANE_W50_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    var O_H1G_BIS_H7A_1FG1S = ECL_GetValue("O_H1G_BIS_H7A_1FG1S");

    var sTable = "VT_1FG1S_M00170" + sDB_Suffix;
    var sTargetAttribute = "O_W50_1FG1S";
    var sWhere = "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T';";

    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
        strError = "DICT1_ERR_1FG1___PLVT_FASTLANE_W50_LOGIKFEHLER_NO_DB_RESULT";
        return strError;
    }


    /*
    // nicht mit sonderwellen, nicht mit Fuß/Flansch
    var O_H1G_BIS_H7A_1FG1S = ECL_GetValue("O_H1G_BIS_H7A_1FG1S");
    var PMD_ABV672_001_000_1FG1S = ECL_GetValue("PMD_ABV672_001_000_1FG1S"); // Art der Befestigung
    
    if (O_H1G_BIS_H7A_1FG1S == "STD" && PMD_ABV672_001_000_1FG1S != "FU_FL"){
        ECL_ActivateValue("O_W50_1FG1S", "W50");
    }else{
        ECL_DeactivateValue("O_W50_1FG1S", "W50");
        ECL_ActivateValue("O_W50_1FG1S", "F");
    }
    */
    // ################################################################################################################


    return "OK";

}
