//@legacy
//#mode(full-ecma)



//@import "VT_1FG1.js"


/*
Checkroutinen ergänzt für Keep Konfiguration
*/

function SetSchmierung_Init(oData) {
    if (oData && !isEmpty(oData)) {
        Bestimme_Oelsorte(oData); 	 		// O_K06_K07_K08_K11_1FG1S	Ölsorte
        Bestimme_Wellendichtung(oData); 	// O_G23_G24_1FG1S			Abtriebswellenabdichtung
        Bestimme_Oelschauglas(oData);		// O_G34_1FG1S				Ölschauglas
        Bestimme_Ablassschraube(oData);		// O_G53_1FG1S				Ölablassschraube magnetisch
        Bestimme_Ausgleichsbehaelter(oData);	// O_G47_1FG1S			Ölausgleichsbehälter
    } else {
        ExecSetStandardifValueEmpty("O_K06_K07_K08_K11_1FG1S", "K06");
        ExecSetStandardifValueEmpty("O_G23_G24_1FG1S", "NON");
        ExecSetStandardifValueEmpty("O_G34_1FG1S", "F");
        ExecSetStandardifValueEmpty("O_G53_1FG1S", "F");
        ExecSetStandardifValueEmpty("O_G47_1FG1S", "F");
    }
}

function SetSchmierung(strchangedAttribute, oData) {
}

/**
*/
function Bestimme_Oelsorte(oData) {
    // O_K06_K07_K08_K11_1FG1S
    // KAG: K06, K07, K08, K11, K12
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_K06_K07_K08_K11_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (sKAG != "NON") {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkOelsorte(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, Default setzen
    else {
        var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
        var O_G23_G24_1FG1S = ECL_GetValue("O_G23_G24_1FG1S");

        var sTable = "VT_1FG1S_M00087" + sDB_Suffix;
        var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
            "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "';";// AND " +
        //"O_G23_G24_1FG1S = '" + O_G23_G24_1FG1S + "';";

        var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
        if (aResult.length > 0) {
            O_K06_K07_K08_K11_1FG1S = aResult[0].O_K06_K07_K08_K11_1FG1S;
            ECL_ActivateValue("O_K06_K07_K08_K11_1FG1S", O_K06_K07_K08_K11_1FG1S);
            ECL_SetValue("O_K06_K07_K08_K11_1FG1S", O_K06_K07_K08_K11_1FG1S);
        }
        else {
            ECL_ActivateValue(sTargetAttribute, "K06");
            ECL_SetValue(sTargetAttribute, "K06");
        }
    }
}
function checkOelsorte(oData, sTargetAttribute, sKAG) {
    /*
    VT_1FG1S_M00087
    MLFB_05_06_07_1FG1S	O_G23_G24_1FG1S	O_K06_K07_K08_K11_1FG1S
    */
    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
    //var O_G23_G24_1FG1S = ECL_GetValue("O_G23_G24_1FG1S");

    var sTable = "VT_1FG1S_M00087" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        //"O_G23_G24_1FG1S = '" + O_G23_G24_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;

}
// #################################################################################################################
function Bestimme_Wellendichtung(oData) {

    // O_G23_G24_1FG1S
    // KAG: NON, G23, G24
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_G23_G24_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (sKAG != "NON") {
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkWellendichtung(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, Standard (NON) setzen
    else {
        var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
        var O_K06_K07_K08_K11_1FG1S = ECL_GetValue("O_K06_K07_K08_K11_1FG1S");

        var sTable = "VT_1FG1S_M00087" + sDB_Suffix;
        var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
            "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
            "O_K06_K07_K08_K11_1FG1S = '" + O_K06_K07_K08_K11_1FG1S + "';";

        var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
        if (aResult.length > 0) {
            var O_G23_G24_1FG1S = aResult[0].O_G23_G24_1FG1S;
            for (var i = 0; i < aResult.length; i++) {
                ;
                if (aResult[i].O_G23_G24_1FG1S == "NON") {
                    O_G23_G24_1FG1S = "NON";
                    break;
                }
            }
            //O_G23_G24_1FG1S = aResult[0].O_G23_G24_1FG1S;
            ECL_ActivateValue(sTargetAttribute, O_G23_G24_1FG1S);
            ECL_SetValue(sTargetAttribute, O_G23_G24_1FG1S);
        }
        else {
            ECL_ActivateValue(sTargetAttribute, "NON");
            ECL_SetValue(sTargetAttribute, "NON");
        }
    }
}
function checkWellendichtung(oData, sTargetAttribute, sKAG) {
    /*
    VT_1FG1S_M00087
    MLFB_05_06_07_1FG1S	O_G23_G24_1FG1S	O_K06_K07_K08_K11_1FG1S
    */
    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
    var O_K06_K07_K08_K11_1FG1S = ECL_GetValue("O_K06_K07_K08_K11_1FG1S");

    var sTable = "VT_1FG1S_M00087" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "O_K06_K07_K08_K11_1FG1S = '" + O_K06_K07_K08_K11_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    /*
    VT_1FG1S_M00245	Rumpf567_Wellenausf_Durchm_G23/G24
        MLFB_05_06_07_1FG1S PMD_ABV414_001_000_1FG1S    H_WELLEN_DURCHM_1FG1S   O_G23_G24_1FG1S
    */
    var PMD_ABV414_001_000_1FG1S = ECL_GetValue("PMD_ABV414_001_000_1FG1S");
    var H_WELLEN_DURCHM_1FG1S = ECL_GetValue("H_WELLEN_DURCHM_1FG1S");

    var sTable = "VT_1FG1S_M00245" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "PMD_ABV414_001_000_1FG1S = '" + PMD_ABV414_001_000_1FG1S + "' AND " +
        //"H_WELLEN_DURCHM_1FG1S = '" + H_WELLEN_DURCHM_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;

}
// #################################################################################################################
// O_G34_1FG1S				Ölschauglas
function Bestimme_Oelschauglas(oData) {
    // O_G34_1FG1S
    // KAG: G34, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_G34_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "G34"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    // Wenn Schrägeinbaulage, dann kein Ölschauglas zulässig:
    if (ECL_GetValue("O_E01_BIS_E37_1FG1S") == "NON") {

        if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
            // es gibt eine KAG, also prüfen, ob erlaubt
            bCheck = checkOelschauglas(oData, sTargetAttribute, sKAG);
        }
    }// else bCheck = false
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkOelschauglas(oData, sTargetAttribute, sKAG) {
    /* 	VT_1FG1S_M00080	G34-Getriebe
            MLFB_05_06_07_1FG1S	O_G34_1FG1S
        
        VT_1FG1S_M00124	G34<>E01-E57
            O_G34_1FG1S	O_E01_BIS_E37_1FG1S
        Kein Ölschauglas bei Schrägeinbaulagen --> oben abgeprüft
    */

    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;

    var sTable = "VT_1FG1S_M00080" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

// #################################################################################################################
// O_G53_1FG1S				Ölablassschraube magnetisch
function Bestimme_Ablassschraube(oData) {
    // O_G53_1FG1S
    // KAG: G53, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_G53_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "G53"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkAblassschraube(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkAblassschraube(oData, sTargetAttribute, sKAG) {
    /* 
    VT	VT_1FG1S_M00174	G53-Getriebe +Anbauart,Einbaulg+Schräglg
        MLFB_05_06_07_1FG1S	MLFB14_1FG1S	HMK_AAA566_KOMBI_1FG1S	O_G53_1FG1S	HMK_E01_E37_KOMBI_1FG1S	HMK_VALUE_VALID_1FG1S
    */
    // ---------------------------------------------------------------------------------------------------------------------------------------------
    // Gültige Einbaulagen (Kombi-Attribut)
    var sWhere_HMK_AAA566_KOMBI = "";	// mehrere gültig, ValidValues schränken ein, nicht einzelwert!
    var aValidValues_AAA566_KOMBI = ECL_GetAllActiveAttributeValues("HMK_AAA566_KOMBI_1FG1S") || [];

    if (aValidValues_AAA566_KOMBI.length == 0) {
        strError = "DICT1_ERR_1FG1___PLVT_NO_VALID_VALUES_AAA566";
        return strError;
    }

    var sWhere_HMK_AAA566_KOMBI = "(HMK_AAA566_KOMBI_1FG1S = '" + aValidValues_AAA566_KOMBI[0] + "'";

    if (aValidValues_AAA566_KOMBI.length > 1) {

        for (var i = 1; i < aValidValues_AAA566_KOMBI.length; i++) {

            sWhere_HMK_AAA566_KOMBI = sWhere_HMK_AAA566_KOMBI + " OR " + "HMK_AAA566_KOMBI_1FG1S = '" + aValidValues_AAA566_KOMBI[i] + "'";
        }
    }
    sWhere_HMK_AAA566_KOMBI = sWhere_HMK_AAA566_KOMBI + ")";
    // ---------------------------------------------------------------------------------------------------------------------------------------------
    // Gültige Schrägeinbaulagen (Kombi-Attribut)
    var sWhere_HMK_E01_E37_KOMBI = "";	// mehrere gültig, ValidValues schränken ein, nicht einzelwert!
    var aValidValues_E01_E37_KOMBI = ECL_GetAllActiveAttributeValues("HMK_E01_E37_KOMBI_1FG1S") || [];

    if (aValidValues_E01_E37_KOMBI.length == 0) {
        strError = "DICT1_ERR_1FG1___PLVT_NO_VALID_VALUES_E01_E37";
        return strError;
    }

    var sWhere_HMK_E01_E37_KOMBI = "(HMK_E01_E37_KOMBI_1FG1S = '" + aValidValues_E01_E37_KOMBI[0] + "'";

    if (aValidValues_E01_E37_KOMBI.length > 1) {

        for (var i = 1; i < aValidValues_E01_E37_KOMBI.length; i++) {

            sWhere_HMK_E01_E37_KOMBI = sWhere_HMK_E01_E37_KOMBI + " OR " + "HMK_E01_E37_KOMBI_1FG1S = '" + aValidValues_E01_E37_KOMBI[i] + "'";
        }
    }
    sWhere_HMK_E01_E37_KOMBI = sWhere_HMK_E01_E37_KOMBI + ")";
    // ---------------------------------------------------------------------------------------------------------------------------------------------
    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
    var MLFB14_1FG1S = oData.oParsingData.MLFB.POS14;

    var sTable = "VT_1FG1S_M00174" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        sWhere_HMK_AAA566_KOMBI + " AND " +
        sWhere_HMK_E01_E37_KOMBI + " AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

// #################################################################################################################
// O_G47_1FG1S			Ölausgleichsbehälter
function Bestimme_Ausgleichsbehaelter(oData) {
    // O_G47_1FG1S
    // KAG: G47, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_G47_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "G47"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkAusgleichsbehaelter(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkAusgleichsbehaelter(oData, sTargetAttribute, sKAG) {
    /* 	VT_1FG1S_M00177	G47-Getriebe,AH
            MLFB_05_06_07_1FG1S	MLFB10_1FG1S	O_G47_1FG1S	HMK_VALUE_VALID_1FG1S
    */

    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
    var MLFB10_1FG1S = oData.oParsingData.MLFB.POS10;

    var sTable = "VT_1FG1S_M00177" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}