//@legacy
//#mode(full-ecma)



//@import "VT_1FG1.js"


/*
Checkroutinen ergänzt für Keep Konfiguration
*/

function SetSonstiges_Init(oData) {
    if (oData && !isEmpty(oData)) {
        Bestimme_Lagerung(oData); 	 		// O_G20_1FG1S		Radial verstärkte Abtriebswellenlagerung
        Bestimme_Pruefbescheinigung(oData); // O_B02_1FG1S	Prüfbescheinigung (für bestellten Motor)
        Bestimme_Kundenangabe_Leistungsschild(oData);		// O_Y84_1FG1S		Kundenangabe auf dem Leistungsschild
        Bestimme_ChemBest(oData);		// O_N16_1FG1S		Ausführung für erhöhte chemische Beständigkeit
        Bestimme_Spielreduziert(oData);	// O_G99_1FG1S		Spielreduzierte Ausführung
        Bestimme_EndstufenradGeklebt(oData);	// O_G97_1FG1S		Geklebtes Endstufenrad
        Bestimme_Schutzhaube(oData);	// O_G60_1FG1S		Schutzhaube
        Bestimme_FastLane(oData);	// O_W50_1FG1S		Motor Schnellieferservice - Fast lane
    } else {
        ExecSetStandardifValueEmpty("O_G20_1FG1S", "F");
        ExecSetStandardifValueEmpty("O_B02_1FG1S", "F");
        ExecSetStandardifValueEmpty("O_Y84_1FG1S", "F");
        ExecSetStandardifValueEmpty("O_N16_1FG1S", "F");
        ExecSetStandardifValueEmpty("O_G99_1FG1S", "F");
        ExecSetStandardifValueEmpty("O_G97_1FG1S", "F");
        ExecSetStandardifValueEmpty("O_G60_1FG1S", "F");
        ExecSetStandardifValueEmpty("O_W50_1FG1S", "F");
    }
}

function SetSonstiges(strchangedAttribute, oData) {
}

/**
    // O_G20_1FG1S		Radial verstärkte Abtriebswellenlagerung
*/
function Bestimme_Lagerung(oData) {
    // O_G20_1FG1S
    // KAG: G20, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_G20_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "G20"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkLagerung(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkLagerung(oData, sTargetAttribute, sKAG) {
    /* 	VT_1FG1S_M00084	G20-Getriebe-Befest.-Welle
            MLFB_05_06_07_1FG1S	MLFB08_1FG1S	MLFB14_1FG1S	O_H1G_BIS_H7A_1FG1S	O_G20_1FG1S	HMK_VALUE_VALID_1FG1S

        n.n. VT_1FG1S_M00157	Datenblatttrigger G20
    */

    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
    var MLFB08_1FG1S = oData.oParsingData.MLFB.POS8;
    var MLFB14_1FG1S = oData.oParsingData.MLFB.POS14;
    var O_H1G_BIS_H7A_1FG1S = ECL_GetValue("O_H1G_BIS_H7A_1FG1S");

    var sTable = "VT_1FG1S_M00084" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

// #################################################################################################################
// O_B02_1FG1S	Prüfbescheinigung (für bestellten Motor)
function Bestimme_Pruefbescheinigung(oData) {
    // O_B02_1FG1S
    // KAG: B02, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_B02_1FG1S";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "B02"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}

// #################################################################################################################
// O_Y84_1FG1S		Kundenangabe auf dem Leistungsschild
function Bestimme_Kundenangabe_Leistungsschild(oData) {
    // O_Y84_1FG1S
    // KAG: Y84, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_Y84_1FG1S";

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Y84"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {
        // es gibt eine KAG, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
        // Freitext wird im Parser-Skript gesetzt
    }
    // wenn keine KAG, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}


// #################################################################################################################
// O_N16_1FG1S		Ausführung für erhöhte chemische Beständigkeit
function Bestimme_ChemBest(oData) {

    // O_N16_1FG1S
    // KAG: N16, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_N16_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "N16"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkChemBest(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkChemBest(oData, sTargetAttribute, sKAG) {
    /* 	VT_1FG1S_M00149	N16-K23-K24
            O_N16_1FG1S	HMK_FARBAUSFUEHRUNG_1FG1S
        VT_1FG1S_M00161	N16-MLFB09-09-14
            MLFB08_1FG1S	MLFB09_1FG1S	MLFB14_1FG1S	O_N16_1FG1S
    */

    var HMK_FARBAUSFUEHRUNG_1FG1S = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1FG1S");

    var sTable = "VT_1FG1S_M00149" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_FARBAUSFUEHRUNG_1FG1S = '" + HMK_FARBAUSFUEHRUNG_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var MLFB08_1FG1S = oData.oParsingData.MLFB.POS8;
    var MLFB09_1FG1S = oData.oParsingData.MLFB.POS9;
    var MLFB14_1FG1S = oData.oParsingData.MLFB.POS14;

    var sTable = "VT_1FG1S_M00161" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
        "MLFB09_1FG1S = '" + MLFB09_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

// #################################################################################################################
// O_G99_1FG1S		Spielreduzierte Ausführung
function Bestimme_Spielreduziert(oData) {
    // O_G99_1FG1S
    // KAG: G99, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_G99_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "G99"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkSpielreduziert(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkSpielreduziert(oData, sTargetAttribute, sKAG) {
    /* 	VT_1FG1S_M00083	G99-Getriebe
            MLFB_05_06_07_1FG1S	O_G99_1FG1S

        VT_1FG1S_M00140	G97-G99
            O_G97_1FG1S	O_G99_1FG1S

    */
    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;

    var sTable = "VT_1FG1S_M00083" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var O_G97_1FG1S = ECL_GetValue("O_G97_1FG1S");

    var sTable = "VT_1FG1S_M00140" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_G97_1FG1S = '" + O_G97_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

// #################################################################################################################
// O_G97_1FG1S		Geklebtes Endstufenrad
function Bestimme_EndstufenradGeklebt(oData) {
    // O_G97_1FG1S
    // KAG: G97, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_G97_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "G97"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkEndstufenradGeklebt(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkEndstufenradGeklebt(oData, sTargetAttribute, sKAG) {
    /* 	VT_1FG1S_M00140	G97-G99
            O_G97_1FG1S	O_G99_1FG1S
        VT_1FG1S_M00141	G97-Getriebe
            MLFB_05_06_07_1FG1S	O_G97_1FG1S

    */

    var O_G99_1FG1S = ECL_GetValue("O_G99_1FG1S");

    var sTable = "VT_1FG1S_M00140" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_G99_1FG1S = '" + O_G99_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;

    var sTable = "VT_1FG1S_M00141" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

// #################################################################################################################
// O_G60_1FG1S		Schutzhaube
function Bestimme_Schutzhaube(oData) {
    // O_G60_1FG1S
    // KAG: G60, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_G60_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "G60"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkSchutzhaube(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkSchutzhaube(oData, sTargetAttribute, sKAG) {
    /* 	
    VT_1FG1S_M00231	G60-Getriebe
        MLFB_05_06_07_1FG1S     O_G60_1FG1S
    if (MLFB05 == (3 or 4))
        VT_1FG1S_M00233	G60 Getriebe, MLFB8;10Welle
            MLFB_05_06_07_1FG1S     MLFB08_1FG1S    MLFB10_1FG1S    O_H1G_BIS_H7A_1FG1S    O_G60_1FG1S
    if (MLFB05 == (5 or 6))
        VT_1FG1S_M00234	G60 Getriebe, MLFB8;14Welle
            MLFB_05_06_07_1FG1S     MLFB08_1FG1S    MLFB14_1FG1S    O_H1G_BIS_H7A_1FG1S    O_G60_1FG1S
    if (O_G60_1FG1S == "G60") only for G60, no values for without
        VT_1FG1S_M00237	G60+Welle vs. RUMPF_567_8_10_14
            MLFB_05_06_07_1FG1S     MLFB08_1FG1S    MLFB10_1FG1S    MLFB14_1FG1S    O_H1G_BIS_H7A_1FG1S     O_G60_1FG1S
        
    VT_1FG1S_M00238	WellenTyp_G60
        PMD_ABV414_001_000_1FG1S    O_G60_1FG1S
    */
    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;

    var sTable = "VT_1FG1S_M00231" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }

    //--------------------------------------------------------------------------------------------------------------
    var MLFB05_1FG1S = oData.oParsingData.MLFB.POS5;
    var MLFB08_1FG1S = oData.oParsingData.MLFB.POS8;
    var MLFB10_1FG1S = oData.oParsingData.MLFB.POS10;
    var MLFB14_1FG1S = oData.oParsingData.MLFB.POS14;
    var O_H1G_BIS_H7A_1FG1S = ECL_GetValue("O_H1G_BIS_H7A_1FG1S");
    /* if (MLFB05 == (3 or 4))
        VT_1FG1S_M00233	G60 Getriebe, MLFB8;10Welle
            MLFB_05_06_07_1FG1S     MLFB08_1FG1S    MLFB10_1FG1S    O_H1G_BIS_H7A_1FG1S    O_G60_1FG1S
    */
    if (MLFB05_1FG1S == "3" || MLFB05_1FG1S == "4") {
        var sTable = "VT_1FG1S_M00233" + sDB_Suffix;
        var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
            "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
            "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
            "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
            "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "' AND " +
            sTargetAttribute + " = '" + sKAG + "';";

        var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
        if (aResult.length < 1) {
            return 0;
        }
    }
    //--------------------------------------------------------------------------------------------------------------
    /* if (MLFB05 == (5 or 6))
        VT_1FG1S_M00234	G60 Getriebe, MLFB8;14Welle
            MLFB_05_06_07_1FG1S     MLFB08_1FG1S    MLFB14_1FG1S    O_H1G_BIS_H7A_1FG1S    O_G60_1FG1S
    */
    if (MLFB05_1FG1S == "5" || MLFB05_1FG1S == "6") {
        var sTable = "VT_1FG1S_M00234" + sDB_Suffix;
        var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
            "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
            "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
            "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
            "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "' AND " +
            sTargetAttribute + " = '" + sKAG + "';";

        var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
        if (aResult.length < 1) {
            return 0;
        }
    }

    //--------------------------------------------------------------------------------------------------------------
    /* if (O_G60_1FG1S == "G60") only for G60, no values for without
        VT_1FG1S_M00237	G60+Welle vs. RUMPF_567_8_10_14
            MLFB_05_06_07_1FG1S     MLFB08_1FG1S    MLFB10_1FG1S    MLFB14_1FG1S    O_H1G_BIS_H7A_1FG1S     O_G60_1FG1S
    */
    var sTable = "VT_1FG1S_M00237" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB08_1FG1S = '" + MLFB08_1FG1S + "' AND " +
        "MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var PMD_ABV414_001_000_1FG1S = ECL_GetValue("PMD_ABV414_001_000_1FG1S");

    var sTable = "VT_1FG1S_M00238" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "PMD_ABV414_001_000_1FG1S = '" + PMD_ABV414_001_000_1FG1S + "' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

// #################################################################################################################
// O_W50_1FG1S		Motor Schnellieferservice - Fast lane
function Bestimme_FastLane(oData) {
    // O_W50_1FG1S
    // KAG: W50, F
    var parseObj = oData.oParsingData;

    var sTargetAttribute = "O_W50_1FG1S";
    var bCheck = false;

    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "W50"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);

    if (parseObj.MLFB.KAG.indexOf(sKAG) > -1) {	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkFastLane(oData, sTargetAttribute, sKAG);
    }
    if (bCheck) {
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else {
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkFastLane(oData, sTargetAttribute, sKAG) {
    /* 	
    VT_1FG1S_M00169	W50-Getriebe-Befestigung
        MLFB_05_06_07_1FG1S	MLFB14_1FG1S	O_W50_1FG1S	HMK_VALUE_VALID_1FG1S

    VT_1FG1S_M00170	W50-Wellenausführung
        O_H1G_BIS_H7A_1FG1S	O_W50_1FG1S	HMK_VALUE_VALID_1FG1S
    */

    var MLFB_05_06_07_1FG1S = oData.oParsingData.GETR_BG_5_7;
    var MLFB14_1FG1S = oData.oParsingData.MLFB.POS14;

    var sTable = "VT_1FG1S_M00169" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_05_06_07_1FG1S = '" + MLFB_05_06_07_1FG1S + "' AND " +
        "MLFB14_1FG1S = '" + MLFB14_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var O_H1G_BIS_H7A_1FG1S = ECL_GetValue("O_H1G_BIS_H7A_1FG1S");;

    var sTable = "VT_1FG1S_M00170" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "O_H1G_BIS_H7A_1FG1S = '" + O_H1G_BIS_H7A_1FG1S + "' AND " +
        "HMK_VALUE_VALID_1FG1S = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG_" + sKAG);
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

// #################################################################################################################


