//@legacy
//#mode(full-ecma)




/**
Wertet eine Variantentabelle für das Zielattribut aus und deaktiviert die nicht gültigen Werte. 
Gültig für die erste Einschränkung des Merkmals, weitere Einschränkungen mit der unteren Funktion.
*/
function SetAttributeLogic1st(sTable, sTargetAttribute, sWhere, sDefault_x)
{
    return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, false);

}
/**
Wertet eine Variantentabelle für das Zielattribut aus und deaktiviert die nicht gültigen Werte. 
Gültig für weitere Einschränkungen des Merkmals, wenn bereits eine Einschränkung stattgefunden hat.
*/
function SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere, sDefault_x) // bIntersect = true
{
    return SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, true);
}

function SetAttributeLogic_gen(sTable, sTargetAttribute, sWhere, sDefault_x, bIntersect)// = true weiter einschränken n. Lauf, bei false, erster Lauf,
{
    var sDefault = sDefault_x || "";
    var sSQL = 	"SELECT DISTINCT " + sTargetAttribute + " FROM " + sTable + " WHERE " + sWhere;
    
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_"+sTargetAttribute);
    
    if (aResult.length > 0){
        if (bIntersect){
            var aValidValues = ECL_GetAllActiveAttributeValues(sTargetAttribute);
        }
        ECL_DeactivateAllAttributeValues(sTargetAttribute);
        //var test = ECL_GetAllActiveAttributeValues(sTargetAttribute);
        for (var i = 0; i < aResult.length; i++){
            if (bIntersect){

                if (aValidValues.indexOf(String(aResult[i][sTargetAttribute])) > -1){
                    ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
                }
            }else{
                ECL_ActivateValue(sTargetAttribute, aResult[i][sTargetAttribute]);
            }
        } 
        //var test = ECL_GetAllActiveAttributeValues(sTargetAttribute);
        if (aResult.length == 1){
            ECL_SelectValue(sTargetAttribute, aResult[0][sTargetAttribute]);
        }
        else
        {
            ExecSetStandardifValueEmpty(sTargetAttribute, sDefault);
        }
    }
    else{
        // Fehler;
        return "Error";
    }
    var aValidValues = ECL_GetAllActiveAttributeValues(sTargetAttribute);
	return aValidValues;
}

function SetAttributeLogicFromCode(sTargetAttribute, aValidValues)
{
    var aValidValues_old = ECL_GetAllActiveAttributeValues(sTargetAttribute);
    var aValidValues_new = new Array();
    
    ECL_DeactivateAllAttributeValues(sTargetAttribute);
    
    for (var i = 0; i < aValidValues.length; i++){
        if (aValidValues_old.length > 0)
        {
            var iIndex = aValidValues_old.indexOf(aValidValues[i]);
            if (aValidValues_old.indexOf(aValidValues[i]) > -1){
                var sValue = aValidValues[i];
                ECL_ActivateValue(sTargetAttribute, aValidValues[i]);
                aValidValues_new.push(sValue);
            }
        }
        else
        {
            // ist das so korrekt? Wenn vorher keine gültigen Werte mehr da waren, kann nicht einfach eins aktiviert werden?!?
            var sValue = aValidValues[i];
            ECL_ActivateValue(sTargetAttribute, aValidValues[i]);
            aValidValues_new.push(sValue);
        }
    } 	
    
    if (aValidValues_new.length == 1){
        ECL_SelectValue(sTargetAttribute, aValidValues_new[0]);
    }
    else
    {
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
    }
    if (aValidValues_new.length == 0){
        // Fehler;
        return "Error";
    }
    var aValidValues = ECL_GetAllActiveAttributeValues(sTargetAttribute);
	return aValidValues;
}


function SetAttributeLogicFromCodeOverwrite(sTargetAttribute, aValidValues)
{
    ECL_DeactivateAllAttributeValues(sTargetAttribute);
    
    for (var i = 0; i < aValidValues.length; i++){
        var sValue = aValidValues[i];
        ECL_ActivateValue(sTargetAttribute, aValidValues[i]);
    } 	
    
    if (aValidValues.length == 1){
        ECL_SelectValue(sTargetAttribute, aValidValues[0]);
    }
    else
    {
        ExecSetStandardifValueEmpty(sTargetAttribute, "");
    }
    
    var aValidValues = ECL_GetAllActiveAttributeValues(sTargetAttribute);
	return aValidValues;
}

/**
Funktion zur Einschränkung eines Attributes in Abhängigkeit der MLFB 
MLFB-Attribut wird von Produktlogik eingeschränkt. 
Der verbleibende Wertepool wird dann genutzt, um das Zielattribut einzuschränken mit einer Übersetzung über eine Übersetzungstabelle

sTarget: 	Zielattribut, welches eingeschränkt werden soll
sMLFB_NAME: ID des MLFB-Attributs
sTable: 	Übersetzungstabelle in der MLFB und Zielattribut enthalten sind.
*/

function SetAttributeLogicFromMLFB_2nd(sTarget, sMLFB_NAME, sTable)
{
    return SetAttributeLogicFromMLFB(sTarget, sMLFB_NAME, sTable, "");
}


function SetAttributeLogicFromMLFB(sTarget, sMLFB_NAME, sTable)
{
    return SetAttributeLogicFromMLFB(sTarget, sMLFB_NAME, sTable, "");
}

function SetAttributeLogicFromMLFB(sTarget, sMLFB_NAME, sTable, addWhere)
{
    var aValidValuesMLFB = ECL_GetAllActiveAttributeValues(sMLFB_NAME);
    
    addWhere = addWhere || "";
    if (addWhere != ""){
        addWhere = addWhere + " AND ";
    }
    ECL_DeactivateAllAttributeValues(sTarget);
    
    var sWhere = sMLFB_NAME + " = '" + aValidValuesMLFB[0] + "'";
    
    if (aValidValuesMLFB.length > 1){
        
        for (var i = 1; i < aValidValuesMLFB.length; i++){
            
            sWhere = sWhere + " OR " + sMLFB_NAME + " = '" + aValidValuesMLFB[i] + "'";
            
        }
    }
    
    var sSQL = "SELECT DISTINCT * FROM " + sTable + " WHERE " + addWhere + "("+ sWhere + ");";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_" + sMLFB_NAME );
    
    if (aResult.length > 0){
        for (var j = 0; j < aResult.length; j++){
            ECL_ActivateValue(sTarget, aResult[j][sTarget]);
        }
    }else{
        return "Error";
    }
    
    if (aResult.length == 1){
        ECL_SelectValue(sTarget, aResult[0][sTarget]);
    }
    else
    {
        ExecSetStandardifValueEmpty(sTarget, "");
    }
    
    var aValidValues = ECL_GetAllActiveAttributeValues(sTarget);
	return aValidValues;
}

function SetAttributeLogicFromMLFB_2nd(sTarget, sMLFB_NAME, sTable, addWhere)
{
    var aValidValuesMLFB = ECL_GetAllActiveAttributeValues(sMLFB_NAME);
    var aValidValuesTarget = ECL_GetAllActiveAttributeValues(sTarget);
    
    addWhere = addWhere || "";
    if (addWhere != ""){
        addWhere = addWhere + " AND ";
    }
    ECL_DeactivateAllAttributeValues(sTarget);
    
    var sWhere = sMLFB_NAME + " = '" + aValidValuesMLFB[0] + "'";
    
    if (aValidValuesMLFB.length > 1){
        
        for (var i = 1; i < aValidValuesMLFB.length; i++){
            
            sWhere = sWhere + " OR " + sMLFB_NAME + " = '" + aValidValuesMLFB[i] + "'";
            
        }
    }
    
    var sSQL = "SELECT DISTINCT * FROM " + sTable + " WHERE " + addWhere + "("+ sWhere + ");";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_" + sMLFB_NAME );
    
    if (aResult.length > 0){
        for (var j = 0; j < aResult.length; j++){
            if (aValidValuesTarget.indexOf(aResult[j][sTarget]) > -1)
                ECL_ActivateValue(sTarget, aResult[j][sTarget]);
        }
    }else{
        return "Error";
    }
    
    if (aResult.length == 1){
        ECL_SelectValue(sTarget, aResult[0][sTarget]);
    }
    else
    {
        ExecSetStandardifValueEmpty(sTarget, "");
    }
    
    var aValidValues = ECL_GetAllActiveAttributeValues(sTarget);
	return aValidValues;
}


function GetDBDataSetEXT(sSQL)
{
    return GetDBDataSetEXT(sSQL, null);
}

function GetDBDataSetEXT(sSQL, sDbRequestIdent){
    // Get current session
    var aResult = Object.fromDatabase("EXTERNAL_DATA", sSQL);
    
    return aResult;
}


function GetDBDataSetEXT_VT377(sSQL, sDbRequestIdent){
    // Get current session
    var aResult = Object.fromDatabase("1FG1_ADD_DATA", sSQL);

    return aResult;
}

/**
    Setzt einen Merkmalswert auf Default, falls der Wert leer war.
    param Attribute: das Merkmal
    param strDefault: der Defaultwert 
*/
function ExecSetStandardifValueEmpty(Attribute, strDefault)
{
    var strValue = ECL_GetValue(Attribute);
    var aselection = ECL_GetAllActiveAttributeValues(Attribute);
    
    if (strDefault == "")
    {
        if (aselection.length > 0 && aselection.indexOf("STD") > -1)
        {
            strDefault = "STD";
        }
        if (aselection.length > 0 && aselection.indexOf("NON") > -1)
        {
            strDefault = "NON";
        }
    }
    if(strValue == "")
    {
        if(ECL_ValueActive(Attribute, strDefault))
        {
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }
        else
        {
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0 )
            {
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
    }
    else
    {
        var aselection = ECL_GetAllActiveAttributeValues(Attribute);
        
        if(aselection.length > 0)
        {
            for(var i=0;i<aselection.length;i++)
            {	
                if(strValue == aselection[i])
                    return true;
            }
        }
        
        if(ECL_ValueActive(Attribute, strDefault))
        {
            ECL_SelectValue(Attribute, strDefault);
            return true;
        }
        else
        {
            var aselection = ECL_GetAllActiveAttributeValues(Attribute);
            if(aselection.length > 0)
            {
                ECL_SelectValue(Attribute, aselection[0]);
                return true;
            }
        }
        
    }
}

/**
    Baut ein SQL Statement gem. angegebener Vorgaben (Datenbank, Tabelle, Bedingung),
    führt dieses aus und setzt angeg. Attribute mit den ermittelten Werten.
    
    param db: Datenbank
    param table: abzufragende Tabelle in der Datenbank
    param attributesObj: {IDENT:"Merkmalname",DB:"Spaltenname in der Datenbank"}
    param whereObj: {"DB-Tabelle":"Spaltenname",Value:"Wert"}
    
*/
function ExecSQL_Standard(db, table, attributesObj, whereObj) 
{
    ExecSQL_Standard_Intern(db, table, attributesObj, whereObj, ""); 	
}

/**
    ohne Einschränkung!!! Damit Umwahl möglich ist.
*/
function ExecSQL_Standard_Open(db, table, attributesObj, whereObj)
{
    
    // To do....
    
    ExecSQL_Standard_Intern_open(db, table, attributesObj, whereObj, ""); 
}

/**
    Wie ExecSQL_Standard, aber mit zusätzl. Vorgabe eines Defaultwerts.
    Falls in der DB kein Wert gefunden wird oder auch mehrere Werte gefunden werden,
    wird der Defaultwert eingestellt
*/
function ExecSQL_Standard_Default(db, table, attributesObj, whereObj, defaultValue) 
{
    ExecSQL_Standard_Intern(db, table, attributesObj, whereObj, defaultValue); 	
}

/**
    Intern verwendet
*/
function ExecSQL_Standard_Intern(db, table, attributesObj, whereObj, defaultValue) 
{
    vtTimeStart	= Date.getTime();
    
    /*for (var i=0; i<attributesObj.length; i++) 
    {
        ECL_DeactivateAllAttributeValues(attributesObj[i]["IDENT"]);
    }
    */
    var sql = makeSQL(table, attributesObj, whereObj);
    var result = new DBRecSet(db, sql);
    logtraceln("ResultSets="+result.getNumRecs());
    
    var aFieldNr=[];
    for (var i=0; i<attributesObj.length; i++) 
    {
        for(var clause in attributesObj[i])
        {
            if(clause != "IDENT")
            {
                aFieldNr.push(result.getFieldNr(attributesObj[i][clause]));
            }
        }
    }
    
    var first = true;
    var firstValue = "";
    var hasStandardValue = false;
    
    while(result.ok())
    {
        for (var i=0; i<attributesObj.length; i++) 
        {
            for(var clause in attributesObj[i])
            {
                if(clause != "DB")
                {
                    var valueToSet = replace(result.getStringFromIdx(aFieldNr[i]),'"','');
                    // Aktiviert alle gefundenen Attributwerte
                    logtraceln("ActivateValue "+ attributesObj[i][clause] + " = " + result.getStringFromIdx(aFieldNr[i]));
                    ECL_ActivateValue(attributesObj[i][clause], valueToSet);
                    
                    // Selektiert den Standard-Attributwert falls vorhanden, sonst den ersten Attributwert
                    if (first){
                        logtraceln("SetValue "+ attributesObj[i][clause] + " = " + valueToSet);
                        ECL_SetValue(attributesObj[i][clause], valueToSet);
    
                        first = false;
                    }
                    
                    if (valueToSet === defaultValue){
                        logtraceln("SetValue "+ attributesObj[i][clause] + " = " + valueToSet);
                        ECL_SetValue(attributesObj[i][clause], valueToSet);
                    }
                }
            }
        }
        
        result.fetchNext();
    }

    vtTimeStop	= Date.getTime();
    vtTime		= (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* SQL - Time: "+vtTime+" sec"+"\n");	
}



function ExecSQL_Standard_Intern_open(db, table, attributesObj, whereObj, defaultValue) 
{
    vtTimeStart	= Date.getTime();
    
    /*for (var i=0; i<attributesObj.length; i++) 
    {
        ECL_DeactivateAllAttributeValues(attributesObj[i]["IDENT"]);
    }*/
    
    var sql = makeSQL(table, attributesObj, whereObj);
    var result = new DBRecSet(db, sql);
    logtraceln("ResultSets="+result.getNumRecs());
    
    var aFieldNr=[];
    for (var i=0; i<attributesObj.length; i++) 
    {
        for(var clause in attributesObj[i])
        {
            if(clause != "IDENT")
            {
                aFieldNr.push(result.getFieldNr(attributesObj[i][clause]));
            }
        }
    }
    
    var first = true;
    var firstValue = "";
    var hasStandardValue = false;
    
    while(result.ok())
    {
        for (var i=0; i<attributesObj.length; i++) 
        {
            for(var clause in attributesObj[i])
            {
                if(clause != "DB")
                {
                    var valueToSet = replace(result.getStringFromIdx(aFieldNr[i]),'"','');
                    // Aktiviert alle gefundenen Attributwerte
                    logtraceln("ActivateValue "+ attributesObj[i][clause] + " = " + result.getStringFromIdx(aFieldNr[i]));
                    ECL_ActivateValue(attributesObj[i][clause], valueToSet);
                    
                    // Selektiert den Standard-Attributwert falls vorhanden, sonst den ersten Attributwert
                    if (first){
                        logtraceln("SetValue "+ attributesObj[i][clause] + " = " + valueToSet);
                        ECL_SetValue(attributesObj[i][clause], valueToSet);
                        
                        first = false;
                    }
                    
                    if (valueToSet === defaultValue){
                        logtraceln("SetValue "+ attributesObj[i][clause] + " = " + valueToSet);
                        ECL_SetValue(attributesObj[i][clause], valueToSet);
                    }
                }
            }
        }
        
        result.fetchNext();
    }

    vtTimeStop	= Date.getTime();
    vtTime		= (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* SQL - Time: "+vtTime+" sec"+"\n");	
}




/**
    Baut ein SQL Statement gem. angegebener Vorgaben (Datenbank, Tabelle, Bedingung),
    führt dieses aus und liefert das Recordset.
    
    param db: Datenbank
    param table: abzufragende Tabelle in der Datenbank
    param attributesObj: {DB:"Spaltenname in der Datenbank"}
    param whereObj: {"DB-Tabelle":"Spaltenname",Value:"Wert"}
    
*/
function ExecSQL_Result(db, table, attributesObj, whereObj) 
{
    vtTimeStart	= Date.getTime();
    
    var sql = makeSQL(table, attributesObj, whereObj);
    
    var result = new DBRecSet(db, sql);
    //var result = Object.fromDatabase(db, sSQL);
    logtraceln("ResultSets="+result.getNumRecs());
    
    var aFieldNr=[];
    for (var i=0; i<attributesObj.length; i++) 
    {
        for(var clause in attributesObj[i])
        {
            if(clause != "IDENT")
            {
                aFieldNr.push(result.getFieldNr(attributesObj[i][clause]));
            }
        }
    }
    
    return result;
}

function makeSQL(table, attributesObj, whereObj)
{
    var attributeSQL = "";
    var sqlWhere = "";
    for (var i=0; i<attributesObj.length; i++) 
    {
        attributeSQL = attributeSQL+","+attributesObj[i]["DB"];
    }
    attributeSQL=trimleft(attributeSQL, ",");

    if(whereObj.length > 0)
    {
        var strSQL="";
        for(var i=0;i<whereObj.length;i++)
        {
            var btest=false;
            for(var clause in whereObj[i])
            {
                if(clause == "Value")
                {
                    btest=true;
                    if(find(whereObj[i][clause],";") > -1)
                    {
                        var strMultiSQL=whereObj[i][clause];
                        var aMultiSQL = strMultiSQL.split(";");
                        strSQL=strSQL+" (";
                        for(var j=0;j<aMultiSQL.length;j++)
                        {
                            strSQL=strSQL+"'"+aMultiSQL[j]+"',";
                        }
                        strSQL=trimright(strSQL,",");
                        strSQL=strSQL+")";
                    }
                    else
                        strSQL = strSQL +"'"+ whereObj[i][clause]+"'";
                }
                else
                {
                    if(btest)
                    {
                        if(find(whereObj[i]["Value"],";") > -1)
                        {
                            strSQL = clause+"."+whereObj[i][clause]+" IN "+strSQL;
                        }
                        else if(find(whereObj[i][clause],"UMGEB_TEMP_MAX") > -1)
                        {
                            strSQL = whereObj[i][clause]+">="+strSQL;
                        }
                        else
                        {
                            strSQL = clause+"."+whereObj[i][clause]+"="+strSQL;
                        }
                    }
                    else
                    {
                        if(find(whereObj[i]["Value"],";") > -1)
                        {
                            strSQL = strSQL + clause+"."+whereObj[i][clause]+" IN ";
                        }
                        else if(find(whereObj[i][clause],"UMGEB_TEMP_MAX") > -1)
                        {
                            strSQL = whereObj[i][clause]+">="+strSQL;
                        }
                        else
                        {
                            strSQL = strSQL + clause+"."+whereObj[i][clause]+"=";
                        }
                    }
                }
                
                if(find(table,clause) < 0 && clause != "Value")
                {
                    table = table +","+clause;
                }
            }
            strSQL = strSQL +" AND ";
            
            if(whereObj[i][clause] == "")
                strSQL = "";
            else
            {
                strSQL = trimright(strSQL,"=");
            }
            sqlWhere = sqlWhere + strSQL;
            strSQL = "";
        }
        sqlWhere = trimright(sqlWhere," AND ");
    }
    
    if (sqlWhere != "") {
        sqlWhere = "WHERE "+sqlWhere;
    }
    
    var sqlSelect = 'SELECT DISTINCT '+attributeSQL;
    var sqlFrom = 'FROM '+table;
    var sql = [sqlSelect, sqlFrom, sqlWhere].join(' ');
    
    sql = sql + " ORDER BY ("+attributesObj[0]["DB"]+") ASC";
    
    logtraceln("SQL="+sql);
    return sql;
}

/**
    Wenn ein einzelnes Attribut durch eine Kurzangabe (oder Defaultwert bei Fehlen
    einer passenden Kurzangabe) zu belegen ist.
    ACHTUNG: wird auf der Datenbank 1LE1_ATTR ausgeführt!
* /
function ExecSQL_KAG_Standard(attribute, kag, defaultValue){
    //ECL_DeactivateAllAttributeValues(attribute);
    var awhere = new Array();
    awhere.push({Tabelle1:"Attribute",Value:attribute});
    var aAttributes = new Array();
    aAttributes.push({IDENT:attribute,DB:"Value"});
    var aResult = ExecSQL_Result("1LE1_ATTR", "Tabelle1", aAttributes, awhere);
    if (aResult.length > 0){
        var resultValue = getKAGorDefaultFromRecordset(aResult, kag, defaultValue);
        
        ECL_ActivateValue(attribute, resultValue);
        ECL_SetValue(attribute, resultValue);
    }
}

*/
function isEmpty(obj) { 
   for (var x in obj) { return false; }
   return true;
}


/**
    Kommt eine der Kurzangaben im einspaltigen Recordset vor, liefert die Kurzangabe als Wert
    Sonst wenn einer der defaultValues (Komma-getrennte Liste) im Recordset vorkommt, liefert diesen Wert.
* /
function getKAGorDefaultFromRecordset(recordset, kagList, defaultValue){
    var recordset = recordset || {};
    var kagList = kagList || [];
    var recordValue = "";
    var resultValue = "";
    var defaults = defaultValue.split(",");
    while(recordset.ok()){
        recordValue = recordset.getStringFromIdx(0);
        if (kagList.indexOf(recordValue) >= 0){
            return recordValue;
        } else {
            for(var j=0;j<defaults.length;j++){
                
                if (recordValue == trimright(trimleft(defaults[j], " "), " ")){
                    resultValue = recordValue;
                }
            }
        }
        
        recordset.fetchNext();
    }
    
    return resultValue;
}

/** 
entfernt ungültige Zeichen aus Textfeldern für KAG
*/
function normalizeOE_Attribute(sAttribute){
    var sValue = ECL_GetValue(sAttribute);

    sValue = sValue.replace("{", "(");
    sValue = sValue.replace("}", ")");
    sValue = sValue.left(30);
    //sValue = sValue.replace("\\", "/");
    /*
    sValue = sValue.replace("Y50:", "");
    sValue = sValue.replace("Y52:", "");
    sValue = sValue.replace("Y58:", "");
    sValue = sValue.replace("Y59:", "");
    sValue = sValue.replace("Y60:", "");
    sValue = sValue.replace("Y61:", "");
    sValue = sValue.replace("Y68:", "");
    sValue = sValue.replace("Y74:", "");
    sValue = sValue.replace("Y75:", "");
    sValue = sValue.replace("Y76:", "");
    sValue = sValue.replace("Y79:", "");
    sValue = sValue.replace("Y80:", "");
    sValue = sValue.replace("Y81:", "");
    sValue = sValue.replace("Y82:", "");
    sValue = sValue.replace("Y84:", "");
    sValue = sValue.replace("Y85:", "");
    sValue = sValue.replace("Y88:", "");
    
    sValue = sValue.replace(/[&#+$~%'":*?<>]/g, '');
    sValue = toupper(sValue);
    */
    
    ECL_SetValue(sAttribute, sValue);
    return sValue;

}

/**
Die folgende Funktion gibt die in der MLFB ggf. vorhandene KAG zu einem gegebenen Attribut zurück
*/
function getKAGforAttribute(sAttributeName, aKAG_List)
{
    var sValue = "NON";
    var aResult = Object.fromDatabase("1FG1_ADD_DATA", "select distinct Wert_ID from DATA WHERE IsKAG = 'x' AND Attribute = '" + sAttributeName + "'");
    
    if (aResult.length > 0 && !isEmpty(aKAG_List) ){
        for(var i=0;i<aResult.length;i++)
        {
            var sKAG = aResult[i].WERT_ID;
            if (aKAG_List.indexOf(sKAG) > -1){
                sValue = sKAG;
                break;
            }
        }
    }
    return sValue;
}


function replaceAt(string, index, replace) {
  return string.substring(0, index) + replace + string.substring(index + 1);
}