//@legacy
//#mode(full-ecma)


//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"


//@import "../1FG1_MLFB/Base.misc.js"


/**
 * @category   1FG1 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2019 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init( strMLFB )
{
    vtTimeStart	= Date.getTime();
    
    var oParsing = {
        strBaseMLFB : '',
        strFullMLFB : '',
        strError    : '',
        strWarning  : '',
        aTokens     : [],
        oFreetext   : {}
    };
    
    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    
    strMLFB = normalizeMLFB( strMLFB );
    strBaseTypeMLFB = normalizeMLFB( strBaseTypeMLFB );
    
    
    //var bF70presentBT=false;
/*	var strStartConfiguration=ECL_GetValue("ECSI_IS_START_CONFIGURATION");
    
    if(strStartConfiguration=="" && find(strMLFB.left(16), ".") >= 0)
        strStartConfiguration="1" ;
    
    if(strStartConfiguration=="1")
    {*/
        //Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
        //Hier sollen dann möglichst viele Attribute beibehalten werden.
        //Die Basetype MLFB kann sich in Getriebe, Motor oder Übersetzung von der Haupt MLFB unterscheiden.
    if(strBaseTypeMLFB != "")
    {
        //--------------------------------------------------------------------------------------------------------
        // Base Type  MLFB aufbereiten
        //--------------------------------------------------------------------------------------------------------
        var aBTComponents = tokenize( strBaseTypeMLFB );
        if ( aBTComponents.length > 1 )
        {
            // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
            // eliminate the resulting invalid short description 'Z'
            if ( ( aBTComponents[1] === 'Z' ) || ( aBTComponents[1] === '-Z' ) ){
                aBTComponents = removeElementsFromArray( aBTComponents, 1, 1 );
            }
        }
        
        strBaseTypeMLFB = aBTComponents[0];
        
        if ( strBaseTypeMLFB.length === 17 ){
            // eliminate the -Z 
            strBaseTypeMLFB = strBaseTypeMLFB.substring( 0, 16 );
        }
        
        var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring( 0, 7 ) + ".." + strBaseTypeMLFB.substring( 9, 13 ) + "." + strBaseTypeMLFB.substring( 14 );
    }
    
    var oResult;
    
    var nFreetext = find(strMLFB,'{');
    var strFreetext = '';
    if (nFreetext > 0){
        strFreetext = strMLFB.right(strMLFB.length-nFreetext+1);
    }
    oParsing.oFreetext = parseFreetext( strFreetext, true );
    strMLFB = replace(strMLFB,strFreetext,"");
    oParsing.strFullMLFB = strMLFB;
    
    var aComponents = tokenize( strMLFB );
    if ( !aComponents.length ){
        oParsing.strError = 'ERRORMSG_MLFB_1FG1___INVALID_MLFB';
        return( oParsing )
    } else if ( aComponents.length > 1 ){
        // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
        // eliminate the resulting invalid short description 'Z'
        if ( ( aComponents[1] === 'Z' ) || ( aComponents[1] === '-Z' ) ){
            aComponents = removeElementsFromArray( aComponents, 1, 1 );
        }
    }
    oParsing.strBaseMLFB = aComponents[0];
    oParsing.aTokens = aComponents;
    
    var strMLFB_fix = strMLFB.substring( 0, 7 ) + ".." + strMLFB.substring( 9, 13 ) + "." + strMLFB.substring( 14, 16 );
    
    // -----------------------------------------------------------------------------------------------
    //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
    // -----------------------------------------------------------------------------------------------
    if( (strBaseTypeMLFB_fix!=strMLFB_fix) && find(strMLFB.left(16), ".") < 0 && strBaseTypeMLFB != "")
    {
        
        // -----------------------------------------------------------------------------------------------
        // KAG abgleichen und ggf übernehmen/entfernen
        // -----------------------------------------------------------------------------------------------
        
        // Geber KAG todo bei Update DTK-Basis, in dieser Version sind keine KAG für Geber vorgesehen
        
        // -----------------------------------------------------------------------------------------------
        // Platzhalter aus MLFB in BT übernehmen
        // -----------------------------------------------------------------------------------------------
        var PMD_ABV410_001_000_1FG1S = getGetriebeBez(strBaseTypeMLFB);
        
        // -----------------------------------------------------------------------------------------------
        // Stelle 8	Wellenausführung
        // -----------------------------------------------------------------------------------------------
        var sMLFB08 = strMLFB.charAt(7);
        var sBT_MLFB08 = strBaseTypeMLFB.charAt(7);
        
        if (sBT_MLFB08 == "."){
            // Check Wellenausführung
            var bCheck = false;
            
            if (PMD_ABV410_001_000_1FG1S != 0){
                bCheck = checkMLFB08(strBaseTypeMLFB, sMLFB08, PMD_ABV410_001_000_1FG1S);
            }
            if (bCheck){
                // setzen
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 7, sMLFB08);
            }else
            {
                // Setze Default:
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 7, "1");
                
                /* wird von der ParserSkripten+PL entfernt
                if (sMLFB08 == "9"){
                    //KAG entfernen
                    var aKAGs = ["H1G", "H3A", "H5A", "H6A", "H7A", "H3G", "H3H", "H3J", "H3K", "H3L", "H3M", "H3N", "H4A", "H3B", "H3C", "H3P"];
                    for (var i = 0; i<aKAGs.length; i++){
                        strMLFB=replace(strMLFB,"+"+aKAGs[i],"");
                        strMLFB=replace(strMLFB,aKAGs[i],"");
                    }
                    ECL_SetValue("ECSI_MLFB",strMLFB);
                }
                */
            }
        }
        
        // -----------------------------------------------------------------------------------------------
        // Stelle 9 - Gebersystem
        // -----------------------------------------------------------------------------------------------
        var sMLFB09 = strMLFB.charAt(8);
        var sBT_MLFB09 = strBaseTypeMLFB.charAt(8);
        
        if (sBT_MLFB09 == "."){
            // Wert aus MLFB übernehmen
            // Check Gebersystem
            var bCheck = false;
            bCheck = checkMLFB09(strBaseTypeMLFB, sMLFB09); 
            if (bCheck){
                // setzen
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 8, sMLFB09);
                // Wenn Z, wurde bereits oben die KAG gesetzt
            }else
            {
                // nicht zulässig, default setzen
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 8, "Q");
            }
        }
        // -----------------------------------------------------------------------------------------------
        // Stelle 14 Befestigungsart
        // -----------------------------------------------------------------------------------------------
        var sMLFB14 = strMLFB.charAt(13);
        var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);
        
        if (sBT_MLFB14 == "."){
            
            // Check Befestigungsart
            var bCheck = false;
            if (PMD_ABV410_001_000_1FG1S != 0){
                bCheck = checkMLFB14(strBaseTypeMLFB, sMLFB14, PMD_ABV410_001_000_1FG1S); 
            }
            if (bCheck){
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
            }
            else{ // Default
                // Setze Default:
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "A");
            }
        }
        // -----------------------------------------------------------------------------------------------
        // Zuweisen der neuen MLFB und KAG-Liste
        strMLFB = strBaseTypeMLFB.substring( 0, 16 ) + strMLFB.substring(16);
        
        oParsing.strBaseMLFB = strBaseTypeMLFB.substring( 0, 16 );
        oParsing.strFullMLFB = strMLFB;
        aComponents[0]=oParsing.strBaseMLFB;
        oParsing.aTokens = aComponents;
        ECL_SetValue("ECSI_MLFB", strMLFB);
    }
    else{
        if(find(strMLFB.left(16), ".") >= 0){
            // Unvollständige SIZER MLFB
            
            // Prüfen, ob '.' an Stelle 1 bis 8, dann Fehler
            for (var i = 0; i < 7; i++){
                if (strMLFB.charAt(i) == "."){
                    oParsing.strError = 'ERRORMSG_MLFB_1LE___INCOMPLETE_MLFB';
                    return( oParsing );
                }
            }
            // Prüfen, ob '.' an Stelle 10 bis 13, dann Fehler
            for (var i = 9; i < 13; i++){
                if (strMLFB.charAt(i) == "."){
                    oParsing.strError = 'ERRORMSG_MLFB_1LE___INCOMPLETE_MLFB';
                    return( oParsing );
                }
            }
            // Prüfen, ob '.' an Stelle 15 bis 16, dann Fehler
            for (var i = 14; i < 16; i++){
                if (strMLFB.charAt(i) == "."){
                    oParsing.strError = 'ERRORMSG_MLFB_1LE___INCOMPLETE_MLFB';
                    return( oParsing );
                }
            }
            
            // -----------------------------------------------------------------------------------
            // Wenn an Stelle 8, 9 oder 14 ein Wildcard, dann Default setzen
            // -----------------------------------------------------------------------------------
            // Wellenausführung
            if (strMLFB.charAt(7) == "."){
                // Setze Default:
                strMLFB = replaceAt(strMLFB, 7, "1");
            }
            // -----------------------------------------------------------------------------------
            // Gebersystem
            if (strMLFB.charAt(8) == "."){
                
                strMLFB = replaceAt(strMLFB, 8, "Q");
            }
            // -----------------------------------------------------------------------------------
            // Befestigungsart
            if (strMLFB.charAt(13) == "."){
                // Setze Default:
                strMLFB = replaceAt(strMLFB, 13, "A");
            }
            // -----------------------------------------------------------------------------------
            ECL_SetValue("ECSI_MLFB", strMLFB);
            oParsing.strBaseMLFB = strMLFB.left(16);
            aComponents[0]=oParsing.strBaseMLFB;
            oParsing.strFullMLFB = strMLFB;
        }
    }
    // END EDIT KEEP CONF
    
    if ( oParsing.strBaseMLFB.length !== 16 ){
        // Prüfen, ob die Zeichenkette 16 Stellen hat
        oParsing.strError = 'ERRORMSG_MLFB_1FG1___PARSE_WRONG_SIZE';
        return( oParsing );
    }
    
    if ( oParsing.strBaseMLFB.indexOf("1FG1") < 0 ){
        // Falsches Produkt
        oParsing.strError = 'ERRORMSG_MLFB_1FG1___PARSE_WRONG_PRODUCT';
        return( oParsing );
    }
    
    var oResult;
    oResult = parse_1FG1(oParsing.aTokens);
    //oResult = add_help_shortcuts(oResult);
    
    //var sBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");
    //oParsing.sBaseTypeMLFB = sBaseTypeMLFB;
    
    
    if ( oResult ) {
        if ( oResult.oProduct )
            oParsing.oProduct = oResult.oProduct;
        if ( oResult.oParsingData )
            oParsing.oParsingData = oResult.oParsingData;
        oParsing.strError += ( ( oParsing.strError ? ' ' : '' ) + oResult.strError );
        oParsing.strWarning += ( ( oParsing.strWarning ? ' ' : '' ) + oResult.strWarning );
    }
            
    
    vtTimeStop	= Date.getTime();
    vtTime		= (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* Parse - Time: "+vtTime+" sec"+"\n");

    return( oParsing );
}

function parse_1FG1( aTokens ) {
    var oResult = {
        strError: '',
        strRegion: '',
        strWarning: '',
        oProduct: null,
        oParsingData: {}
    };
    
    var strBaseMLFB = aTokens[0];
    oResult.oParsingData.MLFB = {};
    oResult.oParsingData.MLFB.POS1 = strBaseMLFB.charAt( 0 );	// 1
    oResult.oParsingData.MLFB.POS2 = strBaseMLFB.charAt( 1 );	// F
    oResult.oParsingData.MLFB.POS3 = strBaseMLFB.charAt( 2 );	// G
    oResult.oParsingData.MLFB.POS4 = strBaseMLFB.charAt( 3 );	// 1
    oResult.oParsingData.MLFB.POS5 = strBaseMLFB.charAt( 4 );	// .? Getriebestufen
    oResult.oParsingData.MLFB.POS6 = strBaseMLFB.charAt( 5 );	// .? Getriebebaugröße 6+7
    oResult.oParsingData.MLFB.POS7 = strBaseMLFB.charAt( 6 );	// .? Getriebebaugröße 6+7
    oResult.oParsingData.MLFB.POS8 = strBaseMLFB.charAt( 7 );	// .? Wellenausführung
    oResult.oParsingData.MLFB.POS9 = strBaseMLFB.charAt( 8 );	// .? Gebersystem
    oResult.oParsingData.MLFB.POS10 = strBaseMLFB.charAt( 9 );	// Achshöhe
    oResult.oParsingData.MLFB.POS11 = strBaseMLFB.charAt( 10 );	// Baulänge
    oResult.oParsingData.MLFB.POS12 = strBaseMLFB.charAt( 11 );	// Drehzahl
    oResult.oParsingData.MLFB.POS13 = strBaseMLFB.charAt( 12 );	// Motortyp
    oResult.oParsingData.MLFB.POS14 = strBaseMLFB.charAt( 13 ); // .? Befestigungsart
    oResult.oParsingData.MLFB.POS15 = strBaseMLFB.charAt( 14 ); // .? Übersetzung 15+16
    oResult.oParsingData.MLFB.POS16 = strBaseMLFB.charAt( 15 ); // .? Übersetzung 15+16
    
    oResult.oParsingData.MLFB.POS1_4 = strBaseMLFB.substring(0, 4);
    // GETR_BG_5_7 = MLFB_05_06_07_1FG1S
    oResult.oParsingData.GETR_BG_5_7 = strBaseMLFB.charAt( 4 ) + strBaseMLFB.charAt( 5 ) + strBaseMLFB.charAt( 6 ); // Getriebe Stufen + Baugröße
    oResult.oParsingData.MOTOR_BG_10_11 = strBaseMLFB.charAt( 9 ) + strBaseMLFB.charAt( 10 ); //Baugröße MLFB 10+11
    
    // Kurzangaben
    if (aTokens.length > 0){
        if (aTokens[0] === strBaseMLFB){
            aTokens = removeElementsFromArray( aTokens, 0, 1 );
        }
        oResult.oParsingData.MLFB.KAG = aTokens;
        
        oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
    }
    
    return oResult;
}


/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens){
    var kagString = "";
    for (var i = 0; i < aTokens.length; i++) {
        kagString += aTokens[i];
        if (i < aTokens.length - 1){
            kagString += ";";
        }
    }
    return kagString;
}


function SetFreetextValue(field, value) {
    
    value = trimleft(value, '*');
    value = trimright(value, '*');
    
    ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {

/*	zur Info - oParse: 
    {
        strBaseMLFB : '',
        strFullMLFB
        strError : '',
        strWarning : '',
        aTokens : [],
        oFreetext : {}
    };
*/
    if (find(oParse.strFullMLFB , 'Y84') >= 0) {
        if (oParse.oFreetext['Y84']) SetFreetextValue('O_Y84_TEXT_1FG1S', oParse.oFreetext['Y84']);
    }
}

function isKAGinMLFB(aArray, sKAG)
{
    for(var i=0;i<aArray.length;i++)
    {
        if(aArray[i]==sKAG)
            return true;
    }
    
    return false;	
}

function getGetriebeBez(strBaseTypeMLFB)
{
    // VT_1FG1S_M00025
    // MLFB05_1FG1S	MLFB06_1FG1S	MLFB07_1FG1S	PMD_ABV410_001_000_1FG1S	PMD_ABV517_001_000_1FG1S	PMD_ABV417_001_000_1FG1S_X	HMK_VALUE_VALID_1FG1S

    var MLFB05_1FG1S = strBaseTypeMLFB.charAt(4);
    var MLFB06_1FG1S = strBaseTypeMLFB.charAt(5);
    var MLFB07_1FG1S = strBaseTypeMLFB.charAt(6);
    
    // Bestimmung PMD_ABV410_001_000_1FG1S
    var sTable = "VT_1FG1S_M00025" + sDB_Suffix;
    var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                "MLFB05_1FG1S = '" + MLFB05_1FG1S + "' AND " +
                "MLFB06_1FG1S = '" + MLFB06_1FG1S + "' AND " +
                "MLFB07_1FG1S = '" + MLFB07_1FG1S + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_ParseKC");
    if (aResult.length > 0){
        var PMD_ABV410_001_000_1FG1S = aResult[0].PMD_ABV410_001_000_1FG1S;
        return PMD_ABV410_001_000_1FG1S;
    }else{
        return 0;
    }
}

// Checkroutinen für Keep Configuration
function checkMLFB08(strBaseTypeMLFB, sMLFB08, PMD_ABV410_001_000_1FG1S)
{
    var sTable = "VT_1FG1S_M00040" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT * FROM " + sTable + " WHERE " +
                "MLFB08_1FG1S = '" 				+ sMLFB08 + "' AND " +
                "PMD_ABV410_001_000_1FG1S = '" 	+ PMD_ABV410_001_000_1FG1S + "' AND " +
                //"H_WELLEN_DURCHM_1FG1S = '" 	+ H_WELLEN_DURCHM_1FG1S + "' AND " +
                //"O_H1G_BIS_H7A_1FG1S = '" 		+ sKAG + "' AND " +
                "HMK_VALUE_VALID_1FG1S = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE_KC");
    if (aResult.length < 1){
        return 0;
    }
    // ----------------------------------
    return 1;
}

function checkMLFB14(strBaseTypeMLFB, sMLFB14, PMD_ABV410_001_000_1FG1S)
{
    // VT_1FG1S_M00077	Getriebe-Wellenausführung
    // 	PMD_ABV410_001_000_1FG1S	MLFB08_1FG1S	MLFB14_1FG1S
    var MLFB08_1FG1S = strBaseTypeMLFB.charAt(7);
    
    var sTable = "VT_1FG1S_M00077" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT * FROM " + sTable + " WHERE " +
                "MLFB08_1FG1S = '" 				+ MLFB08_1FG1S + "' AND " +
                "PMD_ABV410_001_000_1FG1S = '" 	+ PMD_ABV410_001_000_1FG1S + "' AND " +
                "MLFB14_1FG1S = '" 				+ sMLFB14 + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE_KC");
    if (aResult.length < 1){
        return 0;
    }
    // ----------------------------------
    return 1;
}

function checkMLFB09(strBaseTypeMLFB, sMLFB09)
{
	// keine Einschränkung für N16 (wird nachrangig behandelt).
	
	// NEU: AH-Geber VT 210
	var MLFB10_1FG1S = strBaseTypeMLFB.charAt(9);
	
	var sTable = "VT_1FG1S_M00210" + sDB_Suffix;
	var sSQL = "SELECT MLFB09_1FG1S FROM " + sTable + " WHERE " +
				"MLFB09_1FG1S = '" + sMLFB09 + "' AND " +
				"MLFB10_1FG1S = '" + MLFB10_1FG1S + "' AND " +
				"HMK_VALUE_VALID_1FG1S = 'T';";
	var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSER_KC");
	if (aResult.length < 1){
		return 0;
	}
	// ----------------------------------
	return 1;
}