//@legacy
//#mode(full-ecma)


/**
 *
 @category   Parser
 * @package    Core
 * @copyright  Copyright (c) 2009-2013 Plan Software GmbH (http://www.plansoft.de)
 */

/**
 * normalize MLFB (trim spaces, adjust to upper case, add additional spaces between plus if necessary, delete surplus tabs and spaces)
 *
 * @param strMLFB - MLFB input from user to normalize
 *
 * @return string - the normaized MLFB
 */
function normalizeMLFB( strMLFB )
{
    // trim spaces and adjust to upper case
    //strMLFB = toupper( trimright( trimleft( strMLFB, ' ' ), ' ' ) );
    // edit, Freitexte nicht zu die Schreibweise ändern.
    strMLFB = trimright( trimleft( strMLFB, ' ' ), ' ' );
    
    // add additional spaces between plusses if necessary
    strMLFB = replace( strMLFB, '-Z', '-Z ' );
    strMLFB = replace( strMLFB, '+', ' +' );
    strMLFB = replace( strMLFB, '+ ', '+' ); // EDIT 11.03.2020 BCH Fehler bei Direktaufruf in der Suche
    
    // delete surplus tabs and spaces
    strMLFB = replace( strMLFB, '\t', ' ' );
    while ( strMLFB.indexOf( '  ' ) > -1 )
        strMLFB = replace( strMLFB, '  ', ' ' );
    
    return( strMLFB );
}


/**
 * Parse freetext string to object structure
 *
 * @param strFreetext - freetext input from user (may be empty)
 * @param bDontModifyText - don't modify the case of the option text (optional)
 *
 * @return object - contains a attribute-value pair for each short description and its freetext value
 *                  strError (optional): additional error message (only available in case an error occured)
 *                  example: oShortDescriptions['L1Y'] == '4 IN'
 */
function parseFreetext( strFreetext, bDontModifyText )
{
    var oShortDescriptions = {
        strError: ''
    };
    var oParts = ShortDescriptionParser_getParts( strFreetext );
    if ( oParts.strError !== '' )
        oShortDescriptions.strError = oParts.strError;
    var part, idx, val;
    for ( var i = 0; i < oParts.aParts.length; ++i ) 
    {
        part = new StringHandler( oParts.aParts[i] );
        part = part.split( ':' );
        
        idx = trimright( trimleft( toupper( part[0] ), ' ' ), ' ' );
        if ( part.length > 2 )
        {
            // -og- 130225 if a freetext contains multiple colons, we must use the whole freetext and not only the text up to the first colon
            for ( var j = 2; j < part.length; ++j )			
                part[1] += ':' + part[j];
        }
        if ( bDontModifyText )
            val = trimright( trimleft( part[1], ' ' ), ' ' );
        else val = trimright( trimleft( tolower( part[1] ), ' ' ), ' ' );
        
        if(!val && part[1] && part[1].length > 0)
            val = part[1];
        
        if ( idx in oShortDescriptions )
            oShortDescriptions.strError += ( oShortDescriptions.strError ? ', ' : '' ) + translate( 'ERRORMSG_1FG1___MLFB_OPTION_DUPLICATE' ) + ' ' + idx;
        oShortDescriptions[idx] = val;
    }
    
    return( oShortDescriptions );
}

/**
 * splits a text into rows with the maximal number of characters give
 *
 * @param str - text to split
 * @param nMaxChars - maximum number of characters for a row
 *
 * @return array - rows of splitted texts
 */
function splitText( str, nMaxChars )
{
    var output = [];
    var c = '';
    var w = '';
    var index1 = 0;
    var index2 = 0;
    var MAX_CHARS = ( nMaxChars || 32 );
    
    for (var i=0; i<str.length; i++)
    {
        c = str.charAt(i);
        
        if (c == '.' || c == ',' || c == '-' || c == ':' || c == ';' || c == '\t' || c == ' ' || c == '\r' || c == '\n' || i == str.length-1)
        {
            if (i-index1+1 > MAX_CHARS)
            {
                if (index1 != index2 && c != '\r' && c != '\n')
                {
                    if (str.charAt(index2) == ' ' || str.charAt(index2) == '\t')
                        w = str.substring(index1, index2);
                    else
                        w = str.substring(index1, index2+1);
                    
                    index1 = index2+1;
                }
                else
                {
                    w = str.substring(index1, i+1);
                    
                    if (str.charAt(index2) == '\n')
                        index1 = i+1;
                    else
                        index1 = i+2;
                }
                
                output.push(w);
            }
            
            index2 = i;
        }
    }
    
    w = str.substring(index1, str.length);
    if (w != '')
        output.push(w);

    return output;
}

/**
 * This Class parses a given Short Description String
 * There are public methods to get all needed informations
 */
 
function ShortDescriptionParser_getParts( shortDescription )
{
    var parts = [];
    var parse = 0;
    var token = '';
    var len = shortDescription.length;
    var lastChar = '', currentChar = '', strError = '';
    
    for ( var i=1; i <= len; i++ )
    {
        currentChar = mid( shortDescription, i, 1 );
        
        if ( currentChar === '{' ) {
            if ( parse == 1 )	// zwei öffnende Klammern nacheinander
                strError = translate( 'ERRORMSG_1FG1___YPARSER_TOO_MANY_BRACKETS' );
            parse = 1;
        }
        else if ( currentChar === '}' ) {
            if ( parse == 0 )	// schließende Klammer ohne öffnende
                strError = translate( 'ERRORMSG_1FG1___YPARSER_NO_OPENING_BRACKET' );
                
            parse = 0;
            parts.push( token );
            token = '';
        }		
        else if ( parse ) {
            if ( lastChar == " " && currentChar == " " ) {
                ;
            } else {
                token += currentChar;
            }
        }
            
        lastChar = currentChar;	
    }
    
    return( {
        aParts: parts,
        strError : strError
    } );
}



/**
 * @constructor
 * test if a short description is of form ANA with the given starting character x (=necessary short description for MLFB position x)
 *
 * @param strShortDescription - short description to test
 * @param strStartChar - short description must begin with this char
 *
 * @return boolean - true: short description is an ANA description that begins with the start chararcter
 *                   false: short description is not an ANA description that begins with the start chararcter
 */
function isANA( strShortDescription, strStartChar )
{
    return( ( strShortDescription.length === 3 ) && ( strStartChar === strShortDescription.charAt( 0 ) ) &&
              strShortDescription.charAt( 1 ).isDigit() && strShortDescription.charAt( 2 ).isLetter() );
}

    
/**
 * @constructor
 * test if a short description is of form ANN with the given starting character x (=optional short description)
 *
 * @param strShortDescription - short description to test
 * @param strStartChar - short description must begin with this char
 *
 * @return boolean - true: short description is an ANN description that begins with the start chararcter
 *                   false: short description is not an ANN description that begins with the start chararcter
 */
function isANN( strShortDescription, strStartChar )
{
    return( ( strShortDescription.length === 3 ) && ( strStartChar === strShortDescription.charAt( 0 ) ) &&
              strShortDescription.charAt( 1 ).isDigit() && strShortDescription.charAt( 2 ).isDigit() );
}
    
    
function applyValues( base, dialogObject )
{
    if( base && dialogObject && ( typeof( dialogObject ) === 'object' ) )
    {
        var t;
        for( var property in dialogObject )
        {
            t = typeof( dialogObject[property] );			
            if ( ( t !== 'function' ) && ( t !== 'object' ) )
                base[property] = dialogObject[property];
            else if ( t === 'object' )
            {
                if(dialogObject[property] == null)
                    base[property] = null;
                else if((base[property] == null) && (dialogObject[property] != null))
                    base[property] = deepClone(dialogObject[property]);
                
                // recursive deep value copy (don't change references to preserve OK/Cancel semantics for dialog objects)
                applyValues( base[property], dialogObject[property] );
            }
        
        }
    }
}

function isLetter(strValue)
{
    var objRegExp  = /^[a-zA-Z]$/;
    return objRegExp.test(strValue);
}
    
function isDigit(strValue)
{
    var objRegExp  = /^\d/;
    return objRegExp.test(strValue);
}