//@legacy
//#mode(full-ecma)



//@import "VT_1FK7.js"


/*
Checkbox-Attribute setzen und lesen
*/

function getCheckBoxAttributes(strChangedAttribute)
{
    switch (strChangedAttribute){
        case "CB_PASSFEDER_1FK7M":
            // UI_PASSFEDER_1FK7M	Passfeder
            setAttributeFromUICheckbox("UI_PASSFEDER_1FK7M", "CB_PASSFEDER_1FK7M", "T", "F");
        break;
        case "CB_WELLENAUSF_1FK7M":
            // UI_WELLENAUSF_1FK7M	Wellenausführung
            setAttributeFromUICheckbox("UI_WELLENAUSF_1FK7M", "CB_WELLENAUSF_1FK7M", "ALT", "STD");
        break;
        
        case "CB_O_B02_1FK7M":
            // O_B02_1FK7M	Werksprüfzeugnis	B02, F
            setAttributeFromUICheckbox("O_B02_1FK7M", "CB_O_B02_1FK7M", "B02", "F");
        break;
        
        //3.3.2022 der Case wird hinzugefügt, um den Test erfolgreich auszuführen
    	case "CB_O_Y84_1FK7M":
            // O_Y84_1FK7M	Kundenangabe auf dem Leistungsschild		Y84, F
            setAttributeFromUICheckbox("O_Y84_1FK7M", "CB_O_Y84_1FK7M", "Y84", "F");
        break;
        
    	case "CB_O_N16_1006091":
            // O_N16_1006091	Ausführung für erhöhte chemische Beständigkeit	N16, F
            setAttributeFromUICheckbox("O_N16_1006091", "CB_O_N16_1006091", "N16", "F");
        break;
		case "CB_O_Q20_1FK7M":
            // O_Q20_1FK7M	Anschluss zum Druckausgleich	Q20, F
            setAttributeFromUICheckbox("O_Q20_1FK7M", "CB_O_Q20_1FK7M", "Q20", "F");
        break;
        case "CB_O_L13_1FK7M":
            // O_L13_1FK7M	Äusserer Erdungsanschluss	L13, F
            setAttributeFromUICheckbox("O_L13_1FK7M", "CB_O_L13_1FK7M", "L13", "F");
        break;
		case "CB_O_R06_1FK7M":
            // O_R06_1FK7M	Referenzmarke auf Motorwelle		R06, F
            setAttributeFromUICheckbox("O_R06_1FK7M", "CB_O_R06_1FK7M", "R06", "F");
        break;
        case "CB_O_R72_1FK7M":
            // O_R72_1FK7M	Sondergeber			R72, F
            setAttributeFromUICheckbox("O_R72_1FK7M", "CB_O_R72_1FK7M", "R72", "F");
        break;
        case "CB_PMD_ABU209_001_000_1FK7M":
            // PMD_ABU209_001_000_1FK7M	Drive-CLiQ	T, F
            setAttributeFromUICheckbox("PMD_ABU209_001_000_1FK7M", "CB_PMD_ABU209_001_000_1FK7M", "T", "F");
        break;
        case "CB_O_Q30_Q31_1FK7M":
            // O_Q30_Q31_1FK7M	Metall-Leistungsschild am Motor	Q31, F
            setAttributeFromUICheckbox("O_Q30_Q31_1FK7M", "CB_O_Q30_Q31_1FK7M", "Q31", "F");
        break;

    }
}
function setCheckBoxAttributes()
{
    // UI_PASSFEDER_1FK7M	Passfeder
    setProductLogicToUIAttribute("UI_PASSFEDER_1FK7M", "CB_PASSFEDER_1FK7M", "T", "F");

    // UI_WELLENAUSF_1FK7M	Wellenausführung
    setProductLogicToUIAttribute("UI_WELLENAUSF_1FK7M", "CB_WELLENAUSF_1FK7M", "ALT", "STD");

    // O_B02_1FK7M	Werksprüfzeugnis	B02, F
    setProductLogicToUIAttribute("O_B02_1FK7M", "CB_O_B02_1FK7M", "B02", "F");

    // O_Y84_1FK7M	Kundenangabe auf dem Leistungsschild		Y84, F
    //3.3.2022 Kommentar entfernt, da der Code für den Test benötigt wird
	setProductLogicToUIAttribute("O_Y84_1FK7M", "CB_O_Y84_1FK7M", "Y84", "F");

    // O_N16_1006091	Ausführung für erhöhte chemische Beständigkeit	N16, F
    setProductLogicToUIAttribute("O_N16_1006091", "CB_O_N16_1006091", "N16", "F");

    // O_Q20_1FK7M	Anschluss zum Druckausgleich	Q20, F
	setProductLogicToUIAttribute("O_Q20_1FK7M", "CB_O_Q20_1FK7M", "Q20", "F");

    // O_L13_1FK7M	Äusserer Erdungsanschluss	L13, F
	setProductLogicToUIAttribute("O_L13_1FK7M", "CB_O_L13_1FK7M", "L13", "F");

    // O_R06_1FK7M	Referenzmarke auf Motorwelle		R06, F
    setProductLogicToUIAttribute("O_R06_1FK7M", "CB_O_R06_1FK7M", "R06", "F");

    // O_R72_1FK7M	Sondergeber			R72, F
    setProductLogicToUIAttribute("O_R72_1FK7M", "CB_O_R72_1FK7M", "R72", "F");

    // PMD_ABU209_001_000_1FK7M	Drive-CLiQ	T, F
    setProductLogicToUIAttribute("PMD_ABU209_001_000_1FK7M", "CB_PMD_ABU209_001_000_1FK7M", "T", "F");

    // O_Q30_Q31_1FK7M	Metall-Leistungsschild am Motor	Q31, F
    setProductLogicToUIAttribute("O_Q30_Q31_1FK7M", "CB_O_Q30_Q31_1FK7M", "Q31", "F");
}

/**
Funktion zur Übertragung des Logik-Auswahl-Zustandes eines Attributes (eingeschränkt durch Produktlogik) auf ein UI-Checkbox Attribut.

*/
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute)
{
    return setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setProductLogicToUIAttribute(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";
    
    var aValidValues = ECL_GetAllActiveAttributeValues(sOrg_Attribute);
    var bValue_T_valid = false;
    var bValue_F_valid = false;
    
    if (aValidValues.length > 0){
        for (var i=0; i < aValidValues.length; i++){
            if (aValidValues[i] == sVal_True){
                bValue_T_valid = true;
            }
            if (aValidValues[i] == sVal_False){
                bValue_F_valid = true;
            }
        }
        
        if (bValue_T_valid && bValue_F_valid){
            ECL_EnableAttribute(sUI_Attribute);
            var sValue = ECL_GetValue(sOrg_Attribute);
            if (sValue == sVal_True){
                ECL_SelectValue(sUI_Attribute, "T");
            }else{
                ECL_DeselectAttribute(sUI_Attribute);
            }
        }
        else if (bValue_T_valid && !bValue_F_valid){
            ECL_SelectValue(sUI_Attribute, "T");
            ECL_DisableAttribute(sUI_Attribute);
        }
        else if (!bValue_T_valid && bValue_F_valid){
            ECL_DeselectAttribute(sUI_Attribute);
            ECL_DisableAttribute(sUI_Attribute);
        }
    }else{
        ECL_DeselectAttribute(sUI_Attribute);
        ECL_DisableAttribute(sUI_Attribute);
        return 0;
    }
    return 1;
}

/**
Funktion zur Übertragung des Auswahl-Zustandes eines UI-Checkbox-Attributes auf das Original-Attribut.
sOrg_Attribute:	original Produkt-Attrubut, welches durch die Produktlogik gesteuert wird
sUI_Attribute:	UI-Attribut mit Checkbox, auf welches die Logik gespiegelt wird
sValue_True:	Wert 'Ja' des Original-Attributes, wenn er von "T" abweicht		(optional)
sValue_False:	Wert 'Nein' des Original-Attributes, wenn er von "F" abweicht	(optional)
*/
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute)
{
    return setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, "T", "F");
}
function setAttributeFromUICheckbox(sOrg_Attribute, sUI_Attribute, sValue_True, sValue_False)
{
    sVal_True  = sValue_True  || "T";
    sVal_False = sValue_False || "F";
    
    if (ECL_ValueSelected(sUI_Attribute, "T")){
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_True)) {
            ECL_SetValue(sOrg_Attribute, sVal_True);
            
        }else{
            
            if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
                ECL_SetValue(sOrg_Attribute, sVal_False);
            }
            
            ECL_DeselectAttribute(sUI_Attribute);
            ECL_DisableAttribute(sUI_Attribute);
            return 0;
        }
    }else{
        
        if (ECL_ValueEnabled(sOrg_Attribute, sVal_False)) {
            ECL_SetValue(sOrg_Attribute, sVal_False);
        }else{
            return 0;
        }
    }
    return 1;
}
