//@legacy
//#mode(full-ecma)




// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration

// ###################################################################################################################################
// Consequence-Attributes
// ###################################################################################################################################

// ECSI_CC_AdditionalInertia

// IpProtectionLevelMotor

// SensorModule
/*
String.Empty	No sensor module selected
String			Order number as MLFB without separating "-"
*/

// SensorModuleLocation
/*
0	No sensor module selected
1	Outside the cabinet (SME)
2	Inside the cabinet (SMC)
*/

// ECSI_CC_BrakeID

// GearboxOil
/*
1	CLP-ISO-VG220		K06
2	CLP-ISO-PAO-VG220	
3	CLP-ISO-PAO-VG68
4	CLP-ISO-PAO-VG460
5	CLP-ISO-PG-VG460	K08
6	CLP-ISO-PG-VG220	K07
7	CLP-ISO-H1-VG460	K11
8	CLP-ISO-H1-VG100
9	CLP-ISO-E-VG220
 
O_K06_K07_K08_K11_1FG1S
 
K06	Mineralöl CLP ISO VG220
K07	Polyglycol Öl CLP ISO PG VG220
K08	Polyglycol Öl CLP ISO PG VG460
K11	Lebensmittelöl CLP ISO H1 VG460
 
//	ECSI_CC_GearboxOil
* /
var sOelSorte = ECL_GetValue("O_K06_K07_K08_K11_1FG1S");
var ECSI_CC_GearboxOil = "";
switch(sOelSorte){
    case "K06":
        ECSI_CC_GearboxOil = "1";
    break;
    case "K07":
        ECSI_CC_GearboxOil = "6";
    break;
    case "K08":
        ECSI_CC_GearboxOil = "5";
    break;
    case "K11":
        ECSI_CC_GearboxOil = "7";
    break;
    default:
        ECSI_CC_GearboxOil = "";
}
 
ECL_SetValue("ECSI_CC_GearboxOil", ECSI_CC_GearboxOil);
 
// OutputShaftLength
/*
Double [mm]		Length of the output shaft in mm
*/

// GearboxOutputShaftType
/*
V	Solid output shaft. Shaft type: V & VG
P	"Solid output shaft in combination with 
    mounting type flange (forward positioned bearing).
    Shaft type: V & VG"
W	"Solid output shaft with two shaft ends.
    Shaft type: VD"
H	"Hollow output shaft.
    Shaft type: H, HF, HS, HX & N"
U	"Mixer hollow output shaft (bearing VLplus).
    Shaft type: HM"
M	"Mixer solid output shaft (bearing VLplus).
    Shaft type: VM"
R	"Agitator solid output shaft i2 ≠ l (bearing XLplus).
    Shaft type: VR  "
C	"Cooling tower solid output shaft i2 ≠ l.
    Shaft type: VC"

*/

// GearboxOutputShaftDiameter	Double [mm]	Diameter of the output shaft in mm

// GearboxMountingType
/*
F	Foot-mounted 
B	Foot/flange-mounted
P	Flange-mounted i2=l
Z	Housing flange 
D	Mounted with torque support 
 
*/

// GearboxReinforcedBearing
/*
0	Standard bearing of output shaft
1	Reinforced bearing of output shaft
2	XLPlus
3	VLPlus
*/

// SelectedGearboxAdapterID ????


function determineConsequences(sECSI_MLFB) {
    var normalizedMLFB = replace(sECSI_MLFB, '-Z', '');
    normalizedMLFB = replace(sECSI_MLFB, '-', '');
    var baseMLFB = left(normalizedMLFB, 16);
    var ka = right(normalizedMLFB, (normalizedMLFB.length > 16) ? normalizedMLFB.length - 16 : 0);
    var strErr = "";

    var aShaftParams = getOutputShaft();
    if (aShaftParams == "ERROR") {
        strErr = "ERR: ShaftParams";
    }
    /*
        [GearboxOutputShaftType, 
         GearboxOutputShaftDiameter,
         OutputShaftLength];
    */

    var oConsequences = {
        AdditionalInertia: getAdditionalInertia(sECSI_MLFB),
        //MinPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MinPulseFrequency', 		'max'),
        //MaxPulseFrequency			: determineOneConsequence(baseMLFB, ka, 'MaxPulseFrequency', 		'max'),
        //AllowedControlModes		: getAllowedControlModes,
        IpProtectionLevelMotor: getIpProtectionLevelMotor(),
        //	SensorModule				: getSensorModule(),
        BrakeID: getBrakeID(sECSI_MLFB),
        //	GearboxOil					: getGearboxOil(),
        GearboxOutputShaftType: aShaftParams[0],
        GearboxOutputShaftDiameter: aShaftParams[1],
        OutputShaftLength: aShaftParams[2],
        GearboxMountingType: "P",
        //	GearboxReinforcedBearing	: getGearboxReinforcedBearing(),
        //SelectedGearboxAdapterID	: getSelectedGearboxAdapterID(),
        Error_Message: strErr
    }

    return oConsequences;
}

// consequence = name in database table
// operator = max | min | sum

// pro consequence kann es mehrere Origins geben, deren Resultate mit dem Operator verknüpft werden müssen
// Innerhalb einer Origin soll immer nur eine Tabellenzeile verwendet werden, wobei die allgemeinste am Ende kommen muss (daher das DESC im order by)
function determineOneConsequence(baseMLFB, ka, consequence, operator) {
    var dRet = 0;
    if (operator == 'min')
        dRet = 99999;

    var aOrigins = Object.fromDatabase("1FK7_ADD_DATA", "select distinct ORIGIN from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' ") || [];

    for (var i = 0; i < aOrigins.length; i++) {
        var resval = determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, aOrigins[i].ORIGIN);
        if (resval != -99999) {
            if ((operator == 'min') && (resval < dRet))
                dRet = resval;
            else if ((operator == 'max') && (resval > dRet))
                dRet = resval;
            else if (operator == 'sum')
                dRet += resval;
        }
    }
    var strRet = '';
    if ((dRet != 0) && (dRet != 99999))
        strRet = '' + dRet;	// als String zurückliefern
    return strRet;
}

function determineOneConsequenceOrigin(baseMLFB, ka, consequence, operator, origin) {
    var aResult = Object.fromDatabase("1FK7_ADD_DATA", "select * from CONSEQUENCES where CONSEQUENCE = '" + consequence + "' and ORIGIN = '" + origin + "' order by OPTION DESC");

    for (var i = 0; i < aResult.length; i++) {
        var mlfbPattern = aResult[i]['PATTERN'];
        var dbKAG = aResult[i]['OPTION'];
        var origin = aResult[i]['ORIGIN'];			// für jeden Origin nur max. einen Wert bestimmen
        var resval = aResult[i]['RES_VALUE'] - 0;	// Wert als Zahl bestimmen

        var matchP = true;
        if (mlfbPattern) {
            if (!EK_regFound(baseMLFB, mlfbPattern))
                matchP = false;
        }
        var matchK = true;
        if (dbKAG) {
            if (find(ka, dbKAG) < 0)
                matchK = false;
        }
        if (matchP && matchK) {
            return resval;
        }
    }
    return -99999;
}

function getAdditionalInertia(sECSI_MLFB) {
    // Keine Trägheitsmomente für Bremse, da dies der SIZER selbst addiert!!!

    // für Planetengetriebe gilt Wert aus VT196 bzw. VT206 für Läufer + Wert aus VT110 für Getriebe (Planetengetriebe SP/NP) oder DYA aus VT222 inkl. Läufer
    /* wenn Planetengetriebe und keine Bremse gewählt
        c.HMK_TRAEGHEITSMOMENT_1FK7M =
        c.PMD_AAB904_001_000_1FK7M + c.PMD_ABW817_001_000_1FK7M
    */
    var AdditionalInertia = 0;
/*	var PMD_AAB904_001_000_1FK7M = 0; // Läufer-Trägheitsmoment
    var PMD_ABW817_001_000_1FK7M = 0; // Planetengetriebe-Trägheitsmoment
    var HMK_AAB904_DYA_1FK7M = 0; 	  // DYA-Planetengetriebe-Trägheitsmoment inkl. Läufer
    
    // VT 206 VT_1FK7M_M00206_19624
    // MLFB_RUMPF_01_11_1FK7M	PMD_ABJ541_001_000_1FK7M	PMD_ABV866_001_000_1FK7M	PMD_ABV867_001_000_1FK7M	PMD_ABV876_001_000_1FK7M	PMD_ABV877_001_000_1FK7M	PMD_ABJ560_001_000_1FK7M	
    // PMD_AAB904_001_000_1FK7M	PMD_ACC394_001_000_1FK7M	PMD_ABV857_001_000_1FK7M	PMD_ABV862_001_000_1FK7M	PMD_ABH356_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
    var MLFB_RUMPF_01_11_1FK7M = sECSI_MLFB.left(11);
    
    var sSQL = "SELECT DISTINCT PMD_AAB904_001_000_1FK7M FROM VT_1FK7M_M00206_19624 WHERE MLFB_RUMPF_01_11_1FK7M = '" + MLFB_RUMPF_01_11_1FK7M + "' AND HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, "VT_1FK7M_M00206_19624"+"_CC");
    if (aResult.length > 0)
    {
        PMD_AAB904_001_000_1FK7M = parseFloat(aResult[0].PMD_AAB904_001_000_1FK7M);
        
    }else{
        return "ERROR";
    }
    
    //PMD_ABV517_001_000_1FK7M	Art des Getriebes
    var PMD_ABV517_001_000_1FK7M = ECL_GetValue("PMD_ABV517_001_000_1FK7M");
    if (PMD_ABV517_001_000_1FK7M == "Z0001"){
        // Wenn Getriebeart == Z0001 (Kompakt-Planetengetriebe DYA)
        // HMK_TRAEGHEITSMOMENT_1FK7M = HMK_AAB904_DYA_1FK7M
        
        // VT222 VT_1FK7M_M00222_19624
        /* 	HMK_OPT_GETRIEBE_1FK7M	MLFB08_1FK7M	HMK_AAB904_DYA_1FK7M	HMK_VALUE_VALID_1FK7M
            (HMK_DYA_ABW913_1FK7M	HMK_DYA_ABV857_1FK7M	PMD_ABW814_001_000_1FK7M	PMD_ABW812_001_000_1FK7M	HMK_DYA_ABV876_1FK7M	
            PMD_ABW811_001_000_1FK7M	HMK_ABJ560_DYA_1FK7M		HMK_DYA_ABJ545_1FK7M	HMK_DYA_ABW174_1FK7M	HMK_DYA_ABV884_1FK7M	HMK_DYA_AAB326_1FK7M)
        */
/*		var HMK_OPT_GETRIEBE_1FK7M = ECL_GetValue("HMK_OPT_GETRIEBE_1FK7M");
        var MLFB08_1FK7M = sECSI_MLFB.charAt(7);
        
        var sSQL = "SELECT DISTINCT HMK_AAB904_DYA_1FK7M FROM VT_1FK7M_M00222_19624 WHERE " +
                    "HMK_OPT_GETRIEBE_1FK7M = '" + HMK_OPT_GETRIEBE_1FK7M + "' AND " + 
                    "MLFB08_1FK7M = '" 			 + MLFB08_1FK7M 		  + "' AND " + 
                    "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, "VT_1FK7M_M00222_19624"+"_CC");
        if (aResult.length > 0)
        {
            HMK_AAB904_DYA_1FK7M = parseFloat(aResult[0].HMK_AAB904_DYA_1FK7M);
            
        }else{
            return "ERROR";
        }
        AdditionalInertia = HMK_AAB904_DYA_1FK7M;
        
    }else if (PMD_ABV517_001_000_1FK7M == "00007" || PMD_ABV517_001_000_1FK7M == "00008"){
        // Wenn Planetengetriebe: Getriebeart == 00007	Planetengetriebe SP+ oder 00008	Planetengetriebe NP+
        // HMK_TRAEGHEITSMOMENT_1FK7M = PMD_AAB904_001_000_1FK7M + PMD_ABW817_001_000_1FK7M
        // PMD_ABW817_001_000_1FK7M
        
        // VT_1FK7M_M00110_19624
        // PMD_ABV410_001_000_1FK7M	PMD_ABV413_001_000_1006091	MLFB05_06_1FK7M	PMD_ABW817_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
        var PMD_ABV410_001_000_1FK7M = ECL_GetValue("PMD_ABV410_001_000_1FK7M");
        var PMD_ABV413_001_000_1006091 = ECL_GetValue("PMD_ABV413_001_000_1006091");
        var MLFB05_06_1FK7M = sECSI_MLFB.charAt(4) + sECSI_MLFB.charAt(5);
        
        
        var sSQL = "SELECT DISTINCT PMD_ABW817_001_000_1FK7M FROM VT_1FK7M_M00110_19624 WHERE " +
                    "PMD_ABV410_001_000_1FK7M = '"   + PMD_ABV410_001_000_1FK7M   + "' AND " + 
                    "PMD_ABV413_001_000_1006091 = '" + PMD_ABV413_001_000_1006091 + "' AND " + 
                    "MLFB05_06_1FK7M = '" 			 + MLFB05_06_1FK7M 		  + "' AND " + 
                    "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, "VT_1FK7M_M00110_19624"+"_CC");
        if (aResult.length > 0)
        {
            PMD_ABW817_001_000_1FK7M = parseFloat(aResult[0].PMD_ABW817_001_000_1FK7M);
            
        }else{
            return "ERROR";
        }
        
        AdditionalInertia = PMD_AAB904_001_000_1FK7M + PMD_ABW817_001_000_1FK7M;
        
    }else{
        // Kein Getriebe, nur Läufer (Bremse wird vom SIZER addiert)
        AdditionalInertia = PMD_AAB904_001_000_1FK7M;
    }
*/	return AdditionalInertia;
}

function getIpProtectionLevelMotor() {
    // PMD_ABJ176_001_000_1FK7M  	Schutzart
    var IpProtectionLevelMotor = "";
    /*
    Z0037	IP54
    Z0011	IP64
    Z0023	IP65
    Z0042	IP65 und DE-Flansch IP67
    00043	IP54/64
    00044	IP54/65
    00045	IP54/65 und DE-Flansch IP67
    */
    var PMD_ABJ176_001_000_1FK7M = ECL_GetValue("PMD_ABJ176_001_000_1FK7M");

    switch (PMD_ABJ176_001_000_1FK7M) {
        case "Z0037":
        case "00043":
        case "00044":
        case "00045":
            IpProtectionLevelMotor = "54";
            break;

        case "Z0011":
            IpProtectionLevelMotor = "64";
            break;

        case "Z0023":
        case "Z0042":
            IpProtectionLevelMotor = "65";
            break;
    }
    return IpProtectionLevelMotor;
}


//	GearboxOutputShaftType
//	OutputShaftLength
//	GearboxOutputShaftDiameter
function getOutputShaft() {
    /* GearboxOutputShaftType
    V	Solid output shaft. Shaft type: V & VG
-->	P	"Solid output shaft in combination with 
        mounting type flange (forward positioned bearing).
        Shaft type: V & VG"
    W	"Solid output shaft with two shaft ends.
        Shaft type: VD"
    H	"Hollow output shaft.
        Shaft type: H, HF, HS, HX & N"
    U	"Mixer hollow output shaft (bearing VLplus).
        Shaft type: HM"
    M	"Mixer solid output shaft (bearing VLplus).
        Shaft type: VM"
    R	"Agitator solid output shaft i2 ≠ l (bearing XLplus).
        Shaft type: VR  "
    C	"Cooling tower solid output shaft i2 ≠ l.
        Shaft type: VC"
    */

    var GearboxOutputShaftType = "P";
    var sD = "";
    var sL = "";

    var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");

    if (HMK_KONFIG_ZIEL_1FK7M == "SERVO") {

        // PMD_ABV414_001_000_1FK7M		Wellenende
        //var PMD_ABV414_001_000_1FK7M = ECL_GetValue("PMD_ABV414_001_000_1FK7M");
        /*
        n.n.Z0001	Hohlwelle mit Passfedernut
        n.n.Z0002	Hohlwelle mit Spannelement
        Z0003	Mit Passfeder
        Z0004	Ohne Passfeder
        n.n.Z0005	Vollwelle mit Passfeder
        Z0006	Passfeder u. Passfedernut
        n.n.00009	Kein Wert
        */

        //UI_WELLENMASZ_1FK7M	Wellenende D x Länge
        var UI_WELLENMASZ_1FK7M = ECL_GetValue("UI_WELLENMASZ_1FK7M");

        var iPosBlanc = UI_WELLENMASZ_1FK7M.indexOf("_");
        sD = UI_WELLENMASZ_1FK7M.substring(0, iPosBlanc);
        sL = UI_WELLENMASZ_1FK7M.substring(iPosBlanc + 1, UI_WELLENMASZ_1FK7M.length);

    } else {
        var PMD_ABV410_001_000_1FK7M = ECL_GetValue("PMD_ABV410_001_000_1FK7M");

        if (PMD_ABV410_001_000_1FK7M != "00048") {

            var sTable = "VT_1FK7M_M00265" + sDB_Suffix;
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "';";

            var aResult = GetDBDataSetEXT(sSQL, sTable + "_PL");
            if (aResult.length > 0) {
                // HMK_ACB769_1FK7M	Durchmesser der Welle (D2)
                sD = aResult[0].HMK_ACB769_1FK7M;
                // HMK_ACB783_1FK7M	Länge der Welle (L)
                sL = aResult[0].HMK_ACB783_1FK7M;
            }
        }
    }


    var GearboxOutputShaftDiameter = sD;
    var OutputShaftLength = sL;

    var aConsequences = [GearboxOutputShaftType,
        GearboxOutputShaftDiameter,
        OutputShaftLength];

    return aConsequences;
}



function getBrakeID(sECSI_MLFB) {
    /**
    
    //Bremsen Consequences
    */
    var sBrakeID = "";
    var UI_HALTEBREMSE_1FK7M = ECL_GetValue("UI_HALTEBREMSE_1FK7M"); // OHNE, M_FK7, N24
    /*
    Mit Bremse: M_FK7
    N24: Verstärkte Bremse
    */

    var sTable = "BRAKE_ID";
    // SZ_MBC_M_OrderNumber	SZ_MBC_M_ShortOptions	SZ_MBC_BrakeId	SZ_MBC_IsDefaultBrake

    // SZ_MBC_M_OrderNumber == 1FK7xxx
    // SZ_MBC_M_ShortOptions == N24 oder #NO_DATA#

    var MLFB05_1FG1S = sECSI_MLFB.charAt(4);
    var MLFB06_1FG1S = sECSI_MLFB.charAt(5); //Getriebe Stufen
    var MLFB08_1FG1S = sECSI_MLFB.charAt(7); //Getriebe	BG2

    var MLFB_05_06_07_1FG1S = sECSI_MLFB.charAt(4) + sECSI_MLFB.charAt(5) + sECSI_MLFB.charAt(6); //Getriebe

    if (UI_HALTEBREMSE_1FK7M == "M_FK7") {

        if (MLFB_05_06_07_1FG1S == "100") {
            // 1FK7100???????{B;H}?
            //var sMLFBpattern = "1FK7100???????{B;H}?";
            var sBrakeID = "1FK7100";
        } else if (MLFB_05_06_07_1FG1S == "101" || MLFB_05_06_07_1FG1S == "103" || MLFB_05_06_07_1FG1S == "105") {
            // 1FK710{1;3;5}???????{B;H}?
            //var sMLFBpattern = "1FK710{1;3;5}???????{B;H}?";
            var sBrakeID = "1FK7101";
        } else if (MLFB05_1FG1S == "0") {
            //var sMLFBpattern = "1FK70" + MLFB06_1FG1S + "????????{B;H}?";
            var sBrakeID = "1FK70" + MLFB06_1FG1S;
        } else {
            return "ERROR: Kein Treffer für BrakeID.";
        }

        // SZ_MBC_M_OrderNumber	SZ_MBC_M_ShortOptions	SZ_MBC_BrakeId	SZ_MBC_IsDefaultBrake
        /*	var sSQL = "SELECT SZ_MBC_BrakeId FROM BRAKE_ID WHERE " +
                        "SZ_MBC_M_OrderNumber = '"+sMLFBpattern+"' AND " + 
                        "SZ_MBC_M_ShortOptions = '#NO_DATA#';";
        */
    } else if (UI_HALTEBREMSE_1FK7M == "N24") { // Verstärkte Bremse

        if (MLFB_05_06_07_1FG1S == "101" || MLFB_05_06_07_1FG1S == "103" || MLFB_05_06_07_1FG1S == "105") {
            // 1FK710{1;3;5}???????{B;H}?
            //var sMLFBpattern = "1FK710{1;3;5}???????{B;H}?";
            var sBrakeID = "1FK710_N24";
        } else if (MLFB05_1FG1S == "0") {

            if (MLFB_05_06_07_1FG1S == "086" && MLFB08_1FG1S == "4") {
                // 1FK70864??????{B;H}?
                //var sMLFBpattern = "1FK70864??????{B;H}?";
                var sBrakeID = "1FK70864_N24";
            } else if (MLFB_05_06_07_1FG1S == "044" && MLFB08_1FG1S == "4") {
                // 1FK70444??????{B;H}?
                //var sMLFBpattern = "1FK70444??????{B;H}?";
                var sBrakeID = "1FK70444_N24";
            } else {
                // 				1FK70	{3,4, 6, 8}
                var sBrakeID = "1FK70" + MLFB06_1FG1S + "_N24";
            }
        } else {
            //Fehler
            return "ERROR: Kein Treffer für BrakeID.";
        }
    }
    else {
        sBrakeID = "";
    }

    return sBrakeID;
}