//@legacy
//#mode(full-ecma)



//@import "VT_1FK7.js"


/*
Ex-Schutz

O_M03_M39_1FK7M	Ausführung für explosionsgefährdete Bereiche

M03		Zone 2 nach EN5...IEC 60079-15
M39		Zone 22 nach EN.../IEC 61241-1
OHNE	Ohne


*/

function SetEX_Schutz_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_ExSchutz(oData); 	 		// O_M03_M39_1FK7M	Ausführung für explosionsgefährdete Bereiche
        //ECL_SetValue("O_M03_M39_1FK7M","OHNE"); // EDIT 2021.06 TFS 5601046	1FK7 - hide ex Option M03/M39
    }else{
        ExecSetStandardifValueEmpty("O_M03_M39_1FK7M","OHNE"); // /* EDIT 2021.06 TFS 5601046	1FK7 - hide ex Option M03/M39
    }
}

function SetEX_Schutz(strchangedAttribute, oData)
{
}

/**
    O_M03_M39_1FK7M	Ausführung für explosionsgefährdete Bereiche
*/

function Bestimme_ExSchutz(oData)
{
    // O_M03_M39_1FK7M
    // KAG: M03, M39, OHNE
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_M03_M39_1FK7M";
    var bCheck = false;
    
    // Context-Attribute abfragen
    /**
        Gas
            Null	None			SAFE
            2	Ex ec (Zone 2)		EXN			M03		<---O_M03_M39_1FK7M
            1	Ex db (Zone 1)		EXE, EXD
        Dust
            Null	None			SAFE
            22	Ex tc (Zone 22)		EXTC		M39		<---O_M03_M39_1FK7M
            21	Ex tb (Zone 21)		EXTB
    */
    var ECSI_CX_MinimalExplosionProtectionGas = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionGas") || "";
    var ECSI_CX_MinimalExplosionProtectionDust = ECL_GetValue("ECSI_CX_MinimalExplosionProtectionDust") || "";
    
    if (ECSI_CX_MinimalExplosionProtectionGas == "2"){
        var sKAGgefordert = "M03";
    }
    if (ECSI_CX_MinimalExplosionProtectionDust == "22"){
        var sKAGgefordert = "M39";
    }
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    
    if (sKAG == "NON" && sKAGgefordert){
        sKAG = sKAGgefordert;
    }
    
    if (sKAG != "NON"){
        if (oData.IsDriveTrain == 1){
			bCheck = false;
		}else{
			// es gibt eine KAG, also prüfen, ob erlaubt
			bCheck = checkExSchutz(oData, sTargetAttribute, sKAG);
		}
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, OHNE setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "OHNE");
        ECL_SetValue(sTargetAttribute, "OHNE");
        
        if (sKAGgefordert){
            //var sErr = "Geforderter Exschutz nicht zulässig!";
			oData.strError = "DICT1_ERR_1FK7___PARSER_EX_PROTECT_NOT_SUPPORTED";
			return;
        }
    }
}
function checkExSchutz(oData, sTargetAttribute, sKAG)
{
    // Edit 02.2023 no ATEX options 48952 - Remove 1FK7 ATEX options until the related feature is done
	return 0;
	// End Edit 02.2023 no ATEX options 48952 - Remove 1FK7 ATEX options until the related feature is done
    /*
    VT_1FK7M_M00155_19624	O: Q20 <-> M03, M39
        O_Q20_1FK7M	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00165_19624	O: M03/M39 red. DZ <> Rumpf
        MLFB_RUMPF_01_11_1FK7M	O_M03_M39_1FK7M	T_MAX_DREHZ_REDUZIER_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00170_19624	O: M03/M39 einschränken
        O_M03_M39_1FK7M	HMK_KONFIG_ZIEL_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	PMD_ABJ176_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00220_19624	O: L13, N16, M* einschränken
        O_L13_1FK7M	O_N16_1006091	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M
    
    NEU	VT_1FK7M_M00253	ZO N24 <> M03/M39
        UI_HALTEBREMSE_1FK7M	O_M03_M39_1FK7M
    todo, wenn wieder freigegeben
        
    */
    /*var O_Q20_1FK7M = ECL_GetValue("O_Q20_1FK7M");
    
    var sTable = "VT_1FK7M_M00155" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "O_Q20_1FK7M = '" + O_Q20_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }*/
    //--------------------------------------------------------------------------------------------------------------
    var MLFB_RUMPF_01_11_1FK7M = oData.oParsingData.RUMPF;
    
    var sTable = "VT_1FK7M_M00165" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB_RUMPF_01_11_1FK7M = '" + MLFB_RUMPF_01_11_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
    var PMD_ABJ176_001_000_1FK7M = ECL_GetValue("PMD_ABJ176_001_000_1FK7M");
    var MLFB09_1FK7M = oData.oParsingData.MLFB.POS9;
    var MLFB14_1FK7M = oData.oParsingData.MLFB.POS14;
    
    var sTable = "VT_1FK7M_M00170" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                "PMD_ABJ176_001_000_1FK7M = '" + PMD_ABJ176_001_000_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    //var O_L13_1FK7M = ECL_GetValue("O_L13_1FK7M");
    var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
    
    var sTable = "VT_1FK7M_M00220" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                //"O_L13_1FK7M = '" + O_L13_1FK7M + "' AND " +
                "O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ##############################################################################################
