//@legacy
//#mode(full-ecma)



//@import "VT_1FK7.js"


/*
HMK_FARBAUSFUEHRUNG_1006091	Ausführung
O_X01__X27_1FK7M			Farbe


PMD_ABV482_001_000_1FK7M	Grundierung / des Gehäuses
PMD_AAD756_001_000_1FK7M	Farbe / des Gehäuses


*/

function SetFarbe_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Farbausfuehrung(oData); 	// HMK_FARBAUSFUEHRUNG_1006091	Ausführung
        //Bestimme_Farbe(oData); 				// Farbe					O_X01__X27_1FK7M	
    } else {
        ExecSetStandardifValueEmpty("HMK_FARBAUSFUEHRUNG_1006091","00001"); // Lackierung
        ExecSetStandardifValueEmpty("O_X01__X27_1FK7M","STD");				// Farbe
    }
}

function SetFarbe(strchangedAttribute, oData)
{
}

/**
00001	Lackierung
K23	Sonder-Lackieru...Grundierung)
K24	Grundierung (ohne Lackierung)
00004	ohne Lackierung und ohne Grundierung  mit MLFB16 und Schutzart eindeutig

*/
function Bestimme_Farbausfuehrung(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    // HMK_FARBAUSFUEHRUNG_1006091
    // KAG: 00001, K23, K24, 00004
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_FARBAUSFUEHRUNG_1006091";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
	var HMK_FARBAUSFUEHRUNG_1006091 = "00001";
	
	if (oData.IsDriveTrain == 1)
	{
		sKAG = "K24";
		var HMK_FARBAUSFUEHRUNG_1006091 = sKAG;
	}
	
	if (sKAG != "NON"){
		// es gibt eine KAG, also prüfen, ob erlaubt
		bCheck = checkFarbausfuehrung(oData, sTargetAttribute, sKAG);
	}
	
	if (bCheck){
        // wenn erlaubt, setzen
        HMK_FARBAUSFUEHRUNG_1006091 = sKAG;
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, 00001 oder 00004 setzen
    else{
        // VT_1FK7M_M00182_19624
        //MLFB05_06_08_1FK7M	HMK_FARBAUSFUEHRUNG_1006091	PMD_ABJ176_001_000_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M
        var MLFB05_06_08_1FK7M = oData.oParsingData.MLFB.POS5_6_8;
        var MLFB16_1FK7M = oData.oParsingData.MLFB.POS16;
        var PMD_ABJ176_001_000_1FK7M = ECL_GetValue("PMD_ABJ176_001_000_1FK7M");
        
        var sTable = "VT_1FK7M_M00182" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT HMK_FARBAUSFUEHRUNG_1006091 FROM " + sTable + " WHERE " +
                    "MLFB05_06_08_1FK7M = '" 		+ MLFB05_06_08_1FK7M 		+ "' AND " +
                    "MLFB16_1FK7M = '" 		 		+ MLFB16_1FK7M 				+ "' AND " +
                    "PMD_ABJ176_001_000_1FK7M = '" 	+ PMD_ABJ176_001_000_1FK7M 	+ "' AND " +
                    "(HMK_FARBAUSFUEHRUNG_1006091 = '00001' OR " +
                    "HMK_FARBAUSFUEHRUNG_1006091 = '00004') AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSER");
        if (aResult.length > 0)
        {
            HMK_FARBAUSFUEHRUNG_1006091 = aResult[0].HMK_FARBAUSFUEHRUNG_1006091;
        }else{
            HMK_FARBAUSFUEHRUNG_1006091 = "00001";
        }
        
        ECL_ActivateValue(sTargetAttribute, HMK_FARBAUSFUEHRUNG_1006091);
        ECL_SetValue(sTargetAttribute, HMK_FARBAUSFUEHRUNG_1006091);
    }
    // Wenn keine K23, K24 
    
    // Wenn 00004 oder KAG K24--> keine Farbe, sonst Farbe definieren
    if (HMK_FARBAUSFUEHRUNG_1006091 == "K24" || HMK_FARBAUSFUEHRUNG_1006091 == "00004")
    {
        ECL_SetValue("O_X01__X27_1FK7M", "OHNE");
    }else
    {
        // Farbe aus KAG bestimmen, sonst STD
        var sTargetAttribute = "O_X01__X27_1FK7M";
        var bCheck = false;
        
        // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
        var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
        //var aKAG = parseObj.MLFB.KAG || [];
        
        if (sKAG != "NON"){
            // es gibt eine KAG, Prüfung nicht nötig
            ECL_ActivateValue(sTargetAttribute, sKAG);
            ECL_SetValue(sTargetAttribute, sKAG);
        }else{
            ECL_ActivateValue(sTargetAttribute, "STD");
            ECL_SetValue(sTargetAttribute, "STD");
        }
    }	
}
function checkFarbausfuehrung(oData, sTargetAttribute, sKAG)
{
    /*
    A: VT_1FK7M_M00182_19624	ZO MLFB16 <> Schutzart
        MLFB05_06_08_1FK7M	HMK_FARBAUSFUEHRUNG_1006091	PMD_ABJ176_001_000_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M

    B: VT_1FK7M_M00183_19624	O: N16
        HMK_FARBAUSFUEHRUNG_1006091	O_N16_1006091	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00227_19624	Farbausführung <> Konfig.-ziel
        HMK_FARBAUSFUEHRUNG_1006091	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
        ==> K24 nicht gültig für DYAG2, sonst alle erlaubt
    */
    // A ------------------------------------------------------------------------------------------------------
    var MLFB05_06_08_1FK7M = oData.oParsingData.MLFB.POS5_6_8;
    var MLFB16_1FK7M = oData.oParsingData.MLFB.POS16;
    var PMD_ABJ176_001_000_1FK7M = ECL_GetValue("PMD_ABJ176_001_000_1FK7M");
    
    var sTable = "VT_1FK7M_M00182" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB05_06_08_1FK7M = '" 		+ MLFB05_06_08_1FK7M 		+ "' AND " +
                "PMD_ABJ176_001_000_1FK7M = '"  + PMD_ABJ176_001_000_1FK7M 	+ "' AND " +
                "MLFB16_1FK7M = '" + MLFB16_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    // B ------------------------------------------------------------------------------------------------------
    var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
    
    var sTable = "VT_1FK7M_M00183" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "O_N16_1006091 = '" + O_N16_1006091 		+ "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    // C ------------------------------------------------------------------------------------------------------
    var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
    
    var sTable = "VT_1FK7M_M00227" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M 		+ "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    // ------------------------------------------------------------------------------------------------------
    return 1;
}