//@legacy
//#mode(full-ecma)



//@import "VT_1FK7.js"


/*
UI_GEBER_1FK7M	Ausführung
UI_GEBER_SMC_1FK7M	Geberanbindung.../zulässig
UI_GEBER_AUFLOESUNG_1FK7M	Auflösung
PMD_ABU209_001_000_1FK7M	Produktbestandteil Drive-CLiQ-Schnittstelle
PMD_ABU278_001_000_1FK7M	Ausführung /.../integriert

*/

function SetGeber_Init(oData) {
    if (oData && !isEmpty(oData)) {
        Bestimme_Geberausfuehrung(oData); 	// Drive-CLiQ-Schnittstelle		PMD_ABU209_001_000_1FK7M
        //Bestimme_Geber(oData);				// PMD_ABU278_001_000_1FT7	Geber
    } else {
        // Ohne Geber nicht zulässig (MLFB14 != 'W')
        ExecSetStandardifValueEmpty("UI_GEBER_1FK7M", "OHNEU");
        ExecSetStandardifValueEmpty("UI_GEBER_AUFLOESUNG_1FK7M", "00009");
        ExecSetStandardifValueEmpty("PMD_ABU209_001_000_1FK7M", "T");		// mit Drive Cliq
        ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1FK7M", "Z0013"); // 
    }
}

function SetGeber(strchangedAttribute, oData) {
}

/**
    VT_1FK7M_M00054_19624	UI: Geber definieren
        PMD_ABU278_001_000_1FK7M	PMD_ABU209_001_000_1FK7M	UI_GEBER_1FK7M	UI_GEBER_SMC_1FK7M	UI_GEBER_AUFLOESUNG_1FK7M	HMK_VALUE_VALID_1FK7M
    
    
    MLFB14
    neu	VT_1FK7M_M00235_19624	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    alt	VT_1FK7M_M00105_19624	ZO MLFB14 <> Geber
        alt	MLFB14_1FK7M	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

        VT_1FK7M_M00135	ZO R72
        VT_1FK7M_M00144	ZO MLFB-Rumpf, MLFB12, Geber
        VT_1FK7M_M00157	ZO gültige Geber
        VT_1FK7M_M00166	ZO N16
        VT_1FK7M_M00168	ZO R06
        VT_1FK7M_M00169	CAD N16
        VT_1FK7M_M00170	O: M03/M39 einschränken
        VT_1FK7M_M00213	Tech. Daten Umrichter Geber W
        VT_1FK7M_M00224	ZO Geber - Getriebe
*/
function Bestimme_Geberausfuehrung(oData) {
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB14_1FK7M = oMLFB.POS14;
    var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
    //var MLFB12_1FT7 = oMLFB.POS12;

    var aKAG = oMLFB.KAG || [];
    if (aKAG.indexOf("N16") > -1) {
        var O_N16_1006091 = "N16";
    } else {
        var O_N16_1006091 = "F";
    }

    var bCheck = false;
    bCheck = checkGeber(oData, "MLFB14_1FK7M", MLFB14_1FK7M);
    if (bCheck) {
        var sTable = "VT_1FK7M_M00235" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
            "O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
            "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
            "HMK_VALUE_VALID_1FK7M = 'T';";

        var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
        if (aResult.length > 0) {
            //var PMD_ABU209_001_000_1FT7 = aResult[0].PMD_ABU209_001_000_1FT7; // DRIVE CLiQ
            var PMD_ABU278_001_000_1FK7M = aResult[0].PMD_ABU278_001_000_1FK7M; // Gebersystem

            //ECL_DeactivateAllAttributeValues("PMD_ABU278_001_000_1FK7M");
            ECL_ActivateValue("PMD_ABU278_001_000_1FK7M", PMD_ABU278_001_000_1FK7M);
            ECL_SetValue("PMD_ABU278_001_000_1FK7M", PMD_ABU278_001_000_1FK7M);

        } else {
            bCheck = false;
        }

        var sTable = "VT_1FK7M_M00054" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
            "PMD_ABU278_001_000_1FK7M = '" + PMD_ABU278_001_000_1FK7M + "' AND " +
            "HMK_VALUE_VALID_1FK7M = 'T';";

        var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
        if (aResult.length > 0) {
            var PMD_ABU209_001_000_1FK7M = aResult[0].PMD_ABU209_001_000_1FK7M; // DRIVE CLiQ
            var UI_GEBER_1FK7M = aResult[0].UI_GEBER_1FK7M; // Gebersystem
            var UI_GEBER_AUFLOESUNG_1FK7M = aResult[0].UI_GEBER_AUFLOESUNG_1FK7M; // Geberauflösung
            // UI_GEBER_SMC_1FK7M

            ECL_ActivateValue("PMD_ABU209_001_000_1FK7M", PMD_ABU209_001_000_1FK7M);
            ECL_SetValue("PMD_ABU209_001_000_1FK7M", PMD_ABU209_001_000_1FK7M);

            ECL_ActivateValue("UI_GEBER_1FK7M", UI_GEBER_1FK7M);
            ECL_SetValue("UI_GEBER_1FK7M", UI_GEBER_1FK7M);

            ECL_ActivateValue("UI_GEBER_AUFLOESUNG_1FK7M", UI_GEBER_AUFLOESUNG_1FK7M);
            ECL_SetValue("UI_GEBER_AUFLOESUNG_1FK7M", UI_GEBER_AUFLOESUNG_1FK7M);
        } else {
            bCheck = false;
        }
    }
    if (!(bCheck)) {
        // Setze Standardgeber:
        ExecSetStandardifValueEmpty("UI_GEBER_1FK7M", "OHNEU");
        ExecSetStandardifValueEmpty("UI_GEBER_AUFLOESUNG_1FK7M", "00009");
        ExecSetStandardifValueEmpty("PMD_ABU209_001_000_1FK7M", "T");		// mit Drive Cliq
        ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1FK7M", "Z0013"); 	// 	
    }
}

// Check Geber (VT157) Todo
function checkGeber(oData, sTargetAttribute, sKAG) {
    // 60407: Config - 1FK7/1FT7 - Endat2.2 encoder AM25EN22 has to be removed
    if (sKAG == "N") {
        return 0;
    }
    // VT_1FK7M_M00157_19624
    //	HMK_KONFIG_TYP_1FK7M	MLFB05_06_08_1FK7M	MLFB12_1FK7M	MLFB14_1FK7M	PMD_AAA717_001_000_1FK7M	HMK_PRODUKT_ALT_AKT_1FK7M	HMK_VALUE_VALID_1FK7M

    //--------------------------------------------------------------------------------------------------------------
    var MLFB05_06_08_1FK7M = oData.oParsingData.MLFB.POS5_6_8;
    var MLFB12_1FK7M = oData.oParsingData.MLFB.POS12;
    //var PMD_AAA717_001_000_1FK7M = "00005";

    var sTable = "VT_1FK7M_M00157" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "HMK_KONFIG_TYP_1FK7M = 'konfig' AND " +
        "HMK_PRODUKT_ALT_AKT_1FK7M = 'AKT' AND " +
        "MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
        "MLFB12_1FK7M = '" + MLFB12_1FK7M + "' AND " +
        //"PMD_AAA717_001_000_1FK7M = '" + PMD_AAA717_001_000_1FK7M + "' AND " +
        "HMK_VALUE_VALID_1FK7M = 'T' AND " +
        sTargetAttribute + " = '" + sKAG + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}