//@legacy
//#mode(full-ecma)



//@import "VT_1FK7.js"


/*
PMD_ABV517_001_000_1FK7M	Getriebeart
PMD_ABV410_001_000_1FK7M	Bezeichnung des Getriebes
HMK_UEBERSETZ_STUFE_1FK7M	Übersetzung + Stufigkeit
PMD_ABV414_001_000_1FK7M	Wellenende
HMK_OPT_GETRIEBE_1FK7M		Hilfsmerkmal Optionen Getriebe


Test: 1FK70342AK741EA0-Z B02 +J09 +M03 +Q31
*/

function SetGetriebe_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Getriebe(oData); 	// Getriebeart, Bezeichnung, Übersetzung+Stufe, Wellenende

    } else {
        ExecSetStandardifValueEmpty("PMD_ABV410_001_000_1FK7M","00048");
        ExecSetStandardifValueEmpty("PMD_ABV517_001_000_1FK7M","00009"); // 00009	kein Wert
        ExecSetStandardifValueEmpty("HMK_UEBERSETZ_STUFE_1FK7M","00010");
        
        ExecSetStandardifValueEmpty("PMD_ABV414_001_000_1FK7M", "00009");
        ExecSetStandardifValueEmpty("HMK_OPT_GETRIEBE_1FK7M", ".");
    }
}

// GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE
    
    // Mit/Ohne Getriebe allgemein!
    /*	
    

    */
    // ################################################################################################################
    // Bezeichnung			PMD_ABV410_001_000_1FK7M	
    // ################################################################################################################
    /*
    VT_1FK7M_M00076	Zuordnung_Getriebebezeichnung_Getriebe	x
    VT_1FK7M_M00084	Zuordnung_Getriebe_Schaltstufen	o
    VT_1FK7M_M00109	Zuordnung_Baugroesse_I_Getriebe_Optionen	x
    VT_1FK7M_M00110	tech_Daten_Planetengetriebe_III	x
    VT_1FK7M_M00122	ZO Übersetzung <-> Stufigkeit	x
    VT_1FK7M_M00210	1FK7_P Getriebearten	?
    VT_1FK7M_M00224	ZO Geber - Getriebe	x

    * /
    
    
    // ################################################################################################################
    
        
    // ################################################################################################################
    // HMK_UEBERSETZ_STUFE_1FK7M	Übersetzung
    // ################################################################################################################
    /*
    VT_1FK7M_M00122	ZO Übersetzung <-> Stufigkeit

    */
    
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Wellenendes			PMD_ABV414_001_000_1FK7M
    // ################################################################################################################
    /*
    VT_1FK7M_M00080_19624	Zuordnung_Wellenende_Optionen

    */
    
    // ################################################################################################################
    /*
    Bestimmung Getriebe aus KAG HMK_OPT_GETRIEBE_1FK7M "Jxx"
    
    VT_1FK7M_M00080_19624	Zuordnung_Wellenende_Optionen
    VT_1FK7M_M00109	Zuordnung_Baugroesse_I_Getriebe_Optionen

    dann mit Übersetzung und HMK_BAUGROESSE aus VT 220 Bezeichnung ABV410
    
    Anzahl schaltstufen? aus VT177
    */

function SetGetriebe(strchangedAttribute, oData)
{
}

/**

*/
function Bestimme_Getriebe(oData)
{
    /*
    Bestimmung Getriebe aus KAG HMK_OPT_GETRIEBE_1FK7M "xnn"
    
    VT_1FK7M_M00109_19624	KAG --> Bezeichnung
        HMK_BAUGROESSE_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV410_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M

    dann mit Übersetzung und HMK_BAUGROESSE aus VT 220 Bezeichnung ABV410
    
    Anzahl Schaltstufen? aus VT177
    */
    var HMK_KONFIG_ZIEL_1FK7M = oData.oParsingData.KONF_ZIEL;
    	// if Konfig-ziel == Getriebe: todo
	var ECSI_CX_SeriesID = ECL_GetValue("ECSI_CX_SeriesID");
	if (ECSI_CX_SeriesID != "302" && HMK_KONFIG_ZIEL_1FK7M == "SERVO" ){
		ECL_DeactivateAllAttributeValues("PMD_ABV410_001_000_1FK7M");
		ECL_ActivateValue("PMD_ABV410_001_000_1FK7M", "00048");
		ECL_SelectValue("PMD_ABV410_001_000_1FK7M", "00048");
		
		ECL_DeactivateAllAttributeValues("HMK_OPT_GETRIEBE_1FK7M");
		ECL_ActivateValue("HMK_OPT_GETRIEBE_1FK7M", ".");
		ECL_SelectValue("HMK_OPT_GETRIEBE_1FK7M", ".");
		return;
	}
	
	ECL_ActivateAttribute("PMD_ABV410_001_000_1FK7M"); // Bezeichnung Getriebe
	ECL_ActivateAttribute("HMK_UEBERSETZ_STUFE_1FK7M"); // Übersetzung + Stufigkeit
	ECL_ActivateAttribute("PMD_ABV414_001_000_1FK7M"); // Wellenende
	
	ECL_ActivateAttribute("HMK_ACB729_1FK7M");
	ECL_ActivateAttribute("HMK_ACB769_1FK7M");
	ECL_ActivateAttribute("HMK_ACB772_1FK7M");
	ECL_ActivateAttribute("HMK_ACB789_1FK7M");
	ECL_ActivateAttribute("HMK_ACB783_1FK7M");

	
	// HMK_OPT_GETRIEBE_1FK7M
    // KAG: Jxx
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_OPT_GETRIEBE_1FK7M";
    var bCheck = false;
    var bErrGetriebe = false;
    
    
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    
    if (sKAG != "NON"){
        // Daten Getriebe bestimmen
        /*
        VT_1FK7M_M00109_19624	KAG --> Bezeichnung und Übersetzung
            HMK_BAUGROESSE_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV410_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M
        */
        ECL_DeactivateAllAttributeValues("HMK_OPT_GETRIEBE_1FK7M");
        ECL_ActivateValue("HMK_OPT_GETRIEBE_1FK7M", sKAG);
        ECL_SelectValue("HMK_OPT_GETRIEBE_1FK7M", sKAG);
        var HMK_BAUGROESSE_1FK7M = ECL_GetValue("HMK_BAUGROESSE_1FK7M");
        
        var sTable = "VT_1FK7M_M00109" + sDB_Suffix;
        var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                    "HMK_OPT_GETRIEBE_1FK7M = '" + sKAG + "' AND " +
                    "HMK_BAUGROESSE_1FK7M = '" + HMK_BAUGROESSE_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE");
        if (aResult.length > 0)
        {
            var PMD_ABV410_001_000_1FK7M = aResult[0].PMD_ABV410_001_000_1FK7M; // Bezeichnung
            var PMD_ABV413_001_000_1006091 = aResult[0].PMD_ABV413_001_000_1006091; // Übersetzung
            
            ECL_DeactivateAllAttributeValues("PMD_ABV410_001_000_1FK7M");
			ECL_ActivateValue("PMD_ABV410_001_000_1FK7M", PMD_ABV410_001_000_1FK7M);
            ECL_SelectValue("PMD_ABV410_001_000_1FK7M", PMD_ABV410_001_000_1FK7M);
            //ECL_SetValue("PMD_ABV413_001_000_1006091", PMD_ABV413_001_000_1006091);
            
            // Bestimme Übersetzung und Stufe HMK_UEBERSETZ_STUFE_1FK7M aus	VT_1FK7M_M00122_19624
            /*
            VT_1FK7M_M00122_19624
                PMD_ABV410_001_000_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV417_001_000_1FK7M	
                HMK_UEBERSETZ_STUFE_1FK7M	HMK_VALUE_VALID_1FK7M
            */
            var sTable = "VT_1FK7M_M00122" + sDB_Suffix;
            var sSQL = "SELECT HMK_UEBERSETZ_STUFE_1FK7M FROM "+sTable+" WHERE " +
                        "PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
                        "PMD_ABV413_001_000_1006091 = '" + PMD_ABV413_001_000_1006091 + "';";
            
            var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE");
            if (aResult.length > 0){
                
                var HMK_UEBERSETZ_STUFE_1FK7M = aResult[0].HMK_UEBERSETZ_STUFE_1FK7M;
                ECL_DeactivateAllAttributeValues("HMK_UEBERSETZ_STUFE_1FK7M");
				ECL_ActivateValue("HMK_UEBERSETZ_STUFE_1FK7M", HMK_UEBERSETZ_STUFE_1FK7M);
				ECL_SelectValue("HMK_UEBERSETZ_STUFE_1FK7M", HMK_UEBERSETZ_STUFE_1FK7M);
                
            }else{
                bErrGetriebe = true;
            }
        }else{
            bErrGetriebe = true;
        }
        
        // Bestimmung Wellenende PMD_ABV414_001_000_1FK7M aus KAG HMK_OPT_GETRIEBE_1FK7M
        // VT_1FK7M_M00080_19624
        //	PMD_ABV414_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M
        var sTable = "VT_1FK7M_M00080" + sDB_Suffix;
        var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                    "HMK_OPT_GETRIEBE_1FK7M = '" + sKAG + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE");
        if (aResult.length > 0){
            var PMD_ABV414_001_000_1FK7M = aResult[0].PMD_ABV414_001_000_1FK7M; // Wellenende
            
			ECL_DeactivateAllAttributeValues("PMD_ABV414_001_000_1FK7M");
			ECL_ActivateValue("PMD_ABV414_001_000_1FK7M", PMD_ABV414_001_000_1FK7M);
			ECL_SelectValue("PMD_ABV414_001_000_1FK7M", PMD_ABV414_001_000_1FK7M);
        }else{
            bErrGetriebe = true;
        }
     		
		// Bestimmung PMD_ABV517_001_000_1FK7M - Art des Getriebes
		var sTable = "VT_1FK7M_M00076" + sDB_Suffix;
		var sSQL = "SELECT * FROM "+sTable+" WHERE " +
					"PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
					"HMK_VALUE_VALID_1FK7M = 'T';";
		
		var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE");
		if (aResult.length > 0){
			var PMD_ABV517_001_000_1FK7M = aResult[0].PMD_ABV517_001_000_1FK7M; // Art des Getriebes
			
			ECL_DeactivateAllAttributeValues("PMD_ABV517_001_000_1FK7M");
			ECL_ActivateValue("PMD_ABV517_001_000_1FK7M", PMD_ABV517_001_000_1FK7M);
			ECL_SelectValue("PMD_ABV517_001_000_1FK7M", PMD_ABV517_001_000_1FK7M);
		}else{
			bErrGetriebe = true;
		}  
    }
    else
    {
        // Kein Getriebe
        bErrGetriebe = true;
    }
    
    if (bErrGetriebe){
        // Kein Getriebe
        // Fehler wird in PL-Skript abgefangen
        
        ECL_SetValue("PMD_ABV414_001_000_1FK7M", "00009");
        ECL_SetValue("PMD_ABV410_001_000_1FK7M", "00048");
        ECL_SetValue("PMD_ABV517_001_000_1FK7M", "00009");
        ECL_SetValue("HMK_UEBERSETZ_STUFE_1FK7M", "00010");
        ECL_SetValue("HMK_OPT_GETRIEBE_1FK7M", ".");
    }
}


