//@legacy
//#mode(full-ecma)



//@import "VT_1FK7.js"


/*
Konfigurationsziel bestimmen

var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
     Konfig_Ziel wird definiert von:
        VT  37 - alternatives Wellenende
        VT 105 - Geber
        VT 116 - Getriebe	(PMD_ABV517_001_000_1FK7M)
        VT 144 - Rumpf, MLFB14, Geber
        VT 193 - R06 nur ohne Getriebe
        VT 226 - L13 kein DYAG2
        VT 227 - K24 kein DYAG2

*/

function SetKonfigZiel_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_KonfigZiel(oData); 	 		// 
        
    }else{
        ExecSetStandardifValueEmpty("HMK_KONFIG_ZIEL_1FK7M","SERVO"); // Default ohne Getriebe
    }
}

function SetKonfigZiel(strchangedAttribute, oData)
{
}

/**
prüfen, ob ein Getriebe verbaut ist und daraus KonfigZiel ableiten
*/

function Bestimme_KonfigZiel(oData)
{
    // HMK_KONFIG_ZIEL_1FK7M
    // Werte: SERVO, G_DYAG2, G_PLANET_LP, G_PLANET_SP
    
    // HMK_OPT_GETRIEBE_1FK7M
    // Dnn, Jnn, ...
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "HMK_OPT_GETRIEBE_1FK7M";
    
    var HMK_KONFIG_ZIEL_1FK7M = "SERVO";
    // Prüfen, ob Getriebe verbaut HMK_OPT_GETRIEBE_1FK7M in aKAG
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    
    if (sKAG != "NON"){
        // es gibt eine KAG, 
        
        // Getriebe Bezeichnung aus KAG bestimmen 
        // VT_1FK7M_M00109_19624
        // 	HMK_BAUGROESSE_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV410_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M
        
        var sTable = "VT_1FK7M_M00109" + sDB_Suffix;
        
        var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                    "HMK_OPT_GETRIEBE_1FK7M = '" + sKAG + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
        var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE" );
        
        if (aResult.length > 0){
            var PMD_ABV410_001_000_1FK7M = aResult[0].PMD_ABV410_001_000_1FK7M;
            
            // Getriebeart aus Bezeichnung bestimmen
            // VT_1FK7M_M00076_19624
            // 	PMD_ABV410_001_000_1FK7M	PMD_ABV517_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
            var sTable = "VT_1FK7M_M00076" + sDB_Suffix;
            var sSQL = "SELECT PMD_ABV517_001_000_1FK7M FROM "+sTable+" WHERE " +
                        "PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE" );
            
            if (aResult.length > 0){
                var PMD_ABV517_001_000_1FK7M = aResult[0].PMD_ABV517_001_000_1FK7M;
                
                // KONFIG_ZIEL bestimmen
                // VT_1FK7M_M00116_19624
                // 	HMK_KONFIG_ZIEL_1FK7M	PMD_ABV517_001_000_1FK7M
				var sTable = "VT_1FK7M_M00116" + sDB_Suffix;
				var sSQL = "SELECT HMK_KONFIG_ZIEL_1FK7M FROM " + sTable + " WHERE " +
                            "PMD_ABV517_001_000_1FK7M = '" + PMD_ABV517_001_000_1FK7M + "';";
                
                var aResult = GetDBDataSetEXT(sSQL, sTable+"_PARSE" );
                
                if (aResult.length > 0){
                    // KonfigZiel:
                    HMK_KONFIG_ZIEL_1FK7M = aResult[0].HMK_KONFIG_ZIEL_1FK7M;
                }
            }
        }
    }
    
    ECL_ActivateValue("HMK_KONFIG_ZIEL_1FK7M", HMK_KONFIG_ZIEL_1FK7M);
    ECL_SetValue("HMK_KONFIG_ZIEL_1FK7M", HMK_KONFIG_ZIEL_1FK7M);
    
    return HMK_KONFIG_ZIEL_1FK7M;
}

// ##############################################################################################

function Bestimme_KonfigZiel_Parser(sKAG)
{
    // HMK_KONFIG_ZIEL_1FK7M
    // Werte: SERVO, G_DYAG2, G_PLANET_LP, G_PLANET_SP
    
    // HMK_OPT_GETRIEBE_1FK7M
    // Dnn, Jnn, ...
    //var parseObj = oData.oParsingData;
    
    //var sTargetAttribute = "HMK_OPT_GETRIEBE_1FK7M";
    
    var HMK_KONFIG_ZIEL_1FK7M = "SERVO";
    // Prüfen, ob Getriebe verbaut HMK_OPT_GETRIEBE_1FK7M in aKAG
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    //var sKAG = getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    
    if (sKAG != "NON"){
        // es gibt eine KAG, 
        
        // Getriebe Bezeichnung aus KAG bestimmen 
        // VT_1FK7M_M00109_19624
        // 	HMK_BAUGROESSE_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV410_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M
        var sTable = "VT_1FK7M_M00109" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT PMD_ABV410_001_000_1FK7M FROM "+sTable+" WHERE " +
                    "HMK_OPT_GETRIEBE_1FK7M = '" + sKAG + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
        var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE" );
        
        if (aResult.length > 0){
            var PMD_ABV410_001_000_1FK7M = aResult[0].PMD_ABV410_001_000_1FK7M;
            
            // Getriebeart aus Bezeichnung bestimmen
            // VT_1FK7M_M00076_19624
            // 	PMD_ABV410_001_000_1FK7M	PMD_ABV517_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
            var sTable = "VT_1FK7M_M00076" + sDB_Suffix;
            var sSQL = "SELECT PMD_ABV517_001_000_1FK7M FROM "+sTable+" WHERE " +
                        "PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
            var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE" );
            
            if (aResult.length > 0){
                var PMD_ABV517_001_000_1FK7M = aResult[0].PMD_ABV517_001_000_1FK7M;
                
                // KONFIG_ZIEL bestimmen
                // VT_1FK7M_M00116_19624
                // 	HMK_KONFIG_ZIEL_1FK7M	PMD_ABV517_001_000_1FK7M
                var sTable = "VT_1FK7M_M00116" + sDB_Suffix;
                var sSQL = "SELECT HMK_KONFIG_ZIEL_1FK7M FROM "+sTable+" WHERE " +
                            "PMD_ABV517_001_000_1FK7M = '" + PMD_ABV517_001_000_1FK7M + "' AND " +
                            "HMK_KONFIG_ZIEL_1FK7M <> '1FG1' AND " +
                            "HMK_KONFIG_ZIEL_1FK7M <> 'G_STOEBER' AND " +
                            "HMK_KONFIG_ZIEL_1FK7M <> 'G_DYA';";
                
                var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE" );
                
                if (aResult.length > 0){
                    // KonfigZiel:
                    HMK_KONFIG_ZIEL_1FK7M = aResult[0].HMK_KONFIG_ZIEL_1FK7M;
                }
            }
        }
    }
    
    ECL_ActivateValue("HMK_KONFIG_ZIEL_1FK7M", HMK_KONFIG_ZIEL_1FK7M);
    ECL_SetValue("HMK_KONFIG_ZIEL_1FK7M", HMK_KONFIG_ZIEL_1FK7M);
    
    return HMK_KONFIG_ZIEL_1FK7M;
}

// ##############################################################################################
