//@legacy
//#mode(full-ecma)





/*
Motordaten werden vom SIZER in der MLFB übergeben, werden immer 1:1 übernommen

PMD_ACH516_001_000_1FK7M	Achshöhe
TAK_ABU212_001_000_1FK7M	Baulänge
PMD_AAA259_001_000_1FK7M	Motortyp
PMD_ABV400_001_000_1FK7M	Baugröße /...ehstrommotor

PMD_AAA136_001_000_1FK7M	Kühlart
PMD_AAE020_001_000_1FK7M	Bemessungsdrehzahl
PMD_ABJ558_001_000_1FK7M	Zwischenkreisspannung
PMD_AAC949_001_000_1FK7M	Grundbauform
PMD_AAB047_001_000_1FK7M	Anordnung /...Anschlusses
PMD_AAA506_001_000_1FK7M	Ausführung Wellenende
PMD_ABJ176_001_000_1FK7M	Schutzart
PMD_ABU276_001_000_1FK7M	Produktbestandt...Haltebremse
UI_HALTEBREMSE_1FK7M		Haltebremse

??? PMD_AAA149_001_000_1FK7M	Motorpolzahl
??? UI_SCHUTZART_GEH_1FK7M		Schutzart Gehäuse
??? UI_SCHUTZART_FLANSCH_1FK7M	Schutzart Flansch

UI_PASSFEDER_1FK7M			Passfeder
UI_WELLENAUSF_1FK7M			Wellenausführung
UI_WELLENMASZ_1FK7M			Wellenende D x Länge


PMD_ABJ560_001_000_1FK7M	Trägheitsmoment.../Bremse
PMD_AAB904_001_000_1FK7M	Trägheitsmoment / des Läufers
UI_VT_TRAEGHEITSMO_1FK7M	Trägheitsmoment
HMK_TRAEGHEITSMOMENT_1FK7M	Trägheitsmoment.../Motor
PMD_ACC394_001_000_1FK7M	Trägheitsmoment / der Bremse
UI_VT_TRAEGH_MB_1FK7M		Trägheitsmoment
UI_VT_TRAEGH_MVB_1FK7M		Trägheitsmoment

*/

function SetMotor_Init(oData)
{
    if (oData && !isEmpty(oData)){
        
        Bestimme_Baugroesse(oData); 	// PMD_ACH516_001_000_1FK7M Achshöhe	aus MLFB05+06 übersetzen
        Bestimme_Baulaenge(oData); 		// TAK_ABU212_001_000_1FK7M	Baulänge	MLFB07
        Bestimme_HMK_Baugroesse(oData); // HMK_BAUGROESSE_1FK7M	HMK-Baugröße 
        Bestimme_Motortyp(oData);		// PMD_AAA259_001_000_1FK7M	Motortyp	MLFB08
        Bestimme_Drehzahl(oData);		// PMD_AAE020_001_000_1FK7M Bemessungsdrehzahl	MLFB12
        Bestimme_Kuehlung(oData);		// PMD_AAA136_001_000_1FK7M	Kühlart	MLFB09
        
        Bestimme_Wellenende(oData);		// PMD_AAA506_001_000_1FK7M	Ausführung des Wellenendes / an der Antriebsseite	MLFB15
        Bestimme_Wellenausfuehrung(oData)
        //Bestimme_Wellengenauigkeit(oData);	// TAK_AAJ730_001_000_1FT7	Wellen- und Flanschgenauigkeit					MLFB15
        //Bestimme_haltebremse(oData);	// PMD_ABU276_001_000_1FK7M	Haltebremse			MLFB15								MLFB15
        Bestimme_E_Anschluss(oData);	// PMD_AAB047_001_000_1FT7	Anordnung des elektrischen Anschlusses
        Bestimme_Bauform(oData);	// Bauform gemäß Code I			PMD_AAC949_001_000_1FK7M
        Bestimme_Schutzart(oData);	// Schutzart IP				PMD_ABJ176_001_000_1FK7M
        
        
    } else {
        
        //ExecSetStandardifValueEmpty("UI_VT_ACHSHOEHE_1FK7M","36");
        ExecSetStandardifValueEmpty("PMD_ACH516_001_000_1FK7M","36");
        ExecSetStandardifValueEmpty("TAK_ABU212_001_000_1FK7M","4");	
        ExecSetStandardifValueEmpty("HMK_BAUGROESSE_1FK7M","00013");	// 364
        ExecSetStandardifValueEmpty("PMD_AAA259_001_000_1FK7M","Z0001"); // Compact
        ExecSetStandardifValueEmpty("PMD_AAE020_001_000_1FK7M","6000");
        ExecSetStandardifValueEmpty("PMD_AAA136_001_000_1FK7M","Z0004"); // A Selbstkühlung
        
        ExecSetStandardifValueEmpty("PMD_AAA506_001_000_1FK7M","Z0003"); // Wellenende: Passfeder u. Passfedernut
        ExecSetStandardifValueEmpty("UI_PASSFEDER_1FK7M","F"); // Passfeder
        ExecSetStandardifValueEmpty("UI_WELLENAUSF_1FK7M","STD"); // Wellenausführung
        ExecSetStandardifValueEmpty("PMD_AAD427_001_000_1FK7M","F"); // Wellenausführung Standard
        ExecSetStandardifValueEmpty("UI_WELLENMASZ_1FK7M","14_30"); // Wellenabmaße Standard
        
        ExecSetStandardifValueEmpty("UI_HALTEBREMSE_1FK7M","OHNE"); // Haltebremse keine
        
        ExecSetStandardifValueEmpty("PMD_AAB047_001_000_1FK7M","Z0006"); // Anordnung des elektrischen Anschlusses 00004, Stecker drehbar
        ExecSetStandardifValueEmpty("PMD_AAC949_001_000_1FK7M","Z0003"); // Bauform Z0004 IM B5 (neue Flanschform)
        
        ExecSetStandardifValueEmpty("PMD_ABJ176_001_000_1FK7M","Z0011"); // Schutzart IP 64
        ExecSetStandardifValueEmpty("PMD_ABV400_001_000_1FK7M","Z0002");
        
    }
}

function SetMotor(strchangedAttribute, oData)
{
}
// #########################################################################################################################
/**
    Achshöhe		PMD_ACH516_001_000_1FK7M 
    VT_1FK7M_M00069	ZO MLFB05_06 < > AH
        MLFB05_06_1FK7M	PMD_ACH516_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
*/
// #########################################################################################################################
function Bestimme_Baugroesse(oData)
{
    var MLFB05_06_1FK7M = oData.oParsingData.MLFB.POS5 + oData.oParsingData.MLFB.POS6;
    
    var sTable = "VT_1FK7M_M00069" + sDB_Suffix;
    var sSQL = "SELECT PMD_ACH516_001_000_1FK7M FROM "+sTable+" WHERE " +
                "MLFB05_06_1FK7M = '" + MLFB05_06_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length > 0)
    {
        var PMD_ACH516_001_000_1FK7M = aResult[0].PMD_ACH516_001_000_1FK7M; // Achshöhe
        
        ECL_SelectValue("PMD_ACH516_001_000_1FK7M", PMD_ACH516_001_000_1FK7M);
    }else{
		oData.strError = "DICT1_ERR_1FK7___PARSER_BG_NO_DB_RESULT";
		return;
    }
}

// #########################################################################################################################
/**
    VT_1FK7M_M00078	Hilfstabelle_Baugröße
        MLFB05_06_1FK7M	MLFB07_1FK7M	HMK_BAUGROESSE_1FK7M	HMK_VALUE_VALID_1FK7M

*/
function Bestimme_HMK_Baugroesse(oData)
{
    var MLFB05_06_1FK7M = oData.oParsingData.AH;
    var MLFB07_1FK7M 	= oData.oParsingData.MLFB.POS7;
    
    var sTable = "VT_1FK7M_M00078" + sDB_Suffix;
    var sSQL = "SELECT HMK_BAUGROESSE_1FK7M FROM "+sTable+" WHERE " +
                "MLFB05_06_1FK7M = '" + MLFB05_06_1FK7M + "' AND " +
                "MLFB07_1FK7M = '" + MLFB07_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable+ "_PARSE");
    if (aResult.length > 0)
    {
        var HMK_BAUGROESSE_1FK7M = aResult[0].HMK_BAUGROESSE_1FK7M;
        
        ECL_SetValue("HMK_BAUGROESSE_1FK7M", HMK_BAUGROESSE_1FK7M);
    }else{
		oData.strError = "DICT1_ERR_1FK7___PARSER_BG_HMK_NO_DB_RESULT";
		return;
    }
}
// #########################################################################################################################
function Bestimme_Baulaenge(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB07_1FK7M = oMLFB.POS7;
    var TAK_ABU212_001_000_1FK7M = MLFB07_1FK7M; // 1:1 übersetzt

    ECL_SelectValue("TAK_ABU212_001_000_1FK7M", TAK_ABU212_001_000_1FK7M);
}
/**
    VT_1FK7M_M00119	ZO MLFB08 < > Motortyp
        MLFB08_1FK7M	PMD_AAA259_001_000_1FK7M	HMK_GENERATION_1FK7M	HMK_VALUE_VALID_1FK7M
*/
function Bestimme_Motortyp(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB08_1FK7M = oMLFB.POS8;
    
    var sTable = "VT_1FK7M_M00119" + sDB_Suffix;
    var sSQL = "SELECT * FROM "+sTable+" WHERE " +
                "MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                "HMK_GENERATION_1FK7M = '00002';";
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAA259_001_000_1FK7M = aResult[0].PMD_AAA259_001_000_1FK7M; // Motortyp
        
        ECL_DeactivateAllAttributeValues("PMD_AAA259_001_000_1FK7M");
        ECL_ActivateValue("PMD_AAA259_001_000_1FK7M", PMD_AAA259_001_000_1FK7M);
        ECL_SetValue("PMD_AAA259_001_000_1FK7M", PMD_AAA259_001_000_1FK7M);
    }else{
		oData.strError = "DICT1_ERR_1FK7___PARSER_MOTORTYP";
		return;
    }
}

// #########################################################################################################################
/**
    VT_1FK7M_M00006
    MLFB10_1FK7M	PMD_AAE020_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
*/
// #########################################################################################################################
function Bestimme_Drehzahl(oData)
{
    var rumpf = oData.oParsingData.RUMPF;
	
	/* Bestimmung Rumpf nicht nötig, da im Objekt enthalten (Parser)
    var oMLFB = oData.oParsingData.MLFB;
    
    var MLFB05_1FK7M = oMLFB.POS5;
    var MLFB06_1FK7M = oMLFB.POS6;
    var MLFB07_1FK7M = oMLFB.POS7;
    var MLFB08_1FK7M = oMLFB.POS8;
    var MLFB09_1FK7M = oMLFB.POS9;
    var MLFB10_1FK7M = oMLFB.POS10;
    var MLFB11_1FK7M = oMLFB.POS11;
    var MLFB05_06_08_1FK7M = MLFB05_1FK7M + MLFB06_1FK7M + "_" + MLFB08_1FK7M;
    var rumpf = null;
    
    var query = "SELECT MLFB_RUMPF_01_11_1FK7M FROM VT_1FK7M_M00233"+sDB_Suffix+" WHERE " +
    "MLFB05_06_08_1FK7M='" +MLFB05_06_08_1FK7M+ "' AND " + 
    "MLFB07_1FK7M='"+MLFB07_1FK7M+"' AND " + 
    "MLFB09_1FK7M='"+MLFB09_1FK7M+"' AND " + 
    "MLFB10_1FK7M='"+MLFB10_1FK7M+"' AND " + 
    "MLFB11_1FK7M='"+MLFB11_1FK7M+"';";
    var result = Object.fromDatabase("EXTERNAL_DATA", query);
    if(result.length > 0)
    {
        rumpf = result[0]["MLFB_RUMPF_01_11_1FK7M"];
    }
    */
	var sTable = "VT_1FK7M_M00262" + sDB_Suffix;
	var sSQL = "SELECT PMD_AAE020_001_000_1FK7M FROM "+sTable+" WHERE " +
				"MLFB_RUMPF_01_11_1FK7M = '" + rumpf + "';";
	
	var aResult = GetDBDataSetEXT(sSQL, sTable+"_PARSE");
	
	if(aResult.length > 0)
    {
        var PMD_AAE020_001_000_1FK7M = aResult[0].PMD_AAE020_001_000_1FK7M; // Drehzahl
        ECL_DeactivateAllAttributeValues("PMD_AAE020_001_000_1FK7M");
        ECL_ActivateValue("PMD_AAE020_001_000_1FK7M", PMD_AAE020_001_000_1FK7M);
        ECL_SetValue("PMD_AAE020_001_000_1FK7M", PMD_AAE020_001_000_1FK7M);
    }else{
		oData.strError = "DICT1_ERR_1FK7___PARSER_DREHZAHL";
		return;
    }
}

// #########################################################################################################################
/**
    VT_1FK7M_M00005
    MLFB09_1FK7M	PMD_AAA136_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
    
    MLFB09_1FK7M	PMD_AAA136_001_000_1FK7M
A	Z0004
B	Z0004
C	Z0004
S	Z0003

*/
// #########################################################################################################################
function Bestimme_Kuehlung(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB09_1FK7M = oMLFB.POS9;
    
    var sTable = "VT_1FK7M_M00005" + sDB_Suffix;
    var sSQL = "SELECT PMD_AAA136_001_000_1FK7M FROM " + sTable + " WHERE " +
                "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAA136_001_000_1FK7M = aResult[0].PMD_AAA136_001_000_1FK7M; // Kühlart
        
        //ECL_DeactivateAllAttributeValues("PMD_AAA136_001_000_1FK7M");
        ECL_ActivateValue("PMD_AAA136_001_000_1FK7M", PMD_AAA136_001_000_1FK7M);
        ECL_SelectValue("PMD_AAA136_001_000_1FK7M", PMD_AAA136_001_000_1FK7M);
    }else{
		oData.strError = "DICT1_ERR_1FK7___PARSER_COOLING";
		return;
    }
}
// Check Kühlung 	
/*
VT_1FK7M_M00015
MLFB08_1FK7M	MLFB09_1FK7M	HMK_VALUE_VALID_1FK7M

*/



// #########################################################################################################################
/**
    Bestimme_Wellenende(oData); 
        PMD_AAA506_001_000_1FK7M	Ausführung des Wellenendes		MLFB15
        UI_PASSFEDER_1FK7M			Passfeder
        UI_WELLENAUSF_1FK7M			Wellenausführung STD/ALT
        PMD_AAD427_001_000_1FK7M	Wellenausführung F/N05
        UI_WELLENMASZ_1FK7M			Wellenende D x Länge
        
        VT_1FK7M_M00027	UI -> Passfeder
            UI_PASSFEDER_1FK7M	PMD_AAA506_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
        VT_1FK7M_M00151	MLFB15-Wellenende-Haltebremse
            MLFB15_1FK7M	PMD_AAA506_001_000_1FK7M	UI_HALTEBREMSE_1FK7M	HMK_VALUE_VALID_1FK7M

    
    Bestimme_Haltebremse(oData);
        UI_HALTEBREMSE_1FK7M		Haltebremse						MLFB15
        
        VT_1FK7M_M00070	ZO AH > Haltebremse > Gewicht Bremse
        VT_1FK7M_M00085	Option-Arbeitsbremse
        VT_1FK7M_M00150	Haltebremse-Konfigziel
        VT_1FK7M_M00151	MLFB15-Wellenende-Haltebremse
        VT_1FK7M_M00153	K82-Haltebremse
        VT_1FK7M_M00154	C05-Haltebremse
        VT_1FK7M_M00173	Haltebremse
        VT_1FK7M_M00174	Datenblatttrigger Haltebremse
        VT_1FK7M_M00191	O: N24 verstärkte Bremse

    
    MLFB15_1FK7M
        VT_1FK7M_M00018	ZO gültige MLFB15
        VT_1FK7M_M00135	ZO R72
        VT_1FK7M_M00151	MLFB15-Wellenende-Haltebremse
    
    
    Bestimmung PMD_AAA506_001_000_1FK7M über VT151 aus MLFB15_1FK7M
    Bestimmung Haltebremse analog
    
    Bestimmung Passfeder aus VT27 mit PMD_AAA506_001_000_1FK7M
*/
// #########################################################################################################################
function Bestimme_Wellenende(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB15_1FK7M = oMLFB.POS15;
    
    // Bremsenvorgabe aus SIZER:
    var ECSI_CX_MotorBrakeRequired = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    if (ECSI_CX_MotorBrakeRequired == "1"){
        ECL_ActivateAllAttributeValues("UI_HALTEBREMSE_1FK7M");
        ECL_DeactivateValue("UI_HALTEBREMSE_1FK7M", "OHNE");
    }else{
        ECL_DeactivateAllAttributeValues("UI_HALTEBREMSE_1FK7M");
        ECL_ActivateValue("UI_HALTEBREMSE_1FK7M", "OHNE");
        ECL_SetValue("UI_HALTEBREMSE_1FK7M", "OHNE");
    }
    
    // Prüfen, ob "N24" in KAG --> verstärkte Bremse
    //var sKAG = getKAGforAttribute("UI_HALTEBREMSE_1FK7M", oMLFB.KAG);
    var sKAG = "N24"; 
    var aKAG = oMLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        if (ECSI_CX_MotorBrakeRequired == "1"){
            var sWhereBremse = "UI_HALTEBREMSE_1FK7M = 'N24' AND ";
        }else{
            var sWhereBremse = "(UI_HALTEBREMSE_1FK7M = 'OHNE' OR UI_HALTEBREMSE_1FK7M = 'N24') AND ";
        }
    }else{
        if (ECSI_CX_MotorBrakeRequired == "1"){
            var sWhereBremse = "UI_HALTEBREMSE_1FK7M = 'M_FK7' AND ";
        }else{
            var sWhereBremse = "(UI_HALTEBREMSE_1FK7M = 'OHNE' OR UI_HALTEBREMSE_1FK7M = 'M_FK7') AND ";
        }
    }
    
    var sTable = "VT_1FK7M_M00151" + sDB_Suffix;
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB15_1FK7M = '" + MLFB15_1FK7M + "' AND " +
                sWhereBremse +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAA506_001_000_1FK7M = aResult[0].PMD_AAA506_001_000_1FK7M; // Wellenende
        var UI_HALTEBREMSE_1FK7M = aResult[0].UI_HALTEBREMSE_1FK7M; // Haltebremse
        
        //ECL_DeactivateAllAttributeValues("PMD_AAA506_001_000_1FK7M");
        ECL_ActivateValue("PMD_AAA506_001_000_1FK7M", PMD_AAA506_001_000_1FK7M);
        ECL_SetValue("PMD_AAA506_001_000_1FK7M", PMD_AAA506_001_000_1FK7M);
        
        //ECL_DeactivateAllAttributeValues("UI_HALTEBREMSE_1FK7M");
        ECL_ActivateValue("UI_HALTEBREMSE_1FK7M", UI_HALTEBREMSE_1FK7M);
        ECL_SetValue("UI_HALTEBREMSE_1FK7M", UI_HALTEBREMSE_1FK7M);
    }else{
		oData.strError = "DICT1_ERR_1FK7___PARSER_SHAFTEND";
		return;
    }
    
    // Bestimme Passfeder
    if (PMD_AAA506_001_000_1FK7M){
        /*
        VT_1FK7M_M00027	UI -> Passfeder
            UI_PASSFEDER_1FK7M	PMD_AAA506_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
        */
        var sTable = "VT_1FK7M_M00027" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                    "PMD_AAA506_001_000_1FK7M = '" + PMD_AAA506_001_000_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
        if (aResult.length > 0)
        {
            var UI_PASSFEDER_1FK7M = aResult[0].UI_PASSFEDER_1FK7M;
            
            ECL_ActivateValue("UI_PASSFEDER_1FK7M", UI_PASSFEDER_1FK7M);
            ECL_SetValue("UI_PASSFEDER_1FK7M", UI_PASSFEDER_1FK7M);
        }else{
			oData.strError = "DICT1_ERR_1FK7___PARSER_SHAFTEND";
			return;
        }
    }
    // Bestimme Wellenausführung
    /*
    UI_WELLENAUSF_1FK7M			Wellenausführung STD/ALT
    PMD_AAD427_001_000_1FK7M	Wellenausführung F/N05
    UI_WELLENMASZ_1FK7M			Wellenende D x Länge
    */
}
function Bestimme_Wellenausfuehrung(oData)
{
    // PMD_AAD427_001_000_1FK7M
    // KAG: N05, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "PMD_AAD427_001_000_1FK7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "N05"; 
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkWellenausfuehrung(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
        
        var UI_WELLENAUSF_1FK7M = "ALT";
        ECL_ActivateValue("UI_WELLENAUSF_1FK7M", UI_WELLENAUSF_1FK7M);
        ECL_SetValue("UI_WELLENAUSF_1FK7M", UI_WELLENAUSF_1FK7M);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
        
        var UI_WELLENAUSF_1FK7M = "STD";
        ECL_ActivateValue("UI_WELLENAUSF_1FK7M", UI_WELLENAUSF_1FK7M);
        ECL_SetValue("UI_WELLENAUSF_1FK7M", UI_WELLENAUSF_1FK7M);
    }
    
    // Setze Wellenmaße
    // VT_1FK7M_M00028
    //  MLFB05_06_1FK7M	UI_WELLENAUSF_1FK7M	UI_WELLENMASZ_1FK7M	HMK_VALUE_VALID_1FK7M
    var MLFB05_06_1FK7M = parseObj.AH;
    
    var sTable = "VT_1FK7M_M00028" + sDB_Suffix;
    var sSQL = "SELECT UI_WELLENMASZ_1FK7M FROM " + sTable + " WHERE " +
                "MLFB05_06_1FK7M = '" + MLFB05_06_1FK7M + "' AND " +
                "UI_WELLENAUSF_1FK7M = '" + UI_WELLENAUSF_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_PARSE");
    
    if (aResult.length > 0){
        var UI_WELLENMASZ_1FK7M = aResult[0].UI_WELLENMASZ_1FK7M;
        
        ECL_ActivateValue("UI_WELLENMASZ_1FK7M", UI_WELLENMASZ_1FK7M);
        ECL_SetValue("UI_WELLENMASZ_1FK7M", UI_WELLENMASZ_1FK7M);
        
    }else{
        var sError = "ERROR";
    }
}
function checkWellenausfuehrung(oData, sTargetAttribute, sKAG)
{
    if (oData.IsDriveTrain == 1  || oData.GearboxMotorCoupling == 1)
    {
        return 0;
    }
    // Bei SERVO immer erlaubt
    return 1;
}



/**
VT_1FK7M_M00009	ZO MLFB13 <> Anschluss
    MLFB13_1FK7M	PMD_AAB047_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
    1				Z0006						T

*/
function Bestimme_E_Anschluss(oData)
{
    /*var oMLFB = oData.oParsingData.MLFB;
    var PMD_ABV400_001_000_1FT7 = oData.oParsingData.ABV400;
    var MLFB13_1FT7 = oMLFB.POS13;
    
    var sSQL = "SELECT * FROM VT_1FK7M_M00009_19624 WHERE " +
                "MLFB13_1FK7M = '" + MLFB13_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, "VT_1FK7M_M00009_19624"+"_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAB047_001_000_1FK7M = aResult[0].PMD_AAB047_001_000_1FK7M; // Anordnung des elektrischen Anschlusses
        
        //ECL_DeactivateAllAttributeValues("PMD_AAB047_001_000_1FK7M");
        ECL_ActivateValue("PMD_AAB047_001_000_1FK7M", PMD_AAB047_001_000_1FK7M);
        ECL_SetValue("PMD_AAB047_001_000_1FK7M", PMD_AAB047_001_000_1FK7M);
    }else{
	oData.strError = "DICT1_ERR_1FK7___PARSER_E_CONNECT";
	return;
    }
    */
    ECL_ActivateValue("PMD_AAB047_001_000_1FK7M", "Z0006");
    ECL_SetValue("PMD_AAB047_001_000_1FK7M", "Z0006");
}

// ################################################################################################################
// Bauform gemäß Code I			PMD_AAC949_001_000_1FT7 	(Flanschausführung)
// ################################################################################################################
/*
VT_1FK7M_M00008	Bauform <> MLFB12
    MLFB12_1FK7M	PMD_AAC949_001_000_1FK7M	HMK_VALUE_VALID_1FK7M


VT_1FT7_M00189	Mapping Vorselektor Bauform
VT_1FT7_M00207	Opt. Verstärkte Lagerung
VT_1FT7_M00243	Opt. Edelstahlwelle + Beständigkeit

MLFB12
*/
function Bestimme_Bauform(oData)
{
    /*var oMLFB = oData.oParsingData.MLFB;
    var MLFB12_1FK7M = oMLFB.POS12;
    
    var sSQL = "SELECT * FROM VT_1FK7M_M00008_19624 WHERE " +
                "MLFB12_1FK7M = '" + MLFB12_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, "VT_1FK7M_M00008_19624"+"_PARSE");
    if (aResult.length > 0)
    {
        var PMD_AAC949_001_000_1FK7M = aResult[0].PMD_AAC949_001_000_1FK7M; // Bauform
        
        //ECL_DeactivateAllAttributeValues("PMD_AAC949_001_000_1FK7M");
        ECL_ActivateValue("PMD_AAC949_001_000_1FK7M", PMD_AAC949_001_000_1FK7M);
        ECL_SetValue("PMD_AAC949_001_000_1FK7M", PMD_AAC949_001_000_1FK7M);
    }else{
	oData.strError = "DICT1_ERR_1FK7___PARSER_DESIGN";
	return;
    }
    */
    // immer "Z0003"
    ECL_ActivateValue("PMD_AAC949_001_000_1FK7M", "Z0003");
    ECL_SetValue("PMD_AAC949_001_000_1FK7M", "Z0003");
}



// ################################################################################################################
// Schutzart IP			PMD_ABJ176_001_000_1FK7M	
// ################################################################################################################
/*
VT_1FK7M_M00170	O: M03/M39 einschränken
    HMK_KONFIG_ZIEL_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	PMD_ABJ176_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

VT_1FK7M_M00182	ZO MLFB16 <> Schutzart
    MLFB05_06_08_1FK7M	HMK_FARBAUSFUEHRUNG_1006091	PMD_ABJ176_001_000_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M

VT_1FK7M_M00195	MLFB09 <> Schutzart
    MLFB09_1FK7M	PMD_ABJ176_001_000_1FK7M	HMK_VALUE_VALID_1FK7M


MLFB16_1FK7M
    VT_1FK7M_M00019	ZO gültige MLFB16
    VT_1FK7M_M00135	ZO R72
    VT_1FK7M_M00266	ZO Q20
    O_Q20_1FK7M	MLFB08_1FK7M	MLFB09_1FK7M	MLFB11_1FK7M	MLFB12_1FK7M	MLFB13_1FK7M	MLFB14_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M
    VT_1FK7M_M00182	ZO MLFB16 <> Schutzart

*/
function Bestimme_Schutzart(oData)
{
    var oMLFB = oData.oParsingData.MLFB;
    var MLFB09_1FK7M = oMLFB.POS9;
    var MLFB16_1FK7M = oMLFB.POS16;
    var MLFB05_06_08_1FK7M = oMLFB.POS5_6_8;
    
    // nur eindeutig mit VT182 + VT195, daher Inner Join
    var sTable_A = "VT_1FK7M_M00182" + sDB_Suffix;
    var sTable_B = "VT_1FK7M_M00195" + sDB_Suffix;
    
    var sSQL = "SELECT DISTINCT " + sTable_A + ".PMD_ABJ176_001_000_1FK7M FROM " + sTable_A + " " +
                "INNER JOIN " + sTable_B + " ON " + 
                sTable_B +".PMD_ABJ176_001_000_1FK7M = "+ sTable_A +".PMD_ABJ176_001_000_1FK7M WHERE " + 
                sTable_A +".MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                sTable_A +".MLFB16_1FK7M = '" + MLFB16_1FK7M + "' AND " +
                sTable_B +".MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                sTable_A +".HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTable_B +".HMK_VALUE_VALID_1FK7M = 'T';"; 
    
    
    var aResult = GetDBDataSetEXT(sSQL, sTable_A +"_IJOIN_PARSE");
    if (aResult.length > 0)
    {
        var PMD_ABJ176_001_000_1FK7M = aResult[0].PMD_ABJ176_001_000_1FK7M; // Schutzart IP
        
        ECL_ActivateValue("PMD_ABJ176_001_000_1FK7M", PMD_ABJ176_001_000_1FK7M);
        ECL_SetValue("PMD_ABJ176_001_000_1FK7M", PMD_ABJ176_001_000_1FK7M);
    }else{
        var sTable_A = "VT_1FK7M_M00182" + sDB_Suffix;
        var sTable_B = "VT_1FK7M_M00195" + sDB_Suffix;
        
        var sSQL = "SELECT DISTINCT " + sTable_A + ".PMD_ABJ176_001_000_1FK7M, " + sTable_A + ".MLFB16_1FK7M FROM " + sTable_A + " " +
                "INNER JOIN " + sTable_B + " ON " + 
                sTable_B + ".PMD_ABJ176_001_000_1FK7M = " + sTable_A + ".PMD_ABJ176_001_000_1FK7M WHERE " + 
                sTable_A + ".MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                sTable_B + ".MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                sTable_A + ".HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTable_B + ".HMK_VALUE_VALID_1FK7M = 'T';"; 
        
        
        var aResult = GetDBDataSetEXT(sSQL, sTable_A +"_IJOIN_PARSE");
        if (aResult.length > 0)
        {
            var PMD_ABJ176_001_000_1FK7M = aResult[0].PMD_ABJ176_001_000_1FK7M; // Schutzart IP
            var MLFB16_1FK7M = aResult[0].MLFB16_1FK7M;
            //ECL_DeactivateAllAttributeValues("PMD_ABJ176_001_000_1FK7M");
            ECL_ActivateValue("PMD_ABJ176_001_000_1FK7M", PMD_ABJ176_001_000_1FK7M);
            ECL_SetValue("PMD_ABJ176_001_000_1FK7M", PMD_ABJ176_001_000_1FK7M);
            
            var sMLFB = ECL_GetValue("ECSI_MLFB");
            var sMLFB = replaceAt(sMLFB, 15, MLFB16_1FK7M);
            ECL_SetValue("ECSI_MLFB", sMLFB);
        }else{
			oData.strError = "DICT1_ERR_1FK7___PARSER_IP_CLASS";
			return;
		}
    }
}

// ################################################################################################################
