//@legacy
//#mode(full-ecma)



//@import "VT_1FK7.js"


/*

*/

function SetOptionen_1_Init(oData)
{
    if (oData && !isEmpty(oData)){
        
        Bestimme_Pruefbescheinigung(oData); 	// O_B02_1FK7M	Werksprüfzeugnis
        Bestimme_Referenzmarke(oData); 			// O_R06_1FK7M	Referenzmarke auf Motorwelle
        //Bestimme_Sondergeber(oData);			// O_R72_1FK7M	Sondergeber
        
    }else{
        
        ExecSetStandardifValueEmpty("O_B02_1FK7M","F");
        ExecSetStandardifValueEmpty("O_R06_1FK7M","F");
        ExecSetStandardifValueEmpty("O_R72_1FK7M","F");
        
    }
}

function SetOptionen_1(strchangedAttribute, oData)
{
}

/**
    O_R06_1FK7M	Referenzmarke auf Motorwelle
*/

function Bestimme_Referenzmarke(oData)
{
    // O_R06_1FK7M
    // KAG: R06, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_R06_1FK7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "R06"; //getKAGforAttribute(sTargetAttribute, parseObj.MLFB.KAG);
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){	//if (sKAG != "NON"){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkReferenzmarke(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkReferenzmarke(oData, sTargetAttribute, sKAG)
{
    if (oData.IsDriveTrain == 1)
    {
        return 0;
    }
    /* 
    VT_1FK7M_M00168_19624	ZO R06
        O_R06_1FK7M		MLFB08_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00193_19624	O: R06 <-> Motor mit / ohne Getriebe
        O_R06_1FK7M		HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    
    var MLFB08_1FK7M = oData.oParsingData.MLFB.POS8;
    var MLFB09_1FK7M = oData.oParsingData.MLFB.POS9;
    var MLFB14_1FK7M = oData.oParsingData.MLFB.POS14;
    
    var sTable = "VT_1FK7M_M00168" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
    
    var sTable = "VT_1FK7M_M00193" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ##############################################################################################

// ################################################################################################################
// Abnahmeprüfzeugnis			O_B02_1FK7M
// ################################################################################################################
function Bestimme_Pruefbescheinigung(oData)
{
    // O_B02_1FK7M
    // KAG: B02, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_B02_1FK7M";
    
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "B02";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1 && oData.IsDriveTrain == 0){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
// ################################################################################################################
// O_R72_1FK7M	Sondergeber
function Bestimme_Sondergeber(oData)
{
    // O_R72_1FK7M
    // KAG: R72, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_R72_1FK7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "R72"; 
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkSondergeber(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkSondergeber(oData, sTargetAttribute, sKAG)
{
    // VT_1FK7M_M00135_19624	ZO R72
    // 	O_R72_1FK7M	MLFB05_06_08_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	MLFB15_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M

    var MLFB05_06_08_1FK7M = oData.oParsingData.MLFB.POS5_6_8;
    var MLFB09_1FK7M = oData.oParsingData.MLFB.POS9;
    var MLFB14_1FK7M = oData.oParsingData.MLFB.POS14;
    var MLFB15_1FK7M = oData.oParsingData.MLFB.POS15;
    var MLFB16_1FK7M = oData.oParsingData.MLFB.POS16;
    
    var sTable = "VT_1FK7M_M00135" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB05_06_08_1FK7M = '"+ MLFB05_06_08_1FK7M + "' AND " +
                "MLFB09_1FK7M = '" 		+ MLFB09_1FK7M 		 + "' AND " +
                "MLFB14_1FK7M = '" 		+ MLFB14_1FK7M 		 + "' AND " +
                "MLFB15_1FK7M = '" 		+ MLFB15_1FK7M 		 + "' AND " +
                "MLFB16_1FK7M = '" 		+ MLFB16_1FK7M 		 + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################

// ################################################################################################################


