//@legacy
//#mode(full-ecma)



//@import "VT_1FK7.js"


/*
Checkroutinen ergänzt für Keep Konfiguration
*/

function SetOptionen_2_Init(oData)
{
    if (oData && !isEmpty(oData)){
        Bestimme_Metallschild(oData);					// O_Q30_Q31_1FK7M		Metall-Leistungsschild am Motor
        Bestimme_ChemBest(oData);						// O_N16_1006091		Ausführung für erhöhte chemische Beständigkeit
        Bestimme_Kundenangabe_Leistungsschild(oData);	// O_Y84_1FK7M			Kundenangabe auf dem Leistungsschild
        Bestimme_Erdung(oData); 	 					// O_L13_1FK7M			Äusserer Erdungsanschluss
        Bestimme_Druckausgleich(oData); 				// O_Q20_1FK7M			Anschluss zum Druckausgleich
        
    }else{
        //ExecSetStandardifValueEmpty("PMD_ABV483_001_000_1FK7M","F"); //
        ExecSetStandardifValueEmpty("O_Q30_Q31_1FK7M","F"); // Metall-Leistungsschild am Motor
        ExecSetStandardifValueEmpty("O_N16_1006091","F"); 	// Ausführung für erhöhte chemische Beständigkeit
        ExecSetStandardifValueEmpty("O_Y84_1FK7M","F");		
        //ExecSetStandardifValueEmpty("O_L13_1FK7M","F");		
        //ExecSetStandardifValueEmpty("O_Q20_1FK7M","F");		
    }
}

function SetOptionen_2(strchangedAttribute, oData)
{
}

// ################################################################################################################
// O_Q30_Q31_1FK7M					Metall-Leistungsschild
// ################################################################################################################
/**
    n.n. PMD_ABV483_001_000_1FK7M		Metall Leistungsschild am Motor (T/F)
    O_Q30_Q31_1FK7M					Metall-Leistungsschild			(Q31, F)

    n.n. PMD_ABV483_001_000_1FK7M
        VT_1FK7M_M00036	O: Metall-Leistungsschild def.
            PMD_ABV483_001_000_1FK7M	MLFB08_1FK7M	O_Q30_Q31_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

    O_Q30_Q31_1FK7M
        VT_1FK7M_M00036	O: Metall-Leistungsschild def.

*/

function Bestimme_Metallschild(oData)
{
    // O_Q30_Q31_1FK7M
    // KAG: Q31, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_Q30_Q31_1FK7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q31";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkMetallschild(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        sKAG = "F";
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkMetallschild(oData, sTargetAttribute, sKAG)
{
    if (oData.IsDriveTrain == 1)
    {
        return 0;
    }
    /*
    VT_1FK7M_M00036_19624	O: Metall-Leistungsschild def.
        (PMD_ABV483_001_000_1FK7M)	MLFB08_1FK7M	O_Q30_Q31_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    var MLFB08_1FK7M = oData.oParsingData.MLFB.POS8;
    var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
    
    var sTable = "VT_1FK7M_M00036" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB08_1FK7M = '" 			+ MLFB08_1FK7M 			+ "' AND " +
                "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    
    return 1;
}
// ##############################################################################################



// ################################################################################################################
// O_N16_1006091	Ausführung für erhöhte chemische Beständigkeit
// ################################################################################################################
function Bestimme_ChemBest(oData)
{
    // O_N16_1006091
    // KAG: N16, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_N16_1006091";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "N16";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkChemBest(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // wenn erlaubt, setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG oder nicht erlaubt, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkChemBest(oData, sTargetAttribute, sKAG)
{
    if (oData.IsDriveTrain == 1)
	{
		return 0;
	}
    /*
    A: VT_1FK7M_M00149_19624	O: N16 <-> Motor mit / ohne Getriebe
        O_N16_1006091	PMD_ABV517_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    B VT_1FK7M_M00166_19624	ZO N16
        O_N16_1006091	MLFB08_1FK7M	MLFB09_1FK7M	MLFB13_1FK7M	MLFB14_1FK7M	HMK_VALUE_VALID_1FK7M

    C: VT_1FK7M_M00183_19624	O: N16
        HMK_FARBAUSFUEHRUNG_1006091	O_N16_1006091	HMK_VALUE_VALID_1FK7M

    D: VT_1FK7M_M00220_19624	O: L13, N16, M* einschränken
        O_L13_1FK7M	O_N16_1006091	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M

    E: VT_1FK7M_M00225	ZO N16 Q20
        O_Q20_1FK7M	O_N16_1006091	HMK_VALUE_VALID_1FK7M

neu	VT_1FK7M_M00235_19624	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    // A:
    var PMD_ABV517_001_000_1FK7M = ECL_GetValue("PMD_ABV517_001_000_1FK7M");
    
    var sTable = "VT_1FK7M_M00149" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "PMD_ABV517_001_000_1FK7M = '" + PMD_ABV517_001_000_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    // B: --------------------------------------------------------------------------------------------------------------
    var MLFB08_1FK7M = oData.oParsingData.MLFB.POS8;
    var MLFB09_1FK7M = oData.oParsingData.MLFB.POS9;
    var MLFB13_1FK7M = oData.oParsingData.MLFB.POS13;
    var MLFB14_1FK7M = oData.oParsingData.MLFB.POS14;
    
    var sTable = "VT_1FK7M_M00166" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                "MLFB13_1FK7M = '" + MLFB13_1FK7M + "' AND " +
                "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    // C: --------------------------------------------------------------------------------------------------------------
    var HMK_FARBAUSFUEHRUNG_1006091 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1006091");
    
    var sTable = "VT_1FK7M_M00183" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "HMK_FARBAUSFUEHRUNG_1006091 = '" + HMK_FARBAUSFUEHRUNG_1006091 + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    // D: --------------------------------------------------------------------------------------------------------------
    //var O_L13_1FK7M = ECL_GetValue("O_L13_1FK7M");
    var O_M03_M39_1FK7M = ECL_GetValue("O_M03_M39_1FK7M");
    
    var sTable = "VT_1FK7M_M00220" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
    // 			"O_L13_1FK7M = '" + O_L13_1FK7M + "' AND " +
                "O_M03_M39_1FK7M = '" + O_M03_M39_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
/*	VT_1FK7M_M00235_19624	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
*/
    var PMD_ABU278_001_000_1FK7M = ECL_GetValue("PMD_ABU278_001_000_1FK7M");
    var HMK_KONFIG_ZIEL_1FK7M =  oData.oParsingData.KONF_ZIEL;
    
    var sTable = "VT_1FK7M_M00235" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                "PMD_ABU278_001_000_1FK7M = '" + PMD_ABU278_001_000_1FK7M + "' AND " +
                "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// O_Y84_1FK7M			Kundenangabe auf dem Leistungsschild
// ################################################################################################################
/**
    H_O_Y84_1FK7M	Kundenangabe auf dem Leistungsschild (Textfeld) 
    Text wird im Parser befüllt
*/

function Bestimme_Kundenangabe_Leistungsschild(oData)
{
    // O_Y84_1FK7M
    // KAG: Y84, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_Y84_1FK7M";
    //var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Y84";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, 
        // setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}

// ################################################################################################################


// ################################################################################################################
// O_L13_1FK7M			Äusserer Erdungsanschluss
// ################################################################################################################
function Bestimme_Erdung(oData)
{
    // O_L13_1FK7M
    // KAG: L13, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_L13_1FK7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "L13";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkErdung(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkErdung(oData, sTargetAttribute, sKAG)
{
    /*
    VT_1FK7M_M00220_19624	O: L13, N16, M* einschränken
        O_L13_1FK7M		O_N16_1006091	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M
        
    VT_1FK7M_M00226_19624	ZO L13
        O_L13_1FK7M		MLFB08_1FK7M	MLFB09_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

    */
    var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
    var O_M03_M39_1FK7M = ECL_GetValue("O_M03_M39_1FK7M");
    
    var sTable = "VT_1FK7M_M00220" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                 "O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                "O_M03_M39_1FK7M = '" + O_M03_M39_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var MLFB08_1FK7M = oData.oParsingData.MLFB.POS8;
    var MLFB09_1FK7M = oData.oParsingData.MLFB.POS9;
    var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
    
    var sTable = "VT_1FK7M_M00226" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################


// ################################################################################################################
// O_Q20_1FK7M			Anschluss zum Druckausgleich
// ################################################################################################################
function Bestimme_Druckausgleich(oData)
{
    // O_Q20_1FK7M
    // KAG: Q20, F
    var parseObj = oData.oParsingData;
    
    var sTargetAttribute = "O_Q20_1FK7M";
    var bCheck = false;
    
    // KAG aus MLFB für dieses Attribut abfragen, wenn vorhanden
    var sKAG = "Q20";
    var aKAG = parseObj.MLFB.KAG || [];
    
    if (aKAG.indexOf(sKAG) > -1){
        // es gibt eine KAG, also prüfen, ob erlaubt
        bCheck = checkDruckausgleich(oData, sTargetAttribute, sKAG);
    }
    if (bCheck){
        // setzen
        ECL_ActivateValue(sTargetAttribute, sKAG);
        ECL_SetValue(sTargetAttribute, sKAG);
    }
    // wenn keine KAG, F setzen
    else{
        ECL_ActivateValue(sTargetAttribute, "F");
        ECL_SetValue(sTargetAttribute, "F");
    }
}
function checkDruckausgleich(oData, sTargetAttribute, sKAG)
{
    /*
    VT_1FK7M_M00155_19624	O: Q20 <-> M03, M39
        O_Q20_1FK7M	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00266_19624	ZO Q20
		O_Q20_1FK7M	MLFB08_1FK7M	MLFB09_1FK7M	MLFB11_1FK7M	MLFB12_1FK7M	MLFB13_1FK7M	MLFB14_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M
    
        VT_1FK7M_M00225_19624	ZO N16 Q20
        O_Q20_1FK7M	O_N16_1006091	HMK_VALUE_VALID_1FK7M

    */
    var O_M03_M39_1FK7M = ECL_GetValue("O_M03_M39_1FK7M");
    
    var sTable = "VT_1FK7M_M00155" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "O_M03_M39_1FK7M = '" + O_M03_M39_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var MLFB08_1FK7M = oData.oParsingData.MLFB.POS8;
    var MLFB09_1FK7M = oData.oParsingData.MLFB.POS9;
    var MLFB11_1FK7M = oData.oParsingData.MLFB.POS11;
    var MLFB12_1FK7M = oData.oParsingData.MLFB.POS12;
    var MLFB13_1FK7M = oData.oParsingData.MLFB.POS13;
    var MLFB14_1FK7M = oData.oParsingData.MLFB.POS14;
    var MLFB16_1FK7M = oData.oParsingData.MLFB.POS16;
    
    var sTable = "VT_1FK7M_M00266" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                "MLFB11_1FK7M = '" + MLFB11_1FK7M + "' AND " +
                "MLFB12_1FK7M = '" + MLFB12_1FK7M + "' AND " +
                "MLFB13_1FK7M = '" + MLFB13_1FK7M + "' AND " +
                "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                "MLFB16_1FK7M = '" + MLFB16_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
    
    var sTable = "VT_1FK7M_M00225" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
                "O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T' AND " +
                sTargetAttribute + " = '" + sKAG + "';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable + "_KAG");
    if (aResult.length < 1){
        return 0;
    }
    
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}
// ################################################################################################################
