//@legacy
//#mode(full-ecma)



//@import "../1FK7_MLFB/Base.misc.js"

//@import "VT_1FK7.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute)
{
    var strError = "";

    var sMLFB = ECL_GetValue("ECSI_MLFB");
    var sMLFB1_4 = sMLFB.left(4);
    var MLFB01_1FK7M = sMLFB.left(4);
    
    var MLFB05_1FK7M = sMLFB.charAt(4);  //AH 5+6
    var MLFB06_1FK7M = sMLFB.charAt(5);  //AH 5+6
    var MLFB05_06_1FK7M = MLFB05_1FK7M + MLFB06_1FK7M; // MLFB5+6 AH
    var MLFB07_1FK7M = sMLFB.charAt(6); //
    var MLFB08_1FK7M = sMLFB.charAt(7); //
    var MLFB05_06_08_1FK7M = MLFB05_1FK7M + MLFB06_1FK7M + "_" + MLFB08_1FK7M; //
    var MLFB09_1FK7M = sMLFB.charAt(8);
    var MLFB10_1FK7M = sMLFB.charAt(9);
    var MLFB11_1FK7M = sMLFB.charAt(10);
    var MLFB12_1FK7M = sMLFB.charAt(11);
    var MLFB13_1FK7M = sMLFB.charAt(12);
    var MLFB14_1FK7M = sMLFB.charAt(13);
    var MLFB15_1FK7M = sMLFB.charAt(14);
    var MLFB16_1FK7M = sMLFB.charAt(15);
    
    var HMK_BAUGROESSE_1FK7M = ECL_GetValue("HMK_BAUGROESSE_1FK7M"); // MLFB5+6+7 mit neuer ID
    
    var MLFB_RUMPF_01_11_1FK7M = sMLFB.substring(0, 11);
    
    var HMK_KONFIG_TYP_1FK7M = "konfig";	// ECL_GetValue("HMK_KONFIG_TYP_1FK7M");
    var HMK_GENERATION_1FK7M = "00002";		// ECL_GetValue("HMK_GENERATION_1FK7M");
    
    var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
    
    var ECSI_CX_IsDriveTrain = ECL_GetValue("ECSI_CX_IsDriveTrain");
    var ECSI_CX_GearboxMotorCoupling = parseInt(ECL_GetValue("ECSI_CX_GearboxMotorCoupling"));
    
    ECSI_CX_IsDriveTrain = parseInt(ECSI_CX_IsDriveTrain);
    if (ECSI_CX_IsDriveTrain !== 1)
    {
        ECSI_CX_IsDriveTrain = 0;
    }
    
    /* Konfig_Ziel wird definiert von:
        VT  37 - alternatives Wellenende
        VT 105 - Geber
        VT 116 - Getriebe	(PMD_ABV517_001_000_1FK7M)
        VT 144 - Rumpf, MLFB14, Geber
        VT 193 - R06 nur ohne Getriebe
        VT 226 - L13 kein DYAG2
        VT 227 - K24 kein DYAG2
    */
    ECL_ActivateAllAttributeValues("HMK_KONFIG_ZIEL_1FK7M");
    
    
    
    // ################################################################################################################
    /*
    HMK_BAUGROESSE_1FK7M	Baugröße (Achshöhe + Baulänge)
    
    VT_1FK7M_M00078	Hilfstabelle_Baugröße
    VT_1FK7M_M00087	tech_Daten_Stoeber
    VT_1FK7M_M00109	Zuordnung_Baugroesse_I_Getriebe_Optionen
    VT_1FK7M_M00163	Baugröße <-> MLFB11
    */
    
    // ################################################################################################################
    // Zwischenkreisspannung	
    // ################################################################################################################
    /*
    NN
    */
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Achshöhe			PMD_ACH516_001_000_1FK7M
    // 					UI_VT_ACHSHOEHE_1FK7M
    // ################################################################################################################
    /*	
    PMD_ACH516_001_000_1FK7M
        VT_1FK7M_M00069	ZO MLFB05_06 < > AH
        VT_1FK7M_M00070	ZO AH > Haltebremse > Gewicht Bremse
        VT_1FK7M_M00071	ZO AH > Geber > Gewicht Geber
        VT_1FK7M_M00125	ZO Rundlauftoleranz <-> AH
        VT_1FK7M_M00126	ZO Koaxial-, Planlauftoler. <-> AH
        VT_1FK7M_M00259	UI: AH_MAX einschränken

    n.n. UI_VT_ACHSHOEHE_1FK7M
    
        VT_1FK7M_M00216	UI-Tabelle

    
    MLFB05+06
    */
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Baulänge			TAK_ABU212_001_000_1FK7M	
    // ################################################################################################################
    /*
    VT_1FK7M_M00003	ZO MLFB07 < > Baulänge
    
    MLFB07		1:1
    */
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Motortyp		PMD_AAA259_001_000_1FK7M
    // ################################################################################################################
    /*
    VT_1FK7M_M00119	ZO MLFB08 < > Motortyp
        MLFB08_1FK7M	PMD_AAA259_001_000_1FK7M	HMK_GENERATION_1FK7M	HMK_VALUE_VALID_1FK7M
    
    2	Z0001	00002	T		Compact
    3	Z0003	00002	T		High Dynamic
    4	Z0002	00002	T		High Inertia

    MLFB08
    */
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Art der Kühlung			PMD_AAA136_001_000_1FK7M	
    // ################################################################################################################
    /*
    SIZER-Vorgabe
    
    VT_1FK7M_M00005	ZO MLFB09 < > Kühlart
        MLFB09_1FK7M	PMD_AAA136_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    Z0003	Fremdbelüftung
    Z0004	Selbstkühlung
    
    MLFB09_1FK7M	PMD_AAA136_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
    A				Z0004	Selbstkühlung			T
    B				Z0004	Selbstkühlung			T
    C				Z0004	Selbstkühlung			T
    S				Z0003	Fremdbelüftung			T
    */
    
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Bemessungsdrehzahl			PMD_AAE020_001_000_1FK7M	
    // ################################################################################################################
    /*
    im Parser definiert
    
    MLFB10 
        VT_1FK7M_M00172	ZO MLFB_RUMPF

    */
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Bauform 		PMD_AAC949_001_000_1FK7M 	
    // ################################################################################################################
    /*
    VT_1FK7M_M00008	ZO MLFB12 <> Bauform
    
    MLFB12_1FK7M	PMD_AAC949_001_000_1FK7M
        1				Z0003	IM B5 (IM V1,IM V3)
        4				Z0003	IM B5 (IM V1,IM V3)


    MLFB12
        VT_1FK7M_M00008	ZO MLFB12 <> Bauform
        VT_1FK7M_M00144	ZO MLFB-Rumpf, MLFB12, Geber
        VT_1FK7M_M00157	ZO gültige Geber
        VT_1FK7M_M00266	ZO Q20
    
    FIX, nur eine Bauform! Aber zwei MLFB12 Werte, diese müssen bestimmt werden
    */
    
    // Bestimmung MLFB12
    /* VT_1FK7M_M00157
        HMK_KONFIG_TYP_1FK7M	MLFB05_06_08_1FK7M	MLFB12_1FK7M	MLFB14_1FK7M	PMD_AAA717_001_000_1FK7M	HMK_PRODUKT_ALT_AKT_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    var sTable = "VT_1FK7M_M00157" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT MLFB12_1FK7M FROM " + sTable + " WHERE " +
                "HMK_KONFIG_TYP_1FK7M = '" + HMK_KONFIG_TYP_1FK7M 	+ "' AND " +
                "MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M 	+ "' AND " +
                "MLFB14_1FK7M = '" 		 + MLFB14_1FK7M 		+ "' AND " +
                "HMK_PRODUKT_ALT_AKT_1FK7M = 'AKT' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_BEST_MLFB12");
    if (aResult.length > 0)
    {
        var MLFB12_1FK7M = aResult[0].MLFB12_1FK7M;
        
        sMLFB = replaceAt(sMLFB, 11, MLFB12_1FK7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_BESTIMMUNG_MLFB12_NO_DB_RESULT";
        return strError;
    }
    //MLFB_RUMPF_01_11_1FK7M = sMLFB.substring(0, 11);
    // ################################################################################################################
    
    
    // Wenn N16 abgewählt wird, anderen Geber wählen:
    if (strchangedAttribute == "CB_O_N16_1006091"){
        var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
        if (O_N16_1006091 == "F"){
            
            var sTable = "VT_1FK7M_M00235" + sDB_Suffix;
            var sTargetAttribute = "PMD_ABU278_001_000_1FK7M";
            var sWhere = 	"O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                            "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                            "HMK_VALUE_VALID_1FK7M = 'T';";
          
            var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
            if (sStatus == "Error"){
                strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
                return strError;
            }
        }
    }
    
    // ################################################################################################################
    // Haltebremse			UI_HALTEBREMSE_1FK7M	
    // ################################################################################################################
    /*
    UI_HALTEBREMSE_1FK7M	HMK_KONFIG_ZIEL_1FK7M
    M_FK7					SERVO                     Mit Haltebremse
    N24  					SERVO                     Option: verstärkte Bremse
    OHNE 					SERVO                     Ohne Haltebremse
    M_FK7					G_DYAG2                       
    N24  					G_DYAG2                       
    OHNE 					G_DYAG2                       
    M_FK7					G_PLANET_LP                   
    N24  					G_PLANET_LP                   
    OHNE 					G_PLANET_LP                   
    M_FK7					G_PLANET_SP                   
    N24  					G_PLANET_SP                   
    OHNE 					G_PLANET_SP                   
    
    B: VT_1FK7M_M00151	MLFB15-Wellenende-Haltebremse
        MLFB15_1FK7M	PMD_AAA506_001_000_1FK7M	UI_HALTEBREMSE_1FK7M	HMK_VALUE_VALID_1FK7M
        
    A: VT_1FK7M_M00191	O: N24 verstärkte Bremse
        UI_HALTEBREMSE_1FK7M	MLFB05_06_08_1FK7M	MLFB07_1FK7M	HMK_VALUE_VALID_1FK7M
    
    n.n. VT_1FK7M_M00070	ZO AH > Haltebremse > Gewicht Bremse	<----	Nur zur Geweichtsauswertung, keine Logik!
        PMD_ACH516_001_000_1FK7M	UI_HALTEBREMSE_1FK7M	HMK_GEWICHT_BREMSE_1FK7M	HMK_VALUE_VALID_1FK7M
    n.n. VT_1FK7M_M00085	Option-Arbeitsbremse		<---- nicht nötig, keine Logikeinschränkung
        HMK_KONFIG_ZIEL_1FK7M	MLFB05_06_1FK7M	UI_HALTEBREMSE_1FK7M	HMK_BREMSMOMENT_1FK7M	O_N30_BIS_N34_1FK7M
    n.n. VT_1FK7M_M00150	Haltebremse-Konfigziel		<---- Abbildung über zulässige Werte im dynamischen Werteimport, 
        UI_HALTEBREMSE_1FK7M	HMK_KONFIG_ZIEL_1FK7M
    n.n. VT_1FK7M_M00153	K82-Haltebremse						<---- gilt nur für ARB-Bremse
        O_K82_1FK7M	UI_HALTEBREMSE_1FK7M
    n.n. VT_1FK7M_M00154	C05-Haltebremse						<---- gilt nur für ARB-Bremse
    n.n. VT_1FK7M_M00173	Haltebremse						TD	n.n.
        HMK_KONFIG_ZIEL_1FK7M	UI_HALTEBREMSE_1FK7M	MLFB05_06_1FK7M	MLFB07_1FK7M	O_N30_BIS_N34_1FK7M	PMD_ACE868_001_000_1FK7M	
        PMD_ACF397_001_000_1FK7M	PMD_ACE853_001_000_1FK7M	PMD_ACE858_001_000_1FK7M	PMD_ACE859_001_000_1FK7M	PMD_ACF398_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
    n.n. VT_1FK7M_M00174	Datenblatttrigger Haltebremse	TD n.n.
    
    
    NEU	VT_1FK7M_M00253	ZO N24 <> M03/M39
        UI_HALTEBREMSE_1FK7M	O_M03_M39_1FK7M
    todo, wenn wieder freigegeben
        
    MLFB15
        VT_1FK7M_M00018	ZO gültige MLFB15
            HMK_KONFIG_ZIEL_1FK7M	MLFB15_1FK7M	HMK_VALUE_VALID_1FK7M
        
        VT_1FK7M_M00135	ZO R72
            O_R72_1FK7M	MLFB05_06_08_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	MLFB15_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    // gültige MLFB15  
    /* aus VT18
    HMK_KONFIG_ZIEL_1FK7M	MLFB15_1FK7M
    SERVO					A
    SERVO					B
    SERVO					G
    SERVO					H
    G_PLANET_LP				G
    G_PLANET_LP				H
    G_PLANET_SP				G
    G_PLANET_SP				H
    G_DYAG2					U
    G_DYAG2					V
    */
    var sTable = "VT_1FK7M_M00018" + sDB_Suffix;
    var sTargetAttribute = "MLFB15_1FK7M";
    var sWhere = 	"HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_MLFB15_NO_DB_RESULT";
        return strError;
    }
    
    // ----------------------------------------------------------------------------------------------------------------
    var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
    if (strwithBrake == "1"){
        // mit Bremse
        //ECL_DeactivateValue("UI_HALTEBREMSE_1FK7M", "OHNE");		// durch MLFB15 Übertragung abgedeckt
        ECL_DeactivateValue("MLFB15_1FK7M", "A");
        ECL_DeactivateValue("MLFB15_1FK7M", "G");
        ECL_DeactivateValue("MLFB15_1FK7M", "U");
    }else{
        // ohne
        ECL_DeactivateValue("MLFB15_1FK7M", "B");
        ECL_DeactivateValue("MLFB15_1FK7M", "H");
        ECL_DeactivateValue("MLFB15_1FK7M", "V");
    }
    // ----------------------------------------------------------------------------------------------------------------
    // Übertragung auf Bremsen-Attribut
    var sStatus = SetAttributeLogicFromMLFB("UI_HALTEBREMSE_1FK7M", "MLFB15_1FK7M", "VT_1FK7M_M00151" + sDB_Suffix)
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_HALTEBREMSE_NO_DB_RESULT";
        return strError;
    }
    // ----------------------------------------------------------------------------------------------------------------
    
    var aValidValuesBrake = ECL_GetAllActiveAttributeValues("UI_HALTEBREMSE_1FK7M");
    if (aValidValuesBrake.length > 0){
        
        // A: ----------------------------------------------------------------------------------------------------------------
        /*
        A: VT_1FK7M_M00191	O: N24 verstärkte Bremse
            UI_HALTEBREMSE_1FK7M	MLFB05_06_08_1FK7M	MLFB07_1FK7M	HMK_VALUE_VALID_1FK7M
        */
        var sTable = "VT_1FK7M_M00191" + sDB_Suffix;
        var sTargetAttribute = "UI_HALTEBREMSE_1FK7M";
        var sWhere = 	"MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                        "MLFB07_1FK7M = '" + MLFB07_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_HALTEBREMSE_NO_DB_RESULT";
            return strError;
        }
        // B: ----------------------------------------------------------------------------------------------------------------
        /* VT_1FK7M_M00151	MLFB15-Wellenende-Haltebremse
            MLFB15_1FK7M	PMD_AAA506_001_000_1FK7M	UI_HALTEBREMSE_1FK7M	HMK_VALUE_VALID_1FK7M
        n.n., da über MLFB15-Logik abgebildet
        */
    }else{
        // Keine Option wählbar, Fehler! Bremsenvorwahl aus SIZER nicht erfüllbar.
        strError = "DICT1_ERR_1FK7___PLVT_HALTEBREMSE_NO_VALUE";
        return strError;
    }
    // ################################################################################################################
    
    
    
    // ################################################################################################################
    // Passfeder			UI_PASSFEDER_1FK7M
    // ################################################################################################################
    /*
    VT_1FK7M_M00027	UI -> Passfeder
    UI_PASSFEDER_1FK7M	PMD_AAA506_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    nur in Abhängigkeit zu Wellenende AAA506
    UI_PASSFEDER_1FK7M	PMD_AAA506_001_000_1FK7M	MLFB15_1FK7M
            T	    	Z0003						U, V
            F   	 	Z0002						G, H
            T    		00004						A, B
    
    SERVO (ohne Getriebe) Wahl möglich 	Passfeder T/F	Wellenende 00004/Z0002
    Planetengetriebe LP/SP				Passfeder F		Wellenende Z0002
    Planetengetriebe DYAG2				Passfeder T		Wellenende Z0003
    
    */
    switch (HMK_KONFIG_ZIEL_1FK7M){
        case "SERVO":
            ECL_ActivateAllAttributeValues("UI_PASSFEDER_1FK7M");
            
            var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
            if(strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1)
            {
                ECL_DeactivateValue("UI_PASSFEDER_1FK7M", "T");
            }
            ExecSetStandardifValueEmpty("UI_PASSFEDER_1FK7M", "T");
            var UI_PASSFEDER_1FK7M = ECL_GetValue("UI_PASSFEDER_1FK7M");
            if (UI_PASSFEDER_1FK7M == "T"){
                ECL_SetValue("PMD_AAA506_001_000_1FK7M", "00004");
            }else{
                ECL_SetValue("PMD_AAA506_001_000_1FK7M", "Z0002");
            }
        break;
        
        case "G_PLANET_LP":
            ECL_ActivateValue("UI_PASSFEDER_1FK7M", "F");
            ECL_DeactivateValue("UI_PASSFEDER_1FK7M", "T");
            ECL_SetValue("UI_PASSFEDER_1FK7M", "F");
            ECL_SetValue("PMD_AAA506_001_000_1FK7M", "Z0002");
        break;
        
        case "G_PLANET_SP":
            ECL_ActivateValue("UI_PASSFEDER_1FK7M", "F");
            ECL_DeactivateValue("UI_PASSFEDER_1FK7M", "T");
            ECL_SetValue("UI_PASSFEDER_1FK7M", "F");
            ECL_SetValue("PMD_AAA506_001_000_1FK7M", "Z0002");
        break;
        
        case "G_DYAG2":
            ECL_ActivateValue("UI_PASSFEDER_1FK7M", "T");
            ECL_DeactivateValue("UI_PASSFEDER_1FK7M", "F");
            ECL_SetValue("UI_PASSFEDER_1FK7M", "T");
            ECL_SetValue("PMD_AAA506_001_000_1FK7M", "Z0003");
        break;
        
        default:
            ECL_ActivateAllAttributeValues("UI_PASSFEDER_1FK7M");
            var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
            if(strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1)
            {
                ECL_DeactivateValue("UI_PASSFEDER_1FK7M", "T");
            }
            ExecSetStandardifValueEmpty("UI_PASSFEDER_1FK7M", "T");
            var UI_PASSFEDER_1FK7M = ECL_GetValue("UI_PASSFEDER_1FK7M");
            if (UI_PASSFEDER_1FK7M == "T"){
                ECL_SetValue("PMD_AAA506_001_000_1FK7M", "00004");
            }else{
                ECL_SetValue("PMD_AAA506_001_000_1FK7M", "Z0002");
            }
    }
 
    
    // ################################################################################################################
    
    
    // nur für Übersetzung und Tabellenauswertung nötig
    // ################################################################################################################
    // Wellenende an der Antriebsseite 			PMD_AAA506_001_000_1FK7M
    // ################################################################################################################
    /*
    VT_1FK7M_M00027	UI -> Passfeder
        UI_PASSFEDER_1FK7M	PMD_AAA506_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00151	MLFB15-Wellenende-Haltebremse
        MLFB15_1FK7M	PMD_AAA506_001_000_1FK7M	UI_HALTEBREMSE_1FK7M	HMK_VALUE_VALID_1FK7M

    Bestimmen aus 
        UI_PASSFEDER_1FK7M
        UI_HALTEBREMSE_1FK7M
        MLFB15?
        
        
    MLFB15 !!!!
    
    MLFB15_1FK7M	PMD_AAA506_001_000_1FK7M
    A				00004
    B				00004
    G				Z0002
    H				Z0002
    U				Z0003
    V				Z0003

    
    */
    
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Bestimmung MLFB15 aus Wellenende und Haltebremse
    // ################################################################################################################
    // VT_1FK7M_M00151	MLFB15-Wellenende-Haltebremse
    //	MLFB15_1FK7M	PMD_AAA506_001_000_1FK7M	UI_HALTEBREMSE_1FK7M	HMK_VALUE_VALID_1FK7M
    /*
    MLFB15 über VT18 (KonfZiel) einschränken
    mit VT151 und Bremse + Wellenende/Passfeder AAA506 eindeutig
    */
    var PMD_AAA506_001_000_1FK7M = ECL_GetValue("PMD_AAA506_001_000_1FK7M");	// Wellenende
    var UI_HALTEBREMSE_1FK7M = ECL_GetValue("UI_HALTEBREMSE_1FK7M");			// Bremse
    
    var sTable = "VT_1FK7M_M00151" + sDB_Suffix;
    var sSQL = "SELECT MLFB15_1FK7M FROM "+sTable+" WHERE " +
                "PMD_AAA506_001_000_1FK7M = '" + PMD_AAA506_001_000_1FK7M + "' AND " +
                "UI_HALTEBREMSE_1FK7M = '" + UI_HALTEBREMSE_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_MLFB");
    if (aResult.length > 0){
        
        var MLFB15_1FK7M = aResult[0].MLFB15_1FK7M;
        
        sMLFB = replaceAt(sMLFB, 14, MLFB15_1FK7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_BESTIMMUNG_MLFB15_NO_DB_RESULT";
        return strError;
    }

    //MLFB_RUMPF_01_11_1FK7M = sMLFB.substring(0, 11);
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Wellenausführung	UI_WELLENAUSF_1FK7M		STD/ALT		
    // PMD_AAD427_001_000_1FK7M	Wellenausführung	N05, F

    // ################################################################################################################
    /*
    A: VT_1FK7M_M00028	Definition Wellenmaße
        MLFB05_06_1FK7M	UI_WELLENAUSF_1FK7M	UI_WELLENMASZ_1FK7M	HMK_VALUE_VALID_1FK7M

    B: VT_1FK7M_M00037	O: N05 <> Konfigurationsziel
        UI_WELLENAUSF_1FK7M	PMD_AAD427_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

    */
    /*
    var sSQL = "SELECT VT_1FK7M_M00037_19624.PMD_AAD427_001_000_1FK7M FROM VT_1FK7M_M00037_19624 "
                "INNER JOIN VT_1FK7M_M00028_19624 " + 
                "ON VT_1FK7M_M00037_19624.UI_WELLENAUSF_1FK7M = VT_1FK7M_M00028_19624.UI_WELLENAUSF_1FK7M " + 
                "WHERE VT_1FK7M_M00182_19624.HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                "VT_1FK7M_M00028_19624.MLFB05_06_1FK7M = '" + MLFB05_06_1FK7M + "' AND " +
                "VT_1FK7M_M00037_19624.HMK_VALUE_VALID_1FK7M = 'T' AND " +
                "VT_1FK7M_M00028_19624.HMK_VALUE_VALID_1FK7M = 'T';"; 
    
    var aResult = GetDBDataSetEXT(sSQL, "PMD_AAD427_001_000_1FK7M"+"_JOIN");
    if (aResult.length > 0)
    {
        ECL_DeactivateAllAttributeValues("PMD_AAD427_001_000_1FK7M");
        
        for (var i = 0; i < aResult.length; i++){
            ECL_ActivateValue("PMD_AAD427_001_000_1FK7M", aResult[i].PMD_AAD427_001_000_1FK7M);
        }
        if (aResult.length == 1){
            ECL_SetValue("PMD_AAD427_001_000_1FK7M", aResult[0].PMD_AAD427_001_000_1FK7M);
        }
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_WELLENENDE_SONDER_NO_DB_RESULT";
        return strError;
    }
    var PMD_AAD427_001_000_1FK7M = ECL_GetValue("PMD_AAD427_001_000_1FK7M");
    if (PMD_AAD427_001_000_1FK7M == "N05"){
        ECL_SetValue("UI_WELLENAUSF_1FK7M", "ALT");
    }else{
        ECL_SetValue("UI_WELLENAUSF_1FK7M", "STD");
    }
    */
    // A: -------------------------------------------------------------------------------------
    var sTable = "VT_1FK7M_M00028" + sDB_Suffix;
    var sTargetAttribute = "UI_WELLENAUSF_1FK7M";
    var sWhere = 	"MLFB05_06_1FK7M = '" + MLFB05_06_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_WELLENENDE_SONDER_NO_DB_RESULT";
        return strError;
    }
    // B: -------------------------------------------------------------------------------------
    /* VT_1FK7M_M00037	O: N05 <> Konfigurationsziel
        UI_WELLENAUSF_1FK7M	PMD_AAD427_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */	
    //var HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
    
    var sTable = "VT_1FK7M_M00037" + sDB_Suffix;
    var sTargetAttribute = "UI_WELLENAUSF_1FK7M";
    var sWhere = 	"HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_WELLENENDE_SONDER_NO_DB_RESULT";
        return strError;
    }
    if (ECSI_CX_IsDriveTrain == 1  || ECSI_CX_GearboxMotorCoupling == 1){
        ECL_DeactivateValue("UI_WELLENAUSF_1FK7M", "ALT");
        ECL_SelectValue("UI_WELLENAUSF_1FK7M", "STD");
    }
    // ################################################################################################################
    /* Überstzung in KAG-Merkmal PMD_AAD427_001_000_1FK7M
    */
    var UI_WELLENAUSF_1FK7M = ECL_GetValue("UI_WELLENAUSF_1FK7M");
    
    switch(UI_WELLENAUSF_1FK7M){
        case "STD":
            ECL_SetValue("PMD_AAD427_001_000_1FK7M", "F");
            break;
        case "ALT":
            ECL_SetValue("PMD_AAD427_001_000_1FK7M", "N05");
            break;
    }
    // ################################################################################################################
    
    
    // ################################################################################################################
    /* Wenn alternatives Wellenende, dann Konfziel nur SERVO, kein Getriebe zulässig
    KonfZiel einschränken/Setzen
    VT_1FK7M_M00037	O: N05 <> Konfigurationsziel
        UI_WELLENAUSF_1FK7M	PMD_AAD427_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    var sTable = "VT_1FK7M_M00037" + sDB_Suffix;
    var sTargetAttribute = "HMK_KONFIG_ZIEL_1FK7M";
    var sWhere = 	"UI_WELLENAUSF_1FK7M = '" + UI_WELLENAUSF_1FK7M	+ "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_WELLENENDE_SONDER_KONF_ZIEL_NO_DB_RESULT";
        return strError;
    }
 
    // ################################################################################################################
    // Konfigziel neu setzen
    HMK_KONFIG_ZIEL_1FK7M = ECL_GetValue("HMK_KONFIG_ZIEL_1FK7M");
    
    // ################################################################################################################
    // UI_WELLENMASZ_1FK7M	Abmessungen
    // ################################################################################################################
    /*
    A: VT_1FK7M_M00028	Definition Wellenmaße
        MLFB05_06_1FK7M	UI_WELLENAUSF_1FK7M	UI_WELLENMASZ_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    // var UI_WELLENAUSF_1FK7M = ECL_GetValue("UI_WELLENAUSF_1FK7M");	// bereits oben definiert
    var sTable = "VT_1FK7M_M00028" + sDB_Suffix;
    var sTargetAttribute = "UI_WELLENMASZ_1FK7M";
    var sWhere = 	"MLFB05_06_1FK7M = '" + MLFB05_06_1FK7M + "' AND " +
                    "UI_WELLENAUSF_1FK7M = '" + UI_WELLENAUSF_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_WELLENENDE_SONDER_DIM_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    
    
    
    
    
    // ################################################################################################################
    // Bestimmung MLFB13		n.n. immer '1'
    // ################################################################################################################
    
    // ################################################################################################################
    
    
    
    
    // ################################################################################################################
    // Schutzart IP			PMD_ABJ176_001_000_1FK7M	
    // ################################################################################################################
    /*
    A: VT_1FK7M_M00170	O: M03/M39 einschränken
        O_M03_M39_1FK7M	HMK_KONFIG_ZIEL_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	PMD_ABJ176_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    B: VT_1FK7M_M00182	ZO MLFB16 <> Schutzart
        MLFB05_06_08_1FK7M	HMK_FARBAUSFUEHRUNG_1006091	PMD_ABJ176_001_000_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M

    C:VT_1FK7M_M00195	MLFB09 <> Schutzart
        MLFB09_1FK7M	PMD_ABJ176_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    
    MLFB16
    VT_1FK7M_M00019	ZO gültige MLFB16
        MLFB05_06_1FK7M	MLFB08_1FK7M	HMK_KONFIG_ZIEL_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00182	ZO MLFB16 <> Schutzart
        MLFB05_06_08_1FK7M	HMK_FARBAUSFUEHRUNG_1006091	PMD_ABJ176_001_000_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M

    */
    // Einschränkung Schutzart aus gültigen MLFB16
    var sTargetAttribute = "MLFB16_1FK7M";
	
	var sTable = "VT_1FK7M_M00019" + sDB_Suffix;
	var sWhere = 	"MLFB05_06_1FK7M = '" 		+ MLFB05_06_1FK7M 		+ "' AND " +
					"MLFB08_1FK7M = '" 			+ MLFB08_1FK7M 			+ "' AND " +
					"HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
					"HMK_VALUE_VALID_1FK7M = 'T';";
	
	var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
	
	if (sStatus == "Error"){
		strError = "DICT1_ERR_1FK7___PLVT_MLFB16_EINSCHR_NO_DB_RESULT";
		return strError;
	}
	// ------------------------------------------------------------------------------
	if (ECSI_CX_IsDriveTrain == 1)
	{
		var HMK_FARBAUSFUEHRUNG_1006091 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1006091");	// must be K24
		
		var sTable = "VT_1FK7M_M00182" + sDB_Suffix;
		var sWhere = 	"MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
						"HMK_FARBAUSFUEHRUNG_1006091 = '" + HMK_FARBAUSFUEHRUNG_1006091 + "' AND " +
						"HMK_VALUE_VALID_1FK7M = 'T';";
		
		var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
		if (sStatus == "Error"){
			strError = "DICT1_ERR_1FK7___PLVT_MLFB16_EINSCHR_NO_DB_RESULT";
			return strError;
		}
		
		// no IP67
		ECL_DeactivateValue("MLFB16_1FK7M", "2");
		ECL_DeactivateValue("MLFB16_1FK7M", "5");
	}
    
    // ----------------------------------------------------------------------------------------------------------------
    // Übernahme der Einschränkung aus MLFB16 auf Schutzart
    var addWhere = "MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND HMK_VALUE_VALID_1FK7M = 'T'";
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABJ176_001_000_1FK7M", "MLFB16_1FK7M", "VT_1FK7M_M00182" + sDB_Suffix, addWhere)
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // A: ----------------------------------------------------------------------------------------------------------------
    /* VT_1FK7M_M00170	O: M03/M39 einschränken
        O_M03_M39_1FK7M	HMK_KONFIG_ZIEL_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	PMD_ABJ176_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    var O_M03_M39_1FK7M = ECL_GetValue("O_M03_M39_1FK7M");	// 
    
    var sTable = "VT_1FK7M_M00170" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABJ176_001_000_1FK7M";
    var sWhere = 	"O_M03_M39_1FK7M = '" + O_M03_M39_1FK7M + "' AND " +
                    "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                    "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                    "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // B: ----------------------------------------------------------------------------------------
    /* VT_1FK7M_M00182	ZO MLFB16 <> Schutzart
        MLFB05_06_08_1FK7M	HMK_FARBAUSFUEHRUNG_1006091	PMD_ABJ176_001_000_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M
    */	
    var HMK_FARBAUSFUEHRUNG_1006091 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1006091");	// 
    
    var sTable = "VT_1FK7M_M00182" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABJ176_001_000_1FK7M";
    var sWhere = 	"MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                    "HMK_FARBAUSFUEHRUNG_1006091 = '" + HMK_FARBAUSFUEHRUNG_1006091 + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // C: -------------------------------------------------------------------------------------------------------------
    /* VT_1FK7M_M00195	MLFB09 <> Schutzart
        MLFB09_1FK7M	PMD_ABJ176_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    var sTable = "VT_1FK7M_M00195" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABJ176_001_000_1FK7M";
    var sWhere = 	"MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_SCHUTZART_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    

    // ################################################################################################################
    // Bestimme MLFB16
    // ################################################################################################################
    /* VT_1FK7M_M00182	ZO MLFB16 <> Schutzart
        MLFB05_06_08_1FK7M	HMK_FARBAUSFUEHRUNG_1006091	PMD_ABJ176_001_000_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    var HMK_FARBAUSFUEHRUNG_1006091 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1006091");
    var PMD_ABJ176_001_000_1FK7M = ECL_GetValue("PMD_ABJ176_001_000_1FK7M");
    
    var sTable = "VT_1FK7M_M00182" + sDB_Suffix;
    var sSQL = "SELECT MLFB16_1FK7M FROM "+sTable+" WHERE " +
                "MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                "HMK_FARBAUSFUEHRUNG_1006091 = '" + HMK_FARBAUSFUEHRUNG_1006091 + "' AND " +
                "PMD_ABJ176_001_000_1FK7M = '" + PMD_ABJ176_001_000_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_MLFB16");
    if (aResult.length > 0){
        
        var MLFB16_1FK7M = aResult[0].MLFB16_1FK7M;
        
        sMLFB = replaceAt(sMLFB, 15, MLFB16_1FK7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_BESTIMMUNG_MLFB16_NO_DB_RESULT";
        return strError;
    }
    //MLFB_RUMPF_01_11_1FK7M = sMLFB.substring(0, 11);
    // ################################################################################################################
    
    
    
    // ################################################################################################################
    // Drive-CLiQ-Schnittstelle			PMD_ABU209_001_000_1FK7M
    // ################################################################################################################
    /* Bestimmung über Gebersystem unten
    VT_1FK7M_M00054	UI: Geber definieren
        PMD_ABU278_001_000_1FK7M	PMD_ABU209_001_000_1FK7M	UI_GEBER_1FK7M	UI_GEBER_SMC_1FK7M	UI_GEBER_AUFLOESUNG_1FK7M	HMK_VALUE_VALID_1FK7M
    n.n. VT_1FK7M_M00055	Fremdumrichter<>DRIVE-CLiQ		keine Einschränkung für SI300/SI600

    MLFB14 Geber
    */
    // ################################################################################################################
    
    // ################################################################################################################
    // Geberausführung  UI_GEBER_1FK7M
    // ################################################################################################################
    /* Bestimmung über Gebersystem unten
    VT_1FK7M_M00054	UI: Geber definieren
        PMD_ABU278_001_000_1FK7M	PMD_ABU209_001_000_1FK7M	UI_GEBER_1FK7M	UI_GEBER_SMC_1FK7M	UI_GEBER_AUFLOESUNG_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    // ################################################################################################################
    
    // ################################################################################################################
    // Geberauflösung	UI_GEBER_AUFLOESUNG_1FK7M
    // ################################################################################################################
    /* Bestimmung über Gebersystem unten
    VT_1FK7M_M00054	UI: Geber definieren
        PMD_ABU278_001_000_1FK7M	PMD_ABU209_001_000_1FK7M	UI_GEBER_1FK7M	UI_GEBER_SMC_1FK7M	UI_GEBER_AUFLOESUNG_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    // ################################################################################################################
    
    // ################################################################################################################
    // Gebersystem			PMD_ABU278_001_000_1FK7M	
    // ################################################################################################################
    /*
    PMD_ABU278_001_000_1FK7M	Ausführung des Sensors
    PMD_ABU209_001_000_1FK7M	Drive-CLiQ
    UI_GEBER_1FK7M				Ausführung Geber Ohne, Absolutwert, inkremental
    UI_GEBER_SMC_1FK7M			Geberanbindung über Zusatzmodul (SMC) zulässig		wird nicht verwendet
    UI_GEBER_AUFLOESUNG_1FK7M	Auflösung
    
    Ablauf Logik:
    1. MLFB14 aus VT einschränken (Konfig-Ziel, Getriebe, MLFB)
    2. Gebersystem einschränken aus MLFB14
    3. mit gültigen Gebern aus VT54 DRIVE-CLiQ, UI_GEBER und UI_GEBER_AUFLOESUNG einschränken
    Geber selbst ist Ergebnis aus Auswahl von DRIVE-CLiQ, UI_GEBER und UI_GEBER_AUFLOESUNG 
    
    VT_1FK7M_M00054	UI: Geber definieren
        PMD_ABU278_001_000_1FK7M	PMD_ABU209_001_000_1FK7M	UI_GEBER_1FK7M	UI_GEBER_SMC_1FK7M	UI_GEBER_AUFLOESUNG_1FK7M	HMK_VALUE_VALID_1FK7M

    n.n. VT_1FK7M_M00071	ZO AH > Geber > Gewicht Geber
    
alt	VT_1FK7M_M00105	ZO MLFB14 <> Geber
        MLFB14_1FK7M	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
neu	VT_1FK7M_M00235	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
        
    MLFB14
    VT_1FK7M_M00157	ZO gültige Geber
        HMK_KONFIG_TYP_1FK7M	MLFB05_06_08_1FK7M	MLFB12_1FK7M	MLFB14_1FK7M	PMD_AAA717_001_000_1FK7M	HMK_PRODUKT_ALT_AKT_1FK7M	HMK_VALUE_VALID_1FK7M
    
    VT_1FK7M_M00144	ZO MLFB-Rumpf, MLFB12, Geber
        MLFB_RUMPF_01_11_1FK7M	MLFB12_1FK7M	MLFB14_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    
    VT_1FK7M_M00224	ZO Geber - Getriebe
        MLFB14_1FK7M	PMD_ABV410_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
    
    
    Geber 00022, 00023, 00024 nur mit N16
    Geber Z0004, Z0017, Z0018 mit und ohne N16
    
    */
    
    // MLFB14 einschränken
    var sTable = "VT_1FK7M_M00157" + sDB_Suffix;
    var sTargetAttribute = "MLFB14_1FK7M";
    var sWhere = 	"MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                    "HMK_KONFIG_TYP_1FK7M = 'konfig' AND " +
                    "HMK_PRODUKT_ALT_AKT_1FK7M = 'AKT' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_MLFB14_EINSCHR_NO_DB_RESULT";
        return strError;
    }
    
    // ----------------------------------------------------------------------------
    var sTable = "VT_1FK7M_M00144" + sDB_Suffix;
    var sTargetAttribute = "MLFB14_1FK7M";
    var sWhere = 	"MLFB_RUMPF_01_11_1FK7M = '" + MLFB_RUMPF_01_11_1FK7M + "' AND " +
                    "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_MLFB14_EINSCHR_NO_DB_RESULT";
        return strError;
    }
    
    // ----------------------------------------------------------------------------
    var PMD_ABV410_001_000_1FK7M = ECL_GetValue("PMD_ABV410_001_000_1FK7M");
    
    var sTable = "VT_1FK7M_M00224" + sDB_Suffix;
    var sTargetAttribute = "MLFB14_1FK7M";
    var sWhere = 	"PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_MLFB14_EINSCHR_NO_DB_RESULT";
        return strError;
    }
   
    // ----------------------------------------------------------------------------
    var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
    var bActiveN16 = ECL_ValueActive("O_N16_1006091", "N16");
/*	if (O_N16_1006091 == "N16" || !bActiveN16 ){
        var sTable = "VT_1FK7M_M00235" + sDB_Suffix;
        var sTargetAttribute = "MLFB14_1FK7M";
        var sWhere = 	"O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                        "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
            return strError;
        }
    }
*/	
    // A: ----------------------------------------------------------------------------------------
    // Übernahme der Einschränkung aus MLFB14
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABU278_001_000_1FK7M", "MLFB14_1FK7M", "VT_1FK7M_M00235"+ sDB_Suffix)
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    // (B) ----------------------------------------------------------------------------------------------------------------
    
    /*	Einschränkung aus Konfig-Ziel ( bereits über MLFB14-Einschränkung erledigt)
    VT_1FK7M_M00235	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    
    // ----------------------------------------------------------------------------------------------------------------
    // weitere Einschränkung Geber
    /*VT_1FK7M_M00235	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    // 
    //var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
    //var bActiveN16 = ECL_ValueActive("O_N16_1006091", "N16");
    if (O_N16_1006091 == "N16" || !bActiveN16 ){
        var sTable = "VT_1FK7M_M00235" + sDB_Suffix;
        var sTargetAttribute = "PMD_ABU278_001_000_1FK7M";
        var sWhere = 	"O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                        "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
            return strError;
        }
    }
    // ----------------------------------------------------------------------------------------------------------------
    
    var aValidValues_Geber = ECL_GetAllActiveAttributeValues("PMD_ABU278_001_000_1FK7M");
    if (aValidValues_Geber.length == 1){
        var sWhereGeber = "PMD_ABU278_001_000_1FK7M = '" + aValidValues_Geber[0] + "' AND ";
    }else if (aValidValues_Geber.length > 1){
        var sWhereGeber = "(PMD_ABU278_001_000_1FK7M = '" + aValidValues_Geber[0] + "'";
        for (var i = 1; i < aValidValues_Geber.length; i++){
            sWhereGeber = sWhereGeber + " OR PMD_ABU278_001_000_1FK7M = '" + aValidValues_Geber[i] + "'";
        }
        sWhereGeber = sWhereGeber + ") AND ";
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // DRIVE-CLiQ einscränken
    var sTable = "VT_1FK7M_M00054" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT PMD_ABU209_001_000_1FK7M FROM "+sTable+" WHERE " +
                sWhereGeber + 
                "HMK_VALUE_VALID_1FK7M = 'T';";
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_DRIVE_CLIQ");
    if (aResult.length > 0){
        var PMD_ABU209_001_000_1FK7M_oldValue = ECL_GetValue("PMD_ABU209_001_000_1FK7M");       //Wert sichern, da ECL_DeactivateAllAttributeValues verwirf
        ECL_DeactivateAllAttributeValues("PMD_ABU209_001_000_1FK7M");
        for (var j = 0; j<aResult.length;j++){
            ECL_ActivateValue("PMD_ABU209_001_000_1FK7M", aResult[j].PMD_ABU209_001_000_1FK7M);
 
        }
        ECL_SelectValue("PMD_ABU209_001_000_1FK7M",PMD_ABU209_001_000_1FK7M_oldValue);	
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    ExecSetStandardifValueEmpty("PMD_ABU209_001_000_1FK7M", "T");
    var PMD_ABU209_001_000_1FK7M = ECL_GetValue("PMD_ABU209_001_000_1FK7M");
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Geber-Ausführung einschränken
    var sTable = "VT_1FK7M_M00054" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT UI_GEBER_1FK7M FROM "+sTable+" WHERE " +
                sWhereGeber + 
                "PMD_ABU209_001_000_1FK7M = '"+PMD_ABU209_001_000_1FK7M+"' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
                
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_UI_GEBER");
    if (aResult.length > 0){
        var UI_GEBER_1FK7M_OldValue = ECL_GetValue("UI_GEBER_1FK7M");           //Wert sichern, da ECL_DeactivateAllAttributeValues verwirft
        ECL_DeactivateAllAttributeValues("UI_GEBER_1FK7M");
        for (var j = 0; j<aResult.length;j++){
            ECL_ActivateValue("UI_GEBER_1FK7M", aResult[j].UI_GEBER_1FK7M);
        }
        ECL_SelectValue("UI_GEBER_1FK7M",UI_GEBER_1FK7M_OldValue);	
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    ExecSetStandardifValueEmpty("UI_GEBER_1FK7M", "");
    var UI_GEBER_1FK7M = ECL_GetValue("UI_GEBER_1FK7M");
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Geber-Auflösung einschränken
    var sTable = "VT_1FK7M_M00054" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT UI_GEBER_AUFLOESUNG_1FK7M FROM "+sTable+" WHERE " +
                sWhereGeber + 
                "PMD_ABU209_001_000_1FK7M = '"+PMD_ABU209_001_000_1FK7M+"' AND " +
                "UI_GEBER_1FK7M = '"+UI_GEBER_1FK7M+"' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_GEBER_AUFLOESUNG");
    if (aResult.length > 0){
        var UI_GEBER_AUFLOESUNG_1FK7M_OldValue = ECL_GetValue("UI_GEBER_AUFLOESUNG_1FK7M");           //Wert sichern, da ECL_DeactivateAllAttributeValues verwirft
        ECL_DeactivateAllAttributeValues("UI_GEBER_AUFLOESUNG_1FK7M");
        for (var j = 0; j<aResult.length;j++){
            ECL_ActivateValue("UI_GEBER_AUFLOESUNG_1FK7M", aResult[j].UI_GEBER_AUFLOESUNG_1FK7M);
        }
        ECL_SelectValue("UI_GEBER_AUFLOESUNG_1FK7M",UI_GEBER_AUFLOESUNG_1FK7M_OldValue);	
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    ExecSetStandardifValueEmpty("UI_GEBER_AUFLOESUNG_1FK7M", "00009");
    var UI_GEBER_AUFLOESUNG_1FK7M = ECL_GetValue("UI_GEBER_AUFLOESUNG_1FK7M");
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // Bestimme Geber
/*	var sTable = "VT_1FK7M_M00054" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT PMD_ABU278_001_000_1FK7M FROM "+sTable+" WHERE " +
                "PMD_ABU209_001_000_1FK7M = '"+PMD_ABU209_001_000_1FK7M+"' AND " +
                "UI_GEBER_1FK7M = '"+UI_GEBER_1FK7M+"' AND " +
                "UI_GEBER_AUFLOESUNG_1FK7M = '"+UI_GEBER_AUFLOESUNG_1FK7M+"' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_GEBER");
    if (aResult.length > 0){
        for (var i=0; i<aResult.length; i++){
            var PMD_ABU278_001_000_1FK7M = aResult[i].PMD_ABU278_001_000_1FK7M;
            
            if (aValidValues_Geber.indexOf(PMD_ABU278_001_000_1FK7M) > -1){
                ECL_SetValue("PMD_ABU278_001_000_1FK7M", PMD_ABU278_001_000_1FK7M);
            }
        }
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    if (aResult.length > 1){
        var sstop;
    }
*/	
    var PMD_ABU209_001_000_1FK7M = ECL_GetValue("PMD_ABU209_001_000_1FK7M");
    var UI_GEBER_1FK7M = ECL_GetValue("UI_GEBER_1FK7M");
    var UI_GEBER_AUFLOESUNG_1FK7M = ECL_GetValue("UI_GEBER_AUFLOESUNG_1FK7M");
    
    var sTable = "VT_1FK7M_M00054" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABU278_001_000_1FK7M";
    var sWhere = 	"PMD_ABU209_001_000_1FK7M = '"+PMD_ABU209_001_000_1FK7M+"' AND " +
                    "UI_GEBER_1FK7M = '"+UI_GEBER_1FK7M+"' AND " +
                    "UI_GEBER_AUFLOESUNG_1FK7M = '"+UI_GEBER_AUFLOESUNG_1FK7M+"' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    //var PMD_ABU278_001_000_1FK7M = ECL_GetValue("PMD_ABU278_001_000_1FK7M");
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_GEBERSYSTEM_NO_DB_RESULT";
        return strError;
    }
    //ExecSetStandardifValueEmpty("PMD_ABU278_001_000_1FK7M", "");
    // ################################################################################################################
    
    
    // N16 aktualisieren
    /* VT_1FK7M_M00235	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */

    var PMD_ABU278_001_000_1FK7M = ECL_GetValue("PMD_ABU278_001_000_1FK7M");
    
    var sTable = "VT_1FK7M_M00235" + sDB_Suffix;
    var sTargetAttribute = "O_N16_1006091";
    var sWhere = 	"PMD_ABU278_001_000_1FK7M = '" + PMD_ABU278_001_000_1FK7M + "' AND " +
                    //"MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                    "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_CHEM_BEST_NO_DB_RESULT";
        return strError;
    }
    
    
    // ################################################################################################################
    // Bestimmung MLFB14
    // ################################################################################################################
    /*
alt	VT_1FK7M_M00105	ZO MLFB14 <> Geber
        MLFB14_1FK7M	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
neu	VT_1FK7M_M00235	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00135	ZO R72	(Sondergeber)
        O_R72_1FK7M	MLFB05_06_08_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	MLFB15_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00144	ZO MLFB-Rumpf, MLFB12, Geber
    VT_1FK7M_M00157	ZO gültige Geber
    VT_1FK7M_M00166	ZO N16
    VT_1FK7M_M00168	ZO R06
    VT_1FK7M_M00169	CAD N16
    VT_1FK7M_M00170	O: M03/M39 einschränken
    VT_1FK7M_M00213	Tech. Daten Umrichter Geber W
    VT_1FK7M_M00224	ZO Geber - Getriebe

    */
    var PMD_ABU278_001_000_1FK7M = ECL_GetValue("PMD_ABU278_001_000_1FK7M");
    var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
    
    var sTable = "VT_1FK7M_M00235" + sDB_Suffix;
    var sSQL = "SELECT MLFB14_1FK7M FROM "+sTable+" WHERE " +
                "PMD_ABU278_001_000_1FK7M = '" + PMD_ABU278_001_000_1FK7M + "' AND " +
                "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                "O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_MLFB");
    if (aResult.length > 0){
        
        MLFB14_1FK7M = aResult[0].MLFB14_1FK7M;
        
        sMLFB = replaceAt(sMLFB, 13, MLFB14_1FK7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_BESTIMMUNG_MLFB14_NO_DB_RESULT";
        return strError;
    }
    //MLFB_RUMPF_01_11_1FK7M = sMLFB.substring(0, 11);
    // ################################################################################################################
    // Aktualisierung MLFB12
    // ################################################################################################################
    var sTable = "VT_1FK7M_M00157" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT MLFB12_1FK7M FROM "+sTable+" WHERE " +
                "HMK_KONFIG_TYP_1FK7M = '" + HMK_KONFIG_TYP_1FK7M 	+ "' AND " +
                "MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M 	+ "' AND " +
                "MLFB14_1FK7M = '" 		 + MLFB14_1FK7M 		+ "' AND " +
                "HMK_PRODUKT_ALT_AKT_1FK7M = 'AKT' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_BEST_MLFB12");
    if (aResult.length > 0)
    {
        var MLFB12_1FK7M = aResult[0].MLFB12_1FK7M;
        
        sMLFB = replaceAt(sMLFB, 11, MLFB12_1FK7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_BESTIMMUNG_MLFB12_NO_DB_RESULT";
        return strError;
    }
    //MLFB_RUMPF_01_11_1FK7M = sMLFB.substring(0, 11);
    // ################################################################################################################

    
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTI
    // OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTIONEN OPTI
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    // ################################################################################################################
    // Ausführung (Farbe)			HMK_FARBAUSFUEHRUNG_1006091
    // ################################################################################################################
    /*
    VT_1FK7M_M00182	ZO MLFB16 <> Schutzart
        MLFB05_06_08_1FK7M	HMK_FARBAUSFUEHRUNG_1006091	PMD_ABJ176_001_000_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00183	O: N16
        HMK_FARBAUSFUEHRUNG_1006091	O_N16_1006091	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00227	Farbausführung <> Konfig.-ziel
        HMK_FARBAUSFUEHRUNG_1006091	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

    */
    var sTargetAttribute = "HMK_FARBAUSFUEHRUNG_1006091";
    
    if (ECSI_CX_IsDriveTrain == 1){
        
        var aValidValues = ['K24'];
        
        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);
        
        if (sStatus == "Error"){
            // Fehler
            strError = "DICT1_ERR_1FK7___PLVT_FARBAUSFUEHRUNG_NO_DB_RESULT";
            return strError;
        }
    }else{
        
        var PMD_ABJ176_001_000_1FK7M = ECL_GetValue("PMD_ABJ176_001_000_1FK7M");
        
        // sWhere MLFB16_1FK7M 
        var aValidMLFB16 = ECL_GetAllActiveAttributeValues("MLFB16_1FK7M");
        
        if (aValidMLFB16.length == 1){
            var sWhereMLFB16 = "MLFB16_1FK7M = '" + aValidMLFB16[0] + "' AND ";
        }else if (aValidMLFB16.length > 1){
            var sWhereMLFB16 = "(MLFB16_1FK7M = '" + aValidMLFB16[0] + "'";
            for (var i = 1; i < aValidMLFB16.length; i++){
                sWhereMLFB16 += " OR MLFB16_1FK7M = '" + aValidMLFB16[i] + "'";
            }
            sWhereMLFB16 += ") AND ";
        }else{
            strError = "DICT1_ERR_1FK7___PLVT_FARBAUSFUEHRUNG_NO_DB_RESULT";
            return strError;
        }
        
        
        var sTable = "VT_1FK7M_M00182" + sDB_Suffix;
        
        var sWhere = 	"MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                        "PMD_ABJ176_001_000_1FK7M = '" + PMD_ABJ176_001_000_1FK7M + "' AND " +
                        sWhereMLFB16 + 	//"MLFB16_1FK7M = '" + MLFB16_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_FARBAUSFUEHRUNG_NO_DB_RESULT";
            return strError;
        }
        // B: ---------------------------------------------------------------------------------------
        var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
        
        var sTable = "VT_1FK7M_M00183" + sDB_Suffix;
        var sWhere = 	"O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_FARBAUSFUEHRUNG_NO_DB_RESULT";
            return strError;
        }
        // C: ---------------------------------------------------------------------------------------
        var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
        
        var sTable = "VT_1FK7M_M00227" + sDB_Suffix;
        var sWhere = 	"HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_FARBAUSFUEHRUNG_NO_DB_RESULT";
            return strError;
        }
    }
    // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //Bestimme MLFB16
    var HMK_FARBAUSFUEHRUNG_1006091 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1006091");
    var PMD_ABJ176_001_000_1FK7M = ECL_GetValue("PMD_ABJ176_001_000_1FK7M");
    
    /*var sTable = "VT_1FK7M_M00182" + sDB_Suffix;
    var sTargetAttribute = "MLFB16_1FK7M";
    var sWhere = 	"MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                    "PMD_ABJ176_001_000_1FK7M = '" + PMD_ABJ176_001_000_1FK7M + "' AND " +
                    "HMK_FARBAUSFUEHRUNG_1006091 = '" + HMK_FARBAUSFUEHRUNG_1006091 + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_MLFB16_EINSCHR_NO_DB_RESULT";
        return strError;
    }
    */
    var sTable = "VT_1FK7M_M00182" + sDB_Suffix;
    var sSQL = "SELECT MLFB16_1FK7M FROM "+sTable+" WHERE " +
                "MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                "PMD_ABJ176_001_000_1FK7M = '" + PMD_ABJ176_001_000_1FK7M + "' AND " +
                "HMK_FARBAUSFUEHRUNG_1006091 = '" + HMK_FARBAUSFUEHRUNG_1006091 + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL, sTable +"_MLFB16");
    if (aResult.length > 0){
        
        var MLFB16_1FK7M = aResult[0].MLFB16_1FK7M;
        
        sMLFB = replaceAt(sMLFB, 15, MLFB16_1FK7M);
        ECL_SetValue("ECSI_MLFB", sMLFB);
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_BESTIMMUNG_MLFB16_NO_DB_RESULT";
        return strError;
    }
    //MLFB_RUMPF_01_11_1FK7M = sMLFB.substring(0, 11);
    // ################################################################################################################
    
    // ################################################################################################################
    // Farbe		O_X01__X27_1FK7M	
    // ################################################################################################################
    /*
    
    STD
    OHNE
    X01...Xnn
    */
    var HMK_FARBAUSFUEHRUNG_1006091 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1006091");
    if (HMK_FARBAUSFUEHRUNG_1006091 == "00004" || HMK_FARBAUSFUEHRUNG_1006091 == "K24"){
        ECL_DeactivateAllAttributeValues("O_X01__X27_1FK7M");
        ECL_ActivateValue("O_X01__X27_1FK7M", "OHNE");
        ECL_SetValue("O_X01__X27_1FK7M", "OHNE");
    }else{
        ECL_ActivateAllAttributeValues("O_X01__X27_1FK7M");
        ECL_DeactivateValue("O_X01__X27_1FK7M", "OHNE");
    }
    ExecSetStandardifValueEmpty("O_X01__X27_1FK7M", "STD");
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Ex-Schutz
    // ################################################################################################################
    /*
    O_M03_M39_1FK7M	Ausführung für explosionsgefährdete Bereiche

    M03		Zone 2 nach EN5...IEC 60079-15
    M39		Zone 22 nach EN.../IEC 61241-1
    OHNE	Ohne
    
    VT_1FK7M_M00155	O: Q20 <-> M03, M39
        O_Q20_1FK7M	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00165	O: M03/M39 red. DZ <> Rumpf
        MLFB_RUMPF_01_11_1FK7M	O_M03_M39_1FK7M	T_MAX_DREHZ_REDUZIER_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00170	O: M03/M39 einschränken
        O_M03_M39_1FK7M	HMK_KONFIG_ZIEL_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	PMD_ABJ176_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00220	O: L13, N16, M* einschränken
        O_L13_1FK7M	O_N16_1006091	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M
    
    VT_1FK7M_M00253	ZO N24 <> M03/M39
        UI_HALTEBREMSE_1FK7M	O_M03_M39_1FK7M

    */
    var sTargetAttribute = "O_M03_M39_1FK7M";
    
    // Edit 02.2023 no ATEX options 48952 - Remove 1FK7 ATEX options until the related feature is done
    var aValidValues = ['OHNE'];
    
    var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1FK7___PLVT_EX_SCHUTZ_NO_DB_RESULT";
        return strError;
    }
    /*
    // End Edit 02.2023 no ATEX options 48952 - Remove 1FK7 ATEX options until the related feature is done
        
        // nicht erlaubt mit DriveTrain
        if (ECSI_CX_IsDriveTrain == 1){
            
            var aValidValues = ['OHNE'];
            
            var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);
            
            if (sStatus == "Error"){
                // Fehler
                strError = "DICT1_ERR_1FK7___PLVT_EX_SCHUTZ_NO_DB_RESULT";
                return strError;
            }
        }else{
            // A: ---------------------------------------------------------------------------------------
            var O_Q20_1FK7M = ECL_GetValue("O_Q20_1FK7M");
            
            var sTable = "VT_1FK7M_M00155" + sDB_Suffix;
            var sWhere = 	"O_Q20_1FK7M = '" + O_Q20_1FK7M + "' AND " +
                            "HMK_VALUE_VALID_1FK7M = 'T';";
            
            var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
            
            if (sStatus == "Error"){
                strError = "DICT1_ERR_1FK7___PLVT_EX_SCHUTZ_NO_DB_RESULT";
                return strError;
            }
            
            /* EDIT 2021.06 TFS 5601046	1FK7 - hide ex Option M03/M39
            ==> in newer DTK-databases it is avaiable
            * /
            // B: ---------------------------------------------------------------------------------------
            var sTable = "VT_1FK7M_M00165" + sDB_Suffix;
            var sWhere = 	"MLFB_RUMPF_01_11_1FK7M = '" + MLFB_RUMPF_01_11_1FK7M + "' AND " +
                            "HMK_VALUE_VALID_1FK7M = 'T';";
            
            var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
            
            if (sStatus == "Error"){
                strError = "DICT1_ERR_1FK7___PLVT_EX_SCHUTZ_NO_DB_RESULT";
                return strError;
            }
            // C: ---------------------------------------------------------------------------------------
            var PMD_ABJ176_001_000_1FK7M = ECL_GetValue("PMD_ABJ176_001_000_1FK7M");
            
            var sTable = "VT_1FK7M_M00170" + sDB_Suffix;
            var sWhere = 	"HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                            "PMD_ABJ176_001_000_1FK7M = '" + PMD_ABJ176_001_000_1FK7M + "' AND " +
                            "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                            "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                            "HMK_VALUE_VALID_1FK7M = 'T';";
            
            var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
            
            if (sStatus == "Error"){
                strError = "DICT1_ERR_1FK7___PLVT_EX_SCHUTZ_NO_DB_RESULT";
                return strError;
            }
            // D: ---------------------------------------------------------------------------------------
            /* VT_1FK7M_M00220	O: L13, N16, M* einschränken
                O_L13_1FK7M	O_N16_1006091	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M
            * /
            //var O_L13_1FK7M = ECL_GetValue("O_L13_1FK7M");
            var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
            
            var sTable = "VT_1FK7M_M00220" + sDB_Suffix;
            //var sWhere = 	"O_L13_1FK7M = '" + O_L13_1FK7M + "' AND " +
            var sWhere = 	"O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                            "HMK_VALUE_VALID_1FK7M = 'T';";
            
            var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
            
            if (sStatus == "Error"){
                strError = "DICT1_ERR_1FK7___PLVT_EX_SCHUTZ_NO_DB_RESULT";
                return strError;
            }
            // D: ---------------------------------------------------------------------------------------
            /* VT_1FK7M_M00253	ZO N24 <> M03/M39
                UI_HALTEBREMSE_1FK7M	O_M03_M39_1FK7M
            * /
            var sTable = "VT_1FK7M_M00253" + sDB_Suffix;
            var sWhere = 	"UI_HALTEBREMSE_1FK7M = '" + UI_HALTEBREMSE_1FK7M + "';";
            
            var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
            
            if (sStatus == "Error"){
                strError = "DICT1_ERR_1FK7___PLVT_EX_SCHUTZ_NO_DB_RESULT";
                return strError;
            }
        }
    */
    // ################################################################################################################
    
    
    
    // ################################################################################################################
    // O_B02_1FK7M	Werksprüfzeugnis
    // ################################################################################################################
    /*
    kein Vorkommen in DTK-VTs
    */
    if (ECSI_CX_IsDriveTrain == 1){
        ECL_DeactivateValue("O_B02_1FK7M", "B02");
        ECL_SelectValue("O_B02_1FK7M", "F");
    }
    
    // ################################################################################################################
    
    
    // ################################################################################################################
    // O_R06_1FK7M	Referenzmarke auf Motorwelle
    // ################################################################################################################
    /*
    VT_1FK7M_M00168	ZO R06
        O_R06_1FK7M	MLFB08_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00193	O: R06 <-> Motor mit / ohne Getriebe
        O_R06_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    var sTable = "VT_1FK7M_M00168" + sDB_Suffix;
    var sTargetAttribute = "O_R06_1FK7M";
    var sWhere = 	"MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                    "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                    "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_REF_MARKE_WELLE_NO_DB_RESULT";
        return strError;
    }
    // B: ---------------------------------------------------------------------------------------
    var sTable = "VT_1FK7M_M00193" + sDB_Suffix;
    var sTargetAttribute = "O_R06_1FK7M";
    var sWhere = 	"HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_REF_MARKE_WELLE_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------------------------------------------
    if (ECSI_CX_IsDriveTrain == 1){
        
        var aValidValues = ['F'];
        
        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);
        
        if (sStatus == "Error"){
            // Fehler
            strError = "DICT1_ERR_1FK7___PLVT_REF_MARKE_WELLE_NO_DB_RESULT";
            return strError;
        }
    }	
    // ################################################################################################################
    
    
    // ################################################################################################################
   	// O_R72_1FK7M	Sondergeber 			R72 nicht verfügbar für Konfiguration
    // ################################################################################################################
    /*
    VT_1FK7M_M00135	ZO R72	(Sondergeber)
        O_R72_1FK7M	MLFB05_06_08_1FK7M	MLFB09_1FK7M	MLFB14_1FK7M	MLFB15_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M
    * /
    var sTable = "VT_1FK7M_M00135" + sDB_Suffix;
    var sTargetAttribute = "O_R72_1FK7M";
    var sWhere = 	"MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
                    "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                    "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                    "MLFB15_1FK7M = '" + MLFB15_1FK7M + "' AND " +
                    "MLFB16_1FK7M = '" + MLFB16_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_SONDERGEBER_NO_DB_RESULT";
        return strError;
    }
    */
    // ################################################################################################################
    
    // ################################################################################################################
    // PMD_ABV483_001_000_1FK7M		Metall Leistungsschild am Motor 		nicht nötig, T/F vs Q31/F
    // ################################################################################################################
    // Bestimme_Metallschild	// O_Q30_Q31_1FK7M		Metall-Leistungsschild				Q31/F
    // ################################################################################################################
    /*
    VT_1FK7M_M00036	O: Metall-Leistungsschild def.
        PMD_ABV483_001_000_1FK7M	MLFB08_1FK7M	O_Q30_Q31_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

    */
    var PMD_ABV517_001_000_1FK7M = ECL_GetValue("PMD_ABV517_001_000_1FK7M");
    
    var sTable = "VT_1FK7M_M00036" + sDB_Suffix;
    var sTargetAttribute = "O_Q30_Q31_1FK7M";
    var sWhere = 	"MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                    "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_METALLSCHILD_NO_DB_RESULT";
        return strError;
    }
    // ------------------------------------------------------------------------------------------------------
    if (ECSI_CX_IsDriveTrain == 1){
        
        var aValidValues = ['F'];
        
        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);
        
        if (sStatus == "Error"){
            // Fehler
            strError = "DICT1_ERR_1FK7___PLVT_METALLSCHILD_NO_DB_RESULT";
            return strError;
        }
    }	
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Ausführung für erhöhte chemische Beständigkeit		O_N16_1006091		N16
    // ################################################################################################################
    /*
    VT_1FK7M_M00149	O: N16 <-> Motor mit / ohne Getriebe
        O_N16_1006091	PMD_ABV517_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00166	ZO N16
        O_N16_1006091	MLFB08_1FK7M	MLFB09_1FK7M	MLFB13_1FK7M	MLFB14_1FK7M	HMK_VALUE_VALID_1FK7M

    n.n. VT_1FK7M_M00169	CAD N16
    
    VT_1FK7M_M00183	O: N16
        HMK_FARBAUSFUEHRUNG_1006091	O_N16_1006091	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00220	O: L13, N16, M* einschränken
        O_L13_1FK7M	O_N16_1006091	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00225	ZO N16 Q20
        O_Q20_1FK7M	O_N16_1006091	HMK_VALUE_VALID_1FK7M

neu	VT_1FK7M_M00235	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

    */
    // 0: ----------------------------------------------------------------------------------------
    /* VT_1FK7M_M00235	ZO MLFB14 <> Geber
        neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */
    var sTargetAttribute = "O_N16_1006091";

    if (ECSI_CX_IsDriveTrain == 1){
        
        var aValidValues = ['F'];
        
        var sStatus = SetAttributeLogicFromCode(sTargetAttribute, aValidValues);
        if (sStatus == "Error"){
            // Fehler
            strError = "DICT1_ERR_1FK7___PLVT_CHEM_BEST_NO_DB_RESULT";
            return strError;
        }
    }else{
        
        /*var PMD_ABU278_001_000_1FK7M = ECL_GetValue("PMD_ABU278_001_000_1FK7M");
        
        var sTable = "VT_1FK7M_M00235" + sDB_Suffix;
        var sWhere = 	"PMD_ABU278_001_000_1FK7M = '" + PMD_ABU278_001_000_1FK7M + "' AND " +
                        //"MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                        "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        //	var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_CHEM_BEST_NO_DB_RESULT";
            return strError;
        }
        */
        // A: ----------------------------------------------------------------------------------------
        /* VT_1FK7M_M00149	O: N16 <-> Motor mit / ohne Getriebe
            O_N16_1006091	PMD_ABV517_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
        */
        var PMD_ABV517_001_000_1FK7M = ECL_GetValue("PMD_ABV517_001_000_1FK7M");
        
        var sTable = "VT_1FK7M_M00149" + sDB_Suffix;
        var sWhere = 	"PMD_ABV517_001_000_1FK7M = '" + PMD_ABV517_001_000_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
        //	var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_CHEM_BEST_NO_DB_RESULT";
            return strError;
        }
        // B: ---------------------------------------------------------------------------------------
        /* VT_1FK7M_M00166	ZO N16
            O_N16_1006091	MLFB08_1FK7M	MLFB09_1FK7M	MLFB13_1FK7M	MLFB14_1FK7M	HMK_VALUE_VALID_1FK7M
        */
        var sTable = "VT_1FK7M_M00166" + sDB_Suffix;
        var sWhere = 	"MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                        "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                        "MLFB13_1FK7M = '" + MLFB13_1FK7M + "' AND " +
                        "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_CHEM_BEST_NO_DB_RESULT";
            return strError;
        }
        // C: ---------------------------------------------------------------------------------------
        /* VT_1FK7M_M00183	O: N16
            HMK_FARBAUSFUEHRUNG_1006091	O_N16_1006091	HMK_VALUE_VALID_1FK7M
        */
        var HMK_FARBAUSFUEHRUNG_1006091 = ECL_GetValue("HMK_FARBAUSFUEHRUNG_1006091");
        
        var sTable = "VT_1FK7M_M00183" + sDB_Suffix;
        var sWhere = 	"HMK_FARBAUSFUEHRUNG_1006091 = '" + HMK_FARBAUSFUEHRUNG_1006091 + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_CHEM_BEST_NO_DB_RESULT";
            return strError;
        }
        // D: ---------------------------------------------------------------------------------------
        /* VT_1FK7M_M00220	O: L13, N16, M* einschränken
            O_L13_1FK7M	O_N16_1006091	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M
        */
        //var O_L13_1FK7M = ECL_GetValue("O_L13_1FK7M");
        var O_M03_M39_1FK7M = ECL_GetValue("O_M03_M39_1FK7M");
        
        var sTable = "VT_1FK7M_M00220" + sDB_Suffix;
        //var sWhere = 	"O_L13_1FK7M = '" + O_L13_1FK7M + "' AND " +			// todo check ob rückwirkende Logik?
        var sWhere = 	"O_M03_M39_1FK7M = '" + O_M03_M39_1FK7M + "' AND " +
                        "HMK_VALUE_VALID_1FK7M = 'T';";
        
        var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
        
        if (sStatus == "Error"){
            strError = "DICT1_ERR_1FK7___PLVT_CHEM_BEST_NO_DB_RESULT";
            return strError;
        }
        // E: ---------------------------------------------------------------------------------------
        /* VT_1FK7M_M00225	ZO N16 Q20								todo check ob rückwirkende Logik?
            O_Q20_1FK7M	O_N16_1006091	HMK_VALUE_VALID_1FK7M
        */
        //var O_Q20_1FK7M = ECL_GetValue("O_Q20_1FK7M");
        
        /*	var sTable = "VT_1FK7M_M00225" + sDB_Suffix;
            var sWhere = 	"O_Q20_1FK7M = '" + O_Q20_1FK7M + "' AND " +
                            "HMK_VALUE_VALID_1FK7M = 'T';";
            
            var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
            
            if (sStatus == "Error"){
                strError = "DICT1_ERR_1FK7___PLVT_CHEM_BEST_NO_DB_RESULT";
                return strError;
            }
        */	
    }
    // ################################################################################################################
    
    
    if ( !(ECL_ValueActive("O_N16_1006091", "F"))) {
        ECL_ActivateValue("O_N16_1006091", "F");
    }
    
    
    // ################################################################################################################
    // Kundenangabe auf dem Leistungsschild 		O_Y84_1FK7M		Y84
    // ################################################################################################################
    /*
    H_O_Y84_1FK7M	Kundenangabe auf dem Leistungsschild (Textfeld)
    */
    
    if (ECL_ValueEnabled("O_Y84_1FK7M", "Y84")){
        ECL_ActivateAttribute("H_O_Y84_1FK7M");
    }else{
        ECL_DeactivateAttribute("H_O_Y84_1FK7M");
    }
    
    if (strchangedAttribute == "H_O_Y84_1FK7M"){
        var sValueNorm = normalizeOE_Attribute("H_O_Y84_1FK7M");
        if (sValueNorm == ""){
            ECL_SelectValue("O_Y84_1FK7M", "F");
        }else{
            ECL_SelectValue("O_Y84_1FK7M", "Y84");
        }
    }
    // ################################################################################################################
    
    
    
    // ################################################################################################################
    // Äusserer Erdungsanschluss		O_L13_1FK7M
    // ################################################################################################################
    /*
    VT_1FK7M_M00220	O: L13, N16, M* einschränken
        O_L13_1FK7M	O_N16_1006091	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00221	CAD L13 	n.n.
    
    VT_1FK7M_M00226	ZO L13
        O_L13_1FK7M	MLFB08_1FK7M	MLFB09_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    */

    var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
    var O_M03_M39_1FK7M = ECL_GetValue("O_M03_M39_1FK7M");
    
    var sTable = "VT_1FK7M_M00220" + sDB_Suffix;
    var sTargetAttribute = "O_L13_1FK7M";
    var sWhere = 	"O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                    "O_M03_M39_1FK7M = '" + O_M03_M39_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_ERDUNG_NO_DB_RESULT";
        return strError;
    }
    // B: ---------------------------------------------------------------------------------------
    var sTable = "VT_1FK7M_M00226" + sDB_Suffix;
    var sTargetAttribute = "O_L13_1FK7M";
    var sWhere = 	"MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                    "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                    "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_ERDUNG_NO_DB_RESULT";
        return strError;
    }
	// ################################################################################################################
    		
    // ################################################################################################################
    // O_Q20_1FK7M	Anschluss zum Druckausgleich
    // ################################################################################################################
    /*
    VT_1FK7M_M00155	O: Q20 <-> M03, M39
        O_Q20_1FK7M	O_M03_M39_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00266	ZO Q20
		O_Q20_1FK7M	MLFB08_1FK7M	MLFB09_1FK7M	MLFB11_1FK7M	MLFB12_1FK7M	MLFB13_1FK7M	MLFB14_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00225	ZO N16 Q20
        O_Q20_1FK7M	O_N16_1006091	HMK_VALUE_VALID_1FK7M
    */
    // A: ---------------------------------------------------------------------------------------
    var O_M03_M39_1FK7M = ECL_GetValue("O_M03_M39_1FK7M");
    
    var sTable = "VT_1FK7M_M00155" + sDB_Suffix;
    var sTargetAttribute = "O_Q20_1FK7M";
    var sWhere = 	"O_M03_M39_1FK7M = '" + O_M03_M39_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_DRUCKAUSGLEICH_NO_DB_RESULT";
        return strError;
    }
    // B: ---------------------------------------------------------------------------------------
    var sTable = "VT_1FK7M_M00266" + sDB_Suffix;
    var sTargetAttribute = "O_Q20_1FK7M";
    var sWhere = 	"MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
                    "MLFB09_1FK7M = '" + MLFB09_1FK7M + "' AND " +
                    "MLFB11_1FK7M = '" + MLFB11_1FK7M + "' AND " +
                    "MLFB12_1FK7M = '" + MLFB12_1FK7M + "' AND " +
                    "MLFB13_1FK7M = '" + MLFB13_1FK7M + "' AND " +
                    "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
                    "MLFB16_1FK7M = '" + MLFB16_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_DRUCKAUSGLEICH_NO_DB_RESULT";
        return strError;
    }
    // C: ---------------------------------------------------------------------------------------
    var O_N16_1006091 = ECL_GetValue("O_N16_1006091");
    
    var sTable = "VT_1FK7M_M00225" + sDB_Suffix;
    var sTargetAttribute = "O_Q20_1FK7M";
    var sWhere = 	"O_N16_1006091 = '" + O_N16_1006091 + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_DRUCKAUSGLEICH_NO_DB_RESULT";
        return strError;
    }
    
	// ################################################################################################################
    
    
    
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE
    // GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE GETRIEBE
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    /*
    Getriebebezeichnung (PMD_ABV410) führt zu Art des Getriebes (PMD_ABV517) und dies zu HMK_KONFIG_ZIEL_1FK7M
    
    
    
    
    PMD_ABV410_001_000_1FK7M	Bezeichnung des Getriebes
    HMK_UEBERSETZ_STUFE_1FK7M	Übersetzung + Stufigkeit
    PMD_ABV414_001_000_1FK7M	Wellenende
    HMK_OPT_GETRIEBE_1FK7M		Hilfsmerkmal Optionen Getriebe	==> KAG
    

    HMK_ABV413_GETRIEBE_1FK7M	Übersetzung				-->	VT_1FK7M_M00114	ZO ABV413

    PMD_ABV517_001_000_1FK7M	Art des Getriebes
        VT_1FK7M_M00076	Zuordnung_Getriebebezeichnung_Getriebe	nötig
        VT_1FK7M_M00081	Bauform_Einbaulage_Stöber_Getriebe
        VT_1FK7M_M00082	Bauart_Wellenende_Stöber_Getriebe
        VT_1FK7M_M00116	Getriebe-Konfigziel						nötig
        VT_1FK7M_M00149	O: N16 <-> Motor mit / ohne Getriebe
    
    
    HMK_KONFIG_ZIEL_1FK7M	PMD_ABV517_001_000_1FK7M
    SERVO                   00009
    
    
    Bestimmung des Getriebes im Parser. Feste Vorgabe durch SIZER / KAG in BaseType
	
    */
    
    // ------------------------------------------------------------------------------------------------------------------------------
    // Wenn alternatives Wellenende, keine Getriebewahl zulassen. Einschränkung Konfig-Ziel erfolgt in Abhängigkeit vom Wellenende
    /* 	1. 	Getriebeart PMD_ABV517_001_000_1FK7M über VT116 mit noch gültigen Konfigzielen einschränken
        2.	Getriebebezeichnung PMD_ABV410_001_000_1FK7M aus noch gültigen Getriebearten einschränken
    
    * /
    // ------------------------------------------------------------------------------------------------------------------------------
	var aValidValues_KonfigZiel = ECL_GetAllActiveAttributeValues("HMK_KONFIG_ZIEL_1FK7M");
    var aValidValues_Getriebeart = ECL_GetAllActiveAttributeValues("PMD_ABV517_001_000_1FK7M");
    
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABV517_001_000_1FK7M", "HMK_KONFIG_ZIEL_1FK7M", "VT_1FK7M_M00116" + sDB_Suffix);
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_KONFIG_ZIEL_NO_DB_RESULT";
        return strError;
    }
    var aValidValues_Getriebeart = ECL_GetAllActiveAttributeValues("PMD_ABV517_001_000_1FK7M");
    ExecSetStandardifValueEmpty("PMD_ABV517_001_000_1FK7M", "");
    // ------------------------------------------------------------------------------------------------------------------------------
    var aValidValues_GetriebeBez = ECL_GetAllActiveAttributeValues("PMD_ABV410_001_000_1FK7M");
    
    var sStatus = SetAttributeLogicFromMLFB("PMD_ABV410_001_000_1FK7M", "PMD_ABV517_001_000_1FK7M", "VT_1FK7M_M00076" + sDB_Suffix);
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_BEZ_NO_DB_RESULT";
        return strError;
    }
    var aValidValues_GetriebeBez = ECL_GetAllActiveAttributeValues("PMD_ABV410_001_000_1FK7M");
    ExecSetStandardifValueEmpty("PMD_ABV410_001_000_1FK7M", "");
    //var stopper = "";
    // Mit/Ohne Getriebe allgemein!
    /*	HMK_OPT_GETRIEBE_1FK7M
        VT_1FK7M_M00080	Zuordnung_Wellenende_Optionen
        VT_1FK7M_M00087	tech_Daten_Stoeber
        VT_1FK7M_M00109	Zuordnung_Baugroesse_I_Getriebe_Optionen
        VT_1FK7M_M00222	tech_Daten_DYA_Getriebe zu MLFB.08
        VT_1FK7M_M00231	tech_Daten_Planetengetriebe_II
    
    */
    
    
    
    
    // ################################################################################################################
    // Bezeichnung			PMD_ABV410_001_000_1FK7M	
    // ################################################################################################################
    /*
    VT_1FK7M_M00076	Zuordnung_Getriebebezeichnung_Getriebe
        PMD_ABV410_001_000_1FK7M	PMD_ABV517_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    n.n.	VT_1FK7M_M00083	Einschränken_Hilfsmerkmal _G*_Q*
    n.n.?	VT_1FK7M_M00084	Zuordnung_Getriebe_Schaltstufen
    n.n.	VT_1FK7M_M00103	ZO ABV410-Bezeichnung des Getriebes
    n.n.	VT_1FK7M_M00106	Domain Produkttyp Getriebe
    A: VT_1FK7M_M00109	Zuordnung_Baugroesse_I_Getriebe_Optionen
        HMK_BAUGROESSE_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV410_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00110	tech_Daten_Planetengetriebe_III				--> Trägkeitsmomente
        PMD_ABV410_001_000_1FK7M	PMD_ABV413_001_000_1006091	MLFB05_06_1FK7M	PMD_ABW817_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    VT_1FK7M_M00122	ZO Übersetzung <-> Stufigkeit
        PMD_ABV410_001_000_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV417_001_000_1FK7M	HMK_UEBERSETZ_STUFE_1FK7M	HMK_VALUE_VALID_1FK7M
    
    n.n.	VT_1FK7M_M00158	Einschränken_Hilfsmerkmal _H*_G*
    n.n.	VT_1FK7M_M00210	1FK7_P Getriebearten
    n.n. 	VT_1FK7M_M00223	Def. GetrArt bei DI von A** (DYA/DYAG2)
    VT_1FK7M_M00224	ZO Geber - Getriebe
        MLFB14_1FK7M	PMD_ABV410_001_000_1FK7M	HMK_VALUE_VALID_1FK7M

    n.n.	VT_1FK7M_M00230	tech_Daten_Planetengetriebe_I
    n.n.	VT_1FK7M_M00231	tech_Daten_Planetengetriebe_II


    */
    /* A: VT_1FK7M_M00109	Zuordnung_Baugroesse_I_Getriebe_Optionen
        HMK_BAUGROESSE_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV410_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M
    * /
	var sTable = "VT_1FK7M_M00109" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABV410_001_000_1FK7M";
    var sWhere = 	"HMK_BAUGROESSE_1FK7M = '" + HMK_BAUGROESSE_1FK7M + "' AND " +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_BEZ_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    var PMD_ABV410_001_000_1FK7M = ECL_GetValue("PMD_ABV410_001_000_1FK7M");
    var testPMD_ABV410_001_000_1FK7M = ECL_GetAllActiveAttributeValues("PMD_ABV410_001_000_1FK7M");

    // ################################################################################################################
    // Getriebeart setzen:
    // ################################################################################################################
    /*
    VT_1FK7M_M00076	Zuordnung_Getriebebezeichnung_Getriebe
        PMD_ABV410_001_000_1FK7M	PMD_ABV517_001_000_1FK7M	HMK_VALUE_VALID_1FK7M
    * /
	var sTable = "VT_1FK7M_M00076" + sDB_Suffix;
	var sSQL = "SELECT DISTINCT PMD_ABV517_001_000_1FK7M FROM " + sTable + " WHERE " +
                "PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_SET_GETRIEBEART");
    if (aResult.length > 0){
        var PMD_ABV517_001_000_1FK7M = aResult[0].PMD_ABV517_001_000_1FK7M; 
        
        //ECL_ActivateValue("PMD_ABV517_001_000_1FK7M", PMD_ABV517_001_000_1FK7M);
        ECL_SetValue("PMD_ABV517_001_000_1FK7M", PMD_ABV517_001_000_1FK7M);
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_SET_GETRIEBEART_NO_DB_RESULT";
        return strError;
    }
    // ################################################################################################################
    
    // ################################################################################################################
    // KonfigZiel neu setzen
    // ################################################################################################################
    var sTable = "VT_1FK7M_M00116" + sDB_Suffix;
    var sTargetAttribute = "HMK_KONFIG_ZIEL_1FK7M";
    var sWhere = 	"PMD_ABV517_001_000_1FK7M = '" + PMD_ABV517_001_000_1FK7M + "';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_KONFIG_ZIEL_BESTIMMEN_NO_DB_RESULT";
        return strError;
    }
    
    // ################################################################################################################
    
    
    // ################################################################################################################
    // HMK_UEBERSETZ_STUFE_1FK7M	Übersetzung+Stufe
    // ################################################################################################################
    /*
    VT_1FK7M_M00122	ZO Übersetzung <-> Stufigkeit
        PMD_ABV410_001_000_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV417_001_000_1FK7M	HMK_UEBERSETZ_STUFE_1FK7M	HMK_VALUE_VALID_1FK7M

    * /
	ECL_ActivateAllAttributeValues("HMK_UEBERSETZ_STUFE_1FK7M");
    
    if (PMD_ABV410_001_000_1FK7M != "00048"){
        ECL_DeactivateValue("HMK_UEBERSETZ_STUFE_1FK7M", "00010");
    }else{
        ECL_ActivateValue("HMK_UEBERSETZ_STUFE_1FK7M", "00010");
    }
    
    var sTable = "VT_1FK7M_M00122" + sDB_Suffix;
    var sTargetAttribute = "HMK_UEBERSETZ_STUFE_1FK7M";
    
    var sWhere = "PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
                 "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_UEBERSETZUNG_NO_DB_RESULT";
        return strError;
    }
    
    // ################################################################################################################
    
    // ################################################################################################################
    // Übersetzung						PMD_ABV413_001_000_1006091	
    // Anzahl der Schaltstufen			PMD_ABV417_001_000_1FK7M
    // ################################################################################################################
    /*
    VT_1FK7M_M00109	Zuordnung_Baugroesse_I_Getriebe_Optionen
    VT_1FK7M_M00110	tech_Daten_Planetengetriebe_III
    VT_1FK7M_M00114	ZO ABV413
    -------------------------------------------------------------------------------------------------------------------
    VT_1FK7M_M00122	ZO Übersetzung <-> Stufigkeit
        PMD_ABV410_001_000_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV417_001_000_1FK7M	HMK_UEBERSETZ_STUFE_1FK7M	HMK_VALUE_VALID_1FK7M

    HMK_ABV413_GETRIEBE_1FK7M	Übersetzung			n.n.
        VT_1FK7M_M00114	ZO ABV413	nur Übersetzung
    -------------------------------------------------------------------------------------------------------------------
    // Anzahl der Schaltstufen			PMD_ABV417_001_000_1FK7M
    
    VT_1FK7M_M00084	Zuordnung_Getriebe_Schaltstufen
    VT_1FK7M_M00122	ZO Übersetzung <-> Stufigkeit
    -------------------------------------------------------------------------------------------------------------------
    * /
	var HMK_UEBERSETZ_STUFE_1FK7M = ECL_GetValue("HMK_UEBERSETZ_STUFE_1FK7M");
    
    var sTable = "VT_1FK7M_M00122" + sDB_Suffix;
	
	var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
                "HMK_UEBERSETZ_STUFE_1FK7M = '" + HMK_UEBERSETZ_STUFE_1FK7M + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
        
    var aResult = GetDBDataSetEXT(sSQL, sTable+"_PL");
    if (aResult.length > 0){
        var PMD_ABV413_001_000_1006091 = aResult[0].PMD_ABV413_001_000_1006091; // Übersetzung
        var PMD_ABV417_001_000_1FK7M = aResult[0].PMD_ABV417_001_000_1FK7M; // Anzahl der Schaltstufen
        
        ECL_SetValue("PMD_ABV413_001_000_1006091", PMD_ABV413_001_000_1006091);
        ECL_SetValue("PMD_ABV417_001_000_1FK7M", PMD_ABV417_001_000_1FK7M);
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_SET_UEBERSETZUNG_UNBESTIMMT_NO_DB_RESULT";
        return strError;
    }
    
    // ################################################################################################################
    
    
    // ################################################################################################################
    // HMK_OPT_GETRIEBE_1FK7M  Einschränkung zur Bestimmung der gültigen Wellenenden
    // ################################################################################################################
    /*	
    VT_1FK7M_M00109	Zuordnung_Baugroesse_I_Getriebe_Optionen
        HMK_BAUGROESSE_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV410_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M
    * /
	var sTable = "VT_1FK7M_M00109" + sDB_Suffix;
    var sTargetAttribute = "HMK_OPT_GETRIEBE_1FK7M";
    
    var sWhere = "HMK_BAUGROESSE_1FK7M = '" + HMK_BAUGROESSE_1FK7M + "' AND " +
                 "PMD_ABV413_001_000_1006091 = '" + PMD_ABV413_001_000_1006091 + "' AND " +
                 "PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
                 "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_KAG_EINSCHRAENKUNG_NO_DB_RESULT";
        return strError;
    }
    
    // ################################################################################################################
    // Ausführung des Wellenendes an der Antriebsseite 			PMD_ABV414_001_000_1FK7M
    // ################################################################################################################
    /*
    VT_1FK7M_M00080	Zuordnung_Wellenende_Optionen
        PMD_ABV414_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M

    n.n.	VT_1FK7M_M00082	Bauart_Wellenende_Stöber_Getriebe
    n.n.	VT_1FK7M_M00115	ZO ABV414
    * /
	var aValidValues_Getriebe_KAG = ECL_GetAllActiveAttributeValues("HMK_OPT_GETRIEBE_1FK7M");
    var sTable = "VT_1FK7M_M00080" + sDB_Suffix;
    var sTargetAttribute = "PMD_ABV414_001_000_1FK7M";
    if (aValidValues_Getriebe_KAG.length > 0){
        
        var sWhere_KAG = "(HMK_OPT_GETRIEBE_1FK7M = '" + aValidValues_Getriebe_KAG[0] + "' ";
        for(var i=1; i < aValidValues_Getriebe_KAG.length; i++){
            
            sWhere_KAG = sWhere_KAG + "OR HMK_OPT_GETRIEBE_1FK7M = '" + aValidValues_Getriebe_KAG[i] + "' ";
        }
        sWhere_KAG = sWhere_KAG + ") AND ";
    }else{
        var sWhere_KAG = "HMK_OPT_GETRIEBE_1FK7M = '" + HMK_OPT_GETRIEBE_1FK7M + "' AND ";
    }
    var sWhere = 	sWhere_KAG +
                    "HMK_VALUE_VALID_1FK7M = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_WELLENENDE_NO_DB_RESULT";
        return strError;
    }
    
    // ################################################################################################################
    
    
    
    // ################################################################################################################
    // HMK_OPT_GETRIEBE_1FK7M  Bestimmung KAG Jxx
    // ################################################################################################################
    /*
    HMK_OPT_GETRIEBE_1FK7M
        VT_1FK7M_M00080	Zuordnung_Wellenende_Optionen
            PMD_ABV414_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M
        
        n.n.	VT_1FK7M_M00087	tech_Daten_Stoeber
    
    VT_1FK7M_M00109	Zuordnung_Baugroesse_I_Getriebe_Optionen
        HMK_BAUGROESSE_1FK7M	PMD_ABV413_001_000_1006091	PMD_ABV410_001_000_1FK7M	HMK_OPT_GETRIEBE_1FK7M	HMK_VALUE_VALID_1FK7M

        n.n.	VT_1FK7M_M00222	tech_Daten_DYA_Getriebe zu MLFB.08
        n.n.	VT_1FK7M_M00231	tech_Daten_Planetengetriebe_II
    */
    
    /*var sSQL = "SELECT DISTINCT HMK_OPT_GETRIEBE_1FK7M FROM VT_1FK7M_M00109_19624 WHERE " +
                "HMK_BAUGROESSE_1FK7M = '" + HMK_BAUGROESSE_1FK7M + "' AND " +
                "PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
                "PMD_ABV413_001_000_1006091 = '" + PMD_ABV413_001_000_1006091 + "' AND " +
                "HMK_VALUE_VALID_1FK7M = 'T';";
        
    var aResult = GetDBDataSetEXT(sSQL, "VT_1FK7M_M00109_19624"+"_GETRIEBE_KAG");
    * /
	var PMD_ABV414_001_000_1FK7M = ECL_GetValue("PMD_ABV414_001_000_1FK7M");
    
 	var sTableA = "VT_1FK7M_M00080" + sDB_Suffix;
	var sTableB = "VT_1FK7M_M00109" + sDB_Suffix;
	var sSQL = "SELECT DISTINCT " + sTableA + ".HMK_OPT_GETRIEBE_1FK7M FROM " + sTableA + " " +
				"INNER JOIN " + sTableB + " " +
				"ON " + sTableA + ".HMK_OPT_GETRIEBE_1FK7M = " + sTableB + ".HMK_OPT_GETRIEBE_1FK7M " +
				"WHERE " + 
				sTableA + ".PMD_ABV414_001_000_1FK7M = '" + PMD_ABV414_001_000_1FK7M + "' AND " +
				sTableB + ".HMK_BAUGROESSE_1FK7M = '" + HMK_BAUGROESSE_1FK7M + "' AND " +
				sTableB + ".PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "' AND " +
				sTableB + ".PMD_ABV413_001_000_1006091 = '" + PMD_ABV413_001_000_1006091 + "' AND " +
				sTableA + ".HMK_VALUE_VALID_1FK7M = 'T' AND " +
				sTableB + ".HMK_VALUE_VALID_1FK7M = 'T';";
	
	var aResult = GetDBDataSetEXT(sSQL, sTableB +"_GETRIEBE_KAG");
    if (aResult.length > 0){
        
        var HMK_OPT_GETRIEBE_1FK7M = aResult[0].HMK_OPT_GETRIEBE_1FK7M; // KAG
        
        //ECL_ActivateValue("HMK_OPT_GETRIEBE_1FK7M", HMK_OPT_GETRIEBE_1FK7M);
        ECL_SetValue("HMK_OPT_GETRIEBE_1FK7M", HMK_OPT_GETRIEBE_1FK7M);
    }else{
        strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_KAG_UNBESTIMMT_NO_DB_RESULT";
        return strError;
    }
	// ################################################################################################################
	// Set info parameters of gear
	// ################################################################################################################
	/*
	HMK_ACB729_1FK7M	Flanschgröße (D1)
	HMK_ACB772_1FK7M	Zentrierrand (D3)
	HMK_ACB789_1FK7M	Lochkreis (D4)
	HMK_ACB769_1FK7M	Durchmesser der Welle (D2)
	HMK_ACB783_1FK7M	Länge der Welle (L)

	*/
	//	VT_1FK7M_M00265_24169
	//	PMD_ABV410_001_000_1FK7M	HMK_ACB729_1FK7M	HMK_ACB769_1FK7M	HMK_ACB772_1FK7M	HMK_ACB789_1FK7M	HMK_ACB783_1FK7M

	var ECSI_CX_SeriesID = ECL_GetValue("ECSI_CX_SeriesID");
	if (ECSI_CX_SeriesID == "302" || HMK_KONFIG_ZIEL_1FK7M !== "SERVO" ){
		// Getriebe einblenden
		ECL_ActivateAttribute("PMD_ABV410_001_000_1FK7M"); 	// Bezeichnung Getriebe
		ECL_ActivateAttribute("HMK_UEBERSETZ_STUFE_1FK7M"); // Übersetzung + Stufigkeit
		ECL_ActivateAttribute("PMD_ABV414_001_000_1FK7M"); 	// Wellenende
		
		ECL_ActivateAttribute("HMK_ACB729_1FK7M");
		ECL_ActivateAttribute("HMK_ACB769_1FK7M");
		ECL_ActivateAttribute("HMK_ACB772_1FK7M");
		ECL_ActivateAttribute("HMK_ACB789_1FK7M");
		ECL_ActivateAttribute("HMK_ACB783_1FK7M");
		
		
		var PMD_ABV410_001_000_1FK7M = ECL_GetValue("PMD_ABV410_001_000_1FK7M");
		
		if (PMD_ABV410_001_000_1FK7M != "00048"){
			
			var sTable = "VT_1FK7M_M00265" + sDB_Suffix;
			var sSQL = "SELECT * FROM " + sTable + " WHERE " +
						"PMD_ABV410_001_000_1FK7M = '" + PMD_ABV410_001_000_1FK7M + "';";
				
			var aResult = GetDBDataSetEXT(sSQL, sTable + "_PL");
			if (aResult.length > 0){
				var HMK_ACB729_1FK7M = parseInt(aResult[0].HMK_ACB729_1FK7M); 
				var HMK_ACB769_1FK7M = parseInt(aResult[0].HMK_ACB769_1FK7M); 
				var HMK_ACB772_1FK7M = parseInt(aResult[0].HMK_ACB772_1FK7M); 
				var HMK_ACB789_1FK7M = parseInt(aResult[0].HMK_ACB789_1FK7M); 
				var HMK_ACB783_1FK7M = parseInt(aResult[0].HMK_ACB783_1FK7M); 
				
				if (HMK_ACB729_1FK7M < 100){
					HMK_ACB729_1FK7M = "V_0" + HMK_ACB729_1FK7M;
				}else{
					HMK_ACB729_1FK7M = "V_" + HMK_ACB729_1FK7M;
				}
				
                if (HMK_ACB769_1FK7M < 100){
					HMK_ACB769_1FK7M = "V_0" + HMK_ACB769_1FK7M;
				}else{
					HMK_ACB769_1FK7M = "V_" + HMK_ACB769_1FK7M;
				}
				
				if (HMK_ACB772_1FK7M  < 100){
					HMK_ACB772_1FK7M = "V_0" + HMK_ACB772_1FK7M;
				}else{
					HMK_ACB772_1FK7M = "V_" + HMK_ACB772_1FK7M;
				}
				
				if (HMK_ACB789_1FK7M  < 100){
					HMK_ACB789_1FK7M = "V_0" + HMK_ACB789_1FK7M;
				}else{
					HMK_ACB789_1FK7M = "V_" + HMK_ACB789_1FK7M;
				}
				
				if (HMK_ACB783_1FK7M  < 100){
					HMK_ACB783_1FK7M = "V_0" + HMK_ACB783_1FK7M;
				}else{
					HMK_ACB783_1FK7M = "V_" + HMK_ACB783_1FK7M;
				}
				
				ECL_DeactivateAllAttributeValues("HMK_ACB729_1FK7M");
				ECL_DeactivateAllAttributeValues("HMK_ACB769_1FK7M");
				ECL_DeactivateAllAttributeValues("HMK_ACB772_1FK7M");
				ECL_DeactivateAllAttributeValues("HMK_ACB789_1FK7M");
				ECL_DeactivateAllAttributeValues("HMK_ACB783_1FK7M");
				
				ECL_ActivateValue("HMK_ACB729_1FK7M", HMK_ACB729_1FK7M);
				ECL_ActivateValue("HMK_ACB769_1FK7M", HMK_ACB769_1FK7M);
				ECL_ActivateValue("HMK_ACB772_1FK7M", HMK_ACB772_1FK7M);
				ECL_ActivateValue("HMK_ACB789_1FK7M", HMK_ACB789_1FK7M);
				ECL_ActivateValue("HMK_ACB783_1FK7M", HMK_ACB783_1FK7M);
				
				ECL_SelectValue("HMK_ACB729_1FK7M", HMK_ACB729_1FK7M);
				ECL_SelectValue("HMK_ACB769_1FK7M", HMK_ACB769_1FK7M);
				ECL_SelectValue("HMK_ACB772_1FK7M", HMK_ACB772_1FK7M);
				ECL_SelectValue("HMK_ACB789_1FK7M", HMK_ACB789_1FK7M);
				ECL_SelectValue("HMK_ACB783_1FK7M", HMK_ACB783_1FK7M);
			}else{
				strError = "DICT1_ERR_1FK7___PLVT_GETRIEBE_ABM_NO_DB_RESULT";
				return strError;
			}
			/*ECL_DisableAttribute("HMK_ACB729_1FK7M");
			ECL_DisableAttribute("HMK_ACB769_1FK7M");
			ECL_DisableAttribute("HMK_ACB772_1FK7M");
			ECL_DisableAttribute("HMK_ACB789_1FK7M");
			ECL_DisableAttribute("HMK_ACB783_1FK7M");
			*/
		}else{
			// fehler
			
			ECL_DeactivateAllAttributeValues("HMK_OPT_GETRIEBE_1FK7M");
			ECL_ActivateValue("HMK_OPT_GETRIEBE_1FK7M", ".");
			ECL_SelectValue("HMK_OPT_GETRIEBE_1FK7M", ".");
			
			strError = "DICT1_ERR_1FK7___PLVT_GEAR_NO_RESULT";
			return strError;
		}
	}else{
		// Kein Getriebe
		ECL_DeactivateAllAttributeValues("HMK_OPT_GETRIEBE_1FK7M");
		ECL_ActivateValue("HMK_OPT_GETRIEBE_1FK7M", ".");
		ECL_SelectValue("HMK_OPT_GETRIEBE_1FK7M", ".");
		
		// Getriebe ausblenden
		ECL_DeactivateAttribute("PMD_ABV410_001_000_1FK7M"); // Bezeichnung Getriebe
		//ECL_DeactivateAttribute("PMD_ABV517_001_000_1FK7M"); // Art des Getriebes
		ECL_DeactivateAttribute("HMK_UEBERSETZ_STUFE_1FK7M"); // bersetzung + Stufigkeit
		//ECL_DeactivateAttribute("PMD_ABV413_001_000_1006091"); // bersetzung
		//ECL_DeactivateAttribute("PMD_ABV417_001_000_1FK7M"); // Anzahl der Schaltstufen
		ECL_DeactivateAttribute("PMD_ABV414_001_000_1FK7M"); // Wellenende
		//ECL_DeactivateAttribute("HMK_OPT_GETRIEBE_1FK7M"); // Hilfsmerkmal Optionen Getriebe
		
		ECL_DeactivateAttribute("HMK_ACB729_1FK7M");
		ECL_DeactivateAttribute("HMK_ACB769_1FK7M");
		ECL_DeactivateAttribute("HMK_ACB772_1FK7M");
		ECL_DeactivateAttribute("HMK_ACB789_1FK7M");
		ECL_DeactivateAttribute("HMK_ACB783_1FK7M");
		
		
	}
	// ################################################################################################################
	
	
	
    
    //var test = ECL_GetAllActiveAttributeValues("HMK_OPT_GETRIEBE_1FK7M");
    
    // ################################################################################################################
    
    
    
    return "OK";

}
