//@legacy
//#mode(full-ecma)


//@import "StringHandler.js"

//@import "Parser.common.js"

//@import "Parser.tokenizer.js"

//@import "../1FK7_MLFB/Base.misc.js"

//@import "../1FK7_CONFIG/VT_1FK7.js"

//@import "../1FK7_CONFIG/CFG_1FK7_KONFIG_ZIEL.js"


/**
 * @category   1FK7 Parser
 * @package    Parser
 * @copyright  Copyright (c) 2021 Plan Software GmbH (http://www.plansoft.de)
 */
function parse_init(strMLFB) {
    vtTimeStart = Date.getTime();

    var oParsing = {
        strBaseMLFB: '',
        strFullMLFB: '',
        strError: '',
        strWarning: '',
        aTokens: [],
        oFreetext: {}
    };

    var strBaseTypeMLFB = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

    strMLFB = normalizeMLFB(strMLFB);
    strBaseTypeMLFB = normalizeMLFB(strBaseTypeMLFB);

    var strStartConfiguration = ECL_GetValue("ECSI_IS_START_CONFIGURATION");

    //Entweder kommt eine zur Haupt MLFB unterschiedliche Base Type MLFB aus dem SIZER.
    //Hier sollen dann möglichst viele Attribute beibehalten werden.
    //Die Basetype MLFB kann sich in Getriebe, Motor oder Übersetzung von der Haupt MLFB unterscheiden.
    if (strBaseTypeMLFB != "") {
        //--------------------------------------------------------------------------------------------------------
        // Base Type  MLFB aufbereiten
        //--------------------------------------------------------------------------------------------------------
        var aBTComponents = tokenize(strBaseTypeMLFB);
        if (aBTComponents.length > 1) {
            // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
            // eliminate the resulting invalid short description 'Z'
            if ((aBTComponents[1] === 'Z') || (aBTComponents[1] === '-Z')) {
                aBTComponents = removeElementsFromArray(aBTComponents, 1, 1);
            }
        }

        strBaseTypeMLFB = aBTComponents[0];

        if (strBaseTypeMLFB.length === 17) {
            // eliminate the -Z 
            strBaseTypeMLFB = strBaseTypeMLFB.substring(0, 16);
        }

        var strBaseTypeMLFB_fix = strBaseTypeMLFB.substring(0, 11);
    }


    var oResult;

    var nFreetext = find(strMLFB, '{');
    var strFreetext = '';
    if (nFreetext > 0) {
        strFreetext = strMLFB.right(strMLFB.length - nFreetext + 1);
    }
    oParsing.oFreetext = parseFreetext(strFreetext, true);
    strMLFB = replace(strMLFB, strFreetext, "");
    oParsing.strFullMLFB = strMLFB;

    var aComponents = tokenize(strMLFB);
    if (!aComponents.length) {
        oParsing.strError = 'ERRORMSG_MLFB_1FK7___INVALID_MLFB';
        return (oParsing)
    } else if (aComponents.length > 1) {
        // some @%$§/%%§ deliver the MLFB with some space between the last digit and the -Z for short descriptions ->
        // eliminate the resulting invalid short description 'Z'
        if ((aComponents[1] === 'Z') || (aComponents[1] === '-Z')) {
            aComponents = removeElementsFromArray(aComponents, 1, 1);
        }
    }
    oParsing.strBaseMLFB = aComponents[0];
    oParsing.aTokens = aComponents;

    // -----------------------------------------------------------------------------------------------
    // Konfigurationsziel definieren (mit/ohne Getriebe
    var HMK_KONFIG_ZIEL_1FK7M = get_Konfig_Ziel(aBTComponents);

    var bGear = false;
    var bKeepConfig = false;
    // if Konfig-ziel == Getriebe: todo
    var ECSI_CX_SeriesID = ECL_GetValue("ECSI_CX_SeriesID");
    if (ECSI_CX_SeriesID == "302" || HMK_KONFIG_ZIEL_1FK7M !== "SERVO") {
        // mit Getriebe
        bGear = true;

        // prüfen auf Getriebe KAG
        var sKAG_Gear = getKAGforAttribute("HMK_OPT_GETRIEBE_1FK7M", aComponents);
        // BaseType
        var sKAG_Gear_BT = getKAGforAttribute("HMK_OPT_GETRIEBE_1FK7M", aBTComponents);

        var bGearKAGinMLFB = false;
        var bGearKAGinBT = false;

        // Getriebe KAG ggf. entfernen
        if (sKAG_Gear != sKAG_Gear_BT) {
            // remove gear-KAG
            var aNewArray = [];
            for (var i = 0; i < aComponents.length; i++) {

                if (aComponents[i] != sKAG_Gear) {
                    aNewArray.push(aComponents[i]);
                }
            }

            aComponents = aNewArray;

            strMLFB = replace(strMLFB, "+" + sKAG_Gear, "");
            strMLFB = replace(strMLFB, sKAG_Gear, "");

            bKeepConfig = true;
        }

        // Add new KAGs
        aComponents.push(sKAG_Gear_BT);
        aComponents.sort();

        strMLFB = strMLFB + "+" + sKAG_Gear_BT;

        ECL_SetValue("ECSI_MLFB", strMLFB);
    }

    var strMLFB_fix = strMLFB.substring(0, 11);


    // EDIT RepairConfig added
    if (strStartConfiguration == "1" && strBaseTypeMLFB_fix == strMLFB_fix && strBaseTypeMLFB != "" && find(strMLFB.left(16), ".") < 0)   // if same motor is selected again
    {
        var bRepairConfig = true;
    }

    // -----------------------------------------------------------------------------------------------
    //Überprüfung, ob sich die MLFB im Vergleich zur Base Type MLFB unterscheidet
    // -----------------------------------------------------------------------------------------------
    if (((strBaseTypeMLFB_fix != strMLFB_fix) && find(strMLFB.left(16), ".") < 0 && strBaseTypeMLFB != "") || bRepairConfig) {


        // Bei Geber (MLFB14 == 'Z'), dann KAG (gibt es in aktueller DTK-Basis nicht)


        // -----------------------------------------------------------------------------------------------
        // Platzhalter aus MLFB in BT übernehmen
        // -----------------------------------------------------------------------------------------------

        // 12-16 ein Wildcard, dann Default setzen
        // --------------------------------------------------------------------------------------------------------	
        // MLFB14: erst Geber bestimmen, dann Bauform_MLFB
        // --------------------------------------------------------------------------------------------------------
        var sMLFB14 = strMLFB.charAt(13);
        var sBT_MLFB14 = strBaseTypeMLFB.charAt(13);

        if (sBT_MLFB14 == ".") {
            // Wert aus MLFB übernehmen
            // Check Geber
            var bCheck = checkGeber_Parser(strBaseTypeMLFB, sMLFB14, HMK_KONFIG_ZIEL_1FK7M);
            if (bCheck) {
                // setzen
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
            } else {
                // nicht zulässig, default setzen
                //MLFB14 Geber Default B
                var MLFB05_06_08_1FK7M = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5) + "_" + strBaseTypeMLFB.charAt(7);
                var sMLFB14 = get_MLFB14_default(HMK_KONFIG_ZIEL_1FK7M, MLFB05_06_08_1FK7M);
                if (sMLFB14 != "ERROR") {
                    // Setze Default:
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, sMLFB14);
                } else {
                    sMLFB14 = "B";
                    strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 13, "B");
                }
            }
        }
        // --------------------------------------------------------------------------------------------------------
        // MLFB12 Bauform/Flanschausführung Default 1, 4 je nach Geber <--- immer bestimmen, nie übernehmen!
        // --------------------------------------------------------------------------------------------------------
        if (strBaseTypeMLFB.charAt(11) == ".") {
            // Bestimme Wert aus Geber MLFB14 bzw. VT157
            // var sMLFB12 = get_MLFB12_default(MLFB05_06_08_1FK7M, sMLFB14 );
            // if (sMLFB12 != "ERROR"){
            //     // Setze Default:
            //     strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, sMLFB12);
            // }else{
            //     strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "1");
            // }
            //Users wanted DriveCliq selected as default. If set to 1 then it's gonna be selected if passible. 
            //Otherswise it wont and value will be corrected
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 11, "1");
        }
        // --------------------------------------------------------------------------------------------------------
        // MLFB13 E-Anschluss/Steckerabgangsrichtung Default 1 <---- ist immer 1
        // --------------------------------------------------------------------------------------------------------
        var sMLFB13 = strMLFB.charAt(12);
        var sBT_MLFB13 = strBaseTypeMLFB.charAt(12);

        if (sBT_MLFB13 == ".") {
            // Setze Default:
            strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 12, "1");
        }
        // --------------------------------------------------------------------------------------------------------
        // MLFB15 Wellenende/Bremse Default A ohne Bremse, B mit Bremse
        // --------------------------------------------------------------------------------------------------------
        var sMLFB15 = strMLFB.charAt(14);
        var sBT_MLFB15 = strBaseTypeMLFB.charAt(14);

        if (sBT_MLFB15 == ".") {	//MLFB15 Wellenende/Bremse Default A ohne Bremse, B mit Bremse
            // Übernahme Wert aus MLFB

            // Wenn Bremse pflicht?
            // für SERVO: ohne Bremse: A, G
            // für SERVO: mit Bremse: B, H
            var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");

            // mit GearboxMotorCoupling nur G oder H
            var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
            if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) {
                // 
                if (strwithBrake == "1") {
                    // mit Bremse
                    sMLFB15 = "H";
                    var UI_HALTEBREMSE_1FK7M = "M_FK7";
                } else { // ohne Bremse
                    sMLFB15 = "G";
                    var UI_HALTEBREMSE_1FK7M = "OHNE";
                }
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15);
            } else {

                // wenn mit Bremse und vorher MLFB15 == A || B ==> B
                // wenn mit Bremse und vorher MLFB15 == G || H ==> H
                if (strwithBrake == "1") {
                    //var UI_HALTEBREMSE_1FK7M = "M_FK7";

                    if (sMLFB15 == "A" || sMLFB15 == "B") {
                        // mit Bremse, Passfeder
                        var sMLFB15_new = "B";
                    } else if (strwithBrake == "1" && (sMLFB15 == "G" || sMLFB15 == "H")) {
                        // mit Bremse, glatte Welle
                        var sMLFB15_new = "H";
                    }
                } else {
                    //var UI_HALTEBREMSE_1FK7M = "OHNE";
                    // wenn ohne Bremse und vorher MLFB15 == A || B ==> A
                    // wenn ohne Bremse und vorher MLFB15 == G || H ==> G
                    if (sMLFB15 == "A" || sMLFB15 == "B") {
                        // ohne Bremse, Passfeder
                        var sMLFB15_new = "A";

                    } else { // ohne Bremse, glatte Welle
                        var sMLFB15_new = "G";
                    }
                }

                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 14, sMLFB15_new);
            }
        }
        // --------------------------------------------------------------------------------------------------------
        // MLFB16 Schutzart Default 0
        // --------------------------------------------------------------------------------------------------------
        var sMLFB16 = strMLFB.charAt(15);
        var sBT_MLFB16 = strBaseTypeMLFB.charAt(15);

        if (sBT_MLFB16 == ".") {
            // Übernahme aus MLFB

            // Check 
            var bCheck = checkMLFB16(strBaseTypeMLFB, sMLFB16, HMK_KONFIG_ZIEL_1FK7M);
            if (bCheck) {
                // setzen
                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
            } else {
                // Setze Default: //MLFB16 Schutzart Default 0
                // get ValueDefault
                sMLFB16 = GetMLFB16Default(strBaseTypeMLFB, HMK_KONFIG_ZIEL_1FK7M);

                strBaseTypeMLFB = replaceAt(strBaseTypeMLFB, 15, sMLFB16);
            }
        }

        // -----------------------------------------------------------------------------------------------
        // Zuweisen der neuen MLFB und KAG-Liste
        strMLFB = strBaseTypeMLFB.substring(0, 16) + strMLFB.substring(16);

        oParsing.strBaseMLFB = strBaseTypeMLFB.substring(0, 16);
        oParsing.strFullMLFB = strMLFB;
        aComponents[0] = oParsing.strBaseMLFB;
        oParsing.aTokens = aComponents;
        ECL_SetValue("ECSI_MLFB", strMLFB);
    }
    else {
        if (find(strMLFB.left(16), ".") >= 0) {
            //Unvollständige SIZER MLFB

            // Prüfen, ob '.' an Stelle 1 bis 11, dann Fehler
            for (var i = 0; i < 11; i++) {
                if (strMLFB.charAt(i) == ".") {
                    oParsing.strError = 'ERRORMSG_MLFB_1FK7___INCOMPLETE_MLFB';
                    return (oParsing);
                }
            }
            // 12-16 ein Wildcard, dann Default setzen

            // MLFB14: erst Geber bestimmen, dann Bauform_MLFB
            if (strMLFB.charAt(13) == ".") {	//MLFB14 Geber Default B
                var MLFB05_06_08_1FK7M = strMLFB.charAt(4) + strMLFB.charAt(5) + "_" + strMLFB.charAt(7);
                var sMLFB14 = get_MLFB14_default(HMK_KONFIG_ZIEL_1FK7M, MLFB05_06_08_1FK7M);
                if (sMLFB14 != "ERROR") {
                    // Setze Default:
                    strMLFB = replaceAt(strMLFB, 13, sMLFB14);
                } else {
                    strMLFB = replaceAt(strMLFB, 13, "B");
                }
            }
            // MLFB12 Bauform/Flanschausführung Default 1, 4 je nach Geber 
            if (strMLFB.charAt(11) == ".") {
                // Bestimme Wert aus Geber MLFB14 bzw. VT157
                // var sMLFB12 = get_MLFB12_default(MLFB05_06_08_1FK7M, strMLFB.charAt(13) );
                // if (sMLFB12 != "ERROR"){
                //     // Setze Default:
                //     strMLFB = replaceAt(strMLFB, 11, sMLFB12);
                // }else{
                //     strMLFB = replaceAt(strMLFB, 11, "1");
                // }
                //Users wanted DriveCliq selected as default. If set to 1 then it's gonna be selected if passible. 
                //Otherswise it wont and value will be corrected
                strMLFB = replaceAt(strMLFB, 11, "1");

            }
            // MLFB13 E-Anschluss/Steckerabgangsrichtung Default 1 
            if (strMLFB.charAt(12) == ".") {
                // Setze Default:
                strMLFB = replaceAt(strMLFB, 12, "1");
            }
            // MLFB15 Wellenende/Bremse Default A ohne Bremse, B mit Bremse
            if (strMLFB.charAt(14) == ".") {	//MLFB15 Wellenende/Bremse Default A ohne Bremse, B mit Bremse

                var strwithBrake = ECL_GetValue("ECSI_CX_MotorBrakeRequired");
                var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
                if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) {
                    // Zulässige Werte: G,H
                    if (strwithBrake == "1") {
                        // mit Bremse
                        var UI_HALTEBREMSE_1FK7M = "M_FK7";
                        strMLFB = replaceAt(strMLFB, 14, "H");
                    } else { // ohne Bremse
                        var UI_HALTEBREMSE_1FK7M = "OHNE";
                        strMLFB = replaceAt(strMLFB, 14, "G");
                    }
                } else {
                    // Zulässige Werte: A,B
                    if (strwithBrake == "1") {
                        // mit Bremse
                        //var UI_HALTEBREMSE_1FK7M = "M_FK7";
                        strMLFB = replaceAt(strMLFB, 14, "B");
                    } else { // ohne Bremse
                        var UI_HALTEBREMSE_1FK7M = "OHNE";
                        strMLFB = replaceAt(strMLFB, 14, "A");
                    }
                }
            }
            // MLFB16 Schutzart Default 3
            if (strMLFB.charAt(15) == ".") {	//MLFB16 Schutzart Default 3
                // Setze Default:
                strMLFB = replaceAt(strMLFB, 15, "3");
            }
            ECL_SetValue("ECSI_MLFB", strMLFB);

            oParsing.strBaseMLFB = strMLFB.substring(0, 16);
            aComponents[0] = oParsing.strBaseMLFB;
            //oParsing.aTokens = aComponents;
        }
    }
    // END EDIT KEEP CONF

    if (oParsing.strBaseMLFB.length !== 16) {
        // Prüfen, ob die Zeichenkette 16 Stellen hat
        oParsing.strError = 'ERRORMSG_MLFB_1FK7___PARSE_WRONG_SIZE';
        return (oParsing);
    }

    if (oParsing.strBaseMLFB.indexOf("1FK7") < 0) {
        // Falsches Produkt
        oParsing.strError = 'ERRORMSG_MLFB_1FK7___PARSE_WRONG_PRODUCT';
        return (oParsing);
    }

    var oResult;
    oResult = parse_1FT7(oParsing.aTokens);

    oResult.oParsingData.KONF_ZIEL = HMK_KONFIG_ZIEL_1FK7M;

    if (oResult) {
        if (oResult.oProduct)
            oParsing.oProduct = oResult.oProduct;
        if (oResult.oParsingData)
            oParsing.oParsingData = oResult.oParsingData;
        oParsing.strError += ((oParsing.strError ? ' ' : '') + oResult.strError);
        oParsing.strWarning += ((oParsing.strWarning ? ' ' : '') + oResult.strWarning);
        oParsing.GearboxMotorCoupling = parseInt(ECL_GetValue("ECSI_CX_GearboxMotorCoupling")); // 0,1
        var ECSI_CX_IsDriveTrain = parseInt(ECL_GetValue("ECSI_CX_IsDriveTrain"));
        if (ECSI_CX_IsDriveTrain !== 1) {
            ECSI_CX_IsDriveTrain = 0;
        }
        oParsing.IsDriveTrain = ECSI_CX_IsDriveTrain; // 1/0 "true"/"false"
    }


    vtTimeStop = Date.getTime();
    vtTime = (vtTimeStop - vtTimeStart) / 1000;
    logtraceln("******* Parse - Time: " + vtTime + " sec" + "\n");

    return (oParsing);
}

function get_Konfig_Ziel(aKAG_List) {
    var sKAG = getKAGforAttribute("HMK_OPT_GETRIEBE_1FK7M", aKAG_List)
    return Bestimme_KonfigZiel_Parser(sKAG); // HMK_KONFIG_ZIEL_1FK7M
}

function get_MLFB14_default(HMK_KONFIG_ZIEL_1FK7M, MLFB05_06_08_1FK7M) {
    /*
    Geber
    MLFB14 Werte: 
    abhängig von KonfigZiel
    VT_1FK7M_M00157
    HMK_KONFIG_TYP_1FK7M	MLFB05_06_08_1FK7M	MLFB12_1FK7M	MLFB14_1FK7M	PMD_AAA717_001_000_1FK7M	HMK_PRODUKT_ALT_AKT_1FK7M	HMK_VALUE_VALID_1FK7M
    konfig                 	01_5 				4				A				00005						AKT  						T

alt	VT_1FK7M_M00105	Geber, MLFB14, KonfigZiel
    MLFB14_1FK7M	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
neu VT_1FK7M_M00235	ZO MLFB14 <> Geber
        MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M	
    VT_1FK7M_M00054	Geber
    PMD_ABU278_001_000_1FK7M	PMD_ABU209_001_000_1FK7M	UI_GEBER_1FK7M	UI_GEBER_SMC_1FK7M	UI_GEBER_AUFLOESUNG_1FK7M	HMK_VALUE_VALID_1FK7M

    
    Voraussetzung: KonfigZiel definiert
    */
    // zulässige MLFB14 aus KonfigZiel:

    var sTable_A = "VT_1FK7M_M00235" + sDB_Suffix;
    var sTable_B = "VT_1FK7M_M00157" + sDB_Suffix;

    var sSQL = "SELECT DISTINCT " + sTable_A + ".MLFB14_1FK7M FROM " + sTable_A +
        " INNER JOIN " + sTable_B + " ON " +
        sTable_B + ".MLFB14_1FK7M = " + sTable_A + ".MLFB14_1FK7M WHERE " +
        sTable_A + ".HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
        sTable_A + ".HMK_VALUE_VALID_1FK7M = 'T' AND " +
        sTable_B + ".HMK_KONFIG_TYP_1FK7M = 'konfig' AND " +
        sTable_B + ".MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
        sTable_B + ".HMK_PRODUKT_ALT_AKT_1FK7M = 'AKT' AND " +
        sTable_B + ".HMK_VALUE_VALID_1FK7M = 'T' " +
        "ORDER BY " + sTable_A + ".MLFB14_1FK7M ASC;";

    var aResult = GetDBDataSetEXT(sSQL, "MLFB14_PARSE_Default");
    if (aResult.length > 0) {
        var MLFB14_1FK7M = aResult[0].MLFB14_1FK7M;
        return MLFB14_1FK7M;
    }
    return "ERROR";
}

function get_MLFB12_default(MLFB05_06_08_1FK7M, MLFB14_1FK7M) {
    /*
    MLFB12 Werte: 1, 4		immer Bauform IM B5 (Z0003)
    abhängig von gewähltem Geber bzw. MLFB14, ob 1 oder 4
    VT_1FK7M_M00157
    HMK_KONFIG_TYP_1FK7M	MLFB05_06_08_1FK7M	MLFB12_1FK7M	MLFB14_1FK7M	PMD_AAA717_001_000_1FK7M	HMK_PRODUKT_ALT_AKT_1FK7M	HMK_VALUE_VALID_1FK7M
    konfig                 	01_5 				4				A				00005						AKT  						T

    VT_1FK7M_M00105	Geber, MLFB14, KonfigZiel
    MLFB14_1FK7M	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    
    VT_1FK7M_M00054	Geber
    MLFB14_1FK7M	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
    
    Voraussetzung: Geber bestimmt!
    */
    var sTable = "VT_1FK7M_M00157" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT MLFB12_1FK7M FROM " + sTable + " WHERE " +
        "HMK_KONFIG_TYP_1FK7M = 'konfig' AND " +
        "MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
        "MLFB14_1FK7M = '" + MLFB14_1FK7M + "' AND " +
        "HMK_PRODUKT_ALT_AKT_1FK7M = 'AKT' AND " +
        "HMK_VALUE_VALID_1FK7M = 'T';";
    var aResult = GetDBDataSetEXT(sSQL, "MLFB12_PARSE_Default");
    if (aResult.length > 0) {
        var MLFB12_1FK7M = aResult[0].MLFB12_1FK7M;
        return MLFB12_1FK7M;
    }
    return "ERROR";

}

function get_MLFB15_default(HMK_KONFIG_ZIEL_1FK7M, UI_HALTEBREMSE_1FK7M) {
    /*
    Bremse und Wellenende
    
    VT_1FK7M_M00018
    HMK_KONFIG_ZIEL_1FK7M	MLFB15_1FK7M	HMK_VALUE_VALID_1FK7M
    
    VT_1FK7M_M00151
    MLFB15_1FK7M	PMD_AAA506_001_000_1FK7M	UI_HALTEBREMSE_1FK7M	HMK_VALUE_VALID_1FK7M
    
    Voraussetzung: KonfigZiel definiert
    */

    var strECSI_CX_GearboxMotorCoupling = ECL_GetValue("ECSI_CX_GearboxMotorCoupling");
    if (strECSI_CX_GearboxMotorCoupling && parseInt(strECSI_CX_GearboxMotorCoupling) == 1) {
        var sWhereWellenende = "" + sTable_A + ".PMD_AAA506_001_000_1FK7M = 'Z0002' AND";
    }
    var sTable_A = "VT_1FK7M_M00151" + sDB_Suffix;
    var sTable_B = "VT_1FK7M_M00018" + sDB_Suffix;

    var sSQL = "SELECT DISTINCT " + sTable_A + ".MLFB15_1FK7M FROM " + sTable_A +
        " INNER JOIN " + sTable_B + " ON " +
        sTable_A + ".MLFB15_1FK7M = " + sTable_B + ".MLFB15_1FK7M " +
        "WHERE " +
        sTable_A + ".UI_HALTEBREMSE_1FK7M = '" + UI_HALTEBREMSE_1FK7M + "' AND " +
        "(" + sTable_A + ".PMD_AAA506_001_000_1FK7M = 'Z0003' OR " + sTable_A + ".PMD_AAA506_001_000_1FK7M = '00004') AND " +	// Default mit Passfeder!
        sTable_A + ".HMK_VALUE_VALID_1FK7M = 'T' AND " +
        sWhereWellenende +
        sTable_B + ".HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
        sTable_B + ".HMK_VALUE_VALID_1FK7M = 'T';";

    var aResult = GetDBDataSetEXT(sSQL, "MLFB14_PARSE_Default");
    if (aResult.length > 0) {
        var MLFB15_1FK7M = aResult[0].MLFB15_1FK7M;
        return MLFB15_1FK7M;
    }
    return "ERROR";
}



function parse_1FT7(aTokens) {
    var oResult = {
        strError: '',
        strRegion: '',
        strWarning: '',
        oProduct: null,
        oParsingData: {}
    };
    /*
    MLFB-Schema
    
    MLFB01	1
    MLFB02	F
    MLFB03	K
    MLFB04	7
    MLFB05	Achshöhe 1	{03, 04, 06} entspr. AH 36, 48, 63
    MLFB06	Achshöhe 2	
    MLFB07	Baulänge {2,0}		
    MLFB08	Motortyp (Merkmal) {2} Kerntyp, Compact, Generation 2
    MLFB09	Kühlung {A} Selbstkühlung
    MLFB10	Nenndrehzahl	{H, K}  
    MLFB11	7 Zwischenkreisspannung {7} 510...720V
    MLFB12	. 1,4 Bauform	{1, 4} IM B5
    MLFB13	. 1 Anschlusstechnik Steckergröße 1; Stecker drehbar {1} 
    MLFB14	. Geber {B,C;P;Q;R;U;Z} bei Z: KAG: P4B, P4C, P4R
    MLFB15	. Wellenende / Haltebremse {U,V}	
            PMD_AAA506_001_000_1FK7M		PMD_ABU276_001_000_1FK7M bzw. UI_HALTEBREMSE_1FK7M	
    MLFB16	. Schutzart IP64 {0}		PMD_AAB007_001_000_1FT7		PMD_ABJ176_001_000_1FT7
    */
    var strBaseMLFB = aTokens[0];
    oResult.oParsingData.MLFB = {};
    oResult.oParsingData.MLFB.POS1 = strBaseMLFB.charAt(0);	//01 1
    oResult.oParsingData.MLFB.POS2 = strBaseMLFB.charAt(1);	//02 F
    oResult.oParsingData.MLFB.POS3 = strBaseMLFB.charAt(2);	//03 K
    oResult.oParsingData.MLFB.POS4 = strBaseMLFB.charAt(3);	//04 7
    oResult.oParsingData.MLFB.POS5 = strBaseMLFB.charAt(4);	//05 Achshöhe 1	{01, 02, 03, 04, 06, 08, 10} entspr. AH 36, 48, 63		UI_VT_ACHSHOEHE_1FK7M
    oResult.oParsingData.MLFB.POS6 = strBaseMLFB.charAt(5);	//06 Achshöhe 2															PMD_ACH516_001_000_1FK7M
    oResult.oParsingData.MLFB.POS7 = strBaseMLFB.charAt(6);	//07 Baulänge {0, 1, 2, 3, 4, 5, 6}										TAK_ABU212_001_000_1FK7M
    oResult.oParsingData.MLFB.POS8 = strBaseMLFB.charAt(7);	//08 Motortyp (Merkmal) {2} Kerntyp, Compact, Generation 2				PMD_AAA259_001_000_1FK7M
    oResult.oParsingData.MLFB.POS9 = strBaseMLFB.charAt(8);	//09 Kühlung {A, B, C, S} Fremdbelüftung, Selbstkühlung (S)				PMD_AAA136_001_000_1FK7M
    oResult.oParsingData.MLFB.POS10 = strBaseMLFB.charAt(9);	//10 Nenndrehzahl	{C, F, H, K}  										PMD_AAE020_001_000_1FK7M
    oResult.oParsingData.MLFB.POS11 = strBaseMLFB.charAt(10);	//11 Zwischenkreisspannung {7} 510...720V								PMD_ABJ558_001_000_1FK7M
    oResult.oParsingData.MLFB.POS12 = strBaseMLFB.charAt(11);	//12 . Bauform	{1, 4} IM B5											PMD_AAC949_001_000_1FK7M
    oResult.oParsingData.MLFB.POS13 = strBaseMLFB.charAt(12);	//13 . Anschlusstechnik Steckergröße 1; Stecker drehbar {1} 			PMD_AAB047_001_000_1FK7M
    oResult.oParsingData.MLFB.POS14 = strBaseMLFB.charAt(13); //14 . Geber {B,C;P;Q;R;U;Z} bei Z: KAG: P4B, P4C, P4R					PMD_ABU278_001_000_1FK7M
    oResult.oParsingData.MLFB.POS15 = strBaseMLFB.charAt(14); //15 . Wellenende / Haltebremse {A, B, G, H}							PMD_AAA506_001_000_1FK7M / PMD_ABU276_001_000_1FK7M/UI_HALTEBREMSE_1FK7M
    oResult.oParsingData.MLFB.POS16 = strBaseMLFB.charAt(15); //16 . Schutzart IP64 IP65, IP65 und DE Flansch IP67{0, 1, 2}			PMD_ABJ176_001_000_1FK7M

    oResult.oParsingData.MLFB.POS1_4 = strBaseMLFB.substring(0, 4);
    // MLFB05_06_08_1FK7M
    oResult.oParsingData.MLFB.POS5_6_8 = strBaseMLFB.charAt(4) + strBaseMLFB.charAt(5) + "_" + strBaseMLFB.charAt(7);
    oResult.oParsingData.RUMPF = strBaseMLFB.substring(0, 11);

    oResult.oParsingData.AH = strBaseMLFB.charAt(4) + strBaseMLFB.charAt(5); // Achshöhe MLFB5+6


    // HMK_BAUGROESSE_1FK7M 
    //aus VT78 bestimmung CFG_1FK7_MOTOR

    // Kurzangaben
    if (aTokens.length > 0) {
        if (aTokens[0] === strBaseMLFB) {
            aTokens = removeElementsFromArray(aTokens, 0, 1);
        }
        oResult.oParsingData.MLFB.KAG = aTokens || [];

        oResult.oParsingData.MLFB.KAG_LIST = getKAGAsList(aTokens);
    }

    return oResult;
}

/**
    Liefert Semicolon-getrennte Liste aller vorh. Kurzangaben
*/
function getKAGAsList(aTokens) {
    var kagString = "";
    for (var i = 0; i < aTokens.length; i++) {
        kagString += aTokens[i];
        if (i < aTokens.length - 1) {
            kagString += ";";
        }
    }
    return kagString;
}


function SetFreetextValue(field, value) {

    value = trimleft(value, '*');
    value = trimright(value, '*');

    ECL_SetValue(field, value);
}

function SetFREETEXTS(oParse) {

    /*	zur Info - oParse: 
        {
            strBaseMLFB : '',
            strFullMLFB
            strError : '',
            strWarning : '',
            aTokens : [],
            oFreetext : {}
        };
    */
    if (find(oParse.strFullMLFB, 'Y84') >= 0) {
        if (oParse.oFreetext['Y84']) SetFreetextValue('H_O_Y84_1FK7M', oParse.oFreetext['Y84']);
    }
}

function isKAGinMLFB(aArray, sKAG) {
    for (var i = 0; i < aArray.length; i++) {
        if (aArray[i] == sKAG)
            return true;
    }

    return false;
}

function checkGeber_Parser(strBaseTypeMLFB, sMLFB14, HMK_KONFIG_ZIEL_1FK7M) {
    /* 
    VT_1FK7M_M00054	UI: Geber definieren
        PMD_ABU278_001_000_1FK7M	PMD_ABU209_001_000_1FK7M	UI_GEBER_1FK7M	UI_GEBER_SMC_1FK7M	UI_GEBER_AUFLOESUNG_1FK7M	HMK_VALUE_VALID_1FK7M
    
    
    MLFB14
        alt	VT_1FK7M_M00105	ZO MLFB14 <> Geber
            MLFB14_1FK7M	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M
        neu	VT_1FK7M_M00235	ZO MLFB14 <> Geber
            neu MLFB14_1FK7M	O_N16_1006091	PMD_ABU278_001_000_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

        VT_1FK7M_M00135	ZO R72
        VT_1FK7M_M00144	ZO MLFB-Rumpf, MLFB12, Geber
            MLFB_RUMPF_01_11_1FK7M	MLFB12_1FK7M	MLFB14_1FK7M	HMK_KONFIG_ZIEL_1FK7M	HMK_VALUE_VALID_1FK7M

        VT_1FK7M_M00157	ZO gültige Geber
            HMK_KONFIG_TYP_1FK7M	MLFB05_06_08_1FK7M	MLFB12_1FK7M	MLFB14_1FK7M	(PMD_AAA717_001_000_1FK7M)	HMK_PRODUKT_ALT_AKT_1FK7M	HMK_VALUE_VALID_1FK7M
            "konfig"									{1, 4}							egal						"akt"						"T"
        VT_1FK7M_M00166	ZO N16
        VT_1FK7M_M00168	ZO R06
        VT_1FK7M_M00169	CAD N16
        VT_1FK7M_M00170	O: M03/M39 einschränken
        VT_1FK7M_M00213	Tech. Daten Umrichter Geber W
        VT_1FK7M_M00224	ZO Geber - Getriebe
    */
    // 60407: Config - 1FK7/1FT7 - Endat2.2 encoder AM25EN22 has to be removed
    if (sMLFB14 == "N") {
        return 0;
    }
    var MLFB05_06_08_1FK7M = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5) + "_" + strBaseTypeMLFB.charAt(7);
    var HMK_KONFIG_TYP_1FK7M = "konfig";
    var HMK_PRODUKT_ALT_AKT_1FK7M = "AKT";

    var sTargetAttribute = "MLFB14_1FK7M";

    var sTable = "VT_1FK7M_M00157" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_06_08_1FK7M = '" + MLFB05_06_08_1FK7M + "' AND " +
        "HMK_KONFIG_TYP_1FK7M = '" + HMK_KONFIG_TYP_1FK7M + "' AND " +
        "HMK_PRODUKT_ALT_AKT_1FK7M = '" + HMK_PRODUKT_ALT_AKT_1FK7M + "' AND " +
        "HMK_VALUE_VALID_1FK7M = 'T' AND " +
        sTargetAttribute + " = '" + sMLFB14 + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    var MLFB_RUMPF_01_11_1FK7M = strBaseTypeMLFB.substring(0, 11);
    //var HMK_KONFIG_ZIEL_1FK7M = "SERVO";

    var sTable = "VT_1FK7M_M00144" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB_RUMPF_01_11_1FK7M = '" + MLFB_RUMPF_01_11_1FK7M + "' AND " +
        "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
        "HMK_VALUE_VALID_1FK7M = 'T' AND " +
        sTargetAttribute + " = '" + sMLFB14 + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

function checkMLFB16(strBaseTypeMLFB, sMLFB16, HMK_KONFIG_ZIEL_1FK7M) {
    var ECSI_CX_IsDriveTrain = parseInt(ECL_GetValue("ECSI_CX_IsDriveTrain"));
    if (ECSI_CX_IsDriveTrain == 1 && (sMLFB16 == "2" || sMLFB16 == "5")) {
        return 0;
    }

    //VT_1FK7M_M00019	ZO gültige MLFB16
    //	MLFB05_06_1FK7M	MLFB08_1FK7M	HMK_KONFIG_ZIEL_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M
    //--------------------------------------------------------------------------------------------------------------
    var MLFB05_06_1FK7M = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5);
    var MLFB08_1FK7M = strBaseTypeMLFB.charAt(7);

    var sTargetAttribute = "MLFB16_1FK7M";
    var sTable = "VT_1FK7M_M00019" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_06_1FK7M = '" + MLFB05_06_1FK7M + "' AND " +
        "MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
        "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
        "HMK_VALUE_VALID_1FK7M = 'T' AND " +
        sTargetAttribute + " = '" + sMLFB16 + "';";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE");
    if (aResult.length < 1) {
        return 0;
    }
    //--------------------------------------------------------------------------------------------------------------
    return 1;
}

function GetMLFB16Default(strBaseTypeMLFB, HMK_KONFIG_ZIEL_1FK7M) {
    var ECSI_CX_IsDriveTrain = parseInt(ECL_GetValue("ECSI_CX_IsDriveTrain"));
    if (ECSI_CX_IsDriveTrain == 1) {
        var sWhereMLFB16 = "MLFB16_1FK7M <> '2' AND MLFB16_1FK7M <> '5' AND ";
    } else {
        var sWhereMLFB16 = "";
    }

    //VT_1FK7M_M00019	ZO gültige MLFB16
    //	MLFB05_06_1FK7M	MLFB08_1FK7M	HMK_KONFIG_ZIEL_1FK7M	MLFB16_1FK7M	HMK_VALUE_VALID_1FK7M
    //--------------------------------------------------------------------------------------------------------------
    var MLFB05_06_1FK7M = strBaseTypeMLFB.charAt(4) + strBaseTypeMLFB.charAt(5);
    var MLFB08_1FK7M = strBaseTypeMLFB.charAt(7);

    var sTargetAttribute = "MLFB16_1FK7M";
    var sTable = "VT_1FK7M_M00019" + sDB_Suffix;
    var sSQL = "SELECT " + sTargetAttribute + " FROM " + sTable + " WHERE " +
        "MLFB05_06_1FK7M = '" + MLFB05_06_1FK7M + "' AND " +
        "MLFB08_1FK7M = '" + MLFB08_1FK7M + "' AND " +
        "HMK_KONFIG_ZIEL_1FK7M = '" + HMK_KONFIG_ZIEL_1FK7M + "' AND " +
        sWhereMLFB16 +
        "HMK_VALUE_VALID_1FK7M = 'T' ORDER BY MLFB16_1FK7M;";

    var aResult = GetDBDataSetEXT(sSQL, sTable + "_PARSE_GET");
    if (aResult.length > 0) {
        return aResult[0].MLFB16_1FK7M;
    }
    //--------------------------------------------------------------------------------------------------------------
    return "0";
}