//@legacy
//#mode(full-ecma)



//@import "VT_1FN3.js"


// ---------------------------------------------------------------------------------
// Bestimme die Consequences aus einer gegebenen Konfiguration
function determineConsequences(sECSI_MLFB)
{
    /*
    ECSI_CC_HeatsinkCountPerRow		Anzahl Kühlkanäle pro Profilreihe (ECL_GetValue("ECSI_CC_HeatsinkCountPerRow");
    ECSI_CC_SecondaryCoolingType	None/Parallel/SingleSided
    ECSI_CC_CoverType				None/Continuous/Segmented
    */
    var oConsequences = {
        CountOfHeatsinkProfiles 	: getCountOfHeatsinkProfiles(),
        SecondaryCoolingSelected  	: getSecondaryCoolingSelected(),
        CoverSelected				: getCoverSelected()
    }
    return oConsequences;
}


function getCountOfHeatsinkProfiles()
{
    var iCount = parseInt(ECL_GetValue("INT_COUNT_HEATSINK_PROFILES_PER_ROW"));
    
    return iCount;
}

function getSecondaryCoolingSelected()
{
    
    /*Secondary Cooling selected (Heatsink
    None/Parallel/SingleSided
    */
    var A_HEATSINK_PROFILE_1FN3 = ECL_GetValue("A_HEATSINK_PROFILE_1FN3");
    
    var SecondaryCoolingSelected = "None";
    
    switch(A_HEATSINK_PROFILE_1FN3){
        case "NON":
            SecondaryCoolingSelected = "0"; //"None";
        break;
        case "PARALLEL":
            SecondaryCoolingSelected = "1"; //"Parallel";
        break;
        case "SINGLE":
            SecondaryCoolingSelected = "2"; //"SingleSided";
        break;
    }
    return SecondaryCoolingSelected;
}

function getCoverSelected()
{
    // ECSI_CC_CoverType				None/Continuous/Segmented
    var A_COVER_1FN3 = ECL_GetValue("A_COVER_1FN3");
    
    var CoverSelected = "None";
    
    switch(A_COVER_1FN3){
        case "NON":
            CoverSelected = "0"; //"None";
        break;
        case "CON":
            CoverSelected = "1"; //"Continuous";
        break;
        case "SEG":
            CoverSelected = "2"; //"Segmented";
        break;
    }
    return CoverSelected;
    
}
