//@legacy
//#mode(full-ecma)



//@import "VT_1FN3.js"




// 

var iCount_40;
var iCount_30;

function generateMLFB_SEC(sMLFB)
{
    
    var MLFB_RUMPF_PRI_1FN3 = ECL_GetValue("MLFB_RUMPF_PRI_1FN3");
    var MLFB_01_07_1FN3 = ECL_GetValue("MLFB_01_07_1FN3");
    
    var MLFB08_1FN3 = sMLFB.charAt(7);
    var MLFB09_1FN3 = sMLFB.charAt(8);
    var MLFB10_1FN3 = sMLFB.charAt(9);
    var MLFB11_1FN3 = sMLFB.charAt(10);
    var MLFB14_1FN3 = sMLFB.charAt(13);
    
    var i_n = 1;
    var i_t = parseInt(ECL_GetValue("ECSI_CX_SecondaryTrackCount"));
    var i_p = parseInt(ECL_GetValue("ECSI_CX_PrimaryPerTrackCount"));
    var S_COUNT = ECL_GetValue("ECSI_CX_SecondarySectionCount");
    S_COUNT = S_COUNT.replace(",",".");
    S_COUNT = parseFloat(S_COUNT);
    
    var sECSI_MLFB_SEC = "";
    /* 
    n = 1
    t = 
    p = 
    
    gererate MLFB-Sec for Components:
    - A_PRECISION_COOLER_1FN3 {NON, STD, R01}	
        VT_PREC_COOLER_1FN3
            MLFB_RUMPF_PRI_1FN3	MLFB_PREC_COOLER1_FN3	A_PRECISION_COOLER_1FN3	HMK_VALUE_VALID_1FN3
        
        MLFB_PREC_COOLER_1FN3 (opt. -Z R01)
        n = n * t * p 
    - A_HALL_SENSOR_BOX_1FN3
        n = 0 or 1
    - Sec Section articles
        - 1-n x Secondary Section Standard (per track)
        - 0-1 x Secondary Section Standard Extended (per track)
        - 1-k x Heatsink Profiles (could be several artikels if different lengths are used) (per heatsink-row per track)
        - 0-2 x Combi Distributer (per track)
        - 0-1 x Combi Adapter (per track)
        - 0-1 x Combi End Piece (per track)
        - 0-1 x Continuous Cover (per track)
        - 0-m x Cover Segements (could be several artikels if different lengths are used) (per track)
        - 0-2 x Cover End Piece (per track)
    - Safety mat with flux function
        - 0 or 4 x safety mat
    */
    
    
    // ################################################################################################################
    // Sec Section articles
    // ################################################################################################################
    /*
    Sec Section articles
        - 1-n x Secondary Section Standard (per track)
        - 0-1 x Secondary Section Standard Extended (per track)
    */
    var A_SEC_SECTION_TYPE_1FN3 = ECL_GetValue("A_SEC_SECTION_TYPE_1FN3");
    
    // MLFB_PRI_PART_1FN3	MLFB_RUMPF_PRI_1FN3	MLFB10_1FN3	MLFB11_1FN3	MLFB14_1FN3	MLFB_SEK_STD_1FN3	MLFB_SEK_EXT_1FN3	HMK_VALUE_VALID_1FN3
    var sTable = "VT_PRIM_SEK_PARTS_MAP_1FN3";
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "MLFB_RUMPF_PRI_1FN3 = '" + MLFB_RUMPF_PRI_1FN3 + "' AND " +
                "MLFB10_1FN3 = '" + MLFB10_1FN3 + "' AND " +
                "MLFB11_1FN3 = '" + MLFB11_1FN3 + "' AND " +
                "MLFB14_1FN3 = '" + MLFB14_1FN3 + "' AND " +
                "HMK_VALUE_VALID_1FN3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    
    if (aResult.length > 0){
        var MLFB_SEK_STD_1FN3 = aResult[0].MLFB_SEK_STD_1FN3;
        var MLFB_SEK_EXT_1FN3 = aResult[0].MLFB_SEK_EXT_1FN3;
    }else{
            return "ERROR";
        }
    
    if (A_SEC_SECTION_TYPE_1FN3 == "STD"){
        // only standard parts
        var iCountSTD = S_COUNT * i_t;	
        var iCountEXT = 0;
        
        ECL_Trace("MLFB_SEC: Second Section Part 'STD': " + MLFB_SEK_STD_1FN3 + "; count: " + iCountSTD);
        ECL_Trace("MLFB_SEC: No Second Section Part 'EXT'; count: " + iCountEXT);
        
        for (var i=0; i<iCountSTD; i++){
            
            if (sECSI_MLFB_SEC.length > 0){
                sECSI_MLFB_SEC += ";" + MLFB_SEK_STD_1FN3;
            }else{
                sECSI_MLFB_SEC = MLFB_SEK_STD_1FN3;
            }
        }
    }else{
        // extended part
        var iCountSTD = (S_COUNT - 1.5) * i_t;
        var iCountEXT = 1 * i_t;
        
        ECL_Trace("MLFB_SEC: Second Section Part 'STD': " + MLFB_SEK_STD_1FN3 + "; count: " + iCountSTD);
        ECL_Trace("MLFB_SEC: Second Section Part 'EXT': " + MLFB_SEK_EXT_1FN3 + "; count: " + iCountEXT);
        
        for (var i=0; i<iCountSTD; i++){
            
            if (sECSI_MLFB_SEC.length > 0){
                sECSI_MLFB_SEC += ";" + MLFB_SEK_STD_1FN3;
            }else{
                sECSI_MLFB_SEC = MLFB_SEK_STD_1FN3;
            }
        }
        if (MLFB_SEK_EXT_1FN3 != "NON"){
            if (sECSI_MLFB_SEC.length > 0){
                sECSI_MLFB_SEC += ";" + MLFB_SEK_EXT_1FN3;
            }else{
                sECSI_MLFB_SEC = MLFB_SEK_EXT_1FN3;
            }
        }else{
            return "ERROR";
        }
    }
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Präzisionskühler		 A_PRECISION_COOLER_1FN3		ECSI_CX_PrecisionCooler
    // ################################################################################################################
    /* 
    - A_PRECISION_COOLER_1FN3 {NON, STD, R01}	
        VT_PREC_COOLER_1FN3
            MLFB_RUMPF_PRI_1FN3	MLFB_PREC_COOLER_1FN3	A_PRECISION_COOLER_1FN3	HMK_VALUE_VALID_1FN3
        
        MLFB_PREC_COOLER_1FN3 (opt. -Z R01)
        n = n * t * p 
    */
    var A_PRECISION_COOLER_1FN3 = ECL_GetValue("A_PRECISION_COOLER_1FN3");
    
    if (A_PRECISION_COOLER_1FN3 != "NON")
    {
        var iCountPrecCooler = i_n * i_t * i_p;
        
        var sTable = "VT_PREC_COOLER_1FN3" + sDB_Suffix;
        // MLFB_RUMPF_PRI_1FN3	MLFB_PREC_COOLER_1FN3	A_PRECISION_COOLER_1FN3	HMK_VALUE_VALID_1FN3
        
        var sSQL = "SELECT MLFB_PREC_COOLER_1FN3 FROM " + sTable + " WHERE " +
                    "MLFB_RUMPF_PRI_1FN3 = '" + MLFB_RUMPF_PRI_1FN3 + "' AND " +
                    "A_PRECISION_COOLER_1FN3 = '" + A_PRECISION_COOLER_1FN3 + "' AND " +
                    "HMK_VALUE_VALID_1FN3 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0){
            var MLFB_PREC_COOLER_1FN3 = aResult[0].MLFB_PREC_COOLER_1FN3;
            
            ECL_Trace("MLFB_SEC: Precision cooler: " + MLFB_PREC_COOLER_1FN3 + "; count: " + iCountPrecCooler);
            
            for (var i=0; i<iCountPrecCooler; i++){
                
                if (sECSI_MLFB_SEC.length > 0){
                    sECSI_MLFB_SEC += ";" + MLFB_PREC_COOLER_1FN3;
                }else{
                    sECSI_MLFB_SEC = MLFB_PREC_COOLER_1FN3;
                }
            }
        }else{
            return "ERROR";
        }	
    }
    // ################################################################################################################
    
    
    // ################################################################################################################
    //  Sec Section articles
    // ################################################################################################################
    /*
    - Sec Section articles
        - 1-n x Secondary Section Standard (per track)
        - 0-1 x Secondary Section Standard Extended (per track)
        - 1-k x Heatsink Profiles (could be several artikels if different lengths are used) (per heatsink-row per track)
        - 0-2 x Combi Distributer (per track)
        - 0-1 x Combi Adapter (per track)
        - 0-1 x Combi End Piece (per track)
        - 0-1 x Continuous Cover (per track)
        - 0-m x Cover Segements (could be several artikels if different lengths are used) (per track)
        - 0-2 x Cover End Piece (per track)
        
        
        A_SEC_SECTION_TYPE_1FN3		Sekundär-Sektionstyp
        STD	Standard
        EXT	Standard + 1 Standard verlängert
        
        
        
        Continuous cover needs 2x an end piece that holds the cover on top of the track. If the heatsink profiles are cooled 
        with "Parallel water connection" or "Single-sided water connection" these end pieces are not needed, since the end 
        Combi distributer/adapter/end piece can also fix the cover on top of the track.
        
        Cover segments do not need an end piece to hold them. They just lay on top of the track.
        How to calculate the cover segments -> Algorithm #3
        
    */
    
    var A_COVER_1FN3 = ECL_GetValue("A_COVER_1FN3");
    var A_HEATSINK_PROFILE_1FN3 = ECL_GetValue("A_HEATSINK_PROFILE_1FN3");
    
    
    var iCountTrack = i_n * i_t;
    
    // ################################################################################################################
    // Heatsink
    // ################################################################################################################
    /*
    VT_HEATSINK_1FN3
        MLFB_01_07_1FN3	MLFB_HEATSINK_1FN3	MLFB12_HEATSINK_1FN3	MLFB14_HEATSINK_1FN3	MLFB15_HEATSINK_1FN3	S_COUNT_L_MAX_1FN3	MLFB_COMBI_DIST_1FN3	MLFB_COMBI_ADAPTER_1FN3	MLFB_COMBI_END_1FN3
    
    
    for EXT-SectionType and 1FN3300 & 1FN3450 the count is 2x per Track a 1.5 element (1FN30030TK041AB5 (L=1.5)) + Lges -1.5 x Std-Elements
    
    */
    if (A_HEATSINK_PROFILE_1FN3 !== "NON"){
        if ( MLFB_01_07_1FN3 == "1FN3050" || MLFB_01_07_1FN3 == "1FN3100" || MLFB_01_07_1FN3 == "1FN3150"){
            var Lmax = 24; // 	==> s = 1 bis 24 mit einem Profil	AB...CE 
        }else{
            //1FN3300 || 1FN3450 || 1FN3600 || 1FN3900
            var Lmax = 16; // 	==> s = 1 bis 16 mit einem Profil	AB...BG (for 1FN3300 & 1FN3450 + EXT: 17.5 mit 2 Profilen)
        }
        
        if (A_SEC_SECTION_TYPE_1FN3 == "STD"){
            var dCountProfiles = S_COUNT / Lmax;
            var dCountProfilesEXT = 0;
            //if (dCountProfiles > 1)
            var intCountProfiles = Math.ceil(dCountProfiles);
            
            
            var iRest = S_COUNT % intCountProfiles;
            
            if (iRest > 0){
                // ungleiche Profile
                var iCount1 = intCountProfiles -1;
                var iCount2 = 1;
                if (intCountProfiles > 2){
                    var iCountL1 = Lmax;
                }else{
                    var iCountL1 = Math.ceil(S_COUNT / intCountProfiles);
                }
                var iCountL2 = S_COUNT - ((intCountProfiles - 1) * iCountL1);
            }else{
                // gleiche Profile
                var iCount1 = intCountProfiles;
                var iCount2 = 0;
                var iCountL1 = S_COUNT / intCountProfiles;
                var iCountL2 = 0;
            }
        }else{
            if (S_COUNT == 1.5){
                var dCountProfiles = 0;
                var dCountProfilesEXT = 1;
            }else{
                var dCountProfiles = (S_COUNT - 1.5) / Lmax;
                var dCountProfilesEXT = 1;
            }
            
            
            //if (dCountProfiles > 1)
            var intCountProfiles = Math.ceil(dCountProfiles);
            
            
            var iRest = (S_COUNT-1.5) % intCountProfiles;
            
            if (iRest > 0){
                // ungleiche Profile
                var iCount1 = intCountProfiles -1;
                var iCount2 = 1;
                if (intCountProfiles > 2){
                    var iCountL1 = Lmax;
                }else{
                    var iCountL1 = Math.ceil((S_COUNT-1.5) / intCountProfiles);
                }
                var iCountL2 = (S_COUNT-1.5) - ((intCountProfiles - 1) * iCountL1);
            }else{
                // gleiche Profile
                var iCount1 = intCountProfiles;
                var iCount2 = 0;
                var iCountL1 = (S_COUNT-1.5) / intCountProfiles;
                var iCountL2 = 0;
            }
            
        }
        
        ECL_SetValue("INT_COUNT_HEATSINK_PROFILES_PER_ROW", intCountProfiles);
        /*
        Order the article(s) once for each cooling row:
            1FN3050 ... 1FN3450: Need 2 cooling rows per secondary section track
            1FN3600 & 1FN3900: Need 3 cooling rows per secondary section track
        */
        var iFactorRows = 2;
        if (MLFB_01_07_1FN3 == "1FN3600" || MLFB_01_07_1FN3 == "1FN3900"){
            iFactorRows = 3;
        }
        
        //MLFB_01_07_1FN3	MLFB_HEATSINK_1FN3	MLFB12_HEATSINK_1FN3	MLFB14_HEATSINK_1FN3	MLFB15_HEATSINK_1FN3	S_COUNT_L_MAX_1FN3	
        //	MLFB_COMBI_DIST_1FN3	MLFB_COMBI_ADAPTER_1FN3	MLFB_COMBI_END_1FN3
        
        if (iCountL1 > 0){
            var sTable = "VT_HEATSINK_1FN3";
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                        "MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
                        "S_COUNT_L_MAX_1FN3 = " + iCountL1 + " AND " +
                        "HMK_VALUE_VALID_1FN3 = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0){
                var MLFB_HEATSINK_1FN3 = aResult[0].MLFB_HEATSINK_1FN3;
                
                var iCount1_final = iFactorRows * i_t * iCount1;
                
                ECL_Trace("MLFB_SEC: Heatsink profiles L1: " + MLFB_HEATSINK_1FN3 + "; count per row: " + iCount1 + "; count_over_all: " + iCount1_final);
                
                for (var i=0; i<iCount1_final; i++){
                    
                    if (sECSI_MLFB_SEC.length > 0){
                        sECSI_MLFB_SEC += ";" + MLFB_HEATSINK_1FN3;
                    }else{
                        sECSI_MLFB_SEC = MLFB_HEATSINK_1FN3;
                    }
                }
                // for extended profiles add 2 extended elements per track 1FN30030TK041AB5
                if (A_SEC_SECTION_TYPE_1FN3 == "EXT"){
                    
                    var iCount1b_final = iFactorRows * i_t; // 2 per track
                    
                    var MLFB_HEATSINK_EXT_1FN3 = "1FN30030TK041AB5";
                    
                    for (var i=0; i<iCount1_final; i++){
                        
                        if (sECSI_MLFB_SEC.length > 0){
                            sECSI_MLFB_SEC += ";" + MLFB_HEATSINK_EXT_1FN3;
                        }else{
                            sECSI_MLFB_SEC = MLFB_HEATSINK_EXT_1FN3;
                        }
                    }	
                    
                    ECL_Trace("MLFB_SEC: Heatsink profiles Extended: " + MLFB_HEATSINK_EXT_1FN3 + "; count per track(2): " + iFactorRows + "; count_over_all: " + iCount1b_final);
                }
                // Add adapters etc.
                /*
                Parallel water connection:
                    • Will order enough heatsink profiles to cover the number of secondary sections (per track) -> Algorithm #2
                    • Will order 2x Combi distributer (per track)
                Single-sided water connection:
                    • Will order enough heatsink profiles to cover the number of secondary sections (per track) -> Algorithm #2
                    • Will order 1x Combi adapter (per track)
                    • Will order 1x Combi end piece (per track)
                */
                if (A_HEATSINK_PROFILE_1FN3 == "PARALLEL"){
                    var MLFB_COMBI_DIST_1FN3 = aResult[0].MLFB_COMBI_DIST_1FN3;
                    
                    ECL_Trace("MLFB_SEC: Heatsink combi distributer: " + MLFB_COMBI_DIST_1FN3 + "; count per track: " + 2 + "; count_over_all: " + (2 * i_t) );
                    
                    for (var i=0; i < i_t ; i++){
                        if (sECSI_MLFB_SEC.length > 0){
                            sECSI_MLFB_SEC += ";" + MLFB_COMBI_DIST_1FN3;
                            sECSI_MLFB_SEC += ";" + MLFB_COMBI_DIST_1FN3;
                        }else{
                            sECSI_MLFB_SEC = MLFB_COMBI_DIST_1FN3;
                            sECSI_MLFB_SEC += ";" + MLFB_COMBI_DIST_1FN3;
                        }
                    }
                }else if (A_HEATSINK_PROFILE_1FN3 == "SINGLE"){
                    var MLFB_COMBI_ADAPTER_1FN3 = aResult[0].MLFB_COMBI_ADAPTER_1FN3;
                    var MLFB_COMBI_END_1FN3 = aResult[0].MLFB_COMBI_END_1FN3;
                    
                    ECL_Trace("MLFB_SEC: Heatsink combi adapter: " + MLFB_COMBI_ADAPTER_1FN3 + "; count per track: " + 1 + "; count_over_all: " + (1 * i_t) );
                    ECL_Trace("MLFB_SEC: Heatsink combi end piece: " + MLFB_COMBI_END_1FN3 + "; count per track: " + 1 + "; count_over_all: " + (1 * i_t) );
                
                    for (var i=0; i < i_t ; i++){
                        if (sECSI_MLFB_SEC.length > 0){
                            sECSI_MLFB_SEC += ";" + MLFB_COMBI_ADAPTER_1FN3;
                            sECSI_MLFB_SEC += ";" + MLFB_COMBI_END_1FN3;
                        }else{
                            sECSI_MLFB_SEC = MLFB_COMBI_ADAPTER_1FN3;
                            sECSI_MLFB_SEC += ";" + MLFB_COMBI_END_1FN3;
                        }
                    }
                }
            }else{
                return "ERROR";
            }
        }else{
            return "ERROR";
        }
        if (iCountL2 > 0){
            var sTable = "VT_HEATSINK_1FN3";
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                        "MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
                        "S_COUNT_L_MAX_1FN3 = " + iCountL2 + " AND " +
                        "HMK_VALUE_VALID_1FN3 = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0){
                var MLFB_HEATSINK_1FN3 = aResult[0].MLFB_HEATSINK_1FN3;
                
                var iCount2_final = iFactorRows * i_t * iCount2;
                
                ECL_Trace("MLFB_SEC: Heatsink profiles L2: " + MLFB_HEATSINK_1FN3 + "; count per row: " + iCount2 + "; count_over_all: " + iCount2_final);
                
                for (var i=0; i<iCount2_final; i++){
                    
                    if (sECSI_MLFB_SEC.length > 0){
                        sECSI_MLFB_SEC += ";" + MLFB_HEATSINK_1FN3;
                    }else{
                        sECSI_MLFB_SEC = MLFB_HEATSINK_1FN3;
                    }
                }
            }else{
                return "ERROR";
            }
        }
    }else{
        ECL_SetValue("INT_COUNT_HEATSINK_PROFILES_PER_ROW", 0);
    }
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Cover
    // ################################################################################################################
    
    // Get MLFB of cover
    if (A_COVER_1FN3 == "CON"){
        // VT_COVER_CONT_L_1FN3
        //	MLFB_01_07_1FN3	MLFB_COVER_CONTINUOUS_1FN3	MLFB14_COVER_1FN3	MLFB15_COVER_1FN3	S_COUNT
        var sTable = "VT_COVER_CONT_L_1FN3" + sDB_Suffix;
        var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                    "MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
                    "S_COUNT = '" + S_COUNT + "' AND " +
                    "HMK_VALUE_VALID_1FN3 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0){
            var MLFB_COVER_CONTINUOUS_1FN3 = aResult[0].MLFB_COVER_CONTINUOUS_1FN3;
            var MLFB14_COVER_1FN3 = aResult[0].MLFB14_COVER_1FN3;
            var MLFB15_COVER_1FN3 = aResult[0].MLFB15_COVER_1FN3;
            
            var MLFB_COVER_CONTINUOUS_FULL_1FN3 = replaceAt(MLFB_COVER_CONTINUOUS_1FN3, 13, MLFB14_COVER_1FN3);
            MLFB_COVER_CONTINUOUS_FULL_1FN3 = replaceAt(MLFB_COVER_CONTINUOUS_FULL_1FN3, 14, MLFB15_COVER_1FN3);
            
            for (var i=0; i<iCountTrack; i++){
                ECL_Trace("MLFB_SEC: Cover continuous: " + MLFB_COVER_CONTINUOUS_FULL_1FN3 + "; count per row (1): " + iCountTrack + "; count_over_all: " + (iCountTrack * i_t));
                
                if (sECSI_MLFB_SEC.length > 0){
                    sECSI_MLFB_SEC += ";" + MLFB_COVER_CONTINUOUS_FULL_1FN3;
                }else{
                    sECSI_MLFB_SEC = MLFB_COVER_CONTINUOUS_FULL_1FN3;
                }
            }
        }else{
            return "ERROR";
        }
        
        if (A_HEATSINK_PROFILE_1FN3 == "NON"){
            // Continuous cover needs 2x an end piece that holds the cover on top of the track
            // VT_COVER_MAPPING_1FN3
            // 	MLFB_01_07_1FN3	MLFB_COVER_CONTINUOUS_1FN3	MLFB_COVER_SEGMENTED_1FN3	MLFB_COVER_END_PART_1FN3	MLFB_SAFETY_MAT_1FN3	HMK_VALUE_VALID_1FN3
                
            var sTable = "VT_COVER_MAPPING_1FN3" + sDB_Suffix;
            var sSQL = "SELECT MLFB_COVER_END_PART_1FN3 FROM " + sTable + " WHERE " +
                        "MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
                        "MLFB_COVER_CONTINUOUS_1FN3 = '" + MLFB_COVER_CONTINUOUS_1FN3 + "' AND " +
                        "HMK_VALUE_VALID_1FN3 = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0){
                var MLFB_COVER_END_PART_1FN3 = aResult[0].MLFB_COVER_END_PART_1FN3;
                if (MLFB_COVER_END_PART_1FN3 != "NON"){
                    ECL_Trace("MLFB_SEC: Cover end part: " + MLFB_COVER_END_PART_1FN3 + "; count per row (2): " + 2 + "; count_over_all: " + (2 * i_t));
                    
                    for (var i=0; i < i_t ; i++){
                        if (sECSI_MLFB_SEC.length > 0){
                            sECSI_MLFB_SEC += ";" + MLFB_COVER_END_PART_1FN3;
                            sECSI_MLFB_SEC += ";" + MLFB_COVER_END_PART_1FN3;
                        }else{
                            sECSI_MLFB_SEC = MLFB_COVER_END_PART_1FN3;
                            sECSI_MLFB_SEC += ";" + MLFB_COVER_END_PART_1FN3;
                        }
                    }
                }else{
                    //return "ERROR - No Cover end part available";
                    ECL_Trace("MLFB_SEC: No cover end parts available!");
                }
            }else{
                return "ERROR";
            }
        }
        
    }else if (A_COVER_1FN3 == "SEG"){
        /*
        // ########################################################################
        // ALGORITHM #3
        // ########################################################################
        Input: 
            s	
            A_COVER_1FN3 (Continuous, Segmented)
        
        If Secondary section type == Standard		A_SEC_SECTION_TYPE_1FN3 == "STD"
            The segments have to be selected in a way that the contact point in the segments is not directly above a contact point of two secondary segments.
                - So the first and last cover segment has to be a variant with X.5 length
                - Prefer long segments over short ones -> Goal to have as less interruptions as possible
                - Prefer two identical start and end pieces, if possible -> Goal to ease ordering and installation
                - Prefer identical segments in between, if possible -> Goal to ease ordering and installation
        */
        var iCountL25 = 0;
        var iCountL30 = 0;
        var iCountL35 = 0;
        var iCountL40 = 0;
        var iCountL50 = 0;
        var iCountL55 = 0;
        var iCountL65 = 0;
        
        if (MLFB_01_07_1FN3 == "1FN3600" || MLFB_01_07_1FN3 == "1FN3900"){
            var dLmax = 6.5;
            var b55_65_possible = true;
            var sTable = "VT_COVER_CALC_B";
        }else{
            var dLmax = 5;
            var b55_65_possible = false;
            var sTable = "VT_COVER_CALC_A";
        }
        
        if (S_COUNT >= 2.5 && S_COUNT < 21 && S_COUNT != 4.5){
            
            var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                        "LENGTH_S = " + S_COUNT + " ;";
            
            var aResult = GetDBDataSetEXT(sSQL);
            
            if (aResult.length > 0){
                var iCountL25 = aResult[0].COVER_2_5;
                var iCountL30 = aResult[0].COVER_3;
                var iCountL35 = aResult[0].COVER_3_5;
                var iCountL40 = aResult[0].COVER_4;
                var iCountL50 = aResult[0].COVER_5;
                var iCountL55 = 0;
                var iCountL65 = 0;
                
                if (sTable == "VT_COVER_CALC_B"){
                    iCountL55 = aResult[0].COVER_5_5;
                    iCountL65 = aResult[0].COVER_6_5;
                }
            }else{
                return "ERROR";
            }
        }else if (S_COUNT > 20.5 && S_COUNT != 4.5){
            //ab 21
            // for only STD-Elements
            if (A_SEC_SECTION_TYPE_1FN3 == "STD"){
                
                // two x.5 elements needed
                // for solutions with 5.5 and 6.5 elements
                if (b55_65_possible){
                    /*
                    var dL25 = 2.5;
                    var dL30 = 3;
                    var dL35 = 3.5;
                    var dL40 = 4;
                    var dL50 = 5;
                    var dL55 = 5.5;
                    var dL65 = 6.5;
                    */
                    
                    // case 1: 2 x 2.5 		= 5
                    // case 2: 2.5 + 3.5 	= 6
                    // case 3: 2 x 3.5 		= 7
                    // case 4: 2.5 + 5.5 	= 8
                    // case x: 3.5 + 5.5 	= 9	
                    // case 5: 2.5 + 6.5 	= 9 prefer
                    // case 6: 3.5 + 6.5	=10
                    // case 7: 2 x 5.5		=11
                    // case 8: 5.5 + 6.5	=12
                    // case 9: 2 x 6.5		=13
                    
                    
                    //ab 20
                    
                    // konkrete Berechnungsanweisungen für x0, x1, x2, x3... xx9
                    
                    var toText = S_COUNT.toString(); 	//convert to string
                    var lastChar = toText.slice(-1); 	//gets last character
                    //var lastDigit = +(lastChar); 		//convert last character to number
                    
                    switch(lastChar){
                        
                        case "0": // 30,40,50,...
                            // 2 x 6.5 = 13
                            iCountL65 = 2;
                            
                            // 3 x 4 = 12 | 13+12=25
                            iCountL40 = 3;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 25) / 5;
                        break;
                        
                        case "1": // 21,31,41,51,...
                            // two times 5.5 = 11
                            iCountL55 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 11) / 5;
                        break;
                        
                        case "2": // 22,32,42,52,...
                            // 5.5 + 6.5 = 12
                            iCountL55 = 1;
                            iCountL65 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 12) / 5;
                        break;
                        
                        case "3": // 23,33,43,53,...
                            // 2 x 6.5 = 13
                            iCountL65 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 13) / 5;
                        break;
                        
                        case "4": // 24,34,44,54,...
                            if (S_COUNT < 30){
                                // 2 x 5.5 = 11
                                iCountL55 = 2;
                                
                                // 2 x 4 = 8
                                iCountL40 = 2;
                                
                                // fill with 5-elements
                                iCountL50 = (S_COUNT - 11 - 8) / 5;
                            }else{
                                // 2 x 6.5 = 13
                                iCountL65 = 2;
                                
                                // 4 x 4 = 16	| 13+16=29
                                iCountL40 = 4;
                                
                                // fill with 5-elements
                                iCountL50 = (S_COUNT - 29) / 5;
                            }
                        break;
                        
                        case "5": // 25,35,45,55,...
                            // 2 x 6.5 = 13
                            iCountL65 = 2;
                            
                            // 3 x 4 = 12 | 13+12=25
                            iCountL40 = 3;
                            
                            // fill with 5-elements
                            if (S_COUNT < 30){
                                iCountL50 = 0;
                            }else{
                                iCountL50 = (S_COUNT - 25) / 5;
                            }
                        break;
                        
                        case "6": // 26,36,46,56,...
                            // 2 x 5.5 = 11
                            iCountL55 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 11) / 5;
                        break;
                        
                        case "7": // 27,37,47,57,...
                            // 5.5 + 6.5 = 12
                            iCountL55 = 1;
                            iCountL65 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 12) / 5;
                        break;
                        
                        case "8": // 28,38,48,58,...
                            // 2 x 6.5 = 13
                            iCountL65 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 13) / 5;
                        break;
                        
                        case "9": // 29,39,49,59,...
                            // 2 x 6.5 = 13
                            iCountL65 = 2;
                            
                            // 4 x 4 = 16 | 13+16=29
                            iCountL40 = 4;
                            
                            // fill with 5-elements
                            if (S_COUNT < 30){
                                iCountL50 = 0;
                            }else{
                                iCountL50 = (S_COUNT - 29) / 5;
                            }
                        break;
                    }
                }else{
                    /*
                    var dL25 = 2.5;
                    var dL30 = 3;
                    var dL35 = 3.5;
                    var dL40 = 4;
                    var dL50 = 5;
                    */
                    // case 1: 2 x 2.5 		= 5
                    // case 2: 2.5 + 3.5 	= 6
                    // case 3: 2 x 3.5 		= 7
                    
                    // konkrete Berechnungsanweisungen für x0, x1, x2, x3... xx9
                    
                    var toText = S_COUNT.toString(); 	//convert to string
                    var lastChar = toText.slice(-1); 	//gets last character
                    //var lastDigit = +(lastChar); 		//convert last character to number
                    
                    switch(lastChar){
                        
                        case "0": // 30,40,50,...
                            // 2 x 2.5 = 5
                            iCountL25 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 5) / 5;
                        break;
                        
                        case "1": // 21,31,41,51,...
                            // two times 3.5 = 7
                            iCountL35 = 2;
                            
                            // 1 x 4 = 4 | 7 + 4 = 11
                            iCountL40 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 11) / 5;
                        break;
                        
                        case "2": // 22,32,42,52,...
                            // 2 x 3.5 = 7
                            iCountL35 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 7) / 5;
                        break;
                        
                        case "3": // 23,33,43,53,...
                            if (S_COUNT == 23){
                                // 2 x 3.5 = 7
                                iCountL35 = 2;
                                
                                // fill with 4-elements
                                iCount_40 = 4;
                            }else if (S_COUNT == 33){
                                // 2 x 3.5 = 7
                                iCountL35 = 2;
                                
                                // 2 x 3 = 6 | 7+6=13
                                iCount_30 = 2;
                                
                                // fill with 5-elements
                                iCountL50 = 4;
                            }else{
                                // 2 x 3.5 = 7
                                iCountL35 = 2;
                                
                                // 4 x 4 = 16 | 7+16=23
                                iCount_40 = 4;
                                
                                // fill with 5-elements
                                iCountL50 = (S_COUNT - 23) / 5;
                            }
                        break;
                        
                        case "4": // 24,34,44,54,...
                            // 2 x 2.5 = 5
                            iCountL25 = 2;
                            
                            // 1 x 4 = 4 | 5+4 = 9
                            iCountL40 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 9) / 5;
                        break;
                        
                        case "5": // 25,35,45,55,...
                            // 2 x 2.5 = 5
                            iCountL25 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 5) / 5;
                        break;
                        
                        case "6": // 26,36,46,56,...
                            // 2 x 3.5 = 7
                            iCountL35 = 2;
                            
                            // 1 x 4 = 4 | 7+4 = 11
                            iCountL40 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 11) / 5;
                        break;
                        
                        case "7": // 27,37,47,57,...
                            // 2 x 3.5 = 7
                            iCountL35 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 7) / 5;
                        break;
                        
                        case "8": // 28,38,48,58,...
                            // 2 x 2.5 = 5
                            iCountL25 = 2;
                            
                            // 2 x 4 = 4 | 5+8 = 13
                            iCountL40 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 13) / 5;
                        break;
                        
                        case "9": // 29,39,49,59,...
                            if (S_COUNT == 29){
                                // 2 x 2.5 = 5
                                iCountL25 = 2;
                                
                                // 6 x 4 = 24 | 5+24 = 29
                                iCountL40 = 6;
                            }else if (S_COUNT == 39){
                                // 2 x 3.5 = 7
                                iCountL25 = 2;
                                
                                // 8 x 4 = 32 | 7+32=39
                                iCountL40 = 4;
                            }else{
                                // 2 x 3.5 = 7
                                iCountL25 = 2;
                                
                                // 3 x 4 = 12 | 7+12=19
                                iCountL40 = 3;
                                
                                // fill with 5-elements
                                iCountL50 = (S_COUNT - 19) / 5;
                            }
                        break;
                    }
                }
                
            }else{
                // for 1 EXT element and n STD elements
                // for S_COUNT > 21
                if (b55_65_possible){
                    /*
                    var dL25 = 2.5;
                    var dL30 = 3;
                    var dL35 = 3.5;
                    var dL40 = 4;
                    var dL50 = 5;
                    var dL55 = 5.5;
                    var dL65 = 6.5;
                    
                    // case 1: 2.5
                    // case 2: 3.5
                    // case 3: 5.5
                    // case 4: 6.5
                    */
                    
                    // one x.5 elements needed
                    // for solutions with 5.5 and 6.5 elements
                    
                    // konkrete Berechnungsanweisungen für x0, x1, x2, x3... xx9
                    
                    var toText = S_COUNT.toString(); 	//convert to string
                    var lastChar = toText.slice(-3); 	//gets last character
                    //var lastDigit = +(lastChar); 		//convert last character to number
                    
                    switch(lastChar){
                        
                        case "0.5": // 30.5,40.5,50.5,...
                            iCountL55 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 6.5) / 5;
                        break;
                        
                        case "1.5": // 31.5,41.5,51.5,...
                            iCountL65 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 6.5) / 5;
                        break;
                        
                        case "2.5": // 22.5,32.5,42.5,52.5,...
                            // 6.5
                            iCountL65 = 1;
                            
                            // 4 x 4 = 16 | 6.5+16 = 22.5
                            iCountL40 = 4;
                            
                            if (S_COUNT > 30){
                                // fill with 5-elements
                                iCountL50 = (S_COUNT - 22.5) / 5;
                            }
                        break;
                        
                        case "3.5": // 23.5,33.5,43.5,53.5,...
                            // 6.5 
                            iCountL65 = 1;
                            
                            // 3 x 4 = 12 | 6.5+12 = 18.5
                            iCountL40 = 3;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 18.5) / 5;
                        break;
                        
                        case "4.5": // 24.5,34.5,44.5,54.5,...
                            // 6.5 
                            iCountL65 = 1;
                            
                            // 2 x 4 = 8
                            iCountL40 = 2;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 14.5) / 5;
                        break;
                        
                        case "5.5": // 25.5,35.5,45.5,55.5,...
                            
                            iCountL55 = 1;
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 5.5) / 5;
                        break;
                        
                        case "6.5": // 26.5,36.5,46.5,56.5,...
                            iCountL65 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 6.5) / 5;
                        break;
                        
                        case "7.5": // 27.5,37.5,47.5,57.5,...
                            // 5.5
                            iCountL55 = 1;
                            
                            // 3 x 4 = 12 | 5.5+12 = 17.5
                            iCountL40 = 3;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 17.5) / 5;
                        break;
                        
                        case "8.5": // 28,38,48,58,...
                            // 3.5
                            iCountL35 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 3.5) / 5;
                        break;
                        
                        case "9.5": // 29,39,49,59,...
                            // 5.5
                            iCountL55 = 1;
                            
                            // 1 x 4 | 5.5+4=9.5
                            iCountL40 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 9.5) / 5;
                            
                        break;
                    }
                }else{
                    /*
                    var dL25 = 2.5;
                    var dL30 = 3;
                    var dL35 = 3.5;
                    var dL40 = 4;
                    var dL50 = 5;
                    
                    // case 1: 2.5
                    // case 2: 3.5
                    */
                    
                    // konkrete Berechnungsanweisungen für x0.5, x1.5, x2.5, x3.5... xx9.5
                    
                    var toText = S_COUNT.toString(); 	//convert to string
                    var lastChar = toText.slice(-3); 	//gets last character
                    //var lastDigit = +(lastChar); 		//convert last character to number
                        
                    switch(lastChar){
                        case "0.5": // 30.5,40.5,50.5,...
                            iCountL35 = 1;
                            iCountL40 = 3; // 3.5 + 12 = 15.5
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 15.5) / 5;
                        break;
                        
                        case "1.5": // 31.5,41.5,51.5,...
                            iCountL35 = 1;
                            iCountL40 = 2; // 3.5 + 8 = 11.5
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 11.5) / 5;
                        break;
                        
                        case "2.5": // 22.5,32.5,42.5,52.5,...
                            // 2.5
                            iCountL25 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 2.5) / 5;
                        break;
                        
                        case "3.5": // 23.5,33.5,43.5,53.5,...
                            // 3.5 
                            iCountL35 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 3.5) / 5;
                        break;
                        
                        case "4.5": // 24.5,34.5,44.5,54.5,...
                            // 3.5 
                            iCountL35 = 1;
                            
                            // 4 x 4 = 16
                            iCountL40 = 4;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 19.5) / 5;
                        break;
                        
                        case "5.5": // 25.5,35.5,45.5,55.5,...
                            iCountL35 = 1;
                            iCountL40 = 3; // 3.5 + 12 = 15.5
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 15.5) / 5;
                        break;
                        
                        case "6.5": // 26.5,36.5,46.5,56.5,...
                            iCountL35 = 1;
                            iCountL40 = 2;
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 11.5) / 5;
                        break;
                        
                        case "7.5": // 27,37,47,57,...
                            // 2.5
                            iCountL25 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 2.5) / 5;
                        break;
                        
                        case "8.5": // 28,38,48,58,...
                            // 3.5
                            iCountL35 = 1;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 3.5) / 5;
                        break;
                        
                        case "9.5": // 29,39,49,59,...
                            // 3.5
                            iCountL35 = 1;
                            
                            // 4 x 4 = 16 | 3.5+16=19.5
                            iCountL40 = 4;
                            
                            // fill with 5-elements
                            iCountL50 = (S_COUNT - 19.5) / 5;
                        break;
                    }
                }
            }
        }
        
        //set MLFB_Sec
        
        var sTable = "VT_COVER_MAPPING_1FN3" + sDB_Suffix;
        var sSQL = "SELECT MLFB_COVER_SEGMENTED_1FN3 FROM " + sTable + " WHERE " +
                    "MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
                    "HMK_VALUE_VALID_1FN3 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0){
            var MLFB_COVER_SEGMENTED_1FN3 = aResult[0].MLFB_COVER_SEGMENTED_1FN3;
        }else{
            return "ERROR";
        }
        
        
        if (iCountL25 > 0){
            var MLFB15_COVER_SEG_1FN3 = "C";
            var MLFB16_COVER_SEG_1FN3 = "5";
            
            var MLFB_COVER_SEGMENTED_25 = replaceAt(MLFB_COVER_SEGMENTED_1FN3, 14, MLFB15_COVER_SEG_1FN3);
            MLFB_COVER_SEGMENTED_25 = replaceAt(MLFB_COVER_SEGMENTED_25, 15, MLFB16_COVER_SEG_1FN3);
            
            ECL_Trace("MLFB_SEC: Cover segmented L=2,5: " + MLFB_COVER_SEGMENTED_25 + "; count per row: " + iCountL25 + "; count_over_all: " + (iCountL25 * i_t));
            
            for (var j=0; j<i_t; j++){
                for (var i=0; i<iCountL25; i++){
                    if (sECSI_MLFB_SEC.length > 0){
                        sECSI_MLFB_SEC += ";" + MLFB_COVER_SEGMENTED_25;
                    }else{
                        sECSI_MLFB_SEC = MLFB_COVER_SEGMENTED_25;
                    }
                }
            }
        }
        if (iCountL30 > 0){
            var MLFB15_COVER_SEG_1FN3 = "D";
            var MLFB16_COVER_SEG_1FN3 = "0";
            
            var MLFB_COVER_SEGMENTED_30 = replaceAt(MLFB_COVER_SEGMENTED_1FN3, 14, MLFB15_COVER_SEG_1FN3);
            MLFB_COVER_SEGMENTED_30 = replaceAt(MLFB_COVER_SEGMENTED_30, 15, MLFB16_COVER_SEG_1FN3);
            
            ECL_Trace("MLFB_SEC: Cover segmented L=3,0: " + MLFB_COVER_SEGMENTED_30 + "; count per row: " + iCountL30 + "; count_over_all: " + (iCountL30 * i_t));
            
            for (var j=0; j<i_t; j++){
                for (var i=0; i<iCountL30; i++){
                    
                    if (sECSI_MLFB_SEC.length > 0){
                        sECSI_MLFB_SEC += ";" + MLFB_COVER_SEGMENTED_30;
                    }else{
                        sECSI_MLFB_SEC = MLFB_COVER_SEGMENTED_30;
                    }
                }
            }
        }
        if (iCountL35 > 0){
            var MLFB15_COVER_SEG_1FN3 = "D";
            var MLFB16_COVER_SEG_1FN3 = "5";
            
            var MLFB_COVER_SEGMENTED_35 = replaceAt(MLFB_COVER_SEGMENTED_1FN3, 14, MLFB15_COVER_SEG_1FN3);
            MLFB_COVER_SEGMENTED_35 = replaceAt(MLFB_COVER_SEGMENTED_35, 15, MLFB16_COVER_SEG_1FN3);
            
            ECL_Trace("MLFB_SEC: Cover segmented L=3,5: " + MLFB_COVER_SEGMENTED_35 + "; count per row: " + iCountL35 + "; count_over_all: " + (iCountL35 * i_t));
            
            for (var j=0; j<i_t; j++){
                for (var i=0; i<iCountL35; i++){
                    
                    if (sECSI_MLFB_SEC.length > 0){
                        sECSI_MLFB_SEC += ";" + MLFB_COVER_SEGMENTED_35;
                    }else{
                        sECSI_MLFB_SEC = MLFB_COVER_SEGMENTED_35;
                    }
                }
            }
        }
        if (iCountL40 > 0){
            var MLFB15_COVER_SEG_1FN3 = "E";
            var MLFB16_COVER_SEG_1FN3 = "0";
            
            var MLFB_COVER_SEGMENTED_40 = replaceAt(MLFB_COVER_SEGMENTED_1FN3, 14, MLFB15_COVER_SEG_1FN3);
            MLFB_COVER_SEGMENTED_40 = replaceAt(MLFB_COVER_SEGMENTED_40, 15, MLFB16_COVER_SEG_1FN3);
            
            ECL_Trace("MLFB_SEC: Cover segmented L=4,0: " + MLFB_COVER_SEGMENTED_40 + "; count per row: " + iCountL40 + "; count_over_all: " + (iCountL40 * i_t));
            
            for (var j=0; j<i_t; j++){
                for (var i=0; i<iCountL40; i++){
                    
                    if (sECSI_MLFB_SEC.length > 0){
                        sECSI_MLFB_SEC += ";" + MLFB_COVER_SEGMENTED_40;
                    }else{
                        sECSI_MLFB_SEC = MLFB_COVER_SEGMENTED_40;
                    }
                }
            }
        }
        
        if (iCountL50 > 0){
            var MLFB15_COVER_SEG_1FN3 = "F";
            var MLFB16_COVER_SEG_1FN3 = "0";
            
            var MLFB_COVER_SEGMENTED_50 = replaceAt(MLFB_COVER_SEGMENTED_1FN3, 14, MLFB15_COVER_SEG_1FN3);
            MLFB_COVER_SEGMENTED_50 = replaceAt(MLFB_COVER_SEGMENTED_50, 15, MLFB16_COVER_SEG_1FN3);
            
            ECL_Trace("MLFB_SEC: Cover segmented L=5,0: " + MLFB_COVER_SEGMENTED_50 + "; count per row: " + iCountL50 + "; count_over_all: " + (iCountL50 * i_t));
            
            for (var j=0; j<i_t; j++){
                for (var i=0; i<iCountL50; i++){
                    
                    if (sECSI_MLFB_SEC.length > 0){
                        sECSI_MLFB_SEC += ";" + MLFB_COVER_SEGMENTED_50;
                    }else{
                        sECSI_MLFB_SEC = MLFB_COVER_SEGMENTED_50;
                    }
                }
            }
        }
        if (iCountL55 > 0){
            var MLFB15_COVER_SEG_1FN3 = "F";
            var MLFB16_COVER_SEG_1FN3 = "5";
            
            var MLFB_COVER_SEGMENTED_55 = replaceAt(MLFB_COVER_SEGMENTED_1FN3, 14, MLFB15_COVER_SEG_1FN3);
            MLFB_COVER_SEGMENTED_55 = replaceAt(MLFB_COVER_SEGMENTED_55, 15, MLFB16_COVER_SEG_1FN3);
            
            ECL_Trace("MLFB_SEC: Cover segmented L=5,5: " + MLFB_COVER_SEGMENTED_55 + "; count per row: " + iCountL55 + "; count_over_all: " + (iCountL55 * i_t));
            
            for (var j=0; j<i_t; j++){
                for (var i=0; i<iCountL55; i++){
                    
                    if (sECSI_MLFB_SEC.length > 0){
                        sECSI_MLFB_SEC += ";" + MLFB_COVER_SEGMENTED_55;
                    }else{
                        sECSI_MLFB_SEC = MLFB_COVER_SEGMENTED_55;
                    }
                }
            }
        }
        if (iCountL65 > 0){
            var MLFB15_COVER_SEG_1FN3 = "G";
            var MLFB16_COVER_SEG_1FN3 = "5";
            
            var MLFB_COVER_SEGMENTED_65 = replaceAt(MLFB_COVER_SEGMENTED_1FN3, 14, MLFB15_COVER_SEG_1FN3);
            MLFB_COVER_SEGMENTED_65 = replaceAt(MLFB_COVER_SEGMENTED_65, 15, MLFB16_COVER_SEG_1FN3);
            
            ECL_Trace("MLFB_SEC: Cover segmented L=6,5: " + MLFB_COVER_SEGMENTED_65 + "; count per row: " + iCountL65 + "; count_over_all: " + (iCountL65 * i_t));
            
            for (var j=0; j<i_t; j++){
                for (var i=0; i<iCountL65; i++){
                    
                    if (sECSI_MLFB_SEC.length > 0){
                        sECSI_MLFB_SEC += ";" + MLFB_COVER_SEGMENTED_65;
                    }else{
                        sECSI_MLFB_SEC = MLFB_COVER_SEGMENTED_65;
                    }
                }
            }
        }
        
    }
    // ################################################################################################################
    
    
    // ################################################################################################################
    // Bestellpaket mit 4 Einheiten		A_SAFETY_MAT_FLUX_1FN3
    // ################################################################################################################
    /*
    Only avaiable for 1FN3300 & 1FN3450
    
    Has to be ordered with 4 units.
    */
    
    if ((MLFB_01_07_1FN3 == "1FN3300" || MLFB_01_07_1FN3 == "1FN3450") && ECL_ValueSelected("A_SAFETY_MAT_FLUX_1FN3", "T")){
        
        // MLFB_01_07_1FN3	MLFB_COVER_CONTINUOUS_1FN3	MLFB_COVER_SEGMENTED_1FN3	MLFB_COVER_END_PART_1FN3	MLFB_SAFETY_MAT_1FN3	HMK_VALUE_VALID_1FN3
        var sTable = "VT_COVER_MAPPING_1FN3";
        var sSQL = "SELECT MLFB_SAFETY_MAT_1FN3 FROM " + sTable + " WHERE " +
                    "MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
                    "MLFB_SAFETY_MAT_1FN3 <> 'NON' AND " +
                    "HMK_VALUE_VALID_1FN3 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0){
            
            var MLFB_SAFETY_MAT_1FN3 = aResult[0].MLFB_SAFETY_MAT_1FN3;
            
            ECL_Trace("MLFB_SEC: Safety mat flux: " + MLFB_SAFETY_MAT_1FN3 + "; count: 4");
            
            for (var i=0; i<4; i++){
                
                if (sECSI_MLFB_SEC.length > 0){
                    sECSI_MLFB_SEC += ";" + MLFB_SAFETY_MAT_1FN3;
                }else{
                    sECSI_MLFB_SEC = MLFB_SAFETY_MAT_1FN3;
                }
            }
            
        }else{
            return "ERROR";
        }
    }
    // ################################################################################################################
    
    
    
    
    
    // ################################################################################################################
    // ################################################################################################################
    return sECSI_MLFB_SEC;
}