//@legacy
//#mode(full-ecma)

//@import "VT_1FN3.js"

function SetMotorPrimPart_Init(oData) {
  /*
    Leistungs- und Signalanschluss	A_POWER_SIGNAL_CONNECTION_1FN3					MLFB14_1FN3
    */

  if (oData && !isEmpty(oData)) {
    SetCoolingMethod(oData);
    SetPOWER_SIGNAL_CONNECTION(oData);
  } else {
    ExecSetStandardifValueEmpty("A_POWER_SIGNAL_CONNECTION_1FN3", "00001");
  }
  return oData;
}

// ####################################################################################################################
/**

*/
function SetCoolingMethod(oData) {
  // Edit 06/2024 MLFB09 not longer valid, only context variable
  // var MLFB09_1FN3 = oData.oParsingData.MLFB.MLFB09;
  // from context attribute
  var ECSI_CX_CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor");

  ECL_DeactivateAllAttributeValues("A_COOLING_METHOD");
  // water cooling
  if (ECSI_CX_CoolingMethodMotor == "2") {
    ECL_ActivateValue("A_COOLING_METHOD", "W");
    ECL_SelectValue("A_COOLING_METHOD", "W");
  } else {
    // natural cooling
    ECL_ActivateValue("A_COOLING_METHOD", "S");
    ECL_SelectValue("A_COOLING_METHOD", "S");
  }
}
// ####################################################################################################################

function SetPOWER_SIGNAL_CONNECTION(oData) {
  // VT_MLFB14_MAP_CON_1FN3	MLFB14 - Attribut Übersetzung
  //	MLFB14_1FN3	A_POWER_SIGNAL_CONNECTION_1FN3	HMK_VALUE_VALID_1FN3

  var MLFB09_1FN3 = oData.oParsingData.MLFB.MLFB09;
  var MLFB14_1FN3 = oData.oParsingData.MLFB.MLFB14;
  var strBaseTypeMLFB = oData.strBaseTypeMLFB;

  var sTable = "VT_MLFB14_MAP_CON_1FN3" + sDB_Suffix;
  var sSQL =
    "SELECT A_POWER_SIGNAL_CONNECTION_1FN3 FROM " +
    sTable +
    " WHERE " +
    "MLFB14_1FN3 = '" +
    MLFB14_1FN3 +
    "' AND " +
    "HMK_VALUE_VALID_1FN3 = 'T';";
  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    var A_POWER_SIGNAL_CONNECTION_1FN3 =
      aResult[0].A_POWER_SIGNAL_CONNECTION_1FN3;
    if (strBaseTypeMLFB.charAt(13) != "." || MLFB09_1FN3 == "K") {
      ECL_DeactivateAllAttributeValues("A_POWER_SIGNAL_CONNECTION_1FN3");
    }
    ECL_ActivateValue(
      "A_POWER_SIGNAL_CONNECTION_1FN3",
      A_POWER_SIGNAL_CONNECTION_1FN3
    );
    ECL_SelectValue(
      "A_POWER_SIGNAL_CONNECTION_1FN3",
      A_POWER_SIGNAL_CONNECTION_1FN3
    );
  } else {
    // Error
    oData.strError +=
      " " + ECL_Translate("DICT1_ERR_1FN3___PARSER_SET_POWER_SIGNAL_CON");
  }
}
// ####################################################################################################################

// ####################################################################################################################
