//@legacy
//#mode(full-ecma)

//@import "../1FN3_MLFB/Base.misc.js"

//@import "VT_1FN3.js"

/**
    Abbildung der Produktlogik aus Variantentabellen
*/
function ExecProductLogic(strchangedAttribute) {
  var strError = "";

  var sMLFB = ECL_GetValue("ECSI_MLFB");
  var sMLFB_BASE_TYPE = ECL_GetValue("ECSI_MLFB_BASE_TYPE");

  var MLFB01_1FN3 = sMLFB.left(4); // 1FN3
  //var MLFB05_1FN3 = sMLFB.charAt(4);
  //var MLFB06_1FN3 = sMLFB.charAt(5);
  //var MLFB07_1FN3 = sMLFB.charAt(6);
  //var MLFB08_1FN3 = sMLFB.charAt(7);
  var MLFB09_1FN3 = sMLFB.charAt(8);
  var MLFB10_1FN3 = sMLFB.charAt(9);
  var MLFB11_1FN3 = sMLFB.charAt(10);
  //var MLFB12_1FN3 = sMLFB.charAt(11);
  //var MLFB13_1FN3 = sMLFB.charAt(12);
  var MLFB14_1FN3 = sMLFB.charAt(13);
  //var MLFB15_1FN3 = sMLFB.charAt(14);	// A
  //var MLFB16_1FN3 = sMLFB.charAt(15); // 3

  var MLFB_01_07_1FN3 = ECL_GetValue("MLFB_01_07_1FN3");
  var MLFB_RUMPF_PRI_1FN3 = ECL_GetValue("MLFB_RUMPF_PRI_1FN3");

  // ################################################################################################################
  // Parameter durch MLFB/SIZER vorgegeben:
  // ################################################################################################################
  /*
    ECSI_CX_PrecisionCooler						Yes/No
    ECSI_CX_SecondarySectionCount				float
    ECSI_CX_PrimaryPerTrackCount		
    ECSI_CX_SecondarySectionType				Standard/StandardAnd1StandardExtended
    ECSI_CX_SecondaryTrackCount					int
    ECSI_CX_HeatsinkProfilesSelected			Yes/No
    */
  var ECSI_CX_PrecisionCooler = ECL_GetValue("ECSI_CX_PrecisionCooler");
  var ECSI_CX_SecondaryTrackCount = parseInt(ECL_GetValue("ECSI_CX_SecondaryTrackCount"));
  var ECSI_CX_PrimaryPerTrackCount = parseInt(ECL_GetValue("ECSI_CX_PrimaryPerTrackCount"));
  var ECSI_CX_SecondarySectionType = ECL_GetValue("ECSI_CX_SecondarySectionType");
  var ECSI_CX_SecondarySectionCount = ECL_GetValue("ECSI_CX_SecondarySectionCount");
  //var ECSI_CX_HeatsinkProfilesSelected 		= ECL_GetValue("ECSI_CX_HeatsinkProfilesSelected");

  // ################################################################################################################

  ECSI_CX_SecondarySectionCount = ECSI_CX_SecondarySectionCount.replace(",", ".");
  ECSI_CX_SecondarySectionCount = parseFloat(ECSI_CX_SecondarySectionCount);

  var A_SEC_SECTION_TYPE_1FN3 = ECL_GetValue("A_SEC_SECTION_TYPE_1FN3");

  // ################################################################################################################
  // Leistungs- und Signalanschluss	A_POWER_SIGNAL_CONNECTION_1FN3					MLFB14_1FN3
  // ################################################################################################################
  /*	VT_PRIM_SEK_PARTS_MAP_1FN3
            MLFB_RUMPF_PRI_1FN3	MLFB10_1FN3	MLFB11_1FN3	MLFB14_1FN3	MLFB_SEK_STD_1FN3	MLFB_SEK_EXT_1FN3	HMK_VALUE_VALID_1FN3
        
        VT_MLFB14_MAP_CON_1FN3		Translation
            MLFB14_1FN3	A_POWER_SIGNAL_CONNECTION_1FN3	HMK_VALUE_VALID_1FN3
        
    */
  if (sMLFB_BASE_TYPE.charAt(13) == ".") {
    var sTargetAttribute = "MLFB14_1FN3";

    var sTable = "VT_PRIM_SEK_PARTS_MAP_1FN3" + sDB_Suffix;
    var sWhere =
      "MLFB_RUMPF_PRI_1FN3 = '" +
      MLFB_RUMPF_PRI_1FN3 +
      "' AND " +
      "MLFB10_1FN3 = '" +
      MLFB10_1FN3 +
      "' AND " +
      "MLFB11_1FN3 = '" +
      MLFB11_1FN3 +
      "' AND " +
      "HMK_VALUE_VALID_1FN3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1FN3___PL_POWER_SIGNAL_CON_NO_DB_RESULT";
      return strError;
    }
    // -----------------------------------------------------------------------------------
    // Übertrag in A_POWER_SIGNAL_CONNECTION_1FN3
    //Übersetzung MLFB14_1FN3 Where-Klausel
    var aValidValuesMLFB14 = ECL_GetAllActiveAttributeValues("MLFB14_1FN3");
    var sWhereMLFB14 = "MLFB14_1FN3 = '" + aValidValuesMLFB14[0] + "'";

    if (aValidValuesMLFB14.length > 1) {
      for (var i = 1; i < aValidValuesMLFB14.length; i++) {
        sWhereMLFB14 = sWhereMLFB14 + " OR MLFB14_1FN3 = '" + aValidValuesMLFB14[i] + "'";
      }
    }
    sWhereMLFB14 = "(" + sWhereMLFB14 + ") AND ";

    // -----------------------------------------------------------------------------------

    var sTargetAttribute = "A_POWER_SIGNAL_CONNECTION_1FN3";

    var sTable = "VT_MLFB14_MAP_CON_1FN3" + sDB_Suffix;
    var sWhere = sWhereMLFB14 + "HMK_VALUE_VALID_1FN3 = 'T';";

    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);

    if (sStatus == "Error") {
      // Fehler
      strError = "DICT1_ERR_1FN3___PL_POWER_SIGNAL_CON_NO_DB_RESULT";
      return strError;
    }

    // -----------------------------------------------------------------------------------
    // MLFB14_1FN3 aktualisieren
    var A_POWER_SIGNAL_CONNECTION_1FN3 = ECL_GetValue("A_POWER_SIGNAL_CONNECTION_1FN3");

    var sTable = "VT_MLFB14_MAP_CON_1FN3" + sDB_Suffix;
    var sSQL =
      "SELECT MLFB14_1FN3 FROM " +
      sTable +
      " WHERE " +
      "A_POWER_SIGNAL_CONNECTION_1FN3 = '" +
      A_POWER_SIGNAL_CONNECTION_1FN3 +
      "' AND " +
      "HMK_VALUE_VALID_1FN3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      MLFB14_1FN3 = aResult[0].MLFB14_1FN3;
    } else {
      strError = "DICT1_ERR_1FN3___PL_MLFB14_NO_DB_RESULT";
    }

    sMLFB = replaceAt(sMLFB, 13, MLFB14_1FN3);

    ECL_SetValue("ECSI_MLFB", sMLFB);
  } else {
    // Condition handled in the parser
  }
  // ################################################################################################################

  // ################################################################################################################
  // Präzisionskühler		 A_PRECISION_COOLER_1FN3		ECSI_CX_PrecisionCooler
  // ################################################################################################################
  /*	ECSI_CX_PrecisionCooler		Yes/No
    
        if Context ECSI_CX_CoolingMethodMotor == "2"  // water-cooling
            available
        else disable, set non
    */
  var ECSI_CX_CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor");
  var ECSI_CX_PrecisionCooler = ECL_GetValue("ECSI_CX_PrecisionCooler");

  if (ECSI_CX_CoolingMethodMotor == "2") {
    ECL_EnableAttribute("A_PRECISION_COOLER_1FN3");

    if (ECSI_CX_PrecisionCooler == "1" || ECSI_CX_PrecisionCooler == "Yes" || ECSI_CX_PrecisionCooler == "true") {
      ECL_ActivateAllAttributeValues("A_PRECISION_COOLER_1FN3");
      ECL_DeactivateValue("A_PRECISION_COOLER_1FN3", "NON");

      var sTargetAttribute = "A_PRECISION_COOLER_1FN3";

      var sTable = "VT_PREC_COOLER_1FN3" + sDB_Suffix;
      var sWhere = "MLFB_RUMPF_PRI_1FN3 = '" + MLFB_RUMPF_PRI_1FN3 + "' AND " + "HMK_VALUE_VALID_1FN3 = 'T';";

      var sStatus = SetAttributeLogic2nd(sTable, sTargetAttribute, sWhere);

      if (sStatus == "Error") {
        // Fehler
        strError = "DICT1_ERR_1FN3___PL_PREC_COOLER_NO_DB_RESULT";
        return strError;
      }
    } else {
      ECL_DeactivateAllAttributeValues("A_PRECISION_COOLER_1FN3");
      ECL_ActivateValue("A_PRECISION_COOLER_1FN3", "NON");
      ECL_SelectValue("A_PRECISION_COOLER_1FN3", "NON");
    }
  } else {
    ECL_DeactivateAllAttributeValues("A_PRECISION_COOLER_1FN3");
    ECL_ActivateValue("A_PRECISION_COOLER_1FN3", "NON");
    ECL_SelectValue("A_PRECISION_COOLER_1FN3", "NON");

    if (ECSI_CX_PrecisionCooler == "1" || ECSI_CX_PrecisionCooler == "Yes" || ECSI_CX_PrecisionCooler == "true") {
      strError = "DICT1_ERR_1FN3___PL_PREC_COOLER_CONTEXT";
      return strError;
    }
  }

  // ################################################################################################################

  // ################################################################################################################
  // Sekundär-Sektionstyp		A_SEC_SECTION_TYPE_1FN3
  // ################################################################################################################
  /*
        A_SEC_SECTION_TYPE_1FN3		Sekundär-Sektionstyp
            STD	Standard							(DEFAULT)
            EXT	Standard + 1 Standard verlängert
        
        
        for 1FN3050 ... 1FN3150 && 1FN3600 ... 1FN3900
        only STD is available
        
        for 1FN3300 ... 1FN3450 EXT is allowed also
        
        VT_SEC_SECTION_TYPE_1FN3
            MLFB_01_07_1FN3	A_SEC_SECTION_TYPE_1FN3	HMK_VALUE_VALID_1FN3
        
    * /
    
    // Setted by context attribute
    var sTargetAttribute = "A_SEC_SECTION_TYPE_1FN3";
    
    
    var sTable = "VT_SEC_SECTION_TYPE_1FN3" + sDB_Suffix;
    var sWhere = 	"MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
                    "HMK_VALUE_VALID_1FN3 = 'T';";
    
    var sStatus = SetAttributeLogic1st(sTable, sTargetAttribute, sWhere);
    
    if (sStatus == "Error"){
        // Fehler
        strError = "DICT1_ERR_1FN3___PL_SEC_SECTION_TYPE_NO_DB_RESULT";
        return strError;
    }
    */
  // ################################################################################################################
  var A_SEC_SECTION_TYPE_1FN3 = ECL_GetValue("A_SEC_SECTION_TYPE_1FN3");

  // ################################################################################################################
  // Kühlkörperprofil			A_HEATSINK_PROFILE_1FN3
  // ################################################################################################################
  /*
    ECSI_CX_HeatsinkProfiles		Yes/No (true/false)
    
    A_HEATSINK_PROFILE_1FN3		Kühlkörperprofil

        NON			Ohne
        PARALLEL	Paralleler Wasseranschluss
        SINGLE		Einseitiger Wasseranschluss
    
    Water-cooling for secondary section track also available, even, if primary section is self-cooled.

    OPEN ISSUE: The current catalogs only support heatsink profiles with integral numbers. We have to await the new products with half lengths.

    Parallel water connection:
        • Will order enough heatsink profiles to cover the number of secondary sections (per track) -> Algorithm #2
        • Will order 2x Combi distributer (per track)

    Single-sided water connection:
        • Will order enough heatsink profiles to cover the number of secondary sections (per track) -> Algorithm #2
        • Will order 1x Combi adapter (per track)
        • Will order 1x Combi end piece (per track)

    Custom water connections with other heatsink profiles (whole grommet nipple topic) will not be supported in TST. 
    This would make the configuration too complex.

    1FN3050 ... 1FN3450:
        • All possibilities available
        • "None" is selected by default
        • Need 2 cooling rows per secondary section track
        • if SecSectiontype EXT: 2x half-length module added (1FN3300 && 1FN3450 only)

    1FN3600 & 1FN3900:
        • "Parallel water connection available" mandatory -> select and disable
        • Need 3 cooling rows per secondary section track
    
    // ########################################################################
    // ALGORITHM #2
    // ########################################################################
    Input: 
        s	
        A_HEATSINK_PROFILE_1FN3 (PARALLEL, SINGLE)
    
    Can the whole length (s) be covered with one heatsink profile?
    If yes, then order only one heatsink profile per row with the needed length.
    
    If no: How to select the right cooling profiles, if one is too short
    1. Try to order as few articles, as possible (e.g. prefer two different articles over 3 identical) -> Goal to minimize connection points to reduce pressure drop
    2. Try to find a solution with as less article variants as possible (e.g. prefer 2 identical articles over two single and different articles) -> Goal to ease ordering and installation
    
    Order the article(s) once for each cooling row:
    1FN3050 ... 1FN3450: Need 2 cooling rows per secondary section track
    1FN3600 & 1FN3900: Need 3 cooling rows per secondary section track
    
    
    if ( MLFB_01_07_1FN3 == "1FN3050" || MLFB_01_07_1FN3 == "1FN3100" || MLFB_01_07_1FN3 == "1FN3150"){
        var Lmax = 24; // 	==> s = 1 bis 24 mit einem Profil	AB...CE
    }else{
        //1FN3300 || 1FN3450 || 1FN3600 || 1FN3900
        var Lmax = 16; // 	==> s = 1 bis 16 mit einem Profil	AB...BG
    }
    
    var s = ECSI_CX_SecondarySectionCount;
    Anzahl_Profile = s / Lmax;
    
    if (Anzahl_Profile > 1)
        AnzProfil_INT = Math.ceil(Anzahl_Profile);
    else
        1
    
    iRest = S % AnzProfil_INT;
    
    if (iRest > 0){
        // ungleiche Profile
        if (AnzProfil_INT > 2){
            var L1 = Lmax;
        }else{
            var L1 = Math.ceil(S / AnzProfil_INT);
        }
        var L2 = S - ((AnzProfil_INT-1)*L1);
    }else{
        // gleiche Profile
        var L1 = S / AnzProfil_INT;
        var L2 = 0;
    }
    x = s / Lmax
    
    */

  // for 1FN3600 & 1FN3900 "PARALLEL" is mandatory
  if (MLFB_01_07_1FN3 == "1FN3600" || MLFB_01_07_1FN3 == "1FN3900") {
    ECL_DeactivateAllAttributeValues("A_HEATSINK_PROFILE_1FN3");
    ECL_ActivateValue("A_HEATSINK_PROFILE_1FN3", "PARALLEL");
    ECL_SelectValue("A_HEATSINK_PROFILE_1FN3", "PARALLEL");
  } else {
    // check context-parameter for heatsink
    var ECSI_CX_HeatsinkProfiles = ECL_GetValue("ECSI_CX_HeatsinkProfiles");

    if (ECSI_CX_HeatsinkProfiles == "true" || ECSI_CX_HeatsinkProfiles == "1") {
      ECL_ActivateAllAttributeValues("A_HEATSINK_PROFILE_1FN3");
      ECL_DeactivateValue("A_HEATSINK_PROFILE_1FN3", "NON");
    } else {
      ECL_DeactivateAllAttributeValues("A_HEATSINK_PROFILE_1FN3");
      ECL_ActivateValue("A_HEATSINK_PROFILE_1FN3", "NON");
    }

    /* parallel or single?
        1FN3050 ... 1FN3450:
            • All possibilities available
            • "None" is selected by default
            • Need 2 cooling rows per secondary section track
            
            1FN3300 & 1FN3450 && EXT-Type 2 half-length modules needed
            
        1FN3600 & 1FN3900:
            • "Parallel water connection available" mandatory -> select and disable
            • Need 3 cooling rows per secondary section track
        */
    ExecSetStandardifValueEmpty("A_HEATSINK_PROFILE_1FN3", "NON");
  }

  // ################################################################################################################

  // ################################################################################################################
  // Abdeckung		A_COVER_1FN3
  // ################################################################################################################
  var d_s = ECSI_CX_SecondarySectionCount;
  /*
    "Continuous" is available and selected by DEFAULT, if:
        - Secondary section type == Standard		A_SEC_SECTION_TYPE_1FN3 == "STD"
        - 1FN3050 ... 1FN3150: s <= 50
        - 1FN3300 ... 1FN3900: s <= 32
    Otherwise "Segmented", is selected by DEFAULT
    */

  /*  Bugfix Set default value: Handled in parser script CFG_1FN3_SEC_PART.es
    if (A_SEC_SECTION_TYPE_1FN3 == "STD" && (
        ((MLFB_01_07_1FN3 == "1FN3300" || MLFB_01_07_1FN3 == "1FN3450" || MLFB_01_07_1FN3 == "1FN3600" || MLFB_01_07_1FN3 == "1FN3900") && d_s <= 32 ) ||
        ((MLFB_01_07_1FN3 == "1FN3050" || MLFB_01_07_1FN3 == "1FN3100" || MLFB_01_07_1FN3 == "1FN3150") && d_s <= 50 ) )
    ){
        ECL_ActivateValue("A_COVER_1FN3", "CON");
        ECL_SelectValueDefault("A_COVER_1FN3", "CON");
    }else{
        ECL_DeactivateValue("A_COVER_1FN3", "CON");
        ECL_SelectValueDefault("A_COVER_1FN3", "SEG");
    }
*/ /*
    „Segmented“ is only available, if s >= 2.5 and s != 4.5
    */
  if (d_s >= 2.5 && d_s !== 4.5) {
    ECL_ActivateValue("A_COVER_1FN3", "SEG");
  } else {
    ECL_DeactivateValue("A_COVER_1FN3", "SEG");
  }
  var d_s_max = 0;
  // no continuous cover for extended type && bis max Elemente
  if (A_SEC_SECTION_TYPE_1FN3 == "STD") {
    if (MLFB_01_07_1FN3 == "1FN3300" || MLFB_01_07_1FN3 == "1FN3450" || MLFB_01_07_1FN3 == "1FN3600" || MLFB_01_07_1FN3 == "1FN3900") {
      d_s_max = 32;
    } else if (MLFB_01_07_1FN3 == "1FN3050" || MLFB_01_07_1FN3 == "1FN3100" || MLFB_01_07_1FN3 == "1FN3150") {
      d_s_max = 50;
    }
  }

  if (A_SEC_SECTION_TYPE_1FN3 == "EXT" || d_s > d_s_max) {
    ECL_DeactivateValue("A_COVER_1FN3", "CON");
  } else {
    ECL_ActivateValue("A_COVER_1FN3", "CON");
  }
  ExecSetStandardifValueEmpty("A_COVER_1FN3", "NON");
  /*
    Continuous cover needs 2x an end piece that holds the cover on top of the track. If the heatsink profiles are cooled 
    with "Parallel water connection" or "Single-sided water connection" these end pieces are not needed, since the end 
    Combi distributer/adapter/end piece can also fix the cover on top of the track.
    
    Cover segments do not need an end piece to hold them. They just lay on top of the track.
    How to calculate the cover segments -> Algorithm #3
    
    VT_COVER_MAPPING_1FN3
        MLFB_01_07_1FN3	MLFB_COVER_CONTINUOUS_1FN3	MLFB_COVER_SEGMENTED_1FN3	MLFB_COVER_END_PART	SAFETY_MAT	HMK_VALUE_VALID_1FN3
    
    VT_COVER_CONT_L_1FN3
        MLFB_01_07_1FN3	MLFB_COVER_CONTINUOUS_1FN3	MLFB14_COVER_1FN3	MLFB15_COVER_1FN3
    
    VT_COVER_SEG_L_1FN3
        MLFB_01_07_1FN3	MLFB15_COVER_SEG_1FN3	MLFB16_COVER_SEG_1FN3	HMK_VALUE_VALID_1FN3
    
    VT_COVER_SEG_MAP_L_1FN3
        MLFB15_COVER_SEG_1FN3	MLFB16_COVER_SEG_1FN3	A_COUNT_COVER_SEG_1FN3	HMK_VALUE_VALID_1FN3
    
    
    Cover calculation 
    motors 1FN3050 - 1FN3450: VT_COVER_CALC_A
    motors 1FN3600 & 1FN3900: VT_COVER_CALC_B
    
    LENGTH_S	COVER_2_5	COVER_3	COVER_3_5	COVER_4	COVER_5	COVER_5_5	COVER_6_5	Article_count	Sum_length	Check
    2,5			1			0		0			0		0		0			0			1				2,5			OK
    3,0			0			1		0			0		0		0			0			1				3,0			OK
    3,5			0			0		1			0		0		0			0			1				3,5			OK
    4,0			0			0		0			1		0		0			0			1				4,0			OK
    
    */

  /*
    if (MLFB_01_07_1FN3 == "1FN3600" || MLFB_01_07_1FN3 == "1FN3900"){
        var sTable = "VT_COVER_CALC_B";
    }else{
        var sTable = "VT_COVER_CALC_A";
    }
    
    var sSQL = "SELECT * FROM " + sTable + " WHERE " +
                "LENGTH_S = " + ECSI_CX_SecondarySectionCount + " AND " +
                "CHECK = 'OK';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    
    if (aResult.length > 0){
        var iCount25 = aResult[0].COVER_2_5;
        var iCount30 = aResult[0].COVER_3;
        var iCount35 = aResult[0].COVER_3_5;
        var iCount40 = aResult[0].COVER_4;
        var iCount50 = aResult[0].COVER_5;
        var iCount55 = 0;
        var iCount65 = 0;
        
        if (sTable == "VT_COVER_CALC_B"){
            iCount55 = aResult[0].COVER_5_5;
            iCount65 = aResult[0].COVER_6_5;
        }
        
        if (iCount25 > 0){
            var MLFB15_COVER_SEG_1FN3 = "C";
            var MLFB16_COVER_SEG_1FN3 = "5";
            
            var 
            
        }
    }*/

  /*
    // ########################################################################
    // ALGORITHM #3
    // ########################################################################
    Input: 
        s	
        A_COVER_1FN3 (Continuous, Segmented)
    
    If Secondary section type == Standard		A_SEC_SECTION_TYPE_1FN3 == "STD"
        The segments have to be selected in a way that the contact point in the segments is not directly above a contact point of two secondary segments.
            - So the first and last cover segment has to be a variant with X.5 length
            - Prefer long segments over short ones -> Goal to have as less interruptions as possible
            - Prefer two identical start and end pieces, if possible -> Goal to ease ordering and installation
            - Prefer identical segments in between, if possible -> Goal to ease ordering and installation
    */

  // ################################################################################################################
  // Bestellpaket mit 4 Einheiten		A_SAFETY_MAT_FLUX_1FN3
  // ################################################################################################################
  /*
    Only avaiable for 1FN3300 & 1FN3450
    
    Has to be ordered with 4 units.
    */
  if (MLFB_01_07_1FN3 == "1FN3300" || MLFB_01_07_1FN3 == "1FN3450") {
    ECL_EnableAttribute("A_SAFETY_MAT_FLUX_1FN3");
  } else {
    ECL_DeselectAttribute("A_SAFETY_MAT_FLUX_1FN3");
    ECL_DisableAttribute("A_SAFETY_MAT_FLUX_1FN3");
  }

  // ################################################################################################################
  // ################################################################################################################

  return "OK";
}
