//@legacy
//#mode(full-ecma)

//@import "VT_1FN3.js"

function SetMotorSecPart_Init(oData) {
  /*
    // ################################################################################################################
    // Sekundär-Sektionstyp		A_SEC_SECTION_TYPE_1FN3
    // ################################################################################################################
    /*
        A_SEC_SECTION_TYPE_1FN3		Sekundär-Sektionstyp
            STD	Standard							(DEFAULT)
            EXT	Standard + 1 Standard verlängert
        VT_SEC_SECTION_TYPE_1FN3
            MLFB_01_07_1FN3	A_SEC_SECTION_TYPE_1FN3	HMK_VALUE_VALID_1FN3
        
        ECSI_CX_SecondarySectionType				Standard/StandardAnd1StandardExtended
    
    // ################################################################################################################
    // Kühlkörperprofil			A_HEATSINK_PROFILE_1FN3
    // ################################################################################################################
    /*
    not implemented: ECSI_CX_HeatsinkProfilesSelected		/Yes/No
    
    
    // ################################################################################################################
    // Bestellpaket mit 4 Einheiten		A_SAFETY_MAT_FLUX_1FN3
    // ################################################################################################################
    /*
    Only avaiable for 1FN3300 & 1FN3450
    
    Has to be ordered with 4 units.
    */

  if (oData && !isEmpty(oData)) {
    SetSecSectionType(oData);
    SetHeatsinkProfiles(oData);
    SetCover(oData);
    SetSafetyMatFlux(oData);
  } else {
    ExecSetStandardifValueEmpty("A_SEC_SECTION_TYPE_1FN3", "STD"); // Standard
    ExecSetStandardifValueEmpty("A_HEATSINK_PROFILE_1FN3", "NON"); // NON
    ExecSetStandardifValueEmpty("A_COVER_1FN3", "NON"); // NON
    //ECL_DeselectAttribute("A_SAFETY_MAT_FLUX_1FN3");
  }
  return oData;
}

/**

*/
function SetSecSectionType(oData) {
  var MLFB_01_07_1FN3 = oData.oParsingData.MLFB_01_07_1FN3;
  var ECSI_CX_SecondarySectionType = ECL_GetValue("ECSI_CX_SecondarySectionType");

  if (ECSI_CX_SecondarySectionType == "StandardAnd1StandardExtended" || ECSI_CX_SecondarySectionType == "1") {
    // check, if available:
    // MLFB_01_07_1FN3	A_SEC_SECTION_TYPE_1FN3	HMK_VALUE_VALID_1FN3
    var sTable = "VT_SEC_SECTION_TYPE_1FN3" + sDB_Suffix;
    var sSQL =
      "SELECT DISTINCT A_SEC_SECTION_TYPE_1FN3 FROM " +
      sTable +
      " WHERE " +
      "MLFB_01_07_1FN3 = '" +
      MLFB_01_07_1FN3 +
      "' AND " +
      "A_SEC_SECTION_TYPE_1FN3 = 'EXT' AND " +
      "HMK_VALUE_VALID_1FN3 = 'T';";
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      ECL_DeactivateValue("A_SEC_SECTION_TYPE_1FN3", "STD");
      ECL_ActivateValue("A_SEC_SECTION_TYPE_1FN3", "EXT");
      ECL_SelectValue("A_SEC_SECTION_TYPE_1FN3", "EXT");
    } else {
      ECL_DeactivateValue("A_SEC_SECTION_TYPE_1FN3", "EXT");
      ECL_ActivateValue("A_SEC_SECTION_TYPE_1FN3", "STD");
      ECL_SelectValue("A_SEC_SECTION_TYPE_1FN3", "STD");
      // Error
      oData.strError += " " + ECL_Translate("DICT1_ERR_1FN3___PARSER_SET_SEC_SECTION_TYPE");
    }
  } else {
    ECL_DeactivateValue("A_SEC_SECTION_TYPE_1FN3", "EXT");
    ECL_ActivateValue("A_SEC_SECTION_TYPE_1FN3", "STD");
    ECL_SelectValue("A_SEC_SECTION_TYPE_1FN3", "STD");
  }
  /*
    var MLFB_RUMPF_PRI_1FN3 = oData.oParsingData.MLFB_RUMPF_PRI_1FN3;
    var MLFB_01_07_1FN3 = oData.oParsingData.MLFB_01_07_1FN3;
    var MLFB10_1FN3 = oData.oParsingData.MLFB.MLFB10;
    var MLFB11_1FN3 = oData.oParsingData.MLFB.MLFB11;
    var MLFB14_1FN3 = oData.oParsingData.MLFB.MLFB14;
    
    var ECSI_MLFB_SEC = GetMlfbSec() || "";
    
    // VT_SEC_SECTION_TYPE_1FN3
    // MLFB_01_07_1FN3	MLFB08_1FN3	A_MOUNT_HALL_SENSOR_1FN3	A_CABLE_OUTLET_HALL_SENSOR_1FN3	MLFB_HALL_SENSOR_1FN3	HMK_VALUE_VALID_1FN3
    var sTable = "VT_SEC_SECTION_TYPE_1FN3" + sDB_Suffix;
    var sSQL = "SELECT DISTINCT A_SEC_SECTION_TYPE_1FN3 FROM " + sTable + " WHERE " +
                "MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
                "HMK_VALUE_VALID_1FN3 = 'T';";
    
    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0){
        var bEXT = false;
        for (var i=0; i<aResult.length;i++){
            if (aResult[i].A_SEC_SECTION_TYPE_1FN3 == "EXT"){
                bEXT = true;
                break;
            }
        }
        
        if (bEXT){
            // VT_PRIM_SEK_PARTS_MAP_1FN3
            //	MLFB_RUMPF_PRI_1FN3	MLFB10_1FN3	MLFB11_1FN3	MLFB14_1FN3	MLFB_SEK_STD_1FN3	MLFB_SEK_EXT_1FN3	HMK_VALUE_VALID_1FN3
            var sTable = "VT_PRIM_SEK_PARTS_MAP_1FN3" + sDB_Suffix;
            var sSQL = "SELECT DISTINCT MLFB_SEK_EXT_1FN3 FROM " + sTable + " WHERE " +
                        "MLFB_RUMPF_PRI_1FN3 = '" + MLFB_RUMPF_PRI_1FN3 + "' AND " +
                        "MLFB10_1FN3 = '" + MLFB10_1FN3 + "' AND " +
                        "MLFB11_1FN3 = '" + MLFB11_1FN3 + "' AND " +
                        "MLFB14_1FN3 = '" + MLFB14_1FN3 + "' AND " +
                        "MLFB_SEK_EXT_1FN3 <> 'NON' AND " +
                        "HMK_VALUE_VALID_1FN3 = 'T';";
            
            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0){
                for (var i=0; i<aResult.length;i++){
                    var MLFB_SEK_EXT_1FN3 = aResult[i].MLFB_SEK_EXT_1FN3;
                    
                    if (ECSI_MLFB_SEC.indexOf(MLFB_SEK_EXT_1FN3) > -1){
                        ECL_ActivateValue("A_SEC_SECTION_TYPE_1FN3", "EXT");
                        ECL_SelectValue("A_SEC_SECTION_TYPE_1FN3", "EXT");
                        return;
                    }
                }
            }
        }
        
        // else todo, eigentlich nicht nötig
        // VT_PRIM_SEK_PARTS_MAP_1FN3
        //	MLFB_RUMPF_PRI_1FN3	MLFB10_1FN3	MLFB11_1FN3	MLFB14_1FN3	MLFB_SEK_STD_1FN3	MLFB_SEK_EXT_1FN3	HMK_VALUE_VALID_1FN3
        /*var sTable = "VT_PRIM_SEK_PARTS_MAP_1FN3" + sDB_Suffix;
        var sSQL = "SELECT DISTINCT MLFB_SEK_STD_1FN3 FROM " + sTable + " WHERE " +
                    "MLFB_RUMPF_PRI_1FN3 = '" + MLFB_RUMPF_PRI_1FN3 + "' AND " +
                    "MLFB10_1FN3 = '" + MLFB10_1FN3 + "' AND " +
                    "MLFB11_1FN3 = '" + MLFB11_1FN3 + "' AND " +
                    "MLFB14_1FN3 = '" + MLFB14_1FN3 + "' AND " +
                    "HMK_VALUE_VALID_1FN3 = 'T';";
        
        var aResult = GetDBDataSetEXT(sSQL);
        if (aResult.length > 0){
            for (var i=0; i<aResult.length;i++){
                var MLFB_SEK_STD_1FN3 = aResult[i].MLFB_SEK_STD_1FN3;
                
                if (ECSI_MLFB_SEC.indexOf(MLFB_SEK_STD_1FN3) > -1){
                    ECL_ActivateValue("A_SEC_SECTION_TYPE_1FN3", "STD");
                    ECL_SelectValue("A_SEC_SECTION_TYPE_1FN3", "STD");
                    return;
                }
            }
        }else{
            oData.strError += " " + ECL_Translate("DICT1_ERR_1FN3___PARSER_SET_SEC_SECTION_TYPE");
            return;
        }
        */
  /*		ECL_ActivateValue("A_SEC_SECTION_TYPE_1FN3", "STD");
        ECL_SelectValue("A_SEC_SECTION_TYPE_1FN3", "STD");
        
    }else{
        // Error
        oData.strError += " " + ECL_Translate("DICT1_ERR_1FN3___PARSER_SET_SEC_SECTION_TYPE");
    }
*/
}

/*
ECSI_CX_HeatsinkProfiles True/false

A_HEATSINK_PROFILE_1FN3	Kühlkörperprofil

NON			Ohne
PARALLEL	Paralleler Wasseranschluss			mandatory for 1FN3600 & 1FN3900:
SINGLE		Einseitiger Wasseranschluss
*/
function SetHeatsinkProfiles(oData) {
  var ECSI_MLFB_SEC = GetMlfbSec() || "";
  var MLFB_01_07_1FN3 = oData.oParsingData.MLFB_01_07_1FN3;

  // for 1FN3600 & 1FN3900 "PARALLEL" is mandatory
  if (MLFB_01_07_1FN3 == "1FN3600" || MLFB_01_07_1FN3 == "1FN3900") {
    ECL_DeactivateAllAttributeValues("A_HEATSINK_PROFILE_1FN3");
    ECL_ActivateValue("A_HEATSINK_PROFILE_1FN3", "PARALLEL");
    ECL_SelectValue("A_HEATSINK_PROFILE_1FN3", "PARALLEL");
  } else {
    ECL_ActivateAllAttributeValues("A_HEATSINK_PROFILE_1FN3");

    // check context-parameter for heatsink
    var ECSI_CX_HeatsinkProfiles = ECL_GetValue("ECSI_CX_HeatsinkProfiles");

    if (ECSI_CX_HeatsinkProfiles == "true" || ECSI_CX_HeatsinkProfiles == "1") {
      ECL_DeactivateValue("A_HEATSINK_PROFILE_1FN3", "NON");
    } else {
      ECL_ActivateValue("A_HEATSINK_PROFILE_1FN3", "NON");
    }

    /*if (ECL_GetValue("A_SEC_SECTION_TYPE_1FN3") == "EXT"){					// todo half-length is now possible für BG 300 & 450
            ECL_DeactivateAllAttributeValues("A_HEATSINK_PROFILE_1FN3");
        ECL_ActivateValue("A_HEATSINK_PROFILE_1FN3", "NON");
        ECL_SelectValue("A_HEATSINK_PROFILE_1FN3", "NON");
        }else{
            ECL_ActivateAllAttributeValues("A_HEATSINK_PROFILE_1FN3");
        */

    // parallel or single?

    var bValueFound = false;

    // get MLFB list for parralel (MLFB_COMBI_DIST_1FN3)
    var sTable = "VT_HEATSINK_1FN3";
    var sSQL =
      "SELECT DISTINCT MLFB_COMBI_DIST_1FN3 FROM " +
      sTable +
      " WHERE " +
      //"MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
      "HMK_VALUE_VALID_1FN3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      for (var i = 0; i < aResult.length; i++) {
        var MLFB_COMBI_DIST_1FN3 = aResult[i].MLFB_COMBI_DIST_1FN3;
        if (ECSI_MLFB_SEC.indexOf(MLFB_COMBI_DIST_1FN3) > -1) {
          ECL_SelectValue("A_HEATSINK_PROFILE_1FN3", "PARALLEL");
          bValueFound = true;
          break;
        }
      }
    } else {
      oData.strError += " " + ECL_Translate("DICT1_ERR_1FN3___PARSER_HEATSINK_DB");
      return;
    }

    if (!bValueFound) {
      // get MLFB list for single (MLFB_COMBI_ADAPTER_1FN3)
      var sTable = "VT_HEATSINK_1FN3";
      var sSQL =
        "SELECT DISTINCT MLFB_COMBI_ADAPTER_1FN3 FROM " +
        sTable +
        " WHERE " +
        //"MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
        "MLFB_COMBI_ADAPTER_1FN3 <> 'NON' AND " +
        "HMK_VALUE_VALID_1FN3 = 'T';";

      var aResult = GetDBDataSetEXT(sSQL);
      if (aResult.length > 0) {
        for (var i = 0; i < aResult.length; i++) {
          var MLFB_COMBI_ADAPTER_1FN3 = aResult[i].MLFB_COMBI_ADAPTER_1FN3;
          if (ECSI_MLFB_SEC.indexOf(MLFB_COMBI_ADAPTER_1FN3) > -1) {
            // Keep configuration
            var sSQL =
              "SELECT DISTINCT MLFB_COMBI_ADAPTER_1FN3 FROM " +
              sTable +
              " WHERE " +
              "MLFB_01_07_1FN3 = '" +
              MLFB_01_07_1FN3 +
              "' AND " +
              "MLFB_COMBI_ADAPTER_1FN3 <> 'NON' AND " +
              "HMK_VALUE_VALID_1FN3 = 'T';";

            var aResult = GetDBDataSetEXT(sSQL);
            if (aResult.length > 0) {
              //
              ECL_SelectValue("A_HEATSINK_PROFILE_1FN3", "SINGLE");
              bValueFound = true;
              break;
            }
          }
        }
      } else {
        oData.strError += " " + ECL_Translate("DICT1_ERR_1FN3___PARSER_HEATSINK_DB");
        return;
      }
    }
    if (!bValueFound) {
      if (ECSI_CX_HeatsinkProfiles == "true" || ECSI_CX_HeatsinkProfiles == "1") {
        ECL_SelectValue("A_HEATSINK_PROFILE_1FN3", "SINGLE");
      } else {
        ECL_SelectValue("A_HEATSINK_PROFILE_1FN3", "NON");
      }
    }
  }
}

/*
A_COVER_1FN3	Abdeckung

NON	Ohne
CON	Koninuierlich
SEG	Segmentiert

*/
function SetCover(oData) {
  var MLFB_01_07_1FN3 = oData.oParsingData.MLFB_01_07_1FN3;
  var ECSI_MLFB_SEC = GetMlfbSec() || "";

  var A_SEC_SECTION_TYPE_1FN3 = ECL_GetValue("A_SEC_SECTION_TYPE_1FN3");

  var ECSI_CX_SecondarySectionCount = ECL_GetValue("ECSI_CX_SecondarySectionCount");
  ECSI_CX_SecondarySectionCount = ECSI_CX_SecondarySectionCount.replace(",", ".");
  ECSI_CX_SecondarySectionCount = parseFloat(ECSI_CX_SecondarySectionCount);

  ECL_ActivateAllAttributeValues("A_COVER_1FN3");
  var A_COVER_1FN3 = "NON";

  // MLFB_01_07_1FN3	MLFB_COVER_CONTINUOUS_1FN3	MLFB_COVER_SEGMENTED_1FN3	MLFB_COVER_END_PART_1FN3	MLFB_SAFETY_MAT_1FN3	HMK_VALUE_VALID_1FN3
  var sTable = "VT_COVER_MAPPING_1FN3";
  var sSQL =
    "SELECT * FROM " +
    sTable +
    " WHERE " +
    //"MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
    "HMK_VALUE_VALID_1FN3 = 'T';";

  var aResult = GetDBDataSetEXT(sSQL);
  if (aResult.length > 0) {
    for (var i = 0; i < aResult.length; i++) {
      var MLFB_COVER_CONTINUOUS_1FN3 = aResult[i].MLFB_COVER_CONTINUOUS_1FN3;
      MLFB_COVER_CONTINUOUS_1FN3 = MLFB_COVER_CONTINUOUS_1FN3.left(13);

      var MLFB_COVER_SEGMENTED_1FN3 = aResult[i].MLFB_COVER_SEGMENTED_1FN3;
      MLFB_COVER_SEGMENTED_1FN3 = MLFB_COVER_SEGMENTED_1FN3.left(14);

      // no continuous cover for extended type
      // Check for cover continuous:
      if (A_SEC_SECTION_TYPE_1FN3 !== "EXT" && ECSI_MLFB_SEC.indexOf(MLFB_COVER_CONTINUOUS_1FN3) > -1 && ECSI_CX_SecondarySectionCount <= 50) {
        A_COVER_1FN3 = "CON";
        break;
      } else if (ECSI_MLFB_SEC.indexOf(MLFB_COVER_SEGMENTED_1FN3) > -1) {
        // Check for cover segmented:
        A_COVER_1FN3 = "SEG";
        break;
      }
    }
  } else {
    oData.strError += " " + ECL_Translate("DICT1_ERR_1FN3___PARSER_COVER_DB");
    return;
  }

  var IsStartConfiguration = parseInt(ECL_GetValue("ECSI_IS_START_CONFIGURATION"));
  var ECSI_CX_CoolingMethodMotor = ECL_GetValue("ECSI_CX_CoolingMethodMotor");
  var MLFB09_1FN3 = oData.oParsingData.MLFB.MLFB09;

  // set default value if IsStartConfiguration && IsStartConfiguration == 1 && BaseType == MLFB && MLFB_SEC == ""
  if (IsStartConfiguration && IsStartConfiguration == 1 && A_COVER_1FN3 == "NON" && ECSI_MLFB_SEC == "") {
    // Edit 06.2023: 51418 - Natural cooled linear motors should get “no cover” as default
    if (MLFB09_1FN3 == "K" || ECSI_CX_CoolingMethodMotor !== "2") {
      A_COVER_1FN3 = "NON";
      ECL_SelectValueDefault("A_COVER_1FN3", "NON");
    } else {
      if (
        A_SEC_SECTION_TYPE_1FN3 == "STD" &&
        (((MLFB_01_07_1FN3 == "1FN3300" || MLFB_01_07_1FN3 == "1FN3450" || MLFB_01_07_1FN3 == "1FN3600" || MLFB_01_07_1FN3 == "1FN3900") &&
          ECSI_CX_SecondarySectionCount <= 32) ||
          ((MLFB_01_07_1FN3 == "1FN3050" || MLFB_01_07_1FN3 == "1FN3100" || MLFB_01_07_1FN3 == "1FN3150") && ECSI_CX_SecondarySectionCount <= 50))
      ) {
        A_COVER_1FN3 = "CON";
        ECL_SelectValueDefault("A_COVER_1FN3", "CON");
      } else {
        A_COVER_1FN3 = "SEG";
        ECL_DeactivateValue("A_COVER_1FN3", "CON");
        ECL_SelectValueDefault("A_COVER_1FN3", "SEG");
      }
    }
  }
  ECL_ActivateValue("A_COVER_1FN3", A_COVER_1FN3);
  ECL_SelectValue("A_COVER_1FN3", A_COVER_1FN3);
}

/*
 */
function SetSafetyMatFlux(oData) {
  // ################################################################################################################
  // Bestellpaket mit 4 Einheiten		A_SAFETY_MAT_FLUX_1FN3
  // ################################################################################################################
  /*
    Only avaiable for 1FN3300 & 1FN3450
    
    Has to be ordered with 4 units.
    */

  var MLFB_01_07_1FN3 = oData.oParsingData.MLFB_01_07_1FN3;
  var ECSI_MLFB_SEC = GetMlfbSec() || "";

  ECL_DeselectAttribute("A_SAFETY_MAT_FLUX_1FN3");

  if (MLFB_01_07_1FN3 == "1FN3300" || MLFB_01_07_1FN3 == "1FN3450") {
    ECL_EnableAttribute("A_SAFETY_MAT_FLUX_1FN3");

    // if MLFB in MLFB_SEC, set

    // MLFB_01_07_1FN3	MLFB_COVER_CONTINUOUS_1FN3	MLFB_COVER_SEGMENTED_1FN3	MLFB_COVER_END_PART_1FN3	MLFB_SAFETY_MAT_1FN3	HMK_VALUE_VALID_1FN3
    var sTable = "VT_COVER_MAPPING_1FN3";
    var sSQL =
      "SELECT MLFB_SAFETY_MAT_1FN3 FROM " +
      sTable +
      " WHERE " +
      //"MLFB_01_07_1FN3 = '" + MLFB_01_07_1FN3 + "' AND " +
      "MLFB_SAFETY_MAT_1FN3 <> 'NON' AND " +
      "HMK_VALUE_VALID_1FN3 = 'T';";

    var aResult = GetDBDataSetEXT(sSQL);
    if (aResult.length > 0) {
      for (var i = 0; i < aResult.length; i++) {
        var MLFB_SAFETY_MAT_1FN3 = aResult[i].MLFB_SAFETY_MAT_1FN3;
        if (ECSI_MLFB_SEC.indexOf(MLFB_SAFETY_MAT_1FN3) > -1) {
          ECL_SelectValue("A_SAFETY_MAT_FLUX_1FN3", "T");
          break;
        }
      }
    } else {
      oData.strError += " " + ECL_Translate("DICT1_ERR_1FN3___PARSER_SAFETY_MAT_FLUX_DB");
      return;
    }
  }
}
